# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BackupPlanAdvancedBackupSettingResourceType',
    'BackupPlanBackupRuleResourceType',
    'BackupPlanCopyActionResourceType',
    'BackupPlanIndexActionsResourceType',
    'BackupPlanLifecycleResourceType',
    'BackupPlanResourceType',
    'BackupSelectionConditionParameter',
    'BackupSelectionConditionResourceType',
    'BackupSelectionResourceType',
    'BackupSelectionResourceTypeConditionsProperties',
    'BackupVaultLockConfigurationType',
    'BackupVaultNotificationObjectType',
    'FrameworkControl',
    'FrameworkControlControlScopeProperties',
    'FrameworkControlInputParameter',
    'FrameworkTag',
    'LogicallyAirGappedBackupVaultNotificationObjectType',
    'ReportDeliveryChannelProperties',
    'ReportSettingProperties',
    'RestoreTestingPlanRestoreTestingRecoveryPointSelection',
    'RestoreTestingSelectionKeyValue',
    'RestoreTestingSelectionProtectedResourceConditions',
]

@pulumi.output_type
class BackupPlanAdvancedBackupSettingResourceType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupOptions":
            suggest = "backup_options"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanAdvancedBackupSettingResourceType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanAdvancedBackupSettingResourceType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanAdvancedBackupSettingResourceType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_options: Any,
                 resource_type: builtins.str):
        """
        :param Any backup_options: The backup option for the resource. Each option is a key-value pair. This option is only available for Windows VSS backup jobs.
               
               Valid values:
               
               Set to `"WindowsVSS":"enabled"` to enable the `WindowsVSS` backup option and create a Windows VSS backup.
               
               Set to `"WindowsVSS":"disabled"` to create a regular backup. The `WindowsVSS` option is not enabled by default.
               
               If you specify an invalid option, you get an `InvalidParameterValueException` exception.
               
               For more information about Windows VSS backups, see [Creating a VSS-Enabled Windows Backup](https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html) .
        :param builtins.str resource_type: The name of a resource type. The only supported resource type is EC2.
        """
        pulumi.set(__self__, "backup_options", backup_options)
        pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter(name="backupOptions")
    def backup_options(self) -> Any:
        """
        The backup option for the resource. Each option is a key-value pair. This option is only available for Windows VSS backup jobs.

        Valid values:

        Set to `"WindowsVSS":"enabled"` to enable the `WindowsVSS` backup option and create a Windows VSS backup.

        Set to `"WindowsVSS":"disabled"` to create a regular backup. The `WindowsVSS` option is not enabled by default.

        If you specify an invalid option, you get an `InvalidParameterValueException` exception.

        For more information about Windows VSS backups, see [Creating a VSS-Enabled Windows Backup](https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html) .
        """
        return pulumi.get(self, "backup_options")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        The name of a resource type. The only supported resource type is EC2.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class BackupPlanBackupRuleResourceType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleName":
            suggest = "rule_name"
        elif key == "targetBackupVault":
            suggest = "target_backup_vault"
        elif key == "completionWindowMinutes":
            suggest = "completion_window_minutes"
        elif key == "copyActions":
            suggest = "copy_actions"
        elif key == "enableContinuousBackup":
            suggest = "enable_continuous_backup"
        elif key == "indexActions":
            suggest = "index_actions"
        elif key == "recoveryPointTags":
            suggest = "recovery_point_tags"
        elif key == "scheduleExpression":
            suggest = "schedule_expression"
        elif key == "scheduleExpressionTimezone":
            suggest = "schedule_expression_timezone"
        elif key == "startWindowMinutes":
            suggest = "start_window_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupRuleResourceType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupRuleResourceType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupRuleResourceType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_name: builtins.str,
                 target_backup_vault: builtins.str,
                 completion_window_minutes: Optional[builtins.float] = None,
                 copy_actions: Optional[Sequence['outputs.BackupPlanCopyActionResourceType']] = None,
                 enable_continuous_backup: Optional[builtins.bool] = None,
                 index_actions: Optional[Sequence['outputs.BackupPlanIndexActionsResourceType']] = None,
                 lifecycle: Optional['outputs.BackupPlanLifecycleResourceType'] = None,
                 recovery_point_tags: Optional[Mapping[str, builtins.str]] = None,
                 schedule_expression: Optional[builtins.str] = None,
                 schedule_expression_timezone: Optional[builtins.str] = None,
                 start_window_minutes: Optional[builtins.float] = None):
        """
        :param builtins.str rule_name: A display name for a backup rule.
        :param builtins.str target_backup_vault: The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of letters, numbers, and hyphens.
        :param builtins.float completion_window_minutes: A value in minutes after a backup job is successfully started before it must be completed or it is canceled by AWS Backup .
        :param Sequence['BackupPlanCopyActionResourceType'] copy_actions: An array of CopyAction objects, which contains the details of the copy operation.
        :param builtins.bool enable_continuous_backup: Enables continuous backup and point-in-time restores (PITR).
        :param Sequence['BackupPlanIndexActionsResourceType'] index_actions: There can up to one IndexAction in each BackupRule, as each backup can have 0 or 1 backup index associated with it.
               
               Within the array is ResourceTypes. Only 1 resource type will be accepted for each BackupRule. Valid values:
               
               - `EBS` for Amazon Elastic Block Store
               - `S3` for Amazon Simple Storage Service (Amazon S3)
        :param 'BackupPlanLifecycleResourceType' lifecycle: The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup transitions and expires backups automatically according to the lifecycle that you define.
        :param Mapping[str, builtins.str] recovery_point_tags: The tags to assign to the resources.
        :param builtins.str schedule_expression: A CRON expression specifying when AWS Backup initiates a backup job.
        :param builtins.str schedule_expression_timezone: This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
        :param builtins.float start_window_minutes: An optional value that specifies a period of time in minutes after a backup is scheduled before a job is canceled if it doesn't start successfully.
               
               If this value is included, it must be at least 60 minutes to avoid errors.
        """
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "target_backup_vault", target_backup_vault)
        if completion_window_minutes is not None:
            pulumi.set(__self__, "completion_window_minutes", completion_window_minutes)
        if copy_actions is not None:
            pulumi.set(__self__, "copy_actions", copy_actions)
        if enable_continuous_backup is not None:
            pulumi.set(__self__, "enable_continuous_backup", enable_continuous_backup)
        if index_actions is not None:
            pulumi.set(__self__, "index_actions", index_actions)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)
        if recovery_point_tags is not None:
            pulumi.set(__self__, "recovery_point_tags", recovery_point_tags)
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)
        if schedule_expression_timezone is not None:
            pulumi.set(__self__, "schedule_expression_timezone", schedule_expression_timezone)
        if start_window_minutes is not None:
            pulumi.set(__self__, "start_window_minutes", start_window_minutes)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> builtins.str:
        """
        A display name for a backup rule.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="targetBackupVault")
    def target_backup_vault(self) -> builtins.str:
        """
        The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of letters, numbers, and hyphens.
        """
        return pulumi.get(self, "target_backup_vault")

    @property
    @pulumi.getter(name="completionWindowMinutes")
    def completion_window_minutes(self) -> Optional[builtins.float]:
        """
        A value in minutes after a backup job is successfully started before it must be completed or it is canceled by AWS Backup .
        """
        return pulumi.get(self, "completion_window_minutes")

    @property
    @pulumi.getter(name="copyActions")
    def copy_actions(self) -> Optional[Sequence['outputs.BackupPlanCopyActionResourceType']]:
        """
        An array of CopyAction objects, which contains the details of the copy operation.
        """
        return pulumi.get(self, "copy_actions")

    @property
    @pulumi.getter(name="enableContinuousBackup")
    def enable_continuous_backup(self) -> Optional[builtins.bool]:
        """
        Enables continuous backup and point-in-time restores (PITR).
        """
        return pulumi.get(self, "enable_continuous_backup")

    @property
    @pulumi.getter(name="indexActions")
    def index_actions(self) -> Optional[Sequence['outputs.BackupPlanIndexActionsResourceType']]:
        """
        There can up to one IndexAction in each BackupRule, as each backup can have 0 or 1 backup index associated with it.

        Within the array is ResourceTypes. Only 1 resource type will be accepted for each BackupRule. Valid values:

        - `EBS` for Amazon Elastic Block Store
        - `S3` for Amazon Simple Storage Service (Amazon S3)
        """
        return pulumi.get(self, "index_actions")

    @property
    @pulumi.getter
    def lifecycle(self) -> Optional['outputs.BackupPlanLifecycleResourceType']:
        """
        The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup transitions and expires backups automatically according to the lifecycle that you define.
        """
        return pulumi.get(self, "lifecycle")

    @property
    @pulumi.getter(name="recoveryPointTags")
    def recovery_point_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The tags to assign to the resources.
        """
        return pulumi.get(self, "recovery_point_tags")

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[builtins.str]:
        """
        A CRON expression specifying when AWS Backup initiates a backup job.
        """
        return pulumi.get(self, "schedule_expression")

    @property
    @pulumi.getter(name="scheduleExpressionTimezone")
    def schedule_expression_timezone(self) -> Optional[builtins.str]:
        """
        This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
        """
        return pulumi.get(self, "schedule_expression_timezone")

    @property
    @pulumi.getter(name="startWindowMinutes")
    def start_window_minutes(self) -> Optional[builtins.float]:
        """
        An optional value that specifies a period of time in minutes after a backup is scheduled before a job is canceled if it doesn't start successfully.

        If this value is included, it must be at least 60 minutes to avoid errors.
        """
        return pulumi.get(self, "start_window_minutes")


@pulumi.output_type
class BackupPlanCopyActionResourceType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationBackupVaultArn":
            suggest = "destination_backup_vault_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanCopyActionResourceType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanCopyActionResourceType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanCopyActionResourceType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_backup_vault_arn: builtins.str,
                 lifecycle: Optional['outputs.BackupPlanLifecycleResourceType'] = None):
        """
        :param builtins.str destination_backup_vault_arn: An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup. For example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.`
        :param 'BackupPlanLifecycleResourceType' lifecycle: Defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup transitions and expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle, AWS Backup applies the lifecycle policy of the source backup to the destination backup.
               
               Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
        """
        pulumi.set(__self__, "destination_backup_vault_arn", destination_backup_vault_arn)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)

    @property
    @pulumi.getter(name="destinationBackupVaultArn")
    def destination_backup_vault_arn(self) -> builtins.str:
        """
        An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup. For example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.`
        """
        return pulumi.get(self, "destination_backup_vault_arn")

    @property
    @pulumi.getter
    def lifecycle(self) -> Optional['outputs.BackupPlanLifecycleResourceType']:
        """
        Defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup transitions and expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle, AWS Backup applies the lifecycle policy of the source backup to the destination backup.

        Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
        """
        return pulumi.get(self, "lifecycle")


@pulumi.output_type
class BackupPlanIndexActionsResourceType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceTypes":
            suggest = "resource_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanIndexActionsResourceType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanIndexActionsResourceType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanIndexActionsResourceType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_types: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] resource_types: 0 or 1 index action will be accepted for each BackupRule.
               
               Valid values:
               
               - `EBS` for Amazon Elastic Block Store
               - `S3` for Amazon Simple Storage Service (Amazon S3)
        """
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[Sequence[builtins.str]]:
        """
        0 or 1 index action will be accepted for each BackupRule.

        Valid values:

        - `EBS` for Amazon Elastic Block Store
        - `S3` for Amazon Simple Storage Service (Amazon S3)
        """
        return pulumi.get(self, "resource_types")


@pulumi.output_type
class BackupPlanLifecycleResourceType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteAfterDays":
            suggest = "delete_after_days"
        elif key == "moveToColdStorageAfterDays":
            suggest = "move_to_cold_storage_after_days"
        elif key == "optInToArchiveForSupportedResources":
            suggest = "opt_in_to_archive_for_supported_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanLifecycleResourceType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanLifecycleResourceType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanLifecycleResourceType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_after_days: Optional[builtins.float] = None,
                 move_to_cold_storage_after_days: Optional[builtins.float] = None,
                 opt_in_to_archive_for_supported_resources: Optional[builtins.bool] = None):
        """
        :param builtins.float delete_after_days: The number of days after creation that a recovery point is deleted. This value must be at least 90 days after the number of days specified in `MoveToColdStorageAfterDays` .
        :param builtins.float move_to_cold_storage_after_days: The number of days after creation that a recovery point is moved to cold storage.
        :param builtins.bool opt_in_to_archive_for_supported_resources: If the value is true, your backup plan transitions supported resources to archive (cold) storage tier in accordance with your lifecycle settings.
        """
        if delete_after_days is not None:
            pulumi.set(__self__, "delete_after_days", delete_after_days)
        if move_to_cold_storage_after_days is not None:
            pulumi.set(__self__, "move_to_cold_storage_after_days", move_to_cold_storage_after_days)
        if opt_in_to_archive_for_supported_resources is not None:
            pulumi.set(__self__, "opt_in_to_archive_for_supported_resources", opt_in_to_archive_for_supported_resources)

    @property
    @pulumi.getter(name="deleteAfterDays")
    def delete_after_days(self) -> Optional[builtins.float]:
        """
        The number of days after creation that a recovery point is deleted. This value must be at least 90 days after the number of days specified in `MoveToColdStorageAfterDays` .
        """
        return pulumi.get(self, "delete_after_days")

    @property
    @pulumi.getter(name="moveToColdStorageAfterDays")
    def move_to_cold_storage_after_days(self) -> Optional[builtins.float]:
        """
        The number of days after creation that a recovery point is moved to cold storage.
        """
        return pulumi.get(self, "move_to_cold_storage_after_days")

    @property
    @pulumi.getter(name="optInToArchiveForSupportedResources")
    def opt_in_to_archive_for_supported_resources(self) -> Optional[builtins.bool]:
        """
        If the value is true, your backup plan transitions supported resources to archive (cold) storage tier in accordance with your lifecycle settings.
        """
        return pulumi.get(self, "opt_in_to_archive_for_supported_resources")


@pulumi.output_type
class BackupPlanResourceType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupPlanName":
            suggest = "backup_plan_name"
        elif key == "backupPlanRule":
            suggest = "backup_plan_rule"
        elif key == "advancedBackupSettings":
            suggest = "advanced_backup_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanResourceType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanResourceType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanResourceType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_plan_name: builtins.str,
                 backup_plan_rule: Sequence['outputs.BackupPlanBackupRuleResourceType'],
                 advanced_backup_settings: Optional[Sequence['outputs.BackupPlanAdvancedBackupSettingResourceType']] = None):
        """
        :param builtins.str backup_plan_name: The display name of a backup plan.
        :param Sequence['BackupPlanBackupRuleResourceType'] backup_plan_rule: An array of `BackupRule` objects, each of which specifies a scheduled task that is used to back up a selection of resources.
        :param Sequence['BackupPlanAdvancedBackupSettingResourceType'] advanced_backup_settings: A list of backup options for each resource type.
        """
        pulumi.set(__self__, "backup_plan_name", backup_plan_name)
        pulumi.set(__self__, "backup_plan_rule", backup_plan_rule)
        if advanced_backup_settings is not None:
            pulumi.set(__self__, "advanced_backup_settings", advanced_backup_settings)

    @property
    @pulumi.getter(name="backupPlanName")
    def backup_plan_name(self) -> builtins.str:
        """
        The display name of a backup plan.
        """
        return pulumi.get(self, "backup_plan_name")

    @property
    @pulumi.getter(name="backupPlanRule")
    def backup_plan_rule(self) -> Sequence['outputs.BackupPlanBackupRuleResourceType']:
        """
        An array of `BackupRule` objects, each of which specifies a scheduled task that is used to back up a selection of resources.
        """
        return pulumi.get(self, "backup_plan_rule")

    @property
    @pulumi.getter(name="advancedBackupSettings")
    def advanced_backup_settings(self) -> Optional[Sequence['outputs.BackupPlanAdvancedBackupSettingResourceType']]:
        """
        A list of backup options for each resource type.
        """
        return pulumi.get(self, "advanced_backup_settings")


@pulumi.output_type
class BackupSelectionConditionParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conditionKey":
            suggest = "condition_key"
        elif key == "conditionValue":
            suggest = "condition_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupSelectionConditionParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupSelectionConditionParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupSelectionConditionParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition_key: Optional[builtins.str] = None,
                 condition_value: Optional[builtins.str] = None):
        """
        :param builtins.str condition_key: The key in a key-value pair. For example, in the tag `Department: Accounting` , `Department` is the key.
        :param builtins.str condition_value: The value in a key-value pair. For example, in the tag `Department: Accounting` , `Accounting` is the value.
        """
        if condition_key is not None:
            pulumi.set(__self__, "condition_key", condition_key)
        if condition_value is not None:
            pulumi.set(__self__, "condition_value", condition_value)

    @property
    @pulumi.getter(name="conditionKey")
    def condition_key(self) -> Optional[builtins.str]:
        """
        The key in a key-value pair. For example, in the tag `Department: Accounting` , `Department` is the key.
        """
        return pulumi.get(self, "condition_key")

    @property
    @pulumi.getter(name="conditionValue")
    def condition_value(self) -> Optional[builtins.str]:
        """
        The value in a key-value pair. For example, in the tag `Department: Accounting` , `Accounting` is the value.
        """
        return pulumi.get(self, "condition_value")


@pulumi.output_type
class BackupSelectionConditionResourceType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conditionKey":
            suggest = "condition_key"
        elif key == "conditionType":
            suggest = "condition_type"
        elif key == "conditionValue":
            suggest = "condition_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupSelectionConditionResourceType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupSelectionConditionResourceType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupSelectionConditionResourceType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition_key: builtins.str,
                 condition_type: builtins.str,
                 condition_value: builtins.str):
        """
        :param builtins.str condition_key: The key in a key-value pair. For example, in `"Department": "accounting"` , `"Department"` is the key.
        :param builtins.str condition_type: An operation, such as `STRINGEQUALS` , that is applied to a key-value pair used to filter resources in a selection.
        :param builtins.str condition_value: The value in a key-value pair. For example, in `"Department": "accounting"` , `"accounting"` is the value.
        """
        pulumi.set(__self__, "condition_key", condition_key)
        pulumi.set(__self__, "condition_type", condition_type)
        pulumi.set(__self__, "condition_value", condition_value)

    @property
    @pulumi.getter(name="conditionKey")
    def condition_key(self) -> builtins.str:
        """
        The key in a key-value pair. For example, in `"Department": "accounting"` , `"Department"` is the key.
        """
        return pulumi.get(self, "condition_key")

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> builtins.str:
        """
        An operation, such as `STRINGEQUALS` , that is applied to a key-value pair used to filter resources in a selection.
        """
        return pulumi.get(self, "condition_type")

    @property
    @pulumi.getter(name="conditionValue")
    def condition_value(self) -> builtins.str:
        """
        The value in a key-value pair. For example, in `"Department": "accounting"` , `"accounting"` is the value.
        """
        return pulumi.get(self, "condition_value")


@pulumi.output_type
class BackupSelectionResourceType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iamRoleArn":
            suggest = "iam_role_arn"
        elif key == "selectionName":
            suggest = "selection_name"
        elif key == "listOfTags":
            suggest = "list_of_tags"
        elif key == "notResources":
            suggest = "not_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupSelectionResourceType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupSelectionResourceType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupSelectionResourceType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iam_role_arn: builtins.str,
                 selection_name: builtins.str,
                 conditions: Optional['outputs.BackupSelectionResourceTypeConditionsProperties'] = None,
                 list_of_tags: Optional[Sequence['outputs.BackupSelectionConditionResourceType']] = None,
                 not_resources: Optional[Sequence[builtins.str]] = None,
                 resources: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str iam_role_arn: The ARN of the IAM role that AWS Backup uses to authenticate when backing up the target resource; for example, `arn:aws:iam::123456789012:role/S3Access` .
        :param builtins.str selection_name: The display name of a resource selection document.
        :param 'BackupSelectionResourceTypeConditionsProperties' conditions: A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": { "ConditionKey": "aws:ResourceTag/CreatedByCryo", "ConditionValue": "true" },` . Condition operators are case sensitive.
               
               `Conditions` differs from `ListOfTags` as follows:
               
               - When you specify more than one condition, you only assign the resources that match ALL conditions (using AND logic).
               - `Conditions` supports `StringEquals` , `StringLike` , `StringNotEquals` , and `StringNotLike` . `ListOfTags` only supports `StringEquals` .
        :param Sequence['BackupSelectionConditionResourceType'] list_of_tags: A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": { "ConditionKey": "aws:ResourceTag/CreatedByCryo", "ConditionValue": "true" },` . Condition operators are case sensitive.
               
               `ListOfTags` differs from `Conditions` as follows:
               
               - When you specify more than one condition, you assign all resources that match AT LEAST ONE condition (using OR logic).
               - `ListOfTags` only supports `StringEquals` . `Conditions` supports `StringEquals` , `StringLike` , `StringNotEquals` , and `StringNotLike` .
        :param Sequence[builtins.str] not_resources: A list of Amazon Resource Names (ARNs) to exclude from a backup plan. The maximum number of ARNs is 500 without wildcards, or 30 ARNs with wildcards.
               
               If you need to exclude many resources from a backup plan, consider a different resource selection strategy, such as assigning only one or a few resource types or refining your resource selection using tags.
        :param Sequence[builtins.str] resources: An array of strings that contain Amazon Resource Names (ARNs) of resources to assign to a backup plan.
        """
        pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        pulumi.set(__self__, "selection_name", selection_name)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if list_of_tags is not None:
            pulumi.set(__self__, "list_of_tags", list_of_tags)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> builtins.str:
        """
        The ARN of the IAM role that AWS Backup uses to authenticate when backing up the target resource; for example, `arn:aws:iam::123456789012:role/S3Access` .
        """
        return pulumi.get(self, "iam_role_arn")

    @property
    @pulumi.getter(name="selectionName")
    def selection_name(self) -> builtins.str:
        """
        The display name of a resource selection document.
        """
        return pulumi.get(self, "selection_name")

    @property
    @pulumi.getter
    def conditions(self) -> Optional['outputs.BackupSelectionResourceTypeConditionsProperties']:
        """
        A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": { "ConditionKey": "aws:ResourceTag/CreatedByCryo", "ConditionValue": "true" },` . Condition operators are case sensitive.

        `Conditions` differs from `ListOfTags` as follows:

        - When you specify more than one condition, you only assign the resources that match ALL conditions (using AND logic).
        - `Conditions` supports `StringEquals` , `StringLike` , `StringNotEquals` , and `StringNotLike` . `ListOfTags` only supports `StringEquals` .
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="listOfTags")
    def list_of_tags(self) -> Optional[Sequence['outputs.BackupSelectionConditionResourceType']]:
        """
        A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": { "ConditionKey": "aws:ResourceTag/CreatedByCryo", "ConditionValue": "true" },` . Condition operators are case sensitive.

        `ListOfTags` differs from `Conditions` as follows:

        - When you specify more than one condition, you assign all resources that match AT LEAST ONE condition (using OR logic).
        - `ListOfTags` only supports `StringEquals` . `Conditions` supports `StringEquals` , `StringLike` , `StringNotEquals` , and `StringNotLike` .
        """
        return pulumi.get(self, "list_of_tags")

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of Amazon Resource Names (ARNs) to exclude from a backup plan. The maximum number of ARNs is 500 without wildcards, or 30 ARNs with wildcards.

        If you need to exclude many resources from a backup plan, consider a different resource selection strategy, such as assigning only one or a few resource types or refining your resource selection using tags.
        """
        return pulumi.get(self, "not_resources")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[builtins.str]]:
        """
        An array of strings that contain Amazon Resource Names (ARNs) of resources to assign to a backup plan.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class BackupSelectionResourceTypeConditionsProperties(dict):
    """
    A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": { "ConditionKey": "aws:ResourceTag/CreatedByCryo", "ConditionValue": "true" },` . Condition operators are case sensitive.

    `Conditions` differs from `ListOfTags` as follows:

    - When you specify more than one condition, you only assign the resources that match ALL conditions (using AND logic).
    - `Conditions` supports `StringEquals` , `StringLike` , `StringNotEquals` , and `StringNotLike` . `ListOfTags` only supports `StringEquals` .
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stringEquals":
            suggest = "string_equals"
        elif key == "stringLike":
            suggest = "string_like"
        elif key == "stringNotEquals":
            suggest = "string_not_equals"
        elif key == "stringNotLike":
            suggest = "string_not_like"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupSelectionResourceTypeConditionsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupSelectionResourceTypeConditionsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupSelectionResourceTypeConditionsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 string_equals: Optional[Sequence['outputs.BackupSelectionConditionParameter']] = None,
                 string_like: Optional[Sequence['outputs.BackupSelectionConditionParameter']] = None,
                 string_not_equals: Optional[Sequence['outputs.BackupSelectionConditionParameter']] = None,
                 string_not_like: Optional[Sequence['outputs.BackupSelectionConditionParameter']] = None):
        """
        A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": { "ConditionKey": "aws:ResourceTag/CreatedByCryo", "ConditionValue": "true" },` . Condition operators are case sensitive.

        `Conditions` differs from `ListOfTags` as follows:

        - When you specify more than one condition, you only assign the resources that match ALL conditions (using AND logic).
        - `Conditions` supports `StringEquals` , `StringLike` , `StringNotEquals` , and `StringNotLike` . `ListOfTags` only supports `StringEquals` .
        """
        if string_equals is not None:
            pulumi.set(__self__, "string_equals", string_equals)
        if string_like is not None:
            pulumi.set(__self__, "string_like", string_like)
        if string_not_equals is not None:
            pulumi.set(__self__, "string_not_equals", string_not_equals)
        if string_not_like is not None:
            pulumi.set(__self__, "string_not_like", string_not_like)

    @property
    @pulumi.getter(name="stringEquals")
    def string_equals(self) -> Optional[Sequence['outputs.BackupSelectionConditionParameter']]:
        return pulumi.get(self, "string_equals")

    @property
    @pulumi.getter(name="stringLike")
    def string_like(self) -> Optional[Sequence['outputs.BackupSelectionConditionParameter']]:
        return pulumi.get(self, "string_like")

    @property
    @pulumi.getter(name="stringNotEquals")
    def string_not_equals(self) -> Optional[Sequence['outputs.BackupSelectionConditionParameter']]:
        return pulumi.get(self, "string_not_equals")

    @property
    @pulumi.getter(name="stringNotLike")
    def string_not_like(self) -> Optional[Sequence['outputs.BackupSelectionConditionParameter']]:
        return pulumi.get(self, "string_not_like")


@pulumi.output_type
class BackupVaultLockConfigurationType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minRetentionDays":
            suggest = "min_retention_days"
        elif key == "changeableForDays":
            suggest = "changeable_for_days"
        elif key == "maxRetentionDays":
            suggest = "max_retention_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupVaultLockConfigurationType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupVaultLockConfigurationType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupVaultLockConfigurationType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_retention_days: builtins.int,
                 changeable_for_days: Optional[builtins.int] = None,
                 max_retention_days: Optional[builtins.int] = None):
        """
        :param builtins.int min_retention_days: The AWS Backup Vault Lock configuration that specifies the minimum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization's policies require you to retain certain data for at least seven years (2555 days).
               
               If this parameter is not specified, Vault Lock will not enforce a minimum retention period.
               
               If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails that backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.
        :param builtins.int changeable_for_days: The AWS Backup Vault Lock configuration that specifies the number of days before the lock date. For example, setting `ChangeableForDays` to 30 on Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.
               
               AWS Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable. Therefore, you must set `ChangeableForDays` to 3 or greater.
               
               Before the lock date, you can delete Vault Lock from the vault using `DeleteBackupVaultLockConfiguration` or change the Vault Lock configuration using `PutBackupVaultLockConfiguration` . On and after the lock date, the Vault Lock becomes immutable and cannot be changed or deleted.
               
               If this parameter is not specified, you can delete Vault Lock from the vault using `DeleteBackupVaultLockConfiguration` or change the Vault Lock configuration using `PutBackupVaultLockConfiguration` at any time.
        :param builtins.int max_retention_days: The AWS Backup Vault Lock configuration that specifies the maximum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization's policies require you to destroy certain data after retaining it for four years (1460 days).
               
               If this parameter is not included, Vault Lock does not enforce a maximum retention period on the recovery points in the vault. If this parameter is included without a value, Vault Lock will not enforce a maximum retention period.
               
               If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.
        """
        pulumi.set(__self__, "min_retention_days", min_retention_days)
        if changeable_for_days is not None:
            pulumi.set(__self__, "changeable_for_days", changeable_for_days)
        if max_retention_days is not None:
            pulumi.set(__self__, "max_retention_days", max_retention_days)

    @property
    @pulumi.getter(name="minRetentionDays")
    def min_retention_days(self) -> builtins.int:
        """
        The AWS Backup Vault Lock configuration that specifies the minimum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization's policies require you to retain certain data for at least seven years (2555 days).

        If this parameter is not specified, Vault Lock will not enforce a minimum retention period.

        If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails that backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.
        """
        return pulumi.get(self, "min_retention_days")

    @property
    @pulumi.getter(name="changeableForDays")
    def changeable_for_days(self) -> Optional[builtins.int]:
        """
        The AWS Backup Vault Lock configuration that specifies the number of days before the lock date. For example, setting `ChangeableForDays` to 30 on Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.

        AWS Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable. Therefore, you must set `ChangeableForDays` to 3 or greater.

        Before the lock date, you can delete Vault Lock from the vault using `DeleteBackupVaultLockConfiguration` or change the Vault Lock configuration using `PutBackupVaultLockConfiguration` . On and after the lock date, the Vault Lock becomes immutable and cannot be changed or deleted.

        If this parameter is not specified, you can delete Vault Lock from the vault using `DeleteBackupVaultLockConfiguration` or change the Vault Lock configuration using `PutBackupVaultLockConfiguration` at any time.
        """
        return pulumi.get(self, "changeable_for_days")

    @property
    @pulumi.getter(name="maxRetentionDays")
    def max_retention_days(self) -> Optional[builtins.int]:
        """
        The AWS Backup Vault Lock configuration that specifies the maximum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization's policies require you to destroy certain data after retaining it for four years (1460 days).

        If this parameter is not included, Vault Lock does not enforce a maximum retention period on the recovery points in the vault. If this parameter is included without a value, Vault Lock will not enforce a maximum retention period.

        If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.
        """
        return pulumi.get(self, "max_retention_days")


@pulumi.output_type
class BackupVaultNotificationObjectType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupVaultEvents":
            suggest = "backup_vault_events"
        elif key == "snsTopicArn":
            suggest = "sns_topic_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupVaultNotificationObjectType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupVaultNotificationObjectType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupVaultNotificationObjectType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_vault_events: Sequence[builtins.str],
                 sns_topic_arn: builtins.str):
        """
        :param Sequence[builtins.str] backup_vault_events: An array of events that indicate the status of jobs to back up resources to the backup vault. For valid events, see [BackupVaultEvents](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultNotifications.html#API_PutBackupVaultNotifications_RequestSyntax) in the *AWS Backup API Guide* .
        :param builtins.str sns_topic_arn: An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example, `arn:aws:sns:us-west-2:111122223333:MyTopic` .
        """
        pulumi.set(__self__, "backup_vault_events", backup_vault_events)
        pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)

    @property
    @pulumi.getter(name="backupVaultEvents")
    def backup_vault_events(self) -> Sequence[builtins.str]:
        """
        An array of events that indicate the status of jobs to back up resources to the backup vault. For valid events, see [BackupVaultEvents](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultNotifications.html#API_PutBackupVaultNotifications_RequestSyntax) in the *AWS Backup API Guide* .
        """
        return pulumi.get(self, "backup_vault_events")

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> builtins.str:
        """
        An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example, `arn:aws:sns:us-west-2:111122223333:MyTopic` .
        """
        return pulumi.get(self, "sns_topic_arn")


@pulumi.output_type
class FrameworkControl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "controlName":
            suggest = "control_name"
        elif key == "controlInputParameters":
            suggest = "control_input_parameters"
        elif key == "controlScope":
            suggest = "control_scope"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrameworkControl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrameworkControl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrameworkControl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 control_name: builtins.str,
                 control_input_parameters: Optional[Sequence['outputs.FrameworkControlInputParameter']] = None,
                 control_scope: Optional['outputs.FrameworkControlControlScopeProperties'] = None):
        """
        :param builtins.str control_name: The name of a control. This name is between 1 and 256 characters.
        :param Sequence['FrameworkControlInputParameter'] control_input_parameters: A list of ParameterName and ParameterValue pairs.
        :param 'FrameworkControlControlScopeProperties' control_scope: The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.
        """
        pulumi.set(__self__, "control_name", control_name)
        if control_input_parameters is not None:
            pulumi.set(__self__, "control_input_parameters", control_input_parameters)
        if control_scope is not None:
            pulumi.set(__self__, "control_scope", control_scope)

    @property
    @pulumi.getter(name="controlName")
    def control_name(self) -> builtins.str:
        """
        The name of a control. This name is between 1 and 256 characters.
        """
        return pulumi.get(self, "control_name")

    @property
    @pulumi.getter(name="controlInputParameters")
    def control_input_parameters(self) -> Optional[Sequence['outputs.FrameworkControlInputParameter']]:
        """
        A list of ParameterName and ParameterValue pairs.
        """
        return pulumi.get(self, "control_input_parameters")

    @property
    @pulumi.getter(name="controlScope")
    def control_scope(self) -> Optional['outputs.FrameworkControlControlScopeProperties']:
        """
        The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.
        """
        return pulumi.get(self, "control_scope")


@pulumi.output_type
class FrameworkControlControlScopeProperties(dict):
    """
    The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "complianceResourceIds":
            suggest = "compliance_resource_ids"
        elif key == "complianceResourceTypes":
            suggest = "compliance_resource_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrameworkControlControlScopeProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrameworkControlControlScopeProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrameworkControlControlScopeProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compliance_resource_ids: Optional[Sequence[builtins.str]] = None,
                 compliance_resource_types: Optional[Sequence[builtins.str]] = None,
                 tags: Optional[Sequence['outputs.FrameworkTag']] = None):
        """
        The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.
        :param Sequence[builtins.str] compliance_resource_ids: The ID of the only AWS resource that you want your control scope to contain.
        :param Sequence[builtins.str] compliance_resource_types: Describes whether the control scope includes one or more types of resources, such as `EFS` or `RDS`.
        :param Sequence['FrameworkTag'] tags: Describes whether the control scope includes resources with one or more tags. Each tag is a key-value pair.
        """
        if compliance_resource_ids is not None:
            pulumi.set(__self__, "compliance_resource_ids", compliance_resource_ids)
        if compliance_resource_types is not None:
            pulumi.set(__self__, "compliance_resource_types", compliance_resource_types)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="complianceResourceIds")
    def compliance_resource_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The ID of the only AWS resource that you want your control scope to contain.
        """
        return pulumi.get(self, "compliance_resource_ids")

    @property
    @pulumi.getter(name="complianceResourceTypes")
    def compliance_resource_types(self) -> Optional[Sequence[builtins.str]]:
        """
        Describes whether the control scope includes one or more types of resources, such as `EFS` or `RDS`.
        """
        return pulumi.get(self, "compliance_resource_types")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.FrameworkTag']]:
        """
        Describes whether the control scope includes resources with one or more tags. Each tag is a key-value pair.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class FrameworkControlInputParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterName":
            suggest = "parameter_name"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrameworkControlInputParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrameworkControlInputParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrameworkControlInputParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_name: builtins.str,
                 parameter_value: builtins.str):
        """
        :param builtins.str parameter_name: The name of a parameter, for example, `BackupPlanFrequency` .
        :param builtins.str parameter_value: The value of parameter, for example, `hourly` .
        """
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> builtins.str:
        """
        The name of a parameter, for example, `BackupPlanFrequency` .
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> builtins.str:
        """
        The value of parameter, for example, `hourly` .
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class FrameworkTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        A key-value pair to associate with a resource.
        :param builtins.str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param builtins.str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LogicallyAirGappedBackupVaultNotificationObjectType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupVaultEvents":
            suggest = "backup_vault_events"
        elif key == "snsTopicArn":
            suggest = "sns_topic_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogicallyAirGappedBackupVaultNotificationObjectType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogicallyAirGappedBackupVaultNotificationObjectType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogicallyAirGappedBackupVaultNotificationObjectType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_vault_events: Sequence[builtins.str],
                 sns_topic_arn: builtins.str):
        """
        :param Sequence[builtins.str] backup_vault_events: An array of events that indicate the status of jobs to back up resources to the backup vault.
        :param builtins.str sns_topic_arn: The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for example, `arn:aws:sns:us-west-2:111122223333:MyVaultTopic` .
        """
        pulumi.set(__self__, "backup_vault_events", backup_vault_events)
        pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)

    @property
    @pulumi.getter(name="backupVaultEvents")
    def backup_vault_events(self) -> Sequence[builtins.str]:
        """
        An array of events that indicate the status of jobs to back up resources to the backup vault.
        """
        return pulumi.get(self, "backup_vault_events")

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for example, `arn:aws:sns:us-west-2:111122223333:MyVaultTopic` .
        """
        return pulumi.get(self, "sns_topic_arn")


@pulumi.output_type
class ReportDeliveryChannelProperties(dict):
    """
    A structure that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3KeyPrefix":
            suggest = "s3_key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportDeliveryChannelProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportDeliveryChannelProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportDeliveryChannelProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_name: builtins.str,
                 formats: Optional[Sequence[builtins.str]] = None,
                 s3_key_prefix: Optional[builtins.str] = None):
        """
        A structure that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
        :param builtins.str s3_bucket_name: The unique name of the S3 bucket that receives your reports.
        :param Sequence[builtins.str] formats: A list of the format of your reports: CSV, JSON, or both. If not specified, the default format is CSV.
        :param builtins.str s3_key_prefix: The prefix for where AWS Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path: s3://your-bucket-name/prefix/Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if formats is not None:
            pulumi.set(__self__, "formats", formats)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> builtins.str:
        """
        The unique name of the S3 bucket that receives your reports.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter
    def formats(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of the format of your reports: CSV, JSON, or both. If not specified, the default format is CSV.
        """
        return pulumi.get(self, "formats")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[builtins.str]:
        """
        The prefix for where AWS Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path: s3://your-bucket-name/prefix/Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.
        """
        return pulumi.get(self, "s3_key_prefix")


@pulumi.output_type
class ReportSettingProperties(dict):
    """
    Identifies the report template for the report. Reports are built using a report template.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reportTemplate":
            suggest = "report_template"
        elif key == "frameworkArns":
            suggest = "framework_arns"
        elif key == "organizationUnits":
            suggest = "organization_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportSettingProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportSettingProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportSettingProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 report_template: builtins.str,
                 accounts: Optional[Sequence[builtins.str]] = None,
                 framework_arns: Optional[Sequence[builtins.str]] = None,
                 organization_units: Optional[Sequence[builtins.str]] = None,
                 regions: Optional[Sequence[builtins.str]] = None):
        """
        Identifies the report template for the report. Reports are built using a report template.
        :param builtins.str report_template: Identifies the report template for the report. Reports are built using a report template. The report templates are: `BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT`
        :param Sequence[builtins.str] accounts: The list of AWS accounts that a report covers.
        :param Sequence[builtins.str] framework_arns: The Amazon Resource Names (ARNs) of the frameworks a report covers.
        :param Sequence[builtins.str] organization_units: The list of AWS organization units that a report covers.
        :param Sequence[builtins.str] regions: The list of AWS regions that a report covers.
        """
        pulumi.set(__self__, "report_template", report_template)
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if framework_arns is not None:
            pulumi.set(__self__, "framework_arns", framework_arns)
        if organization_units is not None:
            pulumi.set(__self__, "organization_units", organization_units)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter(name="reportTemplate")
    def report_template(self) -> builtins.str:
        """
        Identifies the report template for the report. Reports are built using a report template. The report templates are: `BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT`
        """
        return pulumi.get(self, "report_template")

    @property
    @pulumi.getter
    def accounts(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of AWS accounts that a report covers.
        """
        return pulumi.get(self, "accounts")

    @property
    @pulumi.getter(name="frameworkArns")
    def framework_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        The Amazon Resource Names (ARNs) of the frameworks a report covers.
        """
        return pulumi.get(self, "framework_arns")

    @property
    @pulumi.getter(name="organizationUnits")
    def organization_units(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of AWS organization units that a report covers.
        """
        return pulumi.get(self, "organization_units")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of AWS regions that a report covers.
        """
        return pulumi.get(self, "regions")


@pulumi.output_type
class RestoreTestingPlanRestoreTestingRecoveryPointSelection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeVaults":
            suggest = "include_vaults"
        elif key == "recoveryPointTypes":
            suggest = "recovery_point_types"
        elif key == "excludeVaults":
            suggest = "exclude_vaults"
        elif key == "selectionWindowDays":
            suggest = "selection_window_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestoreTestingPlanRestoreTestingRecoveryPointSelection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestoreTestingPlanRestoreTestingRecoveryPointSelection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestoreTestingPlanRestoreTestingRecoveryPointSelection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: 'RestoreTestingPlanRestoreTestingRecoveryPointSelectionAlgorithm',
                 include_vaults: Sequence[builtins.str],
                 recovery_point_types: Sequence['RestoreTestingPlanRestoreTestingRecoveryPointType'],
                 exclude_vaults: Optional[Sequence[builtins.str]] = None,
                 selection_window_days: Optional[builtins.int] = None):
        """
        :param 'RestoreTestingPlanRestoreTestingRecoveryPointSelectionAlgorithm' algorithm: Acceptable values include "LATEST_WITHIN_WINDOW" or "RANDOM_WITHIN_WINDOW"
        :param Sequence[builtins.str] include_vaults: Accepted values include wildcard ["*"] or by specific ARNs or ARN wilcard replacement ["arn:aws:backup:us-west-2:123456789012:backup-vault:asdf", ...] ["arn:aws:backup:*:*:backup-vault:asdf-*", ...]
        :param Sequence['RestoreTestingPlanRestoreTestingRecoveryPointType'] recovery_point_types: These are the types of recovery points.
               
               Include `SNAPSHOT` to restore only snapshot recovery points; include `CONTINUOUS` to restore continuous recovery points (point in time restore / PITR); use both to restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value for `Algorithm` .
        :param Sequence[builtins.str] exclude_vaults: Accepted values include specific ARNs or list of selectors. Defaults to empty list if not listed.
        :param builtins.int selection_window_days: Accepted values are integers from 1 to 365.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "include_vaults", include_vaults)
        pulumi.set(__self__, "recovery_point_types", recovery_point_types)
        if exclude_vaults is not None:
            pulumi.set(__self__, "exclude_vaults", exclude_vaults)
        if selection_window_days is not None:
            pulumi.set(__self__, "selection_window_days", selection_window_days)

    @property
    @pulumi.getter
    def algorithm(self) -> 'RestoreTestingPlanRestoreTestingRecoveryPointSelectionAlgorithm':
        """
        Acceptable values include "LATEST_WITHIN_WINDOW" or "RANDOM_WITHIN_WINDOW"
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="includeVaults")
    def include_vaults(self) -> Sequence[builtins.str]:
        """
        Accepted values include wildcard ["*"] or by specific ARNs or ARN wilcard replacement ["arn:aws:backup:us-west-2:123456789012:backup-vault:asdf", ...] ["arn:aws:backup:*:*:backup-vault:asdf-*", ...]
        """
        return pulumi.get(self, "include_vaults")

    @property
    @pulumi.getter(name="recoveryPointTypes")
    def recovery_point_types(self) -> Sequence['RestoreTestingPlanRestoreTestingRecoveryPointType']:
        """
        These are the types of recovery points.

        Include `SNAPSHOT` to restore only snapshot recovery points; include `CONTINUOUS` to restore continuous recovery points (point in time restore / PITR); use both to restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value for `Algorithm` .
        """
        return pulumi.get(self, "recovery_point_types")

    @property
    @pulumi.getter(name="excludeVaults")
    def exclude_vaults(self) -> Optional[Sequence[builtins.str]]:
        """
        Accepted values include specific ARNs or list of selectors. Defaults to empty list if not listed.
        """
        return pulumi.get(self, "exclude_vaults")

    @property
    @pulumi.getter(name="selectionWindowDays")
    def selection_window_days(self) -> Optional[builtins.int]:
        """
        Accepted values are integers from 1 to 365.
        """
        return pulumi.get(self, "selection_window_days")


@pulumi.output_type
class RestoreTestingSelectionKeyValue(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The tag key.
        :param builtins.str value: The tag value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RestoreTestingSelectionProtectedResourceConditions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stringEquals":
            suggest = "string_equals"
        elif key == "stringNotEquals":
            suggest = "string_not_equals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestoreTestingSelectionProtectedResourceConditions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestoreTestingSelectionProtectedResourceConditions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestoreTestingSelectionProtectedResourceConditions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 string_equals: Optional[Sequence['outputs.RestoreTestingSelectionKeyValue']] = None,
                 string_not_equals: Optional[Sequence['outputs.RestoreTestingSelectionKeyValue']] = None):
        """
        :param Sequence['RestoreTestingSelectionKeyValue'] string_equals: Filters the values of your tagged resources for only those resources that you tagged with the same value. Also called "exact matching."
        :param Sequence['RestoreTestingSelectionKeyValue'] string_not_equals: Filters the values of your tagged resources for only those resources that you tagged that do not have the same value. Also called "negated matching."
        """
        if string_equals is not None:
            pulumi.set(__self__, "string_equals", string_equals)
        if string_not_equals is not None:
            pulumi.set(__self__, "string_not_equals", string_not_equals)

    @property
    @pulumi.getter(name="stringEquals")
    def string_equals(self) -> Optional[Sequence['outputs.RestoreTestingSelectionKeyValue']]:
        """
        Filters the values of your tagged resources for only those resources that you tagged with the same value. Also called "exact matching."
        """
        return pulumi.get(self, "string_equals")

    @property
    @pulumi.getter(name="stringNotEquals")
    def string_not_equals(self) -> Optional[Sequence['outputs.RestoreTestingSelectionKeyValue']]:
        """
        Filters the values of your tagged resources for only those resources that you tagged that do not have the same value. Also called "negated matching."
        """
        return pulumi.get(self, "string_not_equals")


