# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogicallyAirGappedBackupVaultArgs', 'LogicallyAirGappedBackupVault']

@pulumi.input_type
class LogicallyAirGappedBackupVaultArgs:
    def __init__(__self__, *,
                 max_retention_days: pulumi.Input[builtins.int],
                 min_retention_days: pulumi.Input[builtins.int],
                 access_policy: Optional[Any] = None,
                 backup_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 backup_vault_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 notifications: Optional[pulumi.Input['LogicallyAirGappedBackupVaultNotificationObjectTypeArgs']] = None):
        """
        The set of arguments for constructing a LogicallyAirGappedBackupVault resource.
        :param pulumi.Input[builtins.int] max_retention_days: The maximum retention period that the vault retains its recovery points.
        :param pulumi.Input[builtins.int] min_retention_days: This setting specifies the minimum retention period that the vault retains its recovery points.
               
               The minimum value accepted is 7 days.
        :param Any access_policy: The backup vault access policy document in JSON format.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Backup::LogicallyAirGappedBackupVault` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] backup_vault_name: The name of a logical container where backups are stored. Logically air-gapped backup vaults are identified by names that are unique to the account used to create them and the Region where they are created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] backup_vault_tags: The tags to assign to the vault.
        :param pulumi.Input['LogicallyAirGappedBackupVaultNotificationObjectTypeArgs'] notifications: Returns event notifications for the specified backup vault.
        """
        pulumi.set(__self__, "max_retention_days", max_retention_days)
        pulumi.set(__self__, "min_retention_days", min_retention_days)
        if access_policy is not None:
            pulumi.set(__self__, "access_policy", access_policy)
        if backup_vault_name is not None:
            pulumi.set(__self__, "backup_vault_name", backup_vault_name)
        if backup_vault_tags is not None:
            pulumi.set(__self__, "backup_vault_tags", backup_vault_tags)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)

    @property
    @pulumi.getter(name="maxRetentionDays")
    def max_retention_days(self) -> pulumi.Input[builtins.int]:
        """
        The maximum retention period that the vault retains its recovery points.
        """
        return pulumi.get(self, "max_retention_days")

    @max_retention_days.setter
    def max_retention_days(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_retention_days", value)

    @property
    @pulumi.getter(name="minRetentionDays")
    def min_retention_days(self) -> pulumi.Input[builtins.int]:
        """
        This setting specifies the minimum retention period that the vault retains its recovery points.

        The minimum value accepted is 7 days.
        """
        return pulumi.get(self, "min_retention_days")

    @min_retention_days.setter
    def min_retention_days(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "min_retention_days", value)

    @property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> Optional[Any]:
        """
        The backup vault access policy document in JSON format.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Backup::LogicallyAirGappedBackupVault` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "access_policy")

    @access_policy.setter
    def access_policy(self, value: Optional[Any]):
        pulumi.set(self, "access_policy", value)

    @property
    @pulumi.getter(name="backupVaultName")
    def backup_vault_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a logical container where backups are stored. Logically air-gapped backup vaults are identified by names that are unique to the account used to create them and the Region where they are created.
        """
        return pulumi.get(self, "backup_vault_name")

    @backup_vault_name.setter
    def backup_vault_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_vault_name", value)

    @property
    @pulumi.getter(name="backupVaultTags")
    def backup_vault_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The tags to assign to the vault.
        """
        return pulumi.get(self, "backup_vault_tags")

    @backup_vault_tags.setter
    def backup_vault_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "backup_vault_tags", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input['LogicallyAirGappedBackupVaultNotificationObjectTypeArgs']]:
        """
        Returns event notifications for the specified backup vault.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input['LogicallyAirGappedBackupVaultNotificationObjectTypeArgs']]):
        pulumi.set(self, "notifications", value)


@pulumi.type_token("aws-native:backup:LogicallyAirGappedBackupVault")
class LogicallyAirGappedBackupVault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy: Optional[Any] = None,
                 backup_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 backup_vault_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 max_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 min_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 notifications: Optional[pulumi.Input[Union['LogicallyAirGappedBackupVaultNotificationObjectTypeArgs', 'LogicallyAirGappedBackupVaultNotificationObjectTypeArgsDict']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Backup::LogicallyAirGappedBackupVault

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param Any access_policy: The backup vault access policy document in JSON format.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Backup::LogicallyAirGappedBackupVault` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] backup_vault_name: The name of a logical container where backups are stored. Logically air-gapped backup vaults are identified by names that are unique to the account used to create them and the Region where they are created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] backup_vault_tags: The tags to assign to the vault.
        :param pulumi.Input[builtins.int] max_retention_days: The maximum retention period that the vault retains its recovery points.
        :param pulumi.Input[builtins.int] min_retention_days: This setting specifies the minimum retention period that the vault retains its recovery points.
               
               The minimum value accepted is 7 days.
        :param pulumi.Input[Union['LogicallyAirGappedBackupVaultNotificationObjectTypeArgs', 'LogicallyAirGappedBackupVaultNotificationObjectTypeArgsDict']] notifications: Returns event notifications for the specified backup vault.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogicallyAirGappedBackupVaultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Backup::LogicallyAirGappedBackupVault

        :param str resource_name: The name of the resource.
        :param LogicallyAirGappedBackupVaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogicallyAirGappedBackupVaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy: Optional[Any] = None,
                 backup_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 backup_vault_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 max_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 min_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 notifications: Optional[pulumi.Input[Union['LogicallyAirGappedBackupVaultNotificationObjectTypeArgs', 'LogicallyAirGappedBackupVaultNotificationObjectTypeArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogicallyAirGappedBackupVaultArgs.__new__(LogicallyAirGappedBackupVaultArgs)

            __props__.__dict__["access_policy"] = access_policy
            __props__.__dict__["backup_vault_name"] = backup_vault_name
            __props__.__dict__["backup_vault_tags"] = backup_vault_tags
            if max_retention_days is None and not opts.urn:
                raise TypeError("Missing required property 'max_retention_days'")
            __props__.__dict__["max_retention_days"] = max_retention_days
            if min_retention_days is None and not opts.urn:
                raise TypeError("Missing required property 'min_retention_days'")
            __props__.__dict__["min_retention_days"] = min_retention_days
            __props__.__dict__["notifications"] = notifications
            __props__.__dict__["backup_vault_arn"] = None
            __props__.__dict__["encryption_key_arn"] = None
            __props__.__dict__["vault_state"] = None
            __props__.__dict__["vault_type"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["backupVaultName", "maxRetentionDays", "minRetentionDays"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(LogicallyAirGappedBackupVault, __self__).__init__(
            'aws-native:backup:LogicallyAirGappedBackupVault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'LogicallyAirGappedBackupVault':
        """
        Get an existing LogicallyAirGappedBackupVault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LogicallyAirGappedBackupVaultArgs.__new__(LogicallyAirGappedBackupVaultArgs)

        __props__.__dict__["access_policy"] = None
        __props__.__dict__["backup_vault_arn"] = None
        __props__.__dict__["backup_vault_name"] = None
        __props__.__dict__["backup_vault_tags"] = None
        __props__.__dict__["encryption_key_arn"] = None
        __props__.__dict__["max_retention_days"] = None
        __props__.__dict__["min_retention_days"] = None
        __props__.__dict__["notifications"] = None
        __props__.__dict__["vault_state"] = None
        __props__.__dict__["vault_type"] = None
        return LogicallyAirGappedBackupVault(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> pulumi.Output[Optional[Any]]:
        """
        The backup vault access policy document in JSON format.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Backup::LogicallyAirGappedBackupVault` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "access_policy")

    @property
    @pulumi.getter(name="backupVaultArn")
    def backup_vault_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the backup vault.
        """
        return pulumi.get(self, "backup_vault_arn")

    @property
    @pulumi.getter(name="backupVaultName")
    def backup_vault_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of a logical container where backups are stored. Logically air-gapped backup vaults are identified by names that are unique to the account used to create them and the Region where they are created.
        """
        return pulumi.get(self, "backup_vault_name")

    @property
    @pulumi.getter(name="backupVaultTags")
    def backup_vault_tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The tags to assign to the vault.
        """
        return pulumi.get(self, "backup_vault_tags")

    @property
    @pulumi.getter(name="encryptionKeyArn")
    def encryption_key_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the server-side encryption key.
        """
        return pulumi.get(self, "encryption_key_arn")

    @property
    @pulumi.getter(name="maxRetentionDays")
    def max_retention_days(self) -> pulumi.Output[builtins.int]:
        """
        The maximum retention period that the vault retains its recovery points.
        """
        return pulumi.get(self, "max_retention_days")

    @property
    @pulumi.getter(name="minRetentionDays")
    def min_retention_days(self) -> pulumi.Output[builtins.int]:
        """
        This setting specifies the minimum retention period that the vault retains its recovery points.

        The minimum value accepted is 7 days.
        """
        return pulumi.get(self, "min_retention_days")

    @property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Optional['outputs.LogicallyAirGappedBackupVaultNotificationObjectType']]:
        """
        Returns event notifications for the specified backup vault.
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter(name="vaultState")
    def vault_state(self) -> pulumi.Output[builtins.str]:
        """
        The vault state. The possible values are `CREATING` , `AVAILABLE` , and `FAILED` .
        """
        return pulumi.get(self, "vault_state")

    @property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> pulumi.Output[builtins.str]:
        """
        The vault type. The possible values are `BACKUP_VAULT` and `LOGICALLY_AIR_GAPPED_BACKUP_VAULT` .
        """
        return pulumi.get(self, "vault_type")

