# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetLogicallyAirGappedBackupVaultResult',
    'AwaitableGetLogicallyAirGappedBackupVaultResult',
    'get_logically_air_gapped_backup_vault',
    'get_logically_air_gapped_backup_vault_output',
]

@pulumi.output_type
class GetLogicallyAirGappedBackupVaultResult:
    def __init__(__self__, access_policy=None, backup_vault_arn=None, backup_vault_tags=None, encryption_key_arn=None, notifications=None, vault_state=None, vault_type=None):
        if access_policy and not isinstance(access_policy, dict):
            raise TypeError("Expected argument 'access_policy' to be a dict")
        pulumi.set(__self__, "access_policy", access_policy)
        if backup_vault_arn and not isinstance(backup_vault_arn, str):
            raise TypeError("Expected argument 'backup_vault_arn' to be a str")
        pulumi.set(__self__, "backup_vault_arn", backup_vault_arn)
        if backup_vault_tags and not isinstance(backup_vault_tags, dict):
            raise TypeError("Expected argument 'backup_vault_tags' to be a dict")
        pulumi.set(__self__, "backup_vault_tags", backup_vault_tags)
        if encryption_key_arn and not isinstance(encryption_key_arn, str):
            raise TypeError("Expected argument 'encryption_key_arn' to be a str")
        pulumi.set(__self__, "encryption_key_arn", encryption_key_arn)
        if notifications and not isinstance(notifications, dict):
            raise TypeError("Expected argument 'notifications' to be a dict")
        pulumi.set(__self__, "notifications", notifications)
        if vault_state and not isinstance(vault_state, str):
            raise TypeError("Expected argument 'vault_state' to be a str")
        pulumi.set(__self__, "vault_state", vault_state)
        if vault_type and not isinstance(vault_type, str):
            raise TypeError("Expected argument 'vault_type' to be a str")
        pulumi.set(__self__, "vault_type", vault_type)

    @property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> Optional[Any]:
        """
        The backup vault access policy document in JSON format.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Backup::LogicallyAirGappedBackupVault` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "access_policy")

    @property
    @pulumi.getter(name="backupVaultArn")
    def backup_vault_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the backup vault.
        """
        return pulumi.get(self, "backup_vault_arn")

    @property
    @pulumi.getter(name="backupVaultTags")
    def backup_vault_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The tags to assign to the vault.
        """
        return pulumi.get(self, "backup_vault_tags")

    @property
    @pulumi.getter(name="encryptionKeyArn")
    def encryption_key_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the server-side encryption key.
        """
        return pulumi.get(self, "encryption_key_arn")

    @property
    @pulumi.getter
    def notifications(self) -> Optional['outputs.LogicallyAirGappedBackupVaultNotificationObjectType']:
        """
        Returns event notifications for the specified backup vault.
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter(name="vaultState")
    def vault_state(self) -> Optional[builtins.str]:
        """
        The vault state. The possible values are `CREATING` , `AVAILABLE` , and `FAILED` .
        """
        return pulumi.get(self, "vault_state")

    @property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> Optional[builtins.str]:
        """
        The vault type. The possible values are `BACKUP_VAULT` and `LOGICALLY_AIR_GAPPED_BACKUP_VAULT` .
        """
        return pulumi.get(self, "vault_type")


class AwaitableGetLogicallyAirGappedBackupVaultResult(GetLogicallyAirGappedBackupVaultResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogicallyAirGappedBackupVaultResult(
            access_policy=self.access_policy,
            backup_vault_arn=self.backup_vault_arn,
            backup_vault_tags=self.backup_vault_tags,
            encryption_key_arn=self.encryption_key_arn,
            notifications=self.notifications,
            vault_state=self.vault_state,
            vault_type=self.vault_type)


def get_logically_air_gapped_backup_vault(backup_vault_name: Optional[builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogicallyAirGappedBackupVaultResult:
    """
    Resource Type definition for AWS::Backup::LogicallyAirGappedBackupVault


    :param builtins.str backup_vault_name: The name of a logical container where backups are stored. Logically air-gapped backup vaults are identified by names that are unique to the account used to create them and the Region where they are created.
    """
    __args__ = dict()
    __args__['backupVaultName'] = backup_vault_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:backup:getLogicallyAirGappedBackupVault', __args__, opts=opts, typ=GetLogicallyAirGappedBackupVaultResult).value

    return AwaitableGetLogicallyAirGappedBackupVaultResult(
        access_policy=pulumi.get(__ret__, 'access_policy'),
        backup_vault_arn=pulumi.get(__ret__, 'backup_vault_arn'),
        backup_vault_tags=pulumi.get(__ret__, 'backup_vault_tags'),
        encryption_key_arn=pulumi.get(__ret__, 'encryption_key_arn'),
        notifications=pulumi.get(__ret__, 'notifications'),
        vault_state=pulumi.get(__ret__, 'vault_state'),
        vault_type=pulumi.get(__ret__, 'vault_type'))
def get_logically_air_gapped_backup_vault_output(backup_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogicallyAirGappedBackupVaultResult]:
    """
    Resource Type definition for AWS::Backup::LogicallyAirGappedBackupVault


    :param builtins.str backup_vault_name: The name of a logical container where backups are stored. Logically air-gapped backup vaults are identified by names that are unique to the account used to create them and the Region where they are created.
    """
    __args__ = dict()
    __args__['backupVaultName'] = backup_vault_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:backup:getLogicallyAirGappedBackupVault', __args__, opts=opts, typ=GetLogicallyAirGappedBackupVaultResult)
    return __ret__.apply(lambda __response__: GetLogicallyAirGappedBackupVaultResult(
        access_policy=pulumi.get(__response__, 'access_policy'),
        backup_vault_arn=pulumi.get(__response__, 'backup_vault_arn'),
        backup_vault_tags=pulumi.get(__response__, 'backup_vault_tags'),
        encryption_key_arn=pulumi.get(__response__, 'encryption_key_arn'),
        notifications=pulumi.get(__response__, 'notifications'),
        vault_state=pulumi.get(__response__, 'vault_state'),
        vault_type=pulumi.get(__response__, 'vault_type')))
