# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBackupPlanResult',
    'AwaitableGetBackupPlanResult',
    'get_backup_plan',
    'get_backup_plan_output',
]

@pulumi.output_type
class GetBackupPlanResult:
    def __init__(__self__, backup_plan=None, backup_plan_arn=None, backup_plan_id=None, backup_plan_tags=None, version_id=None):
        if backup_plan and not isinstance(backup_plan, dict):
            raise TypeError("Expected argument 'backup_plan' to be a dict")
        pulumi.set(__self__, "backup_plan", backup_plan)
        if backup_plan_arn and not isinstance(backup_plan_arn, str):
            raise TypeError("Expected argument 'backup_plan_arn' to be a str")
        pulumi.set(__self__, "backup_plan_arn", backup_plan_arn)
        if backup_plan_id and not isinstance(backup_plan_id, str):
            raise TypeError("Expected argument 'backup_plan_id' to be a str")
        pulumi.set(__self__, "backup_plan_id", backup_plan_id)
        if backup_plan_tags and not isinstance(backup_plan_tags, dict):
            raise TypeError("Expected argument 'backup_plan_tags' to be a dict")
        pulumi.set(__self__, "backup_plan_tags", backup_plan_tags)
        if version_id and not isinstance(version_id, str):
            raise TypeError("Expected argument 'version_id' to be a str")
        pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter(name="backupPlan")
    def backup_plan(self) -> Optional['outputs.BackupPlanResourceType']:
        """
        Uniquely identifies the backup plan to be associated with the selection of resources.
        """
        return pulumi.get(self, "backup_plan")

    @property
    @pulumi.getter(name="backupPlanArn")
    def backup_plan_arn(self) -> Optional[builtins.str]:
        """
        An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, `arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50` .
        """
        return pulumi.get(self, "backup_plan_arn")

    @property
    @pulumi.getter(name="backupPlanId")
    def backup_plan_id(self) -> Optional[builtins.str]:
        """
        Uniquely identifies a backup plan.
        """
        return pulumi.get(self, "backup_plan_id")

    @property
    @pulumi.getter(name="backupPlanTags")
    def backup_plan_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The tags to assign to the backup plan.
        """
        return pulumi.get(self, "backup_plan_tags")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[builtins.str]:
        """
        Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version Ids cannot be edited.
        """
        return pulumi.get(self, "version_id")


class AwaitableGetBackupPlanResult(GetBackupPlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupPlanResult(
            backup_plan=self.backup_plan,
            backup_plan_arn=self.backup_plan_arn,
            backup_plan_id=self.backup_plan_id,
            backup_plan_tags=self.backup_plan_tags,
            version_id=self.version_id)


def get_backup_plan(backup_plan_id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupPlanResult:
    """
    Resource Type definition for AWS::Backup::BackupPlan


    :param builtins.str backup_plan_id: Uniquely identifies a backup plan.
    """
    __args__ = dict()
    __args__['backupPlanId'] = backup_plan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:backup:getBackupPlan', __args__, opts=opts, typ=GetBackupPlanResult).value

    return AwaitableGetBackupPlanResult(
        backup_plan=pulumi.get(__ret__, 'backup_plan'),
        backup_plan_arn=pulumi.get(__ret__, 'backup_plan_arn'),
        backup_plan_id=pulumi.get(__ret__, 'backup_plan_id'),
        backup_plan_tags=pulumi.get(__ret__, 'backup_plan_tags'),
        version_id=pulumi.get(__ret__, 'version_id'))
def get_backup_plan_output(backup_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackupPlanResult]:
    """
    Resource Type definition for AWS::Backup::BackupPlan


    :param builtins.str backup_plan_id: Uniquely identifies a backup plan.
    """
    __args__ = dict()
    __args__['backupPlanId'] = backup_plan_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:backup:getBackupPlan', __args__, opts=opts, typ=GetBackupPlanResult)
    return __ret__.apply(lambda __response__: GetBackupPlanResult(
        backup_plan=pulumi.get(__response__, 'backup_plan'),
        backup_plan_arn=pulumi.get(__response__, 'backup_plan_arn'),
        backup_plan_id=pulumi.get(__response__, 'backup_plan_id'),
        backup_plan_tags=pulumi.get(__response__, 'backup_plan_tags'),
        version_id=pulumi.get(__response__, 'version_id')))
