# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['TransformerArgs', 'Transformer']

@pulumi.input_type
class TransformerArgs:
    def __init__(__self__, *,
                 status: pulumi.Input['TransformerStatus'],
                 edi_type: Optional[pulumi.Input['TransformerEdiTypePropertiesArgs']] = None,
                 file_format: Optional[pulumi.Input['TransformerFileFormat']] = None,
                 input_conversion: Optional[pulumi.Input['TransformerInputConversionArgs']] = None,
                 mapping: Optional[pulumi.Input['TransformerMappingArgs']] = None,
                 mapping_template: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 output_conversion: Optional[pulumi.Input['TransformerOutputConversionArgs']] = None,
                 sample_document: Optional[pulumi.Input[builtins.str]] = None,
                 sample_documents: Optional[pulumi.Input['TransformerSampleDocumentsArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Transformer resource.
        :param pulumi.Input['TransformerStatus'] status: Returns the state of the newly created transformer. The transformer can be either `active` or `inactive` . For the transformer to be used in a capability, its status must `active` .
        :param pulumi.Input['TransformerInputConversionArgs'] input_conversion: Returns a structure that contains the format options for the transformation.
        :param pulumi.Input['TransformerMappingArgs'] mapping: Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
        :param pulumi.Input[builtins.str] mapping_template: This shape is deprecated: This is a legacy trait. Please use input-conversion or output-conversion.
        :param pulumi.Input[builtins.str] name: Returns the descriptive name for the transformer.
        :param pulumi.Input['TransformerOutputConversionArgs'] output_conversion: Returns the `OutputConversion` object, which contains the format options for the outbound transformation.
        :param pulumi.Input[builtins.str] sample_document: This shape is deprecated: This is a legacy trait. Please use input-conversion or output-conversion.
        :param pulumi.Input['TransformerSampleDocumentsArgs'] sample_documents: Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A key-value pair for a specific transformer. Tags are metadata that you can use to search for and group capabilities for various purposes.
        """
        pulumi.set(__self__, "status", status)
        if edi_type is not None:
            pulumi.set(__self__, "edi_type", edi_type)
        if file_format is not None:
            pulumi.set(__self__, "file_format", file_format)
        if input_conversion is not None:
            pulumi.set(__self__, "input_conversion", input_conversion)
        if mapping is not None:
            pulumi.set(__self__, "mapping", mapping)
        if mapping_template is not None:
            pulumi.set(__self__, "mapping_template", mapping_template)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_conversion is not None:
            pulumi.set(__self__, "output_conversion", output_conversion)
        if sample_document is not None:
            pulumi.set(__self__, "sample_document", sample_document)
        if sample_documents is not None:
            pulumi.set(__self__, "sample_documents", sample_documents)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input['TransformerStatus']:
        """
        Returns the state of the newly created transformer. The transformer can be either `active` or `inactive` . For the transformer to be used in a capability, its status must `active` .
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input['TransformerStatus']):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="ediType")
    def edi_type(self) -> Optional[pulumi.Input['TransformerEdiTypePropertiesArgs']]:
        return pulumi.get(self, "edi_type")

    @edi_type.setter
    def edi_type(self, value: Optional[pulumi.Input['TransformerEdiTypePropertiesArgs']]):
        pulumi.set(self, "edi_type", value)

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> Optional[pulumi.Input['TransformerFileFormat']]:
        return pulumi.get(self, "file_format")

    @file_format.setter
    def file_format(self, value: Optional[pulumi.Input['TransformerFileFormat']]):
        pulumi.set(self, "file_format", value)

    @property
    @pulumi.getter(name="inputConversion")
    def input_conversion(self) -> Optional[pulumi.Input['TransformerInputConversionArgs']]:
        """
        Returns a structure that contains the format options for the transformation.
        """
        return pulumi.get(self, "input_conversion")

    @input_conversion.setter
    def input_conversion(self, value: Optional[pulumi.Input['TransformerInputConversionArgs']]):
        pulumi.set(self, "input_conversion", value)

    @property
    @pulumi.getter
    def mapping(self) -> Optional[pulumi.Input['TransformerMappingArgs']]:
        """
        Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
        """
        return pulumi.get(self, "mapping")

    @mapping.setter
    def mapping(self, value: Optional[pulumi.Input['TransformerMappingArgs']]):
        pulumi.set(self, "mapping", value)

    @property
    @pulumi.getter(name="mappingTemplate")
    def mapping_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This shape is deprecated: This is a legacy trait. Please use input-conversion or output-conversion.
        """
        return pulumi.get(self, "mapping_template")

    @mapping_template.setter
    def mapping_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mapping_template", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Returns the descriptive name for the transformer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputConversion")
    def output_conversion(self) -> Optional[pulumi.Input['TransformerOutputConversionArgs']]:
        """
        Returns the `OutputConversion` object, which contains the format options for the outbound transformation.
        """
        return pulumi.get(self, "output_conversion")

    @output_conversion.setter
    def output_conversion(self, value: Optional[pulumi.Input['TransformerOutputConversionArgs']]):
        pulumi.set(self, "output_conversion", value)

    @property
    @pulumi.getter(name="sampleDocument")
    def sample_document(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This shape is deprecated: This is a legacy trait. Please use input-conversion or output-conversion.
        """
        return pulumi.get(self, "sample_document")

    @sample_document.setter
    def sample_document(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sample_document", value)

    @property
    @pulumi.getter(name="sampleDocuments")
    def sample_documents(self) -> Optional[pulumi.Input['TransformerSampleDocumentsArgs']]:
        """
        Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
        """
        return pulumi.get(self, "sample_documents")

    @sample_documents.setter
    def sample_documents(self, value: Optional[pulumi.Input['TransformerSampleDocumentsArgs']]):
        pulumi.set(self, "sample_documents", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A key-value pair for a specific transformer. Tags are metadata that you can use to search for and group capabilities for various purposes.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:b2bi:Transformer")
class Transformer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 edi_type: Optional[pulumi.Input[Union['TransformerEdiTypePropertiesArgs', 'TransformerEdiTypePropertiesArgsDict']]] = None,
                 file_format: Optional[pulumi.Input['TransformerFileFormat']] = None,
                 input_conversion: Optional[pulumi.Input[Union['TransformerInputConversionArgs', 'TransformerInputConversionArgsDict']]] = None,
                 mapping: Optional[pulumi.Input[Union['TransformerMappingArgs', 'TransformerMappingArgsDict']]] = None,
                 mapping_template: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 output_conversion: Optional[pulumi.Input[Union['TransformerOutputConversionArgs', 'TransformerOutputConversionArgsDict']]] = None,
                 sample_document: Optional[pulumi.Input[builtins.str]] = None,
                 sample_documents: Optional[pulumi.Input[Union['TransformerSampleDocumentsArgs', 'TransformerSampleDocumentsArgsDict']]] = None,
                 status: Optional[pulumi.Input['TransformerStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::B2BI::Transformer Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TransformerInputConversionArgs', 'TransformerInputConversionArgsDict']] input_conversion: Returns a structure that contains the format options for the transformation.
        :param pulumi.Input[Union['TransformerMappingArgs', 'TransformerMappingArgsDict']] mapping: Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
        :param pulumi.Input[builtins.str] mapping_template: This shape is deprecated: This is a legacy trait. Please use input-conversion or output-conversion.
        :param pulumi.Input[builtins.str] name: Returns the descriptive name for the transformer.
        :param pulumi.Input[Union['TransformerOutputConversionArgs', 'TransformerOutputConversionArgsDict']] output_conversion: Returns the `OutputConversion` object, which contains the format options for the outbound transformation.
        :param pulumi.Input[builtins.str] sample_document: This shape is deprecated: This is a legacy trait. Please use input-conversion or output-conversion.
        :param pulumi.Input[Union['TransformerSampleDocumentsArgs', 'TransformerSampleDocumentsArgsDict']] sample_documents: Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
        :param pulumi.Input['TransformerStatus'] status: Returns the state of the newly created transformer. The transformer can be either `active` or `inactive` . For the transformer to be used in a capability, its status must `active` .
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A key-value pair for a specific transformer. Tags are metadata that you can use to search for and group capabilities for various purposes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransformerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::B2BI::Transformer Resource Type

        :param str resource_name: The name of the resource.
        :param TransformerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransformerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 edi_type: Optional[pulumi.Input[Union['TransformerEdiTypePropertiesArgs', 'TransformerEdiTypePropertiesArgsDict']]] = None,
                 file_format: Optional[pulumi.Input['TransformerFileFormat']] = None,
                 input_conversion: Optional[pulumi.Input[Union['TransformerInputConversionArgs', 'TransformerInputConversionArgsDict']]] = None,
                 mapping: Optional[pulumi.Input[Union['TransformerMappingArgs', 'TransformerMappingArgsDict']]] = None,
                 mapping_template: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 output_conversion: Optional[pulumi.Input[Union['TransformerOutputConversionArgs', 'TransformerOutputConversionArgsDict']]] = None,
                 sample_document: Optional[pulumi.Input[builtins.str]] = None,
                 sample_documents: Optional[pulumi.Input[Union['TransformerSampleDocumentsArgs', 'TransformerSampleDocumentsArgsDict']]] = None,
                 status: Optional[pulumi.Input['TransformerStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransformerArgs.__new__(TransformerArgs)

            __props__.__dict__["edi_type"] = edi_type
            __props__.__dict__["file_format"] = file_format
            __props__.__dict__["input_conversion"] = input_conversion
            __props__.__dict__["mapping"] = mapping
            __props__.__dict__["mapping_template"] = mapping_template
            __props__.__dict__["name"] = name
            __props__.__dict__["output_conversion"] = output_conversion
            __props__.__dict__["sample_document"] = sample_document
            __props__.__dict__["sample_documents"] = sample_documents
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["modified_at"] = None
            __props__.__dict__["transformer_arn"] = None
            __props__.__dict__["transformer_id"] = None
        super(Transformer, __self__).__init__(
            'aws-native:b2bi:Transformer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Transformer':
        """
        Get an existing Transformer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TransformerArgs.__new__(TransformerArgs)

        __props__.__dict__["created_at"] = None
        __props__.__dict__["edi_type"] = None
        __props__.__dict__["file_format"] = None
        __props__.__dict__["input_conversion"] = None
        __props__.__dict__["mapping"] = None
        __props__.__dict__["mapping_template"] = None
        __props__.__dict__["modified_at"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["output_conversion"] = None
        __props__.__dict__["sample_document"] = None
        __props__.__dict__["sample_documents"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["transformer_arn"] = None
        __props__.__dict__["transformer_id"] = None
        return Transformer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Returns a timestamp indicating when the transformer was created. For example, `2023-07-20T19:58:44.624Z` .
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="ediType")
    def edi_type(self) -> pulumi.Output[Optional['outputs.TransformerEdiTypeProperties']]:
        return pulumi.get(self, "edi_type")

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> pulumi.Output[Optional['TransformerFileFormat']]:
        return pulumi.get(self, "file_format")

    @property
    @pulumi.getter(name="inputConversion")
    def input_conversion(self) -> pulumi.Output[Optional['outputs.TransformerInputConversion']]:
        """
        Returns a structure that contains the format options for the transformation.
        """
        return pulumi.get(self, "input_conversion")

    @property
    @pulumi.getter
    def mapping(self) -> pulumi.Output[Optional['outputs.TransformerMapping']]:
        """
        Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
        """
        return pulumi.get(self, "mapping")

    @property
    @pulumi.getter(name="mappingTemplate")
    def mapping_template(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This shape is deprecated: This is a legacy trait. Please use input-conversion or output-conversion.
        """
        return pulumi.get(self, "mapping_template")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[builtins.str]:
        """
        Returns a timestamp representing the date and time for the most recent change for the transformer object.
        """
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Returns the descriptive name for the transformer.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputConversion")
    def output_conversion(self) -> pulumi.Output[Optional['outputs.TransformerOutputConversion']]:
        """
        Returns the `OutputConversion` object, which contains the format options for the outbound transformation.
        """
        return pulumi.get(self, "output_conversion")

    @property
    @pulumi.getter(name="sampleDocument")
    def sample_document(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This shape is deprecated: This is a legacy trait. Please use input-conversion or output-conversion.
        """
        return pulumi.get(self, "sample_document")

    @property
    @pulumi.getter(name="sampleDocuments")
    def sample_documents(self) -> pulumi.Output[Optional['outputs.TransformerSampleDocuments']]:
        """
        Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
        """
        return pulumi.get(self, "sample_documents")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['TransformerStatus']:
        """
        Returns the state of the newly created transformer. The transformer can be either `active` or `inactive` . For the transformer to be used in a capability, its status must `active` .
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A key-value pair for a specific transformer. Tags are metadata that you can use to search for and group capabilities for various purposes.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="transformerArn")
    def transformer_arn(self) -> pulumi.Output[builtins.str]:
        """
        Returns an Amazon Resource Name (ARN) for a specific transformer.
        """
        return pulumi.get(self, "transformer_arn")

    @property
    @pulumi.getter(name="transformerId")
    def transformer_id(self) -> pulumi.Output[builtins.str]:
        """
        The system-assigned unique identifier for the transformer.
        """
        return pulumi.get(self, "transformer_id")

