# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetTransformerResult',
    'AwaitableGetTransformerResult',
    'get_transformer',
    'get_transformer_output',
]

@pulumi.output_type
class GetTransformerResult:
    def __init__(__self__, created_at=None, edi_type=None, file_format=None, input_conversion=None, mapping=None, mapping_template=None, modified_at=None, name=None, output_conversion=None, sample_document=None, sample_documents=None, status=None, tags=None, transformer_arn=None, transformer_id=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if edi_type and not isinstance(edi_type, dict):
            raise TypeError("Expected argument 'edi_type' to be a dict")
        pulumi.set(__self__, "edi_type", edi_type)
        if file_format and not isinstance(file_format, str):
            raise TypeError("Expected argument 'file_format' to be a str")
        pulumi.set(__self__, "file_format", file_format)
        if input_conversion and not isinstance(input_conversion, dict):
            raise TypeError("Expected argument 'input_conversion' to be a dict")
        pulumi.set(__self__, "input_conversion", input_conversion)
        if mapping and not isinstance(mapping, dict):
            raise TypeError("Expected argument 'mapping' to be a dict")
        pulumi.set(__self__, "mapping", mapping)
        if mapping_template and not isinstance(mapping_template, str):
            raise TypeError("Expected argument 'mapping_template' to be a str")
        pulumi.set(__self__, "mapping_template", mapping_template)
        if modified_at and not isinstance(modified_at, str):
            raise TypeError("Expected argument 'modified_at' to be a str")
        pulumi.set(__self__, "modified_at", modified_at)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if output_conversion and not isinstance(output_conversion, dict):
            raise TypeError("Expected argument 'output_conversion' to be a dict")
        pulumi.set(__self__, "output_conversion", output_conversion)
        if sample_document and not isinstance(sample_document, str):
            raise TypeError("Expected argument 'sample_document' to be a str")
        pulumi.set(__self__, "sample_document", sample_document)
        if sample_documents and not isinstance(sample_documents, dict):
            raise TypeError("Expected argument 'sample_documents' to be a dict")
        pulumi.set(__self__, "sample_documents", sample_documents)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if transformer_arn and not isinstance(transformer_arn, str):
            raise TypeError("Expected argument 'transformer_arn' to be a str")
        pulumi.set(__self__, "transformer_arn", transformer_arn)
        if transformer_id and not isinstance(transformer_id, str):
            raise TypeError("Expected argument 'transformer_id' to be a str")
        pulumi.set(__self__, "transformer_id", transformer_id)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        Returns a timestamp indicating when the transformer was created. For example, `2023-07-20T19:58:44.624Z` .
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="ediType")
    def edi_type(self) -> Optional['outputs.TransformerEdiTypeProperties']:
        return pulumi.get(self, "edi_type")

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> Optional['TransformerFileFormat']:
        return pulumi.get(self, "file_format")

    @property
    @pulumi.getter(name="inputConversion")
    def input_conversion(self) -> Optional['outputs.TransformerInputConversion']:
        """
        Returns a structure that contains the format options for the transformation.
        """
        return pulumi.get(self, "input_conversion")

    @property
    @pulumi.getter
    def mapping(self) -> Optional['outputs.TransformerMapping']:
        """
        Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
        """
        return pulumi.get(self, "mapping")

    @property
    @pulumi.getter(name="mappingTemplate")
    def mapping_template(self) -> Optional[builtins.str]:
        """
        This shape is deprecated: This is a legacy trait. Please use input-conversion or output-conversion.
        """
        return pulumi.get(self, "mapping_template")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[builtins.str]:
        """
        Returns a timestamp representing the date and time for the most recent change for the transformer object.
        """
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Returns the descriptive name for the transformer.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputConversion")
    def output_conversion(self) -> Optional['outputs.TransformerOutputConversion']:
        """
        Returns the `OutputConversion` object, which contains the format options for the outbound transformation.
        """
        return pulumi.get(self, "output_conversion")

    @property
    @pulumi.getter(name="sampleDocument")
    def sample_document(self) -> Optional[builtins.str]:
        """
        This shape is deprecated: This is a legacy trait. Please use input-conversion or output-conversion.
        """
        return pulumi.get(self, "sample_document")

    @property
    @pulumi.getter(name="sampleDocuments")
    def sample_documents(self) -> Optional['outputs.TransformerSampleDocuments']:
        """
        Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
        """
        return pulumi.get(self, "sample_documents")

    @property
    @pulumi.getter
    def status(self) -> Optional['TransformerStatus']:
        """
        Returns the state of the newly created transformer. The transformer can be either `active` or `inactive` . For the transformer to be used in a capability, its status must `active` .
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A key-value pair for a specific transformer. Tags are metadata that you can use to search for and group capabilities for various purposes.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="transformerArn")
    def transformer_arn(self) -> Optional[builtins.str]:
        """
        Returns an Amazon Resource Name (ARN) for a specific transformer.
        """
        return pulumi.get(self, "transformer_arn")

    @property
    @pulumi.getter(name="transformerId")
    def transformer_id(self) -> Optional[builtins.str]:
        """
        The system-assigned unique identifier for the transformer.
        """
        return pulumi.get(self, "transformer_id")


class AwaitableGetTransformerResult(GetTransformerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransformerResult(
            created_at=self.created_at,
            edi_type=self.edi_type,
            file_format=self.file_format,
            input_conversion=self.input_conversion,
            mapping=self.mapping,
            mapping_template=self.mapping_template,
            modified_at=self.modified_at,
            name=self.name,
            output_conversion=self.output_conversion,
            sample_document=self.sample_document,
            sample_documents=self.sample_documents,
            status=self.status,
            tags=self.tags,
            transformer_arn=self.transformer_arn,
            transformer_id=self.transformer_id)


def get_transformer(transformer_id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransformerResult:
    """
    Definition of AWS::B2BI::Transformer Resource Type


    :param builtins.str transformer_id: The system-assigned unique identifier for the transformer.
    """
    __args__ = dict()
    __args__['transformerId'] = transformer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:b2bi:getTransformer', __args__, opts=opts, typ=GetTransformerResult).value

    return AwaitableGetTransformerResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        edi_type=pulumi.get(__ret__, 'edi_type'),
        file_format=pulumi.get(__ret__, 'file_format'),
        input_conversion=pulumi.get(__ret__, 'input_conversion'),
        mapping=pulumi.get(__ret__, 'mapping'),
        mapping_template=pulumi.get(__ret__, 'mapping_template'),
        modified_at=pulumi.get(__ret__, 'modified_at'),
        name=pulumi.get(__ret__, 'name'),
        output_conversion=pulumi.get(__ret__, 'output_conversion'),
        sample_document=pulumi.get(__ret__, 'sample_document'),
        sample_documents=pulumi.get(__ret__, 'sample_documents'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        transformer_arn=pulumi.get(__ret__, 'transformer_arn'),
        transformer_id=pulumi.get(__ret__, 'transformer_id'))
def get_transformer_output(transformer_id: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTransformerResult]:
    """
    Definition of AWS::B2BI::Transformer Resource Type


    :param builtins.str transformer_id: The system-assigned unique identifier for the transformer.
    """
    __args__ = dict()
    __args__['transformerId'] = transformer_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:b2bi:getTransformer', __args__, opts=opts, typ=GetTransformerResult)
    return __ret__.apply(lambda __response__: GetTransformerResult(
        created_at=pulumi.get(__response__, 'created_at'),
        edi_type=pulumi.get(__response__, 'edi_type'),
        file_format=pulumi.get(__response__, 'file_format'),
        input_conversion=pulumi.get(__response__, 'input_conversion'),
        mapping=pulumi.get(__response__, 'mapping'),
        mapping_template=pulumi.get(__response__, 'mapping_template'),
        modified_at=pulumi.get(__response__, 'modified_at'),
        name=pulumi.get(__response__, 'name'),
        output_conversion=pulumi.get(__response__, 'output_conversion'),
        sample_document=pulumi.get(__response__, 'sample_document'),
        sample_documents=pulumi.get(__response__, 'sample_documents'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        transformer_arn=pulumi.get(__response__, 'transformer_arn'),
        transformer_id=pulumi.get(__response__, 'transformer_id')))
