# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'AutoScalingGroupAcceleratorCountRequestArgs',
    'AutoScalingGroupAcceleratorCountRequestArgsDict',
    'AutoScalingGroupAcceleratorTotalMemoryMiBRequestArgs',
    'AutoScalingGroupAcceleratorTotalMemoryMiBRequestArgsDict',
    'AutoScalingGroupAvailabilityZoneDistributionArgs',
    'AutoScalingGroupAvailabilityZoneDistributionArgsDict',
    'AutoScalingGroupAvailabilityZoneImpairmentPolicyArgs',
    'AutoScalingGroupAvailabilityZoneImpairmentPolicyArgsDict',
    'AutoScalingGroupBaselineEbsBandwidthMbpsRequestArgs',
    'AutoScalingGroupBaselineEbsBandwidthMbpsRequestArgsDict',
    'AutoScalingGroupBaselinePerformanceFactorsRequestArgs',
    'AutoScalingGroupBaselinePerformanceFactorsRequestArgsDict',
    'AutoScalingGroupCapacityReservationSpecificationArgs',
    'AutoScalingGroupCapacityReservationSpecificationArgsDict',
    'AutoScalingGroupCapacityReservationTargetArgs',
    'AutoScalingGroupCapacityReservationTargetArgsDict',
    'AutoScalingGroupCpuPerformanceFactorRequestArgs',
    'AutoScalingGroupCpuPerformanceFactorRequestArgsDict',
    'AutoScalingGroupInstanceMaintenancePolicyArgs',
    'AutoScalingGroupInstanceMaintenancePolicyArgsDict',
    'AutoScalingGroupInstanceRequirementsArgs',
    'AutoScalingGroupInstanceRequirementsArgsDict',
    'AutoScalingGroupInstancesDistributionArgs',
    'AutoScalingGroupInstancesDistributionArgsDict',
    'AutoScalingGroupLaunchTemplateOverridesArgs',
    'AutoScalingGroupLaunchTemplateOverridesArgsDict',
    'AutoScalingGroupLaunchTemplateSpecificationArgs',
    'AutoScalingGroupLaunchTemplateSpecificationArgsDict',
    'AutoScalingGroupLaunchTemplateArgs',
    'AutoScalingGroupLaunchTemplateArgsDict',
    'AutoScalingGroupLifecycleHookSpecificationArgs',
    'AutoScalingGroupLifecycleHookSpecificationArgsDict',
    'AutoScalingGroupMemoryGiBPerVCpuRequestArgs',
    'AutoScalingGroupMemoryGiBPerVCpuRequestArgsDict',
    'AutoScalingGroupMemoryMiBRequestArgs',
    'AutoScalingGroupMemoryMiBRequestArgsDict',
    'AutoScalingGroupMetricsCollectionArgs',
    'AutoScalingGroupMetricsCollectionArgsDict',
    'AutoScalingGroupMixedInstancesPolicyArgs',
    'AutoScalingGroupMixedInstancesPolicyArgsDict',
    'AutoScalingGroupNetworkBandwidthGbpsRequestArgs',
    'AutoScalingGroupNetworkBandwidthGbpsRequestArgsDict',
    'AutoScalingGroupNetworkInterfaceCountRequestArgs',
    'AutoScalingGroupNetworkInterfaceCountRequestArgsDict',
    'AutoScalingGroupNotificationConfigurationArgs',
    'AutoScalingGroupNotificationConfigurationArgsDict',
    'AutoScalingGroupPerformanceFactorReferenceRequestArgs',
    'AutoScalingGroupPerformanceFactorReferenceRequestArgsDict',
    'AutoScalingGroupTagPropertyArgs',
    'AutoScalingGroupTagPropertyArgsDict',
    'AutoScalingGroupTotalLocalStorageGbRequestArgs',
    'AutoScalingGroupTotalLocalStorageGbRequestArgsDict',
    'AutoScalingGroupTrafficSourceIdentifierArgs',
    'AutoScalingGroupTrafficSourceIdentifierArgsDict',
    'AutoScalingGroupVCpuCountRequestArgs',
    'AutoScalingGroupVCpuCountRequestArgsDict',
    'LaunchConfigurationBlockDeviceMappingArgs',
    'LaunchConfigurationBlockDeviceMappingArgsDict',
    'LaunchConfigurationBlockDeviceArgs',
    'LaunchConfigurationBlockDeviceArgsDict',
    'LaunchConfigurationMetadataOptionsArgs',
    'LaunchConfigurationMetadataOptionsArgsDict',
    'ScalingPolicyCustomizedMetricSpecificationArgs',
    'ScalingPolicyCustomizedMetricSpecificationArgsDict',
    'ScalingPolicyMetricDataQueryArgs',
    'ScalingPolicyMetricDataQueryArgsDict',
    'ScalingPolicyMetricDimensionArgs',
    'ScalingPolicyMetricDimensionArgsDict',
    'ScalingPolicyMetricStatArgs',
    'ScalingPolicyMetricStatArgsDict',
    'ScalingPolicyMetricArgs',
    'ScalingPolicyMetricArgsDict',
    'ScalingPolicyPredefinedMetricSpecificationArgs',
    'ScalingPolicyPredefinedMetricSpecificationArgsDict',
    'ScalingPolicyPredictiveScalingConfigurationArgs',
    'ScalingPolicyPredictiveScalingConfigurationArgsDict',
    'ScalingPolicyPredictiveScalingCustomizedCapacityMetricArgs',
    'ScalingPolicyPredictiveScalingCustomizedCapacityMetricArgsDict',
    'ScalingPolicyPredictiveScalingCustomizedLoadMetricArgs',
    'ScalingPolicyPredictiveScalingCustomizedLoadMetricArgsDict',
    'ScalingPolicyPredictiveScalingCustomizedScalingMetricArgs',
    'ScalingPolicyPredictiveScalingCustomizedScalingMetricArgsDict',
    'ScalingPolicyPredictiveScalingMetricSpecificationArgs',
    'ScalingPolicyPredictiveScalingMetricSpecificationArgsDict',
    'ScalingPolicyPredictiveScalingPredefinedLoadMetricArgs',
    'ScalingPolicyPredictiveScalingPredefinedLoadMetricArgsDict',
    'ScalingPolicyPredictiveScalingPredefinedMetricPairArgs',
    'ScalingPolicyPredictiveScalingPredefinedMetricPairArgsDict',
    'ScalingPolicyPredictiveScalingPredefinedScalingMetricArgs',
    'ScalingPolicyPredictiveScalingPredefinedScalingMetricArgsDict',
    'ScalingPolicyStepAdjustmentArgs',
    'ScalingPolicyStepAdjustmentArgsDict',
    'ScalingPolicyTargetTrackingConfigurationArgs',
    'ScalingPolicyTargetTrackingConfigurationArgsDict',
    'ScalingPolicyTargetTrackingMetricDataQueryArgs',
    'ScalingPolicyTargetTrackingMetricDataQueryArgsDict',
    'ScalingPolicyTargetTrackingMetricStatArgs',
    'ScalingPolicyTargetTrackingMetricStatArgsDict',
    'WarmPoolInstanceReusePolicyArgs',
    'WarmPoolInstanceReusePolicyArgsDict',
]

MYPY = False

if not MYPY:
    class AutoScalingGroupAcceleratorCountRequestArgsDict(TypedDict):
        """
        ``AcceleratorCountRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum number of accelerators for an instance type.
        """
        max: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum value.
        """
        min: NotRequired[pulumi.Input[builtins.int]]
        """
        The minimum value.
        """
elif False:
    AutoScalingGroupAcceleratorCountRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupAcceleratorCountRequestArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[builtins.int]] = None,
                 min: Optional[pulumi.Input[builtins.int]] = None):
        """
        ``AcceleratorCountRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum number of accelerators for an instance type.
        :param pulumi.Input[builtins.int] max: The maximum value.
        :param pulumi.Input[builtins.int] min: The minimum value.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum value.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum value.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min", value)


if not MYPY:
    class AutoScalingGroupAcceleratorTotalMemoryMiBRequestArgsDict(TypedDict):
        """
        ``AcceleratorTotalMemoryMiBRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum total memory size for the accelerators for an instance type, in MiB.
        """
        max: NotRequired[pulumi.Input[builtins.int]]
        """
        The memory maximum in MiB.
        """
        min: NotRequired[pulumi.Input[builtins.int]]
        """
        The memory minimum in MiB.
        """
elif False:
    AutoScalingGroupAcceleratorTotalMemoryMiBRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupAcceleratorTotalMemoryMiBRequestArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[builtins.int]] = None,
                 min: Optional[pulumi.Input[builtins.int]] = None):
        """
        ``AcceleratorTotalMemoryMiBRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum total memory size for the accelerators for an instance type, in MiB.
        :param pulumi.Input[builtins.int] max: The memory maximum in MiB.
        :param pulumi.Input[builtins.int] min: The memory minimum in MiB.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The memory maximum in MiB.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The memory minimum in MiB.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min", value)


if not MYPY:
    class AutoScalingGroupAvailabilityZoneDistributionArgsDict(TypedDict):
        """
        ``AvailabilityZoneDistribution`` is a property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
        """
        capacity_distribution_strategy: NotRequired[pulumi.Input['AutoScalingGroupAvailabilityZoneDistributionCapacityDistributionStrategy']]
        """
        If launches fail in an Availability Zone, the following strategies are available. The default is ``balanced-best-effort``. 
          +   ``balanced-only`` - If launches fail in an Availability Zone, Auto Scaling will continue to attempt to launch in the unhealthy zone to preserve a balanced distribution.
          +   ``balanced-best-effort`` - If launches fail in an Availability Zone, Auto Scaling will attempt to launch in another healthy Availability Zone instead.
        """
elif False:
    AutoScalingGroupAvailabilityZoneDistributionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupAvailabilityZoneDistributionArgs:
    def __init__(__self__, *,
                 capacity_distribution_strategy: Optional[pulumi.Input['AutoScalingGroupAvailabilityZoneDistributionCapacityDistributionStrategy']] = None):
        """
        ``AvailabilityZoneDistribution`` is a property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
        :param pulumi.Input['AutoScalingGroupAvailabilityZoneDistributionCapacityDistributionStrategy'] capacity_distribution_strategy: If launches fail in an Availability Zone, the following strategies are available. The default is ``balanced-best-effort``. 
                 +   ``balanced-only`` - If launches fail in an Availability Zone, Auto Scaling will continue to attempt to launch in the unhealthy zone to preserve a balanced distribution.
                 +   ``balanced-best-effort`` - If launches fail in an Availability Zone, Auto Scaling will attempt to launch in another healthy Availability Zone instead.
        """
        if capacity_distribution_strategy is not None:
            pulumi.set(__self__, "capacity_distribution_strategy", capacity_distribution_strategy)

    @property
    @pulumi.getter(name="capacityDistributionStrategy")
    def capacity_distribution_strategy(self) -> Optional[pulumi.Input['AutoScalingGroupAvailabilityZoneDistributionCapacityDistributionStrategy']]:
        """
        If launches fail in an Availability Zone, the following strategies are available. The default is ``balanced-best-effort``. 
          +   ``balanced-only`` - If launches fail in an Availability Zone, Auto Scaling will continue to attempt to launch in the unhealthy zone to preserve a balanced distribution.
          +   ``balanced-best-effort`` - If launches fail in an Availability Zone, Auto Scaling will attempt to launch in another healthy Availability Zone instead.
        """
        return pulumi.get(self, "capacity_distribution_strategy")

    @capacity_distribution_strategy.setter
    def capacity_distribution_strategy(self, value: Optional[pulumi.Input['AutoScalingGroupAvailabilityZoneDistributionCapacityDistributionStrategy']]):
        pulumi.set(self, "capacity_distribution_strategy", value)


if not MYPY:
    class AutoScalingGroupAvailabilityZoneImpairmentPolicyArgsDict(TypedDict):
        """
        Describes an Availability Zone impairment policy.
        """
        impaired_zone_health_check_behavior: pulumi.Input['AutoScalingGroupAvailabilityZoneImpairmentPolicyImpairedZoneHealthCheckBehavior']
        """
        Specifies the health check behavior for the impaired Availability Zone in an active zonal shift. If you select ``Replace unhealthy``, instances that appear unhealthy will be replaced in all Availability Zones. If you select ``Ignore unhealthy``, instances will not be replaced in the Availability Zone with the active zonal shift. For more information, see [Auto Scaling group zonal shift](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        zonal_shift_enabled: pulumi.Input[builtins.bool]
        """
        If ``true``, enable zonal shift for your Auto Scaling group.
        """
elif False:
    AutoScalingGroupAvailabilityZoneImpairmentPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupAvailabilityZoneImpairmentPolicyArgs:
    def __init__(__self__, *,
                 impaired_zone_health_check_behavior: pulumi.Input['AutoScalingGroupAvailabilityZoneImpairmentPolicyImpairedZoneHealthCheckBehavior'],
                 zonal_shift_enabled: pulumi.Input[builtins.bool]):
        """
        Describes an Availability Zone impairment policy.
        :param pulumi.Input['AutoScalingGroupAvailabilityZoneImpairmentPolicyImpairedZoneHealthCheckBehavior'] impaired_zone_health_check_behavior: Specifies the health check behavior for the impaired Availability Zone in an active zonal shift. If you select ``Replace unhealthy``, instances that appear unhealthy will be replaced in all Availability Zones. If you select ``Ignore unhealthy``, instances will not be replaced in the Availability Zone with the active zonal shift. For more information, see [Auto Scaling group zonal shift](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[builtins.bool] zonal_shift_enabled: If ``true``, enable zonal shift for your Auto Scaling group.
        """
        pulumi.set(__self__, "impaired_zone_health_check_behavior", impaired_zone_health_check_behavior)
        pulumi.set(__self__, "zonal_shift_enabled", zonal_shift_enabled)

    @property
    @pulumi.getter(name="impairedZoneHealthCheckBehavior")
    def impaired_zone_health_check_behavior(self) -> pulumi.Input['AutoScalingGroupAvailabilityZoneImpairmentPolicyImpairedZoneHealthCheckBehavior']:
        """
        Specifies the health check behavior for the impaired Availability Zone in an active zonal shift. If you select ``Replace unhealthy``, instances that appear unhealthy will be replaced in all Availability Zones. If you select ``Ignore unhealthy``, instances will not be replaced in the Availability Zone with the active zonal shift. For more information, see [Auto Scaling group zonal shift](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "impaired_zone_health_check_behavior")

    @impaired_zone_health_check_behavior.setter
    def impaired_zone_health_check_behavior(self, value: pulumi.Input['AutoScalingGroupAvailabilityZoneImpairmentPolicyImpairedZoneHealthCheckBehavior']):
        pulumi.set(self, "impaired_zone_health_check_behavior", value)

    @property
    @pulumi.getter(name="zonalShiftEnabled")
    def zonal_shift_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        If ``true``, enable zonal shift for your Auto Scaling group.
        """
        return pulumi.get(self, "zonal_shift_enabled")

    @zonal_shift_enabled.setter
    def zonal_shift_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "zonal_shift_enabled", value)


if not MYPY:
    class AutoScalingGroupBaselineEbsBandwidthMbpsRequestArgsDict(TypedDict):
        """
        ``BaselineEbsBandwidthMbpsRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum baseline bandwidth performance for an instance type, in Mbps.
        """
        max: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum value in Mbps.
        """
        min: NotRequired[pulumi.Input[builtins.int]]
        """
        The minimum value in Mbps.
        """
elif False:
    AutoScalingGroupBaselineEbsBandwidthMbpsRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupBaselineEbsBandwidthMbpsRequestArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[builtins.int]] = None,
                 min: Optional[pulumi.Input[builtins.int]] = None):
        """
        ``BaselineEbsBandwidthMbpsRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum baseline bandwidth performance for an instance type, in Mbps.
        :param pulumi.Input[builtins.int] max: The maximum value in Mbps.
        :param pulumi.Input[builtins.int] min: The minimum value in Mbps.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum value in Mbps.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum value in Mbps.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min", value)


if not MYPY:
    class AutoScalingGroupBaselinePerformanceFactorsRequestArgsDict(TypedDict):
        """
        The baseline performance to consider, using an instance family as a baseline reference. The instance family establishes the lowest acceptable level of performance. Auto Scaling uses this baseline to guide instance type selection, but there is no guarantee that the selected instance types will always exceed the baseline for every application. 
         Currently, this parameter only supports CPU performance as a baseline performance factor. For example, specifying ``c6i`` uses the CPU performance of the ``c6i`` family as the baseline reference.
        """
        cpu: NotRequired[pulumi.Input['AutoScalingGroupCpuPerformanceFactorRequestArgsDict']]
        """
        The CPU performance to consider, using an instance family as the baseline reference.
        """
elif False:
    AutoScalingGroupBaselinePerformanceFactorsRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupBaselinePerformanceFactorsRequestArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input['AutoScalingGroupCpuPerformanceFactorRequestArgs']] = None):
        """
        The baseline performance to consider, using an instance family as a baseline reference. The instance family establishes the lowest acceptable level of performance. Auto Scaling uses this baseline to guide instance type selection, but there is no guarantee that the selected instance types will always exceed the baseline for every application. 
         Currently, this parameter only supports CPU performance as a baseline performance factor. For example, specifying ``c6i`` uses the CPU performance of the ``c6i`` family as the baseline reference.
        :param pulumi.Input['AutoScalingGroupCpuPerformanceFactorRequestArgs'] cpu: The CPU performance to consider, using an instance family as the baseline reference.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input['AutoScalingGroupCpuPerformanceFactorRequestArgs']]:
        """
        The CPU performance to consider, using an instance family as the baseline reference.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input['AutoScalingGroupCpuPerformanceFactorRequestArgs']]):
        pulumi.set(self, "cpu", value)


if not MYPY:
    class AutoScalingGroupCapacityReservationSpecificationArgsDict(TypedDict):
        """
        Describes the Capacity Reservation preference and targeting options. If you specify ``open`` or ``none`` for ``CapacityReservationPreference``, do not specify a ``CapacityReservationTarget``.
        """
        capacity_reservation_preference: pulumi.Input[builtins.str]
        """
        The capacity reservation preference. The following options are available: 
          +   ``capacity-reservations-only`` - Auto Scaling will only launch instances into a Capacity Reservation or Capacity Reservation resource group. If capacity isn't available, instances will fail to launch.
          +   ``capacity-reservations-first`` - Auto Scaling will try to launch instances into a Capacity Reservation or Capacity Reservation resource group first. If capacity isn't available, instances will run in On-Demand capacity.
          +   ``none`` - Auto Scaling will not launch instances into a Capacity Reservation. Instances will run in On-Demand capacity. 
          +   ``default`` - Auto Scaling uses the Capacity Reservation preference from your launch template or an open Capacity Reservation.
        """
        capacity_reservation_target: NotRequired[pulumi.Input['AutoScalingGroupCapacityReservationTargetArgsDict']]
        """
        Describes a target Capacity Reservation or Capacity Reservation resource group.
        """
elif False:
    AutoScalingGroupCapacityReservationSpecificationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupCapacityReservationSpecificationArgs:
    def __init__(__self__, *,
                 capacity_reservation_preference: pulumi.Input[builtins.str],
                 capacity_reservation_target: Optional[pulumi.Input['AutoScalingGroupCapacityReservationTargetArgs']] = None):
        """
        Describes the Capacity Reservation preference and targeting options. If you specify ``open`` or ``none`` for ``CapacityReservationPreference``, do not specify a ``CapacityReservationTarget``.
        :param pulumi.Input[builtins.str] capacity_reservation_preference: The capacity reservation preference. The following options are available: 
                 +   ``capacity-reservations-only`` - Auto Scaling will only launch instances into a Capacity Reservation or Capacity Reservation resource group. If capacity isn't available, instances will fail to launch.
                 +   ``capacity-reservations-first`` - Auto Scaling will try to launch instances into a Capacity Reservation or Capacity Reservation resource group first. If capacity isn't available, instances will run in On-Demand capacity.
                 +   ``none`` - Auto Scaling will not launch instances into a Capacity Reservation. Instances will run in On-Demand capacity. 
                 +   ``default`` - Auto Scaling uses the Capacity Reservation preference from your launch template or an open Capacity Reservation.
        :param pulumi.Input['AutoScalingGroupCapacityReservationTargetArgs'] capacity_reservation_target: Describes a target Capacity Reservation or Capacity Reservation resource group.
        """
        pulumi.set(__self__, "capacity_reservation_preference", capacity_reservation_preference)
        if capacity_reservation_target is not None:
            pulumi.set(__self__, "capacity_reservation_target", capacity_reservation_target)

    @property
    @pulumi.getter(name="capacityReservationPreference")
    def capacity_reservation_preference(self) -> pulumi.Input[builtins.str]:
        """
        The capacity reservation preference. The following options are available: 
          +   ``capacity-reservations-only`` - Auto Scaling will only launch instances into a Capacity Reservation or Capacity Reservation resource group. If capacity isn't available, instances will fail to launch.
          +   ``capacity-reservations-first`` - Auto Scaling will try to launch instances into a Capacity Reservation or Capacity Reservation resource group first. If capacity isn't available, instances will run in On-Demand capacity.
          +   ``none`` - Auto Scaling will not launch instances into a Capacity Reservation. Instances will run in On-Demand capacity. 
          +   ``default`` - Auto Scaling uses the Capacity Reservation preference from your launch template or an open Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_preference")

    @capacity_reservation_preference.setter
    def capacity_reservation_preference(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "capacity_reservation_preference", value)

    @property
    @pulumi.getter(name="capacityReservationTarget")
    def capacity_reservation_target(self) -> Optional[pulumi.Input['AutoScalingGroupCapacityReservationTargetArgs']]:
        """
        Describes a target Capacity Reservation or Capacity Reservation resource group.
        """
        return pulumi.get(self, "capacity_reservation_target")

    @capacity_reservation_target.setter
    def capacity_reservation_target(self, value: Optional[pulumi.Input['AutoScalingGroupCapacityReservationTargetArgs']]):
        pulumi.set(self, "capacity_reservation_target", value)


if not MYPY:
    class AutoScalingGroupCapacityReservationTargetArgsDict(TypedDict):
        """
        The target for the Capacity Reservation. Specify Capacity Reservations IDs or Capacity Reservation resource group ARNs.
        """
        capacity_reservation_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The Capacity Reservation IDs to launch instances into.
        """
        capacity_reservation_resource_group_arns: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The resource group ARNs of the Capacity Reservation to launch instances into.
        """
elif False:
    AutoScalingGroupCapacityReservationTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupCapacityReservationTargetArgs:
    def __init__(__self__, *,
                 capacity_reservation_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 capacity_reservation_resource_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The target for the Capacity Reservation. Specify Capacity Reservations IDs or Capacity Reservation resource group ARNs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] capacity_reservation_ids: The Capacity Reservation IDs to launch instances into.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] capacity_reservation_resource_group_arns: The resource group ARNs of the Capacity Reservation to launch instances into.
        """
        if capacity_reservation_ids is not None:
            pulumi.set(__self__, "capacity_reservation_ids", capacity_reservation_ids)
        if capacity_reservation_resource_group_arns is not None:
            pulumi.set(__self__, "capacity_reservation_resource_group_arns", capacity_reservation_resource_group_arns)

    @property
    @pulumi.getter(name="capacityReservationIds")
    def capacity_reservation_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The Capacity Reservation IDs to launch instances into.
        """
        return pulumi.get(self, "capacity_reservation_ids")

    @capacity_reservation_ids.setter
    def capacity_reservation_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "capacity_reservation_ids", value)

    @property
    @pulumi.getter(name="capacityReservationResourceGroupArns")
    def capacity_reservation_resource_group_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The resource group ARNs of the Capacity Reservation to launch instances into.
        """
        return pulumi.get(self, "capacity_reservation_resource_group_arns")

    @capacity_reservation_resource_group_arns.setter
    def capacity_reservation_resource_group_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "capacity_reservation_resource_group_arns", value)


if not MYPY:
    class AutoScalingGroupCpuPerformanceFactorRequestArgsDict(TypedDict):
        """
        The CPU performance to consider, using an instance family as the baseline reference.
        """
        references: NotRequired[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupPerformanceFactorReferenceRequestArgsDict']]]]
        """
        Specify an instance family to use as the baseline reference for CPU performance. All instance types that match your specified attributes will be compared against the CPU performance of the referenced instance family, regardless of CPU manufacturer or architecture differences. 
          Currently only one instance family can be specified in the list.
        """
elif False:
    AutoScalingGroupCpuPerformanceFactorRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupCpuPerformanceFactorRequestArgs:
    def __init__(__self__, *,
                 references: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupPerformanceFactorReferenceRequestArgs']]]] = None):
        """
        The CPU performance to consider, using an instance family as the baseline reference.
        :param pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupPerformanceFactorReferenceRequestArgs']]] references: Specify an instance family to use as the baseline reference for CPU performance. All instance types that match your specified attributes will be compared against the CPU performance of the referenced instance family, regardless of CPU manufacturer or architecture differences. 
                 Currently only one instance family can be specified in the list.
        """
        if references is not None:
            pulumi.set(__self__, "references", references)

    @property
    @pulumi.getter
    def references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupPerformanceFactorReferenceRequestArgs']]]]:
        """
        Specify an instance family to use as the baseline reference for CPU performance. All instance types that match your specified attributes will be compared against the CPU performance of the referenced instance family, regardless of CPU manufacturer or architecture differences. 
          Currently only one instance family can be specified in the list.
        """
        return pulumi.get(self, "references")

    @references.setter
    def references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupPerformanceFactorReferenceRequestArgs']]]]):
        pulumi.set(self, "references", value)


if not MYPY:
    class AutoScalingGroupInstanceMaintenancePolicyArgsDict(TypedDict):
        """
        ``InstanceMaintenancePolicy`` is a property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
         For more information, see [Instance maintenance policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        max_healthy_percentage: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the upper threshold as a percentage of the desired capacity of the Auto Scaling group. It represents the maximum percentage of the group that can be in service and healthy, or pending, to support your workload when replacing instances. Value range is 100 to 200. To clear a previously set value, specify a value of ``-1``.
         Both ``MinHealthyPercentage`` and ``MaxHealthyPercentage`` must be specified, and the difference between them cannot be greater than 100. A large range increases the number of instances that can be replaced at the same time.
        """
        min_healthy_percentage: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the lower threshold as a percentage of the desired capacity of the Auto Scaling group. It represents the minimum percentage of the group to keep in service, healthy, and ready to use to support your workload when replacing instances. Value range is 0 to 100. To clear a previously set value, specify a value of ``-1``.
        """
elif False:
    AutoScalingGroupInstanceMaintenancePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupInstanceMaintenancePolicyArgs:
    def __init__(__self__, *,
                 max_healthy_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 min_healthy_percentage: Optional[pulumi.Input[builtins.int]] = None):
        """
        ``InstanceMaintenancePolicy`` is a property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
         For more information, see [Instance maintenance policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[builtins.int] max_healthy_percentage: Specifies the upper threshold as a percentage of the desired capacity of the Auto Scaling group. It represents the maximum percentage of the group that can be in service and healthy, or pending, to support your workload when replacing instances. Value range is 100 to 200. To clear a previously set value, specify a value of ``-1``.
                Both ``MinHealthyPercentage`` and ``MaxHealthyPercentage`` must be specified, and the difference between them cannot be greater than 100. A large range increases the number of instances that can be replaced at the same time.
        :param pulumi.Input[builtins.int] min_healthy_percentage: Specifies the lower threshold as a percentage of the desired capacity of the Auto Scaling group. It represents the minimum percentage of the group to keep in service, healthy, and ready to use to support your workload when replacing instances. Value range is 0 to 100. To clear a previously set value, specify a value of ``-1``.
        """
        if max_healthy_percentage is not None:
            pulumi.set(__self__, "max_healthy_percentage", max_healthy_percentage)
        if min_healthy_percentage is not None:
            pulumi.set(__self__, "min_healthy_percentage", min_healthy_percentage)

    @property
    @pulumi.getter(name="maxHealthyPercentage")
    def max_healthy_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the upper threshold as a percentage of the desired capacity of the Auto Scaling group. It represents the maximum percentage of the group that can be in service and healthy, or pending, to support your workload when replacing instances. Value range is 100 to 200. To clear a previously set value, specify a value of ``-1``.
         Both ``MinHealthyPercentage`` and ``MaxHealthyPercentage`` must be specified, and the difference between them cannot be greater than 100. A large range increases the number of instances that can be replaced at the same time.
        """
        return pulumi.get(self, "max_healthy_percentage")

    @max_healthy_percentage.setter
    def max_healthy_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_healthy_percentage", value)

    @property
    @pulumi.getter(name="minHealthyPercentage")
    def min_healthy_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the lower threshold as a percentage of the desired capacity of the Auto Scaling group. It represents the minimum percentage of the group to keep in service, healthy, and ready to use to support your workload when replacing instances. Value range is 0 to 100. To clear a previously set value, specify a value of ``-1``.
        """
        return pulumi.get(self, "min_healthy_percentage")

    @min_healthy_percentage.setter
    def min_healthy_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_healthy_percentage", value)


if not MYPY:
    class AutoScalingGroupInstanceRequirementsArgsDict(TypedDict):
        """
        The attributes for the instance types for a mixed instances policy. Amazon EC2 Auto Scaling uses your specified requirements to identify instance types. Then, it uses your On-Demand and Spot allocation strategies to launch instances from these instance types.
         When you specify multiple attributes, you get instance types that satisfy all of the specified attributes. If you specify multiple values for an attribute, you get instance types that satisfy any of the specified values.
         To limit the list of instance types from which Amazon EC2 Auto Scaling can identify matching instance types, you can use one of the following parameters, but not both in the same request:
          +   ``AllowedInstanceTypes`` - The instance types to include in the list. All other instance types are ignored, even if they match your specified attributes.
          +   ``ExcludedInstanceTypes`` - The instance types to exclude from the list, even if they match your specified attributes.
          
          You must specify ``VCpuCount`` and ``MemoryMiB``. All other attributes are optional. Any unspecified optional attribute is set to its default.
          For an example template, see [Configure Amazon EC2 Auto Scaling resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-ec2-auto-scaling.html).
         For more information, see [Creating an Auto Scaling group using attribute-based instance type selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html) in the *Amazon EC2 Auto Scaling User Guide*. For help determining which instance types match your attributes before you apply them to your Auto Scaling group, see [Preview instance types with specified attributes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html#ec2fleet-get-instance-types-from-instance-requirements) in the *Amazon EC2 User Guide for Linux Instances*.
          ``InstanceRequirements`` is a property of the ``LaunchTemplateOverrides`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplate.html) property type.
        """
        memory_mi_b: pulumi.Input['AutoScalingGroupMemoryMiBRequestArgsDict']
        """
        The minimum and maximum instance memory size for an instance type, in MiB.
        """
        v_cpu_count: pulumi.Input['AutoScalingGroupVCpuCountRequestArgsDict']
        """
        The minimum and maximum number of vCPUs for an instance type.
        """
        accelerator_count: NotRequired[pulumi.Input['AutoScalingGroupAcceleratorCountRequestArgsDict']]
        """
        The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) for an instance type.
         To exclude accelerator-enabled instance types, set ``Max`` to ``0``.
         Default: No minimum or maximum limits
        """
        accelerator_manufacturers: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Indicates whether instance types must have accelerators by specific manufacturers.
          +  For instance types with NVIDIA devices, specify ``nvidia``.
          +  For instance types with AMD devices, specify ``amd``.
          +  For instance types with AWS devices, specify ``amazon-web-services``.
          +  For instance types with Xilinx devices, specify ``xilinx``.
          
         Default: Any manufacturer
        """
        accelerator_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Lists the accelerators that must be on an instance type.
          +  For instance types with NVIDIA A100 GPUs, specify ``a100``.
          +  For instance types with NVIDIA V100 GPUs, specify ``v100``.
          +  For instance types with NVIDIA K80 GPUs, specify ``k80``.
          +  For instance types with NVIDIA T4 GPUs, specify ``t4``.
          +  For instance types with NVIDIA M60 GPUs, specify ``m60``.
          +  For instance types with AMD Radeon Pro V520 GPUs, specify ``radeon-pro-v520``.
          +  For instance types with Xilinx VU9P FPGAs, specify ``vu9p``.
          
         Default: Any accelerator
        """
        accelerator_total_memory_mi_b: NotRequired[pulumi.Input['AutoScalingGroupAcceleratorTotalMemoryMiBRequestArgsDict']]
        """
        The minimum and maximum total memory size for the accelerators on an instance type, in MiB.
         Default: No minimum or maximum limits
        """
        accelerator_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Lists the accelerator types that must be on an instance type.
          +  For instance types with GPU accelerators, specify ``gpu``.
          +  For instance types with FPGA accelerators, specify ``fpga``.
          +  For instance types with inference accelerators, specify ``inference``.
          
         Default: Any accelerator type
        """
        allowed_instance_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes.
         You can use strings with one or more wild cards, represented by an asterisk (``*``), to allow an instance type, size, or generation. The following are examples: ``m5.8xlarge``, ``c5*.*``, ``m5a.*``, ``r*``, ``*3*``.
         For example, if you specify ``c5*``, Amazon EC2 Auto Scaling will allow the entire C5 instance family, which includes all C5a and C5n instance types. If you specify ``m5a.*``, Amazon EC2 Auto Scaling will allow all the M5a instance types, but not the M5n instance types.
          If you specify ``AllowedInstanceTypes``, you can't specify ``ExcludedInstanceTypes``.
          Default: All instance types
        """
        bare_metal: NotRequired[pulumi.Input[builtins.str]]
        """
        Indicates whether bare metal instance types are included, excluded, or required.
         Default: ``excluded``
        """
        baseline_ebs_bandwidth_mbps: NotRequired[pulumi.Input['AutoScalingGroupBaselineEbsBandwidthMbpsRequestArgsDict']]
        """
        The minimum and maximum baseline bandwidth performance for an instance type, in Mbps. For more information, see [Amazon EBS–optimized instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html) in the *Amazon EC2 User Guide for Linux Instances*.
         Default: No minimum or maximum limits
        """
        baseline_performance_factors: NotRequired[pulumi.Input['AutoScalingGroupBaselinePerformanceFactorsRequestArgsDict']]
        """
        The baseline performance factors for the instance requirements.
        """
        burstable_performance: NotRequired[pulumi.Input[builtins.str]]
        """
        Indicates whether burstable performance instance types are included, excluded, or required. For more information, see [Burstable performance instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html) in the *Amazon EC2 User Guide for Linux Instances*.
         Default: ``excluded``
        """
        cpu_manufacturers: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Lists which specific CPU manufacturers to include.
          +  For instance types with Intel CPUs, specify ``intel``.
          +  For instance types with AMD CPUs, specify ``amd``.
          +  For instance types with AWS CPUs, specify ``amazon-web-services``.
          
          Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template. 
          Default: Any manufacturer
        """
        excluded_instance_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (``*``), to exclude an instance family, type, size, or generation. The following are examples: ``m5.8xlarge``, ``c5*.*``, ``m5a.*``, ``r*``, ``*3*``. 
         For example, if you specify ``c5*``, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify ``m5a.*``, Amazon EC2 Auto Scaling will exclude all the M5a instance types, but not the M5n instance types.
          If you specify ``ExcludedInstanceTypes``, you can't specify ``AllowedInstanceTypes``.
          Default: No excluded instance types
        """
        instance_generations: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Indicates whether current or previous generation instance types are included.
          +  For current generation instance types, specify ``current``. The current generation includes EC2 instance types currently recommended for use. This typically includes the latest two to three generations in each instance family. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide for Linux Instances*.
          +  For previous generation instance types, specify ``previous``.
          
         Default: Any current or previous generation
        """
        local_storage: NotRequired[pulumi.Input[builtins.str]]
        """
        Indicates whether instance types with instance store volumes are included, excluded, or required. For more information, see [Amazon EC2 instance store](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html) in the *Amazon EC2 User Guide for Linux Instances*.
         Default: ``included``
        """
        local_storage_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Indicates the type of local storage that is required.
          +  For instance types with hard disk drive (HDD) storage, specify ``hdd``.
          +  For instance types with solid state drive (SSD) storage, specify ``ssd``.
          
         Default: Any local storage type
        """
        max_spot_price_as_percentage_of_optimal_on_demand_price: NotRequired[pulumi.Input[builtins.int]]
        """
        [Price protection] The price protection threshold for Spot Instances, as a percentage of an identified On-Demand price. The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold.
         The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage.
         If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is based on the per-vCPU or per-memory price instead of the per instance price. 
          Only one of ``SpotMaxPricePercentageOverLowestPrice`` or ``MaxSpotPriceAsPercentageOfOptimalOnDemandPrice`` can be specified. If you don't specify either, Amazon EC2 Auto Scaling will automatically apply optimal price protection to consistently select from a wide range of instance types. To indicate no price protection threshold for Spot Instances, meaning you want to consider all instance types that match your attributes, include one of these parameters and specify a high value, such as ``999999``.
        """
        memory_gi_b_per_v_cpu: NotRequired[pulumi.Input['AutoScalingGroupMemoryGiBPerVCpuRequestArgsDict']]
        """
        The minimum and maximum amount of memory per vCPU for an instance type, in GiB.
         Default: No minimum or maximum limits
        """
        network_bandwidth_gbps: NotRequired[pulumi.Input['AutoScalingGroupNetworkBandwidthGbpsRequestArgsDict']]
        """
        The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps).
         Default: No minimum or maximum limits
        """
        network_interface_count: NotRequired[pulumi.Input['AutoScalingGroupNetworkInterfaceCountRequestArgsDict']]
        """
        The minimum and maximum number of network interfaces for an instance type.
         Default: No minimum or maximum limits
        """
        on_demand_max_price_percentage_over_lowest_price: NotRequired[pulumi.Input[builtins.int]]
        """
        [Price protection] The price protection threshold for On-Demand Instances, as a percentage higher than an identified On-Demand price. The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold. 
         The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage.
         To turn off price protection, specify a high value, such as ``999999``. 
         If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per instance price. 
         Default: ``20``
        """
        require_hibernate_support: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether instance types must provide On-Demand Instance hibernation support.
         Default: ``false``
        """
        spot_max_price_percentage_over_lowest_price: NotRequired[pulumi.Input[builtins.int]]
        """
        [Price protection] The price protection threshold for Spot Instances, as a percentage higher than an identified Spot price. The identified Spot price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold.
         The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. 
         If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is based on the per-vCPU or per-memory price instead of the per instance price. 
          Only one of ``SpotMaxPricePercentageOverLowestPrice`` or ``MaxSpotPriceAsPercentageOfOptimalOnDemandPrice`` can be specified. If you don't specify either, Amazon EC2 Auto Scaling will automatically apply optimal price protection to consistently select from a wide range of instance types. To indicate no price protection threshold for Spot Instances, meaning you want to consider all instance types that match your attributes, include one of these parameters and specify a high value, such as ``999999``.
        """
        total_local_storage_gb: NotRequired[pulumi.Input['AutoScalingGroupTotalLocalStorageGbRequestArgsDict']]
        """
        The minimum and maximum total local storage size for an instance type, in GB.
         Default: No minimum or maximum limits
        """
elif False:
    AutoScalingGroupInstanceRequirementsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupInstanceRequirementsArgs:
    def __init__(__self__, *,
                 memory_mi_b: pulumi.Input['AutoScalingGroupMemoryMiBRequestArgs'],
                 v_cpu_count: pulumi.Input['AutoScalingGroupVCpuCountRequestArgs'],
                 accelerator_count: Optional[pulumi.Input['AutoScalingGroupAcceleratorCountRequestArgs']] = None,
                 accelerator_manufacturers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 accelerator_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 accelerator_total_memory_mi_b: Optional[pulumi.Input['AutoScalingGroupAcceleratorTotalMemoryMiBRequestArgs']] = None,
                 accelerator_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allowed_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 bare_metal: Optional[pulumi.Input[builtins.str]] = None,
                 baseline_ebs_bandwidth_mbps: Optional[pulumi.Input['AutoScalingGroupBaselineEbsBandwidthMbpsRequestArgs']] = None,
                 baseline_performance_factors: Optional[pulumi.Input['AutoScalingGroupBaselinePerformanceFactorsRequestArgs']] = None,
                 burstable_performance: Optional[pulumi.Input[builtins.str]] = None,
                 cpu_manufacturers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 excluded_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 instance_generations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 local_storage: Optional[pulumi.Input[builtins.str]] = None,
                 local_storage_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 max_spot_price_as_percentage_of_optimal_on_demand_price: Optional[pulumi.Input[builtins.int]] = None,
                 memory_gi_b_per_v_cpu: Optional[pulumi.Input['AutoScalingGroupMemoryGiBPerVCpuRequestArgs']] = None,
                 network_bandwidth_gbps: Optional[pulumi.Input['AutoScalingGroupNetworkBandwidthGbpsRequestArgs']] = None,
                 network_interface_count: Optional[pulumi.Input['AutoScalingGroupNetworkInterfaceCountRequestArgs']] = None,
                 on_demand_max_price_percentage_over_lowest_price: Optional[pulumi.Input[builtins.int]] = None,
                 require_hibernate_support: Optional[pulumi.Input[builtins.bool]] = None,
                 spot_max_price_percentage_over_lowest_price: Optional[pulumi.Input[builtins.int]] = None,
                 total_local_storage_gb: Optional[pulumi.Input['AutoScalingGroupTotalLocalStorageGbRequestArgs']] = None):
        """
        The attributes for the instance types for a mixed instances policy. Amazon EC2 Auto Scaling uses your specified requirements to identify instance types. Then, it uses your On-Demand and Spot allocation strategies to launch instances from these instance types.
         When you specify multiple attributes, you get instance types that satisfy all of the specified attributes. If you specify multiple values for an attribute, you get instance types that satisfy any of the specified values.
         To limit the list of instance types from which Amazon EC2 Auto Scaling can identify matching instance types, you can use one of the following parameters, but not both in the same request:
          +   ``AllowedInstanceTypes`` - The instance types to include in the list. All other instance types are ignored, even if they match your specified attributes.
          +   ``ExcludedInstanceTypes`` - The instance types to exclude from the list, even if they match your specified attributes.
          
          You must specify ``VCpuCount`` and ``MemoryMiB``. All other attributes are optional. Any unspecified optional attribute is set to its default.
          For an example template, see [Configure Amazon EC2 Auto Scaling resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-ec2-auto-scaling.html).
         For more information, see [Creating an Auto Scaling group using attribute-based instance type selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html) in the *Amazon EC2 Auto Scaling User Guide*. For help determining which instance types match your attributes before you apply them to your Auto Scaling group, see [Preview instance types with specified attributes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html#ec2fleet-get-instance-types-from-instance-requirements) in the *Amazon EC2 User Guide for Linux Instances*.
          ``InstanceRequirements`` is a property of the ``LaunchTemplateOverrides`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplate.html) property type.
        :param pulumi.Input['AutoScalingGroupMemoryMiBRequestArgs'] memory_mi_b: The minimum and maximum instance memory size for an instance type, in MiB.
        :param pulumi.Input['AutoScalingGroupVCpuCountRequestArgs'] v_cpu_count: The minimum and maximum number of vCPUs for an instance type.
        :param pulumi.Input['AutoScalingGroupAcceleratorCountRequestArgs'] accelerator_count: The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) for an instance type.
                To exclude accelerator-enabled instance types, set ``Max`` to ``0``.
                Default: No minimum or maximum limits
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] accelerator_manufacturers: Indicates whether instance types must have accelerators by specific manufacturers.
                 +  For instance types with NVIDIA devices, specify ``nvidia``.
                 +  For instance types with AMD devices, specify ``amd``.
                 +  For instance types with AWS devices, specify ``amazon-web-services``.
                 +  For instance types with Xilinx devices, specify ``xilinx``.
                 
                Default: Any manufacturer
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] accelerator_names: Lists the accelerators that must be on an instance type.
                 +  For instance types with NVIDIA A100 GPUs, specify ``a100``.
                 +  For instance types with NVIDIA V100 GPUs, specify ``v100``.
                 +  For instance types with NVIDIA K80 GPUs, specify ``k80``.
                 +  For instance types with NVIDIA T4 GPUs, specify ``t4``.
                 +  For instance types with NVIDIA M60 GPUs, specify ``m60``.
                 +  For instance types with AMD Radeon Pro V520 GPUs, specify ``radeon-pro-v520``.
                 +  For instance types with Xilinx VU9P FPGAs, specify ``vu9p``.
                 
                Default: Any accelerator
        :param pulumi.Input['AutoScalingGroupAcceleratorTotalMemoryMiBRequestArgs'] accelerator_total_memory_mi_b: The minimum and maximum total memory size for the accelerators on an instance type, in MiB.
                Default: No minimum or maximum limits
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] accelerator_types: Lists the accelerator types that must be on an instance type.
                 +  For instance types with GPU accelerators, specify ``gpu``.
                 +  For instance types with FPGA accelerators, specify ``fpga``.
                 +  For instance types with inference accelerators, specify ``inference``.
                 
                Default: Any accelerator type
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_instance_types: The instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes.
                You can use strings with one or more wild cards, represented by an asterisk (``*``), to allow an instance type, size, or generation. The following are examples: ``m5.8xlarge``, ``c5*.*``, ``m5a.*``, ``r*``, ``*3*``.
                For example, if you specify ``c5*``, Amazon EC2 Auto Scaling will allow the entire C5 instance family, which includes all C5a and C5n instance types. If you specify ``m5a.*``, Amazon EC2 Auto Scaling will allow all the M5a instance types, but not the M5n instance types.
                 If you specify ``AllowedInstanceTypes``, you can't specify ``ExcludedInstanceTypes``.
                 Default: All instance types
        :param pulumi.Input[builtins.str] bare_metal: Indicates whether bare metal instance types are included, excluded, or required.
                Default: ``excluded``
        :param pulumi.Input['AutoScalingGroupBaselineEbsBandwidthMbpsRequestArgs'] baseline_ebs_bandwidth_mbps: The minimum and maximum baseline bandwidth performance for an instance type, in Mbps. For more information, see [Amazon EBS–optimized instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html) in the *Amazon EC2 User Guide for Linux Instances*.
                Default: No minimum or maximum limits
        :param pulumi.Input['AutoScalingGroupBaselinePerformanceFactorsRequestArgs'] baseline_performance_factors: The baseline performance factors for the instance requirements.
        :param pulumi.Input[builtins.str] burstable_performance: Indicates whether burstable performance instance types are included, excluded, or required. For more information, see [Burstable performance instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html) in the *Amazon EC2 User Guide for Linux Instances*.
                Default: ``excluded``
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cpu_manufacturers: Lists which specific CPU manufacturers to include.
                 +  For instance types with Intel CPUs, specify ``intel``.
                 +  For instance types with AMD CPUs, specify ``amd``.
                 +  For instance types with AWS CPUs, specify ``amazon-web-services``.
                 
                 Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template. 
                 Default: Any manufacturer
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] excluded_instance_types: The instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (``*``), to exclude an instance family, type, size, or generation. The following are examples: ``m5.8xlarge``, ``c5*.*``, ``m5a.*``, ``r*``, ``*3*``. 
                For example, if you specify ``c5*``, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify ``m5a.*``, Amazon EC2 Auto Scaling will exclude all the M5a instance types, but not the M5n instance types.
                 If you specify ``ExcludedInstanceTypes``, you can't specify ``AllowedInstanceTypes``.
                 Default: No excluded instance types
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_generations: Indicates whether current or previous generation instance types are included.
                 +  For current generation instance types, specify ``current``. The current generation includes EC2 instance types currently recommended for use. This typically includes the latest two to three generations in each instance family. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide for Linux Instances*.
                 +  For previous generation instance types, specify ``previous``.
                 
                Default: Any current or previous generation
        :param pulumi.Input[builtins.str] local_storage: Indicates whether instance types with instance store volumes are included, excluded, or required. For more information, see [Amazon EC2 instance store](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html) in the *Amazon EC2 User Guide for Linux Instances*.
                Default: ``included``
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] local_storage_types: Indicates the type of local storage that is required.
                 +  For instance types with hard disk drive (HDD) storage, specify ``hdd``.
                 +  For instance types with solid state drive (SSD) storage, specify ``ssd``.
                 
                Default: Any local storage type
        :param pulumi.Input[builtins.int] max_spot_price_as_percentage_of_optimal_on_demand_price: [Price protection] The price protection threshold for Spot Instances, as a percentage of an identified On-Demand price. The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold.
                The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage.
                If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is based on the per-vCPU or per-memory price instead of the per instance price. 
                 Only one of ``SpotMaxPricePercentageOverLowestPrice`` or ``MaxSpotPriceAsPercentageOfOptimalOnDemandPrice`` can be specified. If you don't specify either, Amazon EC2 Auto Scaling will automatically apply optimal price protection to consistently select from a wide range of instance types. To indicate no price protection threshold for Spot Instances, meaning you want to consider all instance types that match your attributes, include one of these parameters and specify a high value, such as ``999999``.
        :param pulumi.Input['AutoScalingGroupMemoryGiBPerVCpuRequestArgs'] memory_gi_b_per_v_cpu: The minimum and maximum amount of memory per vCPU for an instance type, in GiB.
                Default: No minimum or maximum limits
        :param pulumi.Input['AutoScalingGroupNetworkBandwidthGbpsRequestArgs'] network_bandwidth_gbps: The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps).
                Default: No minimum or maximum limits
        :param pulumi.Input['AutoScalingGroupNetworkInterfaceCountRequestArgs'] network_interface_count: The minimum and maximum number of network interfaces for an instance type.
                Default: No minimum or maximum limits
        :param pulumi.Input[builtins.int] on_demand_max_price_percentage_over_lowest_price: [Price protection] The price protection threshold for On-Demand Instances, as a percentage higher than an identified On-Demand price. The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold. 
                The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage.
                To turn off price protection, specify a high value, such as ``999999``. 
                If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per instance price. 
                Default: ``20``
        :param pulumi.Input[builtins.bool] require_hibernate_support: Indicates whether instance types must provide On-Demand Instance hibernation support.
                Default: ``false``
        :param pulumi.Input[builtins.int] spot_max_price_percentage_over_lowest_price: [Price protection] The price protection threshold for Spot Instances, as a percentage higher than an identified Spot price. The identified Spot price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold.
                The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. 
                If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is based on the per-vCPU or per-memory price instead of the per instance price. 
                 Only one of ``SpotMaxPricePercentageOverLowestPrice`` or ``MaxSpotPriceAsPercentageOfOptimalOnDemandPrice`` can be specified. If you don't specify either, Amazon EC2 Auto Scaling will automatically apply optimal price protection to consistently select from a wide range of instance types. To indicate no price protection threshold for Spot Instances, meaning you want to consider all instance types that match your attributes, include one of these parameters and specify a high value, such as ``999999``.
        :param pulumi.Input['AutoScalingGroupTotalLocalStorageGbRequestArgs'] total_local_storage_gb: The minimum and maximum total local storage size for an instance type, in GB.
                Default: No minimum or maximum limits
        """
        pulumi.set(__self__, "memory_mi_b", memory_mi_b)
        pulumi.set(__self__, "v_cpu_count", v_cpu_count)
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_manufacturers is not None:
            pulumi.set(__self__, "accelerator_manufacturers", accelerator_manufacturers)
        if accelerator_names is not None:
            pulumi.set(__self__, "accelerator_names", accelerator_names)
        if accelerator_total_memory_mi_b is not None:
            pulumi.set(__self__, "accelerator_total_memory_mi_b", accelerator_total_memory_mi_b)
        if accelerator_types is not None:
            pulumi.set(__self__, "accelerator_types", accelerator_types)
        if allowed_instance_types is not None:
            pulumi.set(__self__, "allowed_instance_types", allowed_instance_types)
        if bare_metal is not None:
            pulumi.set(__self__, "bare_metal", bare_metal)
        if baseline_ebs_bandwidth_mbps is not None:
            pulumi.set(__self__, "baseline_ebs_bandwidth_mbps", baseline_ebs_bandwidth_mbps)
        if baseline_performance_factors is not None:
            pulumi.set(__self__, "baseline_performance_factors", baseline_performance_factors)
        if burstable_performance is not None:
            pulumi.set(__self__, "burstable_performance", burstable_performance)
        if cpu_manufacturers is not None:
            pulumi.set(__self__, "cpu_manufacturers", cpu_manufacturers)
        if excluded_instance_types is not None:
            pulumi.set(__self__, "excluded_instance_types", excluded_instance_types)
        if instance_generations is not None:
            pulumi.set(__self__, "instance_generations", instance_generations)
        if local_storage is not None:
            pulumi.set(__self__, "local_storage", local_storage)
        if local_storage_types is not None:
            pulumi.set(__self__, "local_storage_types", local_storage_types)
        if max_spot_price_as_percentage_of_optimal_on_demand_price is not None:
            pulumi.set(__self__, "max_spot_price_as_percentage_of_optimal_on_demand_price", max_spot_price_as_percentage_of_optimal_on_demand_price)
        if memory_gi_b_per_v_cpu is not None:
            pulumi.set(__self__, "memory_gi_b_per_v_cpu", memory_gi_b_per_v_cpu)
        if network_bandwidth_gbps is not None:
            pulumi.set(__self__, "network_bandwidth_gbps", network_bandwidth_gbps)
        if network_interface_count is not None:
            pulumi.set(__self__, "network_interface_count", network_interface_count)
        if on_demand_max_price_percentage_over_lowest_price is not None:
            pulumi.set(__self__, "on_demand_max_price_percentage_over_lowest_price", on_demand_max_price_percentage_over_lowest_price)
        if require_hibernate_support is not None:
            pulumi.set(__self__, "require_hibernate_support", require_hibernate_support)
        if spot_max_price_percentage_over_lowest_price is not None:
            pulumi.set(__self__, "spot_max_price_percentage_over_lowest_price", spot_max_price_percentage_over_lowest_price)
        if total_local_storage_gb is not None:
            pulumi.set(__self__, "total_local_storage_gb", total_local_storage_gb)

    @property
    @pulumi.getter(name="memoryMiB")
    def memory_mi_b(self) -> pulumi.Input['AutoScalingGroupMemoryMiBRequestArgs']:
        """
        The minimum and maximum instance memory size for an instance type, in MiB.
        """
        return pulumi.get(self, "memory_mi_b")

    @memory_mi_b.setter
    def memory_mi_b(self, value: pulumi.Input['AutoScalingGroupMemoryMiBRequestArgs']):
        pulumi.set(self, "memory_mi_b", value)

    @property
    @pulumi.getter(name="vCpuCount")
    def v_cpu_count(self) -> pulumi.Input['AutoScalingGroupVCpuCountRequestArgs']:
        """
        The minimum and maximum number of vCPUs for an instance type.
        """
        return pulumi.get(self, "v_cpu_count")

    @v_cpu_count.setter
    def v_cpu_count(self, value: pulumi.Input['AutoScalingGroupVCpuCountRequestArgs']):
        pulumi.set(self, "v_cpu_count", value)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[pulumi.Input['AutoScalingGroupAcceleratorCountRequestArgs']]:
        """
        The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) for an instance type.
         To exclude accelerator-enabled instance types, set ``Max`` to ``0``.
         Default: No minimum or maximum limits
        """
        return pulumi.get(self, "accelerator_count")

    @accelerator_count.setter
    def accelerator_count(self, value: Optional[pulumi.Input['AutoScalingGroupAcceleratorCountRequestArgs']]):
        pulumi.set(self, "accelerator_count", value)

    @property
    @pulumi.getter(name="acceleratorManufacturers")
    def accelerator_manufacturers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Indicates whether instance types must have accelerators by specific manufacturers.
          +  For instance types with NVIDIA devices, specify ``nvidia``.
          +  For instance types with AMD devices, specify ``amd``.
          +  For instance types with AWS devices, specify ``amazon-web-services``.
          +  For instance types with Xilinx devices, specify ``xilinx``.
          
         Default: Any manufacturer
        """
        return pulumi.get(self, "accelerator_manufacturers")

    @accelerator_manufacturers.setter
    def accelerator_manufacturers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "accelerator_manufacturers", value)

    @property
    @pulumi.getter(name="acceleratorNames")
    def accelerator_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Lists the accelerators that must be on an instance type.
          +  For instance types with NVIDIA A100 GPUs, specify ``a100``.
          +  For instance types with NVIDIA V100 GPUs, specify ``v100``.
          +  For instance types with NVIDIA K80 GPUs, specify ``k80``.
          +  For instance types with NVIDIA T4 GPUs, specify ``t4``.
          +  For instance types with NVIDIA M60 GPUs, specify ``m60``.
          +  For instance types with AMD Radeon Pro V520 GPUs, specify ``radeon-pro-v520``.
          +  For instance types with Xilinx VU9P FPGAs, specify ``vu9p``.
          
         Default: Any accelerator
        """
        return pulumi.get(self, "accelerator_names")

    @accelerator_names.setter
    def accelerator_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "accelerator_names", value)

    @property
    @pulumi.getter(name="acceleratorTotalMemoryMiB")
    def accelerator_total_memory_mi_b(self) -> Optional[pulumi.Input['AutoScalingGroupAcceleratorTotalMemoryMiBRequestArgs']]:
        """
        The minimum and maximum total memory size for the accelerators on an instance type, in MiB.
         Default: No minimum or maximum limits
        """
        return pulumi.get(self, "accelerator_total_memory_mi_b")

    @accelerator_total_memory_mi_b.setter
    def accelerator_total_memory_mi_b(self, value: Optional[pulumi.Input['AutoScalingGroupAcceleratorTotalMemoryMiBRequestArgs']]):
        pulumi.set(self, "accelerator_total_memory_mi_b", value)

    @property
    @pulumi.getter(name="acceleratorTypes")
    def accelerator_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Lists the accelerator types that must be on an instance type.
          +  For instance types with GPU accelerators, specify ``gpu``.
          +  For instance types with FPGA accelerators, specify ``fpga``.
          +  For instance types with inference accelerators, specify ``inference``.
          
         Default: Any accelerator type
        """
        return pulumi.get(self, "accelerator_types")

    @accelerator_types.setter
    def accelerator_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "accelerator_types", value)

    @property
    @pulumi.getter(name="allowedInstanceTypes")
    def allowed_instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes.
         You can use strings with one or more wild cards, represented by an asterisk (``*``), to allow an instance type, size, or generation. The following are examples: ``m5.8xlarge``, ``c5*.*``, ``m5a.*``, ``r*``, ``*3*``.
         For example, if you specify ``c5*``, Amazon EC2 Auto Scaling will allow the entire C5 instance family, which includes all C5a and C5n instance types. If you specify ``m5a.*``, Amazon EC2 Auto Scaling will allow all the M5a instance types, but not the M5n instance types.
          If you specify ``AllowedInstanceTypes``, you can't specify ``ExcludedInstanceTypes``.
          Default: All instance types
        """
        return pulumi.get(self, "allowed_instance_types")

    @allowed_instance_types.setter
    def allowed_instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_instance_types", value)

    @property
    @pulumi.getter(name="bareMetal")
    def bare_metal(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether bare metal instance types are included, excluded, or required.
         Default: ``excluded``
        """
        return pulumi.get(self, "bare_metal")

    @bare_metal.setter
    def bare_metal(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bare_metal", value)

    @property
    @pulumi.getter(name="baselineEbsBandwidthMbps")
    def baseline_ebs_bandwidth_mbps(self) -> Optional[pulumi.Input['AutoScalingGroupBaselineEbsBandwidthMbpsRequestArgs']]:
        """
        The minimum and maximum baseline bandwidth performance for an instance type, in Mbps. For more information, see [Amazon EBS–optimized instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html) in the *Amazon EC2 User Guide for Linux Instances*.
         Default: No minimum or maximum limits
        """
        return pulumi.get(self, "baseline_ebs_bandwidth_mbps")

    @baseline_ebs_bandwidth_mbps.setter
    def baseline_ebs_bandwidth_mbps(self, value: Optional[pulumi.Input['AutoScalingGroupBaselineEbsBandwidthMbpsRequestArgs']]):
        pulumi.set(self, "baseline_ebs_bandwidth_mbps", value)

    @property
    @pulumi.getter(name="baselinePerformanceFactors")
    def baseline_performance_factors(self) -> Optional[pulumi.Input['AutoScalingGroupBaselinePerformanceFactorsRequestArgs']]:
        """
        The baseline performance factors for the instance requirements.
        """
        return pulumi.get(self, "baseline_performance_factors")

    @baseline_performance_factors.setter
    def baseline_performance_factors(self, value: Optional[pulumi.Input['AutoScalingGroupBaselinePerformanceFactorsRequestArgs']]):
        pulumi.set(self, "baseline_performance_factors", value)

    @property
    @pulumi.getter(name="burstablePerformance")
    def burstable_performance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether burstable performance instance types are included, excluded, or required. For more information, see [Burstable performance instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html) in the *Amazon EC2 User Guide for Linux Instances*.
         Default: ``excluded``
        """
        return pulumi.get(self, "burstable_performance")

    @burstable_performance.setter
    def burstable_performance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "burstable_performance", value)

    @property
    @pulumi.getter(name="cpuManufacturers")
    def cpu_manufacturers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Lists which specific CPU manufacturers to include.
          +  For instance types with Intel CPUs, specify ``intel``.
          +  For instance types with AMD CPUs, specify ``amd``.
          +  For instance types with AWS CPUs, specify ``amazon-web-services``.
          
          Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template. 
          Default: Any manufacturer
        """
        return pulumi.get(self, "cpu_manufacturers")

    @cpu_manufacturers.setter
    def cpu_manufacturers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cpu_manufacturers", value)

    @property
    @pulumi.getter(name="excludedInstanceTypes")
    def excluded_instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (``*``), to exclude an instance family, type, size, or generation. The following are examples: ``m5.8xlarge``, ``c5*.*``, ``m5a.*``, ``r*``, ``*3*``. 
         For example, if you specify ``c5*``, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify ``m5a.*``, Amazon EC2 Auto Scaling will exclude all the M5a instance types, but not the M5n instance types.
          If you specify ``ExcludedInstanceTypes``, you can't specify ``AllowedInstanceTypes``.
          Default: No excluded instance types
        """
        return pulumi.get(self, "excluded_instance_types")

    @excluded_instance_types.setter
    def excluded_instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "excluded_instance_types", value)

    @property
    @pulumi.getter(name="instanceGenerations")
    def instance_generations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Indicates whether current or previous generation instance types are included.
          +  For current generation instance types, specify ``current``. The current generation includes EC2 instance types currently recommended for use. This typically includes the latest two to three generations in each instance family. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide for Linux Instances*.
          +  For previous generation instance types, specify ``previous``.
          
         Default: Any current or previous generation
        """
        return pulumi.get(self, "instance_generations")

    @instance_generations.setter
    def instance_generations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "instance_generations", value)

    @property
    @pulumi.getter(name="localStorage")
    def local_storage(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether instance types with instance store volumes are included, excluded, or required. For more information, see [Amazon EC2 instance store](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html) in the *Amazon EC2 User Guide for Linux Instances*.
         Default: ``included``
        """
        return pulumi.get(self, "local_storage")

    @local_storage.setter
    def local_storage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_storage", value)

    @property
    @pulumi.getter(name="localStorageTypes")
    def local_storage_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Indicates the type of local storage that is required.
          +  For instance types with hard disk drive (HDD) storage, specify ``hdd``.
          +  For instance types with solid state drive (SSD) storage, specify ``ssd``.
          
         Default: Any local storage type
        """
        return pulumi.get(self, "local_storage_types")

    @local_storage_types.setter
    def local_storage_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "local_storage_types", value)

    @property
    @pulumi.getter(name="maxSpotPriceAsPercentageOfOptimalOnDemandPrice")
    def max_spot_price_as_percentage_of_optimal_on_demand_price(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        [Price protection] The price protection threshold for Spot Instances, as a percentage of an identified On-Demand price. The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold.
         The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage.
         If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is based on the per-vCPU or per-memory price instead of the per instance price. 
          Only one of ``SpotMaxPricePercentageOverLowestPrice`` or ``MaxSpotPriceAsPercentageOfOptimalOnDemandPrice`` can be specified. If you don't specify either, Amazon EC2 Auto Scaling will automatically apply optimal price protection to consistently select from a wide range of instance types. To indicate no price protection threshold for Spot Instances, meaning you want to consider all instance types that match your attributes, include one of these parameters and specify a high value, such as ``999999``.
        """
        return pulumi.get(self, "max_spot_price_as_percentage_of_optimal_on_demand_price")

    @max_spot_price_as_percentage_of_optimal_on_demand_price.setter
    def max_spot_price_as_percentage_of_optimal_on_demand_price(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_spot_price_as_percentage_of_optimal_on_demand_price", value)

    @property
    @pulumi.getter(name="memoryGiBPerVCpu")
    def memory_gi_b_per_v_cpu(self) -> Optional[pulumi.Input['AutoScalingGroupMemoryGiBPerVCpuRequestArgs']]:
        """
        The minimum and maximum amount of memory per vCPU for an instance type, in GiB.
         Default: No minimum or maximum limits
        """
        return pulumi.get(self, "memory_gi_b_per_v_cpu")

    @memory_gi_b_per_v_cpu.setter
    def memory_gi_b_per_v_cpu(self, value: Optional[pulumi.Input['AutoScalingGroupMemoryGiBPerVCpuRequestArgs']]):
        pulumi.set(self, "memory_gi_b_per_v_cpu", value)

    @property
    @pulumi.getter(name="networkBandwidthGbps")
    def network_bandwidth_gbps(self) -> Optional[pulumi.Input['AutoScalingGroupNetworkBandwidthGbpsRequestArgs']]:
        """
        The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps).
         Default: No minimum or maximum limits
        """
        return pulumi.get(self, "network_bandwidth_gbps")

    @network_bandwidth_gbps.setter
    def network_bandwidth_gbps(self, value: Optional[pulumi.Input['AutoScalingGroupNetworkBandwidthGbpsRequestArgs']]):
        pulumi.set(self, "network_bandwidth_gbps", value)

    @property
    @pulumi.getter(name="networkInterfaceCount")
    def network_interface_count(self) -> Optional[pulumi.Input['AutoScalingGroupNetworkInterfaceCountRequestArgs']]:
        """
        The minimum and maximum number of network interfaces for an instance type.
         Default: No minimum or maximum limits
        """
        return pulumi.get(self, "network_interface_count")

    @network_interface_count.setter
    def network_interface_count(self, value: Optional[pulumi.Input['AutoScalingGroupNetworkInterfaceCountRequestArgs']]):
        pulumi.set(self, "network_interface_count", value)

    @property
    @pulumi.getter(name="onDemandMaxPricePercentageOverLowestPrice")
    def on_demand_max_price_percentage_over_lowest_price(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        [Price protection] The price protection threshold for On-Demand Instances, as a percentage higher than an identified On-Demand price. The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold. 
         The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage.
         To turn off price protection, specify a high value, such as ``999999``. 
         If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per instance price. 
         Default: ``20``
        """
        return pulumi.get(self, "on_demand_max_price_percentage_over_lowest_price")

    @on_demand_max_price_percentage_over_lowest_price.setter
    def on_demand_max_price_percentage_over_lowest_price(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "on_demand_max_price_percentage_over_lowest_price", value)

    @property
    @pulumi.getter(name="requireHibernateSupport")
    def require_hibernate_support(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether instance types must provide On-Demand Instance hibernation support.
         Default: ``false``
        """
        return pulumi.get(self, "require_hibernate_support")

    @require_hibernate_support.setter
    def require_hibernate_support(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "require_hibernate_support", value)

    @property
    @pulumi.getter(name="spotMaxPricePercentageOverLowestPrice")
    def spot_max_price_percentage_over_lowest_price(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        [Price protection] The price protection threshold for Spot Instances, as a percentage higher than an identified Spot price. The identified Spot price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold.
         The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. 
         If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is based on the per-vCPU or per-memory price instead of the per instance price. 
          Only one of ``SpotMaxPricePercentageOverLowestPrice`` or ``MaxSpotPriceAsPercentageOfOptimalOnDemandPrice`` can be specified. If you don't specify either, Amazon EC2 Auto Scaling will automatically apply optimal price protection to consistently select from a wide range of instance types. To indicate no price protection threshold for Spot Instances, meaning you want to consider all instance types that match your attributes, include one of these parameters and specify a high value, such as ``999999``.
        """
        return pulumi.get(self, "spot_max_price_percentage_over_lowest_price")

    @spot_max_price_percentage_over_lowest_price.setter
    def spot_max_price_percentage_over_lowest_price(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "spot_max_price_percentage_over_lowest_price", value)

    @property
    @pulumi.getter(name="totalLocalStorageGb")
    def total_local_storage_gb(self) -> Optional[pulumi.Input['AutoScalingGroupTotalLocalStorageGbRequestArgs']]:
        """
        The minimum and maximum total local storage size for an instance type, in GB.
         Default: No minimum or maximum limits
        """
        return pulumi.get(self, "total_local_storage_gb")

    @total_local_storage_gb.setter
    def total_local_storage_gb(self, value: Optional[pulumi.Input['AutoScalingGroupTotalLocalStorageGbRequestArgs']]):
        pulumi.set(self, "total_local_storage_gb", value)


if not MYPY:
    class AutoScalingGroupInstancesDistributionArgsDict(TypedDict):
        """
        Use this structure to specify the distribution of On-Demand Instances and Spot Instances and the allocation strategies used to fulfill On-Demand and Spot capacities for a mixed instances policy.
         For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
          ``InstancesDistribution`` is a property of the [AWS::AutoScaling::AutoScalingGroup MixedInstancesPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-mixedinstancespolicy.html) property type.
        """
        on_demand_allocation_strategy: NotRequired[pulumi.Input[builtins.str]]
        """
        The allocation strategy to apply to your On-Demand Instances when they are launched. Possible instance types are determined by the launch template overrides that you specify.
         The following lists the valid values:
          + lowest-price Uses price to determine which instance types are the highest priority, launching the lowest priced instance types within an Availability Zone first. This is the default value for Auto Scaling groups that specify InstanceRequirements. + prioritized You set the order of instance types for the launch template overrides from highest to lowest priority (from first to last in the list). Amazon EC2 Auto Scaling launches your highest priority instance types first. If all your On-Demand capacity cannot be fulfilled using your highest priority instance type, then Amazon EC2 Auto Scaling launches the remaining capacity using the second priority instance type, and so on. This is the default value for Auto Scaling groups that don't specify InstanceRequirements and cannot be used for groups that do.
        """
        on_demand_base_capacity: NotRequired[pulumi.Input[builtins.int]]
        """
        The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is launched first as your group scales.
         This number has the same unit of measurement as the group's desired capacity. If you change the default unit of measurement (number of instances) by specifying weighted capacity values in your launch template overrides list, or by changing the default desired capacity type setting of the group, you must specify this number using the same unit of measurement.
         Default: 0
          An update to this setting means a gradual replacement of instances to adjust the current On-Demand Instance levels. When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the previous ones.
        """
        on_demand_percentage_above_base_capacity: NotRequired[pulumi.Input[builtins.int]]
        """
        Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond ``OnDemandBaseCapacity``. Expressed as a number (for example, 20 specifies 20% On-Demand Instances, 80% Spot Instances). If set to 100, only On-Demand Instances are used.
         Default: 100
          An update to this setting means a gradual replacement of instances to adjust the current On-Demand and Spot Instance levels for your additional capacity higher than the base capacity. When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the previous ones.
        """
        spot_allocation_strategy: NotRequired[pulumi.Input[builtins.str]]
        """
        The allocation strategy to apply to your Spot Instances when they are launched. Possible instance types are determined by the launch template overrides that you specify.
         The following lists the valid values:
          + capacity-optimized Requests Spot Instances using pools that are optimally chosen based on the available Spot capacity. This strategy has the lowest risk of interruption. To give certain instance types a higher chance of launching first, use capacity-optimized-prioritized. + capacity-optimized-prioritized You set the order of instance types for the launch template overrides from highest to lowest priority (from first to last in the list). Amazon EC2 Auto Scaling honors the instance type priorities on a best effort basis but optimizes for capacity first. Note that if the On-Demand allocation strategy is set to prioritized, the same priority is applied when fulfilling On-Demand capacity. This is not a valid value for Auto Scaling groups that specify InstanceRequirements. + lowest-price Requests Spot Instances using the lowest priced pools within an Availability Zone, across the number of Spot pools that you specify for the SpotInstancePools property. To ensure that your desired capacity is met, you might receive Spot Instances from several pools. This is the default value, but it might lead to high interruption rates because this strategy only considers instance price and not available capacity. + price-capacity-optimized (recommended) The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot Instance pools that are the least likely to be interrupted and have the lowest possible price.
        """
        spot_instance_pools: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of Spot Instance pools across which to allocate your Spot Instances. The Spot pools are determined from the different instance types in the overrides. Valid only when the ``SpotAllocationStrategy`` is ``lowest-price``. Value must be in the range of 1–20.
         Default: 2
        """
        spot_max_price: NotRequired[pulumi.Input[builtins.str]]
        """
        The maximum price per unit hour that you are willing to pay for a Spot Instance. If your maximum price is lower than the Spot price for the instance types that you selected, your Spot Instances are not launched. We do not recommend specifying a maximum price because it can lead to increased interruptions. When Spot Instances launch, you pay the current Spot price. To remove a maximum price that you previously set, include the property but specify an empty string ("") for the value.
          If you specify a maximum price, your instances will be interrupted more frequently than if you do not specify one.
          Valid Range: Minimum value of 0.001
        """
elif False:
    AutoScalingGroupInstancesDistributionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupInstancesDistributionArgs:
    def __init__(__self__, *,
                 on_demand_allocation_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 on_demand_base_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 on_demand_percentage_above_base_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 spot_allocation_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 spot_instance_pools: Optional[pulumi.Input[builtins.int]] = None,
                 spot_max_price: Optional[pulumi.Input[builtins.str]] = None):
        """
        Use this structure to specify the distribution of On-Demand Instances and Spot Instances and the allocation strategies used to fulfill On-Demand and Spot capacities for a mixed instances policy.
         For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
          ``InstancesDistribution`` is a property of the [AWS::AutoScaling::AutoScalingGroup MixedInstancesPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-mixedinstancespolicy.html) property type.
        :param pulumi.Input[builtins.str] on_demand_allocation_strategy: The allocation strategy to apply to your On-Demand Instances when they are launched. Possible instance types are determined by the launch template overrides that you specify.
                The following lists the valid values:
                 + lowest-price Uses price to determine which instance types are the highest priority, launching the lowest priced instance types within an Availability Zone first. This is the default value for Auto Scaling groups that specify InstanceRequirements. + prioritized You set the order of instance types for the launch template overrides from highest to lowest priority (from first to last in the list). Amazon EC2 Auto Scaling launches your highest priority instance types first. If all your On-Demand capacity cannot be fulfilled using your highest priority instance type, then Amazon EC2 Auto Scaling launches the remaining capacity using the second priority instance type, and so on. This is the default value for Auto Scaling groups that don't specify InstanceRequirements and cannot be used for groups that do.
        :param pulumi.Input[builtins.int] on_demand_base_capacity: The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is launched first as your group scales.
                This number has the same unit of measurement as the group's desired capacity. If you change the default unit of measurement (number of instances) by specifying weighted capacity values in your launch template overrides list, or by changing the default desired capacity type setting of the group, you must specify this number using the same unit of measurement.
                Default: 0
                 An update to this setting means a gradual replacement of instances to adjust the current On-Demand Instance levels. When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the previous ones.
        :param pulumi.Input[builtins.int] on_demand_percentage_above_base_capacity: Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond ``OnDemandBaseCapacity``. Expressed as a number (for example, 20 specifies 20% On-Demand Instances, 80% Spot Instances). If set to 100, only On-Demand Instances are used.
                Default: 100
                 An update to this setting means a gradual replacement of instances to adjust the current On-Demand and Spot Instance levels for your additional capacity higher than the base capacity. When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the previous ones.
        :param pulumi.Input[builtins.str] spot_allocation_strategy: The allocation strategy to apply to your Spot Instances when they are launched. Possible instance types are determined by the launch template overrides that you specify.
                The following lists the valid values:
                 + capacity-optimized Requests Spot Instances using pools that are optimally chosen based on the available Spot capacity. This strategy has the lowest risk of interruption. To give certain instance types a higher chance of launching first, use capacity-optimized-prioritized. + capacity-optimized-prioritized You set the order of instance types for the launch template overrides from highest to lowest priority (from first to last in the list). Amazon EC2 Auto Scaling honors the instance type priorities on a best effort basis but optimizes for capacity first. Note that if the On-Demand allocation strategy is set to prioritized, the same priority is applied when fulfilling On-Demand capacity. This is not a valid value for Auto Scaling groups that specify InstanceRequirements. + lowest-price Requests Spot Instances using the lowest priced pools within an Availability Zone, across the number of Spot pools that you specify for the SpotInstancePools property. To ensure that your desired capacity is met, you might receive Spot Instances from several pools. This is the default value, but it might lead to high interruption rates because this strategy only considers instance price and not available capacity. + price-capacity-optimized (recommended) The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot Instance pools that are the least likely to be interrupted and have the lowest possible price.
        :param pulumi.Input[builtins.int] spot_instance_pools: The number of Spot Instance pools across which to allocate your Spot Instances. The Spot pools are determined from the different instance types in the overrides. Valid only when the ``SpotAllocationStrategy`` is ``lowest-price``. Value must be in the range of 1–20.
                Default: 2
        :param pulumi.Input[builtins.str] spot_max_price: The maximum price per unit hour that you are willing to pay for a Spot Instance. If your maximum price is lower than the Spot price for the instance types that you selected, your Spot Instances are not launched. We do not recommend specifying a maximum price because it can lead to increased interruptions. When Spot Instances launch, you pay the current Spot price. To remove a maximum price that you previously set, include the property but specify an empty string ("") for the value.
                 If you specify a maximum price, your instances will be interrupted more frequently than if you do not specify one.
                 Valid Range: Minimum value of 0.001
        """
        if on_demand_allocation_strategy is not None:
            pulumi.set(__self__, "on_demand_allocation_strategy", on_demand_allocation_strategy)
        if on_demand_base_capacity is not None:
            pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        if on_demand_percentage_above_base_capacity is not None:
            pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        if spot_allocation_strategy is not None:
            pulumi.set(__self__, "spot_allocation_strategy", spot_allocation_strategy)
        if spot_instance_pools is not None:
            pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)
        if spot_max_price is not None:
            pulumi.set(__self__, "spot_max_price", spot_max_price)

    @property
    @pulumi.getter(name="onDemandAllocationStrategy")
    def on_demand_allocation_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The allocation strategy to apply to your On-Demand Instances when they are launched. Possible instance types are determined by the launch template overrides that you specify.
         The following lists the valid values:
          + lowest-price Uses price to determine which instance types are the highest priority, launching the lowest priced instance types within an Availability Zone first. This is the default value for Auto Scaling groups that specify InstanceRequirements. + prioritized You set the order of instance types for the launch template overrides from highest to lowest priority (from first to last in the list). Amazon EC2 Auto Scaling launches your highest priority instance types first. If all your On-Demand capacity cannot be fulfilled using your highest priority instance type, then Amazon EC2 Auto Scaling launches the remaining capacity using the second priority instance type, and so on. This is the default value for Auto Scaling groups that don't specify InstanceRequirements and cannot be used for groups that do.
        """
        return pulumi.get(self, "on_demand_allocation_strategy")

    @on_demand_allocation_strategy.setter
    def on_demand_allocation_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_demand_allocation_strategy", value)

    @property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is launched first as your group scales.
         This number has the same unit of measurement as the group's desired capacity. If you change the default unit of measurement (number of instances) by specifying weighted capacity values in your launch template overrides list, or by changing the default desired capacity type setting of the group, you must specify this number using the same unit of measurement.
         Default: 0
          An update to this setting means a gradual replacement of instances to adjust the current On-Demand Instance levels. When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the previous ones.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @on_demand_base_capacity.setter
    def on_demand_base_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "on_demand_base_capacity", value)

    @property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond ``OnDemandBaseCapacity``. Expressed as a number (for example, 20 specifies 20% On-Demand Instances, 80% Spot Instances). If set to 100, only On-Demand Instances are used.
         Default: 100
          An update to this setting means a gradual replacement of instances to adjust the current On-Demand and Spot Instance levels for your additional capacity higher than the base capacity. When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the previous ones.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @on_demand_percentage_above_base_capacity.setter
    def on_demand_percentage_above_base_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "on_demand_percentage_above_base_capacity", value)

    @property
    @pulumi.getter(name="spotAllocationStrategy")
    def spot_allocation_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The allocation strategy to apply to your Spot Instances when they are launched. Possible instance types are determined by the launch template overrides that you specify.
         The following lists the valid values:
          + capacity-optimized Requests Spot Instances using pools that are optimally chosen based on the available Spot capacity. This strategy has the lowest risk of interruption. To give certain instance types a higher chance of launching first, use capacity-optimized-prioritized. + capacity-optimized-prioritized You set the order of instance types for the launch template overrides from highest to lowest priority (from first to last in the list). Amazon EC2 Auto Scaling honors the instance type priorities on a best effort basis but optimizes for capacity first. Note that if the On-Demand allocation strategy is set to prioritized, the same priority is applied when fulfilling On-Demand capacity. This is not a valid value for Auto Scaling groups that specify InstanceRequirements. + lowest-price Requests Spot Instances using the lowest priced pools within an Availability Zone, across the number of Spot pools that you specify for the SpotInstancePools property. To ensure that your desired capacity is met, you might receive Spot Instances from several pools. This is the default value, but it might lead to high interruption rates because this strategy only considers instance price and not available capacity. + price-capacity-optimized (recommended) The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot Instance pools that are the least likely to be interrupted and have the lowest possible price.
        """
        return pulumi.get(self, "spot_allocation_strategy")

    @spot_allocation_strategy.setter
    def spot_allocation_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spot_allocation_strategy", value)

    @property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of Spot Instance pools across which to allocate your Spot Instances. The Spot pools are determined from the different instance types in the overrides. Valid only when the ``SpotAllocationStrategy`` is ``lowest-price``. Value must be in the range of 1–20.
         Default: 2
        """
        return pulumi.get(self, "spot_instance_pools")

    @spot_instance_pools.setter
    def spot_instance_pools(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "spot_instance_pools", value)

    @property
    @pulumi.getter(name="spotMaxPrice")
    def spot_max_price(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum price per unit hour that you are willing to pay for a Spot Instance. If your maximum price is lower than the Spot price for the instance types that you selected, your Spot Instances are not launched. We do not recommend specifying a maximum price because it can lead to increased interruptions. When Spot Instances launch, you pay the current Spot price. To remove a maximum price that you previously set, include the property but specify an empty string ("") for the value.
          If you specify a maximum price, your instances will be interrupted more frequently than if you do not specify one.
          Valid Range: Minimum value of 0.001
        """
        return pulumi.get(self, "spot_max_price")

    @spot_max_price.setter
    def spot_max_price(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spot_max_price", value)


if not MYPY:
    class AutoScalingGroupLaunchTemplateOverridesArgsDict(TypedDict):
        """
        Use this structure to let Amazon EC2 Auto Scaling do the following when the Auto Scaling group has a mixed instances policy:
          +  Override the instance type that is specified in the launch template.
          +  Use multiple instance types.
          
         Specify the instance types that you want, or define your instance requirements instead and let Amazon EC2 Auto Scaling provision the available instance types that meet your requirements. This can provide Amazon EC2 Auto Scaling with a larger selection of instance types to choose from when fulfilling Spot and On-Demand capacities. You can view which instance types are matched before you apply the instance requirements to your Auto Scaling group.
         After you define your instance requirements, you don't have to keep updating these settings to get new EC2 instance types automatically. Amazon EC2 Auto Scaling uses the instance requirements of the Auto Scaling group to determine whether a new EC2 instance type can be used.
          ``LaunchTemplateOverrides`` is a property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplate.html) property type.
        """
        instance_requirements: NotRequired[pulumi.Input['AutoScalingGroupInstanceRequirementsArgsDict']]
        """
        The instance requirements. Amazon EC2 Auto Scaling uses your specified requirements to identify instance types. Then, it uses your On-Demand and Spot allocation strategies to launch instances from these instance types.
         You can specify up to four separate sets of instance requirements per Auto Scaling group. This is useful for provisioning instances from different Amazon Machine Images (AMIs) in the same Auto Scaling group. To do this, create the AMIs and create a new launch template for each AMI. Then, create a compatible set of instance requirements for each launch template. 
          If you specify ``InstanceRequirements``, you can't specify ``InstanceType``.
        """
        instance_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The instance type, such as ``m3.xlarge``. You must specify an instance type that is supported in your requested Region and Availability Zones. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide for Linux Instances*.
         You can specify up to 40 instance types per Auto Scaling group.
        """
        launch_template_specification: NotRequired[pulumi.Input['AutoScalingGroupLaunchTemplateSpecificationArgsDict']]
        """
        Provides a launch template for the specified instance type or set of instance requirements. For example, some instance types might require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's specified in the ``LaunchTemplate`` definition. For more information, see [Specifying a different launch template for an instance type](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html) in the *Amazon EC2 Auto Scaling User Guide*. 
         You can specify up to 20 launch templates per Auto Scaling group. The launch templates specified in the overrides and in the ``LaunchTemplate`` definition count towards this limit.
        """
        weighted_capacity: NotRequired[pulumi.Input[builtins.str]]
        """
        If you provide a list of instance types to use, you can specify the number of capacity units provided by each instance type in terms of virtual CPUs, memory, storage, throughput, or other relative performance characteristic. When a Spot or On-Demand Instance is launched, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling launches instances until the desired capacity is totally fulfilled, even if this results in an overage. For example, if there are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can only launch an instance with a ``WeightedCapacity`` of five units, the instance is launched, and the desired capacity is exceeded by three units. For more information, see [Configure instance weighting for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html) in the *Amazon EC2 Auto Scaling User Guide*. Value must be in the range of 1-999. 
         If you specify a value for ``WeightedCapacity`` for one instance type, you must specify a value for ``WeightedCapacity`` for all of them.
          Every Auto Scaling group has three size parameters (``DesiredCapacity``, ``MaxSize``, and ``MinSize``). Usually, you set these sizes based on a specific number of instances. However, if you configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with the same units that you use for weighting instances.
        """
elif False:
    AutoScalingGroupLaunchTemplateOverridesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupLaunchTemplateOverridesArgs:
    def __init__(__self__, *,
                 instance_requirements: Optional[pulumi.Input['AutoScalingGroupInstanceRequirementsArgs']] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 launch_template_specification: Optional[pulumi.Input['AutoScalingGroupLaunchTemplateSpecificationArgs']] = None,
                 weighted_capacity: Optional[pulumi.Input[builtins.str]] = None):
        """
        Use this structure to let Amazon EC2 Auto Scaling do the following when the Auto Scaling group has a mixed instances policy:
          +  Override the instance type that is specified in the launch template.
          +  Use multiple instance types.
          
         Specify the instance types that you want, or define your instance requirements instead and let Amazon EC2 Auto Scaling provision the available instance types that meet your requirements. This can provide Amazon EC2 Auto Scaling with a larger selection of instance types to choose from when fulfilling Spot and On-Demand capacities. You can view which instance types are matched before you apply the instance requirements to your Auto Scaling group.
         After you define your instance requirements, you don't have to keep updating these settings to get new EC2 instance types automatically. Amazon EC2 Auto Scaling uses the instance requirements of the Auto Scaling group to determine whether a new EC2 instance type can be used.
          ``LaunchTemplateOverrides`` is a property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplate.html) property type.
        :param pulumi.Input['AutoScalingGroupInstanceRequirementsArgs'] instance_requirements: The instance requirements. Amazon EC2 Auto Scaling uses your specified requirements to identify instance types. Then, it uses your On-Demand and Spot allocation strategies to launch instances from these instance types.
                You can specify up to four separate sets of instance requirements per Auto Scaling group. This is useful for provisioning instances from different Amazon Machine Images (AMIs) in the same Auto Scaling group. To do this, create the AMIs and create a new launch template for each AMI. Then, create a compatible set of instance requirements for each launch template. 
                 If you specify ``InstanceRequirements``, you can't specify ``InstanceType``.
        :param pulumi.Input[builtins.str] instance_type: The instance type, such as ``m3.xlarge``. You must specify an instance type that is supported in your requested Region and Availability Zones. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide for Linux Instances*.
                You can specify up to 40 instance types per Auto Scaling group.
        :param pulumi.Input['AutoScalingGroupLaunchTemplateSpecificationArgs'] launch_template_specification: Provides a launch template for the specified instance type or set of instance requirements. For example, some instance types might require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's specified in the ``LaunchTemplate`` definition. For more information, see [Specifying a different launch template for an instance type](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html) in the *Amazon EC2 Auto Scaling User Guide*. 
                You can specify up to 20 launch templates per Auto Scaling group. The launch templates specified in the overrides and in the ``LaunchTemplate`` definition count towards this limit.
        :param pulumi.Input[builtins.str] weighted_capacity: If you provide a list of instance types to use, you can specify the number of capacity units provided by each instance type in terms of virtual CPUs, memory, storage, throughput, or other relative performance characteristic. When a Spot or On-Demand Instance is launched, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling launches instances until the desired capacity is totally fulfilled, even if this results in an overage. For example, if there are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can only launch an instance with a ``WeightedCapacity`` of five units, the instance is launched, and the desired capacity is exceeded by three units. For more information, see [Configure instance weighting for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html) in the *Amazon EC2 Auto Scaling User Guide*. Value must be in the range of 1-999. 
                If you specify a value for ``WeightedCapacity`` for one instance type, you must specify a value for ``WeightedCapacity`` for all of them.
                 Every Auto Scaling group has three size parameters (``DesiredCapacity``, ``MaxSize``, and ``MinSize``). Usually, you set these sizes based on a specific number of instances. However, if you configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with the same units that you use for weighting instances.
        """
        if instance_requirements is not None:
            pulumi.set(__self__, "instance_requirements", instance_requirements)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if launch_template_specification is not None:
            pulumi.set(__self__, "launch_template_specification", launch_template_specification)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceRequirements")
    def instance_requirements(self) -> Optional[pulumi.Input['AutoScalingGroupInstanceRequirementsArgs']]:
        """
        The instance requirements. Amazon EC2 Auto Scaling uses your specified requirements to identify instance types. Then, it uses your On-Demand and Spot allocation strategies to launch instances from these instance types.
         You can specify up to four separate sets of instance requirements per Auto Scaling group. This is useful for provisioning instances from different Amazon Machine Images (AMIs) in the same Auto Scaling group. To do this, create the AMIs and create a new launch template for each AMI. Then, create a compatible set of instance requirements for each launch template. 
          If you specify ``InstanceRequirements``, you can't specify ``InstanceType``.
        """
        return pulumi.get(self, "instance_requirements")

    @instance_requirements.setter
    def instance_requirements(self, value: Optional[pulumi.Input['AutoScalingGroupInstanceRequirementsArgs']]):
        pulumi.set(self, "instance_requirements", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The instance type, such as ``m3.xlarge``. You must specify an instance type that is supported in your requested Region and Availability Zones. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide for Linux Instances*.
         You can specify up to 40 instance types per Auto Scaling group.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="launchTemplateSpecification")
    def launch_template_specification(self) -> Optional[pulumi.Input['AutoScalingGroupLaunchTemplateSpecificationArgs']]:
        """
        Provides a launch template for the specified instance type or set of instance requirements. For example, some instance types might require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's specified in the ``LaunchTemplate`` definition. For more information, see [Specifying a different launch template for an instance type](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html) in the *Amazon EC2 Auto Scaling User Guide*. 
         You can specify up to 20 launch templates per Auto Scaling group. The launch templates specified in the overrides and in the ``LaunchTemplate`` definition count towards this limit.
        """
        return pulumi.get(self, "launch_template_specification")

    @launch_template_specification.setter
    def launch_template_specification(self, value: Optional[pulumi.Input['AutoScalingGroupLaunchTemplateSpecificationArgs']]):
        pulumi.set(self, "launch_template_specification", value)

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you provide a list of instance types to use, you can specify the number of capacity units provided by each instance type in terms of virtual CPUs, memory, storage, throughput, or other relative performance characteristic. When a Spot or On-Demand Instance is launched, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling launches instances until the desired capacity is totally fulfilled, even if this results in an overage. For example, if there are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can only launch an instance with a ``WeightedCapacity`` of five units, the instance is launched, and the desired capacity is exceeded by three units. For more information, see [Configure instance weighting for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html) in the *Amazon EC2 Auto Scaling User Guide*. Value must be in the range of 1-999. 
         If you specify a value for ``WeightedCapacity`` for one instance type, you must specify a value for ``WeightedCapacity`` for all of them.
          Every Auto Scaling group has three size parameters (``DesiredCapacity``, ``MaxSize``, and ``MinSize``). Usually, you set these sizes based on a specific number of instances. However, if you configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with the same units that you use for weighting instances.
        """
        return pulumi.get(self, "weighted_capacity")

    @weighted_capacity.setter
    def weighted_capacity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "weighted_capacity", value)


if not MYPY:
    class AutoScalingGroupLaunchTemplateSpecificationArgsDict(TypedDict):
        """
        Specifies a launch template to use when provisioning EC2 instances for an Auto Scaling group.
         You must specify the following:
          +  The ID or the name of the launch template, but not both.
          +  The version of the launch template.
          
          ``LaunchTemplateSpecification`` is property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource. It is also a property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplate.html) and [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property types.
         For information about creating a launch template, see [AWS::EC2::LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) and [Create a launch template for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) in the *Amazon EC2 Auto Scaling User Guide*.
         For examples of launch templates, see [Create launch templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-ec2-launch-templates.html).
        """
        version: pulumi.Input[builtins.str]
        """
        The version number of the launch template.
         Specifying ``$Latest`` or ``$Default`` for the template version number is not supported. However, you can specify ``LatestVersionNumber`` or ``DefaultVersionNumber`` using the ``Fn::GetAtt`` intrinsic function. For more information, see [Fn::GetAtt](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getatt.html).
          For an example of using the ``Fn::GetAtt`` function, see the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html#aws-resource-autoscaling-autoscalinggroup--examples) section of the ``AWS::AutoScaling::AutoScalingGroup`` resource.
        """
        launch_template_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the launch template.
         You must specify the ``LaunchTemplateID`` or the ``LaunchTemplateName``, but not both.
        """
        launch_template_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the launch template.
         You must specify the ``LaunchTemplateName`` or the ``LaunchTemplateID``, but not both.
        """
elif False:
    AutoScalingGroupLaunchTemplateSpecificationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupLaunchTemplateSpecificationArgs:
    def __init__(__self__, *,
                 version: pulumi.Input[builtins.str],
                 launch_template_id: Optional[pulumi.Input[builtins.str]] = None,
                 launch_template_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specifies a launch template to use when provisioning EC2 instances for an Auto Scaling group.
         You must specify the following:
          +  The ID or the name of the launch template, but not both.
          +  The version of the launch template.
          
          ``LaunchTemplateSpecification`` is property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource. It is also a property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplate.html) and [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property types.
         For information about creating a launch template, see [AWS::EC2::LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) and [Create a launch template for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) in the *Amazon EC2 Auto Scaling User Guide*.
         For examples of launch templates, see [Create launch templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-ec2-launch-templates.html).
        :param pulumi.Input[builtins.str] version: The version number of the launch template.
                Specifying ``$Latest`` or ``$Default`` for the template version number is not supported. However, you can specify ``LatestVersionNumber`` or ``DefaultVersionNumber`` using the ``Fn::GetAtt`` intrinsic function. For more information, see [Fn::GetAtt](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getatt.html).
                 For an example of using the ``Fn::GetAtt`` function, see the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html#aws-resource-autoscaling-autoscalinggroup--examples) section of the ``AWS::AutoScaling::AutoScalingGroup`` resource.
        :param pulumi.Input[builtins.str] launch_template_id: The ID of the launch template.
                You must specify the ``LaunchTemplateID`` or the ``LaunchTemplateName``, but not both.
        :param pulumi.Input[builtins.str] launch_template_name: The name of the launch template.
                You must specify the ``LaunchTemplateName`` or the ``LaunchTemplateID``, but not both.
        """
        pulumi.set(__self__, "version", version)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[builtins.str]:
        """
        The version number of the launch template.
         Specifying ``$Latest`` or ``$Default`` for the template version number is not supported. However, you can specify ``LatestVersionNumber`` or ``DefaultVersionNumber`` using the ``Fn::GetAtt`` intrinsic function. For more information, see [Fn::GetAtt](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getatt.html).
          For an example of using the ``Fn::GetAtt`` function, see the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html#aws-resource-autoscaling-autoscalinggroup--examples) section of the ``AWS::AutoScaling::AutoScalingGroup`` resource.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the launch template.
         You must specify the ``LaunchTemplateID`` or the ``LaunchTemplateName``, but not both.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the launch template.
         You must specify the ``LaunchTemplateName`` or the ``LaunchTemplateID``, but not both.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_template_name", value)


if not MYPY:
    class AutoScalingGroupLaunchTemplateArgsDict(TypedDict):
        """
        Use this structure to specify the launch templates and instance types (overrides) for a mixed instances policy.
          ``LaunchTemplate`` is a property of the [AWS::AutoScaling::AutoScalingGroup MixedInstancesPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-mixedinstancespolicy.html) property type.
        """
        launch_template_specification: pulumi.Input['AutoScalingGroupLaunchTemplateSpecificationArgsDict']
        """
        The launch template.
        """
        overrides: NotRequired[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupLaunchTemplateOverridesArgsDict']]]]
        """
        Any properties that you specify override the same properties in the launch template.
        """
elif False:
    AutoScalingGroupLaunchTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupLaunchTemplateArgs:
    def __init__(__self__, *,
                 launch_template_specification: pulumi.Input['AutoScalingGroupLaunchTemplateSpecificationArgs'],
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupLaunchTemplateOverridesArgs']]]] = None):
        """
        Use this structure to specify the launch templates and instance types (overrides) for a mixed instances policy.
          ``LaunchTemplate`` is a property of the [AWS::AutoScaling::AutoScalingGroup MixedInstancesPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-mixedinstancespolicy.html) property type.
        :param pulumi.Input['AutoScalingGroupLaunchTemplateSpecificationArgs'] launch_template_specification: The launch template.
        :param pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupLaunchTemplateOverridesArgs']]] overrides: Any properties that you specify override the same properties in the launch template.
        """
        pulumi.set(__self__, "launch_template_specification", launch_template_specification)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)

    @property
    @pulumi.getter(name="launchTemplateSpecification")
    def launch_template_specification(self) -> pulumi.Input['AutoScalingGroupLaunchTemplateSpecificationArgs']:
        """
        The launch template.
        """
        return pulumi.get(self, "launch_template_specification")

    @launch_template_specification.setter
    def launch_template_specification(self, value: pulumi.Input['AutoScalingGroupLaunchTemplateSpecificationArgs']):
        pulumi.set(self, "launch_template_specification", value)

    @property
    @pulumi.getter
    def overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupLaunchTemplateOverridesArgs']]]]:
        """
        Any properties that you specify override the same properties in the launch template.
        """
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupLaunchTemplateOverridesArgs']]]]):
        pulumi.set(self, "overrides", value)


if not MYPY:
    class AutoScalingGroupLifecycleHookSpecificationArgsDict(TypedDict):
        """
        ``LifecycleHookSpecification`` specifies a lifecycle hook for the ``LifecycleHookSpecificationList`` property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource. A lifecycle hook specifies actions to perform when Amazon EC2 Auto Scaling launches or terminates instances. 
         For more information, see [Amazon EC2 Auto Scaling lifecycle hooks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in the *Amazon EC2 Auto Scaling User Guide*. You can find a sample template snippet in the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#aws-resource-as-lifecyclehook--examples) section of the ``AWS::AutoScaling::LifecycleHook`` resource.
        """
        lifecycle_hook_name: pulumi.Input[builtins.str]
        """
        The name of the lifecycle hook.
        """
        lifecycle_transition: pulumi.Input[builtins.str]
        """
        The lifecycle transition. For Auto Scaling groups, there are two major lifecycle transitions.
          +  To create a lifecycle hook for scale-out events, specify ``autoscaling:EC2_INSTANCE_LAUNCHING``.
          +  To create a lifecycle hook for scale-in events, specify ``autoscaling:EC2_INSTANCE_TERMINATING``.
        """
        default_result: NotRequired[pulumi.Input[builtins.str]]
        """
        The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs. The default value is ``ABANDON``.
         Valid values: ``CONTINUE`` | ``ABANDON``
        """
        heartbeat_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from ``30`` to ``7200`` seconds. The default value is ``3600`` seconds (1 hour).
        """
        notification_metadata: NotRequired[pulumi.Input[builtins.str]]
        """
        Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the notification target.
        """
        notification_target_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the notification target that Amazon EC2 Auto Scaling sends notifications to when an instance is in a wait state for the lifecycle hook. You can specify an Amazon SNS topic or an Amazon SQS queue.
        """
        role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target. For information about creating this role, see [Prepare to add a lifecycle hook to your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/prepare-for-lifecycle-notifications.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue.
        """
elif False:
    AutoScalingGroupLifecycleHookSpecificationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupLifecycleHookSpecificationArgs:
    def __init__(__self__, *,
                 lifecycle_hook_name: pulumi.Input[builtins.str],
                 lifecycle_transition: pulumi.Input[builtins.str],
                 default_result: Optional[pulumi.Input[builtins.str]] = None,
                 heartbeat_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 notification_metadata: Optional[pulumi.Input[builtins.str]] = None,
                 notification_target_arn: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        ``LifecycleHookSpecification`` specifies a lifecycle hook for the ``LifecycleHookSpecificationList`` property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource. A lifecycle hook specifies actions to perform when Amazon EC2 Auto Scaling launches or terminates instances. 
         For more information, see [Amazon EC2 Auto Scaling lifecycle hooks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in the *Amazon EC2 Auto Scaling User Guide*. You can find a sample template snippet in the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#aws-resource-as-lifecyclehook--examples) section of the ``AWS::AutoScaling::LifecycleHook`` resource.
        :param pulumi.Input[builtins.str] lifecycle_hook_name: The name of the lifecycle hook.
        :param pulumi.Input[builtins.str] lifecycle_transition: The lifecycle transition. For Auto Scaling groups, there are two major lifecycle transitions.
                 +  To create a lifecycle hook for scale-out events, specify ``autoscaling:EC2_INSTANCE_LAUNCHING``.
                 +  To create a lifecycle hook for scale-in events, specify ``autoscaling:EC2_INSTANCE_TERMINATING``.
        :param pulumi.Input[builtins.str] default_result: The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs. The default value is ``ABANDON``.
                Valid values: ``CONTINUE`` | ``ABANDON``
        :param pulumi.Input[builtins.int] heartbeat_timeout: The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from ``30`` to ``7200`` seconds. The default value is ``3600`` seconds (1 hour).
        :param pulumi.Input[builtins.str] notification_metadata: Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the notification target.
        :param pulumi.Input[builtins.str] notification_target_arn: The Amazon Resource Name (ARN) of the notification target that Amazon EC2 Auto Scaling sends notifications to when an instance is in a wait state for the lifecycle hook. You can specify an Amazon SNS topic or an Amazon SQS queue.
        :param pulumi.Input[builtins.str] role_arn: The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target. For information about creating this role, see [Prepare to add a lifecycle hook to your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/prepare-for-lifecycle-notifications.html) in the *Amazon EC2 Auto Scaling User Guide*.
                Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue.
        """
        pulumi.set(__self__, "lifecycle_hook_name", lifecycle_hook_name)
        pulumi.set(__self__, "lifecycle_transition", lifecycle_transition)
        if default_result is not None:
            pulumi.set(__self__, "default_result", default_result)
        if heartbeat_timeout is not None:
            pulumi.set(__self__, "heartbeat_timeout", heartbeat_timeout)
        if notification_metadata is not None:
            pulumi.set(__self__, "notification_metadata", notification_metadata)
        if notification_target_arn is not None:
            pulumi.set(__self__, "notification_target_arn", notification_target_arn)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="lifecycleHookName")
    def lifecycle_hook_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the lifecycle hook.
        """
        return pulumi.get(self, "lifecycle_hook_name")

    @lifecycle_hook_name.setter
    def lifecycle_hook_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "lifecycle_hook_name", value)

    @property
    @pulumi.getter(name="lifecycleTransition")
    def lifecycle_transition(self) -> pulumi.Input[builtins.str]:
        """
        The lifecycle transition. For Auto Scaling groups, there are two major lifecycle transitions.
          +  To create a lifecycle hook for scale-out events, specify ``autoscaling:EC2_INSTANCE_LAUNCHING``.
          +  To create a lifecycle hook for scale-in events, specify ``autoscaling:EC2_INSTANCE_TERMINATING``.
        """
        return pulumi.get(self, "lifecycle_transition")

    @lifecycle_transition.setter
    def lifecycle_transition(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "lifecycle_transition", value)

    @property
    @pulumi.getter(name="defaultResult")
    def default_result(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs. The default value is ``ABANDON``.
         Valid values: ``CONTINUE`` | ``ABANDON``
        """
        return pulumi.get(self, "default_result")

    @default_result.setter
    def default_result(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_result", value)

    @property
    @pulumi.getter(name="heartbeatTimeout")
    def heartbeat_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from ``30`` to ``7200`` seconds. The default value is ``3600`` seconds (1 hour).
        """
        return pulumi.get(self, "heartbeat_timeout")

    @heartbeat_timeout.setter
    def heartbeat_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "heartbeat_timeout", value)

    @property
    @pulumi.getter(name="notificationMetadata")
    def notification_metadata(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the notification target.
        """
        return pulumi.get(self, "notification_metadata")

    @notification_metadata.setter
    def notification_metadata(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notification_metadata", value)

    @property
    @pulumi.getter(name="notificationTargetArn")
    def notification_target_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the notification target that Amazon EC2 Auto Scaling sends notifications to when an instance is in a wait state for the lifecycle hook. You can specify an Amazon SNS topic or an Amazon SQS queue.
        """
        return pulumi.get(self, "notification_target_arn")

    @notification_target_arn.setter
    def notification_target_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notification_target_arn", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target. For information about creating this role, see [Prepare to add a lifecycle hook to your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/prepare-for-lifecycle-notifications.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)


if not MYPY:
    class AutoScalingGroupMemoryGiBPerVCpuRequestArgsDict(TypedDict):
        """
        ``MemoryGiBPerVCpuRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum amount of memory per vCPU for an instance type, in GiB.
        """
        max: NotRequired[pulumi.Input[builtins.float]]
        """
        The memory maximum in GiB.
        """
        min: NotRequired[pulumi.Input[builtins.float]]
        """
        The memory minimum in GiB.
        """
elif False:
    AutoScalingGroupMemoryGiBPerVCpuRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupMemoryGiBPerVCpuRequestArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[builtins.float]] = None,
                 min: Optional[pulumi.Input[builtins.float]] = None):
        """
        ``MemoryGiBPerVCpuRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum amount of memory per vCPU for an instance type, in GiB.
        :param pulumi.Input[builtins.float] max: The memory maximum in GiB.
        :param pulumi.Input[builtins.float] min: The memory minimum in GiB.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The memory maximum in GiB.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The memory minimum in GiB.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "min", value)


if not MYPY:
    class AutoScalingGroupMemoryMiBRequestArgsDict(TypedDict):
        """
        ``MemoryMiBRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum instance memory size for an instance type, in MiB.
        """
        max: NotRequired[pulumi.Input[builtins.int]]
        """
        The memory maximum in MiB.
        """
        min: NotRequired[pulumi.Input[builtins.int]]
        """
        The memory minimum in MiB.
        """
elif False:
    AutoScalingGroupMemoryMiBRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupMemoryMiBRequestArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[builtins.int]] = None,
                 min: Optional[pulumi.Input[builtins.int]] = None):
        """
        ``MemoryMiBRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum instance memory size for an instance type, in MiB.
        :param pulumi.Input[builtins.int] max: The memory maximum in MiB.
        :param pulumi.Input[builtins.int] min: The memory minimum in MiB.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The memory maximum in MiB.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The memory minimum in MiB.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min", value)


if not MYPY:
    class AutoScalingGroupMetricsCollectionArgsDict(TypedDict):
        """
        ``MetricsCollection`` is a property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource that describes the group metrics that an Amazon EC2 Auto Scaling group sends to Amazon CloudWatch. These metrics describe the group rather than any of its instances. 
         For more information, see [Monitor CloudWatch metrics for your Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-monitoring.html) in the *Amazon EC2 Auto Scaling User Guide*. You can find a sample template snippet in the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html#aws-resource-autoscaling-autoscalinggroup--examples) section of the ``AWS::AutoScaling::AutoScalingGroup`` resource.
        """
        granularity: pulumi.Input[builtins.str]
        """
        The frequency at which Amazon EC2 Auto Scaling sends aggregated data to CloudWatch. The only valid value is ``1Minute``.
        """
        metrics: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Identifies the metrics to enable.
         You can specify one or more of the following metrics:
          +   ``GroupMinSize`` 
          +   ``GroupMaxSize`` 
          +   ``GroupDesiredCapacity`` 
          +   ``GroupInServiceInstances`` 
          +   ``GroupPendingInstances`` 
          +   ``GroupStandbyInstances`` 
          +   ``GroupTerminatingInstances`` 
          +   ``GroupTotalInstances`` 
          +   ``GroupInServiceCapacity`` 
          +   ``GroupPendingCapacity`` 
          +   ``GroupStandbyCapacity`` 
          +   ``GroupTerminatingCapacity`` 
          +   ``GroupTotalCapacity`` 
          +   ``WarmPoolDesiredCapacity`` 
          +   ``WarmPoolWarmedCapacity`` 
          +   ``WarmPoolPendingCapacity`` 
          +   ``WarmPoolTerminatingCapacity`` 
          +   ``WarmPoolTotalCapacity`` 
          +   ``GroupAndWarmPoolDesiredCapacity`` 
          +   ``GroupAndWarmPoolTotalCapacity`` 
          
         If you specify ``Granularity`` and don't specify any metrics, all metrics are enabled.
         For more information, see [Amazon CloudWatch metrics for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-metrics.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
elif False:
    AutoScalingGroupMetricsCollectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupMetricsCollectionArgs:
    def __init__(__self__, *,
                 granularity: pulumi.Input[builtins.str],
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        ``MetricsCollection`` is a property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource that describes the group metrics that an Amazon EC2 Auto Scaling group sends to Amazon CloudWatch. These metrics describe the group rather than any of its instances. 
         For more information, see [Monitor CloudWatch metrics for your Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-monitoring.html) in the *Amazon EC2 Auto Scaling User Guide*. You can find a sample template snippet in the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html#aws-resource-autoscaling-autoscalinggroup--examples) section of the ``AWS::AutoScaling::AutoScalingGroup`` resource.
        :param pulumi.Input[builtins.str] granularity: The frequency at which Amazon EC2 Auto Scaling sends aggregated data to CloudWatch. The only valid value is ``1Minute``.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] metrics: Identifies the metrics to enable.
                You can specify one or more of the following metrics:
                 +   ``GroupMinSize`` 
                 +   ``GroupMaxSize`` 
                 +   ``GroupDesiredCapacity`` 
                 +   ``GroupInServiceInstances`` 
                 +   ``GroupPendingInstances`` 
                 +   ``GroupStandbyInstances`` 
                 +   ``GroupTerminatingInstances`` 
                 +   ``GroupTotalInstances`` 
                 +   ``GroupInServiceCapacity`` 
                 +   ``GroupPendingCapacity`` 
                 +   ``GroupStandbyCapacity`` 
                 +   ``GroupTerminatingCapacity`` 
                 +   ``GroupTotalCapacity`` 
                 +   ``WarmPoolDesiredCapacity`` 
                 +   ``WarmPoolWarmedCapacity`` 
                 +   ``WarmPoolPendingCapacity`` 
                 +   ``WarmPoolTerminatingCapacity`` 
                 +   ``WarmPoolTotalCapacity`` 
                 +   ``GroupAndWarmPoolDesiredCapacity`` 
                 +   ``GroupAndWarmPoolTotalCapacity`` 
                 
                If you specify ``Granularity`` and don't specify any metrics, all metrics are enabled.
                For more information, see [Amazon CloudWatch metrics for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-metrics.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        pulumi.set(__self__, "granularity", granularity)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter
    def granularity(self) -> pulumi.Input[builtins.str]:
        """
        The frequency at which Amazon EC2 Auto Scaling sends aggregated data to CloudWatch. The only valid value is ``1Minute``.
        """
        return pulumi.get(self, "granularity")

    @granularity.setter
    def granularity(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "granularity", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Identifies the metrics to enable.
         You can specify one or more of the following metrics:
          +   ``GroupMinSize`` 
          +   ``GroupMaxSize`` 
          +   ``GroupDesiredCapacity`` 
          +   ``GroupInServiceInstances`` 
          +   ``GroupPendingInstances`` 
          +   ``GroupStandbyInstances`` 
          +   ``GroupTerminatingInstances`` 
          +   ``GroupTotalInstances`` 
          +   ``GroupInServiceCapacity`` 
          +   ``GroupPendingCapacity`` 
          +   ``GroupStandbyCapacity`` 
          +   ``GroupTerminatingCapacity`` 
          +   ``GroupTotalCapacity`` 
          +   ``WarmPoolDesiredCapacity`` 
          +   ``WarmPoolWarmedCapacity`` 
          +   ``WarmPoolPendingCapacity`` 
          +   ``WarmPoolTerminatingCapacity`` 
          +   ``WarmPoolTotalCapacity`` 
          +   ``GroupAndWarmPoolDesiredCapacity`` 
          +   ``GroupAndWarmPoolTotalCapacity`` 
          
         If you specify ``Granularity`` and don't specify any metrics, all metrics are enabled.
         For more information, see [Amazon CloudWatch metrics for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-metrics.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metrics", value)


if not MYPY:
    class AutoScalingGroupMixedInstancesPolicyArgsDict(TypedDict):
        """
        Use this structure to launch multiple instance types and On-Demand Instances and Spot Instances within a single Auto Scaling group.
         A mixed instances policy contains information that Amazon EC2 Auto Scaling can use to launch instances and help optimize your costs. For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
         You can create a mixed instances policy for new and existing Auto Scaling groups. You must use a launch template to configure the policy. You cannot use a launch configuration.
         There are key differences between Spot Instances and On-Demand Instances:
          +  The price for Spot Instances varies based on demand
          +  Amazon EC2 can terminate an individual Spot Instance as the availability of, or price for, Spot Instances changes
          
         When a Spot Instance is terminated, Amazon EC2 Auto Scaling group attempts to launch a replacement instance to maintain the desired capacity for the group. 
          ``MixedInstancesPolicy`` is a property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
        """
        launch_template: pulumi.Input['AutoScalingGroupLaunchTemplateArgsDict']
        """
        One or more launch templates and the instance types (overrides) that are used to launch EC2 instances to fulfill On-Demand and Spot capacities.
        """
        instances_distribution: NotRequired[pulumi.Input['AutoScalingGroupInstancesDistributionArgsDict']]
        """
        The instances distribution.
        """
elif False:
    AutoScalingGroupMixedInstancesPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupMixedInstancesPolicyArgs:
    def __init__(__self__, *,
                 launch_template: pulumi.Input['AutoScalingGroupLaunchTemplateArgs'],
                 instances_distribution: Optional[pulumi.Input['AutoScalingGroupInstancesDistributionArgs']] = None):
        """
        Use this structure to launch multiple instance types and On-Demand Instances and Spot Instances within a single Auto Scaling group.
         A mixed instances policy contains information that Amazon EC2 Auto Scaling can use to launch instances and help optimize your costs. For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
         You can create a mixed instances policy for new and existing Auto Scaling groups. You must use a launch template to configure the policy. You cannot use a launch configuration.
         There are key differences between Spot Instances and On-Demand Instances:
          +  The price for Spot Instances varies based on demand
          +  Amazon EC2 can terminate an individual Spot Instance as the availability of, or price for, Spot Instances changes
          
         When a Spot Instance is terminated, Amazon EC2 Auto Scaling group attempts to launch a replacement instance to maintain the desired capacity for the group. 
          ``MixedInstancesPolicy`` is a property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
        :param pulumi.Input['AutoScalingGroupLaunchTemplateArgs'] launch_template: One or more launch templates and the instance types (overrides) that are used to launch EC2 instances to fulfill On-Demand and Spot capacities.
        :param pulumi.Input['AutoScalingGroupInstancesDistributionArgs'] instances_distribution: The instances distribution.
        """
        pulumi.set(__self__, "launch_template", launch_template)
        if instances_distribution is not None:
            pulumi.set(__self__, "instances_distribution", instances_distribution)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> pulumi.Input['AutoScalingGroupLaunchTemplateArgs']:
        """
        One or more launch templates and the instance types (overrides) that are used to launch EC2 instances to fulfill On-Demand and Spot capacities.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: pulumi.Input['AutoScalingGroupLaunchTemplateArgs']):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="instancesDistribution")
    def instances_distribution(self) -> Optional[pulumi.Input['AutoScalingGroupInstancesDistributionArgs']]:
        """
        The instances distribution.
        """
        return pulumi.get(self, "instances_distribution")

    @instances_distribution.setter
    def instances_distribution(self, value: Optional[pulumi.Input['AutoScalingGroupInstancesDistributionArgs']]):
        pulumi.set(self, "instances_distribution", value)


if not MYPY:
    class AutoScalingGroupNetworkBandwidthGbpsRequestArgsDict(TypedDict):
        """
        ``NetworkBandwidthGbpsRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum network bandwidth for an instance type, in Gbps.
          Setting the minimum bandwidth does not guarantee that your instance will achieve the minimum bandwidth. Amazon EC2 will identify instance types that support the specified minimum bandwidth, but the actual bandwidth of your instance might go below the specified minimum at times. For more information, see [Available instance bandwidth](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-network-bandwidth.html#available-instance-bandwidth) in the *Amazon EC2 User Guide for Linux Instances*.
        """
        max: NotRequired[pulumi.Input[builtins.float]]
        """
        The maximum amount of network bandwidth, in gigabits per second (Gbps).
        """
        min: NotRequired[pulumi.Input[builtins.float]]
        """
        The minimum amount of network bandwidth, in gigabits per second (Gbps).
        """
elif False:
    AutoScalingGroupNetworkBandwidthGbpsRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupNetworkBandwidthGbpsRequestArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[builtins.float]] = None,
                 min: Optional[pulumi.Input[builtins.float]] = None):
        """
        ``NetworkBandwidthGbpsRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum network bandwidth for an instance type, in Gbps.
          Setting the minimum bandwidth does not guarantee that your instance will achieve the minimum bandwidth. Amazon EC2 will identify instance types that support the specified minimum bandwidth, but the actual bandwidth of your instance might go below the specified minimum at times. For more information, see [Available instance bandwidth](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-network-bandwidth.html#available-instance-bandwidth) in the *Amazon EC2 User Guide for Linux Instances*.
        :param pulumi.Input[builtins.float] max: The maximum amount of network bandwidth, in gigabits per second (Gbps).
        :param pulumi.Input[builtins.float] min: The minimum amount of network bandwidth, in gigabits per second (Gbps).
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The maximum amount of network bandwidth, in gigabits per second (Gbps).
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The minimum amount of network bandwidth, in gigabits per second (Gbps).
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "min", value)


if not MYPY:
    class AutoScalingGroupNetworkInterfaceCountRequestArgsDict(TypedDict):
        """
        ``NetworkInterfaceCountRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum number of network interfaces for an instance type.
        """
        max: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of network interfaces.
        """
        min: NotRequired[pulumi.Input[builtins.int]]
        """
        The minimum number of network interfaces.
        """
elif False:
    AutoScalingGroupNetworkInterfaceCountRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupNetworkInterfaceCountRequestArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[builtins.int]] = None,
                 min: Optional[pulumi.Input[builtins.int]] = None):
        """
        ``NetworkInterfaceCountRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum number of network interfaces for an instance type.
        :param pulumi.Input[builtins.int] max: The maximum number of network interfaces.
        :param pulumi.Input[builtins.int] min: The minimum number of network interfaces.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of network interfaces.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of network interfaces.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min", value)


if not MYPY:
    class AutoScalingGroupNotificationConfigurationArgsDict(TypedDict):
        """
        A structure that specifies an Amazon SNS notification configuration for the ``NotificationConfigurations`` property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
         For an example template snippet, see [Configure Amazon EC2 Auto Scaling resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-ec2-auto-scaling.html).
         For more information, see [Get Amazon SNS notifications when your Auto Scaling group scales](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        topic_arn: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The Amazon Resource Name (ARN) of the Amazon SNS topic.
        """
        notification_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of event types that send a notification. Event types can include any of the following types. 
          *Allowed values*:
          +   ``autoscaling:EC2_INSTANCE_LAUNCH`` 
          +   ``autoscaling:EC2_INSTANCE_LAUNCH_ERROR`` 
          +   ``autoscaling:EC2_INSTANCE_TERMINATE`` 
          +   ``autoscaling:EC2_INSTANCE_TERMINATE_ERROR`` 
          +   ``autoscaling:TEST_NOTIFICATION``
        """
elif False:
    AutoScalingGroupNotificationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupNotificationConfigurationArgs:
    def __init__(__self__, *,
                 topic_arn: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 notification_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        A structure that specifies an Amazon SNS notification configuration for the ``NotificationConfigurations`` property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
         For an example template snippet, see [Configure Amazon EC2 Auto Scaling resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-ec2-auto-scaling.html).
         For more information, see [Get Amazon SNS notifications when your Auto Scaling group scales](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] topic_arn: The Amazon Resource Name (ARN) of the Amazon SNS topic.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] notification_types: A list of event types that send a notification. Event types can include any of the following types. 
                 *Allowed values*:
                 +   ``autoscaling:EC2_INSTANCE_LAUNCH`` 
                 +   ``autoscaling:EC2_INSTANCE_LAUNCH_ERROR`` 
                 +   ``autoscaling:EC2_INSTANCE_TERMINATE`` 
                 +   ``autoscaling:EC2_INSTANCE_TERMINATE_ERROR`` 
                 +   ``autoscaling:TEST_NOTIFICATION``
        """
        pulumi.set(__self__, "topic_arn", topic_arn)
        if notification_types is not None:
            pulumi.set(__self__, "notification_types", notification_types)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The Amazon Resource Name (ARN) of the Amazon SNS topic.
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "topic_arn", value)

    @property
    @pulumi.getter(name="notificationTypes")
    def notification_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of event types that send a notification. Event types can include any of the following types. 
          *Allowed values*:
          +   ``autoscaling:EC2_INSTANCE_LAUNCH`` 
          +   ``autoscaling:EC2_INSTANCE_LAUNCH_ERROR`` 
          +   ``autoscaling:EC2_INSTANCE_TERMINATE`` 
          +   ``autoscaling:EC2_INSTANCE_TERMINATE_ERROR`` 
          +   ``autoscaling:TEST_NOTIFICATION``
        """
        return pulumi.get(self, "notification_types")

    @notification_types.setter
    def notification_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "notification_types", value)


if not MYPY:
    class AutoScalingGroupPerformanceFactorReferenceRequestArgsDict(TypedDict):
        """
        Specify an instance family to use as the baseline reference for CPU performance. All instance types that All instance types that match your specified attributes will be compared against the CPU performance of the referenced instance family, regardless of CPU manufacturer or architecture differences. 
          Currently only one instance family can be specified in the list.
        """
        instance_family: NotRequired[pulumi.Input[builtins.str]]
        """
        The instance family to use as a baseline reference. 
          Make sure that you specify the correct value for the instance family. The instance family is everything before the period (.) in the instance type name. For example, in the instance ``c6i.large``, the instance family is ``c6i``, not ``c6``. For more information, see [Amazon EC2 instance type naming conventions](https://docs.aws.amazon.com/ec2/latest/instancetypes/instance-type-names.html) in *Amazon EC2 Instance Types*.
          The following instance types are *not supported* for performance protection.
          +   ``c1`` 
          +   ``g3| g3s`` 
          +   ``hpc7g`` 
          +   ``m1| m2`` 
          +   ``mac1 | mac2 | mac2-m1ultra | mac2-m2 | mac2-m2pro`` 
          +   ``p3dn | p4d | p5`` 
          +   ``t1`` 
          +   ``u-12tb1 | u-18tb1 | u-24tb1 | u-3tb1 | u-6tb1 | u-9tb1 | u7i-12tb | u7in-16tb | u7in-24tb | u7in-32tb`` 
          
         If you performance protection by specifying a supported instance family, the returned instance types will exclude the preceding unsupported instance families.
         If you specify an unsupported instance family as a value for baseline performance, the API returns an empty response.
        """
elif False:
    AutoScalingGroupPerformanceFactorReferenceRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupPerformanceFactorReferenceRequestArgs:
    def __init__(__self__, *,
                 instance_family: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specify an instance family to use as the baseline reference for CPU performance. All instance types that All instance types that match your specified attributes will be compared against the CPU performance of the referenced instance family, regardless of CPU manufacturer or architecture differences. 
          Currently only one instance family can be specified in the list.
        :param pulumi.Input[builtins.str] instance_family: The instance family to use as a baseline reference. 
                 Make sure that you specify the correct value for the instance family. The instance family is everything before the period (.) in the instance type name. For example, in the instance ``c6i.large``, the instance family is ``c6i``, not ``c6``. For more information, see [Amazon EC2 instance type naming conventions](https://docs.aws.amazon.com/ec2/latest/instancetypes/instance-type-names.html) in *Amazon EC2 Instance Types*.
                 The following instance types are *not supported* for performance protection.
                 +   ``c1`` 
                 +   ``g3| g3s`` 
                 +   ``hpc7g`` 
                 +   ``m1| m2`` 
                 +   ``mac1 | mac2 | mac2-m1ultra | mac2-m2 | mac2-m2pro`` 
                 +   ``p3dn | p4d | p5`` 
                 +   ``t1`` 
                 +   ``u-12tb1 | u-18tb1 | u-24tb1 | u-3tb1 | u-6tb1 | u-9tb1 | u7i-12tb | u7in-16tb | u7in-24tb | u7in-32tb`` 
                 
                If you performance protection by specifying a supported instance family, the returned instance types will exclude the preceding unsupported instance families.
                If you specify an unsupported instance family as a value for baseline performance, the API returns an empty response.
        """
        if instance_family is not None:
            pulumi.set(__self__, "instance_family", instance_family)

    @property
    @pulumi.getter(name="instanceFamily")
    def instance_family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The instance family to use as a baseline reference. 
          Make sure that you specify the correct value for the instance family. The instance family is everything before the period (.) in the instance type name. For example, in the instance ``c6i.large``, the instance family is ``c6i``, not ``c6``. For more information, see [Amazon EC2 instance type naming conventions](https://docs.aws.amazon.com/ec2/latest/instancetypes/instance-type-names.html) in *Amazon EC2 Instance Types*.
          The following instance types are *not supported* for performance protection.
          +   ``c1`` 
          +   ``g3| g3s`` 
          +   ``hpc7g`` 
          +   ``m1| m2`` 
          +   ``mac1 | mac2 | mac2-m1ultra | mac2-m2 | mac2-m2pro`` 
          +   ``p3dn | p4d | p5`` 
          +   ``t1`` 
          +   ``u-12tb1 | u-18tb1 | u-24tb1 | u-3tb1 | u-6tb1 | u-9tb1 | u7i-12tb | u7in-16tb | u7in-24tb | u7in-32tb`` 
          
         If you performance protection by specifying a supported instance family, the returned instance types will exclude the preceding unsupported instance families.
         If you specify an unsupported instance family as a value for baseline performance, the API returns an empty response.
        """
        return pulumi.get(self, "instance_family")

    @instance_family.setter
    def instance_family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_family", value)


if not MYPY:
    class AutoScalingGroupTagPropertyArgsDict(TypedDict):
        """
        A structure that specifies a tag for the ``Tags`` property of [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
         For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*. You can find a sample template snippet in the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html#aws-resource-autoscaling-autoscalinggroup--examples) section of the ``AWS::AutoScaling::AutoScalingGroup`` resource.
         CloudFormation adds the following tags to all Auto Scaling groups and associated instances: 
          +  aws:cloudformation:stack-name
          +  aws:cloudformation:stack-id
          +  aws:cloudformation:logical-id
        """
        key: pulumi.Input[builtins.str]
        """
        The tag key.
        """
        propagate_at_launch: pulumi.Input[builtins.bool]
        """
        Set to ``true`` if you want CloudFormation to copy the tag to EC2 instances that are launched as part of the Auto Scaling group. Set to ``false`` if you want the tag attached only to the Auto Scaling group and not copied to any instances launched as part of the Auto Scaling group.
        """
        value: pulumi.Input[builtins.str]
        """
        The tag value.
        """
elif False:
    AutoScalingGroupTagPropertyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupTagPropertyArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str],
                 propagate_at_launch: pulumi.Input[builtins.bool],
                 value: pulumi.Input[builtins.str]):
        """
        A structure that specifies a tag for the ``Tags`` property of [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
         For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*. You can find a sample template snippet in the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html#aws-resource-autoscaling-autoscalinggroup--examples) section of the ``AWS::AutoScaling::AutoScalingGroup`` resource.
         CloudFormation adds the following tags to all Auto Scaling groups and associated instances: 
          +  aws:cloudformation:stack-name
          +  aws:cloudformation:stack-id
          +  aws:cloudformation:logical-id
        :param pulumi.Input[builtins.str] key: The tag key.
        :param pulumi.Input[builtins.bool] propagate_at_launch: Set to ``true`` if you want CloudFormation to copy the tag to EC2 instances that are launched as part of the Auto Scaling group. Set to ``false`` if you want the tag attached only to the Auto Scaling group and not copied to any instances launched as part of the Auto Scaling group.
        :param pulumi.Input[builtins.str] value: The tag value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "propagate_at_launch", propagate_at_launch)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="propagateAtLaunch")
    def propagate_at_launch(self) -> pulumi.Input[builtins.bool]:
        """
        Set to ``true`` if you want CloudFormation to copy the tag to EC2 instances that are launched as part of the Auto Scaling group. Set to ``false`` if you want the tag attached only to the Auto Scaling group and not copied to any instances launched as part of the Auto Scaling group.
        """
        return pulumi.get(self, "propagate_at_launch")

    @propagate_at_launch.setter
    def propagate_at_launch(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "propagate_at_launch", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The tag value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class AutoScalingGroupTotalLocalStorageGbRequestArgsDict(TypedDict):
        """
        ``TotalLocalStorageGBRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum total local storage size for an instance type, in GB.
        """
        max: NotRequired[pulumi.Input[builtins.float]]
        """
        The storage maximum in GB.
        """
        min: NotRequired[pulumi.Input[builtins.float]]
        """
        The storage minimum in GB.
        """
elif False:
    AutoScalingGroupTotalLocalStorageGbRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupTotalLocalStorageGbRequestArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[builtins.float]] = None,
                 min: Optional[pulumi.Input[builtins.float]] = None):
        """
        ``TotalLocalStorageGBRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum total local storage size for an instance type, in GB.
        :param pulumi.Input[builtins.float] max: The storage maximum in GB.
        :param pulumi.Input[builtins.float] min: The storage minimum in GB.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The storage maximum in GB.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The storage minimum in GB.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "min", value)


if not MYPY:
    class AutoScalingGroupTrafficSourceIdentifierArgsDict(TypedDict):
        """
        Identifying information for a traffic source.
        """
        identifier: pulumi.Input[builtins.str]
        """
        Identifies the traffic source.
         For Application Load Balancers, Gateway Load Balancers, Network Load Balancers, and VPC Lattice, this will be the Amazon Resource Name (ARN) for a target group in this account and Region. For Classic Load Balancers, this will be the name of the Classic Load Balancer in this account and Region.
         For example: 
          +  Application Load Balancer ARN: ``arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/1234567890123456`` 
          +  Classic Load Balancer name: ``my-classic-load-balancer`` 
          +  VPC Lattice ARN: ``arn:aws:vpc-lattice:us-west-2:123456789012:targetgroup/tg-1234567890123456`` 
          
         To get the ARN of a target group for a Application Load Balancer, Gateway Load Balancer, or Network Load Balancer, or the name of a Classic Load Balancer, use the Elastic Load Balancing [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) and [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operations.
         To get the ARN of a target group for VPC Lattice, use the VPC Lattice [GetTargetGroup](https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetTargetGroup.html) API operation.
        """
        type: pulumi.Input[builtins.str]
        """
        Provides additional context for the value of ``Identifier``.
         The following lists the valid values:
          +   ``elb`` if ``Identifier`` is the name of a Classic Load Balancer.
          +   ``elbv2`` if ``Identifier`` is the ARN of an Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target group.
          +   ``vpc-lattice`` if ``Identifier`` is the ARN of a VPC Lattice target group.
          
         Required if the identifier is the name of a Classic Load Balancer.
        """
elif False:
    AutoScalingGroupTrafficSourceIdentifierArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupTrafficSourceIdentifierArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str]):
        """
        Identifying information for a traffic source.
        :param pulumi.Input[builtins.str] identifier: Identifies the traffic source.
                For Application Load Balancers, Gateway Load Balancers, Network Load Balancers, and VPC Lattice, this will be the Amazon Resource Name (ARN) for a target group in this account and Region. For Classic Load Balancers, this will be the name of the Classic Load Balancer in this account and Region.
                For example: 
                 +  Application Load Balancer ARN: ``arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/1234567890123456`` 
                 +  Classic Load Balancer name: ``my-classic-load-balancer`` 
                 +  VPC Lattice ARN: ``arn:aws:vpc-lattice:us-west-2:123456789012:targetgroup/tg-1234567890123456`` 
                 
                To get the ARN of a target group for a Application Load Balancer, Gateway Load Balancer, or Network Load Balancer, or the name of a Classic Load Balancer, use the Elastic Load Balancing [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) and [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operations.
                To get the ARN of a target group for VPC Lattice, use the VPC Lattice [GetTargetGroup](https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetTargetGroup.html) API operation.
        :param pulumi.Input[builtins.str] type: Provides additional context for the value of ``Identifier``.
                The following lists the valid values:
                 +   ``elb`` if ``Identifier`` is the name of a Classic Load Balancer.
                 +   ``elbv2`` if ``Identifier`` is the ARN of an Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target group.
                 +   ``vpc-lattice`` if ``Identifier`` is the ARN of a VPC Lattice target group.
                 
                Required if the identifier is the name of a Classic Load Balancer.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[builtins.str]:
        """
        Identifies the traffic source.
         For Application Load Balancers, Gateway Load Balancers, Network Load Balancers, and VPC Lattice, this will be the Amazon Resource Name (ARN) for a target group in this account and Region. For Classic Load Balancers, this will be the name of the Classic Load Balancer in this account and Region.
         For example: 
          +  Application Load Balancer ARN: ``arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/1234567890123456`` 
          +  Classic Load Balancer name: ``my-classic-load-balancer`` 
          +  VPC Lattice ARN: ``arn:aws:vpc-lattice:us-west-2:123456789012:targetgroup/tg-1234567890123456`` 
          
         To get the ARN of a target group for a Application Load Balancer, Gateway Load Balancer, or Network Load Balancer, or the name of a Classic Load Balancer, use the Elastic Load Balancing [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) and [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operations.
         To get the ARN of a target group for VPC Lattice, use the VPC Lattice [GetTargetGroup](https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetTargetGroup.html) API operation.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Provides additional context for the value of ``Identifier``.
         The following lists the valid values:
          +   ``elb`` if ``Identifier`` is the name of a Classic Load Balancer.
          +   ``elbv2`` if ``Identifier`` is the ARN of an Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target group.
          +   ``vpc-lattice`` if ``Identifier`` is the ARN of a VPC Lattice target group.
          
         Required if the identifier is the name of a Classic Load Balancer.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class AutoScalingGroupVCpuCountRequestArgsDict(TypedDict):
        """
        ``VCpuCountRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum number of vCPUs for an instance type.
        """
        max: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of vCPUs.
        """
        min: NotRequired[pulumi.Input[builtins.int]]
        """
        The minimum number of vCPUs.
        """
elif False:
    AutoScalingGroupVCpuCountRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoScalingGroupVCpuCountRequestArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[builtins.int]] = None,
                 min: Optional[pulumi.Input[builtins.int]] = None):
        """
        ``VCpuCountRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum number of vCPUs for an instance type.
        :param pulumi.Input[builtins.int] max: The maximum number of vCPUs.
        :param pulumi.Input[builtins.int] min: The minimum number of vCPUs.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of vCPUs.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of vCPUs.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min", value)


if not MYPY:
    class LaunchConfigurationBlockDeviceMappingArgsDict(TypedDict):
        """
        BlockDeviceMapping is a property of AWS::AutoScaling::LaunchConfiguration that describes a block device mapping for an Auto Scaling group.
        """
        device_name: pulumi.Input[builtins.str]
        """
        The device name exposed to the EC2 instance (for example, /dev/sdh or xvdh). 
        """
        ebs: NotRequired[pulumi.Input['LaunchConfigurationBlockDeviceArgsDict']]
        """
        Parameters used to automatically set up EBS volumes when an instance is launched.
        """
        no_device: NotRequired[pulumi.Input[builtins.bool]]
        """
        Setting this value to true suppresses the specified device included in the block device mapping of the AMI.
        """
        virtual_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the virtual device.
        """
elif False:
    LaunchConfigurationBlockDeviceMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LaunchConfigurationBlockDeviceMappingArgs:
    def __init__(__self__, *,
                 device_name: pulumi.Input[builtins.str],
                 ebs: Optional[pulumi.Input['LaunchConfigurationBlockDeviceArgs']] = None,
                 no_device: Optional[pulumi.Input[builtins.bool]] = None,
                 virtual_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        BlockDeviceMapping is a property of AWS::AutoScaling::LaunchConfiguration that describes a block device mapping for an Auto Scaling group.
        :param pulumi.Input[builtins.str] device_name: The device name exposed to the EC2 instance (for example, /dev/sdh or xvdh). 
        :param pulumi.Input['LaunchConfigurationBlockDeviceArgs'] ebs: Parameters used to automatically set up EBS volumes when an instance is launched.
        :param pulumi.Input[builtins.bool] no_device: Setting this value to true suppresses the specified device included in the block device mapping of the AMI.
        :param pulumi.Input[builtins.str] virtual_name: The name of the virtual device.
        """
        pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> pulumi.Input[builtins.str]:
        """
        The device name exposed to the EC2 instance (for example, /dev/sdh or xvdh). 
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter
    def ebs(self) -> Optional[pulumi.Input['LaunchConfigurationBlockDeviceArgs']]:
        """
        Parameters used to automatically set up EBS volumes when an instance is launched.
        """
        return pulumi.get(self, "ebs")

    @ebs.setter
    def ebs(self, value: Optional[pulumi.Input['LaunchConfigurationBlockDeviceArgs']]):
        pulumi.set(self, "ebs", value)

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Setting this value to true suppresses the specified device included in the block device mapping of the AMI.
        """
        return pulumi.get(self, "no_device")

    @no_device.setter
    def no_device(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "no_device", value)

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the virtual device.
        """
        return pulumi.get(self, "virtual_name")

    @virtual_name.setter
    def virtual_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_name", value)


if not MYPY:
    class LaunchConfigurationBlockDeviceArgsDict(TypedDict):
        """
        BlockDevice is a subproperty of BlockDeviceMapping that describes an Amazon EBS volume.
        """
        delete_on_termination: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether the volume is deleted on instance termination. 
        """
        encrypted: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether the volume should be encrypted. 
        """
        iops: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of input/output (I/O) operations per second (IOPS) to provision for the volume. 
        """
        snapshot_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The snapshot ID of the volume to use.
        """
        throughput: NotRequired[pulumi.Input[builtins.int]]
        """
        The throughput (MiBps) to provision for a gp3 volume.
        """
        volume_size: NotRequired[pulumi.Input[builtins.int]]
        """
        The volume size, in GiBs.
        """
        volume_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The volume type.
        """
elif False:
    LaunchConfigurationBlockDeviceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LaunchConfigurationBlockDeviceArgs:
    def __init__(__self__, *,
                 delete_on_termination: Optional[pulumi.Input[builtins.bool]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 iops: Optional[pulumi.Input[builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 throughput: Optional[pulumi.Input[builtins.int]] = None,
                 volume_size: Optional[pulumi.Input[builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        BlockDevice is a subproperty of BlockDeviceMapping that describes an Amazon EBS volume.
        :param pulumi.Input[builtins.bool] delete_on_termination: Indicates whether the volume is deleted on instance termination. 
        :param pulumi.Input[builtins.bool] encrypted: Specifies whether the volume should be encrypted. 
        :param pulumi.Input[builtins.int] iops: The number of input/output (I/O) operations per second (IOPS) to provision for the volume. 
        :param pulumi.Input[builtins.str] snapshot_id: The snapshot ID of the volume to use.
        :param pulumi.Input[builtins.int] throughput: The throughput (MiBps) to provision for a gp3 volume.
        :param pulumi.Input[builtins.int] volume_size: The volume size, in GiBs.
        :param pulumi.Input[builtins.str] volume_type: The volume type.
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the volume is deleted on instance termination. 
        """
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_on_termination", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the volume should be encrypted. 
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of input/output (I/O) operations per second (IOPS) to provision for the volume. 
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The snapshot ID of the volume to use.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The throughput (MiBps) to provision for a gp3 volume.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "throughput", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The volume size, in GiBs.
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "volume_size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The volume type.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_type", value)


if not MYPY:
    class LaunchConfigurationMetadataOptionsArgsDict(TypedDict):
        """
        MetadataOptions is a property of AWS::AutoScaling::LaunchConfiguration that describes metadata options for the instances.
        """
        http_endpoint: NotRequired[pulumi.Input[builtins.str]]
        """
        This parameter enables or disables the HTTP metadata endpoint on your instances.
        """
        http_put_response_hop_limit: NotRequired[pulumi.Input[builtins.int]]
        """
        The desired HTTP PUT response hop limit for instance metadata requests.
        """
        http_tokens: NotRequired[pulumi.Input[builtins.str]]
        """
        The state of token usage for your instance metadata requests.
        """
elif False:
    LaunchConfigurationMetadataOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LaunchConfigurationMetadataOptionsArgs:
    def __init__(__self__, *,
                 http_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 http_put_response_hop_limit: Optional[pulumi.Input[builtins.int]] = None,
                 http_tokens: Optional[pulumi.Input[builtins.str]] = None):
        """
        MetadataOptions is a property of AWS::AutoScaling::LaunchConfiguration that describes metadata options for the instances.
        :param pulumi.Input[builtins.str] http_endpoint: This parameter enables or disables the HTTP metadata endpoint on your instances.
        :param pulumi.Input[builtins.int] http_put_response_hop_limit: The desired HTTP PUT response hop limit for instance metadata requests.
        :param pulumi.Input[builtins.str] http_tokens: The state of token usage for your instance metadata requests.
        """
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)
        if http_tokens is not None:
            pulumi.set(__self__, "http_tokens", http_tokens)

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This parameter enables or disables the HTTP metadata endpoint on your instances.
        """
        return pulumi.get(self, "http_endpoint")

    @http_endpoint.setter
    def http_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_endpoint", value)

    @property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The desired HTTP PUT response hop limit for instance metadata requests.
        """
        return pulumi.get(self, "http_put_response_hop_limit")

    @http_put_response_hop_limit.setter
    def http_put_response_hop_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "http_put_response_hop_limit", value)

    @property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of token usage for your instance metadata requests.
        """
        return pulumi.get(self, "http_tokens")

    @http_tokens.setter
    def http_tokens(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_tokens", value)


if not MYPY:
    class ScalingPolicyCustomizedMetricSpecificationArgsDict(TypedDict):
        dimensions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDimensionArgsDict']]]]
        """
        The dimensions of the metric.

        Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
        """
        metric_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the metric. To get the exact metric name, namespace, and dimensions, inspect the [Metric](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html) object that is returned by a call to [ListMetrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html) .
        """
        metrics: NotRequired[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyTargetTrackingMetricDataQueryArgsDict']]]]
        """
        The metrics to include in the target tracking scaling policy, as a metric data query. This can include both raw metric and metric math expressions.
        """
        namespace: NotRequired[pulumi.Input[builtins.str]]
        """
        The namespace of the metric.
        """
        period: NotRequired[pulumi.Input[builtins.int]]
        """
        The period of the metric in seconds. The default value is 60. Accepted values are 10, 30, and 60. For high resolution metric, set the value to less than 60. For more information, see [Create a target tracking policy using high-resolution metrics for faster response](https://docs.aws.amazon.com/autoscaling/ec2/userguide/policy-creating-high-resolution-metrics.html) .
        """
        statistic: NotRequired[pulumi.Input[builtins.str]]
        """
        The statistic of the metric.
        """
        unit: NotRequired[pulumi.Input[builtins.str]]
        """
        The unit of the metric. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
elif False:
    ScalingPolicyCustomizedMetricSpecificationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyCustomizedMetricSpecificationArgs:
    def __init__(__self__, *,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDimensionArgs']]]] = None,
                 metric_name: Optional[pulumi.Input[builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyTargetTrackingMetricDataQueryArgs']]]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 period: Optional[pulumi.Input[builtins.int]] = None,
                 statistic: Optional[pulumi.Input[builtins.str]] = None,
                 unit: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDimensionArgs']]] dimensions: The dimensions of the metric.
               
               Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
        :param pulumi.Input[builtins.str] metric_name: The name of the metric. To get the exact metric name, namespace, and dimensions, inspect the [Metric](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html) object that is returned by a call to [ListMetrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html) .
        :param pulumi.Input[Sequence[pulumi.Input['ScalingPolicyTargetTrackingMetricDataQueryArgs']]] metrics: The metrics to include in the target tracking scaling policy, as a metric data query. This can include both raw metric and metric math expressions.
        :param pulumi.Input[builtins.str] namespace: The namespace of the metric.
        :param pulumi.Input[builtins.int] period: The period of the metric in seconds. The default value is 60. Accepted values are 10, 30, and 60. For high resolution metric, set the value to less than 60. For more information, see [Create a target tracking policy using high-resolution metrics for faster response](https://docs.aws.amazon.com/autoscaling/ec2/userguide/policy-creating-high-resolution-metrics.html) .
        :param pulumi.Input[builtins.str] statistic: The statistic of the metric.
        :param pulumi.Input[builtins.str] unit: The unit of the metric. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDimensionArgs']]]]:
        """
        The dimensions of the metric.

        Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the metric. To get the exact metric name, namespace, and dimensions, inspect the [Metric](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html) object that is returned by a call to [ListMetrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html) .
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyTargetTrackingMetricDataQueryArgs']]]]:
        """
        The metrics to include in the target tracking scaling policy, as a metric data query. This can include both raw metric and metric math expressions.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyTargetTrackingMetricDataQueryArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The namespace of the metric.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The period of the metric in seconds. The default value is 60. Accepted values are 10, 30, and 60. For high resolution metric, set the value to less than 60. For more information, see [Create a target tracking policy using high-resolution metrics for faster response](https://docs.aws.amazon.com/autoscaling/ec2/userguide/policy-creating-high-resolution-metrics.html) .
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def statistic(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The statistic of the metric.
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "statistic", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unit of the metric. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unit", value)


if not MYPY:
    class ScalingPolicyMetricDataQueryArgsDict(TypedDict):
        id: pulumi.Input[builtins.str]
        """
        A short name that identifies the object's results in the response. This name must be unique among all `MetricDataQuery` objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
        """
        expression: NotRequired[pulumi.Input[builtins.str]]
        """
        The math expression to perform on the returned data, if this object is performing a math expression. This expression can use the `Id` of the other metrics to refer to those metrics, and can also use the `Id` of other expressions to use the result of those expressions.

        Conditional: Within each `MetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        """
        label: NotRequired[pulumi.Input[builtins.str]]
        """
        A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
        """
        metric_stat: NotRequired[pulumi.Input['ScalingPolicyMetricStatArgsDict']]
        """
        Information about the metric data to return.

        Conditional: Within each `MetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        """
        return_data: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether to return the timestamps and raw data values of this metric.

        If you use any math expressions, specify `true` for this value for only the final math expression that the metric specification is based on. You must specify `false` for `ReturnData` for all the other metrics and expressions used in the metric specification.

        If you are only retrieving metrics and not performing any math expressions, do not specify anything for `ReturnData` . This sets it to its default ( `true` ).
        """
elif False:
    ScalingPolicyMetricDataQueryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyMetricDataQueryArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[builtins.str],
                 expression: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 metric_stat: Optional[pulumi.Input['ScalingPolicyMetricStatArgs']] = None,
                 return_data: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] id: A short name that identifies the object's results in the response. This name must be unique among all `MetricDataQuery` objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
        :param pulumi.Input[builtins.str] expression: The math expression to perform on the returned data, if this object is performing a math expression. This expression can use the `Id` of the other metrics to refer to those metrics, and can also use the `Id` of other expressions to use the result of those expressions.
               
               Conditional: Within each `MetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        :param pulumi.Input[builtins.str] label: A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
        :param pulumi.Input['ScalingPolicyMetricStatArgs'] metric_stat: Information about the metric data to return.
               
               Conditional: Within each `MetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        :param pulumi.Input[builtins.bool] return_data: Indicates whether to return the timestamps and raw data values of this metric.
               
               If you use any math expressions, specify `true` for this value for only the final math expression that the metric specification is based on. You must specify `false` for `ReturnData` for all the other metrics and expressions used in the metric specification.
               
               If you are only retrieving metrics and not performing any math expressions, do not specify anything for `ReturnData` . This sets it to its default ( `true` ).
        """
        pulumi.set(__self__, "id", id)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if metric_stat is not None:
            pulumi.set(__self__, "metric_stat", metric_stat)
        if return_data is not None:
            pulumi.set(__self__, "return_data", return_data)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[builtins.str]:
        """
        A short name that identifies the object's results in the response. This name must be unique among all `MetricDataQuery` objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The math expression to perform on the returned data, if this object is performing a math expression. This expression can use the `Id` of the other metrics to refer to those metrics, and can also use the `Id` of other expressions to use the result of those expressions.

        Conditional: Within each `MetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="metricStat")
    def metric_stat(self) -> Optional[pulumi.Input['ScalingPolicyMetricStatArgs']]:
        """
        Information about the metric data to return.

        Conditional: Within each `MetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        """
        return pulumi.get(self, "metric_stat")

    @metric_stat.setter
    def metric_stat(self, value: Optional[pulumi.Input['ScalingPolicyMetricStatArgs']]):
        pulumi.set(self, "metric_stat", value)

    @property
    @pulumi.getter(name="returnData")
    def return_data(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to return the timestamps and raw data values of this metric.

        If you use any math expressions, specify `true` for this value for only the final math expression that the metric specification is based on. You must specify `false` for `ReturnData` for all the other metrics and expressions used in the metric specification.

        If you are only retrieving metrics and not performing any math expressions, do not specify anything for `ReturnData` . This sets it to its default ( `true` ).
        """
        return pulumi.get(self, "return_data")

    @return_data.setter
    def return_data(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "return_data", value)


if not MYPY:
    class ScalingPolicyMetricDimensionArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the dimension.
        """
        value: pulumi.Input[builtins.str]
        """
        The value of the dimension.
        """
elif False:
    ScalingPolicyMetricDimensionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyMetricDimensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: The name of the dimension.
        :param pulumi.Input[builtins.str] value: The value of the dimension.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the dimension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The value of the dimension.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ScalingPolicyMetricStatArgsDict(TypedDict):
        metric: pulumi.Input['ScalingPolicyMetricArgsDict']
        """
        The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact metric name, namespace, and dimensions, inspect the [Metric](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html) object that is returned by a call to [ListMetrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html) .
        """
        stat: pulumi.Input[builtins.str]
        """
        The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *Amazon CloudWatch User Guide* .

        The most commonly used metrics for predictive scaling are `Average` and `Sum` .
        """
        unit: NotRequired[pulumi.Input[builtins.str]]
        """
        The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
elif False:
    ScalingPolicyMetricStatArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyMetricStatArgs:
    def __init__(__self__, *,
                 metric: pulumi.Input['ScalingPolicyMetricArgs'],
                 stat: pulumi.Input[builtins.str],
                 unit: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['ScalingPolicyMetricArgs'] metric: The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact metric name, namespace, and dimensions, inspect the [Metric](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html) object that is returned by a call to [ListMetrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html) .
        :param pulumi.Input[builtins.str] stat: The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *Amazon CloudWatch User Guide* .
               
               The most commonly used metrics for predictive scaling are `Average` and `Sum` .
        :param pulumi.Input[builtins.str] unit: The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "stat", stat)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input['ScalingPolicyMetricArgs']:
        """
        The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact metric name, namespace, and dimensions, inspect the [Metric](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html) object that is returned by a call to [ListMetrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html) .
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input['ScalingPolicyMetricArgs']):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def stat(self) -> pulumi.Input[builtins.str]:
        """
        The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *Amazon CloudWatch User Guide* .

        The most commonly used metrics for predictive scaling are `Average` and `Sum` .
        """
        return pulumi.get(self, "stat")

    @stat.setter
    def stat(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stat", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unit", value)


if not MYPY:
    class ScalingPolicyMetricArgsDict(TypedDict):
        metric_name: pulumi.Input[builtins.str]
        """
        The name of the metric.
        """
        namespace: pulumi.Input[builtins.str]
        """
        The namespace of the metric. For more information, see the table in [AWS services that publish CloudWatch metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html) in the *Amazon CloudWatch User Guide* .
        """
        dimensions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDimensionArgsDict']]]]
        """
        The dimensions for the metric. For the list of available dimensions, see the AWS documentation available from the table in [AWS services that publish CloudWatch metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html) in the *Amazon CloudWatch User Guide* .

        Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
        """
elif False:
    ScalingPolicyMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyMetricArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[builtins.str],
                 namespace: pulumi.Input[builtins.str],
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDimensionArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] metric_name: The name of the metric.
        :param pulumi.Input[builtins.str] namespace: The namespace of the metric. For more information, see the table in [AWS services that publish CloudWatch metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html) in the *Amazon CloudWatch User Guide* .
        :param pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDimensionArgs']]] dimensions: The dimensions for the metric. For the list of available dimensions, see the AWS documentation available from the table in [AWS services that publish CloudWatch metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html) in the *Amazon CloudWatch User Guide* .
               
               Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[builtins.str]:
        """
        The namespace of the metric. For more information, see the table in [AWS services that publish CloudWatch metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html) in the *Amazon CloudWatch User Guide* .
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDimensionArgs']]]]:
        """
        The dimensions for the metric. For the list of available dimensions, see the AWS documentation available from the table in [AWS services that publish CloudWatch metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html) in the *Amazon CloudWatch User Guide* .

        Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)


if not MYPY:
    class ScalingPolicyPredefinedMetricSpecificationArgsDict(TypedDict):
        predefined_metric_type: pulumi.Input[builtins.str]
        """
        The metric type. The following predefined metrics are available:

        - `ASGAverageCPUUtilization` - Average CPU utilization of the Auto Scaling group.
        - `ASGAverageNetworkIn` - Average number of bytes received on all network interfaces by the Auto Scaling group.
        - `ASGAverageNetworkOut` - Average number of bytes sent out on all network interfaces by the Auto Scaling group.
        - `ALBRequestCountPerTarget` - Average Application Load Balancer request count per target for your Auto Scaling group.
        """
        resource_label: NotRequired[pulumi.Input[builtins.str]]
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.

        You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:

        `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .

        Where:

        - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
        - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.

        To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
elif False:
    ScalingPolicyPredefinedMetricSpecificationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyPredefinedMetricSpecificationArgs:
    def __init__(__self__, *,
                 predefined_metric_type: pulumi.Input[builtins.str],
                 resource_label: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] predefined_metric_type: The metric type. The following predefined metrics are available:
               
               - `ASGAverageCPUUtilization` - Average CPU utilization of the Auto Scaling group.
               - `ASGAverageNetworkIn` - Average number of bytes received on all network interfaces by the Auto Scaling group.
               - `ASGAverageNetworkOut` - Average number of bytes sent out on all network interfaces by the Auto Scaling group.
               - `ALBRequestCountPerTarget` - Average Application Load Balancer request count per target for your Auto Scaling group.
        :param pulumi.Input[builtins.str] resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.
               
               You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
               
               `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .
               
               Where:
               
               - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
               - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.
               
               To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> pulumi.Input[builtins.str]:
        """
        The metric type. The following predefined metrics are available:

        - `ASGAverageCPUUtilization` - Average CPU utilization of the Auto Scaling group.
        - `ASGAverageNetworkIn` - Average number of bytes received on all network interfaces by the Auto Scaling group.
        - `ASGAverageNetworkOut` - Average number of bytes sent out on all network interfaces by the Auto Scaling group.
        - `ALBRequestCountPerTarget` - Average Application Load Balancer request count per target for your Auto Scaling group.
        """
        return pulumi.get(self, "predefined_metric_type")

    @predefined_metric_type.setter
    def predefined_metric_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "predefined_metric_type", value)

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.

        You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:

        `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .

        Where:

        - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
        - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.

        To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        return pulumi.get(self, "resource_label")

    @resource_label.setter
    def resource_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_label", value)


if not MYPY:
    class ScalingPolicyPredictiveScalingConfigurationArgsDict(TypedDict):
        metric_specifications: pulumi.Input[Sequence[pulumi.Input['ScalingPolicyPredictiveScalingMetricSpecificationArgsDict']]]
        """
        This structure includes the metrics and target utilization to use for predictive scaling.

        This is an array, but we currently only support a single metric specification. That is, you can specify a target value and a single metric pair, or a target value and one scaling metric and one load metric.
        """
        max_capacity_breach_behavior: NotRequired[pulumi.Input[builtins.str]]
        """
        Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group. Defaults to `HonorMaxCapacity` if not specified.

        The following are possible values:

        - `HonorMaxCapacity` - Amazon EC2 Auto Scaling can't increase the maximum capacity of the group when the forecast capacity is close to or exceeds the maximum capacity.
        - `IncreaseMaxCapacity` - Amazon EC2 Auto Scaling can increase the maximum capacity of the group when the forecast capacity is close to or exceeds the maximum capacity. The upper limit is determined by the forecasted capacity and the value for `MaxCapacityBuffer` .

        > Use caution when allowing the maximum capacity to be automatically increased. This can lead to more instances being launched than intended if the increased maximum capacity is not monitored and managed. The increased maximum capacity then becomes the new normal maximum capacity for the Auto Scaling group until you manually update it. The maximum capacity does not automatically decrease back to the original maximum.
        """
        max_capacity_buffer: NotRequired[pulumi.Input[builtins.int]]
        """
        The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.

        If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity.

        Required if the `MaxCapacityBreachBehavior` property is set to `IncreaseMaxCapacity` , and cannot be used otherwise.
        """
        mode: NotRequired[pulumi.Input[builtins.str]]
        """
        The predictive scaling mode. Defaults to `ForecastOnly` if not specified.
        """
        scheduling_buffer_time: NotRequired[pulumi.Input[builtins.int]]
        """
        The amount of time, in seconds, by which the instance launch time can be advanced. For example, the forecast says to add capacity at 10:00 AM, and you choose to pre-launch instances by 5 minutes. In that case, the instances will be launched at 9:55 AM. The intention is to give resources time to be provisioned. It can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete.

        The value must be less than the forecast interval duration of 3600 seconds (60 minutes). Defaults to 300 seconds if not specified.
        """
elif False:
    ScalingPolicyPredictiveScalingConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyPredictiveScalingConfigurationArgs:
    def __init__(__self__, *,
                 metric_specifications: pulumi.Input[Sequence[pulumi.Input['ScalingPolicyPredictiveScalingMetricSpecificationArgs']]],
                 max_capacity_breach_behavior: Optional[pulumi.Input[builtins.str]] = None,
                 max_capacity_buffer: Optional[pulumi.Input[builtins.int]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_buffer_time: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ScalingPolicyPredictiveScalingMetricSpecificationArgs']]] metric_specifications: This structure includes the metrics and target utilization to use for predictive scaling.
               
               This is an array, but we currently only support a single metric specification. That is, you can specify a target value and a single metric pair, or a target value and one scaling metric and one load metric.
        :param pulumi.Input[builtins.str] max_capacity_breach_behavior: Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group. Defaults to `HonorMaxCapacity` if not specified.
               
               The following are possible values:
               
               - `HonorMaxCapacity` - Amazon EC2 Auto Scaling can't increase the maximum capacity of the group when the forecast capacity is close to or exceeds the maximum capacity.
               - `IncreaseMaxCapacity` - Amazon EC2 Auto Scaling can increase the maximum capacity of the group when the forecast capacity is close to or exceeds the maximum capacity. The upper limit is determined by the forecasted capacity and the value for `MaxCapacityBuffer` .
               
               > Use caution when allowing the maximum capacity to be automatically increased. This can lead to more instances being launched than intended if the increased maximum capacity is not monitored and managed. The increased maximum capacity then becomes the new normal maximum capacity for the Auto Scaling group until you manually update it. The maximum capacity does not automatically decrease back to the original maximum.
        :param pulumi.Input[builtins.int] max_capacity_buffer: The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.
               
               If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity.
               
               Required if the `MaxCapacityBreachBehavior` property is set to `IncreaseMaxCapacity` , and cannot be used otherwise.
        :param pulumi.Input[builtins.str] mode: The predictive scaling mode. Defaults to `ForecastOnly` if not specified.
        :param pulumi.Input[builtins.int] scheduling_buffer_time: The amount of time, in seconds, by which the instance launch time can be advanced. For example, the forecast says to add capacity at 10:00 AM, and you choose to pre-launch instances by 5 minutes. In that case, the instances will be launched at 9:55 AM. The intention is to give resources time to be provisioned. It can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete.
               
               The value must be less than the forecast interval duration of 3600 seconds (60 minutes). Defaults to 300 seconds if not specified.
        """
        pulumi.set(__self__, "metric_specifications", metric_specifications)
        if max_capacity_breach_behavior is not None:
            pulumi.set(__self__, "max_capacity_breach_behavior", max_capacity_breach_behavior)
        if max_capacity_buffer is not None:
            pulumi.set(__self__, "max_capacity_buffer", max_capacity_buffer)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if scheduling_buffer_time is not None:
            pulumi.set(__self__, "scheduling_buffer_time", scheduling_buffer_time)

    @property
    @pulumi.getter(name="metricSpecifications")
    def metric_specifications(self) -> pulumi.Input[Sequence[pulumi.Input['ScalingPolicyPredictiveScalingMetricSpecificationArgs']]]:
        """
        This structure includes the metrics and target utilization to use for predictive scaling.

        This is an array, but we currently only support a single metric specification. That is, you can specify a target value and a single metric pair, or a target value and one scaling metric and one load metric.
        """
        return pulumi.get(self, "metric_specifications")

    @metric_specifications.setter
    def metric_specifications(self, value: pulumi.Input[Sequence[pulumi.Input['ScalingPolicyPredictiveScalingMetricSpecificationArgs']]]):
        pulumi.set(self, "metric_specifications", value)

    @property
    @pulumi.getter(name="maxCapacityBreachBehavior")
    def max_capacity_breach_behavior(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group. Defaults to `HonorMaxCapacity` if not specified.

        The following are possible values:

        - `HonorMaxCapacity` - Amazon EC2 Auto Scaling can't increase the maximum capacity of the group when the forecast capacity is close to or exceeds the maximum capacity.
        - `IncreaseMaxCapacity` - Amazon EC2 Auto Scaling can increase the maximum capacity of the group when the forecast capacity is close to or exceeds the maximum capacity. The upper limit is determined by the forecasted capacity and the value for `MaxCapacityBuffer` .

        > Use caution when allowing the maximum capacity to be automatically increased. This can lead to more instances being launched than intended if the increased maximum capacity is not monitored and managed. The increased maximum capacity then becomes the new normal maximum capacity for the Auto Scaling group until you manually update it. The maximum capacity does not automatically decrease back to the original maximum.
        """
        return pulumi.get(self, "max_capacity_breach_behavior")

    @max_capacity_breach_behavior.setter
    def max_capacity_breach_behavior(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_capacity_breach_behavior", value)

    @property
    @pulumi.getter(name="maxCapacityBuffer")
    def max_capacity_buffer(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.

        If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity.

        Required if the `MaxCapacityBreachBehavior` property is set to `IncreaseMaxCapacity` , and cannot be used otherwise.
        """
        return pulumi.get(self, "max_capacity_buffer")

    @max_capacity_buffer.setter
    def max_capacity_buffer(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_capacity_buffer", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The predictive scaling mode. Defaults to `ForecastOnly` if not specified.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="schedulingBufferTime")
    def scheduling_buffer_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of time, in seconds, by which the instance launch time can be advanced. For example, the forecast says to add capacity at 10:00 AM, and you choose to pre-launch instances by 5 minutes. In that case, the instances will be launched at 9:55 AM. The intention is to give resources time to be provisioned. It can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete.

        The value must be less than the forecast interval duration of 3600 seconds (60 minutes). Defaults to 300 seconds if not specified.
        """
        return pulumi.get(self, "scheduling_buffer_time")

    @scheduling_buffer_time.setter
    def scheduling_buffer_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "scheduling_buffer_time", value)


if not MYPY:
    class ScalingPolicyPredictiveScalingCustomizedCapacityMetricArgsDict(TypedDict):
        metric_data_queries: pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgsDict']]]
        """
        One or more metric data queries to provide the data points for a capacity metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
elif False:
    ScalingPolicyPredictiveScalingCustomizedCapacityMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyPredictiveScalingCustomizedCapacityMetricArgs:
    def __init__(__self__, *,
                 metric_data_queries: pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgs']]] metric_data_queries: One or more metric data queries to provide the data points for a capacity metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
        pulumi.set(__self__, "metric_data_queries", metric_data_queries)

    @property
    @pulumi.getter(name="metricDataQueries")
    def metric_data_queries(self) -> pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgs']]]:
        """
        One or more metric data queries to provide the data points for a capacity metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
        return pulumi.get(self, "metric_data_queries")

    @metric_data_queries.setter
    def metric_data_queries(self, value: pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgs']]]):
        pulumi.set(self, "metric_data_queries", value)


if not MYPY:
    class ScalingPolicyPredictiveScalingCustomizedLoadMetricArgsDict(TypedDict):
        metric_data_queries: pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgsDict']]]
        """
        One or more metric data queries to provide the data points for a load metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
elif False:
    ScalingPolicyPredictiveScalingCustomizedLoadMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyPredictiveScalingCustomizedLoadMetricArgs:
    def __init__(__self__, *,
                 metric_data_queries: pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgs']]] metric_data_queries: One or more metric data queries to provide the data points for a load metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
        pulumi.set(__self__, "metric_data_queries", metric_data_queries)

    @property
    @pulumi.getter(name="metricDataQueries")
    def metric_data_queries(self) -> pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgs']]]:
        """
        One or more metric data queries to provide the data points for a load metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
        return pulumi.get(self, "metric_data_queries")

    @metric_data_queries.setter
    def metric_data_queries(self, value: pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgs']]]):
        pulumi.set(self, "metric_data_queries", value)


if not MYPY:
    class ScalingPolicyPredictiveScalingCustomizedScalingMetricArgsDict(TypedDict):
        metric_data_queries: pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgsDict']]]
        """
        One or more metric data queries to provide the data points for a scaling metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
elif False:
    ScalingPolicyPredictiveScalingCustomizedScalingMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyPredictiveScalingCustomizedScalingMetricArgs:
    def __init__(__self__, *,
                 metric_data_queries: pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgs']]] metric_data_queries: One or more metric data queries to provide the data points for a scaling metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
        pulumi.set(__self__, "metric_data_queries", metric_data_queries)

    @property
    @pulumi.getter(name="metricDataQueries")
    def metric_data_queries(self) -> pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgs']]]:
        """
        One or more metric data queries to provide the data points for a scaling metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
        return pulumi.get(self, "metric_data_queries")

    @metric_data_queries.setter
    def metric_data_queries(self, value: pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDataQueryArgs']]]):
        pulumi.set(self, "metric_data_queries", value)


if not MYPY:
    class ScalingPolicyPredictiveScalingMetricSpecificationArgsDict(TypedDict):
        target_value: pulumi.Input[builtins.float]
        """
        Specifies the target utilization.

        > Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
        """
        customized_capacity_metric_specification: NotRequired[pulumi.Input['ScalingPolicyPredictiveScalingCustomizedCapacityMetricArgsDict']]
        """
        The customized capacity metric specification.
        """
        customized_load_metric_specification: NotRequired[pulumi.Input['ScalingPolicyPredictiveScalingCustomizedLoadMetricArgsDict']]
        """
        The customized load metric specification.
        """
        customized_scaling_metric_specification: NotRequired[pulumi.Input['ScalingPolicyPredictiveScalingCustomizedScalingMetricArgsDict']]
        """
        The customized scaling metric specification.
        """
        predefined_load_metric_specification: NotRequired[pulumi.Input['ScalingPolicyPredictiveScalingPredefinedLoadMetricArgsDict']]
        """
        The predefined load metric specification.
        """
        predefined_metric_pair_specification: NotRequired[pulumi.Input['ScalingPolicyPredictiveScalingPredefinedMetricPairArgsDict']]
        """
        The predefined metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
        """
        predefined_scaling_metric_specification: NotRequired[pulumi.Input['ScalingPolicyPredictiveScalingPredefinedScalingMetricArgsDict']]
        """
        The predefined scaling metric specification.
        """
elif False:
    ScalingPolicyPredictiveScalingMetricSpecificationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyPredictiveScalingMetricSpecificationArgs:
    def __init__(__self__, *,
                 target_value: pulumi.Input[builtins.float],
                 customized_capacity_metric_specification: Optional[pulumi.Input['ScalingPolicyPredictiveScalingCustomizedCapacityMetricArgs']] = None,
                 customized_load_metric_specification: Optional[pulumi.Input['ScalingPolicyPredictiveScalingCustomizedLoadMetricArgs']] = None,
                 customized_scaling_metric_specification: Optional[pulumi.Input['ScalingPolicyPredictiveScalingCustomizedScalingMetricArgs']] = None,
                 predefined_load_metric_specification: Optional[pulumi.Input['ScalingPolicyPredictiveScalingPredefinedLoadMetricArgs']] = None,
                 predefined_metric_pair_specification: Optional[pulumi.Input['ScalingPolicyPredictiveScalingPredefinedMetricPairArgs']] = None,
                 predefined_scaling_metric_specification: Optional[pulumi.Input['ScalingPolicyPredictiveScalingPredefinedScalingMetricArgs']] = None):
        """
        :param pulumi.Input[builtins.float] target_value: Specifies the target utilization.
               
               > Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
        :param pulumi.Input['ScalingPolicyPredictiveScalingCustomizedCapacityMetricArgs'] customized_capacity_metric_specification: The customized capacity metric specification.
        :param pulumi.Input['ScalingPolicyPredictiveScalingCustomizedLoadMetricArgs'] customized_load_metric_specification: The customized load metric specification.
        :param pulumi.Input['ScalingPolicyPredictiveScalingCustomizedScalingMetricArgs'] customized_scaling_metric_specification: The customized scaling metric specification.
        :param pulumi.Input['ScalingPolicyPredictiveScalingPredefinedLoadMetricArgs'] predefined_load_metric_specification: The predefined load metric specification.
        :param pulumi.Input['ScalingPolicyPredictiveScalingPredefinedMetricPairArgs'] predefined_metric_pair_specification: The predefined metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
        :param pulumi.Input['ScalingPolicyPredictiveScalingPredefinedScalingMetricArgs'] predefined_scaling_metric_specification: The predefined scaling metric specification.
        """
        pulumi.set(__self__, "target_value", target_value)
        if customized_capacity_metric_specification is not None:
            pulumi.set(__self__, "customized_capacity_metric_specification", customized_capacity_metric_specification)
        if customized_load_metric_specification is not None:
            pulumi.set(__self__, "customized_load_metric_specification", customized_load_metric_specification)
        if customized_scaling_metric_specification is not None:
            pulumi.set(__self__, "customized_scaling_metric_specification", customized_scaling_metric_specification)
        if predefined_load_metric_specification is not None:
            pulumi.set(__self__, "predefined_load_metric_specification", predefined_load_metric_specification)
        if predefined_metric_pair_specification is not None:
            pulumi.set(__self__, "predefined_metric_pair_specification", predefined_metric_pair_specification)
        if predefined_scaling_metric_specification is not None:
            pulumi.set(__self__, "predefined_scaling_metric_specification", predefined_scaling_metric_specification)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> pulumi.Input[builtins.float]:
        """
        Specifies the target utilization.

        > Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
        """
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "target_value", value)

    @property
    @pulumi.getter(name="customizedCapacityMetricSpecification")
    def customized_capacity_metric_specification(self) -> Optional[pulumi.Input['ScalingPolicyPredictiveScalingCustomizedCapacityMetricArgs']]:
        """
        The customized capacity metric specification.
        """
        return pulumi.get(self, "customized_capacity_metric_specification")

    @customized_capacity_metric_specification.setter
    def customized_capacity_metric_specification(self, value: Optional[pulumi.Input['ScalingPolicyPredictiveScalingCustomizedCapacityMetricArgs']]):
        pulumi.set(self, "customized_capacity_metric_specification", value)

    @property
    @pulumi.getter(name="customizedLoadMetricSpecification")
    def customized_load_metric_specification(self) -> Optional[pulumi.Input['ScalingPolicyPredictiveScalingCustomizedLoadMetricArgs']]:
        """
        The customized load metric specification.
        """
        return pulumi.get(self, "customized_load_metric_specification")

    @customized_load_metric_specification.setter
    def customized_load_metric_specification(self, value: Optional[pulumi.Input['ScalingPolicyPredictiveScalingCustomizedLoadMetricArgs']]):
        pulumi.set(self, "customized_load_metric_specification", value)

    @property
    @pulumi.getter(name="customizedScalingMetricSpecification")
    def customized_scaling_metric_specification(self) -> Optional[pulumi.Input['ScalingPolicyPredictiveScalingCustomizedScalingMetricArgs']]:
        """
        The customized scaling metric specification.
        """
        return pulumi.get(self, "customized_scaling_metric_specification")

    @customized_scaling_metric_specification.setter
    def customized_scaling_metric_specification(self, value: Optional[pulumi.Input['ScalingPolicyPredictiveScalingCustomizedScalingMetricArgs']]):
        pulumi.set(self, "customized_scaling_metric_specification", value)

    @property
    @pulumi.getter(name="predefinedLoadMetricSpecification")
    def predefined_load_metric_specification(self) -> Optional[pulumi.Input['ScalingPolicyPredictiveScalingPredefinedLoadMetricArgs']]:
        """
        The predefined load metric specification.
        """
        return pulumi.get(self, "predefined_load_metric_specification")

    @predefined_load_metric_specification.setter
    def predefined_load_metric_specification(self, value: Optional[pulumi.Input['ScalingPolicyPredictiveScalingPredefinedLoadMetricArgs']]):
        pulumi.set(self, "predefined_load_metric_specification", value)

    @property
    @pulumi.getter(name="predefinedMetricPairSpecification")
    def predefined_metric_pair_specification(self) -> Optional[pulumi.Input['ScalingPolicyPredictiveScalingPredefinedMetricPairArgs']]:
        """
        The predefined metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
        """
        return pulumi.get(self, "predefined_metric_pair_specification")

    @predefined_metric_pair_specification.setter
    def predefined_metric_pair_specification(self, value: Optional[pulumi.Input['ScalingPolicyPredictiveScalingPredefinedMetricPairArgs']]):
        pulumi.set(self, "predefined_metric_pair_specification", value)

    @property
    @pulumi.getter(name="predefinedScalingMetricSpecification")
    def predefined_scaling_metric_specification(self) -> Optional[pulumi.Input['ScalingPolicyPredictiveScalingPredefinedScalingMetricArgs']]:
        """
        The predefined scaling metric specification.
        """
        return pulumi.get(self, "predefined_scaling_metric_specification")

    @predefined_scaling_metric_specification.setter
    def predefined_scaling_metric_specification(self, value: Optional[pulumi.Input['ScalingPolicyPredictiveScalingPredefinedScalingMetricArgs']]):
        pulumi.set(self, "predefined_scaling_metric_specification", value)


if not MYPY:
    class ScalingPolicyPredictiveScalingPredefinedLoadMetricArgsDict(TypedDict):
        predefined_metric_type: pulumi.Input[builtins.str]
        """
        The metric type.
        """
        resource_label: NotRequired[pulumi.Input[builtins.str]]
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.

        You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:

        `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .

        Where:

        - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
        - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.

        To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
elif False:
    ScalingPolicyPredictiveScalingPredefinedLoadMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyPredictiveScalingPredefinedLoadMetricArgs:
    def __init__(__self__, *,
                 predefined_metric_type: pulumi.Input[builtins.str],
                 resource_label: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] predefined_metric_type: The metric type.
        :param pulumi.Input[builtins.str] resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.
               
               You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
               
               `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .
               
               Where:
               
               - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
               - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.
               
               To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> pulumi.Input[builtins.str]:
        """
        The metric type.
        """
        return pulumi.get(self, "predefined_metric_type")

    @predefined_metric_type.setter
    def predefined_metric_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "predefined_metric_type", value)

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.

        You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:

        `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .

        Where:

        - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
        - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.

        To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        return pulumi.get(self, "resource_label")

    @resource_label.setter
    def resource_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_label", value)


if not MYPY:
    class ScalingPolicyPredictiveScalingPredefinedMetricPairArgsDict(TypedDict):
        predefined_metric_type: pulumi.Input[builtins.str]
        """
        Indicates which metrics to use. There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric. For example, if the metric type is `ASGCPUUtilization` , the Auto Scaling group's total CPU metric is used as the load metric, and the average CPU metric is used for the scaling metric.
        """
        resource_label: NotRequired[pulumi.Input[builtins.str]]
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the total and average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.

        You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:

        `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .

        Where:

        - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
        - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.

        To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
elif False:
    ScalingPolicyPredictiveScalingPredefinedMetricPairArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyPredictiveScalingPredefinedMetricPairArgs:
    def __init__(__self__, *,
                 predefined_metric_type: pulumi.Input[builtins.str],
                 resource_label: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] predefined_metric_type: Indicates which metrics to use. There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric. For example, if the metric type is `ASGCPUUtilization` , the Auto Scaling group's total CPU metric is used as the load metric, and the average CPU metric is used for the scaling metric.
        :param pulumi.Input[builtins.str] resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the total and average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.
               
               You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
               
               `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .
               
               Where:
               
               - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
               - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.
               
               To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> pulumi.Input[builtins.str]:
        """
        Indicates which metrics to use. There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric. For example, if the metric type is `ASGCPUUtilization` , the Auto Scaling group's total CPU metric is used as the load metric, and the average CPU metric is used for the scaling metric.
        """
        return pulumi.get(self, "predefined_metric_type")

    @predefined_metric_type.setter
    def predefined_metric_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "predefined_metric_type", value)

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the total and average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.

        You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:

        `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .

        Where:

        - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
        - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.

        To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        return pulumi.get(self, "resource_label")

    @resource_label.setter
    def resource_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_label", value)


if not MYPY:
    class ScalingPolicyPredictiveScalingPredefinedScalingMetricArgsDict(TypedDict):
        predefined_metric_type: pulumi.Input[builtins.str]
        """
        The metric type.
        """
        resource_label: NotRequired[pulumi.Input[builtins.str]]
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.

        You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:

        `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .

        Where:

        - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
        - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.

        To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
elif False:
    ScalingPolicyPredictiveScalingPredefinedScalingMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyPredictiveScalingPredefinedScalingMetricArgs:
    def __init__(__self__, *,
                 predefined_metric_type: pulumi.Input[builtins.str],
                 resource_label: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] predefined_metric_type: The metric type.
        :param pulumi.Input[builtins.str] resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.
               
               You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
               
               `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .
               
               Where:
               
               - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
               - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.
               
               To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> pulumi.Input[builtins.str]:
        """
        The metric type.
        """
        return pulumi.get(self, "predefined_metric_type")

    @predefined_metric_type.setter
    def predefined_metric_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "predefined_metric_type", value)

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.

        You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:

        `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .

        Where:

        - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
        - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.

        To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        return pulumi.get(self, "resource_label")

    @resource_label.setter
    def resource_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_label", value)


if not MYPY:
    class ScalingPolicyStepAdjustmentArgsDict(TypedDict):
        scaling_adjustment: pulumi.Input[builtins.int]
        """
        The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a non-negative value.
        """
        metric_interval_lower_bound: NotRequired[pulumi.Input[builtins.float]]
        """
        The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
        """
        metric_interval_upper_bound: NotRequired[pulumi.Input[builtins.float]]
        """
        The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.

        The upper bound must be greater than the lower bound.
        """
elif False:
    ScalingPolicyStepAdjustmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyStepAdjustmentArgs:
    def __init__(__self__, *,
                 scaling_adjustment: pulumi.Input[builtins.int],
                 metric_interval_lower_bound: Optional[pulumi.Input[builtins.float]] = None,
                 metric_interval_upper_bound: Optional[pulumi.Input[builtins.float]] = None):
        """
        :param pulumi.Input[builtins.int] scaling_adjustment: The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a non-negative value.
        :param pulumi.Input[builtins.float] metric_interval_lower_bound: The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
        :param pulumi.Input[builtins.float] metric_interval_upper_bound: The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.
               
               The upper bound must be greater than the lower bound.
        """
        pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)
        if metric_interval_lower_bound is not None:
            pulumi.set(__self__, "metric_interval_lower_bound", metric_interval_lower_bound)
        if metric_interval_upper_bound is not None:
            pulumi.set(__self__, "metric_interval_upper_bound", metric_interval_upper_bound)

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> pulumi.Input[builtins.int]:
        """
        The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a non-negative value.
        """
        return pulumi.get(self, "scaling_adjustment")

    @scaling_adjustment.setter
    def scaling_adjustment(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "scaling_adjustment", value)

    @property
    @pulumi.getter(name="metricIntervalLowerBound")
    def metric_interval_lower_bound(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
        """
        return pulumi.get(self, "metric_interval_lower_bound")

    @metric_interval_lower_bound.setter
    def metric_interval_lower_bound(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "metric_interval_lower_bound", value)

    @property
    @pulumi.getter(name="metricIntervalUpperBound")
    def metric_interval_upper_bound(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.

        The upper bound must be greater than the lower bound.
        """
        return pulumi.get(self, "metric_interval_upper_bound")

    @metric_interval_upper_bound.setter
    def metric_interval_upper_bound(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "metric_interval_upper_bound", value)


if not MYPY:
    class ScalingPolicyTargetTrackingConfigurationArgsDict(TypedDict):
        target_value: pulumi.Input[builtins.float]
        """
        The target value for the metric.

        > Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
        """
        customized_metric_specification: NotRequired[pulumi.Input['ScalingPolicyCustomizedMetricSpecificationArgsDict']]
        """
        A customized metric. You must specify either a predefined metric or a customized metric.
        """
        disable_scale_in: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether scaling in by the target tracking scaling policy is disabled. If scaling in is disabled, the target tracking scaling policy doesn't remove instances from the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from the Auto Scaling group. The default is `false` .
        """
        predefined_metric_specification: NotRequired[pulumi.Input['ScalingPolicyPredefinedMetricSpecificationArgsDict']]
        """
        A predefined metric. You must specify either a predefined metric or a customized metric.
        """
elif False:
    ScalingPolicyTargetTrackingConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyTargetTrackingConfigurationArgs:
    def __init__(__self__, *,
                 target_value: pulumi.Input[builtins.float],
                 customized_metric_specification: Optional[pulumi.Input['ScalingPolicyCustomizedMetricSpecificationArgs']] = None,
                 disable_scale_in: Optional[pulumi.Input[builtins.bool]] = None,
                 predefined_metric_specification: Optional[pulumi.Input['ScalingPolicyPredefinedMetricSpecificationArgs']] = None):
        """
        :param pulumi.Input[builtins.float] target_value: The target value for the metric.
               
               > Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
        :param pulumi.Input['ScalingPolicyCustomizedMetricSpecificationArgs'] customized_metric_specification: A customized metric. You must specify either a predefined metric or a customized metric.
        :param pulumi.Input[builtins.bool] disable_scale_in: Indicates whether scaling in by the target tracking scaling policy is disabled. If scaling in is disabled, the target tracking scaling policy doesn't remove instances from the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from the Auto Scaling group. The default is `false` .
        :param pulumi.Input['ScalingPolicyPredefinedMetricSpecificationArgs'] predefined_metric_specification: A predefined metric. You must specify either a predefined metric or a customized metric.
        """
        pulumi.set(__self__, "target_value", target_value)
        if customized_metric_specification is not None:
            pulumi.set(__self__, "customized_metric_specification", customized_metric_specification)
        if disable_scale_in is not None:
            pulumi.set(__self__, "disable_scale_in", disable_scale_in)
        if predefined_metric_specification is not None:
            pulumi.set(__self__, "predefined_metric_specification", predefined_metric_specification)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> pulumi.Input[builtins.float]:
        """
        The target value for the metric.

        > Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
        """
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "target_value", value)

    @property
    @pulumi.getter(name="customizedMetricSpecification")
    def customized_metric_specification(self) -> Optional[pulumi.Input['ScalingPolicyCustomizedMetricSpecificationArgs']]:
        """
        A customized metric. You must specify either a predefined metric or a customized metric.
        """
        return pulumi.get(self, "customized_metric_specification")

    @customized_metric_specification.setter
    def customized_metric_specification(self, value: Optional[pulumi.Input['ScalingPolicyCustomizedMetricSpecificationArgs']]):
        pulumi.set(self, "customized_metric_specification", value)

    @property
    @pulumi.getter(name="disableScaleIn")
    def disable_scale_in(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether scaling in by the target tracking scaling policy is disabled. If scaling in is disabled, the target tracking scaling policy doesn't remove instances from the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from the Auto Scaling group. The default is `false` .
        """
        return pulumi.get(self, "disable_scale_in")

    @disable_scale_in.setter
    def disable_scale_in(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_scale_in", value)

    @property
    @pulumi.getter(name="predefinedMetricSpecification")
    def predefined_metric_specification(self) -> Optional[pulumi.Input['ScalingPolicyPredefinedMetricSpecificationArgs']]:
        """
        A predefined metric. You must specify either a predefined metric or a customized metric.
        """
        return pulumi.get(self, "predefined_metric_specification")

    @predefined_metric_specification.setter
    def predefined_metric_specification(self, value: Optional[pulumi.Input['ScalingPolicyPredefinedMetricSpecificationArgs']]):
        pulumi.set(self, "predefined_metric_specification", value)


if not MYPY:
    class ScalingPolicyTargetTrackingMetricDataQueryArgsDict(TypedDict):
        id: pulumi.Input[builtins.str]
        """
        A short name that identifies the object's results in the response. This name must be unique among all `TargetTrackingMetricDataQuery` objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
        """
        expression: NotRequired[pulumi.Input[builtins.str]]
        """
        The math expression to perform on the returned data, if this object is performing a math expression. This expression can use the `Id` of the other metrics to refer to those metrics, and can also use the `Id` of other expressions to use the result of those expressions.

        Conditional: Within each `TargetTrackingMetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        """
        label: NotRequired[pulumi.Input[builtins.str]]
        """
        A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
        """
        metric_stat: NotRequired[pulumi.Input['ScalingPolicyTargetTrackingMetricStatArgsDict']]
        """
        Information about the metric data to return.

        Conditional: Within each `TargetTrackingMetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        """
        period: NotRequired[pulumi.Input[builtins.int]]
        """
        The period of the metric in seconds. The default value is 60. Accepted values are 10, 30, and 60. For high resolution metric, set the value to less than 60. For more information, see [Create a target tracking policy using high-resolution metrics for faster response](https://docs.aws.amazon.com/autoscaling/ec2/userguide/policy-creating-high-resolution-metrics.html) .
        """
        return_data: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether to return the timestamps and raw data values of this metric.

        If you use any math expressions, specify `true` for this value for only the final math expression that the metric specification is based on. You must specify `false` for `ReturnData` for all the other metrics and expressions used in the metric specification.

        If you are only retrieving metrics and not performing any math expressions, do not specify anything for `ReturnData` . This sets it to its default ( `true` ).
        """
elif False:
    ScalingPolicyTargetTrackingMetricDataQueryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyTargetTrackingMetricDataQueryArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[builtins.str],
                 expression: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 metric_stat: Optional[pulumi.Input['ScalingPolicyTargetTrackingMetricStatArgs']] = None,
                 period: Optional[pulumi.Input[builtins.int]] = None,
                 return_data: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] id: A short name that identifies the object's results in the response. This name must be unique among all `TargetTrackingMetricDataQuery` objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
        :param pulumi.Input[builtins.str] expression: The math expression to perform on the returned data, if this object is performing a math expression. This expression can use the `Id` of the other metrics to refer to those metrics, and can also use the `Id` of other expressions to use the result of those expressions.
               
               Conditional: Within each `TargetTrackingMetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        :param pulumi.Input[builtins.str] label: A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
        :param pulumi.Input['ScalingPolicyTargetTrackingMetricStatArgs'] metric_stat: Information about the metric data to return.
               
               Conditional: Within each `TargetTrackingMetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        :param pulumi.Input[builtins.int] period: The period of the metric in seconds. The default value is 60. Accepted values are 10, 30, and 60. For high resolution metric, set the value to less than 60. For more information, see [Create a target tracking policy using high-resolution metrics for faster response](https://docs.aws.amazon.com/autoscaling/ec2/userguide/policy-creating-high-resolution-metrics.html) .
        :param pulumi.Input[builtins.bool] return_data: Indicates whether to return the timestamps and raw data values of this metric.
               
               If you use any math expressions, specify `true` for this value for only the final math expression that the metric specification is based on. You must specify `false` for `ReturnData` for all the other metrics and expressions used in the metric specification.
               
               If you are only retrieving metrics and not performing any math expressions, do not specify anything for `ReturnData` . This sets it to its default ( `true` ).
        """
        pulumi.set(__self__, "id", id)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if metric_stat is not None:
            pulumi.set(__self__, "metric_stat", metric_stat)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if return_data is not None:
            pulumi.set(__self__, "return_data", return_data)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[builtins.str]:
        """
        A short name that identifies the object's results in the response. This name must be unique among all `TargetTrackingMetricDataQuery` objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The math expression to perform on the returned data, if this object is performing a math expression. This expression can use the `Id` of the other metrics to refer to those metrics, and can also use the `Id` of other expressions to use the result of those expressions.

        Conditional: Within each `TargetTrackingMetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="metricStat")
    def metric_stat(self) -> Optional[pulumi.Input['ScalingPolicyTargetTrackingMetricStatArgs']]:
        """
        Information about the metric data to return.

        Conditional: Within each `TargetTrackingMetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        """
        return pulumi.get(self, "metric_stat")

    @metric_stat.setter
    def metric_stat(self, value: Optional[pulumi.Input['ScalingPolicyTargetTrackingMetricStatArgs']]):
        pulumi.set(self, "metric_stat", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The period of the metric in seconds. The default value is 60. Accepted values are 10, 30, and 60. For high resolution metric, set the value to less than 60. For more information, see [Create a target tracking policy using high-resolution metrics for faster response](https://docs.aws.amazon.com/autoscaling/ec2/userguide/policy-creating-high-resolution-metrics.html) .
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="returnData")
    def return_data(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to return the timestamps and raw data values of this metric.

        If you use any math expressions, specify `true` for this value for only the final math expression that the metric specification is based on. You must specify `false` for `ReturnData` for all the other metrics and expressions used in the metric specification.

        If you are only retrieving metrics and not performing any math expressions, do not specify anything for `ReturnData` . This sets it to its default ( `true` ).
        """
        return pulumi.get(self, "return_data")

    @return_data.setter
    def return_data(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "return_data", value)


if not MYPY:
    class ScalingPolicyTargetTrackingMetricStatArgsDict(TypedDict):
        metric: pulumi.Input['ScalingPolicyMetricArgsDict']
        """
        The metric to use.
        """
        stat: pulumi.Input[builtins.str]
        """
        The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *Amazon CloudWatch User Guide* .

        The most commonly used metric for scaling is `Average` .
        """
        period: NotRequired[pulumi.Input[builtins.int]]
        """
        The period of the metric in seconds. The default value is 60. Accepted values are 10, 30, and 60. For high resolution metric, set the value to less than 60. For more information, see [Create a target tracking policy using high-resolution metrics for faster response](https://docs.aws.amazon.com/autoscaling/ec2/userguide/policy-creating-high-resolution-metrics.html) .
        """
        unit: NotRequired[pulumi.Input[builtins.str]]
        """
        The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
elif False:
    ScalingPolicyTargetTrackingMetricStatArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPolicyTargetTrackingMetricStatArgs:
    def __init__(__self__, *,
                 metric: pulumi.Input['ScalingPolicyMetricArgs'],
                 stat: pulumi.Input[builtins.str],
                 period: Optional[pulumi.Input[builtins.int]] = None,
                 unit: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['ScalingPolicyMetricArgs'] metric: The metric to use.
        :param pulumi.Input[builtins.str] stat: The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *Amazon CloudWatch User Guide* .
               
               The most commonly used metric for scaling is `Average` .
        :param pulumi.Input[builtins.int] period: The period of the metric in seconds. The default value is 60. Accepted values are 10, 30, and 60. For high resolution metric, set the value to less than 60. For more information, see [Create a target tracking policy using high-resolution metrics for faster response](https://docs.aws.amazon.com/autoscaling/ec2/userguide/policy-creating-high-resolution-metrics.html) .
        :param pulumi.Input[builtins.str] unit: The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "stat", stat)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input['ScalingPolicyMetricArgs']:
        """
        The metric to use.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input['ScalingPolicyMetricArgs']):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def stat(self) -> pulumi.Input[builtins.str]:
        """
        The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *Amazon CloudWatch User Guide* .

        The most commonly used metric for scaling is `Average` .
        """
        return pulumi.get(self, "stat")

    @stat.setter
    def stat(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stat", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The period of the metric in seconds. The default value is 60. Accepted values are 10, 30, and 60. For high resolution metric, set the value to less than 60. For more information, see [Create a target tracking policy using high-resolution metrics for faster response](https://docs.aws.amazon.com/autoscaling/ec2/userguide/policy-creating-high-resolution-metrics.html) .
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unit", value)


if not MYPY:
    class WarmPoolInstanceReusePolicyArgsDict(TypedDict):
        reuse_on_scale_in: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
        """
elif False:
    WarmPoolInstanceReusePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WarmPoolInstanceReusePolicyArgs:
    def __init__(__self__, *,
                 reuse_on_scale_in: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] reuse_on_scale_in: Specifies whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
        """
        if reuse_on_scale_in is not None:
            pulumi.set(__self__, "reuse_on_scale_in", reuse_on_scale_in)

    @property
    @pulumi.getter(name="reuseOnScaleIn")
    def reuse_on_scale_in(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
        """
        return pulumi.get(self, "reuse_on_scale_in")

    @reuse_on_scale_in.setter
    def reuse_on_scale_in(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reuse_on_scale_in", value)


