# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AssessmentAwsAccount',
    'AssessmentAwsService',
    'AssessmentDelegation',
    'AssessmentReportsDestination',
    'AssessmentRole',
    'AssessmentScope',
]

@pulumi.output_type
class AssessmentAwsAccount(dict):
    """
    The AWS account associated with the assessment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailAddress":
            suggest = "email_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentAwsAccount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentAwsAccount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentAwsAccount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_address: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        The AWS account associated with the assessment.
        :param builtins.str email_address: The email address that's associated with the AWS account .
        :param builtins.str id: The identifier for the AWS account .
        :param builtins.str name: The name of the AWS account .
        """
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[builtins.str]:
        """
        The email address that's associated with the AWS account .
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The identifier for the AWS account .
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the AWS account .
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AssessmentAwsService(dict):
    """
    An AWS service such as Amazon S3, AWS CloudTrail, and so on.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentAwsService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentAwsService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentAwsService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_name: Optional[builtins.str] = None):
        """
        An AWS service such as Amazon S3, AWS CloudTrail, and so on.
        :param builtins.str service_name: The name of the AWS service .
        """
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[builtins.str]:
        """
        The name of the AWS service .
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class AssessmentDelegation(dict):
    """
    The assignment of a control set to a delegate for review.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assessmentId":
            suggest = "assessment_id"
        elif key == "assessmentName":
            suggest = "assessment_name"
        elif key == "controlSetId":
            suggest = "control_set_id"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "creationTime":
            suggest = "creation_time"
        elif key == "lastUpdated":
            suggest = "last_updated"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "roleType":
            suggest = "role_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentDelegation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentDelegation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentDelegation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assessment_id: Optional[builtins.str] = None,
                 assessment_name: Optional[builtins.str] = None,
                 comment: Optional[builtins.str] = None,
                 control_set_id: Optional[builtins.str] = None,
                 created_by: Optional[builtins.str] = None,
                 creation_time: Optional[builtins.float] = None,
                 id: Optional[builtins.str] = None,
                 last_updated: Optional[builtins.float] = None,
                 role_arn: Optional[builtins.str] = None,
                 role_type: Optional['AssessmentRoleType'] = None,
                 status: Optional['AssessmentDelegationStatus'] = None):
        """
        The assignment of a control set to a delegate for review.
        :param builtins.str assessment_id: The identifier for the assessment that's associated with the delegation.
        :param builtins.str assessment_name: The name of the assessment that's associated with the delegation.
        :param builtins.str comment: The comment that's related to the delegation.
        :param builtins.str control_set_id: The identifier for the control set that's associated with the delegation.
        :param builtins.str created_by: The user or role that created the delegation.
               
               *Minimum* : `1`
               
               *Maximum* : `100`
               
               *Pattern* : `^[a-zA-Z0-9-_()\\\\[\\\\]\\\\s]+$`
        :param builtins.float creation_time: Specifies when the delegation was created.
        :param builtins.str id: The unique identifier for the delegation.
        :param builtins.float last_updated: Specifies when the delegation was last updated.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the IAM role.
        :param 'AssessmentRoleType' role_type: The type of customer persona.
               
               > In `CreateAssessment` , `roleType` can only be `PROCESS_OWNER` .
               > 
               > In `UpdateSettings` , `roleType` can only be `PROCESS_OWNER` .
               > 
               > In `BatchCreateDelegationByAssessment` , `roleType` can only be `RESOURCE_OWNER` .
        :param 'AssessmentDelegationStatus' status: The status of the delegation.
        """
        if assessment_id is not None:
            pulumi.set(__self__, "assessment_id", assessment_id)
        if assessment_name is not None:
            pulumi.set(__self__, "assessment_name", assessment_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if control_set_id is not None:
            pulumi.set(__self__, "control_set_id", control_set_id)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="assessmentId")
    def assessment_id(self) -> Optional[builtins.str]:
        """
        The identifier for the assessment that's associated with the delegation.
        """
        return pulumi.get(self, "assessment_id")

    @property
    @pulumi.getter(name="assessmentName")
    def assessment_name(self) -> Optional[builtins.str]:
        """
        The name of the assessment that's associated with the delegation.
        """
        return pulumi.get(self, "assessment_name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        The comment that's related to the delegation.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="controlSetId")
    def control_set_id(self) -> Optional[builtins.str]:
        """
        The identifier for the control set that's associated with the delegation.
        """
        return pulumi.get(self, "control_set_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[builtins.str]:
        """
        The user or role that created the delegation.

        *Minimum* : `1`

        *Maximum* : `100`

        *Pattern* : `^[a-zA-Z0-9-_()\\\\[\\\\]\\\\s]+$`
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[builtins.float]:
        """
        Specifies when the delegation was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The unique identifier for the delegation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[builtins.float]:
        """
        Specifies when the delegation was last updated.
        """
        return pulumi.get(self, "last_updated")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional['AssessmentRoleType']:
        """
        The type of customer persona.

        > In `CreateAssessment` , `roleType` can only be `PROCESS_OWNER` .
        > 
        > In `UpdateSettings` , `roleType` can only be `PROCESS_OWNER` .
        > 
        > In `BatchCreateDelegationByAssessment` , `roleType` can only be `RESOURCE_OWNER` .
        """
        return pulumi.get(self, "role_type")

    @property
    @pulumi.getter
    def status(self) -> Optional['AssessmentDelegationStatus']:
        """
        The status of the delegation.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class AssessmentReportsDestination(dict):
    """
    The destination in which evidence reports are stored for the specified assessment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationType":
            suggest = "destination_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentReportsDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentReportsDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentReportsDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: Optional[builtins.str] = None,
                 destination_type: Optional['AssessmentReportDestinationType'] = None):
        """
        The destination in which evidence reports are stored for the specified assessment.
        :param builtins.str destination: The destination bucket where Audit Manager stores assessment reports.
        :param 'AssessmentReportDestinationType' destination_type: The destination type, such as Amazon S3.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)

    @property
    @pulumi.getter
    def destination(self) -> Optional[builtins.str]:
        """
        The destination bucket where Audit Manager stores assessment reports.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional['AssessmentReportDestinationType']:
        """
        The destination type, such as Amazon S3.
        """
        return pulumi.get(self, "destination_type")


@pulumi.output_type
class AssessmentRole(dict):
    """
    The wrapper that contains AWS Audit Manager role information, such as the role type and IAM ARN.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "roleType":
            suggest = "role_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: Optional[builtins.str] = None,
                 role_type: Optional['AssessmentRoleType'] = None):
        """
        The wrapper that contains AWS Audit Manager role information, such as the role type and IAM ARN.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the IAM role.
        :param 'AssessmentRoleType' role_type: The type of customer persona.
               
               > In `CreateAssessment` , `roleType` can only be `PROCESS_OWNER` .
               > 
               > In `UpdateSettings` , `roleType` can only be `PROCESS_OWNER` .
               > 
               > In `BatchCreateDelegationByAssessment` , `roleType` can only be `RESOURCE_OWNER` .
        """
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional['AssessmentRoleType']:
        """
        The type of customer persona.

        > In `CreateAssessment` , `roleType` can only be `PROCESS_OWNER` .
        > 
        > In `UpdateSettings` , `roleType` can only be `PROCESS_OWNER` .
        > 
        > In `BatchCreateDelegationByAssessment` , `roleType` can only be `RESOURCE_OWNER` .
        """
        return pulumi.get(self, "role_type")


@pulumi.output_type
class AssessmentScope(dict):
    """
    The wrapper that contains the AWS accounts and AWS services in scope for the assessment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsAccounts":
            suggest = "aws_accounts"
        elif key == "awsServices":
            suggest = "aws_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_accounts: Optional[Sequence['outputs.AssessmentAwsAccount']] = None,
                 aws_services: Optional[Sequence['outputs.AssessmentAwsService']] = None):
        """
        The wrapper that contains the AWS accounts and AWS services in scope for the assessment.
        :param Sequence['AssessmentAwsAccount'] aws_accounts: The AWS accounts included in scope.
        :param Sequence['AssessmentAwsService'] aws_services: The AWS services included in scope.
        """
        if aws_accounts is not None:
            pulumi.set(__self__, "aws_accounts", aws_accounts)
        if aws_services is not None:
            pulumi.set(__self__, "aws_services", aws_services)

    @property
    @pulumi.getter(name="awsAccounts")
    def aws_accounts(self) -> Optional[Sequence['outputs.AssessmentAwsAccount']]:
        """
        The AWS accounts included in scope.
        """
        return pulumi.get(self, "aws_accounts")

    @property
    @pulumi.getter(name="awsServices")
    def aws_services(self) -> Optional[Sequence['outputs.AssessmentAwsService']]:
        """
        The AWS services included in scope.
        """
        return pulumi.get(self, "aws_services")


