# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetAssessmentResult',
    'AwaitableGetAssessmentResult',
    'get_assessment',
    'get_assessment_output',
]

@pulumi.output_type
class GetAssessmentResult:
    def __init__(__self__, arn=None, assessment_id=None, assessment_reports_destination=None, creation_time=None, delegations=None, roles=None, scope=None, status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if assessment_id and not isinstance(assessment_id, str):
            raise TypeError("Expected argument 'assessment_id' to be a str")
        pulumi.set(__self__, "assessment_id", assessment_id)
        if assessment_reports_destination and not isinstance(assessment_reports_destination, dict):
            raise TypeError("Expected argument 'assessment_reports_destination' to be a dict")
        pulumi.set(__self__, "assessment_reports_destination", assessment_reports_destination)
        if creation_time and not isinstance(creation_time, float):
            raise TypeError("Expected argument 'creation_time' to be a float")
        pulumi.set(__self__, "creation_time", creation_time)
        if delegations and not isinstance(delegations, list):
            raise TypeError("Expected argument 'delegations' to be a list")
        pulumi.set(__self__, "delegations", delegations)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if scope and not isinstance(scope, dict):
            raise TypeError("Expected argument 'scope' to be a dict")
        pulumi.set(__self__, "scope", scope)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the assessment.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="assessmentId")
    def assessment_id(self) -> Optional[builtins.str]:
        """
        The unique identifier for the assessment.
        """
        return pulumi.get(self, "assessment_id")

    @property
    @pulumi.getter(name="assessmentReportsDestination")
    def assessment_reports_destination(self) -> Optional['outputs.AssessmentReportsDestination']:
        """
        The destination that evidence reports are stored in for the assessment.
        """
        return pulumi.get(self, "assessment_reports_destination")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[builtins.float]:
        """
        Specifies when the assessment was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def delegations(self) -> Optional[Sequence['outputs.AssessmentDelegation']]:
        """
        The list of delegations.
        """
        return pulumi.get(self, "delegations")

    @property
    @pulumi.getter
    def roles(self) -> Optional[Sequence['outputs.AssessmentRole']]:
        """
        The list of roles for the specified assessment.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def scope(self) -> Optional['outputs.AssessmentScope']:
        """
        The wrapper of AWS accounts and services that are in scope for the assessment.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def status(self) -> Optional['AssessmentStatus']:
        """
        The overall status of the assessment.

        When you create a new assessment, the initial `Status` value is always `ACTIVE` . When you create an assessment, even if you specify the value as `INACTIVE` , the value overrides to `ACTIVE` .

        After you create an assessment, you can change the value of the `Status` property at any time. For example, when you want to stop collecting evidence for your assessment, you can change the assessment status to `INACTIVE` .
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags associated with the assessment.
        """
        return pulumi.get(self, "tags")


class AwaitableGetAssessmentResult(GetAssessmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAssessmentResult(
            arn=self.arn,
            assessment_id=self.assessment_id,
            assessment_reports_destination=self.assessment_reports_destination,
            creation_time=self.creation_time,
            delegations=self.delegations,
            roles=self.roles,
            scope=self.scope,
            status=self.status,
            tags=self.tags)


def get_assessment(assessment_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAssessmentResult:
    """
    An entity that defines the scope of audit evidence collected by AWS Audit Manager.


    :param builtins.str assessment_id: The unique identifier for the assessment.
    """
    __args__ = dict()
    __args__['assessmentId'] = assessment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:auditmanager:getAssessment', __args__, opts=opts, typ=GetAssessmentResult).value

    return AwaitableGetAssessmentResult(
        arn=pulumi.get(__ret__, 'arn'),
        assessment_id=pulumi.get(__ret__, 'assessment_id'),
        assessment_reports_destination=pulumi.get(__ret__, 'assessment_reports_destination'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        delegations=pulumi.get(__ret__, 'delegations'),
        roles=pulumi.get(__ret__, 'roles'),
        scope=pulumi.get(__ret__, 'scope'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_assessment_output(assessment_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAssessmentResult]:
    """
    An entity that defines the scope of audit evidence collected by AWS Audit Manager.


    :param builtins.str assessment_id: The unique identifier for the assessment.
    """
    __args__ = dict()
    __args__['assessmentId'] = assessment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:auditmanager:getAssessment', __args__, opts=opts, typ=GetAssessmentResult)
    return __ret__.apply(lambda __response__: GetAssessmentResult(
        arn=pulumi.get(__response__, 'arn'),
        assessment_id=pulumi.get(__response__, 'assessment_id'),
        assessment_reports_destination=pulumi.get(__response__, 'assessment_reports_destination'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        delegations=pulumi.get(__response__, 'delegations'),
        roles=pulumi.get(__response__, 'roles'),
        scope=pulumi.get(__response__, 'scope'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
