# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['AssessmentArgs', 'Assessment']

@pulumi.input_type
class AssessmentArgs:
    def __init__(__self__, *,
                 assessment_reports_destination: Optional[pulumi.Input['AssessmentReportsDestinationArgs']] = None,
                 aws_account: Optional[pulumi.Input['AssessmentAwsAccountArgs']] = None,
                 delegations: Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentDelegationArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 framework_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentRoleArgs']]]] = None,
                 scope: Optional[pulumi.Input['AssessmentScopeArgs']] = None,
                 status: Optional[pulumi.Input['AssessmentStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Assessment resource.
        :param pulumi.Input['AssessmentReportsDestinationArgs'] assessment_reports_destination: The destination that evidence reports are stored in for the assessment.
        :param pulumi.Input['AssessmentAwsAccountArgs'] aws_account: The AWS account that's associated with the assessment.
        :param pulumi.Input[Sequence[pulumi.Input['AssessmentDelegationArgs']]] delegations: The list of delegations.
        :param pulumi.Input[builtins.str] description: The description of the assessment.
        :param pulumi.Input[builtins.str] framework_id: The unique identifier for the framework.
        :param pulumi.Input[builtins.str] name: The name of the assessment.
        :param pulumi.Input[Sequence[pulumi.Input['AssessmentRoleArgs']]] roles: The list of roles for the specified assessment.
        :param pulumi.Input['AssessmentScopeArgs'] scope: The wrapper of AWS accounts and services that are in scope for the assessment.
        :param pulumi.Input['AssessmentStatus'] status: The overall status of the assessment.
               
               When you create a new assessment, the initial `Status` value is always `ACTIVE` . When you create an assessment, even if you specify the value as `INACTIVE` , the value overrides to `ACTIVE` .
               
               After you create an assessment, you can change the value of the `Status` property at any time. For example, when you want to stop collecting evidence for your assessment, you can change the assessment status to `INACTIVE` .
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags associated with the assessment.
        """
        if assessment_reports_destination is not None:
            pulumi.set(__self__, "assessment_reports_destination", assessment_reports_destination)
        if aws_account is not None:
            pulumi.set(__self__, "aws_account", aws_account)
        if delegations is not None:
            pulumi.set(__self__, "delegations", delegations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if framework_id is not None:
            pulumi.set(__self__, "framework_id", framework_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="assessmentReportsDestination")
    def assessment_reports_destination(self) -> Optional[pulumi.Input['AssessmentReportsDestinationArgs']]:
        """
        The destination that evidence reports are stored in for the assessment.
        """
        return pulumi.get(self, "assessment_reports_destination")

    @assessment_reports_destination.setter
    def assessment_reports_destination(self, value: Optional[pulumi.Input['AssessmentReportsDestinationArgs']]):
        pulumi.set(self, "assessment_reports_destination", value)

    @property
    @pulumi.getter(name="awsAccount")
    def aws_account(self) -> Optional[pulumi.Input['AssessmentAwsAccountArgs']]:
        """
        The AWS account that's associated with the assessment.
        """
        return pulumi.get(self, "aws_account")

    @aws_account.setter
    def aws_account(self, value: Optional[pulumi.Input['AssessmentAwsAccountArgs']]):
        pulumi.set(self, "aws_account", value)

    @property
    @pulumi.getter
    def delegations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentDelegationArgs']]]]:
        """
        The list of delegations.
        """
        return pulumi.get(self, "delegations")

    @delegations.setter
    def delegations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentDelegationArgs']]]]):
        pulumi.set(self, "delegations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the assessment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="frameworkId")
    def framework_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier for the framework.
        """
        return pulumi.get(self, "framework_id")

    @framework_id.setter
    def framework_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "framework_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the assessment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentRoleArgs']]]]:
        """
        The list of roles for the specified assessment.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentRoleArgs']]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['AssessmentScopeArgs']]:
        """
        The wrapper of AWS accounts and services that are in scope for the assessment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['AssessmentScopeArgs']]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['AssessmentStatus']]:
        """
        The overall status of the assessment.

        When you create a new assessment, the initial `Status` value is always `ACTIVE` . When you create an assessment, even if you specify the value as `INACTIVE` , the value overrides to `ACTIVE` .

        After you create an assessment, you can change the value of the `Status` property at any time. For example, when you want to stop collecting evidence for your assessment, you can change the assessment status to `INACTIVE` .
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['AssessmentStatus']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags associated with the assessment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:auditmanager:Assessment")
class Assessment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assessment_reports_destination: Optional[pulumi.Input[Union['AssessmentReportsDestinationArgs', 'AssessmentReportsDestinationArgsDict']]] = None,
                 aws_account: Optional[pulumi.Input[Union['AssessmentAwsAccountArgs', 'AssessmentAwsAccountArgsDict']]] = None,
                 delegations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssessmentDelegationArgs', 'AssessmentDelegationArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 framework_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssessmentRoleArgs', 'AssessmentRoleArgsDict']]]]] = None,
                 scope: Optional[pulumi.Input[Union['AssessmentScopeArgs', 'AssessmentScopeArgsDict']]] = None,
                 status: Optional[pulumi.Input['AssessmentStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        An entity that defines the scope of audit evidence collected by AWS Audit Manager.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AssessmentReportsDestinationArgs', 'AssessmentReportsDestinationArgsDict']] assessment_reports_destination: The destination that evidence reports are stored in for the assessment.
        :param pulumi.Input[Union['AssessmentAwsAccountArgs', 'AssessmentAwsAccountArgsDict']] aws_account: The AWS account that's associated with the assessment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AssessmentDelegationArgs', 'AssessmentDelegationArgsDict']]]] delegations: The list of delegations.
        :param pulumi.Input[builtins.str] description: The description of the assessment.
        :param pulumi.Input[builtins.str] framework_id: The unique identifier for the framework.
        :param pulumi.Input[builtins.str] name: The name of the assessment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AssessmentRoleArgs', 'AssessmentRoleArgsDict']]]] roles: The list of roles for the specified assessment.
        :param pulumi.Input[Union['AssessmentScopeArgs', 'AssessmentScopeArgsDict']] scope: The wrapper of AWS accounts and services that are in scope for the assessment.
        :param pulumi.Input['AssessmentStatus'] status: The overall status of the assessment.
               
               When you create a new assessment, the initial `Status` value is always `ACTIVE` . When you create an assessment, even if you specify the value as `INACTIVE` , the value overrides to `ACTIVE` .
               
               After you create an assessment, you can change the value of the `Status` property at any time. For example, when you want to stop collecting evidence for your assessment, you can change the assessment status to `INACTIVE` .
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags associated with the assessment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AssessmentArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An entity that defines the scope of audit evidence collected by AWS Audit Manager.

        :param str resource_name: The name of the resource.
        :param AssessmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssessmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assessment_reports_destination: Optional[pulumi.Input[Union['AssessmentReportsDestinationArgs', 'AssessmentReportsDestinationArgsDict']]] = None,
                 aws_account: Optional[pulumi.Input[Union['AssessmentAwsAccountArgs', 'AssessmentAwsAccountArgsDict']]] = None,
                 delegations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssessmentDelegationArgs', 'AssessmentDelegationArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 framework_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssessmentRoleArgs', 'AssessmentRoleArgsDict']]]]] = None,
                 scope: Optional[pulumi.Input[Union['AssessmentScopeArgs', 'AssessmentScopeArgsDict']]] = None,
                 status: Optional[pulumi.Input['AssessmentStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssessmentArgs.__new__(AssessmentArgs)

            __props__.__dict__["assessment_reports_destination"] = assessment_reports_destination
            __props__.__dict__["aws_account"] = aws_account
            __props__.__dict__["delegations"] = delegations
            __props__.__dict__["description"] = description
            __props__.__dict__["framework_id"] = framework_id
            __props__.__dict__["name"] = name
            __props__.__dict__["roles"] = roles
            __props__.__dict__["scope"] = scope
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["assessment_id"] = None
            __props__.__dict__["creation_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["awsAccount", "frameworkId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Assessment, __self__).__init__(
            'aws-native:auditmanager:Assessment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Assessment':
        """
        Get an existing Assessment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AssessmentArgs.__new__(AssessmentArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["assessment_id"] = None
        __props__.__dict__["assessment_reports_destination"] = None
        __props__.__dict__["aws_account"] = None
        __props__.__dict__["creation_time"] = None
        __props__.__dict__["delegations"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["framework_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["roles"] = None
        __props__.__dict__["scope"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        return Assessment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the assessment.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="assessmentId")
    def assessment_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for the assessment.
        """
        return pulumi.get(self, "assessment_id")

    @property
    @pulumi.getter(name="assessmentReportsDestination")
    def assessment_reports_destination(self) -> pulumi.Output[Optional['outputs.AssessmentReportsDestination']]:
        """
        The destination that evidence reports are stored in for the assessment.
        """
        return pulumi.get(self, "assessment_reports_destination")

    @property
    @pulumi.getter(name="awsAccount")
    def aws_account(self) -> pulumi.Output[Optional['outputs.AssessmentAwsAccount']]:
        """
        The AWS account that's associated with the assessment.
        """
        return pulumi.get(self, "aws_account")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.float]:
        """
        Specifies when the assessment was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def delegations(self) -> pulumi.Output[Optional[Sequence['outputs.AssessmentDelegation']]]:
        """
        The list of delegations.
        """
        return pulumi.get(self, "delegations")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the assessment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="frameworkId")
    def framework_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The unique identifier for the framework.
        """
        return pulumi.get(self, "framework_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the assessment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Optional[Sequence['outputs.AssessmentRole']]]:
        """
        The list of roles for the specified assessment.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional['outputs.AssessmentScope']]:
        """
        The wrapper of AWS accounts and services that are in scope for the assessment.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional['AssessmentStatus']]:
        """
        The overall status of the assessment.

        When you create a new assessment, the initial `Status` value is always `ACTIVE` . When you create an assessment, even if you specify the value as `INACTIVE` , the value overrides to `ACTIVE` .

        After you create an assessment, you can change the value of the `Status` property at any time. For example, when you want to stop collecting evidence for your assessment, you can change the assessment status to `INACTIVE` .
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags associated with the assessment.
        """
        return pulumi.get(self, "tags")

