# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPreparedStatementResult',
    'AwaitableGetPreparedStatementResult',
    'get_prepared_statement',
    'get_prepared_statement_output',
]

@pulumi.output_type
class GetPreparedStatementResult:
    def __init__(__self__, description=None, query_statement=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if query_statement and not isinstance(query_statement, str):
            raise TypeError("Expected argument 'query_statement' to be a str")
        pulumi.set(__self__, "query_statement", query_statement)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the prepared statement.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="queryStatement")
    def query_statement(self) -> Optional[builtins.str]:
        """
        The query string for the prepared statement.
        """
        return pulumi.get(self, "query_statement")


class AwaitableGetPreparedStatementResult(GetPreparedStatementResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPreparedStatementResult(
            description=self.description,
            query_statement=self.query_statement)


def get_prepared_statement(statement_name: Optional[builtins.str] = None,
                           work_group: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPreparedStatementResult:
    """
    Resource schema for AWS::Athena::PreparedStatement


    :param builtins.str statement_name: The name of the prepared statement.
    :param builtins.str work_group: The name of the workgroup to which the prepared statement belongs.
    """
    __args__ = dict()
    __args__['statementName'] = statement_name
    __args__['workGroup'] = work_group
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:athena:getPreparedStatement', __args__, opts=opts, typ=GetPreparedStatementResult).value

    return AwaitableGetPreparedStatementResult(
        description=pulumi.get(__ret__, 'description'),
        query_statement=pulumi.get(__ret__, 'query_statement'))
def get_prepared_statement_output(statement_name: Optional[pulumi.Input[builtins.str]] = None,
                                  work_group: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPreparedStatementResult]:
    """
    Resource schema for AWS::Athena::PreparedStatement


    :param builtins.str statement_name: The name of the prepared statement.
    :param builtins.str work_group: The name of the workgroup to which the prepared statement belongs.
    """
    __args__ = dict()
    __args__['statementName'] = statement_name
    __args__['workGroup'] = work_group
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:athena:getPreparedStatement', __args__, opts=opts, typ=GetPreparedStatementResult)
    return __ret__.apply(lambda __response__: GetPreparedStatementResult(
        description=pulumi.get(__response__, 'description'),
        query_statement=pulumi.get(__response__, 'query_statement')))
