# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApiAuthMode',
    'ApiAuthProvider',
    'ApiCognitoConfig',
    'ApiDnsMap',
    'ApiEventConfig',
    'ApiEventLogConfig',
    'ApiLambdaAuthorizerConfig',
    'ApiOpenIdConnectConfig',
    'ChannelNamespaceAuthMode',
    'ChannelNamespaceHandlerConfig',
    'ChannelNamespaceHandlerConfigs',
    'ChannelNamespaceIntegration',
    'ChannelNamespaceLambdaConfig',
    'DataSourceAuthorizationConfig',
    'DataSourceAwsIamConfig',
    'DataSourceDeltaSyncConfig',
    'DataSourceDynamoDbConfig',
    'DataSourceElasticsearchConfig',
    'DataSourceEventBridgeConfig',
    'DataSourceHttpConfig',
    'DataSourceLambdaConfig',
    'DataSourceOpenSearchServiceConfig',
    'DataSourceRdsHttpEndpointConfig',
    'DataSourceRelationalDatabaseConfig',
    'FunctionConfigurationAppSyncRuntime',
    'FunctionConfigurationLambdaConflictHandlerConfig',
    'FunctionConfigurationSyncConfig',
    'GraphQlApiAdditionalAuthenticationProvider',
    'GraphQlApiCognitoUserPoolConfig',
    'GraphQlApiEnhancedMetricsConfig',
    'GraphQlApiLambdaAuthorizerConfig',
    'GraphQlApiLogConfig',
    'GraphQlApiOpenIdConnectConfig',
    'GraphQlApiUserPoolConfig',
    'ResolverAppSyncRuntime',
    'ResolverCachingConfig',
    'ResolverLambdaConflictHandlerConfig',
    'ResolverPipelineConfig',
    'ResolverSyncConfig',
    'SourceApiAssociationConfig',
]

@pulumi.output_type
class ApiAuthMode(dict):
    """
    An auth mode.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiAuthMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiAuthMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiAuthMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: Optional['ApiAuthenticationType'] = None):
        """
        An auth mode.
        """
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional['ApiAuthenticationType']:
        return pulumi.get(self, "auth_type")


@pulumi.output_type
class ApiAuthProvider(dict):
    """
    An auth provider for the AppSync API.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "cognitoConfig":
            suggest = "cognito_config"
        elif key == "lambdaAuthorizerConfig":
            suggest = "lambda_authorizer_config"
        elif key == "openIdConnectConfig":
            suggest = "open_id_connect_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiAuthProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiAuthProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiAuthProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: 'ApiAuthenticationType',
                 cognito_config: Optional['outputs.ApiCognitoConfig'] = None,
                 lambda_authorizer_config: Optional['outputs.ApiLambdaAuthorizerConfig'] = None,
                 open_id_connect_config: Optional['outputs.ApiOpenIdConnectConfig'] = None):
        """
        An auth provider for the AppSync API.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        if cognito_config is not None:
            pulumi.set(__self__, "cognito_config", cognito_config)
        if lambda_authorizer_config is not None:
            pulumi.set(__self__, "lambda_authorizer_config", lambda_authorizer_config)
        if open_id_connect_config is not None:
            pulumi.set(__self__, "open_id_connect_config", open_id_connect_config)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> 'ApiAuthenticationType':
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="cognitoConfig")
    def cognito_config(self) -> Optional['outputs.ApiCognitoConfig']:
        return pulumi.get(self, "cognito_config")

    @property
    @pulumi.getter(name="lambdaAuthorizerConfig")
    def lambda_authorizer_config(self) -> Optional['outputs.ApiLambdaAuthorizerConfig']:
        return pulumi.get(self, "lambda_authorizer_config")

    @property
    @pulumi.getter(name="openIdConnectConfig")
    def open_id_connect_config(self) -> Optional['outputs.ApiOpenIdConnectConfig']:
        return pulumi.get(self, "open_id_connect_config")


@pulumi.output_type
class ApiCognitoConfig(dict):
    """
    Optional authorization configuration for using Amazon Cognito user pools with your API endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsRegion":
            suggest = "aws_region"
        elif key == "userPoolId":
            suggest = "user_pool_id"
        elif key == "appIdClientRegex":
            suggest = "app_id_client_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiCognitoConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiCognitoConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiCognitoConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_region: builtins.str,
                 user_pool_id: builtins.str,
                 app_id_client_regex: Optional[builtins.str] = None):
        """
        Optional authorization configuration for using Amazon Cognito user pools with your API endpoint.
        """
        pulumi.set(__self__, "aws_region", aws_region)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> builtins.str:
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> builtins.str:
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[builtins.str]:
        return pulumi.get(self, "app_id_client_regex")


@pulumi.output_type
class ApiDnsMap(dict):
    """
    A map of DNS names for the AppSync API.
    """
    def __init__(__self__, *,
                 http: Optional[builtins.str] = None,
                 realtime: Optional[builtins.str] = None):
        """
        A map of DNS names for the AppSync API.
        :param builtins.str http: The domain name of the Api's HTTP endpoint.
        :param builtins.str realtime: The domain name of the Api's real-time endpoint.
        """
        if http is not None:
            pulumi.set(__self__, "http", http)
        if realtime is not None:
            pulumi.set(__self__, "realtime", realtime)

    @property
    @pulumi.getter
    def http(self) -> Optional[builtins.str]:
        """
        The domain name of the Api's HTTP endpoint.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def realtime(self) -> Optional[builtins.str]:
        """
        The domain name of the Api's real-time endpoint.
        """
        return pulumi.get(self, "realtime")


@pulumi.output_type
class ApiEventConfig(dict):
    """
    The configuration for an Event Api
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authProviders":
            suggest = "auth_providers"
        elif key == "connectionAuthModes":
            suggest = "connection_auth_modes"
        elif key == "defaultPublishAuthModes":
            suggest = "default_publish_auth_modes"
        elif key == "defaultSubscribeAuthModes":
            suggest = "default_subscribe_auth_modes"
        elif key == "logConfig":
            suggest = "log_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiEventConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiEventConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiEventConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_providers: Sequence['outputs.ApiAuthProvider'],
                 connection_auth_modes: Sequence['outputs.ApiAuthMode'],
                 default_publish_auth_modes: Sequence['outputs.ApiAuthMode'],
                 default_subscribe_auth_modes: Sequence['outputs.ApiAuthMode'],
                 log_config: Optional['outputs.ApiEventLogConfig'] = None):
        """
        The configuration for an Event Api
        :param Sequence['ApiAuthProvider'] auth_providers: A list of authorization providers.
        :param Sequence['ApiAuthMode'] connection_auth_modes: A list of valid authorization modes for the Event API connections.
        :param Sequence['ApiAuthMode'] default_publish_auth_modes: A list of valid authorization modes for the Event API publishing.
        :param Sequence['ApiAuthMode'] default_subscribe_auth_modes: A list of valid authorization modes for the Event API subscriptions.
        :param 'ApiEventLogConfig' log_config: The CloudWatch Logs configuration for the Event API.
        """
        pulumi.set(__self__, "auth_providers", auth_providers)
        pulumi.set(__self__, "connection_auth_modes", connection_auth_modes)
        pulumi.set(__self__, "default_publish_auth_modes", default_publish_auth_modes)
        pulumi.set(__self__, "default_subscribe_auth_modes", default_subscribe_auth_modes)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)

    @property
    @pulumi.getter(name="authProviders")
    def auth_providers(self) -> Sequence['outputs.ApiAuthProvider']:
        """
        A list of authorization providers.
        """
        return pulumi.get(self, "auth_providers")

    @property
    @pulumi.getter(name="connectionAuthModes")
    def connection_auth_modes(self) -> Sequence['outputs.ApiAuthMode']:
        """
        A list of valid authorization modes for the Event API connections.
        """
        return pulumi.get(self, "connection_auth_modes")

    @property
    @pulumi.getter(name="defaultPublishAuthModes")
    def default_publish_auth_modes(self) -> Sequence['outputs.ApiAuthMode']:
        """
        A list of valid authorization modes for the Event API publishing.
        """
        return pulumi.get(self, "default_publish_auth_modes")

    @property
    @pulumi.getter(name="defaultSubscribeAuthModes")
    def default_subscribe_auth_modes(self) -> Sequence['outputs.ApiAuthMode']:
        """
        A list of valid authorization modes for the Event API subscriptions.
        """
        return pulumi.get(self, "default_subscribe_auth_modes")

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional['outputs.ApiEventLogConfig']:
        """
        The CloudWatch Logs configuration for the Event API.
        """
        return pulumi.get(self, "log_config")


@pulumi.output_type
class ApiEventLogConfig(dict):
    """
    The log config for the AppSync API.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchLogsRoleArn":
            suggest = "cloud_watch_logs_role_arn"
        elif key == "logLevel":
            suggest = "log_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiEventLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiEventLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiEventLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_logs_role_arn: builtins.str,
                 log_level: 'ApiEventLogLevel'):
        """
        The log config for the AppSync API.
        :param builtins.str cloud_watch_logs_role_arn: The IAM service role that AWS AppSync assumes to publish CloudWatch Logs in your account.
        :param 'ApiEventLogLevel' log_level: The type of information to log for the Event API.
        """
        pulumi.set(__self__, "cloud_watch_logs_role_arn", cloud_watch_logs_role_arn)
        pulumi.set(__self__, "log_level", log_level)

    @property
    @pulumi.getter(name="cloudWatchLogsRoleArn")
    def cloud_watch_logs_role_arn(self) -> builtins.str:
        """
        The IAM service role that AWS AppSync assumes to publish CloudWatch Logs in your account.
        """
        return pulumi.get(self, "cloud_watch_logs_role_arn")

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> 'ApiEventLogLevel':
        """
        The type of information to log for the Event API.
        """
        return pulumi.get(self, "log_level")


@pulumi.output_type
class ApiLambdaAuthorizerConfig(dict):
    """
    A LambdaAuthorizerConfig holds configuration on how to authorize AWS AppSync API access when using the AWS_LAMBDA authorizer mode. Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerUri":
            suggest = "authorizer_uri"
        elif key == "authorizerResultTtlInSeconds":
            suggest = "authorizer_result_ttl_in_seconds"
        elif key == "identityValidationExpression":
            suggest = "identity_validation_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiLambdaAuthorizerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiLambdaAuthorizerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiLambdaAuthorizerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_uri: builtins.str,
                 authorizer_result_ttl_in_seconds: Optional[builtins.int] = None,
                 identity_validation_expression: Optional[builtins.str] = None):
        """
        A LambdaAuthorizerConfig holds configuration on how to authorize AWS AppSync API access when using the AWS_LAMBDA authorizer mode. Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
        """
        pulumi.set(__self__, "authorizer_uri", authorizer_uri)
        if authorizer_result_ttl_in_seconds is not None:
            pulumi.set(__self__, "authorizer_result_ttl_in_seconds", authorizer_result_ttl_in_seconds)
        if identity_validation_expression is not None:
            pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)

    @property
    @pulumi.getter(name="authorizerUri")
    def authorizer_uri(self) -> builtins.str:
        return pulumi.get(self, "authorizer_uri")

    @property
    @pulumi.getter(name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> Optional[builtins.int]:
        return pulumi.get(self, "authorizer_result_ttl_in_seconds")

    @property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[builtins.str]:
        return pulumi.get(self, "identity_validation_expression")


@pulumi.output_type
class ApiOpenIdConnectConfig(dict):
    """
    The OpenID Connect configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authTtl":
            suggest = "auth_ttl"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "iatTtl":
            suggest = "iat_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOpenIdConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOpenIdConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOpenIdConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer: builtins.str,
                 auth_ttl: Optional[builtins.float] = None,
                 client_id: Optional[builtins.str] = None,
                 iat_ttl: Optional[builtins.float] = None):
        """
        The OpenID Connect configuration.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @property
    @pulumi.getter
    def issuer(self) -> builtins.str:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[builtins.float]:
        return pulumi.get(self, "auth_ttl")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[builtins.float]:
        return pulumi.get(self, "iat_ttl")


@pulumi.output_type
class ChannelNamespaceAuthMode(dict):
    """
    An auth mode.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelNamespaceAuthMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelNamespaceAuthMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelNamespaceAuthMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: Optional['ChannelNamespaceAuthenticationType'] = None):
        """
        An auth mode.
        """
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional['ChannelNamespaceAuthenticationType']:
        return pulumi.get(self, "auth_type")


@pulumi.output_type
class ChannelNamespaceHandlerConfig(dict):
    def __init__(__self__, *,
                 behavior: 'ChannelNamespaceHandlerBehavior',
                 integration: 'outputs.ChannelNamespaceIntegration'):
        """
        :param 'ChannelNamespaceHandlerBehavior' behavior: The behavior for the handler.
        :param 'ChannelNamespaceIntegration' integration: The integration data source configuration for the handler.
        """
        pulumi.set(__self__, "behavior", behavior)
        pulumi.set(__self__, "integration", integration)

    @property
    @pulumi.getter
    def behavior(self) -> 'ChannelNamespaceHandlerBehavior':
        """
        The behavior for the handler.
        """
        return pulumi.get(self, "behavior")

    @property
    @pulumi.getter
    def integration(self) -> 'outputs.ChannelNamespaceIntegration':
        """
        The integration data source configuration for the handler.
        """
        return pulumi.get(self, "integration")


@pulumi.output_type
class ChannelNamespaceHandlerConfigs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onPublish":
            suggest = "on_publish"
        elif key == "onSubscribe":
            suggest = "on_subscribe"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelNamespaceHandlerConfigs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelNamespaceHandlerConfigs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelNamespaceHandlerConfigs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_publish: Optional['outputs.ChannelNamespaceHandlerConfig'] = None,
                 on_subscribe: Optional['outputs.ChannelNamespaceHandlerConfig'] = None):
        """
        :param 'ChannelNamespaceHandlerConfig' on_publish: The configuration for the `OnPublish` handler.
        :param 'ChannelNamespaceHandlerConfig' on_subscribe: The configuration for the `OnSubscribe` handler.
        """
        if on_publish is not None:
            pulumi.set(__self__, "on_publish", on_publish)
        if on_subscribe is not None:
            pulumi.set(__self__, "on_subscribe", on_subscribe)

    @property
    @pulumi.getter(name="onPublish")
    def on_publish(self) -> Optional['outputs.ChannelNamespaceHandlerConfig']:
        """
        The configuration for the `OnPublish` handler.
        """
        return pulumi.get(self, "on_publish")

    @property
    @pulumi.getter(name="onSubscribe")
    def on_subscribe(self) -> Optional['outputs.ChannelNamespaceHandlerConfig']:
        """
        The configuration for the `OnSubscribe` handler.
        """
        return pulumi.get(self, "on_subscribe")


@pulumi.output_type
class ChannelNamespaceIntegration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSourceName":
            suggest = "data_source_name"
        elif key == "lambdaConfig":
            suggest = "lambda_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelNamespaceIntegration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelNamespaceIntegration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelNamespaceIntegration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source_name: builtins.str,
                 lambda_config: Optional['outputs.ChannelNamespaceLambdaConfig'] = None):
        """
        :param builtins.str data_source_name: Data source to invoke for this integration.
        :param 'ChannelNamespaceLambdaConfig' lambda_config: The configuration for a Lambda data source.
        """
        pulumi.set(__self__, "data_source_name", data_source_name)
        if lambda_config is not None:
            pulumi.set(__self__, "lambda_config", lambda_config)

    @property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> builtins.str:
        """
        Data source to invoke for this integration.
        """
        return pulumi.get(self, "data_source_name")

    @property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> Optional['outputs.ChannelNamespaceLambdaConfig']:
        """
        The configuration for a Lambda data source.
        """
        return pulumi.get(self, "lambda_config")


@pulumi.output_type
class ChannelNamespaceLambdaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invokeType":
            suggest = "invoke_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelNamespaceLambdaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelNamespaceLambdaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelNamespaceLambdaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 invoke_type: 'ChannelNamespaceInvokeType'):
        """
        :param 'ChannelNamespaceInvokeType' invoke_type: The invocation type for a Lambda data source.
        """
        pulumi.set(__self__, "invoke_type", invoke_type)

    @property
    @pulumi.getter(name="invokeType")
    def invoke_type(self) -> 'ChannelNamespaceInvokeType':
        """
        The invocation type for a Lambda data source.
        """
        return pulumi.get(self, "invoke_type")


@pulumi.output_type
class DataSourceAuthorizationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationType":
            suggest = "authorization_type"
        elif key == "awsIamConfig":
            suggest = "aws_iam_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceAuthorizationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceAuthorizationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceAuthorizationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_type: builtins.str,
                 aws_iam_config: Optional['outputs.DataSourceAwsIamConfig'] = None):
        """
        :param builtins.str authorization_type: The authorization type that the HTTP endpoint requires.
        :param 'DataSourceAwsIamConfig' aws_iam_config: The AWS Identity and Access Management settings.
        """
        pulumi.set(__self__, "authorization_type", authorization_type)
        if aws_iam_config is not None:
            pulumi.set(__self__, "aws_iam_config", aws_iam_config)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> builtins.str:
        """
        The authorization type that the HTTP endpoint requires.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter(name="awsIamConfig")
    def aws_iam_config(self) -> Optional['outputs.DataSourceAwsIamConfig']:
        """
        The AWS Identity and Access Management settings.
        """
        return pulumi.get(self, "aws_iam_config")


@pulumi.output_type
class DataSourceAwsIamConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signingRegion":
            suggest = "signing_region"
        elif key == "signingServiceName":
            suggest = "signing_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceAwsIamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceAwsIamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceAwsIamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 signing_region: Optional[builtins.str] = None,
                 signing_service_name: Optional[builtins.str] = None):
        """
        :param builtins.str signing_region: The signing Region for AWS Identity and Access Management authorization.
        :param builtins.str signing_service_name: The signing service name for AWS Identity and Access Management authorization.
        """
        if signing_region is not None:
            pulumi.set(__self__, "signing_region", signing_region)
        if signing_service_name is not None:
            pulumi.set(__self__, "signing_service_name", signing_service_name)

    @property
    @pulumi.getter(name="signingRegion")
    def signing_region(self) -> Optional[builtins.str]:
        """
        The signing Region for AWS Identity and Access Management authorization.
        """
        return pulumi.get(self, "signing_region")

    @property
    @pulumi.getter(name="signingServiceName")
    def signing_service_name(self) -> Optional[builtins.str]:
        """
        The signing service name for AWS Identity and Access Management authorization.
        """
        return pulumi.get(self, "signing_service_name")


@pulumi.output_type
class DataSourceDeltaSyncConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseTableTtl":
            suggest = "base_table_ttl"
        elif key == "deltaSyncTableName":
            suggest = "delta_sync_table_name"
        elif key == "deltaSyncTableTtl":
            suggest = "delta_sync_table_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDeltaSyncConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDeltaSyncConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDeltaSyncConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_table_ttl: builtins.str,
                 delta_sync_table_name: builtins.str,
                 delta_sync_table_ttl: builtins.str):
        """
        :param builtins.str base_table_ttl: The number of minutes that an Item is stored in the data source.
        :param builtins.str delta_sync_table_name: The Delta Sync table name.
        :param builtins.str delta_sync_table_ttl: The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
        """
        pulumi.set(__self__, "base_table_ttl", base_table_ttl)
        pulumi.set(__self__, "delta_sync_table_name", delta_sync_table_name)
        pulumi.set(__self__, "delta_sync_table_ttl", delta_sync_table_ttl)

    @property
    @pulumi.getter(name="baseTableTtl")
    def base_table_ttl(self) -> builtins.str:
        """
        The number of minutes that an Item is stored in the data source.
        """
        return pulumi.get(self, "base_table_ttl")

    @property
    @pulumi.getter(name="deltaSyncTableName")
    def delta_sync_table_name(self) -> builtins.str:
        """
        The Delta Sync table name.
        """
        return pulumi.get(self, "delta_sync_table_name")

    @property
    @pulumi.getter(name="deltaSyncTableTtl")
    def delta_sync_table_ttl(self) -> builtins.str:
        """
        The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
        """
        return pulumi.get(self, "delta_sync_table_ttl")


@pulumi.output_type
class DataSourceDynamoDbConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsRegion":
            suggest = "aws_region"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "deltaSyncConfig":
            suggest = "delta_sync_config"
        elif key == "useCallerCredentials":
            suggest = "use_caller_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDynamoDbConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDynamoDbConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDynamoDbConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_region: builtins.str,
                 table_name: builtins.str,
                 delta_sync_config: Optional['outputs.DataSourceDeltaSyncConfig'] = None,
                 use_caller_credentials: Optional[builtins.bool] = None,
                 versioned: Optional[builtins.bool] = None):
        """
        :param builtins.str aws_region: The AWS Region.
        :param builtins.str table_name: The table name.
        :param 'DataSourceDeltaSyncConfig' delta_sync_config: The DeltaSyncConfig for a versioned datasource.
        :param builtins.bool use_caller_credentials: Set to TRUE to use AWS Identity and Access Management with this data source.
        :param builtins.bool versioned: Set to TRUE to use Conflict Detection and Resolution with this data source.
        """
        pulumi.set(__self__, "aws_region", aws_region)
        pulumi.set(__self__, "table_name", table_name)
        if delta_sync_config is not None:
            pulumi.set(__self__, "delta_sync_config", delta_sync_config)
        if use_caller_credentials is not None:
            pulumi.set(__self__, "use_caller_credentials", use_caller_credentials)
        if versioned is not None:
            pulumi.set(__self__, "versioned", versioned)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> builtins.str:
        """
        The AWS Region.
        """
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        The table name.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="deltaSyncConfig")
    def delta_sync_config(self) -> Optional['outputs.DataSourceDeltaSyncConfig']:
        """
        The DeltaSyncConfig for a versioned datasource.
        """
        return pulumi.get(self, "delta_sync_config")

    @property
    @pulumi.getter(name="useCallerCredentials")
    def use_caller_credentials(self) -> Optional[builtins.bool]:
        """
        Set to TRUE to use AWS Identity and Access Management with this data source.
        """
        return pulumi.get(self, "use_caller_credentials")

    @property
    @pulumi.getter
    def versioned(self) -> Optional[builtins.bool]:
        """
        Set to TRUE to use Conflict Detection and Resolution with this data source.
        """
        return pulumi.get(self, "versioned")


@pulumi.output_type
class DataSourceElasticsearchConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsRegion":
            suggest = "aws_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceElasticsearchConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceElasticsearchConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceElasticsearchConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_region: builtins.str,
                 endpoint: builtins.str):
        """
        :param builtins.str aws_region: The AWS Region.
        :param builtins.str endpoint: The endpoint.
        """
        pulumi.set(__self__, "aws_region", aws_region)
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> builtins.str:
        """
        The AWS Region.
        """
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        The endpoint.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class DataSourceEventBridgeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventBusArn":
            suggest = "event_bus_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceEventBridgeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceEventBridgeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceEventBridgeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_bus_arn: builtins.str):
        """
        :param builtins.str event_bus_arn: ARN for the EventBridge bus.
        """
        pulumi.set(__self__, "event_bus_arn", event_bus_arn)

    @property
    @pulumi.getter(name="eventBusArn")
    def event_bus_arn(self) -> builtins.str:
        """
        ARN for the EventBridge bus.
        """
        return pulumi.get(self, "event_bus_arn")


@pulumi.output_type
class DataSourceHttpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationConfig":
            suggest = "authorization_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceHttpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceHttpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceHttpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: builtins.str,
                 authorization_config: Optional['outputs.DataSourceAuthorizationConfig'] = None):
        """
        :param builtins.str endpoint: The endpoint.
        :param 'DataSourceAuthorizationConfig' authorization_config: The authorization configuration.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if authorization_config is not None:
            pulumi.set(__self__, "authorization_config", authorization_config)

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        The endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> Optional['outputs.DataSourceAuthorizationConfig']:
        """
        The authorization configuration.
        """
        return pulumi.get(self, "authorization_config")


@pulumi.output_type
class DataSourceLambdaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaFunctionArn":
            suggest = "lambda_function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceLambdaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceLambdaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceLambdaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_function_arn: builtins.str):
        """
        :param builtins.str lambda_function_arn: The ARN for the Lambda function.
        """
        pulumi.set(__self__, "lambda_function_arn", lambda_function_arn)

    @property
    @pulumi.getter(name="lambdaFunctionArn")
    def lambda_function_arn(self) -> builtins.str:
        """
        The ARN for the Lambda function.
        """
        return pulumi.get(self, "lambda_function_arn")


@pulumi.output_type
class DataSourceOpenSearchServiceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsRegion":
            suggest = "aws_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceOpenSearchServiceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceOpenSearchServiceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceOpenSearchServiceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_region: builtins.str,
                 endpoint: builtins.str):
        """
        :param builtins.str aws_region: The AWS Region.
        :param builtins.str endpoint: The endpoint.
        """
        pulumi.set(__self__, "aws_region", aws_region)
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> builtins.str:
        """
        The AWS Region.
        """
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        The endpoint.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class DataSourceRdsHttpEndpointConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsRegion":
            suggest = "aws_region"
        elif key == "awsSecretStoreArn":
            suggest = "aws_secret_store_arn"
        elif key == "dbClusterIdentifier":
            suggest = "db_cluster_identifier"
        elif key == "databaseName":
            suggest = "database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRdsHttpEndpointConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRdsHttpEndpointConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRdsHttpEndpointConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_region: builtins.str,
                 aws_secret_store_arn: builtins.str,
                 db_cluster_identifier: builtins.str,
                 database_name: Optional[builtins.str] = None,
                 schema: Optional[builtins.str] = None):
        """
        :param builtins.str aws_region: AWS Region for RDS HTTP endpoint.
        :param builtins.str aws_secret_store_arn: The ARN for database credentials stored in AWS Secrets Manager.
        :param builtins.str db_cluster_identifier: Amazon RDS cluster Amazon Resource Name (ARN).
        :param builtins.str database_name: Logical database name.
        :param builtins.str schema: Logical schema name.
        """
        pulumi.set(__self__, "aws_region", aws_region)
        pulumi.set(__self__, "aws_secret_store_arn", aws_secret_store_arn)
        pulumi.set(__self__, "db_cluster_identifier", db_cluster_identifier)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> builtins.str:
        """
        AWS Region for RDS HTTP endpoint.
        """
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter(name="awsSecretStoreArn")
    def aws_secret_store_arn(self) -> builtins.str:
        """
        The ARN for database credentials stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "aws_secret_store_arn")

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> builtins.str:
        """
        Amazon RDS cluster Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "db_cluster_identifier")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[builtins.str]:
        """
        Logical database name.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def schema(self) -> Optional[builtins.str]:
        """
        Logical schema name.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class DataSourceRelationalDatabaseConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relationalDatabaseSourceType":
            suggest = "relational_database_source_type"
        elif key == "rdsHttpEndpointConfig":
            suggest = "rds_http_endpoint_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRelationalDatabaseConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRelationalDatabaseConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRelationalDatabaseConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 relational_database_source_type: builtins.str,
                 rds_http_endpoint_config: Optional['outputs.DataSourceRdsHttpEndpointConfig'] = None):
        """
        :param builtins.str relational_database_source_type: The type of relational data source.
        :param 'DataSourceRdsHttpEndpointConfig' rds_http_endpoint_config: Information about the Amazon RDS resource.
        """
        pulumi.set(__self__, "relational_database_source_type", relational_database_source_type)
        if rds_http_endpoint_config is not None:
            pulumi.set(__self__, "rds_http_endpoint_config", rds_http_endpoint_config)

    @property
    @pulumi.getter(name="relationalDatabaseSourceType")
    def relational_database_source_type(self) -> builtins.str:
        """
        The type of relational data source.
        """
        return pulumi.get(self, "relational_database_source_type")

    @property
    @pulumi.getter(name="rdsHttpEndpointConfig")
    def rds_http_endpoint_config(self) -> Optional['outputs.DataSourceRdsHttpEndpointConfig']:
        """
        Information about the Amazon RDS resource.
        """
        return pulumi.get(self, "rds_http_endpoint_config")


@pulumi.output_type
class FunctionConfigurationAppSyncRuntime(dict):
    """
    Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionConfigurationAppSyncRuntime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionConfigurationAppSyncRuntime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionConfigurationAppSyncRuntime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 runtime_version: builtins.str):
        """
        Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        :param builtins.str name: The name of the runtime to use. Currently, the only allowed value is APPSYNC_JS.
        :param builtins.str runtime_version: The version of the runtime to use. Currently, the only allowed version is 1.0.0.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the runtime to use. Currently, the only allowed value is APPSYNC_JS.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> builtins.str:
        """
        The version of the runtime to use. Currently, the only allowed version is 1.0.0.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class FunctionConfigurationLambdaConflictHandlerConfig(dict):
    """
    The LambdaConflictHandlerConfig when configuring LAMBDA as the Conflict Handler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaConflictHandlerArn":
            suggest = "lambda_conflict_handler_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionConfigurationLambdaConflictHandlerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionConfigurationLambdaConflictHandlerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionConfigurationLambdaConflictHandlerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[builtins.str] = None):
        """
        The LambdaConflictHandlerConfig when configuring LAMBDA as the Conflict Handler.
        :param builtins.str lambda_conflict_handler_arn: The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")


@pulumi.output_type
class FunctionConfigurationSyncConfig(dict):
    """
    Describes a Sync configuration for a resolver. Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictDetection":
            suggest = "conflict_detection"
        elif key == "conflictHandler":
            suggest = "conflict_handler"
        elif key == "lambdaConflictHandlerConfig":
            suggest = "lambda_conflict_handler_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionConfigurationSyncConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionConfigurationSyncConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionConfigurationSyncConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_detection: builtins.str,
                 conflict_handler: Optional[builtins.str] = None,
                 lambda_conflict_handler_config: Optional['outputs.FunctionConfigurationLambdaConflictHandlerConfig'] = None):
        """
        Describes a Sync configuration for a resolver. Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        :param builtins.str conflict_detection: The Conflict Detection strategy to use.
        :param builtins.str conflict_handler: The Conflict Resolution strategy to perform in the event of a conflict.
        :param 'FunctionConfigurationLambdaConflictHandlerConfig' lambda_conflict_handler_config: The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
        """
        pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> builtins.str:
        """
        The Conflict Detection strategy to use.
        """
        return pulumi.get(self, "conflict_detection")

    @property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[builtins.str]:
        """
        The Conflict Resolution strategy to perform in the event of a conflict.
        """
        return pulumi.get(self, "conflict_handler")

    @property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional['outputs.FunctionConfigurationLambdaConflictHandlerConfig']:
        """
        The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")


@pulumi.output_type
class GraphQlApiAdditionalAuthenticationProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "lambdaAuthorizerConfig":
            suggest = "lambda_authorizer_config"
        elif key == "openIdConnectConfig":
            suggest = "open_id_connect_config"
        elif key == "userPoolConfig":
            suggest = "user_pool_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQlApiAdditionalAuthenticationProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQlApiAdditionalAuthenticationProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQlApiAdditionalAuthenticationProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: builtins.str,
                 lambda_authorizer_config: Optional['outputs.GraphQlApiLambdaAuthorizerConfig'] = None,
                 open_id_connect_config: Optional['outputs.GraphQlApiOpenIdConnectConfig'] = None,
                 user_pool_config: Optional['outputs.GraphQlApiCognitoUserPoolConfig'] = None):
        """
        :param builtins.str authentication_type: The authentication type for API key, AWS Identity and Access Management, OIDC, Amazon Cognito user pools, or AWS Lambda.
        :param 'GraphQlApiLambdaAuthorizerConfig' lambda_authorizer_config: Configuration for AWS Lambda function authorization.
        :param 'GraphQlApiOpenIdConnectConfig' open_id_connect_config: The OIDC configuration.
        :param 'GraphQlApiCognitoUserPoolConfig' user_pool_config: The Amazon Cognito user pool configuration.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if lambda_authorizer_config is not None:
            pulumi.set(__self__, "lambda_authorizer_config", lambda_authorizer_config)
        if open_id_connect_config is not None:
            pulumi.set(__self__, "open_id_connect_config", open_id_connect_config)
        if user_pool_config is not None:
            pulumi.set(__self__, "user_pool_config", user_pool_config)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> builtins.str:
        """
        The authentication type for API key, AWS Identity and Access Management, OIDC, Amazon Cognito user pools, or AWS Lambda.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="lambdaAuthorizerConfig")
    def lambda_authorizer_config(self) -> Optional['outputs.GraphQlApiLambdaAuthorizerConfig']:
        """
        Configuration for AWS Lambda function authorization.
        """
        return pulumi.get(self, "lambda_authorizer_config")

    @property
    @pulumi.getter(name="openIdConnectConfig")
    def open_id_connect_config(self) -> Optional['outputs.GraphQlApiOpenIdConnectConfig']:
        """
        The OIDC configuration.
        """
        return pulumi.get(self, "open_id_connect_config")

    @property
    @pulumi.getter(name="userPoolConfig")
    def user_pool_config(self) -> Optional['outputs.GraphQlApiCognitoUserPoolConfig']:
        """
        The Amazon Cognito user pool configuration.
        """
        return pulumi.get(self, "user_pool_config")


@pulumi.output_type
class GraphQlApiCognitoUserPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appIdClientRegex":
            suggest = "app_id_client_regex"
        elif key == "awsRegion":
            suggest = "aws_region"
        elif key == "userPoolId":
            suggest = "user_pool_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQlApiCognitoUserPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQlApiCognitoUserPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQlApiCognitoUserPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_id_client_regex: Optional[builtins.str] = None,
                 aws_region: Optional[builtins.str] = None,
                 user_pool_id: Optional[builtins.str] = None):
        """
        :param builtins.str app_id_client_regex: A regular expression for validating the incoming Amazon Cognito user pool app client ID. 
        :param builtins.str aws_region: The AWS Region in which the user pool was created.
        :param builtins.str user_pool_id: The user pool ID
        """
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if user_pool_id is not None:
            pulumi.set(__self__, "user_pool_id", user_pool_id)

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[builtins.str]:
        """
        A regular expression for validating the incoming Amazon Cognito user pool app client ID. 
        """
        return pulumi.get(self, "app_id_client_regex")

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[builtins.str]:
        """
        The AWS Region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> Optional[builtins.str]:
        """
        The user pool ID
        """
        return pulumi.get(self, "user_pool_id")


@pulumi.output_type
class GraphQlApiEnhancedMetricsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSourceLevelMetricsBehavior":
            suggest = "data_source_level_metrics_behavior"
        elif key == "operationLevelMetricsConfig":
            suggest = "operation_level_metrics_config"
        elif key == "resolverLevelMetricsBehavior":
            suggest = "resolver_level_metrics_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQlApiEnhancedMetricsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQlApiEnhancedMetricsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQlApiEnhancedMetricsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source_level_metrics_behavior: builtins.str,
                 operation_level_metrics_config: builtins.str,
                 resolver_level_metrics_behavior: builtins.str):
        """
        :param builtins.str data_source_level_metrics_behavior: Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:
        :param builtins.str operation_level_metrics_config: Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:
        :param builtins.str resolver_level_metrics_behavior: Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:
        """
        pulumi.set(__self__, "data_source_level_metrics_behavior", data_source_level_metrics_behavior)
        pulumi.set(__self__, "operation_level_metrics_config", operation_level_metrics_config)
        pulumi.set(__self__, "resolver_level_metrics_behavior", resolver_level_metrics_behavior)

    @property
    @pulumi.getter(name="dataSourceLevelMetricsBehavior")
    def data_source_level_metrics_behavior(self) -> builtins.str:
        """
        Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:
        """
        return pulumi.get(self, "data_source_level_metrics_behavior")

    @property
    @pulumi.getter(name="operationLevelMetricsConfig")
    def operation_level_metrics_config(self) -> builtins.str:
        """
        Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:
        """
        return pulumi.get(self, "operation_level_metrics_config")

    @property
    @pulumi.getter(name="resolverLevelMetricsBehavior")
    def resolver_level_metrics_behavior(self) -> builtins.str:
        """
        Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:
        """
        return pulumi.get(self, "resolver_level_metrics_behavior")


@pulumi.output_type
class GraphQlApiLambdaAuthorizerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerResultTtlInSeconds":
            suggest = "authorizer_result_ttl_in_seconds"
        elif key == "authorizerUri":
            suggest = "authorizer_uri"
        elif key == "identityValidationExpression":
            suggest = "identity_validation_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQlApiLambdaAuthorizerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQlApiLambdaAuthorizerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQlApiLambdaAuthorizerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_result_ttl_in_seconds: Optional[builtins.int] = None,
                 authorizer_uri: Optional[builtins.str] = None,
                 identity_validation_expression: Optional[builtins.str] = None):
        """
        :param builtins.int authorizer_result_ttl_in_seconds: The number of seconds a response should be cached for.
        :param builtins.str authorizer_uri: The ARN of the Lambda function to be called for authorization.
        :param builtins.str identity_validation_expression: A regular expression for validation of tokens before the Lambda function is called.
        """
        if authorizer_result_ttl_in_seconds is not None:
            pulumi.set(__self__, "authorizer_result_ttl_in_seconds", authorizer_result_ttl_in_seconds)
        if authorizer_uri is not None:
            pulumi.set(__self__, "authorizer_uri", authorizer_uri)
        if identity_validation_expression is not None:
            pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)

    @property
    @pulumi.getter(name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> Optional[builtins.int]:
        """
        The number of seconds a response should be cached for.
        """
        return pulumi.get(self, "authorizer_result_ttl_in_seconds")

    @property
    @pulumi.getter(name="authorizerUri")
    def authorizer_uri(self) -> Optional[builtins.str]:
        """
        The ARN of the Lambda function to be called for authorization.
        """
        return pulumi.get(self, "authorizer_uri")

    @property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[builtins.str]:
        """
        A regular expression for validation of tokens before the Lambda function is called.
        """
        return pulumi.get(self, "identity_validation_expression")


@pulumi.output_type
class GraphQlApiLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchLogsRoleArn":
            suggest = "cloud_watch_logs_role_arn"
        elif key == "excludeVerboseContent":
            suggest = "exclude_verbose_content"
        elif key == "fieldLogLevel":
            suggest = "field_log_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQlApiLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQlApiLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQlApiLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_logs_role_arn: Optional[builtins.str] = None,
                 exclude_verbose_content: Optional[builtins.bool] = None,
                 field_log_level: Optional[builtins.str] = None):
        """
        :param builtins.str cloud_watch_logs_role_arn: The service role that AWS AppSync will assume to publish to Amazon CloudWatch Logs in your account.
        :param builtins.bool exclude_verbose_content: Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level.
        :param builtins.str field_log_level: The field logging level. Values can be NONE, ERROR, INFO, DEBUG, or ALL.
        """
        if cloud_watch_logs_role_arn is not None:
            pulumi.set(__self__, "cloud_watch_logs_role_arn", cloud_watch_logs_role_arn)
        if exclude_verbose_content is not None:
            pulumi.set(__self__, "exclude_verbose_content", exclude_verbose_content)
        if field_log_level is not None:
            pulumi.set(__self__, "field_log_level", field_log_level)

    @property
    @pulumi.getter(name="cloudWatchLogsRoleArn")
    def cloud_watch_logs_role_arn(self) -> Optional[builtins.str]:
        """
        The service role that AWS AppSync will assume to publish to Amazon CloudWatch Logs in your account.
        """
        return pulumi.get(self, "cloud_watch_logs_role_arn")

    @property
    @pulumi.getter(name="excludeVerboseContent")
    def exclude_verbose_content(self) -> Optional[builtins.bool]:
        """
        Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level.
        """
        return pulumi.get(self, "exclude_verbose_content")

    @property
    @pulumi.getter(name="fieldLogLevel")
    def field_log_level(self) -> Optional[builtins.str]:
        """
        The field logging level. Values can be NONE, ERROR, INFO, DEBUG, or ALL.
        """
        return pulumi.get(self, "field_log_level")


@pulumi.output_type
class GraphQlApiOpenIdConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authTtl":
            suggest = "auth_ttl"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "iatTtl":
            suggest = "iat_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQlApiOpenIdConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQlApiOpenIdConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQlApiOpenIdConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_ttl: Optional[builtins.float] = None,
                 client_id: Optional[builtins.str] = None,
                 iat_ttl: Optional[builtins.float] = None,
                 issuer: Optional[builtins.str] = None):
        """
        :param builtins.float auth_ttl: The number of milliseconds that a token is valid after being authenticated.
        :param builtins.str client_id: The client identifier of the Relying party at the OpenID identity provider.
        :param builtins.float iat_ttl: The number of milliseconds that a token is valid after it's issued to a user.
        :param builtins.str issuer: The issuer for the OIDC configuration. 
        """
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[builtins.float]:
        """
        The number of milliseconds that a token is valid after being authenticated.
        """
        return pulumi.get(self, "auth_ttl")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[builtins.str]:
        """
        The client identifier of the Relying party at the OpenID identity provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[builtins.float]:
        """
        The number of milliseconds that a token is valid after it's issued to a user.
        """
        return pulumi.get(self, "iat_ttl")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[builtins.str]:
        """
        The issuer for the OIDC configuration. 
        """
        return pulumi.get(self, "issuer")


@pulumi.output_type
class GraphQlApiUserPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appIdClientRegex":
            suggest = "app_id_client_regex"
        elif key == "awsRegion":
            suggest = "aws_region"
        elif key == "defaultAction":
            suggest = "default_action"
        elif key == "userPoolId":
            suggest = "user_pool_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQlApiUserPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQlApiUserPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQlApiUserPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_id_client_regex: Optional[builtins.str] = None,
                 aws_region: Optional[builtins.str] = None,
                 default_action: Optional[builtins.str] = None,
                 user_pool_id: Optional[builtins.str] = None):
        """
        :param builtins.str app_id_client_regex: A regular expression for validating the incoming Amazon Cognito user pool app client ID.
        :param builtins.str aws_region: The AWS Region in which the user pool was created.
        :param builtins.str default_action: The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool authentication doesn't match the Amazon Cognito user pool configuration.
        :param builtins.str user_pool_id: The user pool ID.
        """
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if user_pool_id is not None:
            pulumi.set(__self__, "user_pool_id", user_pool_id)

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[builtins.str]:
        """
        A regular expression for validating the incoming Amazon Cognito user pool app client ID.
        """
        return pulumi.get(self, "app_id_client_regex")

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[builtins.str]:
        """
        The AWS Region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[builtins.str]:
        """
        The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool authentication doesn't match the Amazon Cognito user pool configuration.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> Optional[builtins.str]:
        """
        The user pool ID.
        """
        return pulumi.get(self, "user_pool_id")


@pulumi.output_type
class ResolverAppSyncRuntime(dict):
    """
    Describes a runtime used by an APSYlong resolver or APSYlong function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverAppSyncRuntime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverAppSyncRuntime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverAppSyncRuntime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 runtime_version: builtins.str):
        """
        Describes a runtime used by an APSYlong resolver or APSYlong function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        :param builtins.str name: The ``name`` of the runtime to use. Currently, the only allowed value is ``APPSYNC_JS``.
        :param builtins.str runtime_version: The ``version`` of the runtime to use. Currently, the only allowed version is ``1.0.0``.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The ``name`` of the runtime to use. Currently, the only allowed value is ``APPSYNC_JS``.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> builtins.str:
        """
        The ``version`` of the runtime to use. Currently, the only allowed version is ``1.0.0``.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class ResolverCachingConfig(dict):
    """
    The caching configuration for a resolver that has caching activated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cachingKeys":
            suggest = "caching_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverCachingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverCachingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverCachingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ttl: builtins.float,
                 caching_keys: Optional[Sequence[builtins.str]] = None):
        """
        The caching configuration for a resolver that has caching activated.
        :param builtins.float ttl: The TTL in seconds for a resolver that has caching activated.
                Valid values are 1–3,600 seconds.
        :param Sequence[builtins.str] caching_keys: The caching keys for a resolver that has caching activated.
                Valid values are entries from the ``$context.arguments``, ``$context.source``, and ``$context.identity`` maps.
        """
        pulumi.set(__self__, "ttl", ttl)
        if caching_keys is not None:
            pulumi.set(__self__, "caching_keys", caching_keys)

    @property
    @pulumi.getter
    def ttl(self) -> builtins.float:
        """
        The TTL in seconds for a resolver that has caching activated.
         Valid values are 1–3,600 seconds.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="cachingKeys")
    def caching_keys(self) -> Optional[Sequence[builtins.str]]:
        """
        The caching keys for a resolver that has caching activated.
         Valid values are entries from the ``$context.arguments``, ``$context.source``, and ``$context.identity`` maps.
        """
        return pulumi.get(self, "caching_keys")


@pulumi.output_type
class ResolverLambdaConflictHandlerConfig(dict):
    """
    The ``LambdaConflictHandlerConfig`` when configuring LAMBDA as the Conflict Handler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaConflictHandlerArn":
            suggest = "lambda_conflict_handler_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverLambdaConflictHandlerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverLambdaConflictHandlerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverLambdaConflictHandlerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[builtins.str] = None):
        """
        The ``LambdaConflictHandlerConfig`` when configuring LAMBDA as the Conflict Handler.
        :param builtins.str lambda_conflict_handler_arn: The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")


@pulumi.output_type
class ResolverPipelineConfig(dict):
    """
    Use the ``PipelineConfig`` property type to specify ``PipelineConfig`` for an APSYlong resolver.
     ``PipelineConfig`` is a property of the [AWS::AppSync::Resolver](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html) resource.
    """
    def __init__(__self__, *,
                 functions: Optional[Sequence[builtins.str]] = None):
        """
        Use the ``PipelineConfig`` property type to specify ``PipelineConfig`` for an APSYlong resolver.
         ``PipelineConfig`` is a property of the [AWS::AppSync::Resolver](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html) resource.
        :param Sequence[builtins.str] functions: A list of ``Function`` objects.
        """
        if functions is not None:
            pulumi.set(__self__, "functions", functions)

    @property
    @pulumi.getter
    def functions(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of ``Function`` objects.
        """
        return pulumi.get(self, "functions")


@pulumi.output_type
class ResolverSyncConfig(dict):
    """
    Describes a Sync configuration for a resolver.
     Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictDetection":
            suggest = "conflict_detection"
        elif key == "conflictHandler":
            suggest = "conflict_handler"
        elif key == "lambdaConflictHandlerConfig":
            suggest = "lambda_conflict_handler_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverSyncConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverSyncConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverSyncConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_detection: builtins.str,
                 conflict_handler: Optional[builtins.str] = None,
                 lambda_conflict_handler_config: Optional['outputs.ResolverLambdaConflictHandlerConfig'] = None):
        """
        Describes a Sync configuration for a resolver.
         Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        :param builtins.str conflict_detection: The Conflict Detection strategy to use.
                 +  *VERSION*: Detect conflicts based on object versions for this resolver.
                 +  *NONE*: Do not detect conflicts when invoking this resolver.
        :param builtins.str conflict_handler: The Conflict Resolution strategy to perform in the event of a conflict.
                 +  *OPTIMISTIC_CONCURRENCY*: Resolve conflicts by rejecting mutations when versions don't match the latest version at the server.
                 +  *AUTOMERGE*: Resolve conflicts with the Automerge conflict resolution strategy.
                 +  *LAMBDA*: Resolve conflicts with an LAMlong function supplied in the ``LambdaConflictHandlerConfig``.
        :param 'ResolverLambdaConflictHandlerConfig' lambda_conflict_handler_config: The ``LambdaConflictHandlerConfig`` when configuring ``LAMBDA`` as the Conflict Handler.
        """
        pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> builtins.str:
        """
        The Conflict Detection strategy to use.
          +  *VERSION*: Detect conflicts based on object versions for this resolver.
          +  *NONE*: Do not detect conflicts when invoking this resolver.
        """
        return pulumi.get(self, "conflict_detection")

    @property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[builtins.str]:
        """
        The Conflict Resolution strategy to perform in the event of a conflict.
          +  *OPTIMISTIC_CONCURRENCY*: Resolve conflicts by rejecting mutations when versions don't match the latest version at the server.
          +  *AUTOMERGE*: Resolve conflicts with the Automerge conflict resolution strategy.
          +  *LAMBDA*: Resolve conflicts with an LAMlong function supplied in the ``LambdaConflictHandlerConfig``.
        """
        return pulumi.get(self, "conflict_handler")

    @property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional['outputs.ResolverLambdaConflictHandlerConfig']:
        """
        The ``LambdaConflictHandlerConfig`` when configuring ``LAMBDA`` as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")


@pulumi.output_type
class SourceApiAssociationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mergeType":
            suggest = "merge_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceApiAssociationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceApiAssociationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceApiAssociationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 merge_type: Optional['SourceApiAssociationConfigMergeType'] = None):
        """
        :param 'SourceApiAssociationConfigMergeType' merge_type: Configuration of the merged behavior for the association. For example when it could be auto or has to be manual.
        """
        if merge_type is not None:
            pulumi.set(__self__, "merge_type", merge_type)

    @property
    @pulumi.getter(name="mergeType")
    def merge_type(self) -> Optional['SourceApiAssociationConfigMergeType']:
        """
        Configuration of the merged behavior for the association. For example when it could be auto or has to be manual.
        """
        return pulumi.get(self, "merge_type")


