# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['GraphQlApiArgs', 'GraphQlApi']

@pulumi.input_type
class GraphQlApiArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[builtins.str],
                 additional_authentication_providers: Optional[pulumi.Input[Sequence[pulumi.Input['GraphQlApiAdditionalAuthenticationProviderArgs']]]] = None,
                 api_type: Optional[pulumi.Input[builtins.str]] = None,
                 enhanced_metrics_config: Optional[pulumi.Input['GraphQlApiEnhancedMetricsConfigArgs']] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 introspection_config: Optional[pulumi.Input[builtins.str]] = None,
                 lambda_authorizer_config: Optional[pulumi.Input['GraphQlApiLambdaAuthorizerConfigArgs']] = None,
                 log_config: Optional[pulumi.Input['GraphQlApiLogConfigArgs']] = None,
                 merged_api_execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 open_id_connect_config: Optional[pulumi.Input['GraphQlApiOpenIdConnectConfigArgs']] = None,
                 owner_contact: Optional[pulumi.Input[builtins.str]] = None,
                 query_depth_limit: Optional[pulumi.Input[builtins.int]] = None,
                 resolver_count_limit: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 user_pool_config: Optional[pulumi.Input['GraphQlApiUserPoolConfigArgs']] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None,
                 xray_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a GraphQlApi resource.
        :param pulumi.Input[builtins.str] authentication_type: Security configuration for your GraphQL API
        :param pulumi.Input[Sequence[pulumi.Input['GraphQlApiAdditionalAuthenticationProviderArgs']]] additional_authentication_providers: A list of additional authentication providers for the GraphqlApi API.
        :param pulumi.Input[builtins.str] api_type: The value that indicates whether the GraphQL API is a standard API (GRAPHQL) or merged API (MERGED).
        :param pulumi.Input['GraphQlApiEnhancedMetricsConfigArgs'] enhanced_metrics_config: Enables and controls the enhanced metrics feature. Enhanced metrics emit granular data on API usage and performance such as AppSync request and error counts, latency, and cache hits/misses. All enhanced metric data is sent to your CloudWatch account, and you can configure the types of data that will be sent.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: A map containing the list of resources with their properties and environment variables.
        :param pulumi.Input[builtins.str] introspection_config: Sets the value of the GraphQL API to enable (ENABLED) or disable (DISABLED) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled.
        :param pulumi.Input['GraphQlApiLambdaAuthorizerConfigArgs'] lambda_authorizer_config: A LambdaAuthorizerConfig holds configuration on how to authorize AWS AppSync API access when using the AWS_LAMBDA authorizer mode. Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
        :param pulumi.Input['GraphQlApiLogConfigArgs'] log_config: The Amazon CloudWatch Logs configuration.
        :param pulumi.Input[builtins.str] merged_api_execution_role_arn: The AWS Identity and Access Management service role ARN for a merged API. 
        :param pulumi.Input[builtins.str] name: The API name
        :param pulumi.Input['GraphQlApiOpenIdConnectConfigArgs'] open_id_connect_config: The OpenID Connect configuration.
        :param pulumi.Input[builtins.str] owner_contact: The owner contact information for an API resource.
        :param pulumi.Input[builtins.int] query_depth_limit: The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query.
        :param pulumi.Input[builtins.int] resolver_count_limit: The maximum number of resolvers that can be invoked in a single request.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An arbitrary set of tags (key-value pairs) for this GraphQL API.
        :param pulumi.Input['GraphQlApiUserPoolConfigArgs'] user_pool_config: Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
        :param pulumi.Input[builtins.str] visibility: Sets the scope of the GraphQL API to public (GLOBAL) or private (PRIVATE). By default, the scope is set to Global if no value is provided.
        :param pulumi.Input[builtins.bool] xray_enabled: A flag indicating whether to use AWS X-Ray tracing for this GraphqlApi.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if additional_authentication_providers is not None:
            pulumi.set(__self__, "additional_authentication_providers", additional_authentication_providers)
        if api_type is not None:
            pulumi.set(__self__, "api_type", api_type)
        if enhanced_metrics_config is not None:
            pulumi.set(__self__, "enhanced_metrics_config", enhanced_metrics_config)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if introspection_config is not None:
            pulumi.set(__self__, "introspection_config", introspection_config)
        if lambda_authorizer_config is not None:
            pulumi.set(__self__, "lambda_authorizer_config", lambda_authorizer_config)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if merged_api_execution_role_arn is not None:
            pulumi.set(__self__, "merged_api_execution_role_arn", merged_api_execution_role_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_id_connect_config is not None:
            pulumi.set(__self__, "open_id_connect_config", open_id_connect_config)
        if owner_contact is not None:
            pulumi.set(__self__, "owner_contact", owner_contact)
        if query_depth_limit is not None:
            pulumi.set(__self__, "query_depth_limit", query_depth_limit)
        if resolver_count_limit is not None:
            pulumi.set(__self__, "resolver_count_limit", resolver_count_limit)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_pool_config is not None:
            pulumi.set(__self__, "user_pool_config", user_pool_config)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)
        if xray_enabled is not None:
            pulumi.set(__self__, "xray_enabled", xray_enabled)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[builtins.str]:
        """
        Security configuration for your GraphQL API
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="additionalAuthenticationProviders")
    def additional_authentication_providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GraphQlApiAdditionalAuthenticationProviderArgs']]]]:
        """
        A list of additional authentication providers for the GraphqlApi API.
        """
        return pulumi.get(self, "additional_authentication_providers")

    @additional_authentication_providers.setter
    def additional_authentication_providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GraphQlApiAdditionalAuthenticationProviderArgs']]]]):
        pulumi.set(self, "additional_authentication_providers", value)

    @property
    @pulumi.getter(name="apiType")
    def api_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value that indicates whether the GraphQL API is a standard API (GRAPHQL) or merged API (MERGED).
        """
        return pulumi.get(self, "api_type")

    @api_type.setter
    def api_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_type", value)

    @property
    @pulumi.getter(name="enhancedMetricsConfig")
    def enhanced_metrics_config(self) -> Optional[pulumi.Input['GraphQlApiEnhancedMetricsConfigArgs']]:
        """
        Enables and controls the enhanced metrics feature. Enhanced metrics emit granular data on API usage and performance such as AppSync request and error counts, latency, and cache hits/misses. All enhanced metric data is sent to your CloudWatch account, and you can configure the types of data that will be sent.
        """
        return pulumi.get(self, "enhanced_metrics_config")

    @enhanced_metrics_config.setter
    def enhanced_metrics_config(self, value: Optional[pulumi.Input['GraphQlApiEnhancedMetricsConfigArgs']]):
        pulumi.set(self, "enhanced_metrics_config", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map containing the list of resources with their properties and environment variables.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="introspectionConfig")
    def introspection_config(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets the value of the GraphQL API to enable (ENABLED) or disable (DISABLED) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled.
        """
        return pulumi.get(self, "introspection_config")

    @introspection_config.setter
    def introspection_config(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "introspection_config", value)

    @property
    @pulumi.getter(name="lambdaAuthorizerConfig")
    def lambda_authorizer_config(self) -> Optional[pulumi.Input['GraphQlApiLambdaAuthorizerConfigArgs']]:
        """
        A LambdaAuthorizerConfig holds configuration on how to authorize AWS AppSync API access when using the AWS_LAMBDA authorizer mode. Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
        """
        return pulumi.get(self, "lambda_authorizer_config")

    @lambda_authorizer_config.setter
    def lambda_authorizer_config(self, value: Optional[pulumi.Input['GraphQlApiLambdaAuthorizerConfigArgs']]):
        pulumi.set(self, "lambda_authorizer_config", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['GraphQlApiLogConfigArgs']]:
        """
        The Amazon CloudWatch Logs configuration.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['GraphQlApiLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter(name="mergedApiExecutionRoleArn")
    def merged_api_execution_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS Identity and Access Management service role ARN for a merged API. 
        """
        return pulumi.get(self, "merged_api_execution_role_arn")

    @merged_api_execution_role_arn.setter
    def merged_api_execution_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "merged_api_execution_role_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The API name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="openIdConnectConfig")
    def open_id_connect_config(self) -> Optional[pulumi.Input['GraphQlApiOpenIdConnectConfigArgs']]:
        """
        The OpenID Connect configuration.
        """
        return pulumi.get(self, "open_id_connect_config")

    @open_id_connect_config.setter
    def open_id_connect_config(self, value: Optional[pulumi.Input['GraphQlApiOpenIdConnectConfigArgs']]):
        pulumi.set(self, "open_id_connect_config", value)

    @property
    @pulumi.getter(name="ownerContact")
    def owner_contact(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The owner contact information for an API resource.
        """
        return pulumi.get(self, "owner_contact")

    @owner_contact.setter
    def owner_contact(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_contact", value)

    @property
    @pulumi.getter(name="queryDepthLimit")
    def query_depth_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query.
        """
        return pulumi.get(self, "query_depth_limit")

    @query_depth_limit.setter
    def query_depth_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "query_depth_limit", value)

    @property
    @pulumi.getter(name="resolverCountLimit")
    def resolver_count_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of resolvers that can be invoked in a single request.
        """
        return pulumi.get(self, "resolver_count_limit")

    @resolver_count_limit.setter
    def resolver_count_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "resolver_count_limit", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An arbitrary set of tags (key-value pairs) for this GraphQL API.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userPoolConfig")
    def user_pool_config(self) -> Optional[pulumi.Input['GraphQlApiUserPoolConfigArgs']]:
        """
        Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
        """
        return pulumi.get(self, "user_pool_config")

    @user_pool_config.setter
    def user_pool_config(self, value: Optional[pulumi.Input['GraphQlApiUserPoolConfigArgs']]):
        pulumi.set(self, "user_pool_config", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets the scope of the GraphQL API to public (GLOBAL) or private (PRIVATE). By default, the scope is set to Global if no value is provided.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "visibility", value)

    @property
    @pulumi.getter(name="xrayEnabled")
    def xray_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A flag indicating whether to use AWS X-Ray tracing for this GraphqlApi.
        """
        return pulumi.get(self, "xray_enabled")

    @xray_enabled.setter
    def xray_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "xray_enabled", value)


@pulumi.type_token("aws-native:appsync:GraphQlApi")
class GraphQlApi(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_authentication_providers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GraphQlApiAdditionalAuthenticationProviderArgs', 'GraphQlApiAdditionalAuthenticationProviderArgsDict']]]]] = None,
                 api_type: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 enhanced_metrics_config: Optional[pulumi.Input[Union['GraphQlApiEnhancedMetricsConfigArgs', 'GraphQlApiEnhancedMetricsConfigArgsDict']]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 introspection_config: Optional[pulumi.Input[builtins.str]] = None,
                 lambda_authorizer_config: Optional[pulumi.Input[Union['GraphQlApiLambdaAuthorizerConfigArgs', 'GraphQlApiLambdaAuthorizerConfigArgsDict']]] = None,
                 log_config: Optional[pulumi.Input[Union['GraphQlApiLogConfigArgs', 'GraphQlApiLogConfigArgsDict']]] = None,
                 merged_api_execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 open_id_connect_config: Optional[pulumi.Input[Union['GraphQlApiOpenIdConnectConfigArgs', 'GraphQlApiOpenIdConnectConfigArgsDict']]] = None,
                 owner_contact: Optional[pulumi.Input[builtins.str]] = None,
                 query_depth_limit: Optional[pulumi.Input[builtins.int]] = None,
                 resolver_count_limit: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 user_pool_config: Optional[pulumi.Input[Union['GraphQlApiUserPoolConfigArgs', 'GraphQlApiUserPoolConfigArgsDict']]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None,
                 xray_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::AppSync::GraphQLApi

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GraphQlApiAdditionalAuthenticationProviderArgs', 'GraphQlApiAdditionalAuthenticationProviderArgsDict']]]] additional_authentication_providers: A list of additional authentication providers for the GraphqlApi API.
        :param pulumi.Input[builtins.str] api_type: The value that indicates whether the GraphQL API is a standard API (GRAPHQL) or merged API (MERGED).
        :param pulumi.Input[builtins.str] authentication_type: Security configuration for your GraphQL API
        :param pulumi.Input[Union['GraphQlApiEnhancedMetricsConfigArgs', 'GraphQlApiEnhancedMetricsConfigArgsDict']] enhanced_metrics_config: Enables and controls the enhanced metrics feature. Enhanced metrics emit granular data on API usage and performance such as AppSync request and error counts, latency, and cache hits/misses. All enhanced metric data is sent to your CloudWatch account, and you can configure the types of data that will be sent.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: A map containing the list of resources with their properties and environment variables.
        :param pulumi.Input[builtins.str] introspection_config: Sets the value of the GraphQL API to enable (ENABLED) or disable (DISABLED) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled.
        :param pulumi.Input[Union['GraphQlApiLambdaAuthorizerConfigArgs', 'GraphQlApiLambdaAuthorizerConfigArgsDict']] lambda_authorizer_config: A LambdaAuthorizerConfig holds configuration on how to authorize AWS AppSync API access when using the AWS_LAMBDA authorizer mode. Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
        :param pulumi.Input[Union['GraphQlApiLogConfigArgs', 'GraphQlApiLogConfigArgsDict']] log_config: The Amazon CloudWatch Logs configuration.
        :param pulumi.Input[builtins.str] merged_api_execution_role_arn: The AWS Identity and Access Management service role ARN for a merged API. 
        :param pulumi.Input[builtins.str] name: The API name
        :param pulumi.Input[Union['GraphQlApiOpenIdConnectConfigArgs', 'GraphQlApiOpenIdConnectConfigArgsDict']] open_id_connect_config: The OpenID Connect configuration.
        :param pulumi.Input[builtins.str] owner_contact: The owner contact information for an API resource.
        :param pulumi.Input[builtins.int] query_depth_limit: The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query.
        :param pulumi.Input[builtins.int] resolver_count_limit: The maximum number of resolvers that can be invoked in a single request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An arbitrary set of tags (key-value pairs) for this GraphQL API.
        :param pulumi.Input[Union['GraphQlApiUserPoolConfigArgs', 'GraphQlApiUserPoolConfigArgsDict']] user_pool_config: Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
        :param pulumi.Input[builtins.str] visibility: Sets the scope of the GraphQL API to public (GLOBAL) or private (PRIVATE). By default, the scope is set to Global if no value is provided.
        :param pulumi.Input[builtins.bool] xray_enabled: A flag indicating whether to use AWS X-Ray tracing for this GraphqlApi.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GraphQlApiArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::AppSync::GraphQLApi

        :param str resource_name: The name of the resource.
        :param GraphQlApiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GraphQlApiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_authentication_providers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GraphQlApiAdditionalAuthenticationProviderArgs', 'GraphQlApiAdditionalAuthenticationProviderArgsDict']]]]] = None,
                 api_type: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 enhanced_metrics_config: Optional[pulumi.Input[Union['GraphQlApiEnhancedMetricsConfigArgs', 'GraphQlApiEnhancedMetricsConfigArgsDict']]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 introspection_config: Optional[pulumi.Input[builtins.str]] = None,
                 lambda_authorizer_config: Optional[pulumi.Input[Union['GraphQlApiLambdaAuthorizerConfigArgs', 'GraphQlApiLambdaAuthorizerConfigArgsDict']]] = None,
                 log_config: Optional[pulumi.Input[Union['GraphQlApiLogConfigArgs', 'GraphQlApiLogConfigArgsDict']]] = None,
                 merged_api_execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 open_id_connect_config: Optional[pulumi.Input[Union['GraphQlApiOpenIdConnectConfigArgs', 'GraphQlApiOpenIdConnectConfigArgsDict']]] = None,
                 owner_contact: Optional[pulumi.Input[builtins.str]] = None,
                 query_depth_limit: Optional[pulumi.Input[builtins.int]] = None,
                 resolver_count_limit: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 user_pool_config: Optional[pulumi.Input[Union['GraphQlApiUserPoolConfigArgs', 'GraphQlApiUserPoolConfigArgsDict']]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None,
                 xray_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GraphQlApiArgs.__new__(GraphQlApiArgs)

            __props__.__dict__["additional_authentication_providers"] = additional_authentication_providers
            __props__.__dict__["api_type"] = api_type
            if authentication_type is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_type'")
            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["enhanced_metrics_config"] = enhanced_metrics_config
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["introspection_config"] = introspection_config
            __props__.__dict__["lambda_authorizer_config"] = lambda_authorizer_config
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["merged_api_execution_role_arn"] = merged_api_execution_role_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["open_id_connect_config"] = open_id_connect_config
            __props__.__dict__["owner_contact"] = owner_contact
            __props__.__dict__["query_depth_limit"] = query_depth_limit
            __props__.__dict__["resolver_count_limit"] = resolver_count_limit
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_pool_config"] = user_pool_config
            __props__.__dict__["visibility"] = visibility
            __props__.__dict__["xray_enabled"] = xray_enabled
            __props__.__dict__["api_id"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["graph_ql_dns"] = None
            __props__.__dict__["graph_ql_endpoint_arn"] = None
            __props__.__dict__["graph_ql_url"] = None
            __props__.__dict__["realtime_dns"] = None
            __props__.__dict__["realtime_url"] = None
        super(GraphQlApi, __self__).__init__(
            'aws-native:appsync:GraphQlApi',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'GraphQlApi':
        """
        Get an existing GraphQlApi resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = GraphQlApiArgs.__new__(GraphQlApiArgs)

        __props__.__dict__["additional_authentication_providers"] = None
        __props__.__dict__["api_id"] = None
        __props__.__dict__["api_type"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["authentication_type"] = None
        __props__.__dict__["enhanced_metrics_config"] = None
        __props__.__dict__["environment_variables"] = None
        __props__.__dict__["graph_ql_dns"] = None
        __props__.__dict__["graph_ql_endpoint_arn"] = None
        __props__.__dict__["graph_ql_url"] = None
        __props__.__dict__["introspection_config"] = None
        __props__.__dict__["lambda_authorizer_config"] = None
        __props__.__dict__["log_config"] = None
        __props__.__dict__["merged_api_execution_role_arn"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["open_id_connect_config"] = None
        __props__.__dict__["owner_contact"] = None
        __props__.__dict__["query_depth_limit"] = None
        __props__.__dict__["realtime_dns"] = None
        __props__.__dict__["realtime_url"] = None
        __props__.__dict__["resolver_count_limit"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["user_pool_config"] = None
        __props__.__dict__["visibility"] = None
        __props__.__dict__["xray_enabled"] = None
        return GraphQlApi(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalAuthenticationProviders")
    def additional_authentication_providers(self) -> pulumi.Output[Optional[Sequence['outputs.GraphQlApiAdditionalAuthenticationProvider']]]:
        """
        A list of additional authentication providers for the GraphqlApi API.
        """
        return pulumi.get(self, "additional_authentication_providers")

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique AWS AppSync GraphQL API identifier.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter(name="apiType")
    def api_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The value that indicates whether the GraphQL API is a standard API (GRAPHQL) or merged API (MERGED).
        """
        return pulumi.get(self, "api_type")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the API key
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[builtins.str]:
        """
        Security configuration for your GraphQL API
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="enhancedMetricsConfig")
    def enhanced_metrics_config(self) -> pulumi.Output[Optional['outputs.GraphQlApiEnhancedMetricsConfig']]:
        """
        Enables and controls the enhanced metrics feature. Enhanced metrics emit granular data on API usage and performance such as AppSync request and error counts, latency, and cache hits/misses. All enhanced metric data is sent to your CloudWatch account, and you can configure the types of data that will be sent.
        """
        return pulumi.get(self, "enhanced_metrics_config")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map containing the list of resources with their properties and environment variables.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="graphQlDns")
    def graph_ql_dns(self) -> pulumi.Output[builtins.str]:
        """
        The fully qualified domain name (FQDN) of the endpoint URL of your GraphQL API.
        """
        return pulumi.get(self, "graph_ql_dns")

    @property
    @pulumi.getter(name="graphQlEndpointArn")
    def graph_ql_endpoint_arn(self) -> pulumi.Output[builtins.str]:
        """
        The GraphQL endpoint ARN.
        """
        return pulumi.get(self, "graph_ql_endpoint_arn")

    @property
    @pulumi.getter(name="graphQlUrl")
    def graph_ql_url(self) -> pulumi.Output[builtins.str]:
        """
        The Endpoint URL of your GraphQL API.
        """
        return pulumi.get(self, "graph_ql_url")

    @property
    @pulumi.getter(name="introspectionConfig")
    def introspection_config(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Sets the value of the GraphQL API to enable (ENABLED) or disable (DISABLED) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled.
        """
        return pulumi.get(self, "introspection_config")

    @property
    @pulumi.getter(name="lambdaAuthorizerConfig")
    def lambda_authorizer_config(self) -> pulumi.Output[Optional['outputs.GraphQlApiLambdaAuthorizerConfig']]:
        """
        A LambdaAuthorizerConfig holds configuration on how to authorize AWS AppSync API access when using the AWS_LAMBDA authorizer mode. Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
        """
        return pulumi.get(self, "lambda_authorizer_config")

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.GraphQlApiLogConfig']]:
        """
        The Amazon CloudWatch Logs configuration.
        """
        return pulumi.get(self, "log_config")

    @property
    @pulumi.getter(name="mergedApiExecutionRoleArn")
    def merged_api_execution_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS Identity and Access Management service role ARN for a merged API. 
        """
        return pulumi.get(self, "merged_api_execution_role_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The API name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="openIdConnectConfig")
    def open_id_connect_config(self) -> pulumi.Output[Optional['outputs.GraphQlApiOpenIdConnectConfig']]:
        """
        The OpenID Connect configuration.
        """
        return pulumi.get(self, "open_id_connect_config")

    @property
    @pulumi.getter(name="ownerContact")
    def owner_contact(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The owner contact information for an API resource.
        """
        return pulumi.get(self, "owner_contact")

    @property
    @pulumi.getter(name="queryDepthLimit")
    def query_depth_limit(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query.
        """
        return pulumi.get(self, "query_depth_limit")

    @property
    @pulumi.getter(name="realtimeDns")
    def realtime_dns(self) -> pulumi.Output[builtins.str]:
        """
        The fully qualified domain name (FQDN) of the real-time endpoint URL of your GraphQL API.
        """
        return pulumi.get(self, "realtime_dns")

    @property
    @pulumi.getter(name="realtimeUrl")
    def realtime_url(self) -> pulumi.Output[builtins.str]:
        """
        The GraphQL API real-time endpoint URL.
        """
        return pulumi.get(self, "realtime_url")

    @property
    @pulumi.getter(name="resolverCountLimit")
    def resolver_count_limit(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum number of resolvers that can be invoked in a single request.
        """
        return pulumi.get(self, "resolver_count_limit")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An arbitrary set of tags (key-value pairs) for this GraphQL API.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userPoolConfig")
    def user_pool_config(self) -> pulumi.Output[Optional['outputs.GraphQlApiUserPoolConfig']]:
        """
        Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
        """
        return pulumi.get(self, "user_pool_config")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Sets the scope of the GraphQL API to public (GLOBAL) or private (PRIVATE). By default, the scope is set to Global if no value is provided.
        """
        return pulumi.get(self, "visibility")

    @property
    @pulumi.getter(name="xrayEnabled")
    def xray_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A flag indicating whether to use AWS X-Ray tracing for this GraphqlApi.
        """
        return pulumi.get(self, "xray_enabled")

