# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetResolverResult',
    'AwaitableGetResolverResult',
    'get_resolver',
    'get_resolver_output',
]

@pulumi.output_type
class GetResolverResult:
    def __init__(__self__, caching_config=None, code=None, data_source_name=None, kind=None, max_batch_size=None, metrics_config=None, pipeline_config=None, request_mapping_template=None, resolver_arn=None, response_mapping_template=None, runtime=None, sync_config=None):
        if caching_config and not isinstance(caching_config, dict):
            raise TypeError("Expected argument 'caching_config' to be a dict")
        pulumi.set(__self__, "caching_config", caching_config)
        if code and not isinstance(code, str):
            raise TypeError("Expected argument 'code' to be a str")
        pulumi.set(__self__, "code", code)
        if data_source_name and not isinstance(data_source_name, str):
            raise TypeError("Expected argument 'data_source_name' to be a str")
        pulumi.set(__self__, "data_source_name", data_source_name)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if max_batch_size and not isinstance(max_batch_size, int):
            raise TypeError("Expected argument 'max_batch_size' to be a int")
        pulumi.set(__self__, "max_batch_size", max_batch_size)
        if metrics_config and not isinstance(metrics_config, str):
            raise TypeError("Expected argument 'metrics_config' to be a str")
        pulumi.set(__self__, "metrics_config", metrics_config)
        if pipeline_config and not isinstance(pipeline_config, dict):
            raise TypeError("Expected argument 'pipeline_config' to be a dict")
        pulumi.set(__self__, "pipeline_config", pipeline_config)
        if request_mapping_template and not isinstance(request_mapping_template, str):
            raise TypeError("Expected argument 'request_mapping_template' to be a str")
        pulumi.set(__self__, "request_mapping_template", request_mapping_template)
        if resolver_arn and not isinstance(resolver_arn, str):
            raise TypeError("Expected argument 'resolver_arn' to be a str")
        pulumi.set(__self__, "resolver_arn", resolver_arn)
        if response_mapping_template and not isinstance(response_mapping_template, str):
            raise TypeError("Expected argument 'response_mapping_template' to be a str")
        pulumi.set(__self__, "response_mapping_template", response_mapping_template)
        if runtime and not isinstance(runtime, dict):
            raise TypeError("Expected argument 'runtime' to be a dict")
        pulumi.set(__self__, "runtime", runtime)
        if sync_config and not isinstance(sync_config, dict):
            raise TypeError("Expected argument 'sync_config' to be a dict")
        pulumi.set(__self__, "sync_config", sync_config)

    @property
    @pulumi.getter(name="cachingConfig")
    def caching_config(self) -> Optional['outputs.ResolverCachingConfig']:
        """
        The caching configuration for the resolver.
        """
        return pulumi.get(self, "caching_config")

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.str]:
        """
        The ``resolver`` code that contains the request and response functions. When code is used, the ``runtime`` is required. The runtime value must be ``APPSYNC_JS``.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> Optional[builtins.str]:
        """
        The resolver data source name.
        """
        return pulumi.get(self, "data_source_name")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        The resolver type.
          +  *UNIT*: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.
          +  *PIPELINE*: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of ``Function`` objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of resolver request inputs that will be sent to a single LAMlong function in a ``BatchInvoke`` operation.
        """
        return pulumi.get(self, "max_batch_size")

    @property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> Optional['ResolverMetricsConfig']:
        """
        Enables or disables enhanced resolver metrics for specified resolvers. Note that ``MetricsConfig`` won't be used unless the ``resolverLevelMetricsBehavior`` value is set to ``PER_RESOLVER_METRICS``. If the ``resolverLevelMetricsBehavior`` is set to ``FULL_REQUEST_RESOLVER_METRICS`` instead, ``MetricsConfig`` will be ignored. However, you can still set its value.
        """
        return pulumi.get(self, "metrics_config")

    @property
    @pulumi.getter(name="pipelineConfig")
    def pipeline_config(self) -> Optional['outputs.ResolverPipelineConfig']:
        """
        Functions linked with the pipeline resolver.
        """
        return pulumi.get(self, "pipeline_config")

    @property
    @pulumi.getter(name="requestMappingTemplate")
    def request_mapping_template(self) -> Optional[builtins.str]:
        """
        The request mapping template.
         Request mapping templates are optional when using a Lambda data source. For all other data sources, a request mapping template is required.
        """
        return pulumi.get(self, "request_mapping_template")

    @property
    @pulumi.getter(name="resolverArn")
    def resolver_arn(self) -> Optional[builtins.str]:
        """
        ARN of the resolver, such as `arn:aws:appsync:us-east-1:123456789012:apis/graphqlapiid/types/typename/resolvers/resolvername` .
        """
        return pulumi.get(self, "resolver_arn")

    @property
    @pulumi.getter(name="responseMappingTemplate")
    def response_mapping_template(self) -> Optional[builtins.str]:
        """
        The response mapping template.
        """
        return pulumi.get(self, "response_mapping_template")

    @property
    @pulumi.getter
    def runtime(self) -> Optional['outputs.ResolverAppSyncRuntime']:
        """
        Describes a runtime used by an APSYlong resolver or APSYlong function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="syncConfig")
    def sync_config(self) -> Optional['outputs.ResolverSyncConfig']:
        """
        The ``SyncConfig`` for a resolver attached to a versioned data source.
        """
        return pulumi.get(self, "sync_config")


class AwaitableGetResolverResult(GetResolverResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResolverResult(
            caching_config=self.caching_config,
            code=self.code,
            data_source_name=self.data_source_name,
            kind=self.kind,
            max_batch_size=self.max_batch_size,
            metrics_config=self.metrics_config,
            pipeline_config=self.pipeline_config,
            request_mapping_template=self.request_mapping_template,
            resolver_arn=self.resolver_arn,
            response_mapping_template=self.response_mapping_template,
            runtime=self.runtime,
            sync_config=self.sync_config)


def get_resolver(resolver_arn: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResolverResult:
    """
    The ``AWS::AppSync::Resolver`` resource defines the logical GraphQL resolver that you attach to fields in a schema. Request and response templates for resolvers are written in Apache Velocity Template Language (VTL) format. For more information about resolvers, see [Resolver Mapping Template Reference](https://docs.aws.amazon.com/appsync/latest/devguide/resolver-mapping-template-reference.html).
      When you submit an update, CFNLong updates resources based on differences between what you submit and the stack's current template. To cause this resource to be updated you must change a property value for this resource in the CFNshort template. Changing the S3 file content without changing a property value will not result in an update operation.
     See [Update Behaviors of Stack Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html) in the *User Guide*.


    :param builtins.str resolver_arn: ARN of the resolver, such as `arn:aws:appsync:us-east-1:123456789012:apis/graphqlapiid/types/typename/resolvers/resolvername` .
    """
    __args__ = dict()
    __args__['resolverArn'] = resolver_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:appsync:getResolver', __args__, opts=opts, typ=GetResolverResult).value

    return AwaitableGetResolverResult(
        caching_config=pulumi.get(__ret__, 'caching_config'),
        code=pulumi.get(__ret__, 'code'),
        data_source_name=pulumi.get(__ret__, 'data_source_name'),
        kind=pulumi.get(__ret__, 'kind'),
        max_batch_size=pulumi.get(__ret__, 'max_batch_size'),
        metrics_config=pulumi.get(__ret__, 'metrics_config'),
        pipeline_config=pulumi.get(__ret__, 'pipeline_config'),
        request_mapping_template=pulumi.get(__ret__, 'request_mapping_template'),
        resolver_arn=pulumi.get(__ret__, 'resolver_arn'),
        response_mapping_template=pulumi.get(__ret__, 'response_mapping_template'),
        runtime=pulumi.get(__ret__, 'runtime'),
        sync_config=pulumi.get(__ret__, 'sync_config'))
def get_resolver_output(resolver_arn: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResolverResult]:
    """
    The ``AWS::AppSync::Resolver`` resource defines the logical GraphQL resolver that you attach to fields in a schema. Request and response templates for resolvers are written in Apache Velocity Template Language (VTL) format. For more information about resolvers, see [Resolver Mapping Template Reference](https://docs.aws.amazon.com/appsync/latest/devguide/resolver-mapping-template-reference.html).
      When you submit an update, CFNLong updates resources based on differences between what you submit and the stack's current template. To cause this resource to be updated you must change a property value for this resource in the CFNshort template. Changing the S3 file content without changing a property value will not result in an update operation.
     See [Update Behaviors of Stack Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html) in the *User Guide*.


    :param builtins.str resolver_arn: ARN of the resolver, such as `arn:aws:appsync:us-east-1:123456789012:apis/graphqlapiid/types/typename/resolvers/resolvername` .
    """
    __args__ = dict()
    __args__['resolverArn'] = resolver_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:appsync:getResolver', __args__, opts=opts, typ=GetResolverResult)
    return __ret__.apply(lambda __response__: GetResolverResult(
        caching_config=pulumi.get(__response__, 'caching_config'),
        code=pulumi.get(__response__, 'code'),
        data_source_name=pulumi.get(__response__, 'data_source_name'),
        kind=pulumi.get(__response__, 'kind'),
        max_batch_size=pulumi.get(__response__, 'max_batch_size'),
        metrics_config=pulumi.get(__response__, 'metrics_config'),
        pipeline_config=pulumi.get(__response__, 'pipeline_config'),
        request_mapping_template=pulumi.get(__response__, 'request_mapping_template'),
        resolver_arn=pulumi.get(__response__, 'resolver_arn'),
        response_mapping_template=pulumi.get(__response__, 'response_mapping_template'),
        runtime=pulumi.get(__response__, 'runtime'),
        sync_config=pulumi.get(__response__, 'sync_config')))
