# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFunctionConfigurationResult',
    'AwaitableGetFunctionConfigurationResult',
    'get_function_configuration',
    'get_function_configuration_output',
]

@pulumi.output_type
class GetFunctionConfigurationResult:
    def __init__(__self__, code=None, data_source_name=None, description=None, function_arn=None, function_id=None, function_version=None, max_batch_size=None, name=None, request_mapping_template=None, response_mapping_template=None, runtime=None, sync_config=None):
        if code and not isinstance(code, str):
            raise TypeError("Expected argument 'code' to be a str")
        pulumi.set(__self__, "code", code)
        if data_source_name and not isinstance(data_source_name, str):
            raise TypeError("Expected argument 'data_source_name' to be a str")
        pulumi.set(__self__, "data_source_name", data_source_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if function_arn and not isinstance(function_arn, str):
            raise TypeError("Expected argument 'function_arn' to be a str")
        pulumi.set(__self__, "function_arn", function_arn)
        if function_id and not isinstance(function_id, str):
            raise TypeError("Expected argument 'function_id' to be a str")
        pulumi.set(__self__, "function_id", function_id)
        if function_version and not isinstance(function_version, str):
            raise TypeError("Expected argument 'function_version' to be a str")
        pulumi.set(__self__, "function_version", function_version)
        if max_batch_size and not isinstance(max_batch_size, int):
            raise TypeError("Expected argument 'max_batch_size' to be a int")
        pulumi.set(__self__, "max_batch_size", max_batch_size)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if request_mapping_template and not isinstance(request_mapping_template, str):
            raise TypeError("Expected argument 'request_mapping_template' to be a str")
        pulumi.set(__self__, "request_mapping_template", request_mapping_template)
        if response_mapping_template and not isinstance(response_mapping_template, str):
            raise TypeError("Expected argument 'response_mapping_template' to be a str")
        pulumi.set(__self__, "response_mapping_template", response_mapping_template)
        if runtime and not isinstance(runtime, dict):
            raise TypeError("Expected argument 'runtime' to be a dict")
        pulumi.set(__self__, "runtime", runtime)
        if sync_config and not isinstance(sync_config, dict):
            raise TypeError("Expected argument 'sync_config' to be a dict")
        pulumi.set(__self__, "sync_config", sync_config)

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.str]:
        """
        The resolver code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> Optional[builtins.str]:
        """
        The name of data source this function will attach.
        """
        return pulumi.get(self, "data_source_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The function description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[builtins.str]:
        """
        The ARN for the function generated by the service
        """
        return pulumi.get(self, "function_arn")

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[builtins.str]:
        """
        The unique identifier for the function generated by the service
        """
        return pulumi.get(self, "function_id")

    @property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> Optional[builtins.str]:
        """
        The version of the request mapping template. Currently, only the 2018-05-29 version of the template is supported.
        """
        return pulumi.get(self, "function_version")

    @property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a BatchInvoke operation.
        """
        return pulumi.get(self, "max_batch_size")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the function.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="requestMappingTemplate")
    def request_mapping_template(self) -> Optional[builtins.str]:
        """
        The Function request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
        """
        return pulumi.get(self, "request_mapping_template")

    @property
    @pulumi.getter(name="responseMappingTemplate")
    def response_mapping_template(self) -> Optional[builtins.str]:
        """
        The Function response mapping template.
        """
        return pulumi.get(self, "response_mapping_template")

    @property
    @pulumi.getter
    def runtime(self) -> Optional['outputs.FunctionConfigurationAppSyncRuntime']:
        """
        Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="syncConfig")
    def sync_config(self) -> Optional['outputs.FunctionConfigurationSyncConfig']:
        """
        Describes a Sync configuration for a resolver. Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        """
        return pulumi.get(self, "sync_config")


class AwaitableGetFunctionConfigurationResult(GetFunctionConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFunctionConfigurationResult(
            code=self.code,
            data_source_name=self.data_source_name,
            description=self.description,
            function_arn=self.function_arn,
            function_id=self.function_id,
            function_version=self.function_version,
            max_batch_size=self.max_batch_size,
            name=self.name,
            request_mapping_template=self.request_mapping_template,
            response_mapping_template=self.response_mapping_template,
            runtime=self.runtime,
            sync_config=self.sync_config)


def get_function_configuration(function_arn: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFunctionConfigurationResult:
    """
    An example resource schema demonstrating some basic constructs and validation rules.


    :param builtins.str function_arn: The ARN for the function generated by the service
    """
    __args__ = dict()
    __args__['functionArn'] = function_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:appsync:getFunctionConfiguration', __args__, opts=opts, typ=GetFunctionConfigurationResult).value

    return AwaitableGetFunctionConfigurationResult(
        code=pulumi.get(__ret__, 'code'),
        data_source_name=pulumi.get(__ret__, 'data_source_name'),
        description=pulumi.get(__ret__, 'description'),
        function_arn=pulumi.get(__ret__, 'function_arn'),
        function_id=pulumi.get(__ret__, 'function_id'),
        function_version=pulumi.get(__ret__, 'function_version'),
        max_batch_size=pulumi.get(__ret__, 'max_batch_size'),
        name=pulumi.get(__ret__, 'name'),
        request_mapping_template=pulumi.get(__ret__, 'request_mapping_template'),
        response_mapping_template=pulumi.get(__ret__, 'response_mapping_template'),
        runtime=pulumi.get(__ret__, 'runtime'),
        sync_config=pulumi.get(__ret__, 'sync_config'))
def get_function_configuration_output(function_arn: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFunctionConfigurationResult]:
    """
    An example resource schema demonstrating some basic constructs and validation rules.


    :param builtins.str function_arn: The ARN for the function generated by the service
    """
    __args__ = dict()
    __args__['functionArn'] = function_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:appsync:getFunctionConfiguration', __args__, opts=opts, typ=GetFunctionConfigurationResult)
    return __ret__.apply(lambda __response__: GetFunctionConfigurationResult(
        code=pulumi.get(__response__, 'code'),
        data_source_name=pulumi.get(__response__, 'data_source_name'),
        description=pulumi.get(__response__, 'description'),
        function_arn=pulumi.get(__response__, 'function_arn'),
        function_id=pulumi.get(__response__, 'function_id'),
        function_version=pulumi.get(__response__, 'function_version'),
        max_batch_size=pulumi.get(__response__, 'max_batch_size'),
        name=pulumi.get(__response__, 'name'),
        request_mapping_template=pulumi.get(__response__, 'request_mapping_template'),
        response_mapping_template=pulumi.get(__response__, 'response_mapping_template'),
        runtime=pulumi.get(__response__, 'runtime'),
        sync_config=pulumi.get(__response__, 'sync_config')))
