# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetDomainNameResult',
    'AwaitableGetDomainNameResult',
    'get_domain_name',
    'get_domain_name_output',
]

@pulumi.output_type
class GetDomainNameResult:
    def __init__(__self__, app_sync_domain_name=None, description=None, domain_name_arn=None, hosted_zone_id=None, tags=None):
        if app_sync_domain_name and not isinstance(app_sync_domain_name, str):
            raise TypeError("Expected argument 'app_sync_domain_name' to be a str")
        pulumi.set(__self__, "app_sync_domain_name", app_sync_domain_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_name_arn and not isinstance(domain_name_arn, str):
            raise TypeError("Expected argument 'domain_name_arn' to be a str")
        pulumi.set(__self__, "domain_name_arn", domain_name_arn)
        if hosted_zone_id and not isinstance(hosted_zone_id, str):
            raise TypeError("Expected argument 'hosted_zone_id' to be a str")
        pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="appSyncDomainName")
    def app_sync_domain_name(self) -> Optional[builtins.str]:
        """
        The domain name provided by AWS AppSync .
        """
        return pulumi.get(self, "app_sync_domain_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The decription for your domain name.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainNameArn")
    def domain_name_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the Domain Name.
        """
        return pulumi.get(self, "domain_name_arn")

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[builtins.str]:
        """
        The ID of your Amazon Route 53 hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A set of tags (key-value pairs) for this domain name.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDomainNameResult(GetDomainNameResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainNameResult(
            app_sync_domain_name=self.app_sync_domain_name,
            description=self.description,
            domain_name_arn=self.domain_name_arn,
            hosted_zone_id=self.hosted_zone_id,
            tags=self.tags)


def get_domain_name(domain_name: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainNameResult:
    """
    Resource Type definition for AWS::AppSync::DomainName


    :param builtins.str domain_name: The domain name.
    """
    __args__ = dict()
    __args__['domainName'] = domain_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:appsync:getDomainName', __args__, opts=opts, typ=GetDomainNameResult).value

    return AwaitableGetDomainNameResult(
        app_sync_domain_name=pulumi.get(__ret__, 'app_sync_domain_name'),
        description=pulumi.get(__ret__, 'description'),
        domain_name_arn=pulumi.get(__ret__, 'domain_name_arn'),
        hosted_zone_id=pulumi.get(__ret__, 'hosted_zone_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_domain_name_output(domain_name: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainNameResult]:
    """
    Resource Type definition for AWS::AppSync::DomainName


    :param builtins.str domain_name: The domain name.
    """
    __args__ = dict()
    __args__['domainName'] = domain_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:appsync:getDomainName', __args__, opts=opts, typ=GetDomainNameResult)
    return __ret__.apply(lambda __response__: GetDomainNameResult(
        app_sync_domain_name=pulumi.get(__response__, 'app_sync_domain_name'),
        description=pulumi.get(__response__, 'description'),
        domain_name_arn=pulumi.get(__response__, 'domain_name_arn'),
        hosted_zone_id=pulumi.get(__response__, 'hosted_zone_id'),
        tags=pulumi.get(__response__, 'tags')))
