# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetDataSourceResult',
    'AwaitableGetDataSourceResult',
    'get_data_source',
    'get_data_source_output',
]

@pulumi.output_type
class GetDataSourceResult:
    def __init__(__self__, data_source_arn=None, description=None, dynamo_db_config=None, elasticsearch_config=None, event_bridge_config=None, http_config=None, lambda_config=None, metrics_config=None, open_search_service_config=None, relational_database_config=None, service_role_arn=None, type=None):
        if data_source_arn and not isinstance(data_source_arn, str):
            raise TypeError("Expected argument 'data_source_arn' to be a str")
        pulumi.set(__self__, "data_source_arn", data_source_arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dynamo_db_config and not isinstance(dynamo_db_config, dict):
            raise TypeError("Expected argument 'dynamo_db_config' to be a dict")
        pulumi.set(__self__, "dynamo_db_config", dynamo_db_config)
        if elasticsearch_config and not isinstance(elasticsearch_config, dict):
            raise TypeError("Expected argument 'elasticsearch_config' to be a dict")
        pulumi.set(__self__, "elasticsearch_config", elasticsearch_config)
        if event_bridge_config and not isinstance(event_bridge_config, dict):
            raise TypeError("Expected argument 'event_bridge_config' to be a dict")
        pulumi.set(__self__, "event_bridge_config", event_bridge_config)
        if http_config and not isinstance(http_config, dict):
            raise TypeError("Expected argument 'http_config' to be a dict")
        pulumi.set(__self__, "http_config", http_config)
        if lambda_config and not isinstance(lambda_config, dict):
            raise TypeError("Expected argument 'lambda_config' to be a dict")
        pulumi.set(__self__, "lambda_config", lambda_config)
        if metrics_config and not isinstance(metrics_config, str):
            raise TypeError("Expected argument 'metrics_config' to be a str")
        pulumi.set(__self__, "metrics_config", metrics_config)
        if open_search_service_config and not isinstance(open_search_service_config, dict):
            raise TypeError("Expected argument 'open_search_service_config' to be a dict")
        pulumi.set(__self__, "open_search_service_config", open_search_service_config)
        if relational_database_config and not isinstance(relational_database_config, dict):
            raise TypeError("Expected argument 'relational_database_config' to be a dict")
        pulumi.set(__self__, "relational_database_config", relational_database_config)
        if service_role_arn and not isinstance(service_role_arn, str):
            raise TypeError("Expected argument 'service_role_arn' to be a str")
        pulumi.set(__self__, "service_role_arn", service_role_arn)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="dataSourceArn")
    def data_source_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the API key, such as arn:aws:appsync:us-east-1:123456789012:apis/graphqlapiid/datasources/datasourcename.
        """
        return pulumi.get(self, "data_source_arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the data source.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dynamoDbConfig")
    def dynamo_db_config(self) -> Optional['outputs.DataSourceDynamoDbConfig']:
        """
        AWS Region and TableName for an Amazon DynamoDB table in your account.
        """
        return pulumi.get(self, "dynamo_db_config")

    @property
    @pulumi.getter(name="elasticsearchConfig")
    def elasticsearch_config(self) -> Optional['outputs.DataSourceElasticsearchConfig']:
        """
        AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
        As of September 2021, Amazon Elasticsearch Service is Amazon OpenSearch Service. This property is deprecated. For new data sources, use OpenSearchServiceConfig to specify an OpenSearch Service data source.
        """
        return pulumi.get(self, "elasticsearch_config")

    @property
    @pulumi.getter(name="eventBridgeConfig")
    def event_bridge_config(self) -> Optional['outputs.DataSourceEventBridgeConfig']:
        """
        ARN for the EventBridge bus.
        """
        return pulumi.get(self, "event_bridge_config")

    @property
    @pulumi.getter(name="httpConfig")
    def http_config(self) -> Optional['outputs.DataSourceHttpConfig']:
        """
        Endpoints for an HTTP data source.
        """
        return pulumi.get(self, "http_config")

    @property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> Optional['outputs.DataSourceLambdaConfig']:
        """
        An ARN of a Lambda function in valid ARN format. This can be the ARN of a Lambda function that exists in the current account or in another account.
        """
        return pulumi.get(self, "lambda_config")

    @property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> Optional['DataSourceMetricsConfig']:
        """
        Enables or disables enhanced data source metrics for specified data sources. Note that `MetricsConfig` won't be used unless the `dataSourceLevelMetricsBehavior` value is set to `PER_DATA_SOURCE_METRICS` . If the `dataSourceLevelMetricsBehavior` is set to `FULL_REQUEST_DATA_SOURCE_METRICS` instead, `MetricsConfig` will be ignored. However, you can still set its value.

        `MetricsConfig` can be `ENABLED` or `DISABLED` .
        """
        return pulumi.get(self, "metrics_config")

    @property
    @pulumi.getter(name="openSearchServiceConfig")
    def open_search_service_config(self) -> Optional['outputs.DataSourceOpenSearchServiceConfig']:
        """
        AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
        """
        return pulumi.get(self, "open_search_service_config")

    @property
    @pulumi.getter(name="relationalDatabaseConfig")
    def relational_database_config(self) -> Optional['outputs.DataSourceRelationalDatabaseConfig']:
        """
        Relational Database configuration of the relational database data source.
        """
        return pulumi.get(self, "relational_database_config")

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> Optional[builtins.str]:
        """
        The AWS Identity and Access Management service role ARN for the data source. The system assumes this role when accessing the data source.
        """
        return pulumi.get(self, "service_role_arn")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of the data source.
        """
        return pulumi.get(self, "type")


class AwaitableGetDataSourceResult(GetDataSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataSourceResult(
            data_source_arn=self.data_source_arn,
            description=self.description,
            dynamo_db_config=self.dynamo_db_config,
            elasticsearch_config=self.elasticsearch_config,
            event_bridge_config=self.event_bridge_config,
            http_config=self.http_config,
            lambda_config=self.lambda_config,
            metrics_config=self.metrics_config,
            open_search_service_config=self.open_search_service_config,
            relational_database_config=self.relational_database_config,
            service_role_arn=self.service_role_arn,
            type=self.type)


def get_data_source(data_source_arn: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataSourceResult:
    """
    Resource Type definition for AWS::AppSync::DataSource


    :param builtins.str data_source_arn: The Amazon Resource Name (ARN) of the API key, such as arn:aws:appsync:us-east-1:123456789012:apis/graphqlapiid/datasources/datasourcename.
    """
    __args__ = dict()
    __args__['dataSourceArn'] = data_source_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:appsync:getDataSource', __args__, opts=opts, typ=GetDataSourceResult).value

    return AwaitableGetDataSourceResult(
        data_source_arn=pulumi.get(__ret__, 'data_source_arn'),
        description=pulumi.get(__ret__, 'description'),
        dynamo_db_config=pulumi.get(__ret__, 'dynamo_db_config'),
        elasticsearch_config=pulumi.get(__ret__, 'elasticsearch_config'),
        event_bridge_config=pulumi.get(__ret__, 'event_bridge_config'),
        http_config=pulumi.get(__ret__, 'http_config'),
        lambda_config=pulumi.get(__ret__, 'lambda_config'),
        metrics_config=pulumi.get(__ret__, 'metrics_config'),
        open_search_service_config=pulumi.get(__ret__, 'open_search_service_config'),
        relational_database_config=pulumi.get(__ret__, 'relational_database_config'),
        service_role_arn=pulumi.get(__ret__, 'service_role_arn'),
        type=pulumi.get(__ret__, 'type'))
def get_data_source_output(data_source_arn: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataSourceResult]:
    """
    Resource Type definition for AWS::AppSync::DataSource


    :param builtins.str data_source_arn: The Amazon Resource Name (ARN) of the API key, such as arn:aws:appsync:us-east-1:123456789012:apis/graphqlapiid/datasources/datasourcename.
    """
    __args__ = dict()
    __args__['dataSourceArn'] = data_source_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:appsync:getDataSource', __args__, opts=opts, typ=GetDataSourceResult)
    return __ret__.apply(lambda __response__: GetDataSourceResult(
        data_source_arn=pulumi.get(__response__, 'data_source_arn'),
        description=pulumi.get(__response__, 'description'),
        dynamo_db_config=pulumi.get(__response__, 'dynamo_db_config'),
        elasticsearch_config=pulumi.get(__response__, 'elasticsearch_config'),
        event_bridge_config=pulumi.get(__response__, 'event_bridge_config'),
        http_config=pulumi.get(__response__, 'http_config'),
        lambda_config=pulumi.get(__response__, 'lambda_config'),
        metrics_config=pulumi.get(__response__, 'metrics_config'),
        open_search_service_config=pulumi.get(__response__, 'open_search_service_config'),
        relational_database_config=pulumi.get(__response__, 'relational_database_config'),
        service_role_arn=pulumi.get(__response__, 'service_role_arn'),
        type=pulumi.get(__response__, 'type')))
