# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['DataSourceArgs', 'DataSource']

@pulumi.input_type
class DataSourceArgs:
    def __init__(__self__, *,
                 api_id: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dynamo_db_config: Optional[pulumi.Input['DataSourceDynamoDbConfigArgs']] = None,
                 elasticsearch_config: Optional[pulumi.Input['DataSourceElasticsearchConfigArgs']] = None,
                 event_bridge_config: Optional[pulumi.Input['DataSourceEventBridgeConfigArgs']] = None,
                 http_config: Optional[pulumi.Input['DataSourceHttpConfigArgs']] = None,
                 lambda_config: Optional[pulumi.Input['DataSourceLambdaConfigArgs']] = None,
                 metrics_config: Optional[pulumi.Input['DataSourceMetricsConfig']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 open_search_service_config: Optional[pulumi.Input['DataSourceOpenSearchServiceConfigArgs']] = None,
                 relational_database_config: Optional[pulumi.Input['DataSourceRelationalDatabaseConfigArgs']] = None,
                 service_role_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DataSource resource.
        :param pulumi.Input[builtins.str] api_id: Unique AWS AppSync GraphQL API identifier where this data source will be created.
        :param pulumi.Input[builtins.str] type: The type of the data source.
        :param pulumi.Input[builtins.str] description: The description of the data source.
        :param pulumi.Input['DataSourceDynamoDbConfigArgs'] dynamo_db_config: AWS Region and TableName for an Amazon DynamoDB table in your account.
        :param pulumi.Input['DataSourceElasticsearchConfigArgs'] elasticsearch_config: AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
               As of September 2021, Amazon Elasticsearch Service is Amazon OpenSearch Service. This property is deprecated. For new data sources, use OpenSearchServiceConfig to specify an OpenSearch Service data source.
        :param pulumi.Input['DataSourceEventBridgeConfigArgs'] event_bridge_config: ARN for the EventBridge bus.
        :param pulumi.Input['DataSourceHttpConfigArgs'] http_config: Endpoints for an HTTP data source.
        :param pulumi.Input['DataSourceLambdaConfigArgs'] lambda_config: An ARN of a Lambda function in valid ARN format. This can be the ARN of a Lambda function that exists in the current account or in another account.
        :param pulumi.Input['DataSourceMetricsConfig'] metrics_config: Enables or disables enhanced data source metrics for specified data sources. Note that `MetricsConfig` won't be used unless the `dataSourceLevelMetricsBehavior` value is set to `PER_DATA_SOURCE_METRICS` . If the `dataSourceLevelMetricsBehavior` is set to `FULL_REQUEST_DATA_SOURCE_METRICS` instead, `MetricsConfig` will be ignored. However, you can still set its value.
               
               `MetricsConfig` can be `ENABLED` or `DISABLED` .
        :param pulumi.Input[builtins.str] name: Friendly name for you to identify your AppSync data source after creation.
        :param pulumi.Input['DataSourceOpenSearchServiceConfigArgs'] open_search_service_config: AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
        :param pulumi.Input['DataSourceRelationalDatabaseConfigArgs'] relational_database_config: Relational Database configuration of the relational database data source.
        :param pulumi.Input[builtins.str] service_role_arn: The AWS Identity and Access Management service role ARN for the data source. The system assumes this role when accessing the data source.
        """
        pulumi.set(__self__, "api_id", api_id)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamo_db_config is not None:
            pulumi.set(__self__, "dynamo_db_config", dynamo_db_config)
        if elasticsearch_config is not None:
            pulumi.set(__self__, "elasticsearch_config", elasticsearch_config)
        if event_bridge_config is not None:
            pulumi.set(__self__, "event_bridge_config", event_bridge_config)
        if http_config is not None:
            pulumi.set(__self__, "http_config", http_config)
        if lambda_config is not None:
            pulumi.set(__self__, "lambda_config", lambda_config)
        if metrics_config is not None:
            pulumi.set(__self__, "metrics_config", metrics_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_search_service_config is not None:
            pulumi.set(__self__, "open_search_service_config", open_search_service_config)
        if relational_database_config is not None:
            pulumi.set(__self__, "relational_database_config", relational_database_config)
        if service_role_arn is not None:
            pulumi.set(__self__, "service_role_arn", service_role_arn)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Input[builtins.str]:
        """
        Unique AWS AppSync GraphQL API identifier where this data source will be created.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the data source.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the data source.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dynamoDbConfig")
    def dynamo_db_config(self) -> Optional[pulumi.Input['DataSourceDynamoDbConfigArgs']]:
        """
        AWS Region and TableName for an Amazon DynamoDB table in your account.
        """
        return pulumi.get(self, "dynamo_db_config")

    @dynamo_db_config.setter
    def dynamo_db_config(self, value: Optional[pulumi.Input['DataSourceDynamoDbConfigArgs']]):
        pulumi.set(self, "dynamo_db_config", value)

    @property
    @pulumi.getter(name="elasticsearchConfig")
    def elasticsearch_config(self) -> Optional[pulumi.Input['DataSourceElasticsearchConfigArgs']]:
        """
        AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
        As of September 2021, Amazon Elasticsearch Service is Amazon OpenSearch Service. This property is deprecated. For new data sources, use OpenSearchServiceConfig to specify an OpenSearch Service data source.
        """
        return pulumi.get(self, "elasticsearch_config")

    @elasticsearch_config.setter
    def elasticsearch_config(self, value: Optional[pulumi.Input['DataSourceElasticsearchConfigArgs']]):
        pulumi.set(self, "elasticsearch_config", value)

    @property
    @pulumi.getter(name="eventBridgeConfig")
    def event_bridge_config(self) -> Optional[pulumi.Input['DataSourceEventBridgeConfigArgs']]:
        """
        ARN for the EventBridge bus.
        """
        return pulumi.get(self, "event_bridge_config")

    @event_bridge_config.setter
    def event_bridge_config(self, value: Optional[pulumi.Input['DataSourceEventBridgeConfigArgs']]):
        pulumi.set(self, "event_bridge_config", value)

    @property
    @pulumi.getter(name="httpConfig")
    def http_config(self) -> Optional[pulumi.Input['DataSourceHttpConfigArgs']]:
        """
        Endpoints for an HTTP data source.
        """
        return pulumi.get(self, "http_config")

    @http_config.setter
    def http_config(self, value: Optional[pulumi.Input['DataSourceHttpConfigArgs']]):
        pulumi.set(self, "http_config", value)

    @property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> Optional[pulumi.Input['DataSourceLambdaConfigArgs']]:
        """
        An ARN of a Lambda function in valid ARN format. This can be the ARN of a Lambda function that exists in the current account or in another account.
        """
        return pulumi.get(self, "lambda_config")

    @lambda_config.setter
    def lambda_config(self, value: Optional[pulumi.Input['DataSourceLambdaConfigArgs']]):
        pulumi.set(self, "lambda_config", value)

    @property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> Optional[pulumi.Input['DataSourceMetricsConfig']]:
        """
        Enables or disables enhanced data source metrics for specified data sources. Note that `MetricsConfig` won't be used unless the `dataSourceLevelMetricsBehavior` value is set to `PER_DATA_SOURCE_METRICS` . If the `dataSourceLevelMetricsBehavior` is set to `FULL_REQUEST_DATA_SOURCE_METRICS` instead, `MetricsConfig` will be ignored. However, you can still set its value.

        `MetricsConfig` can be `ENABLED` or `DISABLED` .
        """
        return pulumi.get(self, "metrics_config")

    @metrics_config.setter
    def metrics_config(self, value: Optional[pulumi.Input['DataSourceMetricsConfig']]):
        pulumi.set(self, "metrics_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Friendly name for you to identify your AppSync data source after creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="openSearchServiceConfig")
    def open_search_service_config(self) -> Optional[pulumi.Input['DataSourceOpenSearchServiceConfigArgs']]:
        """
        AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
        """
        return pulumi.get(self, "open_search_service_config")

    @open_search_service_config.setter
    def open_search_service_config(self, value: Optional[pulumi.Input['DataSourceOpenSearchServiceConfigArgs']]):
        pulumi.set(self, "open_search_service_config", value)

    @property
    @pulumi.getter(name="relationalDatabaseConfig")
    def relational_database_config(self) -> Optional[pulumi.Input['DataSourceRelationalDatabaseConfigArgs']]:
        """
        Relational Database configuration of the relational database data source.
        """
        return pulumi.get(self, "relational_database_config")

    @relational_database_config.setter
    def relational_database_config(self, value: Optional[pulumi.Input['DataSourceRelationalDatabaseConfigArgs']]):
        pulumi.set(self, "relational_database_config", value)

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS Identity and Access Management service role ARN for the data source. The system assumes this role when accessing the data source.
        """
        return pulumi.get(self, "service_role_arn")

    @service_role_arn.setter
    def service_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_role_arn", value)


@pulumi.type_token("aws-native:appsync:DataSource")
class DataSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dynamo_db_config: Optional[pulumi.Input[Union['DataSourceDynamoDbConfigArgs', 'DataSourceDynamoDbConfigArgsDict']]] = None,
                 elasticsearch_config: Optional[pulumi.Input[Union['DataSourceElasticsearchConfigArgs', 'DataSourceElasticsearchConfigArgsDict']]] = None,
                 event_bridge_config: Optional[pulumi.Input[Union['DataSourceEventBridgeConfigArgs', 'DataSourceEventBridgeConfigArgsDict']]] = None,
                 http_config: Optional[pulumi.Input[Union['DataSourceHttpConfigArgs', 'DataSourceHttpConfigArgsDict']]] = None,
                 lambda_config: Optional[pulumi.Input[Union['DataSourceLambdaConfigArgs', 'DataSourceLambdaConfigArgsDict']]] = None,
                 metrics_config: Optional[pulumi.Input['DataSourceMetricsConfig']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 open_search_service_config: Optional[pulumi.Input[Union['DataSourceOpenSearchServiceConfigArgs', 'DataSourceOpenSearchServiceConfigArgsDict']]] = None,
                 relational_database_config: Optional[pulumi.Input[Union['DataSourceRelationalDatabaseConfigArgs', 'DataSourceRelationalDatabaseConfigArgsDict']]] = None,
                 service_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::AppSync::DataSource

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        graph_ql_api_id = config.require("graphQlApiId")
        data_source_name = config.require("dataSourceName")
        data_source_description = config.require("dataSourceDescription")
        service_role_arn = config.require("serviceRoleArn")
        lambda_function_arn = config.require("lambdaFunctionArn")
        data_source = aws_native.appsync.DataSource("dataSource",
            api_id=graph_ql_api_id,
            name=data_source_name,
            description=data_source_description,
            type="AWS_LAMBDA",
            service_role_arn=service_role_arn,
            lambda_config={
                "lambda_function_arn": lambda_function_arn,
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        graph_ql_api_id = config.require("graphQlApiId")
        data_source_name = config.require("dataSourceName")
        data_source_description = config.require("dataSourceDescription")
        service_role_arn = config.require("serviceRoleArn")
        lambda_function_arn = config.require("lambdaFunctionArn")
        data_source = aws_native.appsync.DataSource("dataSource",
            api_id=graph_ql_api_id,
            name=data_source_name,
            description=data_source_description,
            type="AWS_LAMBDA",
            service_role_arn=service_role_arn,
            lambda_config={
                "lambda_function_arn": lambda_function_arn,
            })

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_id: Unique AWS AppSync GraphQL API identifier where this data source will be created.
        :param pulumi.Input[builtins.str] description: The description of the data source.
        :param pulumi.Input[Union['DataSourceDynamoDbConfigArgs', 'DataSourceDynamoDbConfigArgsDict']] dynamo_db_config: AWS Region and TableName for an Amazon DynamoDB table in your account.
        :param pulumi.Input[Union['DataSourceElasticsearchConfigArgs', 'DataSourceElasticsearchConfigArgsDict']] elasticsearch_config: AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
               As of September 2021, Amazon Elasticsearch Service is Amazon OpenSearch Service. This property is deprecated. For new data sources, use OpenSearchServiceConfig to specify an OpenSearch Service data source.
        :param pulumi.Input[Union['DataSourceEventBridgeConfigArgs', 'DataSourceEventBridgeConfigArgsDict']] event_bridge_config: ARN for the EventBridge bus.
        :param pulumi.Input[Union['DataSourceHttpConfigArgs', 'DataSourceHttpConfigArgsDict']] http_config: Endpoints for an HTTP data source.
        :param pulumi.Input[Union['DataSourceLambdaConfigArgs', 'DataSourceLambdaConfigArgsDict']] lambda_config: An ARN of a Lambda function in valid ARN format. This can be the ARN of a Lambda function that exists in the current account or in another account.
        :param pulumi.Input['DataSourceMetricsConfig'] metrics_config: Enables or disables enhanced data source metrics for specified data sources. Note that `MetricsConfig` won't be used unless the `dataSourceLevelMetricsBehavior` value is set to `PER_DATA_SOURCE_METRICS` . If the `dataSourceLevelMetricsBehavior` is set to `FULL_REQUEST_DATA_SOURCE_METRICS` instead, `MetricsConfig` will be ignored. However, you can still set its value.
               
               `MetricsConfig` can be `ENABLED` or `DISABLED` .
        :param pulumi.Input[builtins.str] name: Friendly name for you to identify your AppSync data source after creation.
        :param pulumi.Input[Union['DataSourceOpenSearchServiceConfigArgs', 'DataSourceOpenSearchServiceConfigArgsDict']] open_search_service_config: AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
        :param pulumi.Input[Union['DataSourceRelationalDatabaseConfigArgs', 'DataSourceRelationalDatabaseConfigArgsDict']] relational_database_config: Relational Database configuration of the relational database data source.
        :param pulumi.Input[builtins.str] service_role_arn: The AWS Identity and Access Management service role ARN for the data source. The system assumes this role when accessing the data source.
        :param pulumi.Input[builtins.str] type: The type of the data source.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::AppSync::DataSource

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        graph_ql_api_id = config.require("graphQlApiId")
        data_source_name = config.require("dataSourceName")
        data_source_description = config.require("dataSourceDescription")
        service_role_arn = config.require("serviceRoleArn")
        lambda_function_arn = config.require("lambdaFunctionArn")
        data_source = aws_native.appsync.DataSource("dataSource",
            api_id=graph_ql_api_id,
            name=data_source_name,
            description=data_source_description,
            type="AWS_LAMBDA",
            service_role_arn=service_role_arn,
            lambda_config={
                "lambda_function_arn": lambda_function_arn,
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        graph_ql_api_id = config.require("graphQlApiId")
        data_source_name = config.require("dataSourceName")
        data_source_description = config.require("dataSourceDescription")
        service_role_arn = config.require("serviceRoleArn")
        lambda_function_arn = config.require("lambdaFunctionArn")
        data_source = aws_native.appsync.DataSource("dataSource",
            api_id=graph_ql_api_id,
            name=data_source_name,
            description=data_source_description,
            type="AWS_LAMBDA",
            service_role_arn=service_role_arn,
            lambda_config={
                "lambda_function_arn": lambda_function_arn,
            })

        ```

        :param str resource_name: The name of the resource.
        :param DataSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dynamo_db_config: Optional[pulumi.Input[Union['DataSourceDynamoDbConfigArgs', 'DataSourceDynamoDbConfigArgsDict']]] = None,
                 elasticsearch_config: Optional[pulumi.Input[Union['DataSourceElasticsearchConfigArgs', 'DataSourceElasticsearchConfigArgsDict']]] = None,
                 event_bridge_config: Optional[pulumi.Input[Union['DataSourceEventBridgeConfigArgs', 'DataSourceEventBridgeConfigArgsDict']]] = None,
                 http_config: Optional[pulumi.Input[Union['DataSourceHttpConfigArgs', 'DataSourceHttpConfigArgsDict']]] = None,
                 lambda_config: Optional[pulumi.Input[Union['DataSourceLambdaConfigArgs', 'DataSourceLambdaConfigArgsDict']]] = None,
                 metrics_config: Optional[pulumi.Input['DataSourceMetricsConfig']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 open_search_service_config: Optional[pulumi.Input[Union['DataSourceOpenSearchServiceConfigArgs', 'DataSourceOpenSearchServiceConfigArgsDict']]] = None,
                 relational_database_config: Optional[pulumi.Input[Union['DataSourceRelationalDatabaseConfigArgs', 'DataSourceRelationalDatabaseConfigArgsDict']]] = None,
                 service_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataSourceArgs.__new__(DataSourceArgs)

            if api_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_id'")
            __props__.__dict__["api_id"] = api_id
            __props__.__dict__["description"] = description
            __props__.__dict__["dynamo_db_config"] = dynamo_db_config
            __props__.__dict__["elasticsearch_config"] = elasticsearch_config
            __props__.__dict__["event_bridge_config"] = event_bridge_config
            __props__.__dict__["http_config"] = http_config
            __props__.__dict__["lambda_config"] = lambda_config
            __props__.__dict__["metrics_config"] = metrics_config
            __props__.__dict__["name"] = name
            __props__.__dict__["open_search_service_config"] = open_search_service_config
            __props__.__dict__["relational_database_config"] = relational_database_config
            __props__.__dict__["service_role_arn"] = service_role_arn
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["data_source_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["apiId", "name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DataSource, __self__).__init__(
            'aws-native:appsync:DataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DataSource':
        """
        Get an existing DataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DataSourceArgs.__new__(DataSourceArgs)

        __props__.__dict__["api_id"] = None
        __props__.__dict__["data_source_arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["dynamo_db_config"] = None
        __props__.__dict__["elasticsearch_config"] = None
        __props__.__dict__["event_bridge_config"] = None
        __props__.__dict__["http_config"] = None
        __props__.__dict__["lambda_config"] = None
        __props__.__dict__["metrics_config"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["open_search_service_config"] = None
        __props__.__dict__["relational_database_config"] = None
        __props__.__dict__["service_role_arn"] = None
        __props__.__dict__["type"] = None
        return DataSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique AWS AppSync GraphQL API identifier where this data source will be created.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter(name="dataSourceArn")
    def data_source_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the API key, such as arn:aws:appsync:us-east-1:123456789012:apis/graphqlapiid/datasources/datasourcename.
        """
        return pulumi.get(self, "data_source_arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the data source.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dynamoDbConfig")
    def dynamo_db_config(self) -> pulumi.Output[Optional['outputs.DataSourceDynamoDbConfig']]:
        """
        AWS Region and TableName for an Amazon DynamoDB table in your account.
        """
        return pulumi.get(self, "dynamo_db_config")

    @property
    @pulumi.getter(name="elasticsearchConfig")
    def elasticsearch_config(self) -> pulumi.Output[Optional['outputs.DataSourceElasticsearchConfig']]:
        """
        AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
        As of September 2021, Amazon Elasticsearch Service is Amazon OpenSearch Service. This property is deprecated. For new data sources, use OpenSearchServiceConfig to specify an OpenSearch Service data source.
        """
        return pulumi.get(self, "elasticsearch_config")

    @property
    @pulumi.getter(name="eventBridgeConfig")
    def event_bridge_config(self) -> pulumi.Output[Optional['outputs.DataSourceEventBridgeConfig']]:
        """
        ARN for the EventBridge bus.
        """
        return pulumi.get(self, "event_bridge_config")

    @property
    @pulumi.getter(name="httpConfig")
    def http_config(self) -> pulumi.Output[Optional['outputs.DataSourceHttpConfig']]:
        """
        Endpoints for an HTTP data source.
        """
        return pulumi.get(self, "http_config")

    @property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> pulumi.Output[Optional['outputs.DataSourceLambdaConfig']]:
        """
        An ARN of a Lambda function in valid ARN format. This can be the ARN of a Lambda function that exists in the current account or in another account.
        """
        return pulumi.get(self, "lambda_config")

    @property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> pulumi.Output[Optional['DataSourceMetricsConfig']]:
        """
        Enables or disables enhanced data source metrics for specified data sources. Note that `MetricsConfig` won't be used unless the `dataSourceLevelMetricsBehavior` value is set to `PER_DATA_SOURCE_METRICS` . If the `dataSourceLevelMetricsBehavior` is set to `FULL_REQUEST_DATA_SOURCE_METRICS` instead, `MetricsConfig` will be ignored. However, you can still set its value.

        `MetricsConfig` can be `ENABLED` or `DISABLED` .
        """
        return pulumi.get(self, "metrics_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Friendly name for you to identify your AppSync data source after creation.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="openSearchServiceConfig")
    def open_search_service_config(self) -> pulumi.Output[Optional['outputs.DataSourceOpenSearchServiceConfig']]:
        """
        AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
        """
        return pulumi.get(self, "open_search_service_config")

    @property
    @pulumi.getter(name="relationalDatabaseConfig")
    def relational_database_config(self) -> pulumi.Output[Optional['outputs.DataSourceRelationalDatabaseConfig']]:
        """
        Relational Database configuration of the relational database data source.
        """
        return pulumi.get(self, "relational_database_config")

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS Identity and Access Management service role ARN for the data source. The system assumes this role when accessing the data source.
        """
        return pulumi.get(self, "service_role_arn")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the data source.
        """
        return pulumi.get(self, "type")

