# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ApiArgs', 'Api']

@pulumi.input_type
class ApiArgs:
    def __init__(__self__, *,
                 event_config: Optional[pulumi.Input['ApiEventConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner_contact: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Api resource.
        :param pulumi.Input['ApiEventConfigArgs'] event_config: Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API.
        :param pulumi.Input[builtins.str] name: The name of the `Api` .
        :param pulumi.Input[builtins.str] owner_contact: The owner contact information for an API resource.
               
               This field accepts any string input with a length of 0 - 256 characters.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A set of tags (key-value pairs) for this API.
        """
        if event_config is not None:
            pulumi.set(__self__, "event_config", event_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_contact is not None:
            pulumi.set(__self__, "owner_contact", owner_contact)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="eventConfig")
    def event_config(self) -> Optional[pulumi.Input['ApiEventConfigArgs']]:
        """
        Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API.
        """
        return pulumi.get(self, "event_config")

    @event_config.setter
    def event_config(self, value: Optional[pulumi.Input['ApiEventConfigArgs']]):
        pulumi.set(self, "event_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the `Api` .
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownerContact")
    def owner_contact(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The owner contact information for an API resource.

        This field accepts any string input with a length of 0 - 256 characters.
        """
        return pulumi.get(self, "owner_contact")

    @owner_contact.setter
    def owner_contact(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_contact", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A set of tags (key-value pairs) for this API.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:appsync:Api")
class Api(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_config: Optional[pulumi.Input[Union['ApiEventConfigArgs', 'ApiEventConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner_contact: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for AppSync Api

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ApiEventConfigArgs', 'ApiEventConfigArgsDict']] event_config: Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API.
        :param pulumi.Input[builtins.str] name: The name of the `Api` .
        :param pulumi.Input[builtins.str] owner_contact: The owner contact information for an API resource.
               
               This field accepts any string input with a length of 0 - 256 characters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A set of tags (key-value pairs) for this API.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ApiArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AppSync Api

        :param str resource_name: The name of the resource.
        :param ApiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_config: Optional[pulumi.Input[Union['ApiEventConfigArgs', 'ApiEventConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner_contact: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiArgs.__new__(ApiArgs)

            __props__.__dict__["event_config"] = event_config
            __props__.__dict__["name"] = name
            __props__.__dict__["owner_contact"] = owner_contact
            __props__.__dict__["tags"] = tags
            __props__.__dict__["api_arn"] = None
            __props__.__dict__["api_id"] = None
            __props__.__dict__["dns"] = None
        super(Api, __self__).__init__(
            'aws-native:appsync:Api',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Api':
        """
        Get an existing Api resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ApiArgs.__new__(ApiArgs)

        __props__.__dict__["api_arn"] = None
        __props__.__dict__["api_id"] = None
        __props__.__dict__["dns"] = None
        __props__.__dict__["event_config"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["owner_contact"] = None
        __props__.__dict__["tags"] = None
        return Api(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiArn")
    def api_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AppSync Api
        """
        return pulumi.get(self, "api_arn")

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for the AppSync Api generated by the service
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter
    def dns(self) -> pulumi.Output['outputs.ApiDnsMap']:
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter(name="eventConfig")
    def event_config(self) -> pulumi.Output[Optional['outputs.ApiEventConfig']]:
        """
        Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API.
        """
        return pulumi.get(self, "event_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the `Api` .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerContact")
    def owner_contact(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The owner contact information for an API resource.

        This field accepts any string input with a length of 0 - 256 characters.
        """
        return pulumi.get(self, "owner_contact")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A set of tags (key-value pairs) for this API.
        """
        return pulumi.get(self, "tags")

