# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ApiAuthModeArgs',
    'ApiAuthModeArgsDict',
    'ApiAuthProviderArgs',
    'ApiAuthProviderArgsDict',
    'ApiCognitoConfigArgs',
    'ApiCognitoConfigArgsDict',
    'ApiEventConfigArgs',
    'ApiEventConfigArgsDict',
    'ApiEventLogConfigArgs',
    'ApiEventLogConfigArgsDict',
    'ApiLambdaAuthorizerConfigArgs',
    'ApiLambdaAuthorizerConfigArgsDict',
    'ApiOpenIdConnectConfigArgs',
    'ApiOpenIdConnectConfigArgsDict',
    'ChannelNamespaceAuthModeArgs',
    'ChannelNamespaceAuthModeArgsDict',
    'ChannelNamespaceHandlerConfigsArgs',
    'ChannelNamespaceHandlerConfigsArgsDict',
    'ChannelNamespaceHandlerConfigArgs',
    'ChannelNamespaceHandlerConfigArgsDict',
    'ChannelNamespaceIntegrationArgs',
    'ChannelNamespaceIntegrationArgsDict',
    'ChannelNamespaceLambdaConfigArgs',
    'ChannelNamespaceLambdaConfigArgsDict',
    'DataSourceAuthorizationConfigArgs',
    'DataSourceAuthorizationConfigArgsDict',
    'DataSourceAwsIamConfigArgs',
    'DataSourceAwsIamConfigArgsDict',
    'DataSourceDeltaSyncConfigArgs',
    'DataSourceDeltaSyncConfigArgsDict',
    'DataSourceDynamoDbConfigArgs',
    'DataSourceDynamoDbConfigArgsDict',
    'DataSourceElasticsearchConfigArgs',
    'DataSourceElasticsearchConfigArgsDict',
    'DataSourceEventBridgeConfigArgs',
    'DataSourceEventBridgeConfigArgsDict',
    'DataSourceHttpConfigArgs',
    'DataSourceHttpConfigArgsDict',
    'DataSourceLambdaConfigArgs',
    'DataSourceLambdaConfigArgsDict',
    'DataSourceOpenSearchServiceConfigArgs',
    'DataSourceOpenSearchServiceConfigArgsDict',
    'DataSourceRdsHttpEndpointConfigArgs',
    'DataSourceRdsHttpEndpointConfigArgsDict',
    'DataSourceRelationalDatabaseConfigArgs',
    'DataSourceRelationalDatabaseConfigArgsDict',
    'FunctionConfigurationAppSyncRuntimeArgs',
    'FunctionConfigurationAppSyncRuntimeArgsDict',
    'FunctionConfigurationLambdaConflictHandlerConfigArgs',
    'FunctionConfigurationLambdaConflictHandlerConfigArgsDict',
    'FunctionConfigurationSyncConfigArgs',
    'FunctionConfigurationSyncConfigArgsDict',
    'GraphQlApiAdditionalAuthenticationProviderArgs',
    'GraphQlApiAdditionalAuthenticationProviderArgsDict',
    'GraphQlApiCognitoUserPoolConfigArgs',
    'GraphQlApiCognitoUserPoolConfigArgsDict',
    'GraphQlApiEnhancedMetricsConfigArgs',
    'GraphQlApiEnhancedMetricsConfigArgsDict',
    'GraphQlApiLambdaAuthorizerConfigArgs',
    'GraphQlApiLambdaAuthorizerConfigArgsDict',
    'GraphQlApiLogConfigArgs',
    'GraphQlApiLogConfigArgsDict',
    'GraphQlApiOpenIdConnectConfigArgs',
    'GraphQlApiOpenIdConnectConfigArgsDict',
    'GraphQlApiUserPoolConfigArgs',
    'GraphQlApiUserPoolConfigArgsDict',
    'ResolverAppSyncRuntimeArgs',
    'ResolverAppSyncRuntimeArgsDict',
    'ResolverCachingConfigArgs',
    'ResolverCachingConfigArgsDict',
    'ResolverLambdaConflictHandlerConfigArgs',
    'ResolverLambdaConflictHandlerConfigArgsDict',
    'ResolverPipelineConfigArgs',
    'ResolverPipelineConfigArgsDict',
    'ResolverSyncConfigArgs',
    'ResolverSyncConfigArgsDict',
    'SourceApiAssociationConfigArgs',
    'SourceApiAssociationConfigArgsDict',
]

MYPY = False

if not MYPY:
    class ApiAuthModeArgsDict(TypedDict):
        """
        An auth mode.
        """
        auth_type: NotRequired[pulumi.Input['ApiAuthenticationType']]
elif False:
    ApiAuthModeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApiAuthModeArgs:
    def __init__(__self__, *,
                 auth_type: Optional[pulumi.Input['ApiAuthenticationType']] = None):
        """
        An auth mode.
        """
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input['ApiAuthenticationType']]:
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input['ApiAuthenticationType']]):
        pulumi.set(self, "auth_type", value)


if not MYPY:
    class ApiAuthProviderArgsDict(TypedDict):
        """
        An auth provider for the AppSync API.
        """
        auth_type: pulumi.Input['ApiAuthenticationType']
        cognito_config: NotRequired[pulumi.Input['ApiCognitoConfigArgsDict']]
        lambda_authorizer_config: NotRequired[pulumi.Input['ApiLambdaAuthorizerConfigArgsDict']]
        open_id_connect_config: NotRequired[pulumi.Input['ApiOpenIdConnectConfigArgsDict']]
elif False:
    ApiAuthProviderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApiAuthProviderArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input['ApiAuthenticationType'],
                 cognito_config: Optional[pulumi.Input['ApiCognitoConfigArgs']] = None,
                 lambda_authorizer_config: Optional[pulumi.Input['ApiLambdaAuthorizerConfigArgs']] = None,
                 open_id_connect_config: Optional[pulumi.Input['ApiOpenIdConnectConfigArgs']] = None):
        """
        An auth provider for the AppSync API.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        if cognito_config is not None:
            pulumi.set(__self__, "cognito_config", cognito_config)
        if lambda_authorizer_config is not None:
            pulumi.set(__self__, "lambda_authorizer_config", lambda_authorizer_config)
        if open_id_connect_config is not None:
            pulumi.set(__self__, "open_id_connect_config", open_id_connect_config)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input['ApiAuthenticationType']:
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input['ApiAuthenticationType']):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="cognitoConfig")
    def cognito_config(self) -> Optional[pulumi.Input['ApiCognitoConfigArgs']]:
        return pulumi.get(self, "cognito_config")

    @cognito_config.setter
    def cognito_config(self, value: Optional[pulumi.Input['ApiCognitoConfigArgs']]):
        pulumi.set(self, "cognito_config", value)

    @property
    @pulumi.getter(name="lambdaAuthorizerConfig")
    def lambda_authorizer_config(self) -> Optional[pulumi.Input['ApiLambdaAuthorizerConfigArgs']]:
        return pulumi.get(self, "lambda_authorizer_config")

    @lambda_authorizer_config.setter
    def lambda_authorizer_config(self, value: Optional[pulumi.Input['ApiLambdaAuthorizerConfigArgs']]):
        pulumi.set(self, "lambda_authorizer_config", value)

    @property
    @pulumi.getter(name="openIdConnectConfig")
    def open_id_connect_config(self) -> Optional[pulumi.Input['ApiOpenIdConnectConfigArgs']]:
        return pulumi.get(self, "open_id_connect_config")

    @open_id_connect_config.setter
    def open_id_connect_config(self, value: Optional[pulumi.Input['ApiOpenIdConnectConfigArgs']]):
        pulumi.set(self, "open_id_connect_config", value)


if not MYPY:
    class ApiCognitoConfigArgsDict(TypedDict):
        """
        Optional authorization configuration for using Amazon Cognito user pools with your API endpoint.
        """
        aws_region: pulumi.Input[builtins.str]
        user_pool_id: pulumi.Input[builtins.str]
        app_id_client_regex: NotRequired[pulumi.Input[builtins.str]]
elif False:
    ApiCognitoConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApiCognitoConfigArgs:
    def __init__(__self__, *,
                 aws_region: pulumi.Input[builtins.str],
                 user_pool_id: pulumi.Input[builtins.str],
                 app_id_client_regex: Optional[pulumi.Input[builtins.str]] = None):
        """
        Optional authorization configuration for using Amazon Cognito user pools with your API endpoint.
        """
        pulumi.set(__self__, "aws_region", aws_region)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "app_id_client_regex")

    @app_id_client_regex.setter
    def app_id_client_regex(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_id_client_regex", value)


if not MYPY:
    class ApiEventConfigArgsDict(TypedDict):
        """
        The configuration for an Event Api
        """
        auth_providers: pulumi.Input[Sequence[pulumi.Input['ApiAuthProviderArgsDict']]]
        """
        A list of authorization providers.
        """
        connection_auth_modes: pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgsDict']]]
        """
        A list of valid authorization modes for the Event API connections.
        """
        default_publish_auth_modes: pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgsDict']]]
        """
        A list of valid authorization modes for the Event API publishing.
        """
        default_subscribe_auth_modes: pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgsDict']]]
        """
        A list of valid authorization modes for the Event API subscriptions.
        """
        log_config: NotRequired[pulumi.Input['ApiEventLogConfigArgsDict']]
        """
        The CloudWatch Logs configuration for the Event API.
        """
elif False:
    ApiEventConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApiEventConfigArgs:
    def __init__(__self__, *,
                 auth_providers: pulumi.Input[Sequence[pulumi.Input['ApiAuthProviderArgs']]],
                 connection_auth_modes: pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgs']]],
                 default_publish_auth_modes: pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgs']]],
                 default_subscribe_auth_modes: pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgs']]],
                 log_config: Optional[pulumi.Input['ApiEventLogConfigArgs']] = None):
        """
        The configuration for an Event Api
        :param pulumi.Input[Sequence[pulumi.Input['ApiAuthProviderArgs']]] auth_providers: A list of authorization providers.
        :param pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgs']]] connection_auth_modes: A list of valid authorization modes for the Event API connections.
        :param pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgs']]] default_publish_auth_modes: A list of valid authorization modes for the Event API publishing.
        :param pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgs']]] default_subscribe_auth_modes: A list of valid authorization modes for the Event API subscriptions.
        :param pulumi.Input['ApiEventLogConfigArgs'] log_config: The CloudWatch Logs configuration for the Event API.
        """
        pulumi.set(__self__, "auth_providers", auth_providers)
        pulumi.set(__self__, "connection_auth_modes", connection_auth_modes)
        pulumi.set(__self__, "default_publish_auth_modes", default_publish_auth_modes)
        pulumi.set(__self__, "default_subscribe_auth_modes", default_subscribe_auth_modes)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)

    @property
    @pulumi.getter(name="authProviders")
    def auth_providers(self) -> pulumi.Input[Sequence[pulumi.Input['ApiAuthProviderArgs']]]:
        """
        A list of authorization providers.
        """
        return pulumi.get(self, "auth_providers")

    @auth_providers.setter
    def auth_providers(self, value: pulumi.Input[Sequence[pulumi.Input['ApiAuthProviderArgs']]]):
        pulumi.set(self, "auth_providers", value)

    @property
    @pulumi.getter(name="connectionAuthModes")
    def connection_auth_modes(self) -> pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgs']]]:
        """
        A list of valid authorization modes for the Event API connections.
        """
        return pulumi.get(self, "connection_auth_modes")

    @connection_auth_modes.setter
    def connection_auth_modes(self, value: pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgs']]]):
        pulumi.set(self, "connection_auth_modes", value)

    @property
    @pulumi.getter(name="defaultPublishAuthModes")
    def default_publish_auth_modes(self) -> pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgs']]]:
        """
        A list of valid authorization modes for the Event API publishing.
        """
        return pulumi.get(self, "default_publish_auth_modes")

    @default_publish_auth_modes.setter
    def default_publish_auth_modes(self, value: pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgs']]]):
        pulumi.set(self, "default_publish_auth_modes", value)

    @property
    @pulumi.getter(name="defaultSubscribeAuthModes")
    def default_subscribe_auth_modes(self) -> pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgs']]]:
        """
        A list of valid authorization modes for the Event API subscriptions.
        """
        return pulumi.get(self, "default_subscribe_auth_modes")

    @default_subscribe_auth_modes.setter
    def default_subscribe_auth_modes(self, value: pulumi.Input[Sequence[pulumi.Input['ApiAuthModeArgs']]]):
        pulumi.set(self, "default_subscribe_auth_modes", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['ApiEventLogConfigArgs']]:
        """
        The CloudWatch Logs configuration for the Event API.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['ApiEventLogConfigArgs']]):
        pulumi.set(self, "log_config", value)


if not MYPY:
    class ApiEventLogConfigArgsDict(TypedDict):
        """
        The log config for the AppSync API.
        """
        cloud_watch_logs_role_arn: pulumi.Input[builtins.str]
        """
        The IAM service role that AWS AppSync assumes to publish CloudWatch Logs in your account.
        """
        log_level: pulumi.Input['ApiEventLogLevel']
        """
        The type of information to log for the Event API.
        """
elif False:
    ApiEventLogConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApiEventLogConfigArgs:
    def __init__(__self__, *,
                 cloud_watch_logs_role_arn: pulumi.Input[builtins.str],
                 log_level: pulumi.Input['ApiEventLogLevel']):
        """
        The log config for the AppSync API.
        :param pulumi.Input[builtins.str] cloud_watch_logs_role_arn: The IAM service role that AWS AppSync assumes to publish CloudWatch Logs in your account.
        :param pulumi.Input['ApiEventLogLevel'] log_level: The type of information to log for the Event API.
        """
        pulumi.set(__self__, "cloud_watch_logs_role_arn", cloud_watch_logs_role_arn)
        pulumi.set(__self__, "log_level", log_level)

    @property
    @pulumi.getter(name="cloudWatchLogsRoleArn")
    def cloud_watch_logs_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The IAM service role that AWS AppSync assumes to publish CloudWatch Logs in your account.
        """
        return pulumi.get(self, "cloud_watch_logs_role_arn")

    @cloud_watch_logs_role_arn.setter
    def cloud_watch_logs_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cloud_watch_logs_role_arn", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> pulumi.Input['ApiEventLogLevel']:
        """
        The type of information to log for the Event API.
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: pulumi.Input['ApiEventLogLevel']):
        pulumi.set(self, "log_level", value)


if not MYPY:
    class ApiLambdaAuthorizerConfigArgsDict(TypedDict):
        """
        A LambdaAuthorizerConfig holds configuration on how to authorize AWS AppSync API access when using the AWS_LAMBDA authorizer mode. Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
        """
        authorizer_uri: pulumi.Input[builtins.str]
        authorizer_result_ttl_in_seconds: NotRequired[pulumi.Input[builtins.int]]
        identity_validation_expression: NotRequired[pulumi.Input[builtins.str]]
elif False:
    ApiLambdaAuthorizerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApiLambdaAuthorizerConfigArgs:
    def __init__(__self__, *,
                 authorizer_uri: pulumi.Input[builtins.str],
                 authorizer_result_ttl_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 identity_validation_expression: Optional[pulumi.Input[builtins.str]] = None):
        """
        A LambdaAuthorizerConfig holds configuration on how to authorize AWS AppSync API access when using the AWS_LAMBDA authorizer mode. Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
        """
        pulumi.set(__self__, "authorizer_uri", authorizer_uri)
        if authorizer_result_ttl_in_seconds is not None:
            pulumi.set(__self__, "authorizer_result_ttl_in_seconds", authorizer_result_ttl_in_seconds)
        if identity_validation_expression is not None:
            pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)

    @property
    @pulumi.getter(name="authorizerUri")
    def authorizer_uri(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "authorizer_uri")

    @authorizer_uri.setter
    def authorizer_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authorizer_uri", value)

    @property
    @pulumi.getter(name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "authorizer_result_ttl_in_seconds")

    @authorizer_result_ttl_in_seconds.setter
    def authorizer_result_ttl_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "authorizer_result_ttl_in_seconds", value)

    @property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "identity_validation_expression")

    @identity_validation_expression.setter
    def identity_validation_expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identity_validation_expression", value)


if not MYPY:
    class ApiOpenIdConnectConfigArgsDict(TypedDict):
        """
        The OpenID Connect configuration.
        """
        issuer: pulumi.Input[builtins.str]
        auth_ttl: NotRequired[pulumi.Input[builtins.float]]
        client_id: NotRequired[pulumi.Input[builtins.str]]
        iat_ttl: NotRequired[pulumi.Input[builtins.float]]
elif False:
    ApiOpenIdConnectConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApiOpenIdConnectConfigArgs:
    def __init__(__self__, *,
                 issuer: pulumi.Input[builtins.str],
                 auth_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 iat_ttl: Optional[pulumi.Input[builtins.float]] = None):
        """
        The OpenID Connect configuration.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        return pulumi.get(self, "auth_ttl")

    @auth_ttl.setter
    def auth_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "auth_ttl", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        return pulumi.get(self, "iat_ttl")

    @iat_ttl.setter
    def iat_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "iat_ttl", value)


if not MYPY:
    class ChannelNamespaceAuthModeArgsDict(TypedDict):
        """
        An auth mode.
        """
        auth_type: NotRequired[pulumi.Input['ChannelNamespaceAuthenticationType']]
elif False:
    ChannelNamespaceAuthModeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelNamespaceAuthModeArgs:
    def __init__(__self__, *,
                 auth_type: Optional[pulumi.Input['ChannelNamespaceAuthenticationType']] = None):
        """
        An auth mode.
        """
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input['ChannelNamespaceAuthenticationType']]:
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input['ChannelNamespaceAuthenticationType']]):
        pulumi.set(self, "auth_type", value)


if not MYPY:
    class ChannelNamespaceHandlerConfigsArgsDict(TypedDict):
        on_publish: NotRequired[pulumi.Input['ChannelNamespaceHandlerConfigArgsDict']]
        """
        The configuration for the `OnPublish` handler.
        """
        on_subscribe: NotRequired[pulumi.Input['ChannelNamespaceHandlerConfigArgsDict']]
        """
        The configuration for the `OnSubscribe` handler.
        """
elif False:
    ChannelNamespaceHandlerConfigsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelNamespaceHandlerConfigsArgs:
    def __init__(__self__, *,
                 on_publish: Optional[pulumi.Input['ChannelNamespaceHandlerConfigArgs']] = None,
                 on_subscribe: Optional[pulumi.Input['ChannelNamespaceHandlerConfigArgs']] = None):
        """
        :param pulumi.Input['ChannelNamespaceHandlerConfigArgs'] on_publish: The configuration for the `OnPublish` handler.
        :param pulumi.Input['ChannelNamespaceHandlerConfigArgs'] on_subscribe: The configuration for the `OnSubscribe` handler.
        """
        if on_publish is not None:
            pulumi.set(__self__, "on_publish", on_publish)
        if on_subscribe is not None:
            pulumi.set(__self__, "on_subscribe", on_subscribe)

    @property
    @pulumi.getter(name="onPublish")
    def on_publish(self) -> Optional[pulumi.Input['ChannelNamespaceHandlerConfigArgs']]:
        """
        The configuration for the `OnPublish` handler.
        """
        return pulumi.get(self, "on_publish")

    @on_publish.setter
    def on_publish(self, value: Optional[pulumi.Input['ChannelNamespaceHandlerConfigArgs']]):
        pulumi.set(self, "on_publish", value)

    @property
    @pulumi.getter(name="onSubscribe")
    def on_subscribe(self) -> Optional[pulumi.Input['ChannelNamespaceHandlerConfigArgs']]:
        """
        The configuration for the `OnSubscribe` handler.
        """
        return pulumi.get(self, "on_subscribe")

    @on_subscribe.setter
    def on_subscribe(self, value: Optional[pulumi.Input['ChannelNamespaceHandlerConfigArgs']]):
        pulumi.set(self, "on_subscribe", value)


if not MYPY:
    class ChannelNamespaceHandlerConfigArgsDict(TypedDict):
        behavior: pulumi.Input['ChannelNamespaceHandlerBehavior']
        """
        The behavior for the handler.
        """
        integration: pulumi.Input['ChannelNamespaceIntegrationArgsDict']
        """
        The integration data source configuration for the handler.
        """
elif False:
    ChannelNamespaceHandlerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelNamespaceHandlerConfigArgs:
    def __init__(__self__, *,
                 behavior: pulumi.Input['ChannelNamespaceHandlerBehavior'],
                 integration: pulumi.Input['ChannelNamespaceIntegrationArgs']):
        """
        :param pulumi.Input['ChannelNamespaceHandlerBehavior'] behavior: The behavior for the handler.
        :param pulumi.Input['ChannelNamespaceIntegrationArgs'] integration: The integration data source configuration for the handler.
        """
        pulumi.set(__self__, "behavior", behavior)
        pulumi.set(__self__, "integration", integration)

    @property
    @pulumi.getter
    def behavior(self) -> pulumi.Input['ChannelNamespaceHandlerBehavior']:
        """
        The behavior for the handler.
        """
        return pulumi.get(self, "behavior")

    @behavior.setter
    def behavior(self, value: pulumi.Input['ChannelNamespaceHandlerBehavior']):
        pulumi.set(self, "behavior", value)

    @property
    @pulumi.getter
    def integration(self) -> pulumi.Input['ChannelNamespaceIntegrationArgs']:
        """
        The integration data source configuration for the handler.
        """
        return pulumi.get(self, "integration")

    @integration.setter
    def integration(self, value: pulumi.Input['ChannelNamespaceIntegrationArgs']):
        pulumi.set(self, "integration", value)


if not MYPY:
    class ChannelNamespaceIntegrationArgsDict(TypedDict):
        data_source_name: pulumi.Input[builtins.str]
        """
        Data source to invoke for this integration.
        """
        lambda_config: NotRequired[pulumi.Input['ChannelNamespaceLambdaConfigArgsDict']]
        """
        The configuration for a Lambda data source.
        """
elif False:
    ChannelNamespaceIntegrationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelNamespaceIntegrationArgs:
    def __init__(__self__, *,
                 data_source_name: pulumi.Input[builtins.str],
                 lambda_config: Optional[pulumi.Input['ChannelNamespaceLambdaConfigArgs']] = None):
        """
        :param pulumi.Input[builtins.str] data_source_name: Data source to invoke for this integration.
        :param pulumi.Input['ChannelNamespaceLambdaConfigArgs'] lambda_config: The configuration for a Lambda data source.
        """
        pulumi.set(__self__, "data_source_name", data_source_name)
        if lambda_config is not None:
            pulumi.set(__self__, "lambda_config", lambda_config)

    @property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> pulumi.Input[builtins.str]:
        """
        Data source to invoke for this integration.
        """
        return pulumi.get(self, "data_source_name")

    @data_source_name.setter
    def data_source_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_source_name", value)

    @property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> Optional[pulumi.Input['ChannelNamespaceLambdaConfigArgs']]:
        """
        The configuration for a Lambda data source.
        """
        return pulumi.get(self, "lambda_config")

    @lambda_config.setter
    def lambda_config(self, value: Optional[pulumi.Input['ChannelNamespaceLambdaConfigArgs']]):
        pulumi.set(self, "lambda_config", value)


if not MYPY:
    class ChannelNamespaceLambdaConfigArgsDict(TypedDict):
        invoke_type: pulumi.Input['ChannelNamespaceInvokeType']
        """
        The invocation type for a Lambda data source.
        """
elif False:
    ChannelNamespaceLambdaConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelNamespaceLambdaConfigArgs:
    def __init__(__self__, *,
                 invoke_type: pulumi.Input['ChannelNamespaceInvokeType']):
        """
        :param pulumi.Input['ChannelNamespaceInvokeType'] invoke_type: The invocation type for a Lambda data source.
        """
        pulumi.set(__self__, "invoke_type", invoke_type)

    @property
    @pulumi.getter(name="invokeType")
    def invoke_type(self) -> pulumi.Input['ChannelNamespaceInvokeType']:
        """
        The invocation type for a Lambda data source.
        """
        return pulumi.get(self, "invoke_type")

    @invoke_type.setter
    def invoke_type(self, value: pulumi.Input['ChannelNamespaceInvokeType']):
        pulumi.set(self, "invoke_type", value)


if not MYPY:
    class DataSourceAuthorizationConfigArgsDict(TypedDict):
        authorization_type: pulumi.Input[builtins.str]
        """
        The authorization type that the HTTP endpoint requires.
        """
        aws_iam_config: NotRequired[pulumi.Input['DataSourceAwsIamConfigArgsDict']]
        """
        The AWS Identity and Access Management settings.
        """
elif False:
    DataSourceAuthorizationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceAuthorizationConfigArgs:
    def __init__(__self__, *,
                 authorization_type: pulumi.Input[builtins.str],
                 aws_iam_config: Optional[pulumi.Input['DataSourceAwsIamConfigArgs']] = None):
        """
        :param pulumi.Input[builtins.str] authorization_type: The authorization type that the HTTP endpoint requires.
        :param pulumi.Input['DataSourceAwsIamConfigArgs'] aws_iam_config: The AWS Identity and Access Management settings.
        """
        pulumi.set(__self__, "authorization_type", authorization_type)
        if aws_iam_config is not None:
            pulumi.set(__self__, "aws_iam_config", aws_iam_config)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Input[builtins.str]:
        """
        The authorization type that the HTTP endpoint requires.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter(name="awsIamConfig")
    def aws_iam_config(self) -> Optional[pulumi.Input['DataSourceAwsIamConfigArgs']]:
        """
        The AWS Identity and Access Management settings.
        """
        return pulumi.get(self, "aws_iam_config")

    @aws_iam_config.setter
    def aws_iam_config(self, value: Optional[pulumi.Input['DataSourceAwsIamConfigArgs']]):
        pulumi.set(self, "aws_iam_config", value)


if not MYPY:
    class DataSourceAwsIamConfigArgsDict(TypedDict):
        signing_region: NotRequired[pulumi.Input[builtins.str]]
        """
        The signing Region for AWS Identity and Access Management authorization.
        """
        signing_service_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The signing service name for AWS Identity and Access Management authorization.
        """
elif False:
    DataSourceAwsIamConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceAwsIamConfigArgs:
    def __init__(__self__, *,
                 signing_region: Optional[pulumi.Input[builtins.str]] = None,
                 signing_service_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] signing_region: The signing Region for AWS Identity and Access Management authorization.
        :param pulumi.Input[builtins.str] signing_service_name: The signing service name for AWS Identity and Access Management authorization.
        """
        if signing_region is not None:
            pulumi.set(__self__, "signing_region", signing_region)
        if signing_service_name is not None:
            pulumi.set(__self__, "signing_service_name", signing_service_name)

    @property
    @pulumi.getter(name="signingRegion")
    def signing_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The signing Region for AWS Identity and Access Management authorization.
        """
        return pulumi.get(self, "signing_region")

    @signing_region.setter
    def signing_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_region", value)

    @property
    @pulumi.getter(name="signingServiceName")
    def signing_service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The signing service name for AWS Identity and Access Management authorization.
        """
        return pulumi.get(self, "signing_service_name")

    @signing_service_name.setter
    def signing_service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_service_name", value)


if not MYPY:
    class DataSourceDeltaSyncConfigArgsDict(TypedDict):
        base_table_ttl: pulumi.Input[builtins.str]
        """
        The number of minutes that an Item is stored in the data source.
        """
        delta_sync_table_name: pulumi.Input[builtins.str]
        """
        The Delta Sync table name.
        """
        delta_sync_table_ttl: pulumi.Input[builtins.str]
        """
        The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
        """
elif False:
    DataSourceDeltaSyncConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceDeltaSyncConfigArgs:
    def __init__(__self__, *,
                 base_table_ttl: pulumi.Input[builtins.str],
                 delta_sync_table_name: pulumi.Input[builtins.str],
                 delta_sync_table_ttl: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] base_table_ttl: The number of minutes that an Item is stored in the data source.
        :param pulumi.Input[builtins.str] delta_sync_table_name: The Delta Sync table name.
        :param pulumi.Input[builtins.str] delta_sync_table_ttl: The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
        """
        pulumi.set(__self__, "base_table_ttl", base_table_ttl)
        pulumi.set(__self__, "delta_sync_table_name", delta_sync_table_name)
        pulumi.set(__self__, "delta_sync_table_ttl", delta_sync_table_ttl)

    @property
    @pulumi.getter(name="baseTableTtl")
    def base_table_ttl(self) -> pulumi.Input[builtins.str]:
        """
        The number of minutes that an Item is stored in the data source.
        """
        return pulumi.get(self, "base_table_ttl")

    @base_table_ttl.setter
    def base_table_ttl(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "base_table_ttl", value)

    @property
    @pulumi.getter(name="deltaSyncTableName")
    def delta_sync_table_name(self) -> pulumi.Input[builtins.str]:
        """
        The Delta Sync table name.
        """
        return pulumi.get(self, "delta_sync_table_name")

    @delta_sync_table_name.setter
    def delta_sync_table_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "delta_sync_table_name", value)

    @property
    @pulumi.getter(name="deltaSyncTableTtl")
    def delta_sync_table_ttl(self) -> pulumi.Input[builtins.str]:
        """
        The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
        """
        return pulumi.get(self, "delta_sync_table_ttl")

    @delta_sync_table_ttl.setter
    def delta_sync_table_ttl(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "delta_sync_table_ttl", value)


if not MYPY:
    class DataSourceDynamoDbConfigArgsDict(TypedDict):
        aws_region: pulumi.Input[builtins.str]
        """
        The AWS Region.
        """
        table_name: pulumi.Input[builtins.str]
        """
        The table name.
        """
        delta_sync_config: NotRequired[pulumi.Input['DataSourceDeltaSyncConfigArgsDict']]
        """
        The DeltaSyncConfig for a versioned datasource.
        """
        use_caller_credentials: NotRequired[pulumi.Input[builtins.bool]]
        """
        Set to TRUE to use AWS Identity and Access Management with this data source.
        """
        versioned: NotRequired[pulumi.Input[builtins.bool]]
        """
        Set to TRUE to use Conflict Detection and Resolution with this data source.
        """
elif False:
    DataSourceDynamoDbConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceDynamoDbConfigArgs:
    def __init__(__self__, *,
                 aws_region: pulumi.Input[builtins.str],
                 table_name: pulumi.Input[builtins.str],
                 delta_sync_config: Optional[pulumi.Input['DataSourceDeltaSyncConfigArgs']] = None,
                 use_caller_credentials: Optional[pulumi.Input[builtins.bool]] = None,
                 versioned: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] aws_region: The AWS Region.
        :param pulumi.Input[builtins.str] table_name: The table name.
        :param pulumi.Input['DataSourceDeltaSyncConfigArgs'] delta_sync_config: The DeltaSyncConfig for a versioned datasource.
        :param pulumi.Input[builtins.bool] use_caller_credentials: Set to TRUE to use AWS Identity and Access Management with this data source.
        :param pulumi.Input[builtins.bool] versioned: Set to TRUE to use Conflict Detection and Resolution with this data source.
        """
        pulumi.set(__self__, "aws_region", aws_region)
        pulumi.set(__self__, "table_name", table_name)
        if delta_sync_config is not None:
            pulumi.set(__self__, "delta_sync_config", delta_sync_config)
        if use_caller_credentials is not None:
            pulumi.set(__self__, "use_caller_credentials", use_caller_credentials)
        if versioned is not None:
            pulumi.set(__self__, "versioned", versioned)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> pulumi.Input[builtins.str]:
        """
        The AWS Region.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[builtins.str]:
        """
        The table name.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="deltaSyncConfig")
    def delta_sync_config(self) -> Optional[pulumi.Input['DataSourceDeltaSyncConfigArgs']]:
        """
        The DeltaSyncConfig for a versioned datasource.
        """
        return pulumi.get(self, "delta_sync_config")

    @delta_sync_config.setter
    def delta_sync_config(self, value: Optional[pulumi.Input['DataSourceDeltaSyncConfigArgs']]):
        pulumi.set(self, "delta_sync_config", value)

    @property
    @pulumi.getter(name="useCallerCredentials")
    def use_caller_credentials(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to TRUE to use AWS Identity and Access Management with this data source.
        """
        return pulumi.get(self, "use_caller_credentials")

    @use_caller_credentials.setter
    def use_caller_credentials(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_caller_credentials", value)

    @property
    @pulumi.getter
    def versioned(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to TRUE to use Conflict Detection and Resolution with this data source.
        """
        return pulumi.get(self, "versioned")

    @versioned.setter
    def versioned(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "versioned", value)


if not MYPY:
    class DataSourceElasticsearchConfigArgsDict(TypedDict):
        aws_region: pulumi.Input[builtins.str]
        """
        The AWS Region.
        """
        endpoint: pulumi.Input[builtins.str]
        """
        The endpoint.
        """
elif False:
    DataSourceElasticsearchConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceElasticsearchConfigArgs:
    def __init__(__self__, *,
                 aws_region: pulumi.Input[builtins.str],
                 endpoint: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] aws_region: The AWS Region.
        :param pulumi.Input[builtins.str] endpoint: The endpoint.
        """
        pulumi.set(__self__, "aws_region", aws_region)
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> pulumi.Input[builtins.str]:
        """
        The AWS Region.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The endpoint.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "endpoint", value)


if not MYPY:
    class DataSourceEventBridgeConfigArgsDict(TypedDict):
        event_bus_arn: pulumi.Input[builtins.str]
        """
        ARN for the EventBridge bus.
        """
elif False:
    DataSourceEventBridgeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceEventBridgeConfigArgs:
    def __init__(__self__, *,
                 event_bus_arn: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] event_bus_arn: ARN for the EventBridge bus.
        """
        pulumi.set(__self__, "event_bus_arn", event_bus_arn)

    @property
    @pulumi.getter(name="eventBusArn")
    def event_bus_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN for the EventBridge bus.
        """
        return pulumi.get(self, "event_bus_arn")

    @event_bus_arn.setter
    def event_bus_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "event_bus_arn", value)


if not MYPY:
    class DataSourceHttpConfigArgsDict(TypedDict):
        endpoint: pulumi.Input[builtins.str]
        """
        The endpoint.
        """
        authorization_config: NotRequired[pulumi.Input['DataSourceAuthorizationConfigArgsDict']]
        """
        The authorization configuration.
        """
elif False:
    DataSourceHttpConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceHttpConfigArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[builtins.str],
                 authorization_config: Optional[pulumi.Input['DataSourceAuthorizationConfigArgs']] = None):
        """
        :param pulumi.Input[builtins.str] endpoint: The endpoint.
        :param pulumi.Input['DataSourceAuthorizationConfigArgs'] authorization_config: The authorization configuration.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if authorization_config is not None:
            pulumi.set(__self__, "authorization_config", authorization_config)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The endpoint.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> Optional[pulumi.Input['DataSourceAuthorizationConfigArgs']]:
        """
        The authorization configuration.
        """
        return pulumi.get(self, "authorization_config")

    @authorization_config.setter
    def authorization_config(self, value: Optional[pulumi.Input['DataSourceAuthorizationConfigArgs']]):
        pulumi.set(self, "authorization_config", value)


if not MYPY:
    class DataSourceLambdaConfigArgsDict(TypedDict):
        lambda_function_arn: pulumi.Input[builtins.str]
        """
        The ARN for the Lambda function.
        """
elif False:
    DataSourceLambdaConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceLambdaConfigArgs:
    def __init__(__self__, *,
                 lambda_function_arn: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] lambda_function_arn: The ARN for the Lambda function.
        """
        pulumi.set(__self__, "lambda_function_arn", lambda_function_arn)

    @property
    @pulumi.getter(name="lambdaFunctionArn")
    def lambda_function_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN for the Lambda function.
        """
        return pulumi.get(self, "lambda_function_arn")

    @lambda_function_arn.setter
    def lambda_function_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "lambda_function_arn", value)


if not MYPY:
    class DataSourceOpenSearchServiceConfigArgsDict(TypedDict):
        aws_region: pulumi.Input[builtins.str]
        """
        The AWS Region.
        """
        endpoint: pulumi.Input[builtins.str]
        """
        The endpoint.
        """
elif False:
    DataSourceOpenSearchServiceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceOpenSearchServiceConfigArgs:
    def __init__(__self__, *,
                 aws_region: pulumi.Input[builtins.str],
                 endpoint: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] aws_region: The AWS Region.
        :param pulumi.Input[builtins.str] endpoint: The endpoint.
        """
        pulumi.set(__self__, "aws_region", aws_region)
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> pulumi.Input[builtins.str]:
        """
        The AWS Region.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The endpoint.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "endpoint", value)


if not MYPY:
    class DataSourceRdsHttpEndpointConfigArgsDict(TypedDict):
        aws_region: pulumi.Input[builtins.str]
        """
        AWS Region for RDS HTTP endpoint.
        """
        aws_secret_store_arn: pulumi.Input[builtins.str]
        """
        The ARN for database credentials stored in AWS Secrets Manager.
        """
        db_cluster_identifier: pulumi.Input[builtins.str]
        """
        Amazon RDS cluster Amazon Resource Name (ARN).
        """
        database_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Logical database name.
        """
        schema: NotRequired[pulumi.Input[builtins.str]]
        """
        Logical schema name.
        """
elif False:
    DataSourceRdsHttpEndpointConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceRdsHttpEndpointConfigArgs:
    def __init__(__self__, *,
                 aws_region: pulumi.Input[builtins.str],
                 aws_secret_store_arn: pulumi.Input[builtins.str],
                 db_cluster_identifier: pulumi.Input[builtins.str],
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] aws_region: AWS Region for RDS HTTP endpoint.
        :param pulumi.Input[builtins.str] aws_secret_store_arn: The ARN for database credentials stored in AWS Secrets Manager.
        :param pulumi.Input[builtins.str] db_cluster_identifier: Amazon RDS cluster Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.str] database_name: Logical database name.
        :param pulumi.Input[builtins.str] schema: Logical schema name.
        """
        pulumi.set(__self__, "aws_region", aws_region)
        pulumi.set(__self__, "aws_secret_store_arn", aws_secret_store_arn)
        pulumi.set(__self__, "db_cluster_identifier", db_cluster_identifier)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> pulumi.Input[builtins.str]:
        """
        AWS Region for RDS HTTP endpoint.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter(name="awsSecretStoreArn")
    def aws_secret_store_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN for database credentials stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "aws_secret_store_arn")

    @aws_secret_store_arn.setter
    def aws_secret_store_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "aws_secret_store_arn", value)

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> pulumi.Input[builtins.str]:
        """
        Amazon RDS cluster Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "db_cluster_identifier")

    @db_cluster_identifier.setter
    def db_cluster_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_cluster_identifier", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Logical database name.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Logical schema name.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema", value)


if not MYPY:
    class DataSourceRelationalDatabaseConfigArgsDict(TypedDict):
        relational_database_source_type: pulumi.Input[builtins.str]
        """
        The type of relational data source.
        """
        rds_http_endpoint_config: NotRequired[pulumi.Input['DataSourceRdsHttpEndpointConfigArgsDict']]
        """
        Information about the Amazon RDS resource.
        """
elif False:
    DataSourceRelationalDatabaseConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceRelationalDatabaseConfigArgs:
    def __init__(__self__, *,
                 relational_database_source_type: pulumi.Input[builtins.str],
                 rds_http_endpoint_config: Optional[pulumi.Input['DataSourceRdsHttpEndpointConfigArgs']] = None):
        """
        :param pulumi.Input[builtins.str] relational_database_source_type: The type of relational data source.
        :param pulumi.Input['DataSourceRdsHttpEndpointConfigArgs'] rds_http_endpoint_config: Information about the Amazon RDS resource.
        """
        pulumi.set(__self__, "relational_database_source_type", relational_database_source_type)
        if rds_http_endpoint_config is not None:
            pulumi.set(__self__, "rds_http_endpoint_config", rds_http_endpoint_config)

    @property
    @pulumi.getter(name="relationalDatabaseSourceType")
    def relational_database_source_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of relational data source.
        """
        return pulumi.get(self, "relational_database_source_type")

    @relational_database_source_type.setter
    def relational_database_source_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "relational_database_source_type", value)

    @property
    @pulumi.getter(name="rdsHttpEndpointConfig")
    def rds_http_endpoint_config(self) -> Optional[pulumi.Input['DataSourceRdsHttpEndpointConfigArgs']]:
        """
        Information about the Amazon RDS resource.
        """
        return pulumi.get(self, "rds_http_endpoint_config")

    @rds_http_endpoint_config.setter
    def rds_http_endpoint_config(self, value: Optional[pulumi.Input['DataSourceRdsHttpEndpointConfigArgs']]):
        pulumi.set(self, "rds_http_endpoint_config", value)


if not MYPY:
    class FunctionConfigurationAppSyncRuntimeArgsDict(TypedDict):
        """
        Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the runtime to use. Currently, the only allowed value is APPSYNC_JS.
        """
        runtime_version: pulumi.Input[builtins.str]
        """
        The version of the runtime to use. Currently, the only allowed version is 1.0.0.
        """
elif False:
    FunctionConfigurationAppSyncRuntimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FunctionConfigurationAppSyncRuntimeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 runtime_version: pulumi.Input[builtins.str]):
        """
        Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        :param pulumi.Input[builtins.str] name: The name of the runtime to use. Currently, the only allowed value is APPSYNC_JS.
        :param pulumi.Input[builtins.str] runtime_version: The version of the runtime to use. Currently, the only allowed version is 1.0.0.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the runtime to use. Currently, the only allowed value is APPSYNC_JS.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Input[builtins.str]:
        """
        The version of the runtime to use. Currently, the only allowed version is 1.0.0.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "runtime_version", value)


if not MYPY:
    class FunctionConfigurationLambdaConflictHandlerConfigArgsDict(TypedDict):
        """
        The LambdaConflictHandlerConfig when configuring LAMBDA as the Conflict Handler.
        """
        lambda_conflict_handler_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
elif False:
    FunctionConfigurationLambdaConflictHandlerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FunctionConfigurationLambdaConflictHandlerConfigArgs:
    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        The LambdaConflictHandlerConfig when configuring LAMBDA as the Conflict Handler.
        :param pulumi.Input[builtins.str] lambda_conflict_handler_arn: The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")

    @lambda_conflict_handler_arn.setter
    def lambda_conflict_handler_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lambda_conflict_handler_arn", value)


if not MYPY:
    class FunctionConfigurationSyncConfigArgsDict(TypedDict):
        """
        Describes a Sync configuration for a resolver. Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        """
        conflict_detection: pulumi.Input[builtins.str]
        """
        The Conflict Detection strategy to use.
        """
        conflict_handler: NotRequired[pulumi.Input[builtins.str]]
        """
        The Conflict Resolution strategy to perform in the event of a conflict.
        """
        lambda_conflict_handler_config: NotRequired[pulumi.Input['FunctionConfigurationLambdaConflictHandlerConfigArgsDict']]
        """
        The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
        """
elif False:
    FunctionConfigurationSyncConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FunctionConfigurationSyncConfigArgs:
    def __init__(__self__, *,
                 conflict_detection: pulumi.Input[builtins.str],
                 conflict_handler: Optional[pulumi.Input[builtins.str]] = None,
                 lambda_conflict_handler_config: Optional[pulumi.Input['FunctionConfigurationLambdaConflictHandlerConfigArgs']] = None):
        """
        Describes a Sync configuration for a resolver. Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        :param pulumi.Input[builtins.str] conflict_detection: The Conflict Detection strategy to use.
        :param pulumi.Input[builtins.str] conflict_handler: The Conflict Resolution strategy to perform in the event of a conflict.
        :param pulumi.Input['FunctionConfigurationLambdaConflictHandlerConfigArgs'] lambda_conflict_handler_config: The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
        """
        pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> pulumi.Input[builtins.str]:
        """
        The Conflict Detection strategy to use.
        """
        return pulumi.get(self, "conflict_detection")

    @conflict_detection.setter
    def conflict_detection(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "conflict_detection", value)

    @property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Conflict Resolution strategy to perform in the event of a conflict.
        """
        return pulumi.get(self, "conflict_handler")

    @conflict_handler.setter
    def conflict_handler(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "conflict_handler", value)

    @property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional[pulumi.Input['FunctionConfigurationLambdaConflictHandlerConfigArgs']]:
        """
        The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")

    @lambda_conflict_handler_config.setter
    def lambda_conflict_handler_config(self, value: Optional[pulumi.Input['FunctionConfigurationLambdaConflictHandlerConfigArgs']]):
        pulumi.set(self, "lambda_conflict_handler_config", value)


if not MYPY:
    class GraphQlApiAdditionalAuthenticationProviderArgsDict(TypedDict):
        authentication_type: pulumi.Input[builtins.str]
        """
        The authentication type for API key, AWS Identity and Access Management, OIDC, Amazon Cognito user pools, or AWS Lambda.
        """
        lambda_authorizer_config: NotRequired[pulumi.Input['GraphQlApiLambdaAuthorizerConfigArgsDict']]
        """
        Configuration for AWS Lambda function authorization.
        """
        open_id_connect_config: NotRequired[pulumi.Input['GraphQlApiOpenIdConnectConfigArgsDict']]
        """
        The OIDC configuration.
        """
        user_pool_config: NotRequired[pulumi.Input['GraphQlApiCognitoUserPoolConfigArgsDict']]
        """
        The Amazon Cognito user pool configuration.
        """
elif False:
    GraphQlApiAdditionalAuthenticationProviderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQlApiAdditionalAuthenticationProviderArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[builtins.str],
                 lambda_authorizer_config: Optional[pulumi.Input['GraphQlApiLambdaAuthorizerConfigArgs']] = None,
                 open_id_connect_config: Optional[pulumi.Input['GraphQlApiOpenIdConnectConfigArgs']] = None,
                 user_pool_config: Optional[pulumi.Input['GraphQlApiCognitoUserPoolConfigArgs']] = None):
        """
        :param pulumi.Input[builtins.str] authentication_type: The authentication type for API key, AWS Identity and Access Management, OIDC, Amazon Cognito user pools, or AWS Lambda.
        :param pulumi.Input['GraphQlApiLambdaAuthorizerConfigArgs'] lambda_authorizer_config: Configuration for AWS Lambda function authorization.
        :param pulumi.Input['GraphQlApiOpenIdConnectConfigArgs'] open_id_connect_config: The OIDC configuration.
        :param pulumi.Input['GraphQlApiCognitoUserPoolConfigArgs'] user_pool_config: The Amazon Cognito user pool configuration.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if lambda_authorizer_config is not None:
            pulumi.set(__self__, "lambda_authorizer_config", lambda_authorizer_config)
        if open_id_connect_config is not None:
            pulumi.set(__self__, "open_id_connect_config", open_id_connect_config)
        if user_pool_config is not None:
            pulumi.set(__self__, "user_pool_config", user_pool_config)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[builtins.str]:
        """
        The authentication type for API key, AWS Identity and Access Management, OIDC, Amazon Cognito user pools, or AWS Lambda.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="lambdaAuthorizerConfig")
    def lambda_authorizer_config(self) -> Optional[pulumi.Input['GraphQlApiLambdaAuthorizerConfigArgs']]:
        """
        Configuration for AWS Lambda function authorization.
        """
        return pulumi.get(self, "lambda_authorizer_config")

    @lambda_authorizer_config.setter
    def lambda_authorizer_config(self, value: Optional[pulumi.Input['GraphQlApiLambdaAuthorizerConfigArgs']]):
        pulumi.set(self, "lambda_authorizer_config", value)

    @property
    @pulumi.getter(name="openIdConnectConfig")
    def open_id_connect_config(self) -> Optional[pulumi.Input['GraphQlApiOpenIdConnectConfigArgs']]:
        """
        The OIDC configuration.
        """
        return pulumi.get(self, "open_id_connect_config")

    @open_id_connect_config.setter
    def open_id_connect_config(self, value: Optional[pulumi.Input['GraphQlApiOpenIdConnectConfigArgs']]):
        pulumi.set(self, "open_id_connect_config", value)

    @property
    @pulumi.getter(name="userPoolConfig")
    def user_pool_config(self) -> Optional[pulumi.Input['GraphQlApiCognitoUserPoolConfigArgs']]:
        """
        The Amazon Cognito user pool configuration.
        """
        return pulumi.get(self, "user_pool_config")

    @user_pool_config.setter
    def user_pool_config(self, value: Optional[pulumi.Input['GraphQlApiCognitoUserPoolConfigArgs']]):
        pulumi.set(self, "user_pool_config", value)


if not MYPY:
    class GraphQlApiCognitoUserPoolConfigArgsDict(TypedDict):
        app_id_client_regex: NotRequired[pulumi.Input[builtins.str]]
        """
        A regular expression for validating the incoming Amazon Cognito user pool app client ID. 
        """
        aws_region: NotRequired[pulumi.Input[builtins.str]]
        """
        The AWS Region in which the user pool was created.
        """
        user_pool_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The user pool ID
        """
elif False:
    GraphQlApiCognitoUserPoolConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQlApiCognitoUserPoolConfigArgs:
    def __init__(__self__, *,
                 app_id_client_regex: Optional[pulumi.Input[builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[builtins.str]] = None,
                 user_pool_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] app_id_client_regex: A regular expression for validating the incoming Amazon Cognito user pool app client ID. 
        :param pulumi.Input[builtins.str] aws_region: The AWS Region in which the user pool was created.
        :param pulumi.Input[builtins.str] user_pool_id: The user pool ID
        """
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if user_pool_id is not None:
            pulumi.set(__self__, "user_pool_id", user_pool_id)

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A regular expression for validating the incoming Amazon Cognito user pool app client ID. 
        """
        return pulumi.get(self, "app_id_client_regex")

    @app_id_client_regex.setter
    def app_id_client_regex(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_id_client_regex", value)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS Region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user pool ID
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_pool_id", value)


if not MYPY:
    class GraphQlApiEnhancedMetricsConfigArgsDict(TypedDict):
        data_source_level_metrics_behavior: pulumi.Input[builtins.str]
        """
        Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:
        """
        operation_level_metrics_config: pulumi.Input[builtins.str]
        """
        Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:
        """
        resolver_level_metrics_behavior: pulumi.Input[builtins.str]
        """
        Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:
        """
elif False:
    GraphQlApiEnhancedMetricsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQlApiEnhancedMetricsConfigArgs:
    def __init__(__self__, *,
                 data_source_level_metrics_behavior: pulumi.Input[builtins.str],
                 operation_level_metrics_config: pulumi.Input[builtins.str],
                 resolver_level_metrics_behavior: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] data_source_level_metrics_behavior: Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:
        :param pulumi.Input[builtins.str] operation_level_metrics_config: Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:
        :param pulumi.Input[builtins.str] resolver_level_metrics_behavior: Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:
        """
        pulumi.set(__self__, "data_source_level_metrics_behavior", data_source_level_metrics_behavior)
        pulumi.set(__self__, "operation_level_metrics_config", operation_level_metrics_config)
        pulumi.set(__self__, "resolver_level_metrics_behavior", resolver_level_metrics_behavior)

    @property
    @pulumi.getter(name="dataSourceLevelMetricsBehavior")
    def data_source_level_metrics_behavior(self) -> pulumi.Input[builtins.str]:
        """
        Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:
        """
        return pulumi.get(self, "data_source_level_metrics_behavior")

    @data_source_level_metrics_behavior.setter
    def data_source_level_metrics_behavior(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_source_level_metrics_behavior", value)

    @property
    @pulumi.getter(name="operationLevelMetricsConfig")
    def operation_level_metrics_config(self) -> pulumi.Input[builtins.str]:
        """
        Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:
        """
        return pulumi.get(self, "operation_level_metrics_config")

    @operation_level_metrics_config.setter
    def operation_level_metrics_config(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "operation_level_metrics_config", value)

    @property
    @pulumi.getter(name="resolverLevelMetricsBehavior")
    def resolver_level_metrics_behavior(self) -> pulumi.Input[builtins.str]:
        """
        Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:
        """
        return pulumi.get(self, "resolver_level_metrics_behavior")

    @resolver_level_metrics_behavior.setter
    def resolver_level_metrics_behavior(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resolver_level_metrics_behavior", value)


if not MYPY:
    class GraphQlApiLambdaAuthorizerConfigArgsDict(TypedDict):
        authorizer_result_ttl_in_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds a response should be cached for.
        """
        authorizer_uri: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the Lambda function to be called for authorization.
        """
        identity_validation_expression: NotRequired[pulumi.Input[builtins.str]]
        """
        A regular expression for validation of tokens before the Lambda function is called.
        """
elif False:
    GraphQlApiLambdaAuthorizerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQlApiLambdaAuthorizerConfigArgs:
    def __init__(__self__, *,
                 authorizer_result_ttl_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 authorizer_uri: Optional[pulumi.Input[builtins.str]] = None,
                 identity_validation_expression: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] authorizer_result_ttl_in_seconds: The number of seconds a response should be cached for.
        :param pulumi.Input[builtins.str] authorizer_uri: The ARN of the Lambda function to be called for authorization.
        :param pulumi.Input[builtins.str] identity_validation_expression: A regular expression for validation of tokens before the Lambda function is called.
        """
        if authorizer_result_ttl_in_seconds is not None:
            pulumi.set(__self__, "authorizer_result_ttl_in_seconds", authorizer_result_ttl_in_seconds)
        if authorizer_uri is not None:
            pulumi.set(__self__, "authorizer_uri", authorizer_uri)
        if identity_validation_expression is not None:
            pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)

    @property
    @pulumi.getter(name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds a response should be cached for.
        """
        return pulumi.get(self, "authorizer_result_ttl_in_seconds")

    @authorizer_result_ttl_in_seconds.setter
    def authorizer_result_ttl_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "authorizer_result_ttl_in_seconds", value)

    @property
    @pulumi.getter(name="authorizerUri")
    def authorizer_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the Lambda function to be called for authorization.
        """
        return pulumi.get(self, "authorizer_uri")

    @authorizer_uri.setter
    def authorizer_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorizer_uri", value)

    @property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A regular expression for validation of tokens before the Lambda function is called.
        """
        return pulumi.get(self, "identity_validation_expression")

    @identity_validation_expression.setter
    def identity_validation_expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identity_validation_expression", value)


if not MYPY:
    class GraphQlApiLogConfigArgsDict(TypedDict):
        cloud_watch_logs_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The service role that AWS AppSync will assume to publish to Amazon CloudWatch Logs in your account.
        """
        exclude_verbose_content: NotRequired[pulumi.Input[builtins.bool]]
        """
        Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level.
        """
        field_log_level: NotRequired[pulumi.Input[builtins.str]]
        """
        The field logging level. Values can be NONE, ERROR, INFO, DEBUG, or ALL.
        """
elif False:
    GraphQlApiLogConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQlApiLogConfigArgs:
    def __init__(__self__, *,
                 cloud_watch_logs_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 exclude_verbose_content: Optional[pulumi.Input[builtins.bool]] = None,
                 field_log_level: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] cloud_watch_logs_role_arn: The service role that AWS AppSync will assume to publish to Amazon CloudWatch Logs in your account.
        :param pulumi.Input[builtins.bool] exclude_verbose_content: Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level.
        :param pulumi.Input[builtins.str] field_log_level: The field logging level. Values can be NONE, ERROR, INFO, DEBUG, or ALL.
        """
        if cloud_watch_logs_role_arn is not None:
            pulumi.set(__self__, "cloud_watch_logs_role_arn", cloud_watch_logs_role_arn)
        if exclude_verbose_content is not None:
            pulumi.set(__self__, "exclude_verbose_content", exclude_verbose_content)
        if field_log_level is not None:
            pulumi.set(__self__, "field_log_level", field_log_level)

    @property
    @pulumi.getter(name="cloudWatchLogsRoleArn")
    def cloud_watch_logs_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service role that AWS AppSync will assume to publish to Amazon CloudWatch Logs in your account.
        """
        return pulumi.get(self, "cloud_watch_logs_role_arn")

    @cloud_watch_logs_role_arn.setter
    def cloud_watch_logs_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_watch_logs_role_arn", value)

    @property
    @pulumi.getter(name="excludeVerboseContent")
    def exclude_verbose_content(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level.
        """
        return pulumi.get(self, "exclude_verbose_content")

    @exclude_verbose_content.setter
    def exclude_verbose_content(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "exclude_verbose_content", value)

    @property
    @pulumi.getter(name="fieldLogLevel")
    def field_log_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The field logging level. Values can be NONE, ERROR, INFO, DEBUG, or ALL.
        """
        return pulumi.get(self, "field_log_level")

    @field_log_level.setter
    def field_log_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "field_log_level", value)


if not MYPY:
    class GraphQlApiOpenIdConnectConfigArgsDict(TypedDict):
        auth_ttl: NotRequired[pulumi.Input[builtins.float]]
        """
        The number of milliseconds that a token is valid after being authenticated.
        """
        client_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The client identifier of the Relying party at the OpenID identity provider.
        """
        iat_ttl: NotRequired[pulumi.Input[builtins.float]]
        """
        The number of milliseconds that a token is valid after it's issued to a user.
        """
        issuer: NotRequired[pulumi.Input[builtins.str]]
        """
        The issuer for the OIDC configuration. 
        """
elif False:
    GraphQlApiOpenIdConnectConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQlApiOpenIdConnectConfigArgs:
    def __init__(__self__, *,
                 auth_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 iat_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 issuer: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.float] auth_ttl: The number of milliseconds that a token is valid after being authenticated.
        :param pulumi.Input[builtins.str] client_id: The client identifier of the Relying party at the OpenID identity provider.
        :param pulumi.Input[builtins.float] iat_ttl: The number of milliseconds that a token is valid after it's issued to a user.
        :param pulumi.Input[builtins.str] issuer: The issuer for the OIDC configuration. 
        """
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of milliseconds that a token is valid after being authenticated.
        """
        return pulumi.get(self, "auth_ttl")

    @auth_ttl.setter
    def auth_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "auth_ttl", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The client identifier of the Relying party at the OpenID identity provider.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of milliseconds that a token is valid after it's issued to a user.
        """
        return pulumi.get(self, "iat_ttl")

    @iat_ttl.setter
    def iat_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "iat_ttl", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The issuer for the OIDC configuration. 
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issuer", value)


if not MYPY:
    class GraphQlApiUserPoolConfigArgsDict(TypedDict):
        app_id_client_regex: NotRequired[pulumi.Input[builtins.str]]
        """
        A regular expression for validating the incoming Amazon Cognito user pool app client ID.
        """
        aws_region: NotRequired[pulumi.Input[builtins.str]]
        """
        The AWS Region in which the user pool was created.
        """
        default_action: NotRequired[pulumi.Input[builtins.str]]
        """
        The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool authentication doesn't match the Amazon Cognito user pool configuration.
        """
        user_pool_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The user pool ID.
        """
elif False:
    GraphQlApiUserPoolConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQlApiUserPoolConfigArgs:
    def __init__(__self__, *,
                 app_id_client_regex: Optional[pulumi.Input[builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[builtins.str]] = None,
                 default_action: Optional[pulumi.Input[builtins.str]] = None,
                 user_pool_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] app_id_client_regex: A regular expression for validating the incoming Amazon Cognito user pool app client ID.
        :param pulumi.Input[builtins.str] aws_region: The AWS Region in which the user pool was created.
        :param pulumi.Input[builtins.str] default_action: The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool authentication doesn't match the Amazon Cognito user pool configuration.
        :param pulumi.Input[builtins.str] user_pool_id: The user pool ID.
        """
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if user_pool_id is not None:
            pulumi.set(__self__, "user_pool_id", user_pool_id)

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A regular expression for validating the incoming Amazon Cognito user pool app client ID.
        """
        return pulumi.get(self, "app_id_client_regex")

    @app_id_client_regex.setter
    def app_id_client_regex(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_id_client_regex", value)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS Region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool authentication doesn't match the Amazon Cognito user pool configuration.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user pool ID.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_pool_id", value)


if not MYPY:
    class ResolverAppSyncRuntimeArgsDict(TypedDict):
        """
        Describes a runtime used by an APSYlong resolver or APSYlong function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        """
        name: pulumi.Input[builtins.str]
        """
        The ``name`` of the runtime to use. Currently, the only allowed value is ``APPSYNC_JS``.
        """
        runtime_version: pulumi.Input[builtins.str]
        """
        The ``version`` of the runtime to use. Currently, the only allowed version is ``1.0.0``.
        """
elif False:
    ResolverAppSyncRuntimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverAppSyncRuntimeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 runtime_version: pulumi.Input[builtins.str]):
        """
        Describes a runtime used by an APSYlong resolver or APSYlong function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        :param pulumi.Input[builtins.str] name: The ``name`` of the runtime to use. Currently, the only allowed value is ``APPSYNC_JS``.
        :param pulumi.Input[builtins.str] runtime_version: The ``version`` of the runtime to use. Currently, the only allowed version is ``1.0.0``.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The ``name`` of the runtime to use. Currently, the only allowed value is ``APPSYNC_JS``.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Input[builtins.str]:
        """
        The ``version`` of the runtime to use. Currently, the only allowed version is ``1.0.0``.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "runtime_version", value)


if not MYPY:
    class ResolverCachingConfigArgsDict(TypedDict):
        """
        The caching configuration for a resolver that has caching activated.
        """
        ttl: pulumi.Input[builtins.float]
        """
        The TTL in seconds for a resolver that has caching activated.
         Valid values are 1–3,600 seconds.
        """
        caching_keys: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The caching keys for a resolver that has caching activated.
         Valid values are entries from the ``$context.arguments``, ``$context.source``, and ``$context.identity`` maps.
        """
elif False:
    ResolverCachingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverCachingConfigArgs:
    def __init__(__self__, *,
                 ttl: pulumi.Input[builtins.float],
                 caching_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The caching configuration for a resolver that has caching activated.
        :param pulumi.Input[builtins.float] ttl: The TTL in seconds for a resolver that has caching activated.
                Valid values are 1–3,600 seconds.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] caching_keys: The caching keys for a resolver that has caching activated.
                Valid values are entries from the ``$context.arguments``, ``$context.source``, and ``$context.identity`` maps.
        """
        pulumi.set(__self__, "ttl", ttl)
        if caching_keys is not None:
            pulumi.set(__self__, "caching_keys", caching_keys)

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Input[builtins.float]:
        """
        The TTL in seconds for a resolver that has caching activated.
         Valid values are 1–3,600 seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="cachingKeys")
    def caching_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The caching keys for a resolver that has caching activated.
         Valid values are entries from the ``$context.arguments``, ``$context.source``, and ``$context.identity`` maps.
        """
        return pulumi.get(self, "caching_keys")

    @caching_keys.setter
    def caching_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "caching_keys", value)


if not MYPY:
    class ResolverLambdaConflictHandlerConfigArgsDict(TypedDict):
        """
        The ``LambdaConflictHandlerConfig`` when configuring LAMBDA as the Conflict Handler.
        """
        lambda_conflict_handler_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
elif False:
    ResolverLambdaConflictHandlerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverLambdaConflictHandlerConfigArgs:
    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ``LambdaConflictHandlerConfig`` when configuring LAMBDA as the Conflict Handler.
        :param pulumi.Input[builtins.str] lambda_conflict_handler_arn: The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")

    @lambda_conflict_handler_arn.setter
    def lambda_conflict_handler_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lambda_conflict_handler_arn", value)


if not MYPY:
    class ResolverPipelineConfigArgsDict(TypedDict):
        """
        Use the ``PipelineConfig`` property type to specify ``PipelineConfig`` for an APSYlong resolver.
         ``PipelineConfig`` is a property of the [AWS::AppSync::Resolver](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html) resource.
        """
        functions: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of ``Function`` objects.
        """
elif False:
    ResolverPipelineConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverPipelineConfigArgs:
    def __init__(__self__, *,
                 functions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Use the ``PipelineConfig`` property type to specify ``PipelineConfig`` for an APSYlong resolver.
         ``PipelineConfig`` is a property of the [AWS::AppSync::Resolver](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html) resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] functions: A list of ``Function`` objects.
        """
        if functions is not None:
            pulumi.set(__self__, "functions", functions)

    @property
    @pulumi.getter
    def functions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of ``Function`` objects.
        """
        return pulumi.get(self, "functions")

    @functions.setter
    def functions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "functions", value)


if not MYPY:
    class ResolverSyncConfigArgsDict(TypedDict):
        """
        Describes a Sync configuration for a resolver.
         Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        """
        conflict_detection: pulumi.Input[builtins.str]
        """
        The Conflict Detection strategy to use.
          +  *VERSION*: Detect conflicts based on object versions for this resolver.
          +  *NONE*: Do not detect conflicts when invoking this resolver.
        """
        conflict_handler: NotRequired[pulumi.Input[builtins.str]]
        """
        The Conflict Resolution strategy to perform in the event of a conflict.
          +  *OPTIMISTIC_CONCURRENCY*: Resolve conflicts by rejecting mutations when versions don't match the latest version at the server.
          +  *AUTOMERGE*: Resolve conflicts with the Automerge conflict resolution strategy.
          +  *LAMBDA*: Resolve conflicts with an LAMlong function supplied in the ``LambdaConflictHandlerConfig``.
        """
        lambda_conflict_handler_config: NotRequired[pulumi.Input['ResolverLambdaConflictHandlerConfigArgsDict']]
        """
        The ``LambdaConflictHandlerConfig`` when configuring ``LAMBDA`` as the Conflict Handler.
        """
elif False:
    ResolverSyncConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverSyncConfigArgs:
    def __init__(__self__, *,
                 conflict_detection: pulumi.Input[builtins.str],
                 conflict_handler: Optional[pulumi.Input[builtins.str]] = None,
                 lambda_conflict_handler_config: Optional[pulumi.Input['ResolverLambdaConflictHandlerConfigArgs']] = None):
        """
        Describes a Sync configuration for a resolver.
         Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        :param pulumi.Input[builtins.str] conflict_detection: The Conflict Detection strategy to use.
                 +  *VERSION*: Detect conflicts based on object versions for this resolver.
                 +  *NONE*: Do not detect conflicts when invoking this resolver.
        :param pulumi.Input[builtins.str] conflict_handler: The Conflict Resolution strategy to perform in the event of a conflict.
                 +  *OPTIMISTIC_CONCURRENCY*: Resolve conflicts by rejecting mutations when versions don't match the latest version at the server.
                 +  *AUTOMERGE*: Resolve conflicts with the Automerge conflict resolution strategy.
                 +  *LAMBDA*: Resolve conflicts with an LAMlong function supplied in the ``LambdaConflictHandlerConfig``.
        :param pulumi.Input['ResolverLambdaConflictHandlerConfigArgs'] lambda_conflict_handler_config: The ``LambdaConflictHandlerConfig`` when configuring ``LAMBDA`` as the Conflict Handler.
        """
        pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> pulumi.Input[builtins.str]:
        """
        The Conflict Detection strategy to use.
          +  *VERSION*: Detect conflicts based on object versions for this resolver.
          +  *NONE*: Do not detect conflicts when invoking this resolver.
        """
        return pulumi.get(self, "conflict_detection")

    @conflict_detection.setter
    def conflict_detection(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "conflict_detection", value)

    @property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Conflict Resolution strategy to perform in the event of a conflict.
          +  *OPTIMISTIC_CONCURRENCY*: Resolve conflicts by rejecting mutations when versions don't match the latest version at the server.
          +  *AUTOMERGE*: Resolve conflicts with the Automerge conflict resolution strategy.
          +  *LAMBDA*: Resolve conflicts with an LAMlong function supplied in the ``LambdaConflictHandlerConfig``.
        """
        return pulumi.get(self, "conflict_handler")

    @conflict_handler.setter
    def conflict_handler(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "conflict_handler", value)

    @property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional[pulumi.Input['ResolverLambdaConflictHandlerConfigArgs']]:
        """
        The ``LambdaConflictHandlerConfig`` when configuring ``LAMBDA`` as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")

    @lambda_conflict_handler_config.setter
    def lambda_conflict_handler_config(self, value: Optional[pulumi.Input['ResolverLambdaConflictHandlerConfigArgs']]):
        pulumi.set(self, "lambda_conflict_handler_config", value)


if not MYPY:
    class SourceApiAssociationConfigArgsDict(TypedDict):
        merge_type: NotRequired[pulumi.Input['SourceApiAssociationConfigMergeType']]
        """
        Configuration of the merged behavior for the association. For example when it could be auto or has to be manual.
        """
elif False:
    SourceApiAssociationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SourceApiAssociationConfigArgs:
    def __init__(__self__, *,
                 merge_type: Optional[pulumi.Input['SourceApiAssociationConfigMergeType']] = None):
        """
        :param pulumi.Input['SourceApiAssociationConfigMergeType'] merge_type: Configuration of the merged behavior for the association. For example when it could be auto or has to be manual.
        """
        if merge_type is not None:
            pulumi.set(__self__, "merge_type", merge_type)

    @property
    @pulumi.getter(name="mergeType")
    def merge_type(self) -> Optional[pulumi.Input['SourceApiAssociationConfigMergeType']]:
        """
        Configuration of the merged behavior for the association. For example when it could be auto or has to be manual.
        """
        return pulumi.get(self, "merge_type")

    @merge_type.setter
    def merge_type(self, value: Optional[pulumi.Input['SourceApiAssociationConfigMergeType']]):
        pulumi.set(self, "merge_type", value)


