# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['VpcIngressConnectionArgs', 'VpcIngressConnection']

@pulumi.input_type
class VpcIngressConnectionArgs:
    def __init__(__self__, *,
                 ingress_vpc_configuration: pulumi.Input['VpcIngressConnectionIngressVpcConfigurationArgs'],
                 service_arn: pulumi.Input[builtins.str],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]] = None,
                 vpc_ingress_connection_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VpcIngressConnection resource.
        :param pulumi.Input['VpcIngressConnectionIngressVpcConfigurationArgs'] ingress_vpc_configuration: Specifications for the customer’s Amazon VPC and the related AWS PrivateLink VPC endpoint that are used to create the VPC Ingress Connection resource.
        :param pulumi.Input[builtins.str] service_arn: The Amazon Resource Name (ARN) of the service.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]] tags: An optional list of metadata items that you can associate with the VPC Ingress Connection resource. A tag is a key-value pair.
        :param pulumi.Input[builtins.str] vpc_ingress_connection_name: The customer-provided Vpc Ingress Connection name.
        """
        pulumi.set(__self__, "ingress_vpc_configuration", ingress_vpc_configuration)
        pulumi.set(__self__, "service_arn", service_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_ingress_connection_name is not None:
            pulumi.set(__self__, "vpc_ingress_connection_name", vpc_ingress_connection_name)

    @property
    @pulumi.getter(name="ingressVpcConfiguration")
    def ingress_vpc_configuration(self) -> pulumi.Input['VpcIngressConnectionIngressVpcConfigurationArgs']:
        """
        Specifications for the customer’s Amazon VPC and the related AWS PrivateLink VPC endpoint that are used to create the VPC Ingress Connection resource.
        """
        return pulumi.get(self, "ingress_vpc_configuration")

    @ingress_vpc_configuration.setter
    def ingress_vpc_configuration(self, value: pulumi.Input['VpcIngressConnectionIngressVpcConfigurationArgs']):
        pulumi.set(self, "ingress_vpc_configuration", value)

    @property
    @pulumi.getter(name="serviceArn")
    def service_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the service.
        """
        return pulumi.get(self, "service_arn")

    @service_arn.setter
    def service_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]:
        """
        An optional list of metadata items that you can associate with the VPC Ingress Connection resource. A tag is a key-value pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcIngressConnectionName")
    def vpc_ingress_connection_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The customer-provided Vpc Ingress Connection name.
        """
        return pulumi.get(self, "vpc_ingress_connection_name")

    @vpc_ingress_connection_name.setter
    def vpc_ingress_connection_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_ingress_connection_name", value)


@pulumi.type_token("aws-native:apprunner:VpcIngressConnection")
class VpcIngressConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingress_vpc_configuration: Optional[pulumi.Input[Union['VpcIngressConnectionIngressVpcConfigurationArgs', 'VpcIngressConnectionIngressVpcConfigurationArgsDict']]] = None,
                 service_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 vpc_ingress_connection_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The AWS::AppRunner::VpcIngressConnection resource is an App Runner resource that specifies an App Runner VpcIngressConnection.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VpcIngressConnectionIngressVpcConfigurationArgs', 'VpcIngressConnectionIngressVpcConfigurationArgsDict']] ingress_vpc_configuration: Specifications for the customer’s Amazon VPC and the related AWS PrivateLink VPC endpoint that are used to create the VPC Ingress Connection resource.
        :param pulumi.Input[builtins.str] service_arn: The Amazon Resource Name (ARN) of the service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]] tags: An optional list of metadata items that you can associate with the VPC Ingress Connection resource. A tag is a key-value pair.
        :param pulumi.Input[builtins.str] vpc_ingress_connection_name: The customer-provided Vpc Ingress Connection name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcIngressConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::AppRunner::VpcIngressConnection resource is an App Runner resource that specifies an App Runner VpcIngressConnection.

        :param str resource_name: The name of the resource.
        :param VpcIngressConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcIngressConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingress_vpc_configuration: Optional[pulumi.Input[Union['VpcIngressConnectionIngressVpcConfigurationArgs', 'VpcIngressConnectionIngressVpcConfigurationArgsDict']]] = None,
                 service_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 vpc_ingress_connection_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcIngressConnectionArgs.__new__(VpcIngressConnectionArgs)

            if ingress_vpc_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'ingress_vpc_configuration'")
            __props__.__dict__["ingress_vpc_configuration"] = ingress_vpc_configuration
            if service_arn is None and not opts.urn:
                raise TypeError("Missing required property 'service_arn'")
            __props__.__dict__["service_arn"] = service_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_ingress_connection_name"] = vpc_ingress_connection_name
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vpc_ingress_connection_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["serviceArn", "tags[*]", "vpcIngressConnectionName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(VpcIngressConnection, __self__).__init__(
            'aws-native:apprunner:VpcIngressConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VpcIngressConnection':
        """
        Get an existing VpcIngressConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VpcIngressConnectionArgs.__new__(VpcIngressConnectionArgs)

        __props__.__dict__["domain_name"] = None
        __props__.__dict__["ingress_vpc_configuration"] = None
        __props__.__dict__["service_arn"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["vpc_ingress_connection_arn"] = None
        __props__.__dict__["vpc_ingress_connection_name"] = None
        return VpcIngressConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[builtins.str]:
        """
        The Domain name associated with the VPC Ingress Connection.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="ingressVpcConfiguration")
    def ingress_vpc_configuration(self) -> pulumi.Output['outputs.VpcIngressConnectionIngressVpcConfiguration']:
        """
        Specifications for the customer’s Amazon VPC and the related AWS PrivateLink VPC endpoint that are used to create the VPC Ingress Connection resource.
        """
        return pulumi.get(self, "ingress_vpc_configuration")

    @property
    @pulumi.getter(name="serviceArn")
    def service_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the service.
        """
        return pulumi.get(self, "service_arn")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['VpcIngressConnectionStatus']:
        """
        The current status of the VpcIngressConnection.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.CreateOnlyTag']]]:
        """
        An optional list of metadata items that you can associate with the VPC Ingress Connection resource. A tag is a key-value pair.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcIngressConnectionArn")
    def vpc_ingress_connection_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the VpcIngressConnection.
        """
        return pulumi.get(self, "vpc_ingress_connection_arn")

    @property
    @pulumi.getter(name="vpcIngressConnectionName")
    def vpc_ingress_connection_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The customer-provided Vpc Ingress Connection name.
        """
        return pulumi.get(self, "vpc_ingress_connection_name")

