# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ObservabilityConfigurationTraceConfiguration',
    'ServiceAuthenticationConfiguration',
    'ServiceCodeConfiguration',
    'ServiceCodeConfigurationValues',
    'ServiceCodeRepository',
    'ServiceEgressConfiguration',
    'ServiceEncryptionConfiguration',
    'ServiceHealthCheckConfiguration',
    'ServiceImageConfiguration',
    'ServiceImageRepository',
    'ServiceIngressConfiguration',
    'ServiceInstanceConfiguration',
    'ServiceKeyValuePair',
    'ServiceNetworkConfiguration',
    'ServiceObservabilityConfiguration',
    'ServiceSourceCodeVersion',
    'ServiceSourceConfiguration',
    'VpcIngressConnectionIngressVpcConfiguration',
]

@pulumi.output_type
class ObservabilityConfigurationTraceConfiguration(dict):
    """
    Describes the configuration of the tracing feature within an AWS App Runner observability configuration.
    """
    def __init__(__self__, *,
                 vendor: 'ObservabilityConfigurationTraceConfigurationVendor'):
        """
        Describes the configuration of the tracing feature within an AWS App Runner observability configuration.
        :param 'ObservabilityConfigurationTraceConfigurationVendor' vendor: The implementation provider chosen for tracing App Runner services.
        """
        pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter
    def vendor(self) -> 'ObservabilityConfigurationTraceConfigurationVendor':
        """
        The implementation provider chosen for tracing App Runner services.
        """
        return pulumi.get(self, "vendor")


@pulumi.output_type
class ServiceAuthenticationConfiguration(dict):
    """
    Authentication Configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessRoleArn":
            suggest = "access_role_arn"
        elif key == "connectionArn":
            suggest = "connection_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAuthenticationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAuthenticationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAuthenticationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_role_arn: Optional[builtins.str] = None,
                 connection_arn: Optional[builtins.str] = None):
        """
        Authentication Configuration
        :param builtins.str access_role_arn: Access Role Arn
        :param builtins.str connection_arn: Connection Arn
        """
        if access_role_arn is not None:
            pulumi.set(__self__, "access_role_arn", access_role_arn)
        if connection_arn is not None:
            pulumi.set(__self__, "connection_arn", connection_arn)

    @property
    @pulumi.getter(name="accessRoleArn")
    def access_role_arn(self) -> Optional[builtins.str]:
        """
        Access Role Arn
        """
        return pulumi.get(self, "access_role_arn")

    @property
    @pulumi.getter(name="connectionArn")
    def connection_arn(self) -> Optional[builtins.str]:
        """
        Connection Arn
        """
        return pulumi.get(self, "connection_arn")


@pulumi.output_type
class ServiceCodeConfiguration(dict):
    """
    Code Configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationSource":
            suggest = "configuration_source"
        elif key == "codeConfigurationValues":
            suggest = "code_configuration_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_source: 'ServiceCodeConfigurationConfigurationSource',
                 code_configuration_values: Optional['outputs.ServiceCodeConfigurationValues'] = None):
        """
        Code Configuration
        :param 'ServiceCodeConfigurationConfigurationSource' configuration_source: Configuration Source
        :param 'ServiceCodeConfigurationValues' code_configuration_values: The basic configuration for building and running the App Runner service. Use it to quickly launch an App Runner service without providing a `apprunner.yaml` file in the source code repository (or ignoring the file if it exists).
        """
        pulumi.set(__self__, "configuration_source", configuration_source)
        if code_configuration_values is not None:
            pulumi.set(__self__, "code_configuration_values", code_configuration_values)

    @property
    @pulumi.getter(name="configurationSource")
    def configuration_source(self) -> 'ServiceCodeConfigurationConfigurationSource':
        """
        Configuration Source
        """
        return pulumi.get(self, "configuration_source")

    @property
    @pulumi.getter(name="codeConfigurationValues")
    def code_configuration_values(self) -> Optional['outputs.ServiceCodeConfigurationValues']:
        """
        The basic configuration for building and running the App Runner service. Use it to quickly launch an App Runner service without providing a `apprunner.yaml` file in the source code repository (or ignoring the file if it exists).
        """
        return pulumi.get(self, "code_configuration_values")


@pulumi.output_type
class ServiceCodeConfigurationValues(dict):
    """
    Code Configuration Values
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildCommand":
            suggest = "build_command"
        elif key == "runtimeEnvironmentSecrets":
            suggest = "runtime_environment_secrets"
        elif key == "runtimeEnvironmentVariables":
            suggest = "runtime_environment_variables"
        elif key == "startCommand":
            suggest = "start_command"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCodeConfigurationValues. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCodeConfigurationValues.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCodeConfigurationValues.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 runtime: 'ServiceCodeConfigurationValuesRuntime',
                 build_command: Optional[builtins.str] = None,
                 port: Optional[builtins.str] = None,
                 runtime_environment_secrets: Optional[Sequence['outputs.ServiceKeyValuePair']] = None,
                 runtime_environment_variables: Optional[Sequence['outputs.ServiceKeyValuePair']] = None,
                 start_command: Optional[builtins.str] = None):
        """
        Code Configuration Values
        :param 'ServiceCodeConfigurationValuesRuntime' runtime: Runtime
        :param builtins.str build_command: Build Command
        :param builtins.str port: Port
        :param Sequence['ServiceKeyValuePair'] runtime_environment_secrets: The secrets and parameters that get referenced by your service as environment variables
        :param Sequence['ServiceKeyValuePair'] runtime_environment_variables: The environment variables that are available to your running AWS App Runner service. An array of key-value pairs.
        :param builtins.str start_command: Start Command
        """
        pulumi.set(__self__, "runtime", runtime)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if runtime_environment_secrets is not None:
            pulumi.set(__self__, "runtime_environment_secrets", runtime_environment_secrets)
        if runtime_environment_variables is not None:
            pulumi.set(__self__, "runtime_environment_variables", runtime_environment_variables)
        if start_command is not None:
            pulumi.set(__self__, "start_command", start_command)

    @property
    @pulumi.getter
    def runtime(self) -> 'ServiceCodeConfigurationValuesRuntime':
        """
        Runtime
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[builtins.str]:
        """
        Build Command
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.str]:
        """
        Port
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="runtimeEnvironmentSecrets")
    def runtime_environment_secrets(self) -> Optional[Sequence['outputs.ServiceKeyValuePair']]:
        """
        The secrets and parameters that get referenced by your service as environment variables
        """
        return pulumi.get(self, "runtime_environment_secrets")

    @property
    @pulumi.getter(name="runtimeEnvironmentVariables")
    def runtime_environment_variables(self) -> Optional[Sequence['outputs.ServiceKeyValuePair']]:
        """
        The environment variables that are available to your running AWS App Runner service. An array of key-value pairs.
        """
        return pulumi.get(self, "runtime_environment_variables")

    @property
    @pulumi.getter(name="startCommand")
    def start_command(self) -> Optional[builtins.str]:
        """
        Start Command
        """
        return pulumi.get(self, "start_command")


@pulumi.output_type
class ServiceCodeRepository(dict):
    """
    Source Code Repository
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryUrl":
            suggest = "repository_url"
        elif key == "sourceCodeVersion":
            suggest = "source_code_version"
        elif key == "codeConfiguration":
            suggest = "code_configuration"
        elif key == "sourceDirectory":
            suggest = "source_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCodeRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCodeRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCodeRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_url: builtins.str,
                 source_code_version: 'outputs.ServiceSourceCodeVersion',
                 code_configuration: Optional['outputs.ServiceCodeConfiguration'] = None,
                 source_directory: Optional[builtins.str] = None):
        """
        Source Code Repository
        :param builtins.str repository_url: Repository Url
        :param 'ServiceSourceCodeVersion' source_code_version: The version that should be used within the source code repository.
        :param 'ServiceCodeConfiguration' code_configuration: Configuration for building and running the service from a source code repository.
               
               > `CodeConfiguration` is required only for `CreateService` request.
        :param builtins.str source_directory: Source Directory
        """
        pulumi.set(__self__, "repository_url", repository_url)
        pulumi.set(__self__, "source_code_version", source_code_version)
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if source_directory is not None:
            pulumi.set(__self__, "source_directory", source_directory)

    @property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> builtins.str:
        """
        Repository Url
        """
        return pulumi.get(self, "repository_url")

    @property
    @pulumi.getter(name="sourceCodeVersion")
    def source_code_version(self) -> 'outputs.ServiceSourceCodeVersion':
        """
        The version that should be used within the source code repository.
        """
        return pulumi.get(self, "source_code_version")

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional['outputs.ServiceCodeConfiguration']:
        """
        Configuration for building and running the service from a source code repository.

        > `CodeConfiguration` is required only for `CreateService` request.
        """
        return pulumi.get(self, "code_configuration")

    @property
    @pulumi.getter(name="sourceDirectory")
    def source_directory(self) -> Optional[builtins.str]:
        """
        Source Directory
        """
        return pulumi.get(self, "source_directory")


@pulumi.output_type
class ServiceEgressConfiguration(dict):
    """
    Network egress configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "egressType":
            suggest = "egress_type"
        elif key == "vpcConnectorArn":
            suggest = "vpc_connector_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEgressConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEgressConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEgressConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress_type: 'ServiceEgressConfigurationEgressType',
                 vpc_connector_arn: Optional[builtins.str] = None):
        """
        Network egress configuration
        :param 'ServiceEgressConfigurationEgressType' egress_type: Network egress type.
        :param builtins.str vpc_connector_arn: The Amazon Resource Name (ARN) of the App Runner VpcConnector.
        """
        pulumi.set(__self__, "egress_type", egress_type)
        if vpc_connector_arn is not None:
            pulumi.set(__self__, "vpc_connector_arn", vpc_connector_arn)

    @property
    @pulumi.getter(name="egressType")
    def egress_type(self) -> 'ServiceEgressConfigurationEgressType':
        """
        Network egress type.
        """
        return pulumi.get(self, "egress_type")

    @property
    @pulumi.getter(name="vpcConnectorArn")
    def vpc_connector_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the App Runner VpcConnector.
        """
        return pulumi.get(self, "vpc_connector_arn")


@pulumi.output_type
class ServiceEncryptionConfiguration(dict):
    """
    Encryption configuration (KMS key)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key: builtins.str):
        """
        Encryption configuration (KMS key)
        :param builtins.str kms_key: The KMS Key
        """
        pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> builtins.str:
        """
        The KMS Key
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class ServiceHealthCheckConfiguration(dict):
    """
    Health check configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceHealthCheckConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceHealthCheckConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceHealthCheckConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 healthy_threshold: Optional[builtins.int] = None,
                 interval: Optional[builtins.int] = None,
                 path: Optional[builtins.str] = None,
                 protocol: Optional['ServiceHealthCheckConfigurationProtocol'] = None,
                 timeout: Optional[builtins.int] = None,
                 unhealthy_threshold: Optional[builtins.int] = None):
        """
        Health check configuration
        :param builtins.int healthy_threshold: Health check Healthy Threshold
        :param builtins.int interval: Health check Interval
        :param builtins.str path: Health check Path
        :param 'ServiceHealthCheckConfigurationProtocol' protocol: Health Check Protocol
        :param builtins.int timeout: Health check Timeout
        :param builtins.int unhealthy_threshold: Health check Unhealthy Threshold
        """
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[builtins.int]:
        """
        Health check Healthy Threshold
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter
    def interval(self) -> Optional[builtins.int]:
        """
        Health check Interval
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        Health check Path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def protocol(self) -> Optional['ServiceHealthCheckConfigurationProtocol']:
        """
        Health Check Protocol
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[builtins.int]:
        """
        Health check Timeout
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[builtins.int]:
        """
        Health check Unhealthy Threshold
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class ServiceImageConfiguration(dict):
    """
    Image Configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeEnvironmentSecrets":
            suggest = "runtime_environment_secrets"
        elif key == "runtimeEnvironmentVariables":
            suggest = "runtime_environment_variables"
        elif key == "startCommand":
            suggest = "start_command"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceImageConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceImageConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceImageConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: Optional[builtins.str] = None,
                 runtime_environment_secrets: Optional[Sequence['outputs.ServiceKeyValuePair']] = None,
                 runtime_environment_variables: Optional[Sequence['outputs.ServiceKeyValuePair']] = None,
                 start_command: Optional[builtins.str] = None):
        """
        Image Configuration
        :param builtins.str port: Port
        :param Sequence['ServiceKeyValuePair'] runtime_environment_secrets: The secrets and parameters that get referenced by your service as environment variables
        :param Sequence['ServiceKeyValuePair'] runtime_environment_variables: Environment variables that are available to your running App Runner service. An array of key-value pairs.
        :param builtins.str start_command: Start Command
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if runtime_environment_secrets is not None:
            pulumi.set(__self__, "runtime_environment_secrets", runtime_environment_secrets)
        if runtime_environment_variables is not None:
            pulumi.set(__self__, "runtime_environment_variables", runtime_environment_variables)
        if start_command is not None:
            pulumi.set(__self__, "start_command", start_command)

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.str]:
        """
        Port
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="runtimeEnvironmentSecrets")
    def runtime_environment_secrets(self) -> Optional[Sequence['outputs.ServiceKeyValuePair']]:
        """
        The secrets and parameters that get referenced by your service as environment variables
        """
        return pulumi.get(self, "runtime_environment_secrets")

    @property
    @pulumi.getter(name="runtimeEnvironmentVariables")
    def runtime_environment_variables(self) -> Optional[Sequence['outputs.ServiceKeyValuePair']]:
        """
        Environment variables that are available to your running App Runner service. An array of key-value pairs.
        """
        return pulumi.get(self, "runtime_environment_variables")

    @property
    @pulumi.getter(name="startCommand")
    def start_command(self) -> Optional[builtins.str]:
        """
        Start Command
        """
        return pulumi.get(self, "start_command")


@pulumi.output_type
class ServiceImageRepository(dict):
    """
    Image Repository
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageIdentifier":
            suggest = "image_identifier"
        elif key == "imageRepositoryType":
            suggest = "image_repository_type"
        elif key == "imageConfiguration":
            suggest = "image_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceImageRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceImageRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceImageRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_identifier: builtins.str,
                 image_repository_type: 'ServiceImageRepositoryImageRepositoryType',
                 image_configuration: Optional['outputs.ServiceImageConfiguration'] = None):
        """
        Image Repository
        :param builtins.str image_identifier: Image Identifier
        :param 'ServiceImageRepositoryImageRepositoryType' image_repository_type: Image Repository Type
        :param 'ServiceImageConfiguration' image_configuration: Configuration for running the identified image.
        """
        pulumi.set(__self__, "image_identifier", image_identifier)
        pulumi.set(__self__, "image_repository_type", image_repository_type)
        if image_configuration is not None:
            pulumi.set(__self__, "image_configuration", image_configuration)

    @property
    @pulumi.getter(name="imageIdentifier")
    def image_identifier(self) -> builtins.str:
        """
        Image Identifier
        """
        return pulumi.get(self, "image_identifier")

    @property
    @pulumi.getter(name="imageRepositoryType")
    def image_repository_type(self) -> 'ServiceImageRepositoryImageRepositoryType':
        """
        Image Repository Type
        """
        return pulumi.get(self, "image_repository_type")

    @property
    @pulumi.getter(name="imageConfiguration")
    def image_configuration(self) -> Optional['outputs.ServiceImageConfiguration']:
        """
        Configuration for running the identified image.
        """
        return pulumi.get(self, "image_configuration")


@pulumi.output_type
class ServiceIngressConfiguration(dict):
    """
    Network ingress configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPubliclyAccessible":
            suggest = "is_publicly_accessible"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceIngressConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceIngressConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceIngressConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_publicly_accessible: builtins.bool):
        """
        Network ingress configuration
        :param builtins.bool is_publicly_accessible: It's set to true if the Apprunner service is publicly accessible. It's set to false otherwise.
        """
        pulumi.set(__self__, "is_publicly_accessible", is_publicly_accessible)

    @property
    @pulumi.getter(name="isPubliclyAccessible")
    def is_publicly_accessible(self) -> builtins.bool:
        """
        It's set to true if the Apprunner service is publicly accessible. It's set to false otherwise.
        """
        return pulumi.get(self, "is_publicly_accessible")


@pulumi.output_type
class ServiceInstanceConfiguration(dict):
    """
    Instance Configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceRoleArn":
            suggest = "instance_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceInstanceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceInstanceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceInstanceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: Optional[builtins.str] = None,
                 instance_role_arn: Optional[builtins.str] = None,
                 memory: Optional[builtins.str] = None):
        """
        Instance Configuration
        :param builtins.str cpu: CPU
        :param builtins.str instance_role_arn: Instance Role Arn
        :param builtins.str memory: Memory
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if instance_role_arn is not None:
            pulumi.set(__self__, "instance_role_arn", instance_role_arn)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[builtins.str]:
        """
        CPU
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="instanceRoleArn")
    def instance_role_arn(self) -> Optional[builtins.str]:
        """
        Instance Role Arn
        """
        return pulumi.get(self, "instance_role_arn")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.str]:
        """
        Memory
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class ServiceKeyValuePair(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The key name string to map to a value.
        :param builtins.str value: The value string to which the key name is mapped.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The key name string to map to a value.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value string to which the key name is mapped.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceNetworkConfiguration(dict):
    """
    Network configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "egressConfiguration":
            suggest = "egress_configuration"
        elif key == "ingressConfiguration":
            suggest = "ingress_configuration"
        elif key == "ipAddressType":
            suggest = "ip_address_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress_configuration: Optional['outputs.ServiceEgressConfiguration'] = None,
                 ingress_configuration: Optional['outputs.ServiceIngressConfiguration'] = None,
                 ip_address_type: Optional['ServiceNetworkConfigurationIpAddressType'] = None):
        """
        Network configuration
        :param 'ServiceEgressConfiguration' egress_configuration: Network configuration settings for outbound message traffic.
        :param 'ServiceIngressConfiguration' ingress_configuration: Network configuration settings for inbound message traffic.
        :param 'ServiceNetworkConfigurationIpAddressType' ip_address_type: App Runner service endpoint IP address type
        """
        if egress_configuration is not None:
            pulumi.set(__self__, "egress_configuration", egress_configuration)
        if ingress_configuration is not None:
            pulumi.set(__self__, "ingress_configuration", ingress_configuration)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)

    @property
    @pulumi.getter(name="egressConfiguration")
    def egress_configuration(self) -> Optional['outputs.ServiceEgressConfiguration']:
        """
        Network configuration settings for outbound message traffic.
        """
        return pulumi.get(self, "egress_configuration")

    @property
    @pulumi.getter(name="ingressConfiguration")
    def ingress_configuration(self) -> Optional['outputs.ServiceIngressConfiguration']:
        """
        Network configuration settings for inbound message traffic.
        """
        return pulumi.get(self, "ingress_configuration")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional['ServiceNetworkConfigurationIpAddressType']:
        """
        App Runner service endpoint IP address type
        """
        return pulumi.get(self, "ip_address_type")


@pulumi.output_type
class ServiceObservabilityConfiguration(dict):
    """
    Service observability configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "observabilityEnabled":
            suggest = "observability_enabled"
        elif key == "observabilityConfigurationArn":
            suggest = "observability_configuration_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceObservabilityConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceObservabilityConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceObservabilityConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 observability_enabled: builtins.bool,
                 observability_configuration_arn: Optional[builtins.str] = None):
        """
        Service observability configuration
        :param builtins.bool observability_enabled: Observability enabled
        :param builtins.str observability_configuration_arn: The Amazon Resource Name (ARN) of the App Runner ObservabilityConfiguration.
        """
        pulumi.set(__self__, "observability_enabled", observability_enabled)
        if observability_configuration_arn is not None:
            pulumi.set(__self__, "observability_configuration_arn", observability_configuration_arn)

    @property
    @pulumi.getter(name="observabilityEnabled")
    def observability_enabled(self) -> builtins.bool:
        """
        Observability enabled
        """
        return pulumi.get(self, "observability_enabled")

    @property
    @pulumi.getter(name="observabilityConfigurationArn")
    def observability_configuration_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the App Runner ObservabilityConfiguration.
        """
        return pulumi.get(self, "observability_configuration_arn")


@pulumi.output_type
class ServiceSourceCodeVersion(dict):
    """
    Source Code Version
    """
    def __init__(__self__, *,
                 type: 'ServiceSourceCodeVersionType',
                 value: builtins.str):
        """
        Source Code Version
        :param 'ServiceSourceCodeVersionType' type: Source Code Version Type
        :param builtins.str value: Source Code Version Value
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> 'ServiceSourceCodeVersionType':
        """
        Source Code Version Type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Source Code Version Value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceSourceConfiguration(dict):
    """
    Source Code configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationConfiguration":
            suggest = "authentication_configuration"
        elif key == "autoDeploymentsEnabled":
            suggest = "auto_deployments_enabled"
        elif key == "codeRepository":
            suggest = "code_repository"
        elif key == "imageRepository":
            suggest = "image_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_configuration: Optional['outputs.ServiceAuthenticationConfiguration'] = None,
                 auto_deployments_enabled: Optional[builtins.bool] = None,
                 code_repository: Optional['outputs.ServiceCodeRepository'] = None,
                 image_repository: Optional['outputs.ServiceImageRepository'] = None):
        """
        Source Code configuration
        :param 'ServiceAuthenticationConfiguration' authentication_configuration: Describes the resources that are needed to authenticate access to some source repositories.
        :param builtins.bool auto_deployments_enabled: Auto Deployment enabled
        :param 'ServiceCodeRepository' code_repository: The description of a source code repository.
               
               You must provide either this member or `ImageRepository` (but not both).
        :param 'ServiceImageRepository' image_repository: The description of a source image repository.
               
               You must provide either this member or `CodeRepository` (but not both).
        """
        if authentication_configuration is not None:
            pulumi.set(__self__, "authentication_configuration", authentication_configuration)
        if auto_deployments_enabled is not None:
            pulumi.set(__self__, "auto_deployments_enabled", auto_deployments_enabled)
        if code_repository is not None:
            pulumi.set(__self__, "code_repository", code_repository)
        if image_repository is not None:
            pulumi.set(__self__, "image_repository", image_repository)

    @property
    @pulumi.getter(name="authenticationConfiguration")
    def authentication_configuration(self) -> Optional['outputs.ServiceAuthenticationConfiguration']:
        """
        Describes the resources that are needed to authenticate access to some source repositories.
        """
        return pulumi.get(self, "authentication_configuration")

    @property
    @pulumi.getter(name="autoDeploymentsEnabled")
    def auto_deployments_enabled(self) -> Optional[builtins.bool]:
        """
        Auto Deployment enabled
        """
        return pulumi.get(self, "auto_deployments_enabled")

    @property
    @pulumi.getter(name="codeRepository")
    def code_repository(self) -> Optional['outputs.ServiceCodeRepository']:
        """
        The description of a source code repository.

        You must provide either this member or `ImageRepository` (but not both).
        """
        return pulumi.get(self, "code_repository")

    @property
    @pulumi.getter(name="imageRepository")
    def image_repository(self) -> Optional['outputs.ServiceImageRepository']:
        """
        The description of a source image repository.

        You must provide either this member or `CodeRepository` (but not both).
        """
        return pulumi.get(self, "image_repository")


@pulumi.output_type
class VpcIngressConnectionIngressVpcConfiguration(dict):
    """
    The configuration of customer’s VPC and related VPC endpoint
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcEndpointId":
            suggest = "vpc_endpoint_id"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpcIngressConnectionIngressVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpcIngressConnectionIngressVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpcIngressConnectionIngressVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_endpoint_id: builtins.str,
                 vpc_id: builtins.str):
        """
        The configuration of customer’s VPC and related VPC endpoint
        :param builtins.str vpc_endpoint_id: The ID of the VPC endpoint that your App Runner service connects to.
        :param builtins.str vpc_id: The ID of the VPC that the VPC endpoint is used in.
        """
        pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> builtins.str:
        """
        The ID of the VPC endpoint that your App Runner service connects to.
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        The ID of the VPC that the VPC endpoint is used in.
        """
        return pulumi.get(self, "vpc_id")


