# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAutoScalingConfigurationResult',
    'AwaitableGetAutoScalingConfigurationResult',
    'get_auto_scaling_configuration',
    'get_auto_scaling_configuration_output',
]

@pulumi.output_type
class GetAutoScalingConfigurationResult:
    def __init__(__self__, auto_scaling_configuration_arn=None, auto_scaling_configuration_revision=None, latest=None):
        if auto_scaling_configuration_arn and not isinstance(auto_scaling_configuration_arn, str):
            raise TypeError("Expected argument 'auto_scaling_configuration_arn' to be a str")
        pulumi.set(__self__, "auto_scaling_configuration_arn", auto_scaling_configuration_arn)
        if auto_scaling_configuration_revision and not isinstance(auto_scaling_configuration_revision, int):
            raise TypeError("Expected argument 'auto_scaling_configuration_revision' to be a int")
        pulumi.set(__self__, "auto_scaling_configuration_revision", auto_scaling_configuration_revision)
        if latest and not isinstance(latest, bool):
            raise TypeError("Expected argument 'latest' to be a bool")
        pulumi.set(__self__, "latest", latest)

    @property
    @pulumi.getter(name="autoScalingConfigurationArn")
    def auto_scaling_configuration_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of this auto scaling configuration.
        """
        return pulumi.get(self, "auto_scaling_configuration_arn")

    @property
    @pulumi.getter(name="autoScalingConfigurationRevision")
    def auto_scaling_configuration_revision(self) -> Optional[builtins.int]:
        """
        The revision of this auto scaling configuration. It's unique among all the active configurations ("Status": "ACTIVE") that share the same AutoScalingConfigurationName.
        """
        return pulumi.get(self, "auto_scaling_configuration_revision")

    @property
    @pulumi.getter
    def latest(self) -> Optional[builtins.bool]:
        """
        It's set to true for the configuration with the highest Revision among all configurations that share the same AutoScalingConfigurationName. It's set to false otherwise. App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same capacity for both old and new code.
        """
        return pulumi.get(self, "latest")


class AwaitableGetAutoScalingConfigurationResult(GetAutoScalingConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutoScalingConfigurationResult(
            auto_scaling_configuration_arn=self.auto_scaling_configuration_arn,
            auto_scaling_configuration_revision=self.auto_scaling_configuration_revision,
            latest=self.latest)


def get_auto_scaling_configuration(auto_scaling_configuration_arn: Optional[builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutoScalingConfigurationResult:
    """
    Describes an AWS App Runner automatic configuration resource that enables automatic scaling of instances used to process web requests. You can share an auto scaling configuration across multiple services.


    :param builtins.str auto_scaling_configuration_arn: The Amazon Resource Name (ARN) of this auto scaling configuration.
    """
    __args__ = dict()
    __args__['autoScalingConfigurationArn'] = auto_scaling_configuration_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:apprunner:getAutoScalingConfiguration', __args__, opts=opts, typ=GetAutoScalingConfigurationResult).value

    return AwaitableGetAutoScalingConfigurationResult(
        auto_scaling_configuration_arn=pulumi.get(__ret__, 'auto_scaling_configuration_arn'),
        auto_scaling_configuration_revision=pulumi.get(__ret__, 'auto_scaling_configuration_revision'),
        latest=pulumi.get(__ret__, 'latest'))
def get_auto_scaling_configuration_output(auto_scaling_configuration_arn: Optional[pulumi.Input[builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutoScalingConfigurationResult]:
    """
    Describes an AWS App Runner automatic configuration resource that enables automatic scaling of instances used to process web requests. You can share an auto scaling configuration across multiple services.


    :param builtins.str auto_scaling_configuration_arn: The Amazon Resource Name (ARN) of this auto scaling configuration.
    """
    __args__ = dict()
    __args__['autoScalingConfigurationArn'] = auto_scaling_configuration_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:apprunner:getAutoScalingConfiguration', __args__, opts=opts, typ=GetAutoScalingConfigurationResult)
    return __ret__.apply(lambda __response__: GetAutoScalingConfigurationResult(
        auto_scaling_configuration_arn=pulumi.get(__response__, 'auto_scaling_configuration_arn'),
        auto_scaling_configuration_revision=pulumi.get(__response__, 'auto_scaling_configuration_revision'),
        latest=pulumi.get(__response__, 'latest')))
