# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetServiceLevelObjectiveResult',
    'AwaitableGetServiceLevelObjectiveResult',
    'get_service_level_objective',
    'get_service_level_objective_output',
]

@pulumi.output_type
class GetServiceLevelObjectiveResult:
    def __init__(__self__, arn=None, burn_rate_configurations=None, created_time=None, description=None, evaluation_type=None, exclusion_windows=None, goal=None, last_updated_time=None, request_based_sli=None, sli=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if burn_rate_configurations and not isinstance(burn_rate_configurations, list):
            raise TypeError("Expected argument 'burn_rate_configurations' to be a list")
        pulumi.set(__self__, "burn_rate_configurations", burn_rate_configurations)
        if created_time and not isinstance(created_time, int):
            raise TypeError("Expected argument 'created_time' to be a int")
        pulumi.set(__self__, "created_time", created_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if evaluation_type and not isinstance(evaluation_type, str):
            raise TypeError("Expected argument 'evaluation_type' to be a str")
        pulumi.set(__self__, "evaluation_type", evaluation_type)
        if exclusion_windows and not isinstance(exclusion_windows, list):
            raise TypeError("Expected argument 'exclusion_windows' to be a list")
        pulumi.set(__self__, "exclusion_windows", exclusion_windows)
        if goal and not isinstance(goal, dict):
            raise TypeError("Expected argument 'goal' to be a dict")
        pulumi.set(__self__, "goal", goal)
        if last_updated_time and not isinstance(last_updated_time, int):
            raise TypeError("Expected argument 'last_updated_time' to be a int")
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if request_based_sli and not isinstance(request_based_sli, dict):
            raise TypeError("Expected argument 'request_based_sli' to be a dict")
        pulumi.set(__self__, "request_based_sli", request_based_sli)
        if sli and not isinstance(sli, dict):
            raise TypeError("Expected argument 'sli' to be a dict")
        pulumi.set(__self__, "sli", sli)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of this SLO.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="burnRateConfigurations")
    def burn_rate_configurations(self) -> Optional[Sequence['outputs.ServiceLevelObjectiveBurnRateConfiguration']]:
        """
        Each object in this array defines the length of the look-back window used to calculate one burn rate metric for this SLO. The burn rate measures how fast the service is consuming the error budget, relative to the attainment goal of the SLO.
        """
        return pulumi.get(self, "burn_rate_configurations")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[builtins.int]:
        """
        Epoch time in seconds of the time that this SLO was created
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description for this SLO. Default is 'No description'
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="evaluationType")
    def evaluation_type(self) -> Optional['ServiceLevelObjectiveEvaluationType']:
        """
        Displays whether this is a period-based SLO or a request-based SLO.
        """
        return pulumi.get(self, "evaluation_type")

    @property
    @pulumi.getter(name="exclusionWindows")
    def exclusion_windows(self) -> Optional[Sequence['outputs.ServiceLevelObjectiveExclusionWindow']]:
        """
        The time window to be excluded from the SLO performance metrics.
        """
        return pulumi.get(self, "exclusion_windows")

    @property
    @pulumi.getter
    def goal(self) -> Optional['outputs.ServiceLevelObjectiveGoal']:
        """
        This structure contains the attributes that determine the goal of an SLO. This includes the time period for evaluation and the attainment threshold.
        """
        return pulumi.get(self, "goal")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[builtins.int]:
        """
        Epoch time in seconds of the time that this SLO was most recently updated
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter(name="requestBasedSli")
    def request_based_sli(self) -> Optional['outputs.ServiceLevelObjectiveRequestBasedSli']:
        """
        A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO.
        """
        return pulumi.get(self, "request_based_sli")

    @property
    @pulumi.getter
    def sli(self) -> Optional['outputs.ServiceLevelObjectiveSli']:
        """
        A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO.
        """
        return pulumi.get(self, "sli")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of key-value pairs to associate with the SLO. You can associate as many as 50 tags with an SLO. To be able to associate tags with the SLO when you create the SLO, you must have the cloudwatch:TagResource permission.

        Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
        """
        return pulumi.get(self, "tags")


class AwaitableGetServiceLevelObjectiveResult(GetServiceLevelObjectiveResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceLevelObjectiveResult(
            arn=self.arn,
            burn_rate_configurations=self.burn_rate_configurations,
            created_time=self.created_time,
            description=self.description,
            evaluation_type=self.evaluation_type,
            exclusion_windows=self.exclusion_windows,
            goal=self.goal,
            last_updated_time=self.last_updated_time,
            request_based_sli=self.request_based_sli,
            sli=self.sli,
            tags=self.tags)


def get_service_level_objective(arn: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceLevelObjectiveResult:
    """
    Resource Type definition for AWS::ApplicationSignals::ServiceLevelObjective


    :param builtins.str arn: The ARN of this SLO.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:applicationsignals:getServiceLevelObjective', __args__, opts=opts, typ=GetServiceLevelObjectiveResult).value

    return AwaitableGetServiceLevelObjectiveResult(
        arn=pulumi.get(__ret__, 'arn'),
        burn_rate_configurations=pulumi.get(__ret__, 'burn_rate_configurations'),
        created_time=pulumi.get(__ret__, 'created_time'),
        description=pulumi.get(__ret__, 'description'),
        evaluation_type=pulumi.get(__ret__, 'evaluation_type'),
        exclusion_windows=pulumi.get(__ret__, 'exclusion_windows'),
        goal=pulumi.get(__ret__, 'goal'),
        last_updated_time=pulumi.get(__ret__, 'last_updated_time'),
        request_based_sli=pulumi.get(__ret__, 'request_based_sli'),
        sli=pulumi.get(__ret__, 'sli'),
        tags=pulumi.get(__ret__, 'tags'))
def get_service_level_objective_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceLevelObjectiveResult]:
    """
    Resource Type definition for AWS::ApplicationSignals::ServiceLevelObjective


    :param builtins.str arn: The ARN of this SLO.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:applicationsignals:getServiceLevelObjective', __args__, opts=opts, typ=GetServiceLevelObjectiveResult)
    return __ret__.apply(lambda __response__: GetServiceLevelObjectiveResult(
        arn=pulumi.get(__response__, 'arn'),
        burn_rate_configurations=pulumi.get(__response__, 'burn_rate_configurations'),
        created_time=pulumi.get(__response__, 'created_time'),
        description=pulumi.get(__response__, 'description'),
        evaluation_type=pulumi.get(__response__, 'evaluation_type'),
        exclusion_windows=pulumi.get(__response__, 'exclusion_windows'),
        goal=pulumi.get(__response__, 'goal'),
        last_updated_time=pulumi.get(__response__, 'last_updated_time'),
        request_based_sli=pulumi.get(__response__, 'request_based_sli'),
        sli=pulumi.get(__response__, 'sli'),
        tags=pulumi.get(__response__, 'tags')))
