# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ServiceLevelObjectiveBurnRateConfigurationArgs',
    'ServiceLevelObjectiveBurnRateConfigurationArgsDict',
    'ServiceLevelObjectiveCalendarIntervalArgs',
    'ServiceLevelObjectiveCalendarIntervalArgsDict',
    'ServiceLevelObjectiveDependencyConfigArgs',
    'ServiceLevelObjectiveDependencyConfigArgsDict',
    'ServiceLevelObjectiveDimensionArgs',
    'ServiceLevelObjectiveDimensionArgsDict',
    'ServiceLevelObjectiveExclusionWindowArgs',
    'ServiceLevelObjectiveExclusionWindowArgsDict',
    'ServiceLevelObjectiveGoalArgs',
    'ServiceLevelObjectiveGoalArgsDict',
    'ServiceLevelObjectiveIntervalArgs',
    'ServiceLevelObjectiveIntervalArgsDict',
    'ServiceLevelObjectiveMetricDataQueryArgs',
    'ServiceLevelObjectiveMetricDataQueryArgsDict',
    'ServiceLevelObjectiveMetricStatArgs',
    'ServiceLevelObjectiveMetricStatArgsDict',
    'ServiceLevelObjectiveMetricArgs',
    'ServiceLevelObjectiveMetricArgsDict',
    'ServiceLevelObjectiveMonitoredRequestCountMetricArgs',
    'ServiceLevelObjectiveMonitoredRequestCountMetricArgsDict',
    'ServiceLevelObjectiveRecurrenceRuleArgs',
    'ServiceLevelObjectiveRecurrenceRuleArgsDict',
    'ServiceLevelObjectiveRequestBasedSliMetricArgs',
    'ServiceLevelObjectiveRequestBasedSliMetricArgsDict',
    'ServiceLevelObjectiveRequestBasedSliArgs',
    'ServiceLevelObjectiveRequestBasedSliArgsDict',
    'ServiceLevelObjectiveRollingIntervalArgs',
    'ServiceLevelObjectiveRollingIntervalArgsDict',
    'ServiceLevelObjectiveSliMetricArgs',
    'ServiceLevelObjectiveSliMetricArgsDict',
    'ServiceLevelObjectiveSliArgs',
    'ServiceLevelObjectiveSliArgsDict',
    'ServiceLevelObjectiveWindowArgs',
    'ServiceLevelObjectiveWindowArgsDict',
]

MYPY = False

if not MYPY:
    class ServiceLevelObjectiveBurnRateConfigurationArgsDict(TypedDict):
        """
        This object defines the length of the look-back window used to calculate one burn rate metric for this SLO. The burn rate measures how fast the service is consuming the error budget, relative to the attainment goal of the SLO. A burn rate of exactly 1 indicates that the SLO goal will be met exactly.
        For example, if you specify 60 as the number of minutes in the look-back window, the burn rate is calculated as the following:
        burn rate = error rate over the look-back window / (1 - attainment goal percentage)
        """
        look_back_window_minutes: pulumi.Input[builtins.int]
        """
        The number of minutes to use as the look-back window.
        """
elif False:
    ServiceLevelObjectiveBurnRateConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveBurnRateConfigurationArgs:
    def __init__(__self__, *,
                 look_back_window_minutes: pulumi.Input[builtins.int]):
        """
        This object defines the length of the look-back window used to calculate one burn rate metric for this SLO. The burn rate measures how fast the service is consuming the error budget, relative to the attainment goal of the SLO. A burn rate of exactly 1 indicates that the SLO goal will be met exactly.
        For example, if you specify 60 as the number of minutes in the look-back window, the burn rate is calculated as the following:
        burn rate = error rate over the look-back window / (1 - attainment goal percentage)
        :param pulumi.Input[builtins.int] look_back_window_minutes: The number of minutes to use as the look-back window.
        """
        pulumi.set(__self__, "look_back_window_minutes", look_back_window_minutes)

    @property
    @pulumi.getter(name="lookBackWindowMinutes")
    def look_back_window_minutes(self) -> pulumi.Input[builtins.int]:
        """
        The number of minutes to use as the look-back window.
        """
        return pulumi.get(self, "look_back_window_minutes")

    @look_back_window_minutes.setter
    def look_back_window_minutes(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "look_back_window_minutes", value)


if not MYPY:
    class ServiceLevelObjectiveCalendarIntervalArgsDict(TypedDict):
        """
        If the interval for this service level objective is a calendar interval, this structure contains the interval specifications.
        """
        duration: pulumi.Input[builtins.int]
        """
        Specifies the duration of each calendar interval. For example, if `Duration` is `1` and `DurationUnit` is `MONTH` , each interval is one month, aligned with the calendar.
        """
        duration_unit: pulumi.Input['ServiceLevelObjectiveDurationUnit']
        """
        Specifies the calendar interval unit.
        """
        start_time: pulumi.Input[builtins.int]
        """
        Epoch time in seconds you want the first interval to start. Be sure to choose a time that configures the intervals the way that you want. For example, if you want weekly intervals starting on Mondays at 6 a.m., be sure to specify a start time that is a Monday at 6 a.m.
        As soon as one calendar interval ends, another automatically begins.
        """
elif False:
    ServiceLevelObjectiveCalendarIntervalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveCalendarIntervalArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[builtins.int],
                 duration_unit: pulumi.Input['ServiceLevelObjectiveDurationUnit'],
                 start_time: pulumi.Input[builtins.int]):
        """
        If the interval for this service level objective is a calendar interval, this structure contains the interval specifications.
        :param pulumi.Input[builtins.int] duration: Specifies the duration of each calendar interval. For example, if `Duration` is `1` and `DurationUnit` is `MONTH` , each interval is one month, aligned with the calendar.
        :param pulumi.Input['ServiceLevelObjectiveDurationUnit'] duration_unit: Specifies the calendar interval unit.
        :param pulumi.Input[builtins.int] start_time: Epoch time in seconds you want the first interval to start. Be sure to choose a time that configures the intervals the way that you want. For example, if you want weekly intervals starting on Mondays at 6 a.m., be sure to specify a start time that is a Monday at 6 a.m.
               As soon as one calendar interval ends, another automatically begins.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "duration_unit", duration_unit)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[builtins.int]:
        """
        Specifies the duration of each calendar interval. For example, if `Duration` is `1` and `DurationUnit` is `MONTH` , each interval is one month, aligned with the calendar.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="durationUnit")
    def duration_unit(self) -> pulumi.Input['ServiceLevelObjectiveDurationUnit']:
        """
        Specifies the calendar interval unit.
        """
        return pulumi.get(self, "duration_unit")

    @duration_unit.setter
    def duration_unit(self, value: pulumi.Input['ServiceLevelObjectiveDurationUnit']):
        pulumi.set(self, "duration_unit", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[builtins.int]:
        """
        Epoch time in seconds you want the first interval to start. Be sure to choose a time that configures the intervals the way that you want. For example, if you want weekly intervals starting on Mondays at 6 a.m., be sure to specify a start time that is a Monday at 6 a.m.
        As soon as one calendar interval ends, another automatically begins.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class ServiceLevelObjectiveDependencyConfigArgsDict(TypedDict):
        """
        Configuration for identifying a dependency and its operation
        """
        dependency_key_attributes: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]
        """
        If this SLO is related to a metric collected by Application Signals, you must use this field to specify which dependency the SLO metric is related to.

        - `Type` designates the type of object this is.
        - `ResourceType` specifies the type of the resource. This field is used only when the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Name` specifies the name of the object. This is used only if the value of the `Type` field is `Service` , `RemoteService` , or `AWS::Service` .
        - `Identifier` identifies the resource objects of this resource. This is used only if the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Environment` specifies the location where this object is hosted, or what it belongs to.
        """
        dependency_operation_name: pulumi.Input[builtins.str]
        """
        When the SLO monitors a specific operation of the dependency, this field specifies the name of that operation in the dependency.
        """
elif False:
    ServiceLevelObjectiveDependencyConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveDependencyConfigArgs:
    def __init__(__self__, *,
                 dependency_key_attributes: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]],
                 dependency_operation_name: pulumi.Input[builtins.str]):
        """
        Configuration for identifying a dependency and its operation
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dependency_key_attributes: If this SLO is related to a metric collected by Application Signals, you must use this field to specify which dependency the SLO metric is related to.
               
               - `Type` designates the type of object this is.
               - `ResourceType` specifies the type of the resource. This field is used only when the value of the `Type` field is `Resource` or `AWS::Resource` .
               - `Name` specifies the name of the object. This is used only if the value of the `Type` field is `Service` , `RemoteService` , or `AWS::Service` .
               - `Identifier` identifies the resource objects of this resource. This is used only if the value of the `Type` field is `Resource` or `AWS::Resource` .
               - `Environment` specifies the location where this object is hosted, or what it belongs to.
        :param pulumi.Input[builtins.str] dependency_operation_name: When the SLO monitors a specific operation of the dependency, this field specifies the name of that operation in the dependency.
        """
        pulumi.set(__self__, "dependency_key_attributes", dependency_key_attributes)
        pulumi.set(__self__, "dependency_operation_name", dependency_operation_name)

    @property
    @pulumi.getter(name="dependencyKeyAttributes")
    def dependency_key_attributes(self) -> pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]:
        """
        If this SLO is related to a metric collected by Application Signals, you must use this field to specify which dependency the SLO metric is related to.

        - `Type` designates the type of object this is.
        - `ResourceType` specifies the type of the resource. This field is used only when the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Name` specifies the name of the object. This is used only if the value of the `Type` field is `Service` , `RemoteService` , or `AWS::Service` .
        - `Identifier` identifies the resource objects of this resource. This is used only if the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Environment` specifies the location where this object is hosted, or what it belongs to.
        """
        return pulumi.get(self, "dependency_key_attributes")

    @dependency_key_attributes.setter
    def dependency_key_attributes(self, value: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]):
        pulumi.set(self, "dependency_key_attributes", value)

    @property
    @pulumi.getter(name="dependencyOperationName")
    def dependency_operation_name(self) -> pulumi.Input[builtins.str]:
        """
        When the SLO monitors a specific operation of the dependency, this field specifies the name of that operation in the dependency.
        """
        return pulumi.get(self, "dependency_operation_name")

    @dependency_operation_name.setter
    def dependency_operation_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dependency_operation_name", value)


if not MYPY:
    class ServiceLevelObjectiveDimensionArgsDict(TypedDict):
        """
        A dimension is a name/value pair that is part of the identity of a metric. Because dimensions are part of the unique identifier for a metric, whenever you add a unique name/value pair to one of your metrics, you are creating a new variation of that metric. For example, many Amazon EC2 metrics publish `InstanceId` as a dimension name, and the actual instance ID as the value for that dimension. You can assign up to 30 dimensions to a metric.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the dimension. Dimension names must contain only ASCII characters, must include at least one non-whitespace character, and cannot start with a colon (:). ASCII control characters are not supported as part of dimension names.
        """
        value: pulumi.Input[builtins.str]
        """
        The value of the dimension. Dimension values must contain only ASCII characters and must include at least one non-whitespace character. ASCII control characters are not supported as part of dimension values
        """
elif False:
    ServiceLevelObjectiveDimensionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveDimensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        A dimension is a name/value pair that is part of the identity of a metric. Because dimensions are part of the unique identifier for a metric, whenever you add a unique name/value pair to one of your metrics, you are creating a new variation of that metric. For example, many Amazon EC2 metrics publish `InstanceId` as a dimension name, and the actual instance ID as the value for that dimension. You can assign up to 30 dimensions to a metric.
        :param pulumi.Input[builtins.str] name: The name of the dimension. Dimension names must contain only ASCII characters, must include at least one non-whitespace character, and cannot start with a colon (:). ASCII control characters are not supported as part of dimension names.
        :param pulumi.Input[builtins.str] value: The value of the dimension. Dimension values must contain only ASCII characters and must include at least one non-whitespace character. ASCII control characters are not supported as part of dimension values
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the dimension. Dimension names must contain only ASCII characters, must include at least one non-whitespace character, and cannot start with a colon (:). ASCII control characters are not supported as part of dimension names.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The value of the dimension. Dimension values must contain only ASCII characters and must include at least one non-whitespace character. ASCII control characters are not supported as part of dimension values
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ServiceLevelObjectiveExclusionWindowArgsDict(TypedDict):
        """
        This object defines a time exclusion window for this SLO. The time exclusion window is used to exclude breaching data points from affecting attainment rate, error budget, and burn rate metrics.
        """
        window: pulumi.Input['ServiceLevelObjectiveWindowArgsDict']
        reason: NotRequired[pulumi.Input[builtins.str]]
        """
        An optional reason for scheduling this time exclusion window. Default is 'No reason'.
        """
        recurrence_rule: NotRequired[pulumi.Input['ServiceLevelObjectiveRecurrenceRuleArgsDict']]
        start_time: NotRequired[pulumi.Input[builtins.str]]
        """
        The time you want the exclusion window to start at. Note that time exclusion windows can only be scheduled in the future, not the past.
        """
elif False:
    ServiceLevelObjectiveExclusionWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveExclusionWindowArgs:
    def __init__(__self__, *,
                 window: pulumi.Input['ServiceLevelObjectiveWindowArgs'],
                 reason: Optional[pulumi.Input[builtins.str]] = None,
                 recurrence_rule: Optional[pulumi.Input['ServiceLevelObjectiveRecurrenceRuleArgs']] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        This object defines a time exclusion window for this SLO. The time exclusion window is used to exclude breaching data points from affecting attainment rate, error budget, and burn rate metrics.
        :param pulumi.Input[builtins.str] reason: An optional reason for scheduling this time exclusion window. Default is 'No reason'.
        :param pulumi.Input[builtins.str] start_time: The time you want the exclusion window to start at. Note that time exclusion windows can only be scheduled in the future, not the past.
        """
        pulumi.set(__self__, "window", window)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if recurrence_rule is not None:
            pulumi.set(__self__, "recurrence_rule", recurrence_rule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def window(self) -> pulumi.Input['ServiceLevelObjectiveWindowArgs']:
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: pulumi.Input['ServiceLevelObjectiveWindowArgs']):
        pulumi.set(self, "window", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional reason for scheduling this time exclusion window. Default is 'No reason'.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter(name="recurrenceRule")
    def recurrence_rule(self) -> Optional[pulumi.Input['ServiceLevelObjectiveRecurrenceRuleArgs']]:
        return pulumi.get(self, "recurrence_rule")

    @recurrence_rule.setter
    def recurrence_rule(self, value: Optional[pulumi.Input['ServiceLevelObjectiveRecurrenceRuleArgs']]):
        pulumi.set(self, "recurrence_rule", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time you want the exclusion window to start at. Note that time exclusion windows can only be scheduled in the future, not the past.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class ServiceLevelObjectiveGoalArgsDict(TypedDict):
        """
        A structure that contains the attributes that determine the goal of the SLO. This includes the time period for evaluation and the attainment threshold.
        """
        attainment_goal: NotRequired[pulumi.Input[builtins.float]]
        """
        The threshold that determines if the goal is being met. An attainment goal is the ratio of good periods that meet the threshold requirements to the total periods within the interval. For example, an attainment goal of 99.9% means that within your interval, you are targeting 99.9% of the periods to be in healthy state.
        If you omit this parameter, 99 is used to represent 99% as the attainment goal.
        """
        interval: NotRequired[pulumi.Input['ServiceLevelObjectiveIntervalArgsDict']]
        """
        The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.

        If you omit this parameter, a rolling interval of 7 days is used.
        """
        warning_threshold: NotRequired[pulumi.Input[builtins.float]]
        """
        The percentage of remaining budget over total budget that you want to get warnings for. If you omit this parameter, the default of 50.0 is used.
        """
elif False:
    ServiceLevelObjectiveGoalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveGoalArgs:
    def __init__(__self__, *,
                 attainment_goal: Optional[pulumi.Input[builtins.float]] = None,
                 interval: Optional[pulumi.Input['ServiceLevelObjectiveIntervalArgs']] = None,
                 warning_threshold: Optional[pulumi.Input[builtins.float]] = None):
        """
        A structure that contains the attributes that determine the goal of the SLO. This includes the time period for evaluation and the attainment threshold.
        :param pulumi.Input[builtins.float] attainment_goal: The threshold that determines if the goal is being met. An attainment goal is the ratio of good periods that meet the threshold requirements to the total periods within the interval. For example, an attainment goal of 99.9% means that within your interval, you are targeting 99.9% of the periods to be in healthy state.
               If you omit this parameter, 99 is used to represent 99% as the attainment goal.
        :param pulumi.Input['ServiceLevelObjectiveIntervalArgs'] interval: The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.
               
               If you omit this parameter, a rolling interval of 7 days is used.
        :param pulumi.Input[builtins.float] warning_threshold: The percentage of remaining budget over total budget that you want to get warnings for. If you omit this parameter, the default of 50.0 is used.
        """
        if attainment_goal is not None:
            pulumi.set(__self__, "attainment_goal", attainment_goal)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if warning_threshold is not None:
            pulumi.set(__self__, "warning_threshold", warning_threshold)

    @property
    @pulumi.getter(name="attainmentGoal")
    def attainment_goal(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The threshold that determines if the goal is being met. An attainment goal is the ratio of good periods that meet the threshold requirements to the total periods within the interval. For example, an attainment goal of 99.9% means that within your interval, you are targeting 99.9% of the periods to be in healthy state.
        If you omit this parameter, 99 is used to represent 99% as the attainment goal.
        """
        return pulumi.get(self, "attainment_goal")

    @attainment_goal.setter
    def attainment_goal(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "attainment_goal", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input['ServiceLevelObjectiveIntervalArgs']]:
        """
        The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.

        If you omit this parameter, a rolling interval of 7 days is used.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input['ServiceLevelObjectiveIntervalArgs']]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="warningThreshold")
    def warning_threshold(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The percentage of remaining budget over total budget that you want to get warnings for. If you omit this parameter, the default of 50.0 is used.
        """
        return pulumi.get(self, "warning_threshold")

    @warning_threshold.setter
    def warning_threshold(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "warning_threshold", value)


if not MYPY:
    class ServiceLevelObjectiveIntervalArgsDict(TypedDict):
        """
        The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.
        If you omit this parameter, a rolling interval of 7 days is used.
        """
        calendar_interval: NotRequired[pulumi.Input['ServiceLevelObjectiveCalendarIntervalArgsDict']]
        """
        If the interval is a calendar interval, this structure contains the interval specifications.
        """
        rolling_interval: NotRequired[pulumi.Input['ServiceLevelObjectiveRollingIntervalArgsDict']]
        """
        If the interval is a rolling interval, this structure contains the interval specifications.
        """
elif False:
    ServiceLevelObjectiveIntervalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveIntervalArgs:
    def __init__(__self__, *,
                 calendar_interval: Optional[pulumi.Input['ServiceLevelObjectiveCalendarIntervalArgs']] = None,
                 rolling_interval: Optional[pulumi.Input['ServiceLevelObjectiveRollingIntervalArgs']] = None):
        """
        The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.
        If you omit this parameter, a rolling interval of 7 days is used.
        :param pulumi.Input['ServiceLevelObjectiveCalendarIntervalArgs'] calendar_interval: If the interval is a calendar interval, this structure contains the interval specifications.
        :param pulumi.Input['ServiceLevelObjectiveRollingIntervalArgs'] rolling_interval: If the interval is a rolling interval, this structure contains the interval specifications.
        """
        if calendar_interval is not None:
            pulumi.set(__self__, "calendar_interval", calendar_interval)
        if rolling_interval is not None:
            pulumi.set(__self__, "rolling_interval", rolling_interval)

    @property
    @pulumi.getter(name="calendarInterval")
    def calendar_interval(self) -> Optional[pulumi.Input['ServiceLevelObjectiveCalendarIntervalArgs']]:
        """
        If the interval is a calendar interval, this structure contains the interval specifications.
        """
        return pulumi.get(self, "calendar_interval")

    @calendar_interval.setter
    def calendar_interval(self, value: Optional[pulumi.Input['ServiceLevelObjectiveCalendarIntervalArgs']]):
        pulumi.set(self, "calendar_interval", value)

    @property
    @pulumi.getter(name="rollingInterval")
    def rolling_interval(self) -> Optional[pulumi.Input['ServiceLevelObjectiveRollingIntervalArgs']]:
        """
        If the interval is a rolling interval, this structure contains the interval specifications.
        """
        return pulumi.get(self, "rolling_interval")

    @rolling_interval.setter
    def rolling_interval(self, value: Optional[pulumi.Input['ServiceLevelObjectiveRollingIntervalArgs']]):
        pulumi.set(self, "rolling_interval", value)


if not MYPY:
    class ServiceLevelObjectiveMetricDataQueryArgsDict(TypedDict):
        """
        Use this structure to define a metric or metric math expression that you want to use as for a service level objective.
        Each `MetricDataQuery` in the `MetricDataQueries` array specifies either a metric to retrieve, or a metric math expression to be performed on retrieved metrics. A single `MetricDataQueries` array can include as many as 20 `MetricDataQuery` structures in the array. The 20 structures can include as many as 10 structures that contain a `MetricStat` parameter to retrieve a metric, and as many as 10 structures that contain the `Expression` parameter to perform a math expression. Of those Expression structures, exactly one must have true as the value for `ReturnData`. The result of this expression used for the SLO.
        """
        id: pulumi.Input[builtins.str]
        """
        A short name used to tie this object to the results in the response.
        """
        account_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the account where the metrics are located, if this is a cross-account alarm.
        """
        expression: NotRequired[pulumi.Input[builtins.str]]
        """
        The math expression to be performed on the returned data.
        """
        metric_stat: NotRequired[pulumi.Input['ServiceLevelObjectiveMetricStatArgsDict']]
        """
        A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO. Within one MetricDataQuery, you must specify either Expression or MetricStat but not both.
        """
        return_data: NotRequired[pulumi.Input[builtins.bool]]
        """
        This option indicates whether to return the timestamps and raw data values of this metric.
        """
elif False:
    ServiceLevelObjectiveMetricDataQueryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveMetricDataQueryArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[builtins.str],
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 expression: Optional[pulumi.Input[builtins.str]] = None,
                 metric_stat: Optional[pulumi.Input['ServiceLevelObjectiveMetricStatArgs']] = None,
                 return_data: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Use this structure to define a metric or metric math expression that you want to use as for a service level objective.
        Each `MetricDataQuery` in the `MetricDataQueries` array specifies either a metric to retrieve, or a metric math expression to be performed on retrieved metrics. A single `MetricDataQueries` array can include as many as 20 `MetricDataQuery` structures in the array. The 20 structures can include as many as 10 structures that contain a `MetricStat` parameter to retrieve a metric, and as many as 10 structures that contain the `Expression` parameter to perform a math expression. Of those Expression structures, exactly one must have true as the value for `ReturnData`. The result of this expression used for the SLO.
        :param pulumi.Input[builtins.str] id: A short name used to tie this object to the results in the response.
        :param pulumi.Input[builtins.str] account_id: The ID of the account where the metrics are located, if this is a cross-account alarm.
        :param pulumi.Input[builtins.str] expression: The math expression to be performed on the returned data.
        :param pulumi.Input['ServiceLevelObjectiveMetricStatArgs'] metric_stat: A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO. Within one MetricDataQuery, you must specify either Expression or MetricStat but not both.
        :param pulumi.Input[builtins.bool] return_data: This option indicates whether to return the timestamps and raw data values of this metric.
        """
        pulumi.set(__self__, "id", id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if metric_stat is not None:
            pulumi.set(__self__, "metric_stat", metric_stat)
        if return_data is not None:
            pulumi.set(__self__, "return_data", return_data)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[builtins.str]:
        """
        A short name used to tie this object to the results in the response.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the account where the metrics are located, if this is a cross-account alarm.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The math expression to be performed on the returned data.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter(name="metricStat")
    def metric_stat(self) -> Optional[pulumi.Input['ServiceLevelObjectiveMetricStatArgs']]:
        """
        A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO. Within one MetricDataQuery, you must specify either Expression or MetricStat but not both.
        """
        return pulumi.get(self, "metric_stat")

    @metric_stat.setter
    def metric_stat(self, value: Optional[pulumi.Input['ServiceLevelObjectiveMetricStatArgs']]):
        pulumi.set(self, "metric_stat", value)

    @property
    @pulumi.getter(name="returnData")
    def return_data(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This option indicates whether to return the timestamps and raw data values of this metric.
        """
        return pulumi.get(self, "return_data")

    @return_data.setter
    def return_data(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "return_data", value)


if not MYPY:
    class ServiceLevelObjectiveMetricStatArgsDict(TypedDict):
        """
        A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO. Within one MetricDataQuery object, you must specify either Expression or MetricStat but not both.
        """
        metric: pulumi.Input['ServiceLevelObjectiveMetricArgsDict']
        period: pulumi.Input[builtins.int]
        """
        The granularity, in seconds, to be used for the metric.
        """
        stat: pulumi.Input[builtins.str]
        """
        The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended statistic.
        """
        unit: NotRequired[pulumi.Input[builtins.str]]
        """
        If you omit Unit then all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.
        """
elif False:
    ServiceLevelObjectiveMetricStatArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveMetricStatArgs:
    def __init__(__self__, *,
                 metric: pulumi.Input['ServiceLevelObjectiveMetricArgs'],
                 period: pulumi.Input[builtins.int],
                 stat: pulumi.Input[builtins.str],
                 unit: Optional[pulumi.Input[builtins.str]] = None):
        """
        A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO. Within one MetricDataQuery object, you must specify either Expression or MetricStat but not both.
        :param pulumi.Input[builtins.int] period: The granularity, in seconds, to be used for the metric.
        :param pulumi.Input[builtins.str] stat: The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended statistic.
        :param pulumi.Input[builtins.str] unit: If you omit Unit then all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "stat", stat)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input['ServiceLevelObjectiveMetricArgs']:
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input['ServiceLevelObjectiveMetricArgs']):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def period(self) -> pulumi.Input[builtins.int]:
        """
        The granularity, in seconds, to be used for the metric.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def stat(self) -> pulumi.Input[builtins.str]:
        """
        The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended statistic.
        """
        return pulumi.get(self, "stat")

    @stat.setter
    def stat(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stat", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you omit Unit then all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unit", value)


if not MYPY:
    class ServiceLevelObjectiveMetricArgsDict(TypedDict):
        """
        This structure defines the metric used for a service level indicator, including the metric name, namespace, and dimensions.
        """
        dimensions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveDimensionArgsDict']]]]
        """
        An array of one or more dimensions to use to define the metric that you want to use.
        """
        metric_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the metric to use.
        """
        namespace: NotRequired[pulumi.Input[builtins.str]]
        """
        The namespace of the metric.
        """
elif False:
    ServiceLevelObjectiveMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveMetricArgs:
    def __init__(__self__, *,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveDimensionArgs']]]] = None,
                 metric_name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None):
        """
        This structure defines the metric used for a service level indicator, including the metric name, namespace, and dimensions.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveDimensionArgs']]] dimensions: An array of one or more dimensions to use to define the metric that you want to use.
        :param pulumi.Input[builtins.str] metric_name: The name of the metric to use.
        :param pulumi.Input[builtins.str] namespace: The namespace of the metric.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveDimensionArgs']]]]:
        """
        An array of one or more dimensions to use to define the metric that you want to use.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the metric to use.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The namespace of the metric.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)


if not MYPY:
    class ServiceLevelObjectiveMonitoredRequestCountMetricArgsDict(TypedDict):
        """
        This structure defines the metric that is used as the "good request" or "bad request" value for a request-based SLO. This value observed for the metric defined in `TotalRequestCountMetric` is divided by the number found for `MonitoredRequestCountMetric` to determine the percentage of successful requests that this SLO tracks.
        """
        bad_count_metric: NotRequired[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgsDict']]]]
        """
        If you want to count "bad requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "bad requests" in this structure.
        """
        good_count_metric: NotRequired[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgsDict']]]]
        """
        If you want to count "good requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "good requests" in this structure.
        """
elif False:
    ServiceLevelObjectiveMonitoredRequestCountMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveMonitoredRequestCountMetricArgs:
    def __init__(__self__, *,
                 bad_count_metric: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]]] = None,
                 good_count_metric: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]]] = None):
        """
        This structure defines the metric that is used as the "good request" or "bad request" value for a request-based SLO. This value observed for the metric defined in `TotalRequestCountMetric` is divided by the number found for `MonitoredRequestCountMetric` to determine the percentage of successful requests that this SLO tracks.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]] bad_count_metric: If you want to count "bad requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "bad requests" in this structure.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]] good_count_metric: If you want to count "good requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "good requests" in this structure.
        """
        if bad_count_metric is not None:
            pulumi.set(__self__, "bad_count_metric", bad_count_metric)
        if good_count_metric is not None:
            pulumi.set(__self__, "good_count_metric", good_count_metric)

    @property
    @pulumi.getter(name="badCountMetric")
    def bad_count_metric(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]]]:
        """
        If you want to count "bad requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "bad requests" in this structure.
        """
        return pulumi.get(self, "bad_count_metric")

    @bad_count_metric.setter
    def bad_count_metric(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]]]):
        pulumi.set(self, "bad_count_metric", value)

    @property
    @pulumi.getter(name="goodCountMetric")
    def good_count_metric(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]]]:
        """
        If you want to count "good requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "good requests" in this structure.
        """
        return pulumi.get(self, "good_count_metric")

    @good_count_metric.setter
    def good_count_metric(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]]]):
        pulumi.set(self, "good_count_metric", value)


if not MYPY:
    class ServiceLevelObjectiveRecurrenceRuleArgsDict(TypedDict):
        """
        This object defines how often to repeat a time exclusion window.
        """
        expression: pulumi.Input[builtins.str]
        """
        A cron or rate expression denoting how often to repeat this exclusion window.
        """
elif False:
    ServiceLevelObjectiveRecurrenceRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveRecurrenceRuleArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str]):
        """
        This object defines how often to repeat a time exclusion window.
        :param pulumi.Input[builtins.str] expression: A cron or rate expression denoting how often to repeat this exclusion window.
        """
        pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        """
        A cron or rate expression denoting how often to repeat this exclusion window.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)


if not MYPY:
    class ServiceLevelObjectiveRequestBasedSliMetricArgsDict(TypedDict):
        """
        This structure contains the information about the metric that is used for a request-based SLO.
        """
        dependency_config: NotRequired[pulumi.Input['ServiceLevelObjectiveDependencyConfigArgsDict']]
        """
        Identifies the dependency using the `DependencyKeyAttributes` and `DependencyOperationName` .
        """
        key_attributes: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        This is a string-to-string map that contains information about the type of object that this SLO is related to. It can include the following fields.

        - `Type` designates the type of object that this SLO is related to.
        - `ResourceType` specifies the type of the resource. This field is used only when the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Name` specifies the name of the object. This is used only if the value of the `Type` field is `Service` , `RemoteService` , or `AWS::Service` .
        - `Identifier` identifies the resource objects of this resource. This is used only if the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Environment` specifies the location where this object is hosted, or what it belongs to.
        - `AwsAccountId` allows you to create an SLO for an object that exists in another account.
        """
        metric_type: NotRequired[pulumi.Input['ServiceLevelObjectiveRequestBasedSliMetricMetricType']]
        """
        If the SLO monitors either the LATENCY or AVAILABILITY metric that Application Signals collects, this field displays which of those metrics is used.
        """
        monitored_request_count_metric: NotRequired[pulumi.Input['ServiceLevelObjectiveMonitoredRequestCountMetricArgsDict']]
        """
        Use this structure to define the metric that you want to use as the "good request" or "bad request" value for a request-based SLO. This value observed for the metric defined in `TotalRequestCountMetric` will be divided by the number found for `MonitoredRequestCountMetric` to determine the percentage of successful requests that this SLO tracks.
        """
        operation_name: NotRequired[pulumi.Input[builtins.str]]
        """
        If the SLO monitors a specific operation of the service, this field displays that operation name.
        """
        total_request_count_metric: NotRequired[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgsDict']]]]
        """
        This structure defines the metric that is used as the "total requests" number for a request-based SLO. The number observed for this metric is divided by the number of "good requests" or "bad requests" that is observed for the metric defined in `MonitoredRequestCountMetric`.
        """
elif False:
    ServiceLevelObjectiveRequestBasedSliMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveRequestBasedSliMetricArgs:
    def __init__(__self__, *,
                 dependency_config: Optional[pulumi.Input['ServiceLevelObjectiveDependencyConfigArgs']] = None,
                 key_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metric_type: Optional[pulumi.Input['ServiceLevelObjectiveRequestBasedSliMetricMetricType']] = None,
                 monitored_request_count_metric: Optional[pulumi.Input['ServiceLevelObjectiveMonitoredRequestCountMetricArgs']] = None,
                 operation_name: Optional[pulumi.Input[builtins.str]] = None,
                 total_request_count_metric: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]]] = None):
        """
        This structure contains the information about the metric that is used for a request-based SLO.
        :param pulumi.Input['ServiceLevelObjectiveDependencyConfigArgs'] dependency_config: Identifies the dependency using the `DependencyKeyAttributes` and `DependencyOperationName` .
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] key_attributes: This is a string-to-string map that contains information about the type of object that this SLO is related to. It can include the following fields.
               
               - `Type` designates the type of object that this SLO is related to.
               - `ResourceType` specifies the type of the resource. This field is used only when the value of the `Type` field is `Resource` or `AWS::Resource` .
               - `Name` specifies the name of the object. This is used only if the value of the `Type` field is `Service` , `RemoteService` , or `AWS::Service` .
               - `Identifier` identifies the resource objects of this resource. This is used only if the value of the `Type` field is `Resource` or `AWS::Resource` .
               - `Environment` specifies the location where this object is hosted, or what it belongs to.
               - `AwsAccountId` allows you to create an SLO for an object that exists in another account.
        :param pulumi.Input['ServiceLevelObjectiveRequestBasedSliMetricMetricType'] metric_type: If the SLO monitors either the LATENCY or AVAILABILITY metric that Application Signals collects, this field displays which of those metrics is used.
        :param pulumi.Input['ServiceLevelObjectiveMonitoredRequestCountMetricArgs'] monitored_request_count_metric: Use this structure to define the metric that you want to use as the "good request" or "bad request" value for a request-based SLO. This value observed for the metric defined in `TotalRequestCountMetric` will be divided by the number found for `MonitoredRequestCountMetric` to determine the percentage of successful requests that this SLO tracks.
        :param pulumi.Input[builtins.str] operation_name: If the SLO monitors a specific operation of the service, this field displays that operation name.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]] total_request_count_metric: This structure defines the metric that is used as the "total requests" number for a request-based SLO. The number observed for this metric is divided by the number of "good requests" or "bad requests" that is observed for the metric defined in `MonitoredRequestCountMetric`.
        """
        if dependency_config is not None:
            pulumi.set(__self__, "dependency_config", dependency_config)
        if key_attributes is not None:
            pulumi.set(__self__, "key_attributes", key_attributes)
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if monitored_request_count_metric is not None:
            pulumi.set(__self__, "monitored_request_count_metric", monitored_request_count_metric)
        if operation_name is not None:
            pulumi.set(__self__, "operation_name", operation_name)
        if total_request_count_metric is not None:
            pulumi.set(__self__, "total_request_count_metric", total_request_count_metric)

    @property
    @pulumi.getter(name="dependencyConfig")
    def dependency_config(self) -> Optional[pulumi.Input['ServiceLevelObjectiveDependencyConfigArgs']]:
        """
        Identifies the dependency using the `DependencyKeyAttributes` and `DependencyOperationName` .
        """
        return pulumi.get(self, "dependency_config")

    @dependency_config.setter
    def dependency_config(self, value: Optional[pulumi.Input['ServiceLevelObjectiveDependencyConfigArgs']]):
        pulumi.set(self, "dependency_config", value)

    @property
    @pulumi.getter(name="keyAttributes")
    def key_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        This is a string-to-string map that contains information about the type of object that this SLO is related to. It can include the following fields.

        - `Type` designates the type of object that this SLO is related to.
        - `ResourceType` specifies the type of the resource. This field is used only when the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Name` specifies the name of the object. This is used only if the value of the `Type` field is `Service` , `RemoteService` , or `AWS::Service` .
        - `Identifier` identifies the resource objects of this resource. This is used only if the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Environment` specifies the location where this object is hosted, or what it belongs to.
        - `AwsAccountId` allows you to create an SLO for an object that exists in another account.
        """
        return pulumi.get(self, "key_attributes")

    @key_attributes.setter
    def key_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "key_attributes", value)

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional[pulumi.Input['ServiceLevelObjectiveRequestBasedSliMetricMetricType']]:
        """
        If the SLO monitors either the LATENCY or AVAILABILITY metric that Application Signals collects, this field displays which of those metrics is used.
        """
        return pulumi.get(self, "metric_type")

    @metric_type.setter
    def metric_type(self, value: Optional[pulumi.Input['ServiceLevelObjectiveRequestBasedSliMetricMetricType']]):
        pulumi.set(self, "metric_type", value)

    @property
    @pulumi.getter(name="monitoredRequestCountMetric")
    def monitored_request_count_metric(self) -> Optional[pulumi.Input['ServiceLevelObjectiveMonitoredRequestCountMetricArgs']]:
        """
        Use this structure to define the metric that you want to use as the "good request" or "bad request" value for a request-based SLO. This value observed for the metric defined in `TotalRequestCountMetric` will be divided by the number found for `MonitoredRequestCountMetric` to determine the percentage of successful requests that this SLO tracks.
        """
        return pulumi.get(self, "monitored_request_count_metric")

    @monitored_request_count_metric.setter
    def monitored_request_count_metric(self, value: Optional[pulumi.Input['ServiceLevelObjectiveMonitoredRequestCountMetricArgs']]):
        pulumi.set(self, "monitored_request_count_metric", value)

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If the SLO monitors a specific operation of the service, this field displays that operation name.
        """
        return pulumi.get(self, "operation_name")

    @operation_name.setter
    def operation_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operation_name", value)

    @property
    @pulumi.getter(name="totalRequestCountMetric")
    def total_request_count_metric(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]]]:
        """
        This structure defines the metric that is used as the "total requests" number for a request-based SLO. The number observed for this metric is divided by the number of "good requests" or "bad requests" that is observed for the metric defined in `MonitoredRequestCountMetric`.
        """
        return pulumi.get(self, "total_request_count_metric")

    @total_request_count_metric.setter
    def total_request_count_metric(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]]]):
        pulumi.set(self, "total_request_count_metric", value)


if not MYPY:
    class ServiceLevelObjectiveRequestBasedSliArgsDict(TypedDict):
        """
        This structure contains information about the performance metric that a request-based SLO monitors.
        """
        request_based_sli_metric: pulumi.Input['ServiceLevelObjectiveRequestBasedSliMetricArgsDict']
        """
        A structure that contains information about the metric that the SLO monitors.
        """
        comparison_operator: NotRequired[pulumi.Input['ServiceLevelObjectiveRequestBasedSliComparisonOperator']]
        """
        The arithmetic operation used when comparing the specified metric to the threshold.
        """
        metric_threshold: NotRequired[pulumi.Input[builtins.float]]
        """
        The value that the SLI metric is compared to.
        """
elif False:
    ServiceLevelObjectiveRequestBasedSliArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveRequestBasedSliArgs:
    def __init__(__self__, *,
                 request_based_sli_metric: pulumi.Input['ServiceLevelObjectiveRequestBasedSliMetricArgs'],
                 comparison_operator: Optional[pulumi.Input['ServiceLevelObjectiveRequestBasedSliComparisonOperator']] = None,
                 metric_threshold: Optional[pulumi.Input[builtins.float]] = None):
        """
        This structure contains information about the performance metric that a request-based SLO monitors.
        :param pulumi.Input['ServiceLevelObjectiveRequestBasedSliMetricArgs'] request_based_sli_metric: A structure that contains information about the metric that the SLO monitors.
        :param pulumi.Input['ServiceLevelObjectiveRequestBasedSliComparisonOperator'] comparison_operator: The arithmetic operation used when comparing the specified metric to the threshold.
        :param pulumi.Input[builtins.float] metric_threshold: The value that the SLI metric is compared to.
        """
        pulumi.set(__self__, "request_based_sli_metric", request_based_sli_metric)
        if comparison_operator is not None:
            pulumi.set(__self__, "comparison_operator", comparison_operator)
        if metric_threshold is not None:
            pulumi.set(__self__, "metric_threshold", metric_threshold)

    @property
    @pulumi.getter(name="requestBasedSliMetric")
    def request_based_sli_metric(self) -> pulumi.Input['ServiceLevelObjectiveRequestBasedSliMetricArgs']:
        """
        A structure that contains information about the metric that the SLO monitors.
        """
        return pulumi.get(self, "request_based_sli_metric")

    @request_based_sli_metric.setter
    def request_based_sli_metric(self, value: pulumi.Input['ServiceLevelObjectiveRequestBasedSliMetricArgs']):
        pulumi.set(self, "request_based_sli_metric", value)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> Optional[pulumi.Input['ServiceLevelObjectiveRequestBasedSliComparisonOperator']]:
        """
        The arithmetic operation used when comparing the specified metric to the threshold.
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: Optional[pulumi.Input['ServiceLevelObjectiveRequestBasedSliComparisonOperator']]):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter(name="metricThreshold")
    def metric_threshold(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The value that the SLI metric is compared to.
        """
        return pulumi.get(self, "metric_threshold")

    @metric_threshold.setter
    def metric_threshold(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "metric_threshold", value)


if not MYPY:
    class ServiceLevelObjectiveRollingIntervalArgsDict(TypedDict):
        """
        If the interval is a calendar interval, this structure contains the interval specifications.
        """
        duration: pulumi.Input[builtins.int]
        """
        Specifies the duration of each rolling interval. For example, if `Duration` is `7` and `DurationUnit` is `DAY` , each rolling interval is seven days.
        """
        duration_unit: pulumi.Input['ServiceLevelObjectiveDurationUnit']
        """
        Specifies the rolling interval unit.
        """
elif False:
    ServiceLevelObjectiveRollingIntervalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveRollingIntervalArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[builtins.int],
                 duration_unit: pulumi.Input['ServiceLevelObjectiveDurationUnit']):
        """
        If the interval is a calendar interval, this structure contains the interval specifications.
        :param pulumi.Input[builtins.int] duration: Specifies the duration of each rolling interval. For example, if `Duration` is `7` and `DurationUnit` is `DAY` , each rolling interval is seven days.
        :param pulumi.Input['ServiceLevelObjectiveDurationUnit'] duration_unit: Specifies the rolling interval unit.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "duration_unit", duration_unit)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[builtins.int]:
        """
        Specifies the duration of each rolling interval. For example, if `Duration` is `7` and `DurationUnit` is `DAY` , each rolling interval is seven days.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="durationUnit")
    def duration_unit(self) -> pulumi.Input['ServiceLevelObjectiveDurationUnit']:
        """
        Specifies the rolling interval unit.
        """
        return pulumi.get(self, "duration_unit")

    @duration_unit.setter
    def duration_unit(self, value: pulumi.Input['ServiceLevelObjectiveDurationUnit']):
        pulumi.set(self, "duration_unit", value)


if not MYPY:
    class ServiceLevelObjectiveSliMetricArgsDict(TypedDict):
        """
        A structure that contains information about the metric that the SLO monitors.
        """
        dependency_config: NotRequired[pulumi.Input['ServiceLevelObjectiveDependencyConfigArgsDict']]
        """
        Identifies the dependency using the `DependencyKeyAttributes` and `DependencyOperationName` .
        """
        key_attributes: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        If this SLO is related to a metric collected by Application Signals, you must use this field to specify which service the SLO metric is related to. To do so, you must specify at least the `Type` , `Name` , and `Environment` attributes.

        This is a string-to-string map. It can include the following fields.

        - `Type` designates the type of object this is.
        - `ResourceType` specifies the type of the resource. This field is used only when the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Name` specifies the name of the object. This is used only if the value of the `Type` field is `Service` , `RemoteService` , or `AWS::Service` .
        - `Identifier` identifies the resource objects of this resource. This is used only if the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Environment` specifies the location where this object is hosted, or what it belongs to.
        """
        metric_data_queries: NotRequired[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgsDict']]]]
        """
        If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use this structure to specify that metric or expression.
        """
        metric_type: NotRequired[pulumi.Input['ServiceLevelObjectiveSliMetricMetricType']]
        """
        If the SLO monitors either the LATENCY or AVAILABILITY metric that Application Signals collects, this field displays which of those metrics is used.
        """
        operation_name: NotRequired[pulumi.Input[builtins.str]]
        """
        If the SLO monitors a specific operation of the service, this field displays that operation name.
        """
        period_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds to use as the period for SLO evaluation. Your application's performance is compared to the SLI during each period. For each period, the application is determined to have either achieved or not achieved the necessary performance.
        """
        statistic: NotRequired[pulumi.Input[builtins.str]]
        """
        The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended statistic
        """
elif False:
    ServiceLevelObjectiveSliMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveSliMetricArgs:
    def __init__(__self__, *,
                 dependency_config: Optional[pulumi.Input['ServiceLevelObjectiveDependencyConfigArgs']] = None,
                 key_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metric_data_queries: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]]] = None,
                 metric_type: Optional[pulumi.Input['ServiceLevelObjectiveSliMetricMetricType']] = None,
                 operation_name: Optional[pulumi.Input[builtins.str]] = None,
                 period_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 statistic: Optional[pulumi.Input[builtins.str]] = None):
        """
        A structure that contains information about the metric that the SLO monitors.
        :param pulumi.Input['ServiceLevelObjectiveDependencyConfigArgs'] dependency_config: Identifies the dependency using the `DependencyKeyAttributes` and `DependencyOperationName` .
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] key_attributes: If this SLO is related to a metric collected by Application Signals, you must use this field to specify which service the SLO metric is related to. To do so, you must specify at least the `Type` , `Name` , and `Environment` attributes.
               
               This is a string-to-string map. It can include the following fields.
               
               - `Type` designates the type of object this is.
               - `ResourceType` specifies the type of the resource. This field is used only when the value of the `Type` field is `Resource` or `AWS::Resource` .
               - `Name` specifies the name of the object. This is used only if the value of the `Type` field is `Service` , `RemoteService` , or `AWS::Service` .
               - `Identifier` identifies the resource objects of this resource. This is used only if the value of the `Type` field is `Resource` or `AWS::Resource` .
               - `Environment` specifies the location where this object is hosted, or what it belongs to.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]] metric_data_queries: If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use this structure to specify that metric or expression.
        :param pulumi.Input['ServiceLevelObjectiveSliMetricMetricType'] metric_type: If the SLO monitors either the LATENCY or AVAILABILITY metric that Application Signals collects, this field displays which of those metrics is used.
        :param pulumi.Input[builtins.str] operation_name: If the SLO monitors a specific operation of the service, this field displays that operation name.
        :param pulumi.Input[builtins.int] period_seconds: The number of seconds to use as the period for SLO evaluation. Your application's performance is compared to the SLI during each period. For each period, the application is determined to have either achieved or not achieved the necessary performance.
        :param pulumi.Input[builtins.str] statistic: The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended statistic
        """
        if dependency_config is not None:
            pulumi.set(__self__, "dependency_config", dependency_config)
        if key_attributes is not None:
            pulumi.set(__self__, "key_attributes", key_attributes)
        if metric_data_queries is not None:
            pulumi.set(__self__, "metric_data_queries", metric_data_queries)
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if operation_name is not None:
            pulumi.set(__self__, "operation_name", operation_name)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)

    @property
    @pulumi.getter(name="dependencyConfig")
    def dependency_config(self) -> Optional[pulumi.Input['ServiceLevelObjectiveDependencyConfigArgs']]:
        """
        Identifies the dependency using the `DependencyKeyAttributes` and `DependencyOperationName` .
        """
        return pulumi.get(self, "dependency_config")

    @dependency_config.setter
    def dependency_config(self, value: Optional[pulumi.Input['ServiceLevelObjectiveDependencyConfigArgs']]):
        pulumi.set(self, "dependency_config", value)

    @property
    @pulumi.getter(name="keyAttributes")
    def key_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        If this SLO is related to a metric collected by Application Signals, you must use this field to specify which service the SLO metric is related to. To do so, you must specify at least the `Type` , `Name` , and `Environment` attributes.

        This is a string-to-string map. It can include the following fields.

        - `Type` designates the type of object this is.
        - `ResourceType` specifies the type of the resource. This field is used only when the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Name` specifies the name of the object. This is used only if the value of the `Type` field is `Service` , `RemoteService` , or `AWS::Service` .
        - `Identifier` identifies the resource objects of this resource. This is used only if the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Environment` specifies the location where this object is hosted, or what it belongs to.
        """
        return pulumi.get(self, "key_attributes")

    @key_attributes.setter
    def key_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "key_attributes", value)

    @property
    @pulumi.getter(name="metricDataQueries")
    def metric_data_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]]]:
        """
        If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use this structure to specify that metric or expression.
        """
        return pulumi.get(self, "metric_data_queries")

    @metric_data_queries.setter
    def metric_data_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveMetricDataQueryArgs']]]]):
        pulumi.set(self, "metric_data_queries", value)

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional[pulumi.Input['ServiceLevelObjectiveSliMetricMetricType']]:
        """
        If the SLO monitors either the LATENCY or AVAILABILITY metric that Application Signals collects, this field displays which of those metrics is used.
        """
        return pulumi.get(self, "metric_type")

    @metric_type.setter
    def metric_type(self, value: Optional[pulumi.Input['ServiceLevelObjectiveSliMetricMetricType']]):
        pulumi.set(self, "metric_type", value)

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If the SLO monitors a specific operation of the service, this field displays that operation name.
        """
        return pulumi.get(self, "operation_name")

    @operation_name.setter
    def operation_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operation_name", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds to use as the period for SLO evaluation. Your application's performance is compared to the SLI during each period. For each period, the application is determined to have either achieved or not achieved the necessary performance.
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter
    def statistic(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended statistic
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "statistic", value)


if not MYPY:
    class ServiceLevelObjectiveSliArgsDict(TypedDict):
        """
        This structure contains information about the performance metric that an SLO monitors.
        """
        comparison_operator: pulumi.Input['ServiceLevelObjectiveSliComparisonOperator']
        """
        The arithmetic operation used when comparing the specified metric to the threshold.
        """
        metric_threshold: pulumi.Input[builtins.float]
        """
        The value that the SLI metric is compared to.
        """
        sli_metric: pulumi.Input['ServiceLevelObjectiveSliMetricArgsDict']
        """
        Use this structure to specify the metric to be used for the SLO.
        """
elif False:
    ServiceLevelObjectiveSliArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveSliArgs:
    def __init__(__self__, *,
                 comparison_operator: pulumi.Input['ServiceLevelObjectiveSliComparisonOperator'],
                 metric_threshold: pulumi.Input[builtins.float],
                 sli_metric: pulumi.Input['ServiceLevelObjectiveSliMetricArgs']):
        """
        This structure contains information about the performance metric that an SLO monitors.
        :param pulumi.Input['ServiceLevelObjectiveSliComparisonOperator'] comparison_operator: The arithmetic operation used when comparing the specified metric to the threshold.
        :param pulumi.Input[builtins.float] metric_threshold: The value that the SLI metric is compared to.
        :param pulumi.Input['ServiceLevelObjectiveSliMetricArgs'] sli_metric: Use this structure to specify the metric to be used for the SLO.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "metric_threshold", metric_threshold)
        pulumi.set(__self__, "sli_metric", sli_metric)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> pulumi.Input['ServiceLevelObjectiveSliComparisonOperator']:
        """
        The arithmetic operation used when comparing the specified metric to the threshold.
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: pulumi.Input['ServiceLevelObjectiveSliComparisonOperator']):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter(name="metricThreshold")
    def metric_threshold(self) -> pulumi.Input[builtins.float]:
        """
        The value that the SLI metric is compared to.
        """
        return pulumi.get(self, "metric_threshold")

    @metric_threshold.setter
    def metric_threshold(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "metric_threshold", value)

    @property
    @pulumi.getter(name="sliMetric")
    def sli_metric(self) -> pulumi.Input['ServiceLevelObjectiveSliMetricArgs']:
        """
        Use this structure to specify the metric to be used for the SLO.
        """
        return pulumi.get(self, "sli_metric")

    @sli_metric.setter
    def sli_metric(self, value: pulumi.Input['ServiceLevelObjectiveSliMetricArgs']):
        pulumi.set(self, "sli_metric", value)


if not MYPY:
    class ServiceLevelObjectiveWindowArgsDict(TypedDict):
        """
        This object defines the length of time an exclusion window should span.
        """
        duration: pulumi.Input[builtins.int]
        duration_unit: pulumi.Input['ServiceLevelObjectiveDurationUnit']
elif False:
    ServiceLevelObjectiveWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLevelObjectiveWindowArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[builtins.int],
                 duration_unit: pulumi.Input['ServiceLevelObjectiveDurationUnit']):
        """
        This object defines the length of time an exclusion window should span.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "duration_unit", duration_unit)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[builtins.int]:
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="durationUnit")
    def duration_unit(self) -> pulumi.Input['ServiceLevelObjectiveDurationUnit']:
        return pulumi.get(self, "duration_unit")

    @duration_unit.setter
    def duration_unit(self, value: pulumi.Input['ServiceLevelObjectiveDurationUnit']):
        pulumi.set(self, "duration_unit", value)


