# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    def __init__(__self__, application_arn=None, auto_configuration_enabled=None, cwe_monitor_enabled=None, ops_center_enabled=None, tags=None):
        if application_arn and not isinstance(application_arn, str):
            raise TypeError("Expected argument 'application_arn' to be a str")
        pulumi.set(__self__, "application_arn", application_arn)
        if auto_configuration_enabled and not isinstance(auto_configuration_enabled, bool):
            raise TypeError("Expected argument 'auto_configuration_enabled' to be a bool")
        pulumi.set(__self__, "auto_configuration_enabled", auto_configuration_enabled)
        if cwe_monitor_enabled and not isinstance(cwe_monitor_enabled, bool):
            raise TypeError("Expected argument 'cwe_monitor_enabled' to be a bool")
        pulumi.set(__self__, "cwe_monitor_enabled", cwe_monitor_enabled)
        if ops_center_enabled and not isinstance(ops_center_enabled, bool):
            raise TypeError("Expected argument 'ops_center_enabled' to be a bool")
        pulumi.set(__self__, "ops_center_enabled", ops_center_enabled)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the ApplicationInsights application.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="autoConfigurationEnabled")
    def auto_configuration_enabled(self) -> Optional[builtins.bool]:
        """
        If set to true, application will be configured with recommended monitoring configuration.
        """
        return pulumi.get(self, "auto_configuration_enabled")

    @property
    @pulumi.getter(name="cweMonitorEnabled")
    def cwe_monitor_enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether Application Insights can listen to CloudWatch events for the application resources.
        """
        return pulumi.get(self, "cwe_monitor_enabled")

    @property
    @pulumi.getter(name="opsCenterEnabled")
    def ops_center_enabled(self) -> Optional[builtins.bool]:
        """
        When set to true, creates opsItems for any problems detected on an application.
        """
        return pulumi.get(self, "ops_center_enabled")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags of Application Insights application.
        """
        return pulumi.get(self, "tags")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            application_arn=self.application_arn,
            auto_configuration_enabled=self.auto_configuration_enabled,
            cwe_monitor_enabled=self.cwe_monitor_enabled,
            ops_center_enabled=self.ops_center_enabled,
            tags=self.tags)


def get_application(application_arn: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    Resource schema for AWS::ApplicationInsights::Application


    :param builtins.str application_arn: The ARN of the ApplicationInsights application.
    """
    __args__ = dict()
    __args__['applicationArn'] = application_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:applicationinsights:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        application_arn=pulumi.get(__ret__, 'application_arn'),
        auto_configuration_enabled=pulumi.get(__ret__, 'auto_configuration_enabled'),
        cwe_monitor_enabled=pulumi.get(__ret__, 'cwe_monitor_enabled'),
        ops_center_enabled=pulumi.get(__ret__, 'ops_center_enabled'),
        tags=pulumi.get(__ret__, 'tags'))
def get_application_output(application_arn: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationResult]:
    """
    Resource schema for AWS::ApplicationInsights::Application


    :param builtins.str application_arn: The ARN of the ApplicationInsights application.
    """
    __args__ = dict()
    __args__['applicationArn'] = application_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:applicationinsights:getApplication', __args__, opts=opts, typ=GetApplicationResult)
    return __ret__.apply(lambda __response__: GetApplicationResult(
        application_arn=pulumi.get(__response__, 'application_arn'),
        auto_configuration_enabled=pulumi.get(__response__, 'auto_configuration_enabled'),
        cwe_monitor_enabled=pulumi.get(__response__, 'cwe_monitor_enabled'),
        ops_center_enabled=pulumi.get(__response__, 'ops_center_enabled'),
        tags=pulumi.get(__response__, 'tags')))
