# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 attach_missing_permission: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_configuration_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 component_monitoring_settings: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationComponentMonitoringSettingArgs']]]] = None,
                 custom_components: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationCustomComponentArgs']]]] = None,
                 cwe_monitor_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 grouping_type: Optional[pulumi.Input['ApplicationGroupingType']] = None,
                 log_pattern_sets: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationLogPatternSetArgs']]]] = None,
                 ops_center_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ops_item_sns_topic_arn: Optional[pulumi.Input[builtins.str]] = None,
                 sns_notification_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group.
        :param pulumi.Input[builtins.bool] attach_missing_permission: If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing
        :param pulumi.Input[builtins.bool] auto_configuration_enabled: If set to true, application will be configured with recommended monitoring configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationComponentMonitoringSettingArgs']]] component_monitoring_settings: The monitoring settings of the components.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationCustomComponentArgs']]] custom_components: The custom grouped components.
        :param pulumi.Input[builtins.bool] cwe_monitor_enabled: Indicates whether Application Insights can listen to CloudWatch events for the application resources.
        :param pulumi.Input['ApplicationGroupingType'] grouping_type: The grouping type of the application
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationLogPatternSetArgs']]] log_pattern_sets: The log pattern sets.
        :param pulumi.Input[builtins.bool] ops_center_enabled: When set to true, creates opsItems for any problems detected on an application.
        :param pulumi.Input[builtins.str] ops_item_sns_topic_arn: The SNS topic provided to Application Insights that is associated to the created opsItem.
        :param pulumi.Input[builtins.str] sns_notification_arn: Application Insights sends notifications to this SNS topic whenever there is a problem update in the associated application.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags of Application Insights application.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if attach_missing_permission is not None:
            pulumi.set(__self__, "attach_missing_permission", attach_missing_permission)
        if auto_configuration_enabled is not None:
            pulumi.set(__self__, "auto_configuration_enabled", auto_configuration_enabled)
        if component_monitoring_settings is not None:
            pulumi.set(__self__, "component_monitoring_settings", component_monitoring_settings)
        if custom_components is not None:
            pulumi.set(__self__, "custom_components", custom_components)
        if cwe_monitor_enabled is not None:
            pulumi.set(__self__, "cwe_monitor_enabled", cwe_monitor_enabled)
        if grouping_type is not None:
            pulumi.set(__self__, "grouping_type", grouping_type)
        if log_pattern_sets is not None:
            pulumi.set(__self__, "log_pattern_sets", log_pattern_sets)
        if ops_center_enabled is not None:
            pulumi.set(__self__, "ops_center_enabled", ops_center_enabled)
        if ops_item_sns_topic_arn is not None:
            pulumi.set(__self__, "ops_item_sns_topic_arn", ops_item_sns_topic_arn)
        if sns_notification_arn is not None:
            pulumi.set(__self__, "sns_notification_arn", sns_notification_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="attachMissingPermission")
    def attach_missing_permission(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing
        """
        return pulumi.get(self, "attach_missing_permission")

    @attach_missing_permission.setter
    def attach_missing_permission(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "attach_missing_permission", value)

    @property
    @pulumi.getter(name="autoConfigurationEnabled")
    def auto_configuration_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, application will be configured with recommended monitoring configuration.
        """
        return pulumi.get(self, "auto_configuration_enabled")

    @auto_configuration_enabled.setter
    def auto_configuration_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_configuration_enabled", value)

    @property
    @pulumi.getter(name="componentMonitoringSettings")
    def component_monitoring_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationComponentMonitoringSettingArgs']]]]:
        """
        The monitoring settings of the components.
        """
        return pulumi.get(self, "component_monitoring_settings")

    @component_monitoring_settings.setter
    def component_monitoring_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationComponentMonitoringSettingArgs']]]]):
        pulumi.set(self, "component_monitoring_settings", value)

    @property
    @pulumi.getter(name="customComponents")
    def custom_components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationCustomComponentArgs']]]]:
        """
        The custom grouped components.
        """
        return pulumi.get(self, "custom_components")

    @custom_components.setter
    def custom_components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationCustomComponentArgs']]]]):
        pulumi.set(self, "custom_components", value)

    @property
    @pulumi.getter(name="cweMonitorEnabled")
    def cwe_monitor_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether Application Insights can listen to CloudWatch events for the application resources.
        """
        return pulumi.get(self, "cwe_monitor_enabled")

    @cwe_monitor_enabled.setter
    def cwe_monitor_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cwe_monitor_enabled", value)

    @property
    @pulumi.getter(name="groupingType")
    def grouping_type(self) -> Optional[pulumi.Input['ApplicationGroupingType']]:
        """
        The grouping type of the application
        """
        return pulumi.get(self, "grouping_type")

    @grouping_type.setter
    def grouping_type(self, value: Optional[pulumi.Input['ApplicationGroupingType']]):
        pulumi.set(self, "grouping_type", value)

    @property
    @pulumi.getter(name="logPatternSets")
    def log_pattern_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationLogPatternSetArgs']]]]:
        """
        The log pattern sets.
        """
        return pulumi.get(self, "log_pattern_sets")

    @log_pattern_sets.setter
    def log_pattern_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationLogPatternSetArgs']]]]):
        pulumi.set(self, "log_pattern_sets", value)

    @property
    @pulumi.getter(name="opsCenterEnabled")
    def ops_center_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to true, creates opsItems for any problems detected on an application.
        """
        return pulumi.get(self, "ops_center_enabled")

    @ops_center_enabled.setter
    def ops_center_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ops_center_enabled", value)

    @property
    @pulumi.getter(name="opsItemSnsTopicArn")
    def ops_item_sns_topic_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SNS topic provided to Application Insights that is associated to the created opsItem.
        """
        return pulumi.get(self, "ops_item_sns_topic_arn")

    @ops_item_sns_topic_arn.setter
    def ops_item_sns_topic_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ops_item_sns_topic_arn", value)

    @property
    @pulumi.getter(name="snsNotificationArn")
    def sns_notification_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Application Insights sends notifications to this SNS topic whenever there is a problem update in the associated application.
        """
        return pulumi.get(self, "sns_notification_arn")

    @sns_notification_arn.setter
    def sns_notification_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sns_notification_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags of Application Insights application.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:applicationinsights:Application")
class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attach_missing_permission: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_configuration_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 component_monitoring_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationComponentMonitoringSettingArgs', 'ApplicationComponentMonitoringSettingArgsDict']]]]] = None,
                 custom_components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationCustomComponentArgs', 'ApplicationCustomComponentArgsDict']]]]] = None,
                 cwe_monitor_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 grouping_type: Optional[pulumi.Input['ApplicationGroupingType']] = None,
                 log_pattern_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationLogPatternSetArgs', 'ApplicationLogPatternSetArgsDict']]]]] = None,
                 ops_center_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ops_item_sns_topic_arn: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sns_notification_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::ApplicationInsights::Application

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] attach_missing_permission: If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing
        :param pulumi.Input[builtins.bool] auto_configuration_enabled: If set to true, application will be configured with recommended monitoring configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationComponentMonitoringSettingArgs', 'ApplicationComponentMonitoringSettingArgsDict']]]] component_monitoring_settings: The monitoring settings of the components.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationCustomComponentArgs', 'ApplicationCustomComponentArgsDict']]]] custom_components: The custom grouped components.
        :param pulumi.Input[builtins.bool] cwe_monitor_enabled: Indicates whether Application Insights can listen to CloudWatch events for the application resources.
        :param pulumi.Input['ApplicationGroupingType'] grouping_type: The grouping type of the application
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationLogPatternSetArgs', 'ApplicationLogPatternSetArgsDict']]]] log_pattern_sets: The log pattern sets.
        :param pulumi.Input[builtins.bool] ops_center_enabled: When set to true, creates opsItems for any problems detected on an application.
        :param pulumi.Input[builtins.str] ops_item_sns_topic_arn: The SNS topic provided to Application Insights that is associated to the created opsItem.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group.
        :param pulumi.Input[builtins.str] sns_notification_arn: Application Insights sends notifications to this SNS topic whenever there is a problem update in the associated application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags of Application Insights application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::ApplicationInsights::Application

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attach_missing_permission: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_configuration_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 component_monitoring_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationComponentMonitoringSettingArgs', 'ApplicationComponentMonitoringSettingArgsDict']]]]] = None,
                 custom_components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationCustomComponentArgs', 'ApplicationCustomComponentArgsDict']]]]] = None,
                 cwe_monitor_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 grouping_type: Optional[pulumi.Input['ApplicationGroupingType']] = None,
                 log_pattern_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationLogPatternSetArgs', 'ApplicationLogPatternSetArgsDict']]]]] = None,
                 ops_center_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ops_item_sns_topic_arn: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sns_notification_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            __props__.__dict__["attach_missing_permission"] = attach_missing_permission
            __props__.__dict__["auto_configuration_enabled"] = auto_configuration_enabled
            __props__.__dict__["component_monitoring_settings"] = component_monitoring_settings
            __props__.__dict__["custom_components"] = custom_components
            __props__.__dict__["cwe_monitor_enabled"] = cwe_monitor_enabled
            __props__.__dict__["grouping_type"] = grouping_type
            __props__.__dict__["log_pattern_sets"] = log_pattern_sets
            __props__.__dict__["ops_center_enabled"] = ops_center_enabled
            __props__.__dict__["ops_item_sns_topic_arn"] = ops_item_sns_topic_arn
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["sns_notification_arn"] = sns_notification_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["application_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["groupingType", "resourceGroupName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Application, __self__).__init__(
            'aws-native:applicationinsights:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ApplicationArgs.__new__(ApplicationArgs)

        __props__.__dict__["application_arn"] = None
        __props__.__dict__["attach_missing_permission"] = None
        __props__.__dict__["auto_configuration_enabled"] = None
        __props__.__dict__["component_monitoring_settings"] = None
        __props__.__dict__["custom_components"] = None
        __props__.__dict__["cwe_monitor_enabled"] = None
        __props__.__dict__["grouping_type"] = None
        __props__.__dict__["log_pattern_sets"] = None
        __props__.__dict__["ops_center_enabled"] = None
        __props__.__dict__["ops_item_sns_topic_arn"] = None
        __props__.__dict__["resource_group_name"] = None
        __props__.__dict__["sns_notification_arn"] = None
        __props__.__dict__["tags"] = None
        return Application(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the ApplicationInsights application.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="attachMissingPermission")
    def attach_missing_permission(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing
        """
        return pulumi.get(self, "attach_missing_permission")

    @property
    @pulumi.getter(name="autoConfigurationEnabled")
    def auto_configuration_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set to true, application will be configured with recommended monitoring configuration.
        """
        return pulumi.get(self, "auto_configuration_enabled")

    @property
    @pulumi.getter(name="componentMonitoringSettings")
    def component_monitoring_settings(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationComponentMonitoringSetting']]]:
        """
        The monitoring settings of the components.
        """
        return pulumi.get(self, "component_monitoring_settings")

    @property
    @pulumi.getter(name="customComponents")
    def custom_components(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationCustomComponent']]]:
        """
        The custom grouped components.
        """
        return pulumi.get(self, "custom_components")

    @property
    @pulumi.getter(name="cweMonitorEnabled")
    def cwe_monitor_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether Application Insights can listen to CloudWatch events for the application resources.
        """
        return pulumi.get(self, "cwe_monitor_enabled")

    @property
    @pulumi.getter(name="groupingType")
    def grouping_type(self) -> pulumi.Output[Optional['ApplicationGroupingType']]:
        """
        The grouping type of the application
        """
        return pulumi.get(self, "grouping_type")

    @property
    @pulumi.getter(name="logPatternSets")
    def log_pattern_sets(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationLogPatternSet']]]:
        """
        The log pattern sets.
        """
        return pulumi.get(self, "log_pattern_sets")

    @property
    @pulumi.getter(name="opsCenterEnabled")
    def ops_center_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When set to true, creates opsItems for any problems detected on an application.
        """
        return pulumi.get(self, "ops_center_enabled")

    @property
    @pulumi.getter(name="opsItemSnsTopicArn")
    def ops_item_sns_topic_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The SNS topic provided to Application Insights that is associated to the created opsItem.
        """
        return pulumi.get(self, "ops_item_sns_topic_arn")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="snsNotificationArn")
    def sns_notification_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Application Insights sends notifications to this SNS topic whenever there is a problem update in the associated application.
        """
        return pulumi.get(self, "sns_notification_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags of Application Insights application.
        """
        return pulumi.get(self, "tags")

