# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ApplicationAlarmMetricArgs',
    'ApplicationAlarmMetricArgsDict',
    'ApplicationAlarmArgs',
    'ApplicationAlarmArgsDict',
    'ApplicationComponentConfigurationArgs',
    'ApplicationComponentConfigurationArgsDict',
    'ApplicationComponentMonitoringSettingArgs',
    'ApplicationComponentMonitoringSettingArgsDict',
    'ApplicationConfigurationDetailsArgs',
    'ApplicationConfigurationDetailsArgsDict',
    'ApplicationCustomComponentArgs',
    'ApplicationCustomComponentArgsDict',
    'ApplicationHaClusterPrometheusExporterArgs',
    'ApplicationHaClusterPrometheusExporterArgsDict',
    'ApplicationHanaPrometheusExporterArgs',
    'ApplicationHanaPrometheusExporterArgsDict',
    'ApplicationJmxPrometheusExporterArgs',
    'ApplicationJmxPrometheusExporterArgsDict',
    'ApplicationLogPatternSetArgs',
    'ApplicationLogPatternSetArgsDict',
    'ApplicationLogPatternArgs',
    'ApplicationLogPatternArgsDict',
    'ApplicationLogArgs',
    'ApplicationLogArgsDict',
    'ApplicationNetWeaverPrometheusExporterArgs',
    'ApplicationNetWeaverPrometheusExporterArgsDict',
    'ApplicationProcessArgs',
    'ApplicationProcessArgsDict',
    'ApplicationSqlServerPrometheusExporterArgs',
    'ApplicationSqlServerPrometheusExporterArgsDict',
    'ApplicationSubComponentConfigurationDetailsArgs',
    'ApplicationSubComponentConfigurationDetailsArgsDict',
    'ApplicationSubComponentTypeConfigurationArgs',
    'ApplicationSubComponentTypeConfigurationArgsDict',
    'ApplicationWindowsEventArgs',
    'ApplicationWindowsEventArgsDict',
]

MYPY = False

if not MYPY:
    class ApplicationAlarmMetricArgsDict(TypedDict):
        """
        A metric to be monitored for the component.
        """
        alarm_metric_name: pulumi.Input[builtins.str]
        """
        The name of the metric to be monitored for the component.
        """
elif False:
    ApplicationAlarmMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationAlarmMetricArgs:
    def __init__(__self__, *,
                 alarm_metric_name: pulumi.Input[builtins.str]):
        """
        A metric to be monitored for the component.
        :param pulumi.Input[builtins.str] alarm_metric_name: The name of the metric to be monitored for the component.
        """
        pulumi.set(__self__, "alarm_metric_name", alarm_metric_name)

    @property
    @pulumi.getter(name="alarmMetricName")
    def alarm_metric_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the metric to be monitored for the component.
        """
        return pulumi.get(self, "alarm_metric_name")

    @alarm_metric_name.setter
    def alarm_metric_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "alarm_metric_name", value)


if not MYPY:
    class ApplicationAlarmArgsDict(TypedDict):
        """
        A CloudWatch alarm to be monitored for the component.
        """
        alarm_name: pulumi.Input[builtins.str]
        """
        The name of the CloudWatch alarm to be monitored for the component.
        """
        severity: NotRequired[pulumi.Input['ApplicationAlarmSeverity']]
        """
        Indicates the degree of outage when the alarm goes off.
        """
elif False:
    ApplicationAlarmArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationAlarmArgs:
    def __init__(__self__, *,
                 alarm_name: pulumi.Input[builtins.str],
                 severity: Optional[pulumi.Input['ApplicationAlarmSeverity']] = None):
        """
        A CloudWatch alarm to be monitored for the component.
        :param pulumi.Input[builtins.str] alarm_name: The name of the CloudWatch alarm to be monitored for the component.
        :param pulumi.Input['ApplicationAlarmSeverity'] severity: Indicates the degree of outage when the alarm goes off.
        """
        pulumi.set(__self__, "alarm_name", alarm_name)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the CloudWatch alarm to be monitored for the component.
        """
        return pulumi.get(self, "alarm_name")

    @alarm_name.setter
    def alarm_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "alarm_name", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input['ApplicationAlarmSeverity']]:
        """
        Indicates the degree of outage when the alarm goes off.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input['ApplicationAlarmSeverity']]):
        pulumi.set(self, "severity", value)


if not MYPY:
    class ApplicationComponentConfigurationArgsDict(TypedDict):
        """
        The configuration settings of the component.
        """
        configuration_details: NotRequired[pulumi.Input['ApplicationConfigurationDetailsArgsDict']]
        """
        The configuration settings
        """
        sub_component_type_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['ApplicationSubComponentTypeConfigurationArgsDict']]]]
        """
        Sub component configurations of the component.
        """
elif False:
    ApplicationComponentConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationComponentConfigurationArgs:
    def __init__(__self__, *,
                 configuration_details: Optional[pulumi.Input['ApplicationConfigurationDetailsArgs']] = None,
                 sub_component_type_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSubComponentTypeConfigurationArgs']]]] = None):
        """
        The configuration settings of the component.
        :param pulumi.Input['ApplicationConfigurationDetailsArgs'] configuration_details: The configuration settings
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationSubComponentTypeConfigurationArgs']]] sub_component_type_configurations: Sub component configurations of the component.
        """
        if configuration_details is not None:
            pulumi.set(__self__, "configuration_details", configuration_details)
        if sub_component_type_configurations is not None:
            pulumi.set(__self__, "sub_component_type_configurations", sub_component_type_configurations)

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> Optional[pulumi.Input['ApplicationConfigurationDetailsArgs']]:
        """
        The configuration settings
        """
        return pulumi.get(self, "configuration_details")

    @configuration_details.setter
    def configuration_details(self, value: Optional[pulumi.Input['ApplicationConfigurationDetailsArgs']]):
        pulumi.set(self, "configuration_details", value)

    @property
    @pulumi.getter(name="subComponentTypeConfigurations")
    def sub_component_type_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSubComponentTypeConfigurationArgs']]]]:
        """
        Sub component configurations of the component.
        """
        return pulumi.get(self, "sub_component_type_configurations")

    @sub_component_type_configurations.setter
    def sub_component_type_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSubComponentTypeConfigurationArgs']]]]):
        pulumi.set(self, "sub_component_type_configurations", value)


if not MYPY:
    class ApplicationComponentMonitoringSettingArgsDict(TypedDict):
        """
        The monitoring setting of the component.
        """
        component_configuration_mode: pulumi.Input['ApplicationComponentMonitoringSettingComponentConfigurationMode']
        """
        The component monitoring configuration mode.
        """
        tier: pulumi.Input[builtins.str]
        """
        The tier of the application component.
        """
        component_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the compnonent.
        """
        component_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the component.
        """
        custom_component_configuration: NotRequired[pulumi.Input['ApplicationComponentConfigurationArgsDict']]
        """
        The monitoring configuration of the component.
        """
        default_overwrite_component_configuration: NotRequired[pulumi.Input['ApplicationComponentConfigurationArgsDict']]
        """
        The overwritten settings on default component monitoring configuration.
        """
elif False:
    ApplicationComponentMonitoringSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationComponentMonitoringSettingArgs:
    def __init__(__self__, *,
                 component_configuration_mode: pulumi.Input['ApplicationComponentMonitoringSettingComponentConfigurationMode'],
                 tier: pulumi.Input[builtins.str],
                 component_arn: Optional[pulumi.Input[builtins.str]] = None,
                 component_name: Optional[pulumi.Input[builtins.str]] = None,
                 custom_component_configuration: Optional[pulumi.Input['ApplicationComponentConfigurationArgs']] = None,
                 default_overwrite_component_configuration: Optional[pulumi.Input['ApplicationComponentConfigurationArgs']] = None):
        """
        The monitoring setting of the component.
        :param pulumi.Input['ApplicationComponentMonitoringSettingComponentConfigurationMode'] component_configuration_mode: The component monitoring configuration mode.
        :param pulumi.Input[builtins.str] tier: The tier of the application component.
        :param pulumi.Input[builtins.str] component_arn: The ARN of the compnonent.
        :param pulumi.Input[builtins.str] component_name: The name of the component.
        :param pulumi.Input['ApplicationComponentConfigurationArgs'] custom_component_configuration: The monitoring configuration of the component.
        :param pulumi.Input['ApplicationComponentConfigurationArgs'] default_overwrite_component_configuration: The overwritten settings on default component monitoring configuration.
        """
        pulumi.set(__self__, "component_configuration_mode", component_configuration_mode)
        pulumi.set(__self__, "tier", tier)
        if component_arn is not None:
            pulumi.set(__self__, "component_arn", component_arn)
        if component_name is not None:
            pulumi.set(__self__, "component_name", component_name)
        if custom_component_configuration is not None:
            pulumi.set(__self__, "custom_component_configuration", custom_component_configuration)
        if default_overwrite_component_configuration is not None:
            pulumi.set(__self__, "default_overwrite_component_configuration", default_overwrite_component_configuration)

    @property
    @pulumi.getter(name="componentConfigurationMode")
    def component_configuration_mode(self) -> pulumi.Input['ApplicationComponentMonitoringSettingComponentConfigurationMode']:
        """
        The component monitoring configuration mode.
        """
        return pulumi.get(self, "component_configuration_mode")

    @component_configuration_mode.setter
    def component_configuration_mode(self, value: pulumi.Input['ApplicationComponentMonitoringSettingComponentConfigurationMode']):
        pulumi.set(self, "component_configuration_mode", value)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input[builtins.str]:
        """
        The tier of the application component.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="componentArn")
    def component_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the compnonent.
        """
        return pulumi.get(self, "component_arn")

    @component_arn.setter
    def component_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "component_arn", value)

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the component.
        """
        return pulumi.get(self, "component_name")

    @component_name.setter
    def component_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "component_name", value)

    @property
    @pulumi.getter(name="customComponentConfiguration")
    def custom_component_configuration(self) -> Optional[pulumi.Input['ApplicationComponentConfigurationArgs']]:
        """
        The monitoring configuration of the component.
        """
        return pulumi.get(self, "custom_component_configuration")

    @custom_component_configuration.setter
    def custom_component_configuration(self, value: Optional[pulumi.Input['ApplicationComponentConfigurationArgs']]):
        pulumi.set(self, "custom_component_configuration", value)

    @property
    @pulumi.getter(name="defaultOverwriteComponentConfiguration")
    def default_overwrite_component_configuration(self) -> Optional[pulumi.Input['ApplicationComponentConfigurationArgs']]:
        """
        The overwritten settings on default component monitoring configuration.
        """
        return pulumi.get(self, "default_overwrite_component_configuration")

    @default_overwrite_component_configuration.setter
    def default_overwrite_component_configuration(self, value: Optional[pulumi.Input['ApplicationComponentConfigurationArgs']]):
        pulumi.set(self, "default_overwrite_component_configuration", value)


if not MYPY:
    class ApplicationConfigurationDetailsArgsDict(TypedDict):
        """
        The configuration settings.
        """
        alarm_metrics: NotRequired[pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgsDict']]]]
        """
        A list of metrics to monitor for the component.
        """
        alarms: NotRequired[pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmArgsDict']]]]
        """
        A list of alarms to monitor for the component.
        """
        ha_cluster_prometheus_exporter: NotRequired[pulumi.Input['ApplicationHaClusterPrometheusExporterArgsDict']]
        """
        The HA cluster Prometheus Exporter settings.
        """
        hana_prometheus_exporter: NotRequired[pulumi.Input['ApplicationHanaPrometheusExporterArgsDict']]
        """
        The HANA DB Prometheus Exporter settings.
        """
        jmx_prometheus_exporter: NotRequired[pulumi.Input['ApplicationJmxPrometheusExporterArgsDict']]
        """
        The JMX Prometheus Exporter settings.
        """
        logs: NotRequired[pulumi.Input[Sequence[pulumi.Input['ApplicationLogArgsDict']]]]
        """
        A list of logs to monitor for the component.
        """
        net_weaver_prometheus_exporter: NotRequired[pulumi.Input['ApplicationNetWeaverPrometheusExporterArgsDict']]
        """
        The NetWeaver Prometheus Exporter settings.
        """
        processes: NotRequired[pulumi.Input[Sequence[pulumi.Input['ApplicationProcessArgsDict']]]]
        """
        A list of processes to monitor for the component. Only Windows EC2 instances can have a processes section.
        """
        sql_server_prometheus_exporter: NotRequired[pulumi.Input['ApplicationSqlServerPrometheusExporterArgsDict']]
        """
        The SQL Prometheus Exporter settings.
        """
        windows_events: NotRequired[pulumi.Input[Sequence[pulumi.Input['ApplicationWindowsEventArgsDict']]]]
        """
        A list of Windows Events to log.
        """
elif False:
    ApplicationConfigurationDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationConfigurationDetailsArgs:
    def __init__(__self__, *,
                 alarm_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgs']]]] = None,
                 alarms: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmArgs']]]] = None,
                 ha_cluster_prometheus_exporter: Optional[pulumi.Input['ApplicationHaClusterPrometheusExporterArgs']] = None,
                 hana_prometheus_exporter: Optional[pulumi.Input['ApplicationHanaPrometheusExporterArgs']] = None,
                 jmx_prometheus_exporter: Optional[pulumi.Input['ApplicationJmxPrometheusExporterArgs']] = None,
                 logs: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationLogArgs']]]] = None,
                 net_weaver_prometheus_exporter: Optional[pulumi.Input['ApplicationNetWeaverPrometheusExporterArgs']] = None,
                 processes: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationProcessArgs']]]] = None,
                 sql_server_prometheus_exporter: Optional[pulumi.Input['ApplicationSqlServerPrometheusExporterArgs']] = None,
                 windows_events: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationWindowsEventArgs']]]] = None):
        """
        The configuration settings.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgs']]] alarm_metrics: A list of metrics to monitor for the component.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmArgs']]] alarms: A list of alarms to monitor for the component.
        :param pulumi.Input['ApplicationHaClusterPrometheusExporterArgs'] ha_cluster_prometheus_exporter: The HA cluster Prometheus Exporter settings.
        :param pulumi.Input['ApplicationHanaPrometheusExporterArgs'] hana_prometheus_exporter: The HANA DB Prometheus Exporter settings.
        :param pulumi.Input['ApplicationJmxPrometheusExporterArgs'] jmx_prometheus_exporter: The JMX Prometheus Exporter settings.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationLogArgs']]] logs: A list of logs to monitor for the component.
        :param pulumi.Input['ApplicationNetWeaverPrometheusExporterArgs'] net_weaver_prometheus_exporter: The NetWeaver Prometheus Exporter settings.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationProcessArgs']]] processes: A list of processes to monitor for the component. Only Windows EC2 instances can have a processes section.
        :param pulumi.Input['ApplicationSqlServerPrometheusExporterArgs'] sql_server_prometheus_exporter: The SQL Prometheus Exporter settings.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationWindowsEventArgs']]] windows_events: A list of Windows Events to log.
        """
        if alarm_metrics is not None:
            pulumi.set(__self__, "alarm_metrics", alarm_metrics)
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if ha_cluster_prometheus_exporter is not None:
            pulumi.set(__self__, "ha_cluster_prometheus_exporter", ha_cluster_prometheus_exporter)
        if hana_prometheus_exporter is not None:
            pulumi.set(__self__, "hana_prometheus_exporter", hana_prometheus_exporter)
        if jmx_prometheus_exporter is not None:
            pulumi.set(__self__, "jmx_prometheus_exporter", jmx_prometheus_exporter)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if net_weaver_prometheus_exporter is not None:
            pulumi.set(__self__, "net_weaver_prometheus_exporter", net_weaver_prometheus_exporter)
        if processes is not None:
            pulumi.set(__self__, "processes", processes)
        if sql_server_prometheus_exporter is not None:
            pulumi.set(__self__, "sql_server_prometheus_exporter", sql_server_prometheus_exporter)
        if windows_events is not None:
            pulumi.set(__self__, "windows_events", windows_events)

    @property
    @pulumi.getter(name="alarmMetrics")
    def alarm_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgs']]]]:
        """
        A list of metrics to monitor for the component.
        """
        return pulumi.get(self, "alarm_metrics")

    @alarm_metrics.setter
    def alarm_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgs']]]]):
        pulumi.set(self, "alarm_metrics", value)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmArgs']]]]:
        """
        A list of alarms to monitor for the component.
        """
        return pulumi.get(self, "alarms")

    @alarms.setter
    def alarms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmArgs']]]]):
        pulumi.set(self, "alarms", value)

    @property
    @pulumi.getter(name="haClusterPrometheusExporter")
    def ha_cluster_prometheus_exporter(self) -> Optional[pulumi.Input['ApplicationHaClusterPrometheusExporterArgs']]:
        """
        The HA cluster Prometheus Exporter settings.
        """
        return pulumi.get(self, "ha_cluster_prometheus_exporter")

    @ha_cluster_prometheus_exporter.setter
    def ha_cluster_prometheus_exporter(self, value: Optional[pulumi.Input['ApplicationHaClusterPrometheusExporterArgs']]):
        pulumi.set(self, "ha_cluster_prometheus_exporter", value)

    @property
    @pulumi.getter(name="hanaPrometheusExporter")
    def hana_prometheus_exporter(self) -> Optional[pulumi.Input['ApplicationHanaPrometheusExporterArgs']]:
        """
        The HANA DB Prometheus Exporter settings.
        """
        return pulumi.get(self, "hana_prometheus_exporter")

    @hana_prometheus_exporter.setter
    def hana_prometheus_exporter(self, value: Optional[pulumi.Input['ApplicationHanaPrometheusExporterArgs']]):
        pulumi.set(self, "hana_prometheus_exporter", value)

    @property
    @pulumi.getter(name="jmxPrometheusExporter")
    def jmx_prometheus_exporter(self) -> Optional[pulumi.Input['ApplicationJmxPrometheusExporterArgs']]:
        """
        The JMX Prometheus Exporter settings.
        """
        return pulumi.get(self, "jmx_prometheus_exporter")

    @jmx_prometheus_exporter.setter
    def jmx_prometheus_exporter(self, value: Optional[pulumi.Input['ApplicationJmxPrometheusExporterArgs']]):
        pulumi.set(self, "jmx_prometheus_exporter", value)

    @property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationLogArgs']]]]:
        """
        A list of logs to monitor for the component.
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationLogArgs']]]]):
        pulumi.set(self, "logs", value)

    @property
    @pulumi.getter(name="netWeaverPrometheusExporter")
    def net_weaver_prometheus_exporter(self) -> Optional[pulumi.Input['ApplicationNetWeaverPrometheusExporterArgs']]:
        """
        The NetWeaver Prometheus Exporter settings.
        """
        return pulumi.get(self, "net_weaver_prometheus_exporter")

    @net_weaver_prometheus_exporter.setter
    def net_weaver_prometheus_exporter(self, value: Optional[pulumi.Input['ApplicationNetWeaverPrometheusExporterArgs']]):
        pulumi.set(self, "net_weaver_prometheus_exporter", value)

    @property
    @pulumi.getter
    def processes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationProcessArgs']]]]:
        """
        A list of processes to monitor for the component. Only Windows EC2 instances can have a processes section.
        """
        return pulumi.get(self, "processes")

    @processes.setter
    def processes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationProcessArgs']]]]):
        pulumi.set(self, "processes", value)

    @property
    @pulumi.getter(name="sqlServerPrometheusExporter")
    def sql_server_prometheus_exporter(self) -> Optional[pulumi.Input['ApplicationSqlServerPrometheusExporterArgs']]:
        """
        The SQL Prometheus Exporter settings.
        """
        return pulumi.get(self, "sql_server_prometheus_exporter")

    @sql_server_prometheus_exporter.setter
    def sql_server_prometheus_exporter(self, value: Optional[pulumi.Input['ApplicationSqlServerPrometheusExporterArgs']]):
        pulumi.set(self, "sql_server_prometheus_exporter", value)

    @property
    @pulumi.getter(name="windowsEvents")
    def windows_events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationWindowsEventArgs']]]]:
        """
        A list of Windows Events to log.
        """
        return pulumi.get(self, "windows_events")

    @windows_events.setter
    def windows_events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationWindowsEventArgs']]]]):
        pulumi.set(self, "windows_events", value)


if not MYPY:
    class ApplicationCustomComponentArgsDict(TypedDict):
        """
        The custom grouped component.
        """
        component_name: pulumi.Input[builtins.str]
        """
        The name of the component.
        """
        resource_list: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The list of resource ARNs that belong to the component.
        """
elif False:
    ApplicationCustomComponentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationCustomComponentArgs:
    def __init__(__self__, *,
                 component_name: pulumi.Input[builtins.str],
                 resource_list: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        The custom grouped component.
        :param pulumi.Input[builtins.str] component_name: The name of the component.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resource_list: The list of resource ARNs that belong to the component.
        """
        pulumi.set(__self__, "component_name", component_name)
        pulumi.set(__self__, "resource_list", resource_list)

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the component.
        """
        return pulumi.get(self, "component_name")

    @component_name.setter
    def component_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "component_name", value)

    @property
    @pulumi.getter(name="resourceList")
    def resource_list(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The list of resource ARNs that belong to the component.
        """
        return pulumi.get(self, "resource_list")

    @resource_list.setter
    def resource_list(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "resource_list", value)


if not MYPY:
    class ApplicationHaClusterPrometheusExporterArgsDict(TypedDict):
        """
        The HA cluster Prometheus Exporter settings.
        """
        prometheus_port: NotRequired[pulumi.Input[builtins.str]]
        """
        Prometheus exporter port.
        """
elif False:
    ApplicationHaClusterPrometheusExporterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationHaClusterPrometheusExporterArgs:
    def __init__(__self__, *,
                 prometheus_port: Optional[pulumi.Input[builtins.str]] = None):
        """
        The HA cluster Prometheus Exporter settings.
        :param pulumi.Input[builtins.str] prometheus_port: Prometheus exporter port.
        """
        if prometheus_port is not None:
            pulumi.set(__self__, "prometheus_port", prometheus_port)

    @property
    @pulumi.getter(name="prometheusPort")
    def prometheus_port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Prometheus exporter port.
        """
        return pulumi.get(self, "prometheus_port")

    @prometheus_port.setter
    def prometheus_port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prometheus_port", value)


if not MYPY:
    class ApplicationHanaPrometheusExporterArgsDict(TypedDict):
        """
        The HANA DB Prometheus Exporter settings.
        """
        agree_to_install_hanadb_client: pulumi.Input[builtins.bool]
        """
        A flag which indicates agreeing to install SAP HANA DB client.
        """
        hana_port: pulumi.Input[builtins.str]
        """
        The HANA DB port.
        """
        hana_secret_name: pulumi.Input[builtins.str]
        """
        The secret name which manages the HANA DB credentials e.g. {
          "username": "<>",
          "password": "<>"
        }.
        """
        hanasid: pulumi.Input[builtins.str]
        """
        HANA DB SID.
        """
        prometheus_port: NotRequired[pulumi.Input[builtins.str]]
        """
        Prometheus exporter port.
        """
elif False:
    ApplicationHanaPrometheusExporterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationHanaPrometheusExporterArgs:
    def __init__(__self__, *,
                 agree_to_install_hanadb_client: pulumi.Input[builtins.bool],
                 hana_port: pulumi.Input[builtins.str],
                 hana_secret_name: pulumi.Input[builtins.str],
                 hanasid: pulumi.Input[builtins.str],
                 prometheus_port: Optional[pulumi.Input[builtins.str]] = None):
        """
        The HANA DB Prometheus Exporter settings.
        :param pulumi.Input[builtins.bool] agree_to_install_hanadb_client: A flag which indicates agreeing to install SAP HANA DB client.
        :param pulumi.Input[builtins.str] hana_port: The HANA DB port.
        :param pulumi.Input[builtins.str] hana_secret_name: The secret name which manages the HANA DB credentials e.g. {
                 "username": "<>",
                 "password": "<>"
               }.
        :param pulumi.Input[builtins.str] hanasid: HANA DB SID.
        :param pulumi.Input[builtins.str] prometheus_port: Prometheus exporter port.
        """
        pulumi.set(__self__, "agree_to_install_hanadb_client", agree_to_install_hanadb_client)
        pulumi.set(__self__, "hana_port", hana_port)
        pulumi.set(__self__, "hana_secret_name", hana_secret_name)
        pulumi.set(__self__, "hanasid", hanasid)
        if prometheus_port is not None:
            pulumi.set(__self__, "prometheus_port", prometheus_port)

    @property
    @pulumi.getter(name="agreeToInstallHanadbClient")
    def agree_to_install_hanadb_client(self) -> pulumi.Input[builtins.bool]:
        """
        A flag which indicates agreeing to install SAP HANA DB client.
        """
        return pulumi.get(self, "agree_to_install_hanadb_client")

    @agree_to_install_hanadb_client.setter
    def agree_to_install_hanadb_client(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "agree_to_install_hanadb_client", value)

    @property
    @pulumi.getter(name="hanaPort")
    def hana_port(self) -> pulumi.Input[builtins.str]:
        """
        The HANA DB port.
        """
        return pulumi.get(self, "hana_port")

    @hana_port.setter
    def hana_port(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hana_port", value)

    @property
    @pulumi.getter(name="hanaSecretName")
    def hana_secret_name(self) -> pulumi.Input[builtins.str]:
        """
        The secret name which manages the HANA DB credentials e.g. {
          "username": "<>",
          "password": "<>"
        }.
        """
        return pulumi.get(self, "hana_secret_name")

    @hana_secret_name.setter
    def hana_secret_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hana_secret_name", value)

    @property
    @pulumi.getter
    def hanasid(self) -> pulumi.Input[builtins.str]:
        """
        HANA DB SID.
        """
        return pulumi.get(self, "hanasid")

    @hanasid.setter
    def hanasid(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hanasid", value)

    @property
    @pulumi.getter(name="prometheusPort")
    def prometheus_port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Prometheus exporter port.
        """
        return pulumi.get(self, "prometheus_port")

    @prometheus_port.setter
    def prometheus_port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prometheus_port", value)


if not MYPY:
    class ApplicationJmxPrometheusExporterArgsDict(TypedDict):
        """
        The JMX Prometheus Exporter settings.
        """
        host_port: NotRequired[pulumi.Input[builtins.str]]
        """
        Java agent host port
        """
        jmxurl: NotRequired[pulumi.Input[builtins.str]]
        """
        JMX service URL.
        """
        prometheus_port: NotRequired[pulumi.Input[builtins.str]]
        """
        Prometheus exporter port.
        """
elif False:
    ApplicationJmxPrometheusExporterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationJmxPrometheusExporterArgs:
    def __init__(__self__, *,
                 host_port: Optional[pulumi.Input[builtins.str]] = None,
                 jmxurl: Optional[pulumi.Input[builtins.str]] = None,
                 prometheus_port: Optional[pulumi.Input[builtins.str]] = None):
        """
        The JMX Prometheus Exporter settings.
        :param pulumi.Input[builtins.str] host_port: Java agent host port
        :param pulumi.Input[builtins.str] jmxurl: JMX service URL.
        :param pulumi.Input[builtins.str] prometheus_port: Prometheus exporter port.
        """
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if jmxurl is not None:
            pulumi.set(__self__, "jmxurl", jmxurl)
        if prometheus_port is not None:
            pulumi.set(__self__, "prometheus_port", prometheus_port)

    @property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Java agent host port
        """
        return pulumi.get(self, "host_port")

    @host_port.setter
    def host_port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_port", value)

    @property
    @pulumi.getter
    def jmxurl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        JMX service URL.
        """
        return pulumi.get(self, "jmxurl")

    @jmxurl.setter
    def jmxurl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "jmxurl", value)

    @property
    @pulumi.getter(name="prometheusPort")
    def prometheus_port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Prometheus exporter port.
        """
        return pulumi.get(self, "prometheus_port")

    @prometheus_port.setter
    def prometheus_port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prometheus_port", value)


if not MYPY:
    class ApplicationLogPatternSetArgsDict(TypedDict):
        """
        The log pattern set.
        """
        log_patterns: pulumi.Input[Sequence[pulumi.Input['ApplicationLogPatternArgsDict']]]
        """
        The log patterns of a set.
        """
        pattern_set_name: pulumi.Input[builtins.str]
        """
        The name of the log pattern set.
        """
elif False:
    ApplicationLogPatternSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationLogPatternSetArgs:
    def __init__(__self__, *,
                 log_patterns: pulumi.Input[Sequence[pulumi.Input['ApplicationLogPatternArgs']]],
                 pattern_set_name: pulumi.Input[builtins.str]):
        """
        The log pattern set.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationLogPatternArgs']]] log_patterns: The log patterns of a set.
        :param pulumi.Input[builtins.str] pattern_set_name: The name of the log pattern set.
        """
        pulumi.set(__self__, "log_patterns", log_patterns)
        pulumi.set(__self__, "pattern_set_name", pattern_set_name)

    @property
    @pulumi.getter(name="logPatterns")
    def log_patterns(self) -> pulumi.Input[Sequence[pulumi.Input['ApplicationLogPatternArgs']]]:
        """
        The log patterns of a set.
        """
        return pulumi.get(self, "log_patterns")

    @log_patterns.setter
    def log_patterns(self, value: pulumi.Input[Sequence[pulumi.Input['ApplicationLogPatternArgs']]]):
        pulumi.set(self, "log_patterns", value)

    @property
    @pulumi.getter(name="patternSetName")
    def pattern_set_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the log pattern set.
        """
        return pulumi.get(self, "pattern_set_name")

    @pattern_set_name.setter
    def pattern_set_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pattern_set_name", value)


if not MYPY:
    class ApplicationLogPatternArgsDict(TypedDict):
        """
        The log pattern.
        """
        pattern: pulumi.Input[builtins.str]
        """
        The log pattern.
        """
        pattern_name: pulumi.Input[builtins.str]
        """
        The name of the log pattern.
        """
        rank: pulumi.Input[builtins.int]
        """
        Rank of the log pattern.
        """
elif False:
    ApplicationLogPatternArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationLogPatternArgs:
    def __init__(__self__, *,
                 pattern: pulumi.Input[builtins.str],
                 pattern_name: pulumi.Input[builtins.str],
                 rank: pulumi.Input[builtins.int]):
        """
        The log pattern.
        :param pulumi.Input[builtins.str] pattern: The log pattern.
        :param pulumi.Input[builtins.str] pattern_name: The name of the log pattern.
        :param pulumi.Input[builtins.int] rank: Rank of the log pattern.
        """
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "pattern_name", pattern_name)
        pulumi.set(__self__, "rank", rank)

    @property
    @pulumi.getter
    def pattern(self) -> pulumi.Input[builtins.str]:
        """
        The log pattern.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="patternName")
    def pattern_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the log pattern.
        """
        return pulumi.get(self, "pattern_name")

    @pattern_name.setter
    def pattern_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pattern_name", value)

    @property
    @pulumi.getter
    def rank(self) -> pulumi.Input[builtins.int]:
        """
        Rank of the log pattern.
        """
        return pulumi.get(self, "rank")

    @rank.setter
    def rank(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "rank", value)


if not MYPY:
    class ApplicationLogArgsDict(TypedDict):
        """
        A log to be monitored for the component.
        """
        log_type: pulumi.Input[builtins.str]
        """
        The log type decides the log patterns against which Application Insights analyzes the log.
        """
        encoding: NotRequired[pulumi.Input['ApplicationLogEncoding']]
        """
        The type of encoding of the logs to be monitored.
        """
        log_group_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The CloudWatch log group name to be associated to the monitored log.
        """
        log_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The path of the logs to be monitored.
        """
        pattern_set: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the log pattern set.
        """
elif False:
    ApplicationLogArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationLogArgs:
    def __init__(__self__, *,
                 log_type: pulumi.Input[builtins.str],
                 encoding: Optional[pulumi.Input['ApplicationLogEncoding']] = None,
                 log_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 log_path: Optional[pulumi.Input[builtins.str]] = None,
                 pattern_set: Optional[pulumi.Input[builtins.str]] = None):
        """
        A log to be monitored for the component.
        :param pulumi.Input[builtins.str] log_type: The log type decides the log patterns against which Application Insights analyzes the log.
        :param pulumi.Input['ApplicationLogEncoding'] encoding: The type of encoding of the logs to be monitored.
        :param pulumi.Input[builtins.str] log_group_name: The CloudWatch log group name to be associated to the monitored log.
        :param pulumi.Input[builtins.str] log_path: The path of the logs to be monitored.
        :param pulumi.Input[builtins.str] pattern_set: The name of the log pattern set.
        """
        pulumi.set(__self__, "log_type", log_type)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if log_path is not None:
            pulumi.set(__self__, "log_path", log_path)
        if pattern_set is not None:
            pulumi.set(__self__, "pattern_set", pattern_set)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> pulumi.Input[builtins.str]:
        """
        The log type decides the log patterns against which Application Insights analyzes the log.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "log_type", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input['ApplicationLogEncoding']]:
        """
        The type of encoding of the logs to be monitored.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input['ApplicationLogEncoding']]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CloudWatch log group name to be associated to the monitored log.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_group_name", value)

    @property
    @pulumi.getter(name="logPath")
    def log_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path of the logs to be monitored.
        """
        return pulumi.get(self, "log_path")

    @log_path.setter
    def log_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_path", value)

    @property
    @pulumi.getter(name="patternSet")
    def pattern_set(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the log pattern set.
        """
        return pulumi.get(self, "pattern_set")

    @pattern_set.setter
    def pattern_set(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern_set", value)


if not MYPY:
    class ApplicationNetWeaverPrometheusExporterArgsDict(TypedDict):
        """
        The NetWeaver Prometheus Exporter Settings.
        """
        instance_numbers: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        SAP instance numbers for ASCS, ERS, and App Servers.
        """
        sapsid: pulumi.Input[builtins.str]
        """
        SAP NetWeaver SID.
        """
        prometheus_port: NotRequired[pulumi.Input[builtins.str]]
        """
        Prometheus exporter port.
        """
elif False:
    ApplicationNetWeaverPrometheusExporterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationNetWeaverPrometheusExporterArgs:
    def __init__(__self__, *,
                 instance_numbers: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 sapsid: pulumi.Input[builtins.str],
                 prometheus_port: Optional[pulumi.Input[builtins.str]] = None):
        """
        The NetWeaver Prometheus Exporter Settings.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_numbers: SAP instance numbers for ASCS, ERS, and App Servers.
        :param pulumi.Input[builtins.str] sapsid: SAP NetWeaver SID.
        :param pulumi.Input[builtins.str] prometheus_port: Prometheus exporter port.
        """
        pulumi.set(__self__, "instance_numbers", instance_numbers)
        pulumi.set(__self__, "sapsid", sapsid)
        if prometheus_port is not None:
            pulumi.set(__self__, "prometheus_port", prometheus_port)

    @property
    @pulumi.getter(name="instanceNumbers")
    def instance_numbers(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        SAP instance numbers for ASCS, ERS, and App Servers.
        """
        return pulumi.get(self, "instance_numbers")

    @instance_numbers.setter
    def instance_numbers(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "instance_numbers", value)

    @property
    @pulumi.getter
    def sapsid(self) -> pulumi.Input[builtins.str]:
        """
        SAP NetWeaver SID.
        """
        return pulumi.get(self, "sapsid")

    @sapsid.setter
    def sapsid(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sapsid", value)

    @property
    @pulumi.getter(name="prometheusPort")
    def prometheus_port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Prometheus exporter port.
        """
        return pulumi.get(self, "prometheus_port")

    @prometheus_port.setter
    def prometheus_port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prometheus_port", value)


if not MYPY:
    class ApplicationProcessArgsDict(TypedDict):
        """
        A process to be monitored for the component.
        """
        alarm_metrics: pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgsDict']]]
        """
        A list of metrics to monitor for the component.
        """
        process_name: pulumi.Input[builtins.str]
        """
        The name of the process to be monitored for the component.
        """
elif False:
    ApplicationProcessArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationProcessArgs:
    def __init__(__self__, *,
                 alarm_metrics: pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgs']]],
                 process_name: pulumi.Input[builtins.str]):
        """
        A process to be monitored for the component.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgs']]] alarm_metrics: A list of metrics to monitor for the component.
        :param pulumi.Input[builtins.str] process_name: The name of the process to be monitored for the component.
        """
        pulumi.set(__self__, "alarm_metrics", alarm_metrics)
        pulumi.set(__self__, "process_name", process_name)

    @property
    @pulumi.getter(name="alarmMetrics")
    def alarm_metrics(self) -> pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgs']]]:
        """
        A list of metrics to monitor for the component.
        """
        return pulumi.get(self, "alarm_metrics")

    @alarm_metrics.setter
    def alarm_metrics(self, value: pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgs']]]):
        pulumi.set(self, "alarm_metrics", value)

    @property
    @pulumi.getter(name="processName")
    def process_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the process to be monitored for the component.
        """
        return pulumi.get(self, "process_name")

    @process_name.setter
    def process_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "process_name", value)


if not MYPY:
    class ApplicationSqlServerPrometheusExporterArgsDict(TypedDict):
        """
        The SQL prometheus exporter settings.
        """
        prometheus_port: pulumi.Input[builtins.str]
        """
        Prometheus exporter port.
        """
        sql_secret_name: pulumi.Input[builtins.str]
        """
        Secret name which managers SQL exporter connection. e.g. {"data_source_name": "sqlserver://<USERNAME>:<PASSWORD>@localhost:1433"}
        """
elif False:
    ApplicationSqlServerPrometheusExporterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationSqlServerPrometheusExporterArgs:
    def __init__(__self__, *,
                 prometheus_port: pulumi.Input[builtins.str],
                 sql_secret_name: pulumi.Input[builtins.str]):
        """
        The SQL prometheus exporter settings.
        :param pulumi.Input[builtins.str] prometheus_port: Prometheus exporter port.
        :param pulumi.Input[builtins.str] sql_secret_name: Secret name which managers SQL exporter connection. e.g. {"data_source_name": "sqlserver://<USERNAME>:<PASSWORD>@localhost:1433"}
        """
        pulumi.set(__self__, "prometheus_port", prometheus_port)
        pulumi.set(__self__, "sql_secret_name", sql_secret_name)

    @property
    @pulumi.getter(name="prometheusPort")
    def prometheus_port(self) -> pulumi.Input[builtins.str]:
        """
        Prometheus exporter port.
        """
        return pulumi.get(self, "prometheus_port")

    @prometheus_port.setter
    def prometheus_port(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "prometheus_port", value)

    @property
    @pulumi.getter(name="sqlSecretName")
    def sql_secret_name(self) -> pulumi.Input[builtins.str]:
        """
        Secret name which managers SQL exporter connection. e.g. {"data_source_name": "sqlserver://<USERNAME>:<PASSWORD>@localhost:1433"}
        """
        return pulumi.get(self, "sql_secret_name")

    @sql_secret_name.setter
    def sql_secret_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sql_secret_name", value)


if not MYPY:
    class ApplicationSubComponentConfigurationDetailsArgsDict(TypedDict):
        """
        The configuration settings of sub components.
        """
        alarm_metrics: NotRequired[pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgsDict']]]]
        """
        A list of metrics to monitor for the component.
        """
        logs: NotRequired[pulumi.Input[Sequence[pulumi.Input['ApplicationLogArgsDict']]]]
        """
        A list of logs to monitor for the component.
        """
        processes: NotRequired[pulumi.Input[Sequence[pulumi.Input['ApplicationProcessArgsDict']]]]
        """
        A list of processes to monitor for the component. Only Windows EC2 instances can have a processes section.
        """
        windows_events: NotRequired[pulumi.Input[Sequence[pulumi.Input['ApplicationWindowsEventArgsDict']]]]
        """
        A list of Windows Events to log.
        """
elif False:
    ApplicationSubComponentConfigurationDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationSubComponentConfigurationDetailsArgs:
    def __init__(__self__, *,
                 alarm_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgs']]]] = None,
                 logs: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationLogArgs']]]] = None,
                 processes: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationProcessArgs']]]] = None,
                 windows_events: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationWindowsEventArgs']]]] = None):
        """
        The configuration settings of sub components.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgs']]] alarm_metrics: A list of metrics to monitor for the component.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationLogArgs']]] logs: A list of logs to monitor for the component.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationProcessArgs']]] processes: A list of processes to monitor for the component. Only Windows EC2 instances can have a processes section.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationWindowsEventArgs']]] windows_events: A list of Windows Events to log.
        """
        if alarm_metrics is not None:
            pulumi.set(__self__, "alarm_metrics", alarm_metrics)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if processes is not None:
            pulumi.set(__self__, "processes", processes)
        if windows_events is not None:
            pulumi.set(__self__, "windows_events", windows_events)

    @property
    @pulumi.getter(name="alarmMetrics")
    def alarm_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgs']]]]:
        """
        A list of metrics to monitor for the component.
        """
        return pulumi.get(self, "alarm_metrics")

    @alarm_metrics.setter
    def alarm_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAlarmMetricArgs']]]]):
        pulumi.set(self, "alarm_metrics", value)

    @property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationLogArgs']]]]:
        """
        A list of logs to monitor for the component.
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationLogArgs']]]]):
        pulumi.set(self, "logs", value)

    @property
    @pulumi.getter
    def processes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationProcessArgs']]]]:
        """
        A list of processes to monitor for the component. Only Windows EC2 instances can have a processes section.
        """
        return pulumi.get(self, "processes")

    @processes.setter
    def processes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationProcessArgs']]]]):
        pulumi.set(self, "processes", value)

    @property
    @pulumi.getter(name="windowsEvents")
    def windows_events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationWindowsEventArgs']]]]:
        """
        A list of Windows Events to log.
        """
        return pulumi.get(self, "windows_events")

    @windows_events.setter
    def windows_events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationWindowsEventArgs']]]]):
        pulumi.set(self, "windows_events", value)


if not MYPY:
    class ApplicationSubComponentTypeConfigurationArgsDict(TypedDict):
        """
        One type sub component configurations for the component.
        """
        sub_component_configuration_details: pulumi.Input['ApplicationSubComponentConfigurationDetailsArgsDict']
        """
        The configuration settings of sub components.
        """
        sub_component_type: pulumi.Input['ApplicationSubComponentTypeConfigurationSubComponentType']
        """
        The sub component type.
        """
elif False:
    ApplicationSubComponentTypeConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationSubComponentTypeConfigurationArgs:
    def __init__(__self__, *,
                 sub_component_configuration_details: pulumi.Input['ApplicationSubComponentConfigurationDetailsArgs'],
                 sub_component_type: pulumi.Input['ApplicationSubComponentTypeConfigurationSubComponentType']):
        """
        One type sub component configurations for the component.
        :param pulumi.Input['ApplicationSubComponentConfigurationDetailsArgs'] sub_component_configuration_details: The configuration settings of sub components.
        :param pulumi.Input['ApplicationSubComponentTypeConfigurationSubComponentType'] sub_component_type: The sub component type.
        """
        pulumi.set(__self__, "sub_component_configuration_details", sub_component_configuration_details)
        pulumi.set(__self__, "sub_component_type", sub_component_type)

    @property
    @pulumi.getter(name="subComponentConfigurationDetails")
    def sub_component_configuration_details(self) -> pulumi.Input['ApplicationSubComponentConfigurationDetailsArgs']:
        """
        The configuration settings of sub components.
        """
        return pulumi.get(self, "sub_component_configuration_details")

    @sub_component_configuration_details.setter
    def sub_component_configuration_details(self, value: pulumi.Input['ApplicationSubComponentConfigurationDetailsArgs']):
        pulumi.set(self, "sub_component_configuration_details", value)

    @property
    @pulumi.getter(name="subComponentType")
    def sub_component_type(self) -> pulumi.Input['ApplicationSubComponentTypeConfigurationSubComponentType']:
        """
        The sub component type.
        """
        return pulumi.get(self, "sub_component_type")

    @sub_component_type.setter
    def sub_component_type(self, value: pulumi.Input['ApplicationSubComponentTypeConfigurationSubComponentType']):
        pulumi.set(self, "sub_component_type", value)


if not MYPY:
    class ApplicationWindowsEventArgsDict(TypedDict):
        """
        A Windows Event to be monitored for the component.
        """
        event_levels: pulumi.Input[Sequence[pulumi.Input['ApplicationEventLevel']]]
        """
        The levels of event to log. 
        """
        event_name: pulumi.Input[builtins.str]
        """
        The type of Windows Events to log.
        """
        log_group_name: pulumi.Input[builtins.str]
        """
        The CloudWatch log group name to be associated to the monitored log.
        """
        pattern_set: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the log pattern set.
        """
elif False:
    ApplicationWindowsEventArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationWindowsEventArgs:
    def __init__(__self__, *,
                 event_levels: pulumi.Input[Sequence[pulumi.Input['ApplicationEventLevel']]],
                 event_name: pulumi.Input[builtins.str],
                 log_group_name: pulumi.Input[builtins.str],
                 pattern_set: Optional[pulumi.Input[builtins.str]] = None):
        """
        A Windows Event to be monitored for the component.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationEventLevel']]] event_levels: The levels of event to log. 
        :param pulumi.Input[builtins.str] event_name: The type of Windows Events to log.
        :param pulumi.Input[builtins.str] log_group_name: The CloudWatch log group name to be associated to the monitored log.
        :param pulumi.Input[builtins.str] pattern_set: The name of the log pattern set.
        """
        pulumi.set(__self__, "event_levels", event_levels)
        pulumi.set(__self__, "event_name", event_name)
        pulumi.set(__self__, "log_group_name", log_group_name)
        if pattern_set is not None:
            pulumi.set(__self__, "pattern_set", pattern_set)

    @property
    @pulumi.getter(name="eventLevels")
    def event_levels(self) -> pulumi.Input[Sequence[pulumi.Input['ApplicationEventLevel']]]:
        """
        The levels of event to log. 
        """
        return pulumi.get(self, "event_levels")

    @event_levels.setter
    def event_levels(self, value: pulumi.Input[Sequence[pulumi.Input['ApplicationEventLevel']]]):
        pulumi.set(self, "event_levels", value)

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> pulumi.Input[builtins.str]:
        """
        The type of Windows Events to log.
        """
        return pulumi.get(self, "event_name")

    @event_name.setter
    def event_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "event_name", value)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The CloudWatch log group name to be associated to the monitored log.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "log_group_name", value)

    @property
    @pulumi.getter(name="patternSet")
    def pattern_set(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the log pattern set.
        """
        return pulumi.get(self, "pattern_set")

    @pattern_set.setter
    def pattern_set(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern_set", value)


