# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ConfigurationProfileValidators',
    'DeploymentDynamicExtensionParameters',
    'EnvironmentMonitor',
    'ExtensionAction',
    'ExtensionParameter',
]

@pulumi.output_type
class ConfigurationProfileValidators(dict):
    """
    A list of methods for validating the configuration.
    """
    def __init__(__self__, *,
                 content: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        A list of methods for validating the configuration.
        :param builtins.str content: Either the JSON Schema content or the Amazon Resource Name (ARN) of an Lambda function.
        :param builtins.str type: AWS AppConfig supports validators of type JSON_SCHEMA and LAMBDA.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def content(self) -> Optional[builtins.str]:
        """
        Either the JSON Schema content or the Amazon Resource Name (ARN) of an Lambda function.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        AWS AppConfig supports validators of type JSON_SCHEMA and LAMBDA.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DeploymentDynamicExtensionParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extensionReference":
            suggest = "extension_reference"
        elif key == "parameterName":
            suggest = "parameter_name"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentDynamicExtensionParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentDynamicExtensionParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentDynamicExtensionParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extension_reference: Optional[builtins.str] = None,
                 parameter_name: Optional[builtins.str] = None,
                 parameter_value: Optional[builtins.str] = None):
        """
        :param builtins.str extension_reference: The ARN or ID of the extension for which you are inserting a dynamic parameter.
        :param builtins.str parameter_name: The parameter name.
        :param builtins.str parameter_value: The parameter value.
        """
        if extension_reference is not None:
            pulumi.set(__self__, "extension_reference", extension_reference)
        if parameter_name is not None:
            pulumi.set(__self__, "parameter_name", parameter_name)
        if parameter_value is not None:
            pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="extensionReference")
    def extension_reference(self) -> Optional[builtins.str]:
        """
        The ARN or ID of the extension for which you are inserting a dynamic parameter.
        """
        return pulumi.get(self, "extension_reference")

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> Optional[builtins.str]:
        """
        The parameter name.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> Optional[builtins.str]:
        """
        The parameter value.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class EnvironmentMonitor(dict):
    """
    Amazon CloudWatch alarm to monitor during the deployment process.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alarmArn":
            suggest = "alarm_arn"
        elif key == "alarmRoleArn":
            suggest = "alarm_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentMonitor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentMonitor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentMonitor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarm_arn: builtins.str,
                 alarm_role_arn: Optional[builtins.str] = None):
        """
        Amazon CloudWatch alarm to monitor during the deployment process.
        :param builtins.str alarm_arn: Amazon Resource Name (ARN) of the Amazon CloudWatch alarm.
        :param builtins.str alarm_role_arn: ARN of an AWS Identity and Access Management (IAM) role for AWS AppConfig to monitor AlarmArn.
        """
        pulumi.set(__self__, "alarm_arn", alarm_arn)
        if alarm_role_arn is not None:
            pulumi.set(__self__, "alarm_role_arn", alarm_role_arn)

    @property
    @pulumi.getter(name="alarmArn")
    def alarm_arn(self) -> builtins.str:
        """
        Amazon Resource Name (ARN) of the Amazon CloudWatch alarm.
        """
        return pulumi.get(self, "alarm_arn")

    @property
    @pulumi.getter(name="alarmRoleArn")
    def alarm_role_arn(self) -> Optional[builtins.str]:
        """
        ARN of an AWS Identity and Access Management (IAM) role for AWS AppConfig to monitor AlarmArn.
        """
        return pulumi.get(self, "alarm_role_arn")


@pulumi.output_type
class ExtensionAction(dict):
    """
    An action for an extension to take at a specific action point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 uri: builtins.str,
                 description: Optional[builtins.str] = None,
                 role_arn: Optional[builtins.str] = None):
        """
        An action for an extension to take at a specific action point.
        :param builtins.str name: The name of the extension action.
        :param builtins.str uri: The URI of the extension action.
        :param builtins.str description: The description of the extension Action.
        :param builtins.str role_arn: The ARN of the role for invoking the extension action.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the extension action.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        The URI of the extension action.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the extension Action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the role for invoking the extension action.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class ExtensionParameter(dict):
    """
    A parameter for the extension to send to a specific action.
    """
    def __init__(__self__, *,
                 required: builtins.bool,
                 description: Optional[builtins.str] = None,
                 dynamic: Optional[builtins.bool] = None):
        """
        A parameter for the extension to send to a specific action.
        :param builtins.str description: The description of the extension Parameter.
        """
        pulumi.set(__self__, "required", required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamic is not None:
            pulumi.set(__self__, "dynamic", dynamic)

    @property
    @pulumi.getter
    def required(self) -> builtins.bool:
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the extension Parameter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dynamic(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "dynamic")


