# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HostedConfigurationVersionArgs', 'HostedConfigurationVersion']

@pulumi.input_type
class HostedConfigurationVersionArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[builtins.str],
                 configuration_profile_id: pulumi.Input[builtins.str],
                 content: pulumi.Input[builtins.str],
                 content_type: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 latest_version_number: Optional[pulumi.Input[builtins.int]] = None,
                 version_label: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a HostedConfigurationVersion resource.
        :param pulumi.Input[builtins.str] application_id: The application ID.
        :param pulumi.Input[builtins.str] configuration_profile_id: The configuration profile ID.
        :param pulumi.Input[builtins.str] content: The content of the configuration or the configuration data.
        :param pulumi.Input[builtins.str] content_type: A standard MIME type describing the format of the configuration content.
        :param pulumi.Input[builtins.str] description: A description of the hosted configuration version.
        :param pulumi.Input[builtins.int] latest_version_number: An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.
        :param pulumi.Input[builtins.str] version_label: A user-defined label for an AWS AppConfig hosted configuration version.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "configuration_profile_id", configuration_profile_id)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if latest_version_number is not None:
            pulumi.set(__self__, "latest_version_number", latest_version_number)
        if version_label is not None:
            pulumi.set(__self__, "version_label", version_label)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        The application ID.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="configurationProfileId")
    def configuration_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        The configuration profile ID.
        """
        return pulumi.get(self, "configuration_profile_id")

    @configuration_profile_id.setter
    def configuration_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "configuration_profile_id", value)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[builtins.str]:
        """
        The content of the configuration or the configuration data.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Input[builtins.str]:
        """
        A standard MIME type describing the format of the configuration content.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the hosted configuration version.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="latestVersionNumber")
    def latest_version_number(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.
        """
        return pulumi.get(self, "latest_version_number")

    @latest_version_number.setter
    def latest_version_number(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "latest_version_number", value)

    @property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-defined label for an AWS AppConfig hosted configuration version.
        """
        return pulumi.get(self, "version_label")

    @version_label.setter
    def version_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_label", value)


@pulumi.type_token("aws-native:appconfig:HostedConfigurationVersion")
class HostedConfigurationVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 latest_version_number: Optional[pulumi.Input[builtins.int]] = None,
                 version_label: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::AppConfig::HostedConfigurationVersion

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: The application ID.
        :param pulumi.Input[builtins.str] configuration_profile_id: The configuration profile ID.
        :param pulumi.Input[builtins.str] content: The content of the configuration or the configuration data.
        :param pulumi.Input[builtins.str] content_type: A standard MIME type describing the format of the configuration content.
        :param pulumi.Input[builtins.str] description: A description of the hosted configuration version.
        :param pulumi.Input[builtins.int] latest_version_number: An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.
        :param pulumi.Input[builtins.str] version_label: A user-defined label for an AWS AppConfig hosted configuration version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostedConfigurationVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::AppConfig::HostedConfigurationVersion

        :param str resource_name: The name of the resource.
        :param HostedConfigurationVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostedConfigurationVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 latest_version_number: Optional[pulumi.Input[builtins.int]] = None,
                 version_label: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostedConfigurationVersionArgs.__new__(HostedConfigurationVersionArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            if configuration_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'configuration_profile_id'")
            __props__.__dict__["configuration_profile_id"] = configuration_profile_id
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            if content_type is None and not opts.urn:
                raise TypeError("Missing required property 'content_type'")
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["description"] = description
            __props__.__dict__["latest_version_number"] = latest_version_number
            __props__.__dict__["version_label"] = version_label
            __props__.__dict__["version_number"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["applicationId", "configurationProfileId", "content", "contentType", "description", "latestVersionNumber", "versionLabel"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(HostedConfigurationVersion, __self__).__init__(
            'aws-native:appconfig:HostedConfigurationVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'HostedConfigurationVersion':
        """
        Get an existing HostedConfigurationVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = HostedConfigurationVersionArgs.__new__(HostedConfigurationVersionArgs)

        __props__.__dict__["application_id"] = None
        __props__.__dict__["configuration_profile_id"] = None
        __props__.__dict__["content"] = None
        __props__.__dict__["content_type"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["latest_version_number"] = None
        __props__.__dict__["version_label"] = None
        __props__.__dict__["version_number"] = None
        return HostedConfigurationVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        The application ID.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="configurationProfileId")
    def configuration_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        The configuration profile ID.
        """
        return pulumi.get(self, "configuration_profile_id")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[builtins.str]:
        """
        The content of the configuration or the configuration data.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[builtins.str]:
        """
        A standard MIME type describing the format of the configuration content.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the hosted configuration version.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="latestVersionNumber")
    def latest_version_number(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.
        """
        return pulumi.get(self, "latest_version_number")

    @property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A user-defined label for an AWS AppConfig hosted configuration version.
        """
        return pulumi.get(self, "version_label")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> pulumi.Output[builtins.str]:
        """
        Current version number of hosted configuration version.
        """
        return pulumi.get(self, "version_number")

