# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetDeploymentStrategyResult',
    'AwaitableGetDeploymentStrategyResult',
    'get_deployment_strategy',
    'get_deployment_strategy_output',
]

@pulumi.output_type
class GetDeploymentStrategyResult:
    def __init__(__self__, deployment_duration_in_minutes=None, description=None, final_bake_time_in_minutes=None, growth_factor=None, growth_type=None, id=None, tags=None):
        if deployment_duration_in_minutes and not isinstance(deployment_duration_in_minutes, float):
            raise TypeError("Expected argument 'deployment_duration_in_minutes' to be a float")
        pulumi.set(__self__, "deployment_duration_in_minutes", deployment_duration_in_minutes)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if final_bake_time_in_minutes and not isinstance(final_bake_time_in_minutes, float):
            raise TypeError("Expected argument 'final_bake_time_in_minutes' to be a float")
        pulumi.set(__self__, "final_bake_time_in_minutes", final_bake_time_in_minutes)
        if growth_factor and not isinstance(growth_factor, float):
            raise TypeError("Expected argument 'growth_factor' to be a float")
        pulumi.set(__self__, "growth_factor", growth_factor)
        if growth_type and not isinstance(growth_type, str):
            raise TypeError("Expected argument 'growth_type' to be a str")
        pulumi.set(__self__, "growth_type", growth_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="deploymentDurationInMinutes")
    def deployment_duration_in_minutes(self) -> Optional[builtins.float]:
        """
        Total amount of time for a deployment to last.
        """
        return pulumi.get(self, "deployment_duration_in_minutes")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of the deployment strategy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="finalBakeTimeInMinutes")
    def final_bake_time_in_minutes(self) -> Optional[builtins.float]:
        """
        Specifies the amount of time AWS AppConfig monitors for Amazon CloudWatch alarms after the configuration has been deployed to 100% of its targets, before considering the deployment to be complete. If an alarm is triggered during this time, AWS AppConfig rolls back the deployment. You must configure permissions for AWS AppConfig to roll back based on CloudWatch alarms. For more information, see Configuring permissions for rollback based on Amazon CloudWatch alarms in the AWS AppConfig User Guide.
        """
        return pulumi.get(self, "final_bake_time_in_minutes")

    @property
    @pulumi.getter(name="growthFactor")
    def growth_factor(self) -> Optional[builtins.float]:
        """
        The percentage of targets to receive a deployed configuration during each interval.
        """
        return pulumi.get(self, "growth_factor")

    @property
    @pulumi.getter(name="growthType")
    def growth_type(self) -> Optional['DeploymentStrategyGrowthType']:
        """
        The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:

        Linear: For this type, AWS AppConfig processes the deployment by dividing the total number of targets by the value specified for Step percentage. For example, a linear deployment that uses a Step percentage of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.

        Exponential: For this type, AWS AppConfig processes the deployment exponentially using the following formula: G*(2^N). In this formula, G is the growth factor specified by the user and N is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:

        2*(2^0)

        2*(2^1)

        2*(2^2)

        Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.
        """
        return pulumi.get(self, "growth_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The deployment strategy ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Assigns metadata to an AWS AppConfig resource. Tags help organize and categorize your AWS AppConfig resources. Each tag consists of a key and an optional value, both of which you define. You can specify a maximum of 50 tags for a resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDeploymentStrategyResult(GetDeploymentStrategyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeploymentStrategyResult(
            deployment_duration_in_minutes=self.deployment_duration_in_minutes,
            description=self.description,
            final_bake_time_in_minutes=self.final_bake_time_in_minutes,
            growth_factor=self.growth_factor,
            growth_type=self.growth_type,
            id=self.id,
            tags=self.tags)


def get_deployment_strategy(id: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeploymentStrategyResult:
    """
    Resource Type definition for AWS::AppConfig::DeploymentStrategy


    :param builtins.str id: The deployment strategy ID.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:appconfig:getDeploymentStrategy', __args__, opts=opts, typ=GetDeploymentStrategyResult).value

    return AwaitableGetDeploymentStrategyResult(
        deployment_duration_in_minutes=pulumi.get(__ret__, 'deployment_duration_in_minutes'),
        description=pulumi.get(__ret__, 'description'),
        final_bake_time_in_minutes=pulumi.get(__ret__, 'final_bake_time_in_minutes'),
        growth_factor=pulumi.get(__ret__, 'growth_factor'),
        growth_type=pulumi.get(__ret__, 'growth_type'),
        id=pulumi.get(__ret__, 'id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_deployment_strategy_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDeploymentStrategyResult]:
    """
    Resource Type definition for AWS::AppConfig::DeploymentStrategy


    :param builtins.str id: The deployment strategy ID.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:appconfig:getDeploymentStrategy', __args__, opts=opts, typ=GetDeploymentStrategyResult)
    return __ret__.apply(lambda __response__: GetDeploymentStrategyResult(
        deployment_duration_in_minutes=pulumi.get(__response__, 'deployment_duration_in_minutes'),
        description=pulumi.get(__response__, 'description'),
        final_bake_time_in_minutes=pulumi.get(__response__, 'final_bake_time_in_minutes'),
        growth_factor=pulumi.get(__response__, 'growth_factor'),
        growth_type=pulumi.get(__response__, 'growth_type'),
        id=pulumi.get(__response__, 'id'),
        tags=pulumi.get(__response__, 'tags')))
