# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDeploymentResult',
    'AwaitableGetDeploymentResult',
    'get_deployment',
    'get_deployment_output',
]

@pulumi.output_type
class GetDeploymentResult:
    def __init__(__self__, deployment_number=None):
        if deployment_number and not isinstance(deployment_number, str):
            raise TypeError("Expected argument 'deployment_number' to be a str")
        pulumi.set(__self__, "deployment_number", deployment_number)

    @property
    @pulumi.getter(name="deploymentNumber")
    def deployment_number(self) -> Optional[builtins.str]:
        """
        The sequence number of the deployment.
        """
        return pulumi.get(self, "deployment_number")


class AwaitableGetDeploymentResult(GetDeploymentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeploymentResult(
            deployment_number=self.deployment_number)


def get_deployment(application_id: Optional[builtins.str] = None,
                   deployment_number: Optional[builtins.str] = None,
                   environment_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeploymentResult:
    """
    Resource Type definition for AWS::AppConfig::Deployment


    :param builtins.str application_id: The application ID.
    :param builtins.str deployment_number: The sequence number of the deployment.
    :param builtins.str environment_id: The environment ID.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['deploymentNumber'] = deployment_number
    __args__['environmentId'] = environment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:appconfig:getDeployment', __args__, opts=opts, typ=GetDeploymentResult).value

    return AwaitableGetDeploymentResult(
        deployment_number=pulumi.get(__ret__, 'deployment_number'))
def get_deployment_output(application_id: Optional[pulumi.Input[builtins.str]] = None,
                          deployment_number: Optional[pulumi.Input[builtins.str]] = None,
                          environment_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDeploymentResult]:
    """
    Resource Type definition for AWS::AppConfig::Deployment


    :param builtins.str application_id: The application ID.
    :param builtins.str deployment_number: The sequence number of the deployment.
    :param builtins.str environment_id: The environment ID.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['deploymentNumber'] = deployment_number
    __args__['environmentId'] = environment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:appconfig:getDeployment', __args__, opts=opts, typ=GetDeploymentResult)
    return __ret__.apply(lambda __response__: GetDeploymentResult(
        deployment_number=pulumi.get(__response__, 'deployment_number')))
