# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['DeploymentStrategyArgs', 'DeploymentStrategy']

@pulumi.input_type
class DeploymentStrategyArgs:
    def __init__(__self__, *,
                 deployment_duration_in_minutes: pulumi.Input[builtins.float],
                 growth_factor: pulumi.Input[builtins.float],
                 replicate_to: pulumi.Input['DeploymentStrategyReplicateTo'],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 final_bake_time_in_minutes: Optional[pulumi.Input[builtins.float]] = None,
                 growth_type: Optional[pulumi.Input['DeploymentStrategyGrowthType']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DeploymentStrategy resource.
        :param pulumi.Input[builtins.float] deployment_duration_in_minutes: Total amount of time for a deployment to last.
        :param pulumi.Input[builtins.float] growth_factor: The percentage of targets to receive a deployed configuration during each interval.
        :param pulumi.Input['DeploymentStrategyReplicateTo'] replicate_to: Save the deployment strategy to a Systems Manager (SSM) document.
        :param pulumi.Input[builtins.str] description: A description of the deployment strategy.
        :param pulumi.Input[builtins.float] final_bake_time_in_minutes: Specifies the amount of time AWS AppConfig monitors for Amazon CloudWatch alarms after the configuration has been deployed to 100% of its targets, before considering the deployment to be complete. If an alarm is triggered during this time, AWS AppConfig rolls back the deployment. You must configure permissions for AWS AppConfig to roll back based on CloudWatch alarms. For more information, see Configuring permissions for rollback based on Amazon CloudWatch alarms in the AWS AppConfig User Guide.
        :param pulumi.Input['DeploymentStrategyGrowthType'] growth_type: The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:
               
               Linear: For this type, AWS AppConfig processes the deployment by dividing the total number of targets by the value specified for Step percentage. For example, a linear deployment that uses a Step percentage of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.
               
               Exponential: For this type, AWS AppConfig processes the deployment exponentially using the following formula: G*(2^N). In this formula, G is the growth factor specified by the user and N is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:
               
               2*(2^0)
               
               2*(2^1)
               
               2*(2^2)
               
               Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.
        :param pulumi.Input[builtins.str] name: A name for the deployment strategy.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Assigns metadata to an AWS AppConfig resource. Tags help organize and categorize your AWS AppConfig resources. Each tag consists of a key and an optional value, both of which you define. You can specify a maximum of 50 tags for a resource.
        """
        pulumi.set(__self__, "deployment_duration_in_minutes", deployment_duration_in_minutes)
        pulumi.set(__self__, "growth_factor", growth_factor)
        pulumi.set(__self__, "replicate_to", replicate_to)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if final_bake_time_in_minutes is not None:
            pulumi.set(__self__, "final_bake_time_in_minutes", final_bake_time_in_minutes)
        if growth_type is not None:
            pulumi.set(__self__, "growth_type", growth_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="deploymentDurationInMinutes")
    def deployment_duration_in_minutes(self) -> pulumi.Input[builtins.float]:
        """
        Total amount of time for a deployment to last.
        """
        return pulumi.get(self, "deployment_duration_in_minutes")

    @deployment_duration_in_minutes.setter
    def deployment_duration_in_minutes(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "deployment_duration_in_minutes", value)

    @property
    @pulumi.getter(name="growthFactor")
    def growth_factor(self) -> pulumi.Input[builtins.float]:
        """
        The percentage of targets to receive a deployed configuration during each interval.
        """
        return pulumi.get(self, "growth_factor")

    @growth_factor.setter
    def growth_factor(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "growth_factor", value)

    @property
    @pulumi.getter(name="replicateTo")
    def replicate_to(self) -> pulumi.Input['DeploymentStrategyReplicateTo']:
        """
        Save the deployment strategy to a Systems Manager (SSM) document.
        """
        return pulumi.get(self, "replicate_to")

    @replicate_to.setter
    def replicate_to(self, value: pulumi.Input['DeploymentStrategyReplicateTo']):
        pulumi.set(self, "replicate_to", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the deployment strategy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="finalBakeTimeInMinutes")
    def final_bake_time_in_minutes(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Specifies the amount of time AWS AppConfig monitors for Amazon CloudWatch alarms after the configuration has been deployed to 100% of its targets, before considering the deployment to be complete. If an alarm is triggered during this time, AWS AppConfig rolls back the deployment. You must configure permissions for AWS AppConfig to roll back based on CloudWatch alarms. For more information, see Configuring permissions for rollback based on Amazon CloudWatch alarms in the AWS AppConfig User Guide.
        """
        return pulumi.get(self, "final_bake_time_in_minutes")

    @final_bake_time_in_minutes.setter
    def final_bake_time_in_minutes(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "final_bake_time_in_minutes", value)

    @property
    @pulumi.getter(name="growthType")
    def growth_type(self) -> Optional[pulumi.Input['DeploymentStrategyGrowthType']]:
        """
        The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:

        Linear: For this type, AWS AppConfig processes the deployment by dividing the total number of targets by the value specified for Step percentage. For example, a linear deployment that uses a Step percentage of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.

        Exponential: For this type, AWS AppConfig processes the deployment exponentially using the following formula: G*(2^N). In this formula, G is the growth factor specified by the user and N is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:

        2*(2^0)

        2*(2^1)

        2*(2^2)

        Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.
        """
        return pulumi.get(self, "growth_type")

    @growth_type.setter
    def growth_type(self, value: Optional[pulumi.Input['DeploymentStrategyGrowthType']]):
        pulumi.set(self, "growth_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the deployment strategy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Assigns metadata to an AWS AppConfig resource. Tags help organize and categorize your AWS AppConfig resources. Each tag consists of a key and an optional value, both of which you define. You can specify a maximum of 50 tags for a resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:appconfig:DeploymentStrategy")
class DeploymentStrategy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deployment_duration_in_minutes: Optional[pulumi.Input[builtins.float]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 final_bake_time_in_minutes: Optional[pulumi.Input[builtins.float]] = None,
                 growth_factor: Optional[pulumi.Input[builtins.float]] = None,
                 growth_type: Optional[pulumi.Input['DeploymentStrategyGrowthType']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 replicate_to: Optional[pulumi.Input['DeploymentStrategyReplicateTo']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::AppConfig::DeploymentStrategy

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        basic_deployment_strategy = aws_native.appconfig.DeploymentStrategy("basicDeploymentStrategy",
            name="MyTestDeploymentStrategy",
            description="A sample test deployment strategy.",
            deployment_duration_in_minutes=3,
            final_bake_time_in_minutes=4,
            growth_factor=10,
            growth_type=aws_native.appconfig.DeploymentStrategyGrowthType.LINEAR,
            replicate_to=aws_native.appconfig.DeploymentStrategyReplicateTo.NONE,
            tags=[{
                "key": "Env",
                "value": "test",
            }])

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.float] deployment_duration_in_minutes: Total amount of time for a deployment to last.
        :param pulumi.Input[builtins.str] description: A description of the deployment strategy.
        :param pulumi.Input[builtins.float] final_bake_time_in_minutes: Specifies the amount of time AWS AppConfig monitors for Amazon CloudWatch alarms after the configuration has been deployed to 100% of its targets, before considering the deployment to be complete. If an alarm is triggered during this time, AWS AppConfig rolls back the deployment. You must configure permissions for AWS AppConfig to roll back based on CloudWatch alarms. For more information, see Configuring permissions for rollback based on Amazon CloudWatch alarms in the AWS AppConfig User Guide.
        :param pulumi.Input[builtins.float] growth_factor: The percentage of targets to receive a deployed configuration during each interval.
        :param pulumi.Input['DeploymentStrategyGrowthType'] growth_type: The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:
               
               Linear: For this type, AWS AppConfig processes the deployment by dividing the total number of targets by the value specified for Step percentage. For example, a linear deployment that uses a Step percentage of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.
               
               Exponential: For this type, AWS AppConfig processes the deployment exponentially using the following formula: G*(2^N). In this formula, G is the growth factor specified by the user and N is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:
               
               2*(2^0)
               
               2*(2^1)
               
               2*(2^2)
               
               Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.
        :param pulumi.Input[builtins.str] name: A name for the deployment strategy.
        :param pulumi.Input['DeploymentStrategyReplicateTo'] replicate_to: Save the deployment strategy to a Systems Manager (SSM) document.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Assigns metadata to an AWS AppConfig resource. Tags help organize and categorize your AWS AppConfig resources. Each tag consists of a key and an optional value, both of which you define. You can specify a maximum of 50 tags for a resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentStrategyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::AppConfig::DeploymentStrategy

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        basic_deployment_strategy = aws_native.appconfig.DeploymentStrategy("basicDeploymentStrategy",
            name="MyTestDeploymentStrategy",
            description="A sample test deployment strategy.",
            deployment_duration_in_minutes=3,
            final_bake_time_in_minutes=4,
            growth_factor=10,
            growth_type=aws_native.appconfig.DeploymentStrategyGrowthType.LINEAR,
            replicate_to=aws_native.appconfig.DeploymentStrategyReplicateTo.NONE,
            tags=[{
                "key": "Env",
                "value": "test",
            }])

        ```

        :param str resource_name: The name of the resource.
        :param DeploymentStrategyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentStrategyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deployment_duration_in_minutes: Optional[pulumi.Input[builtins.float]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 final_bake_time_in_minutes: Optional[pulumi.Input[builtins.float]] = None,
                 growth_factor: Optional[pulumi.Input[builtins.float]] = None,
                 growth_type: Optional[pulumi.Input['DeploymentStrategyGrowthType']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 replicate_to: Optional[pulumi.Input['DeploymentStrategyReplicateTo']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentStrategyArgs.__new__(DeploymentStrategyArgs)

            if deployment_duration_in_minutes is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_duration_in_minutes'")
            __props__.__dict__["deployment_duration_in_minutes"] = deployment_duration_in_minutes
            __props__.__dict__["description"] = description
            __props__.__dict__["final_bake_time_in_minutes"] = final_bake_time_in_minutes
            if growth_factor is None and not opts.urn:
                raise TypeError("Missing required property 'growth_factor'")
            __props__.__dict__["growth_factor"] = growth_factor
            __props__.__dict__["growth_type"] = growth_type
            __props__.__dict__["name"] = name
            if replicate_to is None and not opts.urn:
                raise TypeError("Missing required property 'replicate_to'")
            __props__.__dict__["replicate_to"] = replicate_to
            __props__.__dict__["tags"] = tags
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name", "replicateTo"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DeploymentStrategy, __self__).__init__(
            'aws-native:appconfig:DeploymentStrategy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DeploymentStrategy':
        """
        Get an existing DeploymentStrategy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DeploymentStrategyArgs.__new__(DeploymentStrategyArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["deployment_duration_in_minutes"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["final_bake_time_in_minutes"] = None
        __props__.__dict__["growth_factor"] = None
        __props__.__dict__["growth_type"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["replicate_to"] = None
        __props__.__dict__["tags"] = None
        return DeploymentStrategy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The deployment strategy ID.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="deploymentDurationInMinutes")
    def deployment_duration_in_minutes(self) -> pulumi.Output[builtins.float]:
        """
        Total amount of time for a deployment to last.
        """
        return pulumi.get(self, "deployment_duration_in_minutes")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the deployment strategy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="finalBakeTimeInMinutes")
    def final_bake_time_in_minutes(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        Specifies the amount of time AWS AppConfig monitors for Amazon CloudWatch alarms after the configuration has been deployed to 100% of its targets, before considering the deployment to be complete. If an alarm is triggered during this time, AWS AppConfig rolls back the deployment. You must configure permissions for AWS AppConfig to roll back based on CloudWatch alarms. For more information, see Configuring permissions for rollback based on Amazon CloudWatch alarms in the AWS AppConfig User Guide.
        """
        return pulumi.get(self, "final_bake_time_in_minutes")

    @property
    @pulumi.getter(name="growthFactor")
    def growth_factor(self) -> pulumi.Output[builtins.float]:
        """
        The percentage of targets to receive a deployed configuration during each interval.
        """
        return pulumi.get(self, "growth_factor")

    @property
    @pulumi.getter(name="growthType")
    def growth_type(self) -> pulumi.Output[Optional['DeploymentStrategyGrowthType']]:
        """
        The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:

        Linear: For this type, AWS AppConfig processes the deployment by dividing the total number of targets by the value specified for Step percentage. For example, a linear deployment that uses a Step percentage of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.

        Exponential: For this type, AWS AppConfig processes the deployment exponentially using the following formula: G*(2^N). In this formula, G is the growth factor specified by the user and N is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:

        2*(2^0)

        2*(2^1)

        2*(2^2)

        Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.
        """
        return pulumi.get(self, "growth_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A name for the deployment strategy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="replicateTo")
    def replicate_to(self) -> pulumi.Output['DeploymentStrategyReplicateTo']:
        """
        Save the deployment strategy to a Systems Manager (SSM) document.
        """
        return pulumi.get(self, "replicate_to")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Assigns metadata to an AWS AppConfig resource. Tags help organize and categorize your AWS AppConfig resources. Each tag consists of a key and an optional value, both of which you define. You can specify a maximum of 50 tags for a resource.
        """
        return pulumi.get(self, "tags")

