# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RoutingRuleArgs', 'RoutingRule']

@pulumi.input_type
class RoutingRuleArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input['RoutingRuleActionArgs']]],
                 conditions: pulumi.Input[Sequence[pulumi.Input['RoutingRuleConditionArgs']]],
                 domain_name_arn: pulumi.Input[builtins.str],
                 priority: pulumi.Input[builtins.int]):
        """
        The set of arguments for constructing a RoutingRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['RoutingRuleActionArgs']]] actions: The resulting action based on matching a routing rules condition. Only InvokeApi is supported.
        :param pulumi.Input[Sequence[pulumi.Input['RoutingRuleConditionArgs']]] conditions: The conditions of the routing rule.
        :param pulumi.Input[builtins.str] domain_name_arn: The amazon resource name (ARN) of the domain name resource.
        :param pulumi.Input[builtins.int] priority: The order in which API Gateway evaluates a rule. Priority is evaluated from the lowest value to the highest value. Rules can't have the same priority. Priority values 1-1,000,000 are supported.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "domain_name_arn", domain_name_arn)
        pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input['RoutingRuleActionArgs']]]:
        """
        The resulting action based on matching a routing rules condition. Only InvokeApi is supported.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input['RoutingRuleActionArgs']]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Input[Sequence[pulumi.Input['RoutingRuleConditionArgs']]]:
        """
        The conditions of the routing rule.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input[Sequence[pulumi.Input['RoutingRuleConditionArgs']]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="domainNameArn")
    def domain_name_arn(self) -> pulumi.Input[builtins.str]:
        """
        The amazon resource name (ARN) of the domain name resource.
        """
        return pulumi.get(self, "domain_name_arn")

    @domain_name_arn.setter
    def domain_name_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_name_arn", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[builtins.int]:
        """
        The order in which API Gateway evaluates a rule. Priority is evaluated from the lowest value to the highest value. Rules can't have the same priority. Priority values 1-1,000,000 are supported.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "priority", value)


@pulumi.type_token("aws-native:apigatewayv2:RoutingRule")
class RoutingRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoutingRuleActionArgs', 'RoutingRuleActionArgsDict']]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoutingRuleConditionArgs', 'RoutingRuleConditionArgsDict']]]]] = None,
                 domain_name_arn: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Schema for AWS::ApiGatewayV2::RoutingRule

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RoutingRuleActionArgs', 'RoutingRuleActionArgsDict']]]] actions: The resulting action based on matching a routing rules condition. Only InvokeApi is supported.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RoutingRuleConditionArgs', 'RoutingRuleConditionArgsDict']]]] conditions: The conditions of the routing rule.
        :param pulumi.Input[builtins.str] domain_name_arn: The amazon resource name (ARN) of the domain name resource.
        :param pulumi.Input[builtins.int] priority: The order in which API Gateway evaluates a rule. Priority is evaluated from the lowest value to the highest value. Rules can't have the same priority. Priority values 1-1,000,000 are supported.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoutingRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Schema for AWS::ApiGatewayV2::RoutingRule

        :param str resource_name: The name of the resource.
        :param RoutingRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoutingRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoutingRuleActionArgs', 'RoutingRuleActionArgsDict']]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoutingRuleConditionArgs', 'RoutingRuleConditionArgsDict']]]]] = None,
                 domain_name_arn: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoutingRuleArgs.__new__(RoutingRuleArgs)

            if actions is None and not opts.urn:
                raise TypeError("Missing required property 'actions'")
            __props__.__dict__["actions"] = actions
            if conditions is None and not opts.urn:
                raise TypeError("Missing required property 'conditions'")
            __props__.__dict__["conditions"] = conditions
            if domain_name_arn is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name_arn'")
            __props__.__dict__["domain_name_arn"] = domain_name_arn
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["routing_rule_arn"] = None
            __props__.__dict__["routing_rule_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domainNameArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(RoutingRule, __self__).__init__(
            'aws-native:apigatewayv2:RoutingRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RoutingRule':
        """
        Get an existing RoutingRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RoutingRuleArgs.__new__(RoutingRuleArgs)

        __props__.__dict__["actions"] = None
        __props__.__dict__["conditions"] = None
        __props__.__dict__["domain_name_arn"] = None
        __props__.__dict__["priority"] = None
        __props__.__dict__["routing_rule_arn"] = None
        __props__.__dict__["routing_rule_id"] = None
        return RoutingRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.RoutingRuleAction']]:
        """
        The resulting action based on matching a routing rules condition. Only InvokeApi is supported.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.RoutingRuleCondition']]:
        """
        The conditions of the routing rule.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="domainNameArn")
    def domain_name_arn(self) -> pulumi.Output[builtins.str]:
        """
        The amazon resource name (ARN) of the domain name resource.
        """
        return pulumi.get(self, "domain_name_arn")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[builtins.int]:
        """
        The order in which API Gateway evaluates a rule. Priority is evaluated from the lowest value to the highest value. Rules can't have the same priority. Priority values 1-1,000,000 are supported.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="routingRuleArn")
    def routing_rule_arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of the resource.
        """
        return pulumi.get(self, "routing_rule_arn")

    @property
    @pulumi.getter(name="routingRuleId")
    def routing_rule_id(self) -> pulumi.Output[builtins.str]:
        """
        RoutingRule Id generated by service
        """
        return pulumi.get(self, "routing_rule_id")

