# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApiBodyS3Location',
    'ApiCors',
    'AuthorizerJwtConfiguration',
    'DomainNameConfiguration',
    'DomainNameMutualTlsAuthentication',
    'IntegrationResponseParameter',
    'IntegrationResponseParameterMap',
    'IntegrationTlsConfig',
    'RouteParameterConstraints',
    'RouteResponseParameterConstraints',
    'RoutingRuleAction',
    'RoutingRuleActionInvokeApi',
    'RoutingRuleCondition',
    'RoutingRuleMatchBasePaths',
    'RoutingRuleMatchHeaderValue',
    'RoutingRuleMatchHeaders',
]

@pulumi.output_type
class ApiBodyS3Location(dict):
    """
    The ``BodyS3Location`` property specifies an S3 location from which to import an OpenAPI definition. Supported only for HTTP APIs.
    """
    def __init__(__self__, *,
                 bucket: Optional[builtins.str] = None,
                 etag: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        The ``BodyS3Location`` property specifies an S3 location from which to import an OpenAPI definition. Supported only for HTTP APIs.
        :param builtins.str bucket: The S3 bucket that contains the OpenAPI definition to import. Required if you specify a ``BodyS3Location`` for an API.
        :param builtins.str etag: The Etag of the S3 object.
        :param builtins.str key: The key of the S3 object. Required if you specify a ``BodyS3Location`` for an API.
        :param builtins.str version: The version of the S3 object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        The S3 bucket that contains the OpenAPI definition to import. Required if you specify a ``BodyS3Location`` for an API.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def etag(self) -> Optional[builtins.str]:
        """
        The Etag of the S3 object.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The key of the S3 object. Required if you specify a ``BodyS3Location`` for an API.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        The version of the S3 object.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ApiCors(dict):
    """
    The ``Cors`` property specifies a CORS configuration for an API. Supported only for HTTP APIs. See [Configuring CORS](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html) for more information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowHeaders":
            suggest = "allow_headers"
        elif key == "allowMethods":
            suggest = "allow_methods"
        elif key == "allowOrigins":
            suggest = "allow_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAge":
            suggest = "max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[builtins.bool] = None,
                 allow_headers: Optional[Sequence[builtins.str]] = None,
                 allow_methods: Optional[Sequence[builtins.str]] = None,
                 allow_origins: Optional[Sequence[builtins.str]] = None,
                 expose_headers: Optional[Sequence[builtins.str]] = None,
                 max_age: Optional[builtins.int] = None):
        """
        The ``Cors`` property specifies a CORS configuration for an API. Supported only for HTTP APIs. See [Configuring CORS](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html) for more information.
        :param builtins.bool allow_credentials: Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.
        :param Sequence[builtins.str] allow_headers: Represents a collection of allowed headers. Supported only for HTTP APIs.
        :param Sequence[builtins.str] allow_methods: Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
        :param Sequence[builtins.str] allow_origins: Represents a collection of allowed origins. Supported only for HTTP APIs.
        :param Sequence[builtins.str] expose_headers: Represents a collection of exposed headers. Supported only for HTTP APIs.
        :param builtins.int max_age: The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[builtins.bool]:
        """
        Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Represents a collection of allowed headers. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[Sequence[builtins.str]]:
        """
        Represents a collection of allowed origins. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Represents a collection of exposed headers. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[builtins.int]:
        """
        The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class AuthorizerJwtConfiguration(dict):
    """
    The ``JWTConfiguration`` property specifies the configuration of a JWT authorizer. Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
    """
    def __init__(__self__, *,
                 audience: Optional[Sequence[builtins.str]] = None,
                 issuer: Optional[builtins.str] = None):
        """
        The ``JWTConfiguration`` property specifies the configuration of a JWT authorizer. Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        :param Sequence[builtins.str] audience: A list of the intended recipients of the JWT. A valid JWT must provide an ``aud`` that matches at least one entry in this list. See [RFC 7519](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc7519#section-4.1.3). Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        :param builtins.str issuer: The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: ``https://cognito-idp.{region}.amazonaws.com/{userPoolId}``. Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        """
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def audience(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of the intended recipients of the JWT. A valid JWT must provide an ``aud`` that matches at least one entry in this list. See [RFC 7519](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc7519#section-4.1.3). Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[builtins.str]:
        """
        The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: ``https://cognito-idp.{region}.amazonaws.com/{userPoolId}``. Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "issuer")


@pulumi.output_type
class DomainNameConfiguration(dict):
    """
    The ``DomainNameConfiguration`` property type specifies the configuration for an API's domain name.
      ``DomainNameConfiguration`` is a property of the [AWS::ApiGatewayV2::DomainName](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html) resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateArn":
            suggest = "certificate_arn"
        elif key == "certificateName":
            suggest = "certificate_name"
        elif key == "endpointType":
            suggest = "endpoint_type"
        elif key == "ipAddressType":
            suggest = "ip_address_type"
        elif key == "ownershipVerificationCertificateArn":
            suggest = "ownership_verification_certificate_arn"
        elif key == "securityPolicy":
            suggest = "security_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainNameConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainNameConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainNameConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_arn: Optional[builtins.str] = None,
                 certificate_name: Optional[builtins.str] = None,
                 endpoint_type: Optional[builtins.str] = None,
                 ip_address_type: Optional[builtins.str] = None,
                 ownership_verification_certificate_arn: Optional[builtins.str] = None,
                 security_policy: Optional[builtins.str] = None):
        """
        The ``DomainNameConfiguration`` property type specifies the configuration for an API's domain name.
          ``DomainNameConfiguration`` is a property of the [AWS::ApiGatewayV2::DomainName](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html) resource.
        :param builtins.str certificate_arn: An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
        :param builtins.str certificate_name: The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.
        :param builtins.str endpoint_type: The endpoint type.
        :param builtins.str ip_address_type: The IP address types that can invoke the domain name. Use `ipv4` to allow only IPv4 addresses to invoke your domain name, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke your domain name.
        :param builtins.str ownership_verification_certificate_arn: The Amazon resource name (ARN) for the public certificate issued by ACMlong. This ARN is used to validate custom domain ownership. It's required only if you configure mutual TLS and use either an ACM-imported or a private CA certificate ARN as the regionalCertificateArn.
        :param builtins.str security_policy: The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are ``TLS_1_0`` and ``TLS_1_2``.
        """
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if ownership_verification_certificate_arn is not None:
            pulumi.set(__self__, "ownership_verification_certificate_arn", ownership_verification_certificate_arn)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[builtins.str]:
        """
        An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
        """
        return pulumi.get(self, "certificate_arn")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[builtins.str]:
        """
        The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[builtins.str]:
        """
        The endpoint type.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[builtins.str]:
        """
        The IP address types that can invoke the domain name. Use `ipv4` to allow only IPv4 addresses to invoke your domain name, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke your domain name.
        """
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter(name="ownershipVerificationCertificateArn")
    def ownership_verification_certificate_arn(self) -> Optional[builtins.str]:
        """
        The Amazon resource name (ARN) for the public certificate issued by ACMlong. This ARN is used to validate custom domain ownership. It's required only if you configure mutual TLS and use either an ACM-imported or a private CA certificate ARN as the regionalCertificateArn.
        """
        return pulumi.get(self, "ownership_verification_certificate_arn")

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[builtins.str]:
        """
        The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are ``TLS_1_0`` and ``TLS_1_2``.
        """
        return pulumi.get(self, "security_policy")


@pulumi.output_type
class DomainNameMutualTlsAuthentication(dict):
    """
    If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "truststoreUri":
            suggest = "truststore_uri"
        elif key == "truststoreVersion":
            suggest = "truststore_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainNameMutualTlsAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainNameMutualTlsAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainNameMutualTlsAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 truststore_uri: Optional[builtins.str] = None,
                 truststore_version: Optional[builtins.str] = None):
        """
        If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
        :param builtins.str truststore_uri: An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, ``s3://bucket-name/key-name``. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.
        :param builtins.str truststore_version: The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
        if truststore_uri is not None:
            pulumi.set(__self__, "truststore_uri", truststore_uri)
        if truststore_version is not None:
            pulumi.set(__self__, "truststore_version", truststore_version)

    @property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> Optional[builtins.str]:
        """
        An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, ``s3://bucket-name/key-name``. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.
        """
        return pulumi.get(self, "truststore_uri")

    @property
    @pulumi.getter(name="truststoreVersion")
    def truststore_version(self) -> Optional[builtins.str]:
        """
        The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
        return pulumi.get(self, "truststore_version")


@pulumi.output_type
class IntegrationResponseParameter(dict):
    """
    response parameter
    """
    def __init__(__self__, *,
                 destination: Optional[builtins.str] = None,
                 source: Optional[builtins.str] = None):
        """
        response parameter
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def destination(self) -> Optional[builtins.str]:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        return pulumi.get(self, "source")


@pulumi.output_type
class IntegrationResponseParameterMap(dict):
    """
    map of response parameter lists
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "responseParameters":
            suggest = "response_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationResponseParameterMap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationResponseParameterMap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationResponseParameterMap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 response_parameters: Optional[Sequence['outputs.IntegrationResponseParameter']] = None):
        """
        map of response parameter lists
        """
        if response_parameters is not None:
            pulumi.set(__self__, "response_parameters", response_parameters)

    @property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> Optional[Sequence['outputs.IntegrationResponseParameter']]:
        return pulumi.get(self, "response_parameters")


@pulumi.output_type
class IntegrationTlsConfig(dict):
    """
    The TlsConfig property specifies the TLS configuration for a private integration. Supported only for HTTP APIs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverNameToVerify":
            suggest = "server_name_to_verify"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationTlsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationTlsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationTlsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_name_to_verify: Optional[builtins.str] = None):
        """
        The TlsConfig property specifies the TLS configuration for a private integration. Supported only for HTTP APIs.
        :param builtins.str server_name_to_verify: If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.
        """
        if server_name_to_verify is not None:
            pulumi.set(__self__, "server_name_to_verify", server_name_to_verify)

    @property
    @pulumi.getter(name="serverNameToVerify")
    def server_name_to_verify(self) -> Optional[builtins.str]:
        """
        If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.
        """
        return pulumi.get(self, "server_name_to_verify")


@pulumi.output_type
class RouteParameterConstraints(dict):
    def __init__(__self__, *,
                 required: builtins.bool):
        pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def required(self) -> builtins.bool:
        return pulumi.get(self, "required")


@pulumi.output_type
class RouteResponseParameterConstraints(dict):
    """
    Specifies whether the parameter is required.
    """
    def __init__(__self__, *,
                 required: builtins.bool):
        """
        Specifies whether the parameter is required.
        :param builtins.bool required: Specifies whether the parameter is required.
        """
        pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def required(self) -> builtins.bool:
        """
        Specifies whether the parameter is required.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class RoutingRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invokeApi":
            suggest = "invoke_api"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 invoke_api: 'outputs.RoutingRuleActionInvokeApi'):
        """
        :param 'RoutingRuleActionInvokeApi' invoke_api: Represents an InvokeApi action.
        """
        pulumi.set(__self__, "invoke_api", invoke_api)

    @property
    @pulumi.getter(name="invokeApi")
    def invoke_api(self) -> 'outputs.RoutingRuleActionInvokeApi':
        """
        Represents an InvokeApi action.
        """
        return pulumi.get(self, "invoke_api")


@pulumi.output_type
class RoutingRuleActionInvokeApi(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiId":
            suggest = "api_id"
        elif key == "stripBasePath":
            suggest = "strip_base_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingRuleActionInvokeApi. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingRuleActionInvokeApi.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingRuleActionInvokeApi.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_id: builtins.str,
                 stage: builtins.str,
                 strip_base_path: Optional[builtins.bool] = None):
        """
        :param builtins.str api_id: The API identifier of the target API.
        :param builtins.str stage: The name of the target stage.
        :param builtins.bool strip_base_path: The strip base path setting. When true, API Gateway strips the incoming matched base path when forwarding the request to the target API.
        """
        pulumi.set(__self__, "api_id", api_id)
        pulumi.set(__self__, "stage", stage)
        if strip_base_path is not None:
            pulumi.set(__self__, "strip_base_path", strip_base_path)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> builtins.str:
        """
        The API identifier of the target API.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter
    def stage(self) -> builtins.str:
        """
        The name of the target stage.
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter(name="stripBasePath")
    def strip_base_path(self) -> Optional[builtins.bool]:
        """
        The strip base path setting. When true, API Gateway strips the incoming matched base path when forwarding the request to the target API.
        """
        return pulumi.get(self, "strip_base_path")


@pulumi.output_type
class RoutingRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchBasePaths":
            suggest = "match_base_paths"
        elif key == "matchHeaders":
            suggest = "match_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_base_paths: Optional['outputs.RoutingRuleMatchBasePaths'] = None,
                 match_headers: Optional['outputs.RoutingRuleMatchHeaders'] = None):
        """
        :param 'RoutingRuleMatchBasePaths' match_base_paths: The base path to be matched.
        :param 'RoutingRuleMatchHeaders' match_headers: The headers to be matched.
        """
        if match_base_paths is not None:
            pulumi.set(__self__, "match_base_paths", match_base_paths)
        if match_headers is not None:
            pulumi.set(__self__, "match_headers", match_headers)

    @property
    @pulumi.getter(name="matchBasePaths")
    def match_base_paths(self) -> Optional['outputs.RoutingRuleMatchBasePaths']:
        """
        The base path to be matched.
        """
        return pulumi.get(self, "match_base_paths")

    @property
    @pulumi.getter(name="matchHeaders")
    def match_headers(self) -> Optional['outputs.RoutingRuleMatchHeaders']:
        """
        The headers to be matched.
        """
        return pulumi.get(self, "match_headers")


@pulumi.output_type
class RoutingRuleMatchBasePaths(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "anyOf":
            suggest = "any_of"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingRuleMatchBasePaths. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingRuleMatchBasePaths.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingRuleMatchBasePaths.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 any_of: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] any_of: The string of the case sensitive base path to be matched.
        """
        pulumi.set(__self__, "any_of", any_of)

    @property
    @pulumi.getter(name="anyOf")
    def any_of(self) -> Sequence[builtins.str]:
        """
        The string of the case sensitive base path to be matched.
        """
        return pulumi.get(self, "any_of")


@pulumi.output_type
class RoutingRuleMatchHeaderValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueGlob":
            suggest = "value_glob"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingRuleMatchHeaderValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingRuleMatchHeaderValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingRuleMatchHeaderValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header: builtins.str,
                 value_glob: builtins.str):
        """
        :param builtins.str header: The case insensitive header name to be matched. The header name must be less than 40 characters and the only allowed characters are `a-z` , `A-Z` , `0-9` , and the following special characters: `*?-!#$%&'.^_`|~.` .
        :param builtins.str value_glob: The case sensitive header glob value to be matched against entire header value. The header glob value must be less than 128 characters and the only allowed characters are `a-z` , `A-Z` , `0-9` , and the following special characters: `*?-!#$%&'.^_`|~` . Wildcard matching is supported for header glob values but must be for `*prefix-match` , `suffix-match*` , or `*infix*-match` .
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "value_glob", value_glob)

    @property
    @pulumi.getter
    def header(self) -> builtins.str:
        """
        The case insensitive header name to be matched. The header name must be less than 40 characters and the only allowed characters are `a-z` , `A-Z` , `0-9` , and the following special characters: `*?-!#$%&'.^_`|~.` .
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter(name="valueGlob")
    def value_glob(self) -> builtins.str:
        """
        The case sensitive header glob value to be matched against entire header value. The header glob value must be less than 128 characters and the only allowed characters are `a-z` , `A-Z` , `0-9` , and the following special characters: `*?-!#$%&'.^_`|~` . Wildcard matching is supported for header glob values but must be for `*prefix-match` , `suffix-match*` , or `*infix*-match` .
        """
        return pulumi.get(self, "value_glob")


@pulumi.output_type
class RoutingRuleMatchHeaders(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "anyOf":
            suggest = "any_of"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingRuleMatchHeaders. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingRuleMatchHeaders.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingRuleMatchHeaders.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 any_of: Sequence['outputs.RoutingRuleMatchHeaderValue']):
        """
        :param Sequence['RoutingRuleMatchHeaderValue'] any_of: The header name and header value glob to be matched. The matchHeaders condition is matched if any of the header name and header value globs are matched.
        """
        pulumi.set(__self__, "any_of", any_of)

    @property
    @pulumi.getter(name="anyOf")
    def any_of(self) -> Sequence['outputs.RoutingRuleMatchHeaderValue']:
        """
        The header name and header value glob to be matched. The matchHeaders condition is matched if any of the header name and header value globs are matched.
        """
        return pulumi.get(self, "any_of")


