# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRoutingRuleResult',
    'AwaitableGetRoutingRuleResult',
    'get_routing_rule',
    'get_routing_rule_output',
]

@pulumi.output_type
class GetRoutingRuleResult:
    def __init__(__self__, actions=None, conditions=None, priority=None, routing_rule_arn=None, routing_rule_id=None):
        if actions and not isinstance(actions, list):
            raise TypeError("Expected argument 'actions' to be a list")
        pulumi.set(__self__, "actions", actions)
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if routing_rule_arn and not isinstance(routing_rule_arn, str):
            raise TypeError("Expected argument 'routing_rule_arn' to be a str")
        pulumi.set(__self__, "routing_rule_arn", routing_rule_arn)
        if routing_rule_id and not isinstance(routing_rule_id, str):
            raise TypeError("Expected argument 'routing_rule_id' to be a str")
        pulumi.set(__self__, "routing_rule_id", routing_rule_id)

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence['outputs.RoutingRuleAction']]:
        """
        The resulting action based on matching a routing rules condition. Only InvokeApi is supported.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.RoutingRuleCondition']]:
        """
        The conditions of the routing rule.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def priority(self) -> Optional[builtins.int]:
        """
        The order in which API Gateway evaluates a rule. Priority is evaluated from the lowest value to the highest value. Rules can't have the same priority. Priority values 1-1,000,000 are supported.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="routingRuleArn")
    def routing_rule_arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN) of the resource.
        """
        return pulumi.get(self, "routing_rule_arn")

    @property
    @pulumi.getter(name="routingRuleId")
    def routing_rule_id(self) -> Optional[builtins.str]:
        """
        RoutingRule Id generated by service
        """
        return pulumi.get(self, "routing_rule_id")


class AwaitableGetRoutingRuleResult(GetRoutingRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoutingRuleResult(
            actions=self.actions,
            conditions=self.conditions,
            priority=self.priority,
            routing_rule_arn=self.routing_rule_arn,
            routing_rule_id=self.routing_rule_id)


def get_routing_rule(routing_rule_arn: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoutingRuleResult:
    """
    Schema for AWS::ApiGatewayV2::RoutingRule


    :param builtins.str routing_rule_arn: Amazon Resource Name (ARN) of the resource.
    """
    __args__ = dict()
    __args__['routingRuleArn'] = routing_rule_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:apigatewayv2:getRoutingRule', __args__, opts=opts, typ=GetRoutingRuleResult).value

    return AwaitableGetRoutingRuleResult(
        actions=pulumi.get(__ret__, 'actions'),
        conditions=pulumi.get(__ret__, 'conditions'),
        priority=pulumi.get(__ret__, 'priority'),
        routing_rule_arn=pulumi.get(__ret__, 'routing_rule_arn'),
        routing_rule_id=pulumi.get(__ret__, 'routing_rule_id'))
def get_routing_rule_output(routing_rule_arn: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRoutingRuleResult]:
    """
    Schema for AWS::ApiGatewayV2::RoutingRule


    :param builtins.str routing_rule_arn: Amazon Resource Name (ARN) of the resource.
    """
    __args__ = dict()
    __args__['routingRuleArn'] = routing_rule_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:apigatewayv2:getRoutingRule', __args__, opts=opts, typ=GetRoutingRuleResult)
    return __ret__.apply(lambda __response__: GetRoutingRuleResult(
        actions=pulumi.get(__response__, 'actions'),
        conditions=pulumi.get(__response__, 'conditions'),
        priority=pulumi.get(__response__, 'priority'),
        routing_rule_arn=pulumi.get(__response__, 'routing_rule_arn'),
        routing_rule_id=pulumi.get(__response__, 'routing_rule_id')))
