# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRouteResult',
    'AwaitableGetRouteResult',
    'get_route',
    'get_route_output',
]

@pulumi.output_type
class GetRouteResult:
    def __init__(__self__, api_key_required=None, authorization_scopes=None, authorization_type=None, model_selection_expression=None, operation_name=None, request_models=None, route_id=None, route_key=None, route_response_selection_expression=None, target=None):
        if api_key_required and not isinstance(api_key_required, bool):
            raise TypeError("Expected argument 'api_key_required' to be a bool")
        pulumi.set(__self__, "api_key_required", api_key_required)
        if authorization_scopes and not isinstance(authorization_scopes, list):
            raise TypeError("Expected argument 'authorization_scopes' to be a list")
        pulumi.set(__self__, "authorization_scopes", authorization_scopes)
        if authorization_type and not isinstance(authorization_type, str):
            raise TypeError("Expected argument 'authorization_type' to be a str")
        pulumi.set(__self__, "authorization_type", authorization_type)
        if model_selection_expression and not isinstance(model_selection_expression, str):
            raise TypeError("Expected argument 'model_selection_expression' to be a str")
        pulumi.set(__self__, "model_selection_expression", model_selection_expression)
        if operation_name and not isinstance(operation_name, str):
            raise TypeError("Expected argument 'operation_name' to be a str")
        pulumi.set(__self__, "operation_name", operation_name)
        if request_models and not isinstance(request_models, dict):
            raise TypeError("Expected argument 'request_models' to be a dict")
        pulumi.set(__self__, "request_models", request_models)
        if route_id and not isinstance(route_id, str):
            raise TypeError("Expected argument 'route_id' to be a str")
        pulumi.set(__self__, "route_id", route_id)
        if route_key and not isinstance(route_key, str):
            raise TypeError("Expected argument 'route_key' to be a str")
        pulumi.set(__self__, "route_key", route_key)
        if route_response_selection_expression and not isinstance(route_response_selection_expression, str):
            raise TypeError("Expected argument 'route_response_selection_expression' to be a str")
        pulumi.set(__self__, "route_response_selection_expression", route_response_selection_expression)
        if target and not isinstance(target, str):
            raise TypeError("Expected argument 'target' to be a str")
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="apiKeyRequired")
    def api_key_required(self) -> Optional[builtins.bool]:
        """
        Specifies whether an API key is required for the route. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "api_key_required")

    @property
    @pulumi.getter(name="authorizationScopes")
    def authorization_scopes(self) -> Optional[Sequence[builtins.str]]:
        """
        The authorization scopes supported by this route.
        """
        return pulumi.get(self, "authorization_scopes")

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[builtins.str]:
        """
        The authorization type for the route. For WebSocket APIs, valid values are ``NONE`` for open access, ``AWS_IAM`` for using AWS IAM permissions, and ``CUSTOM`` for using a Lambda authorizer. For HTTP APIs, valid values are ``NONE`` for open access, ``JWT`` for using JSON Web Tokens, ``AWS_IAM`` for using AWS IAM permissions, and ``CUSTOM`` for using a Lambda authorizer.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter(name="modelSelectionExpression")
    def model_selection_expression(self) -> Optional[builtins.str]:
        """
        The model selection expression for the route. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "model_selection_expression")

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[builtins.str]:
        """
        The operation name for the route.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="requestModels")
    def request_models(self) -> Optional[Any]:
        """
        The request models for the route. Supported only for WebSocket APIs.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::ApiGatewayV2::Route` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "request_models")

    @property
    @pulumi.getter(name="routeId")
    def route_id(self) -> Optional[builtins.str]:
        """
        The route ID.
        """
        return pulumi.get(self, "route_id")

    @property
    @pulumi.getter(name="routeKey")
    def route_key(self) -> Optional[builtins.str]:
        """
        The route key for the route. For HTTP APIs, the route key can be either ``$default``, or a combination of an HTTP method and resource path, for example, ``GET /pets``.
        """
        return pulumi.get(self, "route_key")

    @property
    @pulumi.getter(name="routeResponseSelectionExpression")
    def route_response_selection_expression(self) -> Optional[builtins.str]:
        """
        The route response selection expression for the route. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "route_response_selection_expression")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.str]:
        """
        The target for the route.
        """
        return pulumi.get(self, "target")


class AwaitableGetRouteResult(GetRouteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteResult(
            api_key_required=self.api_key_required,
            authorization_scopes=self.authorization_scopes,
            authorization_type=self.authorization_type,
            model_selection_expression=self.model_selection_expression,
            operation_name=self.operation_name,
            request_models=self.request_models,
            route_id=self.route_id,
            route_key=self.route_key,
            route_response_selection_expression=self.route_response_selection_expression,
            target=self.target)


def get_route(api_id: Optional[builtins.str] = None,
              route_id: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteResult:
    """
    The ``AWS::ApiGatewayV2::Route`` resource creates a route for an API.


    :param builtins.str api_id: The API identifier.
    :param builtins.str route_id: The route ID.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    __args__['routeId'] = route_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:apigatewayv2:getRoute', __args__, opts=opts, typ=GetRouteResult).value

    return AwaitableGetRouteResult(
        api_key_required=pulumi.get(__ret__, 'api_key_required'),
        authorization_scopes=pulumi.get(__ret__, 'authorization_scopes'),
        authorization_type=pulumi.get(__ret__, 'authorization_type'),
        model_selection_expression=pulumi.get(__ret__, 'model_selection_expression'),
        operation_name=pulumi.get(__ret__, 'operation_name'),
        request_models=pulumi.get(__ret__, 'request_models'),
        route_id=pulumi.get(__ret__, 'route_id'),
        route_key=pulumi.get(__ret__, 'route_key'),
        route_response_selection_expression=pulumi.get(__ret__, 'route_response_selection_expression'),
        target=pulumi.get(__ret__, 'target'))
def get_route_output(api_id: Optional[pulumi.Input[builtins.str]] = None,
                     route_id: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRouteResult]:
    """
    The ``AWS::ApiGatewayV2::Route`` resource creates a route for an API.


    :param builtins.str api_id: The API identifier.
    :param builtins.str route_id: The route ID.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    __args__['routeId'] = route_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:apigatewayv2:getRoute', __args__, opts=opts, typ=GetRouteResult)
    return __ret__.apply(lambda __response__: GetRouteResult(
        api_key_required=pulumi.get(__response__, 'api_key_required'),
        authorization_scopes=pulumi.get(__response__, 'authorization_scopes'),
        authorization_type=pulumi.get(__response__, 'authorization_type'),
        model_selection_expression=pulumi.get(__response__, 'model_selection_expression'),
        operation_name=pulumi.get(__response__, 'operation_name'),
        request_models=pulumi.get(__response__, 'request_models'),
        route_id=pulumi.get(__response__, 'route_id'),
        route_key=pulumi.get(__response__, 'route_key'),
        route_response_selection_expression=pulumi.get(__response__, 'route_response_selection_expression'),
        target=pulumi.get(__response__, 'target')))
