# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetModelResult',
    'AwaitableGetModelResult',
    'get_model',
    'get_model_output',
]

@pulumi.output_type
class GetModelResult:
    def __init__(__self__, content_type=None, description=None, model_id=None, name=None, schema=None):
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if model_id and not isinstance(model_id, str):
            raise TypeError("Expected argument 'model_id' to be a str")
        pulumi.set(__self__, "model_id", model_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if schema and not isinstance(schema, dict):
            raise TypeError("Expected argument 'schema' to be a dict")
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[builtins.str]:
        """
        The content-type for the model, for example, "application/json".
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[builtins.str]:
        """
        The model ID.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the model.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> Optional[Any]:
        """
        The schema for the model. For application/json models, this should be JSON schema draft 4 model.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::ApiGatewayV2::Model` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "schema")


class AwaitableGetModelResult(GetModelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetModelResult(
            content_type=self.content_type,
            description=self.description,
            model_id=self.model_id,
            name=self.name,
            schema=self.schema)


def get_model(api_id: Optional[builtins.str] = None,
              model_id: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetModelResult:
    """
    The ``AWS::ApiGatewayV2::Model`` resource updates data model for a WebSocket API. For more information, see [Model Selection Expressions](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) in the *API Gateway Developer Guide*.


    :param builtins.str api_id: The API identifier.
    :param builtins.str model_id: The model ID.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    __args__['modelId'] = model_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:apigatewayv2:getModel', __args__, opts=opts, typ=GetModelResult).value

    return AwaitableGetModelResult(
        content_type=pulumi.get(__ret__, 'content_type'),
        description=pulumi.get(__ret__, 'description'),
        model_id=pulumi.get(__ret__, 'model_id'),
        name=pulumi.get(__ret__, 'name'),
        schema=pulumi.get(__ret__, 'schema'))
def get_model_output(api_id: Optional[pulumi.Input[builtins.str]] = None,
                     model_id: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetModelResult]:
    """
    The ``AWS::ApiGatewayV2::Model`` resource updates data model for a WebSocket API. For more information, see [Model Selection Expressions](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) in the *API Gateway Developer Guide*.


    :param builtins.str api_id: The API identifier.
    :param builtins.str model_id: The model ID.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    __args__['modelId'] = model_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:apigatewayv2:getModel', __args__, opts=opts, typ=GetModelResult)
    return __ret__.apply(lambda __response__: GetModelResult(
        content_type=pulumi.get(__response__, 'content_type'),
        description=pulumi.get(__response__, 'description'),
        model_id=pulumi.get(__response__, 'model_id'),
        name=pulumi.get(__response__, 'name'),
        schema=pulumi.get(__response__, 'schema')))
