# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDeploymentResult',
    'AwaitableGetDeploymentResult',
    'get_deployment',
    'get_deployment_output',
]

@pulumi.output_type
class GetDeploymentResult:
    def __init__(__self__, deployment_id=None, description=None):
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[builtins.str]:
        """
        The deployment ID.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description for the deployment resource.
        """
        return pulumi.get(self, "description")


class AwaitableGetDeploymentResult(GetDeploymentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeploymentResult(
            deployment_id=self.deployment_id,
            description=self.description)


def get_deployment(api_id: Optional[builtins.str] = None,
                   deployment_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeploymentResult:
    """
    The ``AWS::ApiGatewayV2::Deployment`` resource creates a deployment for an API.


    :param builtins.str api_id: The API identifier.
    :param builtins.str deployment_id: The deployment ID.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    __args__['deploymentId'] = deployment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:apigatewayv2:getDeployment', __args__, opts=opts, typ=GetDeploymentResult).value

    return AwaitableGetDeploymentResult(
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        description=pulumi.get(__ret__, 'description'))
def get_deployment_output(api_id: Optional[pulumi.Input[builtins.str]] = None,
                          deployment_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDeploymentResult]:
    """
    The ``AWS::ApiGatewayV2::Deployment`` resource creates a deployment for an API.


    :param builtins.str api_id: The API identifier.
    :param builtins.str deployment_id: The deployment ID.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    __args__['deploymentId'] = deployment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:apigatewayv2:getDeployment', __args__, opts=opts, typ=GetDeploymentResult)
    return __ret__.apply(lambda __response__: GetDeploymentResult(
        deployment_id=pulumi.get(__response__, 'deployment_id'),
        description=pulumi.get(__response__, 'description')))
