# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAuthorizerResult',
    'AwaitableGetAuthorizerResult',
    'get_authorizer',
    'get_authorizer_output',
]

@pulumi.output_type
class GetAuthorizerResult:
    def __init__(__self__, authorizer_id=None, authorizer_type=None, identity_source=None, identity_validation_expression=None, jwt_configuration=None, name=None):
        if authorizer_id and not isinstance(authorizer_id, str):
            raise TypeError("Expected argument 'authorizer_id' to be a str")
        pulumi.set(__self__, "authorizer_id", authorizer_id)
        if authorizer_type and not isinstance(authorizer_type, str):
            raise TypeError("Expected argument 'authorizer_type' to be a str")
        pulumi.set(__self__, "authorizer_type", authorizer_type)
        if identity_source and not isinstance(identity_source, list):
            raise TypeError("Expected argument 'identity_source' to be a list")
        pulumi.set(__self__, "identity_source", identity_source)
        if identity_validation_expression and not isinstance(identity_validation_expression, str):
            raise TypeError("Expected argument 'identity_validation_expression' to be a str")
        pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)
        if jwt_configuration and not isinstance(jwt_configuration, dict):
            raise TypeError("Expected argument 'jwt_configuration' to be a dict")
        pulumi.set(__self__, "jwt_configuration", jwt_configuration)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[builtins.str]:
        """
        The authorizer ID.
        """
        return pulumi.get(self, "authorizer_id")

    @property
    @pulumi.getter(name="authorizerType")
    def authorizer_type(self) -> Optional[builtins.str]:
        """
        The authorizer type. Specify ``REQUEST`` for a Lambda function using incoming request parameters. Specify ``JWT`` to use JSON Web Tokens (supported only for HTTP APIs).
        """
        return pulumi.get(self, "authorizer_type")

    @property
    @pulumi.getter(name="identitySource")
    def identity_source(self) -> Optional[Sequence[builtins.str]]:
        """
        The identity source for which authorization is requested.
         For a ``REQUEST`` authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with ``$``, for example, ``$request.header.Auth``, ``$request.querystring.Name``. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see [Working with Lambda authorizers for HTTP APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html).
         For ``JWT``, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example ``$request.header.Authorization``.
        """
        return pulumi.get(self, "identity_source")

    @property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[builtins.str]:
        """
        This parameter is not used.
        """
        return pulumi.get(self, "identity_validation_expression")

    @property
    @pulumi.getter(name="jwtConfiguration")
    def jwt_configuration(self) -> Optional['outputs.AuthorizerJwtConfiguration']:
        """
        The ``JWTConfiguration`` property specifies the configuration of a JWT authorizer. Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "jwt_configuration")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the authorizer.
        """
        return pulumi.get(self, "name")


class AwaitableGetAuthorizerResult(GetAuthorizerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthorizerResult(
            authorizer_id=self.authorizer_id,
            authorizer_type=self.authorizer_type,
            identity_source=self.identity_source,
            identity_validation_expression=self.identity_validation_expression,
            jwt_configuration=self.jwt_configuration,
            name=self.name)


def get_authorizer(api_id: Optional[builtins.str] = None,
                   authorizer_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthorizerResult:
    """
    The ``AWS::ApiGatewayV2::Authorizer`` resource creates an authorizer for a WebSocket API or an HTTP API. To learn more, see [Controlling and managing access to a WebSocket API in API Gateway](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-control-access.html) and [Controlling and managing access to an HTTP API in API Gateway](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-access-control.html) in the *API Gateway Developer Guide*.


    :param builtins.str api_id: The API identifier.
    :param builtins.str authorizer_id: The authorizer ID.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    __args__['authorizerId'] = authorizer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:apigatewayv2:getAuthorizer', __args__, opts=opts, typ=GetAuthorizerResult).value

    return AwaitableGetAuthorizerResult(
        authorizer_id=pulumi.get(__ret__, 'authorizer_id'),
        authorizer_type=pulumi.get(__ret__, 'authorizer_type'),
        identity_source=pulumi.get(__ret__, 'identity_source'),
        identity_validation_expression=pulumi.get(__ret__, 'identity_validation_expression'),
        jwt_configuration=pulumi.get(__ret__, 'jwt_configuration'),
        name=pulumi.get(__ret__, 'name'))
def get_authorizer_output(api_id: Optional[pulumi.Input[builtins.str]] = None,
                          authorizer_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuthorizerResult]:
    """
    The ``AWS::ApiGatewayV2::Authorizer`` resource creates an authorizer for a WebSocket API or an HTTP API. To learn more, see [Controlling and managing access to a WebSocket API in API Gateway](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-control-access.html) and [Controlling and managing access to an HTTP API in API Gateway](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-access-control.html) in the *API Gateway Developer Guide*.


    :param builtins.str api_id: The API identifier.
    :param builtins.str authorizer_id: The authorizer ID.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    __args__['authorizerId'] = authorizer_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:apigatewayv2:getAuthorizer', __args__, opts=opts, typ=GetAuthorizerResult)
    return __ret__.apply(lambda __response__: GetAuthorizerResult(
        authorizer_id=pulumi.get(__response__, 'authorizer_id'),
        authorizer_type=pulumi.get(__response__, 'authorizer_type'),
        identity_source=pulumi.get(__response__, 'identity_source'),
        identity_validation_expression=pulumi.get(__response__, 'identity_validation_expression'),
        jwt_configuration=pulumi.get(__response__, 'jwt_configuration'),
        name=pulumi.get(__response__, 'name')))
