# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ApiBodyS3LocationArgs',
    'ApiBodyS3LocationArgsDict',
    'ApiCorsArgs',
    'ApiCorsArgsDict',
    'AuthorizerJwtConfigurationArgs',
    'AuthorizerJwtConfigurationArgsDict',
    'DomainNameConfigurationArgs',
    'DomainNameConfigurationArgsDict',
    'DomainNameMutualTlsAuthenticationArgs',
    'DomainNameMutualTlsAuthenticationArgsDict',
    'IntegrationResponseParameterMapArgs',
    'IntegrationResponseParameterMapArgsDict',
    'IntegrationResponseParameterArgs',
    'IntegrationResponseParameterArgsDict',
    'IntegrationTlsConfigArgs',
    'IntegrationTlsConfigArgsDict',
    'RouteParameterConstraintsArgs',
    'RouteParameterConstraintsArgsDict',
    'RouteResponseParameterConstraintsArgs',
    'RouteResponseParameterConstraintsArgsDict',
    'RoutingRuleActionInvokeApiArgs',
    'RoutingRuleActionInvokeApiArgsDict',
    'RoutingRuleActionArgs',
    'RoutingRuleActionArgsDict',
    'RoutingRuleConditionArgs',
    'RoutingRuleConditionArgsDict',
    'RoutingRuleMatchBasePathsArgs',
    'RoutingRuleMatchBasePathsArgsDict',
    'RoutingRuleMatchHeaderValueArgs',
    'RoutingRuleMatchHeaderValueArgsDict',
    'RoutingRuleMatchHeadersArgs',
    'RoutingRuleMatchHeadersArgsDict',
]

MYPY = False

if not MYPY:
    class ApiBodyS3LocationArgsDict(TypedDict):
        """
        The ``BodyS3Location`` property specifies an S3 location from which to import an OpenAPI definition. Supported only for HTTP APIs.
        """
        bucket: NotRequired[pulumi.Input[builtins.str]]
        """
        The S3 bucket that contains the OpenAPI definition to import. Required if you specify a ``BodyS3Location`` for an API.
        """
        etag: NotRequired[pulumi.Input[builtins.str]]
        """
        The Etag of the S3 object.
        """
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        The key of the S3 object. Required if you specify a ``BodyS3Location`` for an API.
        """
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        The version of the S3 object.
        """
elif False:
    ApiBodyS3LocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApiBodyS3LocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ``BodyS3Location`` property specifies an S3 location from which to import an OpenAPI definition. Supported only for HTTP APIs.
        :param pulumi.Input[builtins.str] bucket: The S3 bucket that contains the OpenAPI definition to import. Required if you specify a ``BodyS3Location`` for an API.
        :param pulumi.Input[builtins.str] etag: The Etag of the S3 object.
        :param pulumi.Input[builtins.str] key: The key of the S3 object. Required if you specify a ``BodyS3Location`` for an API.
        :param pulumi.Input[builtins.str] version: The version of the S3 object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The S3 bucket that contains the OpenAPI definition to import. Required if you specify a ``BodyS3Location`` for an API.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Etag of the S3 object.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key of the S3 object. Required if you specify a ``BodyS3Location`` for an API.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the S3 object.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class ApiCorsArgsDict(TypedDict):
        """
        The ``Cors`` property specifies a CORS configuration for an API. Supported only for HTTP APIs. See [Configuring CORS](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html) for more information.
        """
        allow_credentials: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.
        """
        allow_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Represents a collection of allowed headers. Supported only for HTTP APIs.
        """
        allow_methods: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
        """
        allow_origins: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Represents a collection of allowed origins. Supported only for HTTP APIs.
        """
        expose_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Represents a collection of exposed headers. Supported only for HTTP APIs.
        """
        max_age: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.
        """
elif False:
    ApiCorsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApiCorsArgs:
    def __init__(__self__, *,
                 allow_credentials: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_headers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allow_methods: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allow_origins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 expose_headers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 max_age: Optional[pulumi.Input[builtins.int]] = None):
        """
        The ``Cors`` property specifies a CORS configuration for an API. Supported only for HTTP APIs. See [Configuring CORS](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html) for more information.
        :param pulumi.Input[builtins.bool] allow_credentials: Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allow_headers: Represents a collection of allowed headers. Supported only for HTTP APIs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allow_methods: Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allow_origins: Represents a collection of allowed origins. Supported only for HTTP APIs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] expose_headers: Represents a collection of exposed headers. Supported only for HTTP APIs.
        :param pulumi.Input[builtins.int] max_age: The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "allow_credentials")

    @allow_credentials.setter
    def allow_credentials(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_credentials", value)

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Represents a collection of allowed headers. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "allow_headers")

    @allow_headers.setter
    def allow_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allow_headers", value)

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "allow_methods")

    @allow_methods.setter
    def allow_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allow_methods", value)

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Represents a collection of allowed origins. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "allow_origins")

    @allow_origins.setter
    def allow_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allow_origins", value)

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Represents a collection of exposed headers. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "expose_headers")

    @expose_headers.setter
    def expose_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "expose_headers", value)

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "max_age")

    @max_age.setter
    def max_age(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_age", value)


if not MYPY:
    class AuthorizerJwtConfigurationArgsDict(TypedDict):
        """
        The ``JWTConfiguration`` property specifies the configuration of a JWT authorizer. Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        """
        audience: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of the intended recipients of the JWT. A valid JWT must provide an ``aud`` that matches at least one entry in this list. See [RFC 7519](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc7519#section-4.1.3). Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        """
        issuer: NotRequired[pulumi.Input[builtins.str]]
        """
        The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: ``https://cognito-idp.{region}.amazonaws.com/{userPoolId}``. Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        """
elif False:
    AuthorizerJwtConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthorizerJwtConfigurationArgs:
    def __init__(__self__, *,
                 audience: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 issuer: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ``JWTConfiguration`` property specifies the configuration of a JWT authorizer. Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] audience: A list of the intended recipients of the JWT. A valid JWT must provide an ``aud`` that matches at least one entry in this list. See [RFC 7519](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc7519#section-4.1.3). Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        :param pulumi.Input[builtins.str] issuer: The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: ``https://cognito-idp.{region}.amazonaws.com/{userPoolId}``. Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        """
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the intended recipients of the JWT. A valid JWT must provide an ``aud`` that matches at least one entry in this list. See [RFC 7519](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc7519#section-4.1.3). Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: ``https://cognito-idp.{region}.amazonaws.com/{userPoolId}``. Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issuer", value)


if not MYPY:
    class DomainNameConfigurationArgsDict(TypedDict):
        """
        The ``DomainNameConfiguration`` property type specifies the configuration for an API's domain name.
          ``DomainNameConfiguration`` is a property of the [AWS::ApiGatewayV2::DomainName](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html) resource.
        """
        certificate_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
        """
        certificate_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.
        """
        endpoint_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The endpoint type.
        """
        ip_address_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP address types that can invoke the domain name. Use `ipv4` to allow only IPv4 addresses to invoke your domain name, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke your domain name.
        """
        ownership_verification_certificate_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon resource name (ARN) for the public certificate issued by ACMlong. This ARN is used to validate custom domain ownership. It's required only if you configure mutual TLS and use either an ACM-imported or a private CA certificate ARN as the regionalCertificateArn.
        """
        security_policy: NotRequired[pulumi.Input[builtins.str]]
        """
        The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are ``TLS_1_0`` and ``TLS_1_2``.
        """
elif False:
    DomainNameConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainNameConfigurationArgs:
    def __init__(__self__, *,
                 certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 ownership_verification_certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
                 security_policy: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ``DomainNameConfiguration`` property type specifies the configuration for an API's domain name.
          ``DomainNameConfiguration`` is a property of the [AWS::ApiGatewayV2::DomainName](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html) resource.
        :param pulumi.Input[builtins.str] certificate_arn: An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
        :param pulumi.Input[builtins.str] certificate_name: The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.
        :param pulumi.Input[builtins.str] endpoint_type: The endpoint type.
        :param pulumi.Input[builtins.str] ip_address_type: The IP address types that can invoke the domain name. Use `ipv4` to allow only IPv4 addresses to invoke your domain name, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke your domain name.
        :param pulumi.Input[builtins.str] ownership_verification_certificate_arn: The Amazon resource name (ARN) for the public certificate issued by ACMlong. This ARN is used to validate custom domain ownership. It's required only if you configure mutual TLS and use either an ACM-imported or a private CA certificate ARN as the regionalCertificateArn.
        :param pulumi.Input[builtins.str] security_policy: The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are ``TLS_1_0`` and ``TLS_1_2``.
        """
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if ownership_verification_certificate_arn is not None:
            pulumi.set(__self__, "ownership_verification_certificate_arn", ownership_verification_certificate_arn)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_arn", value)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint type.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address types that can invoke the domain name. Use `ipv4` to allow only IPv4 addresses to invoke your domain name, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke your domain name.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter(name="ownershipVerificationCertificateArn")
    def ownership_verification_certificate_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon resource name (ARN) for the public certificate issued by ACMlong. This ARN is used to validate custom domain ownership. It's required only if you configure mutual TLS and use either an ACM-imported or a private CA certificate ARN as the regionalCertificateArn.
        """
        return pulumi.get(self, "ownership_verification_certificate_arn")

    @ownership_verification_certificate_arn.setter
    def ownership_verification_certificate_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ownership_verification_certificate_arn", value)

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are ``TLS_1_0`` and ``TLS_1_2``.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_policy", value)


if not MYPY:
    class DomainNameMutualTlsAuthenticationArgsDict(TypedDict):
        """
        If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
        """
        truststore_uri: NotRequired[pulumi.Input[builtins.str]]
        """
        An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, ``s3://bucket-name/key-name``. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.
        """
        truststore_version: NotRequired[pulumi.Input[builtins.str]]
        """
        The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
elif False:
    DomainNameMutualTlsAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainNameMutualTlsAuthenticationArgs:
    def __init__(__self__, *,
                 truststore_uri: Optional[pulumi.Input[builtins.str]] = None,
                 truststore_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
        :param pulumi.Input[builtins.str] truststore_uri: An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, ``s3://bucket-name/key-name``. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.
        :param pulumi.Input[builtins.str] truststore_version: The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
        if truststore_uri is not None:
            pulumi.set(__self__, "truststore_uri", truststore_uri)
        if truststore_version is not None:
            pulumi.set(__self__, "truststore_version", truststore_version)

    @property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, ``s3://bucket-name/key-name``. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.
        """
        return pulumi.get(self, "truststore_uri")

    @truststore_uri.setter
    def truststore_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "truststore_uri", value)

    @property
    @pulumi.getter(name="truststoreVersion")
    def truststore_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
        return pulumi.get(self, "truststore_version")

    @truststore_version.setter
    def truststore_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "truststore_version", value)


if not MYPY:
    class IntegrationResponseParameterMapArgsDict(TypedDict):
        """
        map of response parameter lists
        """
        response_parameters: NotRequired[pulumi.Input[Sequence[pulumi.Input['IntegrationResponseParameterArgsDict']]]]
elif False:
    IntegrationResponseParameterMapArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IntegrationResponseParameterMapArgs:
    def __init__(__self__, *,
                 response_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResponseParameterArgs']]]] = None):
        """
        map of response parameter lists
        """
        if response_parameters is not None:
            pulumi.set(__self__, "response_parameters", response_parameters)

    @property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResponseParameterArgs']]]]:
        return pulumi.get(self, "response_parameters")

    @response_parameters.setter
    def response_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResponseParameterArgs']]]]):
        pulumi.set(self, "response_parameters", value)


if not MYPY:
    class IntegrationResponseParameterArgsDict(TypedDict):
        """
        response parameter
        """
        destination: NotRequired[pulumi.Input[builtins.str]]
        source: NotRequired[pulumi.Input[builtins.str]]
elif False:
    IntegrationResponseParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IntegrationResponseParameterArgs:
    def __init__(__self__, *,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None):
        """
        response parameter
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)


if not MYPY:
    class IntegrationTlsConfigArgsDict(TypedDict):
        """
        The TlsConfig property specifies the TLS configuration for a private integration. Supported only for HTTP APIs.
        """
        server_name_to_verify: NotRequired[pulumi.Input[builtins.str]]
        """
        If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.
        """
elif False:
    IntegrationTlsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IntegrationTlsConfigArgs:
    def __init__(__self__, *,
                 server_name_to_verify: Optional[pulumi.Input[builtins.str]] = None):
        """
        The TlsConfig property specifies the TLS configuration for a private integration. Supported only for HTTP APIs.
        :param pulumi.Input[builtins.str] server_name_to_verify: If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.
        """
        if server_name_to_verify is not None:
            pulumi.set(__self__, "server_name_to_verify", server_name_to_verify)

    @property
    @pulumi.getter(name="serverNameToVerify")
    def server_name_to_verify(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.
        """
        return pulumi.get(self, "server_name_to_verify")

    @server_name_to_verify.setter
    def server_name_to_verify(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_name_to_verify", value)


if not MYPY:
    class RouteParameterConstraintsArgsDict(TypedDict):
        required: pulumi.Input[builtins.bool]
elif False:
    RouteParameterConstraintsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RouteParameterConstraintsArgs:
    def __init__(__self__, *,
                 required: pulumi.Input[builtins.bool]):
        pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def required(self) -> pulumi.Input[builtins.bool]:
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "required", value)


if not MYPY:
    class RouteResponseParameterConstraintsArgsDict(TypedDict):
        """
        Specifies whether the parameter is required.
        """
        required: pulumi.Input[builtins.bool]
        """
        Specifies whether the parameter is required.
        """
elif False:
    RouteResponseParameterConstraintsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RouteResponseParameterConstraintsArgs:
    def __init__(__self__, *,
                 required: pulumi.Input[builtins.bool]):
        """
        Specifies whether the parameter is required.
        :param pulumi.Input[builtins.bool] required: Specifies whether the parameter is required.
        """
        pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def required(self) -> pulumi.Input[builtins.bool]:
        """
        Specifies whether the parameter is required.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "required", value)


if not MYPY:
    class RoutingRuleActionInvokeApiArgsDict(TypedDict):
        api_id: pulumi.Input[builtins.str]
        """
        The API identifier of the target API.
        """
        stage: pulumi.Input[builtins.str]
        """
        The name of the target stage.
        """
        strip_base_path: NotRequired[pulumi.Input[builtins.bool]]
        """
        The strip base path setting. When true, API Gateway strips the incoming matched base path when forwarding the request to the target API.
        """
elif False:
    RoutingRuleActionInvokeApiArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RoutingRuleActionInvokeApiArgs:
    def __init__(__self__, *,
                 api_id: pulumi.Input[builtins.str],
                 stage: pulumi.Input[builtins.str],
                 strip_base_path: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] api_id: The API identifier of the target API.
        :param pulumi.Input[builtins.str] stage: The name of the target stage.
        :param pulumi.Input[builtins.bool] strip_base_path: The strip base path setting. When true, API Gateway strips the incoming matched base path when forwarding the request to the target API.
        """
        pulumi.set(__self__, "api_id", api_id)
        pulumi.set(__self__, "stage", stage)
        if strip_base_path is not None:
            pulumi.set(__self__, "strip_base_path", strip_base_path)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Input[builtins.str]:
        """
        The API identifier of the target API.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter
    def stage(self) -> pulumi.Input[builtins.str]:
        """
        The name of the target stage.
        """
        return pulumi.get(self, "stage")

    @stage.setter
    def stage(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stage", value)

    @property
    @pulumi.getter(name="stripBasePath")
    def strip_base_path(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The strip base path setting. When true, API Gateway strips the incoming matched base path when forwarding the request to the target API.
        """
        return pulumi.get(self, "strip_base_path")

    @strip_base_path.setter
    def strip_base_path(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "strip_base_path", value)


if not MYPY:
    class RoutingRuleActionArgsDict(TypedDict):
        invoke_api: pulumi.Input['RoutingRuleActionInvokeApiArgsDict']
        """
        Represents an InvokeApi action.
        """
elif False:
    RoutingRuleActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RoutingRuleActionArgs:
    def __init__(__self__, *,
                 invoke_api: pulumi.Input['RoutingRuleActionInvokeApiArgs']):
        """
        :param pulumi.Input['RoutingRuleActionInvokeApiArgs'] invoke_api: Represents an InvokeApi action.
        """
        pulumi.set(__self__, "invoke_api", invoke_api)

    @property
    @pulumi.getter(name="invokeApi")
    def invoke_api(self) -> pulumi.Input['RoutingRuleActionInvokeApiArgs']:
        """
        Represents an InvokeApi action.
        """
        return pulumi.get(self, "invoke_api")

    @invoke_api.setter
    def invoke_api(self, value: pulumi.Input['RoutingRuleActionInvokeApiArgs']):
        pulumi.set(self, "invoke_api", value)


if not MYPY:
    class RoutingRuleConditionArgsDict(TypedDict):
        match_base_paths: NotRequired[pulumi.Input['RoutingRuleMatchBasePathsArgsDict']]
        """
        The base path to be matched.
        """
        match_headers: NotRequired[pulumi.Input['RoutingRuleMatchHeadersArgsDict']]
        """
        The headers to be matched.
        """
elif False:
    RoutingRuleConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RoutingRuleConditionArgs:
    def __init__(__self__, *,
                 match_base_paths: Optional[pulumi.Input['RoutingRuleMatchBasePathsArgs']] = None,
                 match_headers: Optional[pulumi.Input['RoutingRuleMatchHeadersArgs']] = None):
        """
        :param pulumi.Input['RoutingRuleMatchBasePathsArgs'] match_base_paths: The base path to be matched.
        :param pulumi.Input['RoutingRuleMatchHeadersArgs'] match_headers: The headers to be matched.
        """
        if match_base_paths is not None:
            pulumi.set(__self__, "match_base_paths", match_base_paths)
        if match_headers is not None:
            pulumi.set(__self__, "match_headers", match_headers)

    @property
    @pulumi.getter(name="matchBasePaths")
    def match_base_paths(self) -> Optional[pulumi.Input['RoutingRuleMatchBasePathsArgs']]:
        """
        The base path to be matched.
        """
        return pulumi.get(self, "match_base_paths")

    @match_base_paths.setter
    def match_base_paths(self, value: Optional[pulumi.Input['RoutingRuleMatchBasePathsArgs']]):
        pulumi.set(self, "match_base_paths", value)

    @property
    @pulumi.getter(name="matchHeaders")
    def match_headers(self) -> Optional[pulumi.Input['RoutingRuleMatchHeadersArgs']]:
        """
        The headers to be matched.
        """
        return pulumi.get(self, "match_headers")

    @match_headers.setter
    def match_headers(self, value: Optional[pulumi.Input['RoutingRuleMatchHeadersArgs']]):
        pulumi.set(self, "match_headers", value)


if not MYPY:
    class RoutingRuleMatchBasePathsArgsDict(TypedDict):
        any_of: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The string of the case sensitive base path to be matched.
        """
elif False:
    RoutingRuleMatchBasePathsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RoutingRuleMatchBasePathsArgs:
    def __init__(__self__, *,
                 any_of: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] any_of: The string of the case sensitive base path to be matched.
        """
        pulumi.set(__self__, "any_of", any_of)

    @property
    @pulumi.getter(name="anyOf")
    def any_of(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The string of the case sensitive base path to be matched.
        """
        return pulumi.get(self, "any_of")

    @any_of.setter
    def any_of(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "any_of", value)


if not MYPY:
    class RoutingRuleMatchHeaderValueArgsDict(TypedDict):
        header: pulumi.Input[builtins.str]
        """
        The case insensitive header name to be matched. The header name must be less than 40 characters and the only allowed characters are `a-z` , `A-Z` , `0-9` , and the following special characters: `*?-!#$%&'.^_`|~.` .
        """
        value_glob: pulumi.Input[builtins.str]
        """
        The case sensitive header glob value to be matched against entire header value. The header glob value must be less than 128 characters and the only allowed characters are `a-z` , `A-Z` , `0-9` , and the following special characters: `*?-!#$%&'.^_`|~` . Wildcard matching is supported for header glob values but must be for `*prefix-match` , `suffix-match*` , or `*infix*-match` .
        """
elif False:
    RoutingRuleMatchHeaderValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RoutingRuleMatchHeaderValueArgs:
    def __init__(__self__, *,
                 header: pulumi.Input[builtins.str],
                 value_glob: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] header: The case insensitive header name to be matched. The header name must be less than 40 characters and the only allowed characters are `a-z` , `A-Z` , `0-9` , and the following special characters: `*?-!#$%&'.^_`|~.` .
        :param pulumi.Input[builtins.str] value_glob: The case sensitive header glob value to be matched against entire header value. The header glob value must be less than 128 characters and the only allowed characters are `a-z` , `A-Z` , `0-9` , and the following special characters: `*?-!#$%&'.^_`|~` . Wildcard matching is supported for header glob values but must be for `*prefix-match` , `suffix-match*` , or `*infix*-match` .
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "value_glob", value_glob)

    @property
    @pulumi.getter
    def header(self) -> pulumi.Input[builtins.str]:
        """
        The case insensitive header name to be matched. The header name must be less than 40 characters and the only allowed characters are `a-z` , `A-Z` , `0-9` , and the following special characters: `*?-!#$%&'.^_`|~.` .
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter(name="valueGlob")
    def value_glob(self) -> pulumi.Input[builtins.str]:
        """
        The case sensitive header glob value to be matched against entire header value. The header glob value must be less than 128 characters and the only allowed characters are `a-z` , `A-Z` , `0-9` , and the following special characters: `*?-!#$%&'.^_`|~` . Wildcard matching is supported for header glob values but must be for `*prefix-match` , `suffix-match*` , or `*infix*-match` .
        """
        return pulumi.get(self, "value_glob")

    @value_glob.setter
    def value_glob(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value_glob", value)


if not MYPY:
    class RoutingRuleMatchHeadersArgsDict(TypedDict):
        any_of: pulumi.Input[Sequence[pulumi.Input['RoutingRuleMatchHeaderValueArgsDict']]]
        """
        The header name and header value glob to be matched. The matchHeaders condition is matched if any of the header name and header value globs are matched.
        """
elif False:
    RoutingRuleMatchHeadersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RoutingRuleMatchHeadersArgs:
    def __init__(__self__, *,
                 any_of: pulumi.Input[Sequence[pulumi.Input['RoutingRuleMatchHeaderValueArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RoutingRuleMatchHeaderValueArgs']]] any_of: The header name and header value glob to be matched. The matchHeaders condition is matched if any of the header name and header value globs are matched.
        """
        pulumi.set(__self__, "any_of", any_of)

    @property
    @pulumi.getter(name="anyOf")
    def any_of(self) -> pulumi.Input[Sequence[pulumi.Input['RoutingRuleMatchHeaderValueArgs']]]:
        """
        The header name and header value glob to be matched. The matchHeaders condition is matched if any of the header name and header value globs are matched.
        """
        return pulumi.get(self, "any_of")

    @any_of.setter
    def any_of(self, value: pulumi.Input[Sequence[pulumi.Input['RoutingRuleMatchHeaderValueArgs']]]):
        pulumi.set(self, "any_of", value)


