# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetResourceResult',
    'AwaitableGetResourceResult',
    'get_resource',
    'get_resource_output',
]

@pulumi.output_type
class GetResourceResult:
    def __init__(__self__, resource_id=None):
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        """
        The ID for the resource. For example: `abc123` .
        """
        return pulumi.get(self, "resource_id")


class AwaitableGetResourceResult(GetResourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceResult(
            resource_id=self.resource_id)


def get_resource(resource_id: Optional[builtins.str] = None,
                 rest_api_id: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceResult:
    """
    The ``AWS::ApiGateway::Resource`` resource creates a resource in an API.


    :param builtins.str resource_id: The ID for the resource. For example: `abc123` .
    :param builtins.str rest_api_id: The string identifier of the associated RestApi.
    """
    __args__ = dict()
    __args__['resourceId'] = resource_id
    __args__['restApiId'] = rest_api_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:apigateway:getResource', __args__, opts=opts, typ=GetResourceResult).value

    return AwaitableGetResourceResult(
        resource_id=pulumi.get(__ret__, 'resource_id'))
def get_resource_output(resource_id: Optional[pulumi.Input[builtins.str]] = None,
                        rest_api_id: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceResult]:
    """
    The ``AWS::ApiGateway::Resource`` resource creates a resource in an API.


    :param builtins.str resource_id: The ID for the resource. For example: `abc123` .
    :param builtins.str rest_api_id: The string identifier of the associated RestApi.
    """
    __args__ = dict()
    __args__['resourceId'] = resource_id
    __args__['restApiId'] = rest_api_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:apigateway:getResource', __args__, opts=opts, typ=GetResourceResult)
    return __ret__.apply(lambda __response__: GetResourceResult(
        resource_id=pulumi.get(__response__, 'resource_id')))
