# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetMethodResult',
    'AwaitableGetMethodResult',
    'get_method',
    'get_method_output',
]

@pulumi.output_type
class GetMethodResult:
    def __init__(__self__, api_key_required=None, authorization_scopes=None, authorization_type=None, authorizer_id=None, integration=None, method_responses=None, operation_name=None, request_models=None, request_parameters=None, request_validator_id=None):
        if api_key_required and not isinstance(api_key_required, bool):
            raise TypeError("Expected argument 'api_key_required' to be a bool")
        pulumi.set(__self__, "api_key_required", api_key_required)
        if authorization_scopes and not isinstance(authorization_scopes, list):
            raise TypeError("Expected argument 'authorization_scopes' to be a list")
        pulumi.set(__self__, "authorization_scopes", authorization_scopes)
        if authorization_type and not isinstance(authorization_type, str):
            raise TypeError("Expected argument 'authorization_type' to be a str")
        pulumi.set(__self__, "authorization_type", authorization_type)
        if authorizer_id and not isinstance(authorizer_id, str):
            raise TypeError("Expected argument 'authorizer_id' to be a str")
        pulumi.set(__self__, "authorizer_id", authorizer_id)
        if integration and not isinstance(integration, dict):
            raise TypeError("Expected argument 'integration' to be a dict")
        pulumi.set(__self__, "integration", integration)
        if method_responses and not isinstance(method_responses, list):
            raise TypeError("Expected argument 'method_responses' to be a list")
        pulumi.set(__self__, "method_responses", method_responses)
        if operation_name and not isinstance(operation_name, str):
            raise TypeError("Expected argument 'operation_name' to be a str")
        pulumi.set(__self__, "operation_name", operation_name)
        if request_models and not isinstance(request_models, dict):
            raise TypeError("Expected argument 'request_models' to be a dict")
        pulumi.set(__self__, "request_models", request_models)
        if request_parameters and not isinstance(request_parameters, dict):
            raise TypeError("Expected argument 'request_parameters' to be a dict")
        pulumi.set(__self__, "request_parameters", request_parameters)
        if request_validator_id and not isinstance(request_validator_id, str):
            raise TypeError("Expected argument 'request_validator_id' to be a str")
        pulumi.set(__self__, "request_validator_id", request_validator_id)

    @property
    @pulumi.getter(name="apiKeyRequired")
    def api_key_required(self) -> Optional[builtins.bool]:
        """
        A boolean flag specifying whether a valid ApiKey is required to invoke this method.
        """
        return pulumi.get(self, "api_key_required")

    @property
    @pulumi.getter(name="authorizationScopes")
    def authorization_scopes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of authorization scopes configured on the method. The scopes are used with a `COGNITO_USER_POOLS` authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
        """
        return pulumi.get(self, "authorization_scopes")

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[builtins.str]:
        """
        The method's authorization type. This parameter is required. For valid values, see [Method](https://docs.aws.amazon.com/apigateway/latest/api/API_Method.html) in the *API Gateway API Reference*.
          If you specify the ``AuthorizerId`` property, specify ``CUSTOM`` or ``COGNITO_USER_POOLS`` for this property.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[builtins.str]:
        """
        The identifier of an authorizer to use on this method. The method's authorization type must be `CUSTOM` or `COGNITO_USER_POOLS` .
        """
        return pulumi.get(self, "authorizer_id")

    @property
    @pulumi.getter
    def integration(self) -> Optional['outputs.MethodIntegration']:
        """
        Represents an `HTTP` , `HTTP_PROXY` , `AWS` , `AWS_PROXY` , or Mock integration.
        """
        return pulumi.get(self, "integration")

    @property
    @pulumi.getter(name="methodResponses")
    def method_responses(self) -> Optional[Sequence['outputs.MethodResponse']]:
        """
        Gets a method response associated with a given HTTP status code.
        """
        return pulumi.get(self, "method_responses")

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[builtins.str]:
        """
        A human-friendly operation identifier for the method. For example, you can assign the `operationName` of `ListPets` for the `GET /pets` method in the `PetStore` example.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="requestModels")
    def request_models(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
        """
        return pulumi.get(self, "request_models")

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> Optional[Mapping[str, Any]]:
        """
        A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of `method.request.{location}.{name}` , where `location` is `querystring` , `path` , or `header` and `name` is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required ( `true` ) or optional ( `false` ). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
        """
        return pulumi.get(self, "request_parameters")

    @property
    @pulumi.getter(name="requestValidatorId")
    def request_validator_id(self) -> Optional[builtins.str]:
        """
        The identifier of a RequestValidator for request validation.
        """
        return pulumi.get(self, "request_validator_id")


class AwaitableGetMethodResult(GetMethodResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMethodResult(
            api_key_required=self.api_key_required,
            authorization_scopes=self.authorization_scopes,
            authorization_type=self.authorization_type,
            authorizer_id=self.authorizer_id,
            integration=self.integration,
            method_responses=self.method_responses,
            operation_name=self.operation_name,
            request_models=self.request_models,
            request_parameters=self.request_parameters,
            request_validator_id=self.request_validator_id)


def get_method(http_method: Optional[builtins.str] = None,
               resource_id: Optional[builtins.str] = None,
               rest_api_id: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMethodResult:
    """
    The ``AWS::ApiGateway::Method`` resource creates API Gateway methods that define the parameters and body that clients must send in their requests.


    :param builtins.str http_method: The method's HTTP verb.
    :param builtins.str resource_id: The Resource identifier for the MethodResponse resource.
    :param builtins.str rest_api_id: The string identifier of the associated RestApi.
    """
    __args__ = dict()
    __args__['httpMethod'] = http_method
    __args__['resourceId'] = resource_id
    __args__['restApiId'] = rest_api_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:apigateway:getMethod', __args__, opts=opts, typ=GetMethodResult).value

    return AwaitableGetMethodResult(
        api_key_required=pulumi.get(__ret__, 'api_key_required'),
        authorization_scopes=pulumi.get(__ret__, 'authorization_scopes'),
        authorization_type=pulumi.get(__ret__, 'authorization_type'),
        authorizer_id=pulumi.get(__ret__, 'authorizer_id'),
        integration=pulumi.get(__ret__, 'integration'),
        method_responses=pulumi.get(__ret__, 'method_responses'),
        operation_name=pulumi.get(__ret__, 'operation_name'),
        request_models=pulumi.get(__ret__, 'request_models'),
        request_parameters=pulumi.get(__ret__, 'request_parameters'),
        request_validator_id=pulumi.get(__ret__, 'request_validator_id'))
def get_method_output(http_method: Optional[pulumi.Input[builtins.str]] = None,
                      resource_id: Optional[pulumi.Input[builtins.str]] = None,
                      rest_api_id: Optional[pulumi.Input[builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMethodResult]:
    """
    The ``AWS::ApiGateway::Method`` resource creates API Gateway methods that define the parameters and body that clients must send in their requests.


    :param builtins.str http_method: The method's HTTP verb.
    :param builtins.str resource_id: The Resource identifier for the MethodResponse resource.
    :param builtins.str rest_api_id: The string identifier of the associated RestApi.
    """
    __args__ = dict()
    __args__['httpMethod'] = http_method
    __args__['resourceId'] = resource_id
    __args__['restApiId'] = rest_api_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:apigateway:getMethod', __args__, opts=opts, typ=GetMethodResult)
    return __ret__.apply(lambda __response__: GetMethodResult(
        api_key_required=pulumi.get(__response__, 'api_key_required'),
        authorization_scopes=pulumi.get(__response__, 'authorization_scopes'),
        authorization_type=pulumi.get(__response__, 'authorization_type'),
        authorizer_id=pulumi.get(__response__, 'authorizer_id'),
        integration=pulumi.get(__response__, 'integration'),
        method_responses=pulumi.get(__response__, 'method_responses'),
        operation_name=pulumi.get(__response__, 'operation_name'),
        request_models=pulumi.get(__response__, 'request_models'),
        request_parameters=pulumi.get(__response__, 'request_parameters'),
        request_validator_id=pulumi.get(__response__, 'request_validator_id')))
