# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetDomainNameV2Result',
    'AwaitableGetDomainNameV2Result',
    'get_domain_name_v2',
    'get_domain_name_v2_output',
]

@pulumi.output_type
class GetDomainNameV2Result:
    def __init__(__self__, certificate_arn=None, domain_name_arn=None, domain_name_id=None, policy=None, routing_mode=None, tags=None):
        if certificate_arn and not isinstance(certificate_arn, str):
            raise TypeError("Expected argument 'certificate_arn' to be a str")
        pulumi.set(__self__, "certificate_arn", certificate_arn)
        if domain_name_arn and not isinstance(domain_name_arn, str):
            raise TypeError("Expected argument 'domain_name_arn' to be a str")
        pulumi.set(__self__, "domain_name_arn", domain_name_arn)
        if domain_name_id and not isinstance(domain_name_id, str):
            raise TypeError("Expected argument 'domain_name_id' to be a str")
        pulumi.set(__self__, "domain_name_id", domain_name_id)
        if policy and not isinstance(policy, dict):
            raise TypeError("Expected argument 'policy' to be a dict")
        pulumi.set(__self__, "policy", policy)
        if routing_mode and not isinstance(routing_mode, str):
            raise TypeError("Expected argument 'routing_mode' to be a str")
        pulumi.set(__self__, "routing_mode", routing_mode)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[builtins.str]:
        """
        The reference to an AWS -managed certificate that will be used by the private endpoint for this domain name. AWS Certificate Manager is the only supported source.
        """
        return pulumi.get(self, "certificate_arn")

    @property
    @pulumi.getter(name="domainNameArn")
    def domain_name_arn(self) -> Optional[builtins.str]:
        """
        The amazon resource name (ARN) of the domain name resource.
        """
        return pulumi.get(self, "domain_name_arn")

    @property
    @pulumi.getter(name="domainNameId")
    def domain_name_id(self) -> Optional[builtins.str]:
        """
        The domain name ID.
        """
        return pulumi.get(self, "domain_name_id")

    @property
    @pulumi.getter
    def policy(self) -> Optional[Any]:
        """
        A stringified JSON policy document that applies to the `execute-api` service for this DomainName regardless of the caller and Method configuration. You can use `Fn::ToJsonString` to enter your `policy` . For more information, see [Fn::ToJsonString](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ToJsonString.html) .

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::ApiGateway::DomainNameV2` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="routingMode")
    def routing_mode(self) -> Optional['DomainNameV2RoutingMode']:
        """
        The valid routing modes are [BASE_PATH_MAPPING_ONLY], [ROUTING_RULE_THEN_BASE_PATH_MAPPING] and [ROUTING_RULE_ONLY]. All other inputs are invalid.
        """
        return pulumi.get(self, "routing_mode")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The collection of tags. Each tag element is associated with a given resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDomainNameV2Result(GetDomainNameV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainNameV2Result(
            certificate_arn=self.certificate_arn,
            domain_name_arn=self.domain_name_arn,
            domain_name_id=self.domain_name_id,
            policy=self.policy,
            routing_mode=self.routing_mode,
            tags=self.tags)


def get_domain_name_v2(domain_name_arn: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainNameV2Result:
    """
    Resource Type definition for AWS::ApiGateway::DomainNameV2.


    :param builtins.str domain_name_arn: The amazon resource name (ARN) of the domain name resource.
    """
    __args__ = dict()
    __args__['domainNameArn'] = domain_name_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:apigateway:getDomainNameV2', __args__, opts=opts, typ=GetDomainNameV2Result).value

    return AwaitableGetDomainNameV2Result(
        certificate_arn=pulumi.get(__ret__, 'certificate_arn'),
        domain_name_arn=pulumi.get(__ret__, 'domain_name_arn'),
        domain_name_id=pulumi.get(__ret__, 'domain_name_id'),
        policy=pulumi.get(__ret__, 'policy'),
        routing_mode=pulumi.get(__ret__, 'routing_mode'),
        tags=pulumi.get(__ret__, 'tags'))
def get_domain_name_v2_output(domain_name_arn: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainNameV2Result]:
    """
    Resource Type definition for AWS::ApiGateway::DomainNameV2.


    :param builtins.str domain_name_arn: The amazon resource name (ARN) of the domain name resource.
    """
    __args__ = dict()
    __args__['domainNameArn'] = domain_name_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:apigateway:getDomainNameV2', __args__, opts=opts, typ=GetDomainNameV2Result)
    return __ret__.apply(lambda __response__: GetDomainNameV2Result(
        certificate_arn=pulumi.get(__response__, 'certificate_arn'),
        domain_name_arn=pulumi.get(__response__, 'domain_name_arn'),
        domain_name_id=pulumi.get(__response__, 'domain_name_id'),
        policy=pulumi.get(__response__, 'policy'),
        routing_mode=pulumi.get(__response__, 'routing_mode'),
        tags=pulumi.get(__response__, 'tags')))
