# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBasePathMappingResult',
    'AwaitableGetBasePathMappingResult',
    'get_base_path_mapping',
    'get_base_path_mapping_output',
]

@pulumi.output_type
class GetBasePathMappingResult:
    def __init__(__self__, rest_api_id=None, stage=None):
        if rest_api_id and not isinstance(rest_api_id, str):
            raise TypeError("Expected argument 'rest_api_id' to be a str")
        pulumi.set(__self__, "rest_api_id", rest_api_id)
        if stage and not isinstance(stage, str):
            raise TypeError("Expected argument 'stage' to be a str")
        pulumi.set(__self__, "stage", stage)

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> Optional[builtins.str]:
        """
        The string identifier of the associated RestApi.
        """
        return pulumi.get(self, "rest_api_id")

    @property
    @pulumi.getter
    def stage(self) -> Optional[builtins.str]:
        """
        The name of the associated stage.
        """
        return pulumi.get(self, "stage")


class AwaitableGetBasePathMappingResult(GetBasePathMappingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBasePathMappingResult(
            rest_api_id=self.rest_api_id,
            stage=self.stage)


def get_base_path_mapping(base_path: Optional[builtins.str] = None,
                          domain_name: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBasePathMappingResult:
    """
    The ``AWS::ApiGateway::BasePathMapping`` resource creates a base path that clients who call your API must use in the invocation URL.


    :param builtins.str base_path: The base path name that callers of the API must provide as part of the URL after the domain name.
    :param builtins.str domain_name: The domain name of the BasePathMapping resource to be described.
    """
    __args__ = dict()
    __args__['basePath'] = base_path
    __args__['domainName'] = domain_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:apigateway:getBasePathMapping', __args__, opts=opts, typ=GetBasePathMappingResult).value

    return AwaitableGetBasePathMappingResult(
        rest_api_id=pulumi.get(__ret__, 'rest_api_id'),
        stage=pulumi.get(__ret__, 'stage'))
def get_base_path_mapping_output(base_path: Optional[pulumi.Input[builtins.str]] = None,
                                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBasePathMappingResult]:
    """
    The ``AWS::ApiGateway::BasePathMapping`` resource creates a base path that clients who call your API must use in the invocation URL.


    :param builtins.str base_path: The base path name that callers of the API must provide as part of the URL after the domain name.
    :param builtins.str domain_name: The domain name of the BasePathMapping resource to be described.
    """
    __args__ = dict()
    __args__['basePath'] = base_path
    __args__['domainName'] = domain_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:apigateway:getBasePathMapping', __args__, opts=opts, typ=GetBasePathMappingResult)
    return __ret__.apply(lambda __response__: GetBasePathMappingResult(
        rest_api_id=pulumi.get(__response__, 'rest_api_id'),
        stage=pulumi.get(__response__, 'stage')))
