# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DomainNameV2Args', 'DomainNameV2']

@pulumi.input_type
class DomainNameV2Args:
    def __init__(__self__, *,
                 certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_configuration: Optional[pulumi.Input['DomainNameV2EndpointConfigurationArgs']] = None,
                 policy: Optional[Any] = None,
                 routing_mode: Optional[pulumi.Input['DomainNameV2RoutingMode']] = None,
                 security_policy: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DomainNameV2 resource.
        :param pulumi.Input[builtins.str] certificate_arn: The reference to an AWS -managed certificate that will be used by the private endpoint for this domain name. AWS Certificate Manager is the only supported source.
        :param pulumi.Input[builtins.str] domain_name: Represents a custom domain name as a user-friendly host name of an API (RestApi).
        :param pulumi.Input['DomainNameV2EndpointConfigurationArgs'] endpoint_configuration: The endpoint configuration to indicate the types of endpoints an API (RestApi) or its custom domain name (DomainName) has and the IP address types that can invoke it.
        :param Any policy: A stringified JSON policy document that applies to the `execute-api` service for this DomainName regardless of the caller and Method configuration. You can use `Fn::ToJsonString` to enter your `policy` . For more information, see [Fn::ToJsonString](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ToJsonString.html) .
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::ApiGateway::DomainNameV2` for more information about the expected schema for this property.
        :param pulumi.Input['DomainNameV2RoutingMode'] routing_mode: The valid routing modes are [BASE_PATH_MAPPING_ONLY], [ROUTING_RULE_THEN_BASE_PATH_MAPPING] and [ROUTING_RULE_ONLY]. All other inputs are invalid.
        :param pulumi.Input[builtins.str] security_policy: The Transport Layer Security (TLS) version + cipher suite for this DomainName. Only `TLS_1_2` is supported.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The collection of tags. Each tag element is associated with a given resource.
        """
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if endpoint_configuration is not None:
            pulumi.set(__self__, "endpoint_configuration", endpoint_configuration)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if routing_mode is not None:
            pulumi.set(__self__, "routing_mode", routing_mode)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reference to an AWS -managed certificate that will be used by the private endpoint for this domain name. AWS Certificate Manager is the only supported source.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_arn", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Represents a custom domain name as a user-friendly host name of an API (RestApi).
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="endpointConfiguration")
    def endpoint_configuration(self) -> Optional[pulumi.Input['DomainNameV2EndpointConfigurationArgs']]:
        """
        The endpoint configuration to indicate the types of endpoints an API (RestApi) or its custom domain name (DomainName) has and the IP address types that can invoke it.
        """
        return pulumi.get(self, "endpoint_configuration")

    @endpoint_configuration.setter
    def endpoint_configuration(self, value: Optional[pulumi.Input['DomainNameV2EndpointConfigurationArgs']]):
        pulumi.set(self, "endpoint_configuration", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[Any]:
        """
        A stringified JSON policy document that applies to the `execute-api` service for this DomainName regardless of the caller and Method configuration. You can use `Fn::ToJsonString` to enter your `policy` . For more information, see [Fn::ToJsonString](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ToJsonString.html) .

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::ApiGateway::DomainNameV2` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[Any]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="routingMode")
    def routing_mode(self) -> Optional[pulumi.Input['DomainNameV2RoutingMode']]:
        """
        The valid routing modes are [BASE_PATH_MAPPING_ONLY], [ROUTING_RULE_THEN_BASE_PATH_MAPPING] and [ROUTING_RULE_ONLY]. All other inputs are invalid.
        """
        return pulumi.get(self, "routing_mode")

    @routing_mode.setter
    def routing_mode(self, value: Optional[pulumi.Input['DomainNameV2RoutingMode']]):
        pulumi.set(self, "routing_mode", value)

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Transport Layer Security (TLS) version + cipher suite for this DomainName. Only `TLS_1_2` is supported.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The collection of tags. Each tag element is associated with a given resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:apigateway:DomainNameV2")
class DomainNameV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_configuration: Optional[pulumi.Input[Union['DomainNameV2EndpointConfigurationArgs', 'DomainNameV2EndpointConfigurationArgsDict']]] = None,
                 policy: Optional[Any] = None,
                 routing_mode: Optional[pulumi.Input['DomainNameV2RoutingMode']] = None,
                 security_policy: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::ApiGateway::DomainNameV2.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] certificate_arn: The reference to an AWS -managed certificate that will be used by the private endpoint for this domain name. AWS Certificate Manager is the only supported source.
        :param pulumi.Input[builtins.str] domain_name: Represents a custom domain name as a user-friendly host name of an API (RestApi).
        :param pulumi.Input[Union['DomainNameV2EndpointConfigurationArgs', 'DomainNameV2EndpointConfigurationArgsDict']] endpoint_configuration: The endpoint configuration to indicate the types of endpoints an API (RestApi) or its custom domain name (DomainName) has and the IP address types that can invoke it.
        :param Any policy: A stringified JSON policy document that applies to the `execute-api` service for this DomainName regardless of the caller and Method configuration. You can use `Fn::ToJsonString` to enter your `policy` . For more information, see [Fn::ToJsonString](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ToJsonString.html) .
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::ApiGateway::DomainNameV2` for more information about the expected schema for this property.
        :param pulumi.Input['DomainNameV2RoutingMode'] routing_mode: The valid routing modes are [BASE_PATH_MAPPING_ONLY], [ROUTING_RULE_THEN_BASE_PATH_MAPPING] and [ROUTING_RULE_ONLY]. All other inputs are invalid.
        :param pulumi.Input[builtins.str] security_policy: The Transport Layer Security (TLS) version + cipher suite for this DomainName. Only `TLS_1_2` is supported.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The collection of tags. Each tag element is associated with a given resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DomainNameV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::ApiGateway::DomainNameV2.

        :param str resource_name: The name of the resource.
        :param DomainNameV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainNameV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_configuration: Optional[pulumi.Input[Union['DomainNameV2EndpointConfigurationArgs', 'DomainNameV2EndpointConfigurationArgsDict']]] = None,
                 policy: Optional[Any] = None,
                 routing_mode: Optional[pulumi.Input['DomainNameV2RoutingMode']] = None,
                 security_policy: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainNameV2Args.__new__(DomainNameV2Args)

            __props__.__dict__["certificate_arn"] = certificate_arn
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["endpoint_configuration"] = endpoint_configuration
            __props__.__dict__["policy"] = policy
            __props__.__dict__["routing_mode"] = routing_mode
            __props__.__dict__["security_policy"] = security_policy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["domain_name_arn"] = None
            __props__.__dict__["domain_name_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domainName", "endpointConfiguration", "securityPolicy"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DomainNameV2, __self__).__init__(
            'aws-native:apigateway:DomainNameV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DomainNameV2':
        """
        Get an existing DomainNameV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DomainNameV2Args.__new__(DomainNameV2Args)

        __props__.__dict__["certificate_arn"] = None
        __props__.__dict__["domain_name"] = None
        __props__.__dict__["domain_name_arn"] = None
        __props__.__dict__["domain_name_id"] = None
        __props__.__dict__["endpoint_configuration"] = None
        __props__.__dict__["policy"] = None
        __props__.__dict__["routing_mode"] = None
        __props__.__dict__["security_policy"] = None
        __props__.__dict__["tags"] = None
        return DomainNameV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The reference to an AWS -managed certificate that will be used by the private endpoint for this domain name. AWS Certificate Manager is the only supported source.
        """
        return pulumi.get(self, "certificate_arn")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Represents a custom domain name as a user-friendly host name of an API (RestApi).
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="domainNameArn")
    def domain_name_arn(self) -> pulumi.Output[builtins.str]:
        """
        The amazon resource name (ARN) of the domain name resource.
        """
        return pulumi.get(self, "domain_name_arn")

    @property
    @pulumi.getter(name="domainNameId")
    def domain_name_id(self) -> pulumi.Output[builtins.str]:
        """
        The domain name ID.
        """
        return pulumi.get(self, "domain_name_id")

    @property
    @pulumi.getter(name="endpointConfiguration")
    def endpoint_configuration(self) -> pulumi.Output[Optional['outputs.DomainNameV2EndpointConfiguration']]:
        """
        The endpoint configuration to indicate the types of endpoints an API (RestApi) or its custom domain name (DomainName) has and the IP address types that can invoke it.
        """
        return pulumi.get(self, "endpoint_configuration")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[Optional[Any]]:
        """
        A stringified JSON policy document that applies to the `execute-api` service for this DomainName regardless of the caller and Method configuration. You can use `Fn::ToJsonString` to enter your `policy` . For more information, see [Fn::ToJsonString](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ToJsonString.html) .

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::ApiGateway::DomainNameV2` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="routingMode")
    def routing_mode(self) -> pulumi.Output[Optional['DomainNameV2RoutingMode']]:
        """
        The valid routing modes are [BASE_PATH_MAPPING_ONLY], [ROUTING_RULE_THEN_BASE_PATH_MAPPING] and [ROUTING_RULE_ONLY]. All other inputs are invalid.
        """
        return pulumi.get(self, "routing_mode")

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Transport Layer Security (TLS) version + cipher suite for this DomainName. Only `TLS_1_2` is supported.
        """
        return pulumi.get(self, "security_policy")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The collection of tags. Each tag element is associated with a given resource.
        """
        return pulumi.get(self, "tags")

