# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['DomainNameAccessAssociationArgs', 'DomainNameAccessAssociation']

@pulumi.input_type
class DomainNameAccessAssociationArgs:
    def __init__(__self__, *,
                 access_association_source: pulumi.Input[builtins.str],
                 access_association_source_type: pulumi.Input['DomainNameAccessAssociationAccessAssociationSourceType'],
                 domain_name_arn: pulumi.Input[builtins.str],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]] = None):
        """
        The set of arguments for constructing a DomainNameAccessAssociation resource.
        :param pulumi.Input[builtins.str] access_association_source: The source of the domain name access association resource.
        :param pulumi.Input['DomainNameAccessAssociationAccessAssociationSourceType'] access_association_source_type: The source type of the domain name access association resource.
        :param pulumi.Input[builtins.str] domain_name_arn: The amazon resource name (ARN) of the domain name resource.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]] tags: An array of arbitrary tags (key-value pairs) to associate with the domainname access association.
        """
        pulumi.set(__self__, "access_association_source", access_association_source)
        pulumi.set(__self__, "access_association_source_type", access_association_source_type)
        pulumi.set(__self__, "domain_name_arn", domain_name_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accessAssociationSource")
    def access_association_source(self) -> pulumi.Input[builtins.str]:
        """
        The source of the domain name access association resource.
        """
        return pulumi.get(self, "access_association_source")

    @access_association_source.setter
    def access_association_source(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "access_association_source", value)

    @property
    @pulumi.getter(name="accessAssociationSourceType")
    def access_association_source_type(self) -> pulumi.Input['DomainNameAccessAssociationAccessAssociationSourceType']:
        """
        The source type of the domain name access association resource.
        """
        return pulumi.get(self, "access_association_source_type")

    @access_association_source_type.setter
    def access_association_source_type(self, value: pulumi.Input['DomainNameAccessAssociationAccessAssociationSourceType']):
        pulumi.set(self, "access_association_source_type", value)

    @property
    @pulumi.getter(name="domainNameArn")
    def domain_name_arn(self) -> pulumi.Input[builtins.str]:
        """
        The amazon resource name (ARN) of the domain name resource.
        """
        return pulumi.get(self, "domain_name_arn")

    @domain_name_arn.setter
    def domain_name_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_name_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]:
        """
        An array of arbitrary tags (key-value pairs) to associate with the domainname access association.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:apigateway:DomainNameAccessAssociation")
class DomainNameAccessAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_association_source: Optional[pulumi.Input[builtins.str]] = None,
                 access_association_source_type: Optional[pulumi.Input['DomainNameAccessAssociationAccessAssociationSourceType']] = None,
                 domain_name_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::ApiGateway::DomainNameAccessAssociation.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_association_source: The source of the domain name access association resource.
        :param pulumi.Input['DomainNameAccessAssociationAccessAssociationSourceType'] access_association_source_type: The source type of the domain name access association resource.
        :param pulumi.Input[builtins.str] domain_name_arn: The amazon resource name (ARN) of the domain name resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]] tags: An array of arbitrary tags (key-value pairs) to associate with the domainname access association.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainNameAccessAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::ApiGateway::DomainNameAccessAssociation.

        :param str resource_name: The name of the resource.
        :param DomainNameAccessAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainNameAccessAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_association_source: Optional[pulumi.Input[builtins.str]] = None,
                 access_association_source_type: Optional[pulumi.Input['DomainNameAccessAssociationAccessAssociationSourceType']] = None,
                 domain_name_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainNameAccessAssociationArgs.__new__(DomainNameAccessAssociationArgs)

            if access_association_source is None and not opts.urn:
                raise TypeError("Missing required property 'access_association_source'")
            __props__.__dict__["access_association_source"] = access_association_source
            if access_association_source_type is None and not opts.urn:
                raise TypeError("Missing required property 'access_association_source_type'")
            __props__.__dict__["access_association_source_type"] = access_association_source_type
            if domain_name_arn is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name_arn'")
            __props__.__dict__["domain_name_arn"] = domain_name_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["domain_name_access_association_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["accessAssociationSource", "accessAssociationSourceType", "domainNameArn", "tags[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DomainNameAccessAssociation, __self__).__init__(
            'aws-native:apigateway:DomainNameAccessAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DomainNameAccessAssociation':
        """
        Get an existing DomainNameAccessAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DomainNameAccessAssociationArgs.__new__(DomainNameAccessAssociationArgs)

        __props__.__dict__["access_association_source"] = None
        __props__.__dict__["access_association_source_type"] = None
        __props__.__dict__["domain_name_access_association_arn"] = None
        __props__.__dict__["domain_name_arn"] = None
        __props__.__dict__["tags"] = None
        return DomainNameAccessAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessAssociationSource")
    def access_association_source(self) -> pulumi.Output[builtins.str]:
        """
        The source of the domain name access association resource.
        """
        return pulumi.get(self, "access_association_source")

    @property
    @pulumi.getter(name="accessAssociationSourceType")
    def access_association_source_type(self) -> pulumi.Output['DomainNameAccessAssociationAccessAssociationSourceType']:
        """
        The source type of the domain name access association resource.
        """
        return pulumi.get(self, "access_association_source_type")

    @property
    @pulumi.getter(name="domainNameAccessAssociationArn")
    def domain_name_access_association_arn(self) -> pulumi.Output[builtins.str]:
        """
        The amazon resource name (ARN) of the domain name access association resource.
        """
        return pulumi.get(self, "domain_name_access_association_arn")

    @property
    @pulumi.getter(name="domainNameArn")
    def domain_name_arn(self) -> pulumi.Output[builtins.str]:
        """
        The amazon resource name (ARN) of the domain name resource.
        """
        return pulumi.get(self, "domain_name_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.CreateOnlyTag']]]:
        """
        An array of arbitrary tags (key-value pairs) to associate with the domainname access association.
        """
        return pulumi.get(self, "tags")

