# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BasePathMappingV2Args', 'BasePathMappingV2']

@pulumi.input_type
class BasePathMappingV2Args:
    def __init__(__self__, *,
                 domain_name_arn: pulumi.Input[builtins.str],
                 rest_api_id: pulumi.Input[builtins.str],
                 base_path: Optional[pulumi.Input[builtins.str]] = None,
                 stage: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a BasePathMappingV2 resource.
        :param pulumi.Input[builtins.str] domain_name_arn: The Arn of an AWS::ApiGateway::DomainNameV2 resource.
        :param pulumi.Input[builtins.str] rest_api_id: The ID of the API.
        :param pulumi.Input[builtins.str] base_path: The base path name that callers of the API must provide in the URL after the domain name.
        :param pulumi.Input[builtins.str] stage: The name of the API's stage.
        """
        pulumi.set(__self__, "domain_name_arn", domain_name_arn)
        pulumi.set(__self__, "rest_api_id", rest_api_id)
        if base_path is not None:
            pulumi.set(__self__, "base_path", base_path)
        if stage is not None:
            pulumi.set(__self__, "stage", stage)

    @property
    @pulumi.getter(name="domainNameArn")
    def domain_name_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Arn of an AWS::ApiGateway::DomainNameV2 resource.
        """
        return pulumi.get(self, "domain_name_arn")

    @domain_name_arn.setter
    def domain_name_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_name_arn", value)

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the API.
        """
        return pulumi.get(self, "rest_api_id")

    @rest_api_id.setter
    def rest_api_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "rest_api_id", value)

    @property
    @pulumi.getter(name="basePath")
    def base_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The base path name that callers of the API must provide in the URL after the domain name.
        """
        return pulumi.get(self, "base_path")

    @base_path.setter
    def base_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "base_path", value)

    @property
    @pulumi.getter
    def stage(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the API's stage.
        """
        return pulumi.get(self, "stage")

    @stage.setter
    def stage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stage", value)


@pulumi.type_token("aws-native:apigateway:BasePathMappingV2")
class BasePathMappingV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_path: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name_arn: Optional[pulumi.Input[builtins.str]] = None,
                 rest_api_id: Optional[pulumi.Input[builtins.str]] = None,
                 stage: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::ApiGateway::BasePathMappingV2

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] base_path: The base path name that callers of the API must provide in the URL after the domain name.
        :param pulumi.Input[builtins.str] domain_name_arn: The Arn of an AWS::ApiGateway::DomainNameV2 resource.
        :param pulumi.Input[builtins.str] rest_api_id: The ID of the API.
        :param pulumi.Input[builtins.str] stage: The name of the API's stage.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BasePathMappingV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::ApiGateway::BasePathMappingV2

        :param str resource_name: The name of the resource.
        :param BasePathMappingV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BasePathMappingV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_path: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name_arn: Optional[pulumi.Input[builtins.str]] = None,
                 rest_api_id: Optional[pulumi.Input[builtins.str]] = None,
                 stage: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BasePathMappingV2Args.__new__(BasePathMappingV2Args)

            __props__.__dict__["base_path"] = base_path
            if domain_name_arn is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name_arn'")
            __props__.__dict__["domain_name_arn"] = domain_name_arn
            if rest_api_id is None and not opts.urn:
                raise TypeError("Missing required property 'rest_api_id'")
            __props__.__dict__["rest_api_id"] = rest_api_id
            __props__.__dict__["stage"] = stage
            __props__.__dict__["base_path_mapping_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["basePath", "domainNameArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(BasePathMappingV2, __self__).__init__(
            'aws-native:apigateway:BasePathMappingV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'BasePathMappingV2':
        """
        Get an existing BasePathMappingV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BasePathMappingV2Args.__new__(BasePathMappingV2Args)

        __props__.__dict__["base_path"] = None
        __props__.__dict__["base_path_mapping_arn"] = None
        __props__.__dict__["domain_name_arn"] = None
        __props__.__dict__["rest_api_id"] = None
        __props__.__dict__["stage"] = None
        return BasePathMappingV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="basePath")
    def base_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The base path name that callers of the API must provide in the URL after the domain name.
        """
        return pulumi.get(self, "base_path")

    @property
    @pulumi.getter(name="basePathMappingArn")
    def base_path_mapping_arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of the resource.
        """
        return pulumi.get(self, "base_path_mapping_arn")

    @property
    @pulumi.getter(name="domainNameArn")
    def domain_name_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Arn of an AWS::ApiGateway::DomainNameV2 resource.
        """
        return pulumi.get(self, "domain_name_arn")

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the API.
        """
        return pulumi.get(self, "rest_api_id")

    @property
    @pulumi.getter
    def stage(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the API's stage.
        """
        return pulumi.get(self, "stage")

