# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ApiKeyStageKeyArgs',
    'ApiKeyStageKeyArgsDict',
    'DeploymentAccessLogSettingArgs',
    'DeploymentAccessLogSettingArgsDict',
    'DeploymentCanarySettingsArgs',
    'DeploymentCanarySettingsArgsDict',
    'DeploymentCanarySettingArgs',
    'DeploymentCanarySettingArgsDict',
    'DeploymentMethodSettingArgs',
    'DeploymentMethodSettingArgsDict',
    'DeploymentStageDescriptionArgs',
    'DeploymentStageDescriptionArgsDict',
    'DeploymentTagArgs',
    'DeploymentTagArgsDict',
    'DocumentationPartLocationArgs',
    'DocumentationPartLocationArgsDict',
    'DomainNameEndpointConfigurationArgs',
    'DomainNameEndpointConfigurationArgsDict',
    'DomainNameMutualTlsAuthenticationArgs',
    'DomainNameMutualTlsAuthenticationArgsDict',
    'DomainNameV2EndpointConfigurationArgs',
    'DomainNameV2EndpointConfigurationArgsDict',
    'MethodIntegrationResponseArgs',
    'MethodIntegrationResponseArgsDict',
    'MethodIntegrationArgs',
    'MethodIntegrationArgsDict',
    'MethodResponseArgs',
    'MethodResponseArgsDict',
    'RestApiEndpointConfigurationArgs',
    'RestApiEndpointConfigurationArgsDict',
    'RestApiS3LocationArgs',
    'RestApiS3LocationArgsDict',
    'StageAccessLogSettingArgs',
    'StageAccessLogSettingArgsDict',
    'StageCanarySettingArgs',
    'StageCanarySettingArgsDict',
    'StageMethodSettingArgs',
    'StageMethodSettingArgsDict',
    'UsagePlanApiStageArgs',
    'UsagePlanApiStageArgsDict',
    'UsagePlanQuotaSettingsArgs',
    'UsagePlanQuotaSettingsArgsDict',
    'UsagePlanThrottleSettingsArgs',
    'UsagePlanThrottleSettingsArgsDict',
]

MYPY = False

if not MYPY:
    class ApiKeyStageKeyArgsDict(TypedDict):
        """
        ``StageKey`` is a property of the [AWS::ApiGateway::ApiKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html) resource that specifies the stage to associate with the API key. This association allows only clients with the key to make requests to methods in that stage.
        """
        rest_api_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The string identifier of the associated RestApi.
        """
        stage_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The stage name associated with the stage key.
        """
elif False:
    ApiKeyStageKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApiKeyStageKeyArgs:
    def __init__(__self__, *,
                 rest_api_id: Optional[pulumi.Input[builtins.str]] = None,
                 stage_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        ``StageKey`` is a property of the [AWS::ApiGateway::ApiKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html) resource that specifies the stage to associate with the API key. This association allows only clients with the key to make requests to methods in that stage.
        :param pulumi.Input[builtins.str] rest_api_id: The string identifier of the associated RestApi.
        :param pulumi.Input[builtins.str] stage_name: The stage name associated with the stage key.
        """
        if rest_api_id is not None:
            pulumi.set(__self__, "rest_api_id", rest_api_id)
        if stage_name is not None:
            pulumi.set(__self__, "stage_name", stage_name)

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The string identifier of the associated RestApi.
        """
        return pulumi.get(self, "rest_api_id")

    @rest_api_id.setter
    def rest_api_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rest_api_id", value)

    @property
    @pulumi.getter(name="stageName")
    def stage_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The stage name associated with the stage key.
        """
        return pulumi.get(self, "stage_name")

    @stage_name.setter
    def stage_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stage_name", value)


if not MYPY:
    class DeploymentAccessLogSettingArgsDict(TypedDict):
        """
        The ``AccessLogSetting`` property type specifies settings for logging access in this stage.
          ``AccessLogSetting`` is a property of the [StageDescription](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html) property type.
        """
        destination_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with `amazon-apigateway-` .
        """
        format: NotRequired[pulumi.Input[builtins.str]]
        """
        A single line format of the access logs of data, as specified by selected $context variables. The format must include at least `$context.requestId` .
        """
elif False:
    DeploymentAccessLogSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentAccessLogSettingArgs:
    def __init__(__self__, *,
                 destination_arn: Optional[pulumi.Input[builtins.str]] = None,
                 format: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ``AccessLogSetting`` property type specifies settings for logging access in this stage.
          ``AccessLogSetting`` is a property of the [StageDescription](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html) property type.
        :param pulumi.Input[builtins.str] destination_arn: The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with `amazon-apigateway-` .
        :param pulumi.Input[builtins.str] format: A single line format of the access logs of data, as specified by selected $context variables. The format must include at least `$context.requestId` .
        """
        if destination_arn is not None:
            pulumi.set(__self__, "destination_arn", destination_arn)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with `amazon-apigateway-` .
        """
        return pulumi.get(self, "destination_arn")

    @destination_arn.setter
    def destination_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_arn", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A single line format of the access logs of data, as specified by selected $context variables. The format must include at least `$context.requestId` .
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "format", value)


if not MYPY:
    class DeploymentCanarySettingsArgsDict(TypedDict):
        """
        The ``DeploymentCanarySettings`` property type specifies settings for the canary deployment.
        """
        percent_traffic: NotRequired[pulumi.Input[builtins.float]]
        """
        The percentage (0.0-100.0) of traffic routed to the canary deployment.
        """
        stage_variable_overrides: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
        """
        use_stage_cache: NotRequired[pulumi.Input[builtins.bool]]
        """
        A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
        """
elif False:
    DeploymentCanarySettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentCanarySettingsArgs:
    def __init__(__self__, *,
                 percent_traffic: Optional[pulumi.Input[builtins.float]] = None,
                 stage_variable_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 use_stage_cache: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The ``DeploymentCanarySettings`` property type specifies settings for the canary deployment.
        :param pulumi.Input[builtins.float] percent_traffic: The percentage (0.0-100.0) of traffic routed to the canary deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] stage_variable_overrides: A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
        :param pulumi.Input[builtins.bool] use_stage_cache: A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
        """
        if percent_traffic is not None:
            pulumi.set(__self__, "percent_traffic", percent_traffic)
        if stage_variable_overrides is not None:
            pulumi.set(__self__, "stage_variable_overrides", stage_variable_overrides)
        if use_stage_cache is not None:
            pulumi.set(__self__, "use_stage_cache", use_stage_cache)

    @property
    @pulumi.getter(name="percentTraffic")
    def percent_traffic(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The percentage (0.0-100.0) of traffic routed to the canary deployment.
        """
        return pulumi.get(self, "percent_traffic")

    @percent_traffic.setter
    def percent_traffic(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "percent_traffic", value)

    @property
    @pulumi.getter(name="stageVariableOverrides")
    def stage_variable_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
        """
        return pulumi.get(self, "stage_variable_overrides")

    @stage_variable_overrides.setter
    def stage_variable_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "stage_variable_overrides", value)

    @property
    @pulumi.getter(name="useStageCache")
    def use_stage_cache(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
        """
        return pulumi.get(self, "use_stage_cache")

    @use_stage_cache.setter
    def use_stage_cache(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_stage_cache", value)


if not MYPY:
    class DeploymentCanarySettingArgsDict(TypedDict):
        """
        The ``CanarySetting`` property type specifies settings for the canary deployment in this stage.
         ``CanarySetting`` is a property of the [StageDescription](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html) property type.
        """
        percent_traffic: NotRequired[pulumi.Input[builtins.float]]
        """
        The percent (0-100) of traffic diverted to a canary deployment.
        """
        stage_variable_overrides: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.
        """
        use_stage_cache: NotRequired[pulumi.Input[builtins.bool]]
        """
        A Boolean flag to indicate whether the canary deployment uses the stage cache or not.
        """
elif False:
    DeploymentCanarySettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentCanarySettingArgs:
    def __init__(__self__, *,
                 percent_traffic: Optional[pulumi.Input[builtins.float]] = None,
                 stage_variable_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 use_stage_cache: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The ``CanarySetting`` property type specifies settings for the canary deployment in this stage.
         ``CanarySetting`` is a property of the [StageDescription](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html) property type.
        :param pulumi.Input[builtins.float] percent_traffic: The percent (0-100) of traffic diverted to a canary deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] stage_variable_overrides: Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.
        :param pulumi.Input[builtins.bool] use_stage_cache: A Boolean flag to indicate whether the canary deployment uses the stage cache or not.
        """
        if percent_traffic is not None:
            pulumi.set(__self__, "percent_traffic", percent_traffic)
        if stage_variable_overrides is not None:
            pulumi.set(__self__, "stage_variable_overrides", stage_variable_overrides)
        if use_stage_cache is not None:
            pulumi.set(__self__, "use_stage_cache", use_stage_cache)

    @property
    @pulumi.getter(name="percentTraffic")
    def percent_traffic(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The percent (0-100) of traffic diverted to a canary deployment.
        """
        return pulumi.get(self, "percent_traffic")

    @percent_traffic.setter
    def percent_traffic(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "percent_traffic", value)

    @property
    @pulumi.getter(name="stageVariableOverrides")
    def stage_variable_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.
        """
        return pulumi.get(self, "stage_variable_overrides")

    @stage_variable_overrides.setter
    def stage_variable_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "stage_variable_overrides", value)

    @property
    @pulumi.getter(name="useStageCache")
    def use_stage_cache(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A Boolean flag to indicate whether the canary deployment uses the stage cache or not.
        """
        return pulumi.get(self, "use_stage_cache")

    @use_stage_cache.setter
    def use_stage_cache(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_stage_cache", value)


if not MYPY:
    class DeploymentMethodSettingArgsDict(TypedDict):
        """
        The ``MethodSetting`` property type configures settings for all methods in a stage.
         The ``MethodSettings`` property of the [Amazon API Gateway Deployment StageDescription](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html) property type contains a list of ``MethodSetting`` property types.
        """
        cache_data_encrypted: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether the cached responses are encrypted.
        """
        cache_ttl_in_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
        """
        caching_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
        """
        data_trace_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs. This can be useful to troubleshoot APIs, but can result in logging sensitive data. We recommend that you don't enable this option for production APIs.
        """
        http_method: NotRequired[pulumi.Input[builtins.str]]
        """
        The HTTP method.
        """
        logging_level: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. Valid values are `OFF` , `ERROR` , and `INFO` . Choose `ERROR` to write only error-level entries to CloudWatch Logs, or choose `INFO` to include all `ERROR` events as well as extra informational events.
        """
        metrics_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether Amazon CloudWatch metrics are enabled for this method.
        """
        resource_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource path for this method. Forward slashes (``/``) are encoded as ``~1`` and the initial slash must include a forward slash. For example, the path value ``/resource/subresource`` must be encoded as ``/~1resource~1subresource``. To specify the root path, use only a slash (``/``).
        """
        throttling_burst_limit: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the throttling burst limit.
        """
        throttling_rate_limit: NotRequired[pulumi.Input[builtins.float]]
        """
        Specifies the throttling rate limit.
        """
elif False:
    DeploymentMethodSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentMethodSettingArgs:
    def __init__(__self__, *,
                 cache_data_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 cache_ttl_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 caching_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 data_trace_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 http_method: Optional[pulumi.Input[builtins.str]] = None,
                 logging_level: Optional[pulumi.Input[builtins.str]] = None,
                 metrics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_path: Optional[pulumi.Input[builtins.str]] = None,
                 throttling_burst_limit: Optional[pulumi.Input[builtins.int]] = None,
                 throttling_rate_limit: Optional[pulumi.Input[builtins.float]] = None):
        """
        The ``MethodSetting`` property type configures settings for all methods in a stage.
         The ``MethodSettings`` property of the [Amazon API Gateway Deployment StageDescription](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html) property type contains a list of ``MethodSetting`` property types.
        :param pulumi.Input[builtins.bool] cache_data_encrypted: Specifies whether the cached responses are encrypted.
        :param pulumi.Input[builtins.int] cache_ttl_in_seconds: Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
        :param pulumi.Input[builtins.bool] caching_enabled: Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
        :param pulumi.Input[builtins.bool] data_trace_enabled: Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs. This can be useful to troubleshoot APIs, but can result in logging sensitive data. We recommend that you don't enable this option for production APIs.
        :param pulumi.Input[builtins.str] http_method: The HTTP method.
        :param pulumi.Input[builtins.str] logging_level: Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. Valid values are `OFF` , `ERROR` , and `INFO` . Choose `ERROR` to write only error-level entries to CloudWatch Logs, or choose `INFO` to include all `ERROR` events as well as extra informational events.
        :param pulumi.Input[builtins.bool] metrics_enabled: Specifies whether Amazon CloudWatch metrics are enabled for this method.
        :param pulumi.Input[builtins.str] resource_path: The resource path for this method. Forward slashes (``/``) are encoded as ``~1`` and the initial slash must include a forward slash. For example, the path value ``/resource/subresource`` must be encoded as ``/~1resource~1subresource``. To specify the root path, use only a slash (``/``).
        :param pulumi.Input[builtins.int] throttling_burst_limit: Specifies the throttling burst limit.
        :param pulumi.Input[builtins.float] throttling_rate_limit: Specifies the throttling rate limit.
        """
        if cache_data_encrypted is not None:
            pulumi.set(__self__, "cache_data_encrypted", cache_data_encrypted)
        if cache_ttl_in_seconds is not None:
            pulumi.set(__self__, "cache_ttl_in_seconds", cache_ttl_in_seconds)
        if caching_enabled is not None:
            pulumi.set(__self__, "caching_enabled", caching_enabled)
        if data_trace_enabled is not None:
            pulumi.set(__self__, "data_trace_enabled", data_trace_enabled)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if metrics_enabled is not None:
            pulumi.set(__self__, "metrics_enabled", metrics_enabled)
        if resource_path is not None:
            pulumi.set(__self__, "resource_path", resource_path)
        if throttling_burst_limit is not None:
            pulumi.set(__self__, "throttling_burst_limit", throttling_burst_limit)
        if throttling_rate_limit is not None:
            pulumi.set(__self__, "throttling_rate_limit", throttling_rate_limit)

    @property
    @pulumi.getter(name="cacheDataEncrypted")
    def cache_data_encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the cached responses are encrypted.
        """
        return pulumi.get(self, "cache_data_encrypted")

    @cache_data_encrypted.setter
    def cache_data_encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cache_data_encrypted", value)

    @property
    @pulumi.getter(name="cacheTtlInSeconds")
    def cache_ttl_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
        """
        return pulumi.get(self, "cache_ttl_in_seconds")

    @cache_ttl_in_seconds.setter
    def cache_ttl_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cache_ttl_in_seconds", value)

    @property
    @pulumi.getter(name="cachingEnabled")
    def caching_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
        """
        return pulumi.get(self, "caching_enabled")

    @caching_enabled.setter
    def caching_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "caching_enabled", value)

    @property
    @pulumi.getter(name="dataTraceEnabled")
    def data_trace_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs. This can be useful to troubleshoot APIs, but can result in logging sensitive data. We recommend that you don't enable this option for production APIs.
        """
        return pulumi.get(self, "data_trace_enabled")

    @data_trace_enabled.setter
    def data_trace_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "data_trace_enabled", value)

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The HTTP method.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_method", value)

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. Valid values are `OFF` , `ERROR` , and `INFO` . Choose `ERROR` to write only error-level entries to CloudWatch Logs, or choose `INFO` to include all `ERROR` events as well as extra informational events.
        """
        return pulumi.get(self, "logging_level")

    @logging_level.setter
    def logging_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logging_level", value)

    @property
    @pulumi.getter(name="metricsEnabled")
    def metrics_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether Amazon CloudWatch metrics are enabled for this method.
        """
        return pulumi.get(self, "metrics_enabled")

    @metrics_enabled.setter
    def metrics_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "metrics_enabled", value)

    @property
    @pulumi.getter(name="resourcePath")
    def resource_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource path for this method. Forward slashes (``/``) are encoded as ``~1`` and the initial slash must include a forward slash. For example, the path value ``/resource/subresource`` must be encoded as ``/~1resource~1subresource``. To specify the root path, use only a slash (``/``).
        """
        return pulumi.get(self, "resource_path")

    @resource_path.setter
    def resource_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_path", value)

    @property
    @pulumi.getter(name="throttlingBurstLimit")
    def throttling_burst_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the throttling burst limit.
        """
        return pulumi.get(self, "throttling_burst_limit")

    @throttling_burst_limit.setter
    def throttling_burst_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "throttling_burst_limit", value)

    @property
    @pulumi.getter(name="throttlingRateLimit")
    def throttling_rate_limit(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Specifies the throttling rate limit.
        """
        return pulumi.get(self, "throttling_rate_limit")

    @throttling_rate_limit.setter
    def throttling_rate_limit(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "throttling_rate_limit", value)


if not MYPY:
    class DeploymentStageDescriptionArgsDict(TypedDict):
        """
        ``StageDescription`` is a property of the [AWS::ApiGateway::Deployment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html) resource that configures a deployment stage.
        """
        access_log_setting: NotRequired[pulumi.Input['DeploymentAccessLogSettingArgsDict']]
        """
        Specifies settings for logging access in this stage.
        """
        cache_cluster_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether a cache cluster is enabled for the stage. To activate a method-level cache, set `CachingEnabled` to `true` for a method.
        """
        cache_cluster_size: NotRequired[pulumi.Input[builtins.str]]
        """
        The size of the stage's cache cluster. For more information, see [cacheClusterSize](https://docs.aws.amazon.com/apigateway/latest/api/API_CreateStage.html#apigw-CreateStage-request-cacheClusterSize) in the *API Gateway API Reference*.
        """
        cache_data_encrypted: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether the cached responses are encrypted.
        """
        cache_ttl_in_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches responses.
        """
        caching_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether responses are cached and returned for requests. You must enable a cache cluster on the stage to cache responses. For more information, see [Enable API Gateway Caching in a Stage to Enhance API Performance](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html) in the *API Gateway Developer Guide*.
        """
        canary_setting: NotRequired[pulumi.Input['DeploymentCanarySettingArgsDict']]
        """
        Specifies settings for the canary deployment in this stage.
        """
        client_certificate_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The identifier of the client certificate that API Gateway uses to call your integration endpoints in the stage.
        """
        data_trace_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether data trace logging is enabled for methods in the stage. API Gateway pushes these logs to Amazon CloudWatch Logs.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        A description of the purpose of the stage.
        """
        documentation_version: NotRequired[pulumi.Input[builtins.str]]
        """
        The version identifier of the API documentation snapshot.
        """
        logging_level: NotRequired[pulumi.Input[builtins.str]]
        """
        The logging level for this method. For valid values, see the ``loggingLevel`` property of the [MethodSetting](https://docs.aws.amazon.com/apigateway/latest/api/API_MethodSetting.html) resource in the *Amazon API Gateway API Reference*.
        """
        method_settings: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeploymentMethodSettingArgsDict']]]]
        """
        Configures settings for all of the stage's methods.
        """
        metrics_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether Amazon CloudWatch metrics are enabled for methods in the stage.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeploymentTagArgsDict']]]]
        """
        An array of arbitrary tags (key-value pairs) to associate with the stage.
        """
        throttling_burst_limit: NotRequired[pulumi.Input[builtins.int]]
        """
        The target request burst rate limit. This allows more requests through for a period of time than the target rate limit. For more information, see [Manage API Request Throttling](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html) in the *API Gateway Developer Guide*.
        """
        throttling_rate_limit: NotRequired[pulumi.Input[builtins.float]]
        """
        The target request steady-state rate limit. For more information, see [Manage API Request Throttling](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html) in the *API Gateway Developer Guide*.
        """
        tracing_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether active tracing with X-ray is enabled for this stage.
         For more information, see [Trace API Gateway API Execution with X-Ray](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-xray.html) in the *API Gateway Developer Guide*.
        """
        variables: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        A map that defines the stage variables. Variable names must consist of alphanumeric characters, and the values must match the following regular expression: ``[A-Za-z0-9-._~:/?#&=,]+``.
        """
elif False:
    DeploymentStageDescriptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentStageDescriptionArgs:
    def __init__(__self__, *,
                 access_log_setting: Optional[pulumi.Input['DeploymentAccessLogSettingArgs']] = None,
                 cache_cluster_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cache_cluster_size: Optional[pulumi.Input[builtins.str]] = None,
                 cache_data_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 cache_ttl_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 caching_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 canary_setting: Optional[pulumi.Input['DeploymentCanarySettingArgs']] = None,
                 client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 data_trace_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 documentation_version: Optional[pulumi.Input[builtins.str]] = None,
                 logging_level: Optional[pulumi.Input[builtins.str]] = None,
                 method_settings: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentMethodSettingArgs']]]] = None,
                 metrics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentTagArgs']]]] = None,
                 throttling_burst_limit: Optional[pulumi.Input[builtins.int]] = None,
                 throttling_rate_limit: Optional[pulumi.Input[builtins.float]] = None,
                 tracing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        ``StageDescription`` is a property of the [AWS::ApiGateway::Deployment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html) resource that configures a deployment stage.
        :param pulumi.Input['DeploymentAccessLogSettingArgs'] access_log_setting: Specifies settings for logging access in this stage.
        :param pulumi.Input[builtins.bool] cache_cluster_enabled: Specifies whether a cache cluster is enabled for the stage. To activate a method-level cache, set `CachingEnabled` to `true` for a method.
        :param pulumi.Input[builtins.str] cache_cluster_size: The size of the stage's cache cluster. For more information, see [cacheClusterSize](https://docs.aws.amazon.com/apigateway/latest/api/API_CreateStage.html#apigw-CreateStage-request-cacheClusterSize) in the *API Gateway API Reference*.
        :param pulumi.Input[builtins.bool] cache_data_encrypted: Indicates whether the cached responses are encrypted.
        :param pulumi.Input[builtins.int] cache_ttl_in_seconds: The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches responses.
        :param pulumi.Input[builtins.bool] caching_enabled: Indicates whether responses are cached and returned for requests. You must enable a cache cluster on the stage to cache responses. For more information, see [Enable API Gateway Caching in a Stage to Enhance API Performance](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html) in the *API Gateway Developer Guide*.
        :param pulumi.Input['DeploymentCanarySettingArgs'] canary_setting: Specifies settings for the canary deployment in this stage.
        :param pulumi.Input[builtins.str] client_certificate_id: The identifier of the client certificate that API Gateway uses to call your integration endpoints in the stage.
        :param pulumi.Input[builtins.bool] data_trace_enabled: Indicates whether data trace logging is enabled for methods in the stage. API Gateway pushes these logs to Amazon CloudWatch Logs.
        :param pulumi.Input[builtins.str] description: A description of the purpose of the stage.
        :param pulumi.Input[builtins.str] documentation_version: The version identifier of the API documentation snapshot.
        :param pulumi.Input[builtins.str] logging_level: The logging level for this method. For valid values, see the ``loggingLevel`` property of the [MethodSetting](https://docs.aws.amazon.com/apigateway/latest/api/API_MethodSetting.html) resource in the *Amazon API Gateway API Reference*.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentMethodSettingArgs']]] method_settings: Configures settings for all of the stage's methods.
        :param pulumi.Input[builtins.bool] metrics_enabled: Indicates whether Amazon CloudWatch metrics are enabled for methods in the stage.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentTagArgs']]] tags: An array of arbitrary tags (key-value pairs) to associate with the stage.
        :param pulumi.Input[builtins.int] throttling_burst_limit: The target request burst rate limit. This allows more requests through for a period of time than the target rate limit. For more information, see [Manage API Request Throttling](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html) in the *API Gateway Developer Guide*.
        :param pulumi.Input[builtins.float] throttling_rate_limit: The target request steady-state rate limit. For more information, see [Manage API Request Throttling](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html) in the *API Gateway Developer Guide*.
        :param pulumi.Input[builtins.bool] tracing_enabled: Specifies whether active tracing with X-ray is enabled for this stage.
                For more information, see [Trace API Gateway API Execution with X-Ray](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-xray.html) in the *API Gateway Developer Guide*.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] variables: A map that defines the stage variables. Variable names must consist of alphanumeric characters, and the values must match the following regular expression: ``[A-Za-z0-9-._~:/?#&=,]+``.
        """
        if access_log_setting is not None:
            pulumi.set(__self__, "access_log_setting", access_log_setting)
        if cache_cluster_enabled is not None:
            pulumi.set(__self__, "cache_cluster_enabled", cache_cluster_enabled)
        if cache_cluster_size is not None:
            pulumi.set(__self__, "cache_cluster_size", cache_cluster_size)
        if cache_data_encrypted is not None:
            pulumi.set(__self__, "cache_data_encrypted", cache_data_encrypted)
        if cache_ttl_in_seconds is not None:
            pulumi.set(__self__, "cache_ttl_in_seconds", cache_ttl_in_seconds)
        if caching_enabled is not None:
            pulumi.set(__self__, "caching_enabled", caching_enabled)
        if canary_setting is not None:
            pulumi.set(__self__, "canary_setting", canary_setting)
        if client_certificate_id is not None:
            pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if data_trace_enabled is not None:
            pulumi.set(__self__, "data_trace_enabled", data_trace_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if documentation_version is not None:
            pulumi.set(__self__, "documentation_version", documentation_version)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if method_settings is not None:
            pulumi.set(__self__, "method_settings", method_settings)
        if metrics_enabled is not None:
            pulumi.set(__self__, "metrics_enabled", metrics_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if throttling_burst_limit is not None:
            pulumi.set(__self__, "throttling_burst_limit", throttling_burst_limit)
        if throttling_rate_limit is not None:
            pulumi.set(__self__, "throttling_rate_limit", throttling_rate_limit)
        if tracing_enabled is not None:
            pulumi.set(__self__, "tracing_enabled", tracing_enabled)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="accessLogSetting")
    def access_log_setting(self) -> Optional[pulumi.Input['DeploymentAccessLogSettingArgs']]:
        """
        Specifies settings for logging access in this stage.
        """
        return pulumi.get(self, "access_log_setting")

    @access_log_setting.setter
    def access_log_setting(self, value: Optional[pulumi.Input['DeploymentAccessLogSettingArgs']]):
        pulumi.set(self, "access_log_setting", value)

    @property
    @pulumi.getter(name="cacheClusterEnabled")
    def cache_cluster_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether a cache cluster is enabled for the stage. To activate a method-level cache, set `CachingEnabled` to `true` for a method.
        """
        return pulumi.get(self, "cache_cluster_enabled")

    @cache_cluster_enabled.setter
    def cache_cluster_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cache_cluster_enabled", value)

    @property
    @pulumi.getter(name="cacheClusterSize")
    def cache_cluster_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The size of the stage's cache cluster. For more information, see [cacheClusterSize](https://docs.aws.amazon.com/apigateway/latest/api/API_CreateStage.html#apigw-CreateStage-request-cacheClusterSize) in the *API Gateway API Reference*.
        """
        return pulumi.get(self, "cache_cluster_size")

    @cache_cluster_size.setter
    def cache_cluster_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_cluster_size", value)

    @property
    @pulumi.getter(name="cacheDataEncrypted")
    def cache_data_encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the cached responses are encrypted.
        """
        return pulumi.get(self, "cache_data_encrypted")

    @cache_data_encrypted.setter
    def cache_data_encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cache_data_encrypted", value)

    @property
    @pulumi.getter(name="cacheTtlInSeconds")
    def cache_ttl_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches responses.
        """
        return pulumi.get(self, "cache_ttl_in_seconds")

    @cache_ttl_in_seconds.setter
    def cache_ttl_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cache_ttl_in_seconds", value)

    @property
    @pulumi.getter(name="cachingEnabled")
    def caching_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether responses are cached and returned for requests. You must enable a cache cluster on the stage to cache responses. For more information, see [Enable API Gateway Caching in a Stage to Enhance API Performance](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html) in the *API Gateway Developer Guide*.
        """
        return pulumi.get(self, "caching_enabled")

    @caching_enabled.setter
    def caching_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "caching_enabled", value)

    @property
    @pulumi.getter(name="canarySetting")
    def canary_setting(self) -> Optional[pulumi.Input['DeploymentCanarySettingArgs']]:
        """
        Specifies settings for the canary deployment in this stage.
        """
        return pulumi.get(self, "canary_setting")

    @canary_setting.setter
    def canary_setting(self, value: Optional[pulumi.Input['DeploymentCanarySettingArgs']]):
        pulumi.set(self, "canary_setting", value)

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the client certificate that API Gateway uses to call your integration endpoints in the stage.
        """
        return pulumi.get(self, "client_certificate_id")

    @client_certificate_id.setter
    def client_certificate_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_id", value)

    @property
    @pulumi.getter(name="dataTraceEnabled")
    def data_trace_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether data trace logging is enabled for methods in the stage. API Gateway pushes these logs to Amazon CloudWatch Logs.
        """
        return pulumi.get(self, "data_trace_enabled")

    @data_trace_enabled.setter
    def data_trace_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "data_trace_enabled", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the purpose of the stage.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="documentationVersion")
    def documentation_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version identifier of the API documentation snapshot.
        """
        return pulumi.get(self, "documentation_version")

    @documentation_version.setter
    def documentation_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "documentation_version", value)

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The logging level for this method. For valid values, see the ``loggingLevel`` property of the [MethodSetting](https://docs.aws.amazon.com/apigateway/latest/api/API_MethodSetting.html) resource in the *Amazon API Gateway API Reference*.
        """
        return pulumi.get(self, "logging_level")

    @logging_level.setter
    def logging_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logging_level", value)

    @property
    @pulumi.getter(name="methodSettings")
    def method_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentMethodSettingArgs']]]]:
        """
        Configures settings for all of the stage's methods.
        """
        return pulumi.get(self, "method_settings")

    @method_settings.setter
    def method_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentMethodSettingArgs']]]]):
        pulumi.set(self, "method_settings", value)

    @property
    @pulumi.getter(name="metricsEnabled")
    def metrics_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether Amazon CloudWatch metrics are enabled for methods in the stage.
        """
        return pulumi.get(self, "metrics_enabled")

    @metrics_enabled.setter
    def metrics_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "metrics_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentTagArgs']]]]:
        """
        An array of arbitrary tags (key-value pairs) to associate with the stage.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="throttlingBurstLimit")
    def throttling_burst_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The target request burst rate limit. This allows more requests through for a period of time than the target rate limit. For more information, see [Manage API Request Throttling](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html) in the *API Gateway Developer Guide*.
        """
        return pulumi.get(self, "throttling_burst_limit")

    @throttling_burst_limit.setter
    def throttling_burst_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "throttling_burst_limit", value)

    @property
    @pulumi.getter(name="throttlingRateLimit")
    def throttling_rate_limit(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The target request steady-state rate limit. For more information, see [Manage API Request Throttling](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html) in the *API Gateway Developer Guide*.
        """
        return pulumi.get(self, "throttling_rate_limit")

    @throttling_rate_limit.setter
    def throttling_rate_limit(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "throttling_rate_limit", value)

    @property
    @pulumi.getter(name="tracingEnabled")
    def tracing_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether active tracing with X-ray is enabled for this stage.
         For more information, see [Trace API Gateway API Execution with X-Ray](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-xray.html) in the *API Gateway Developer Guide*.
        """
        return pulumi.get(self, "tracing_enabled")

    @tracing_enabled.setter
    def tracing_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tracing_enabled", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map that defines the stage variables. Variable names must consist of alphanumeric characters, and the values must match the following regular expression: ``[A-Za-z0-9-._~:/?#&=,]+``.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "variables", value)


if not MYPY:
    class DeploymentTagArgsDict(TypedDict):
        key: pulumi.Input[builtins.str]
        """
        The key name of the tag
        """
        value: pulumi.Input[builtins.str]
        """
        The value for the tag
        """
elif False:
    DeploymentTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] key: The key name of the tag
        :param pulumi.Input[builtins.str] value: The value for the tag
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The key name of the tag
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The value for the tag
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class DocumentationPartLocationArgsDict(TypedDict):
        """
        The ``Location`` property specifies the location of the Amazon API Gateway API entity that the documentation applies to. ``Location`` is a property of the [AWS::ApiGateway::DocumentationPart](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html) resource.
         For more information about each property, including constraints and valid values, see [DocumentationPart](https://docs.aws.amazon.com/apigateway/latest/api/API_DocumentationPartLocation.html) in the *Amazon API Gateway REST API Reference*.
        """
        method: NotRequired[pulumi.Input[builtins.str]]
        """
        The HTTP verb of a method. It is a valid field for the API entity types of `METHOD` , `PATH_PARAMETER` , `QUERY_PARAMETER` , `REQUEST_HEADER` , `REQUEST_BODY` , `RESPONSE` , `RESPONSE_HEADER` , and `RESPONSE_BODY` . The default value is `*` for any method. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other `location` attributes, the child entity's `method` attribute must match that of the parent entity exactly.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the targeted API entity. It is a valid and required field for the API entity types of `AUTHORIZER` , `MODEL` , `PATH_PARAMETER` , `QUERY_PARAMETER` , `REQUEST_HEADER` , `REQUEST_BODY` and `RESPONSE_HEADER` . It is an invalid field for any other entity type.
        """
        path: NotRequired[pulumi.Input[builtins.str]]
        """
        The URL path of the target. It is a valid field for the API entity types of `RESOURCE` , `METHOD` , `PATH_PARAMETER` , `QUERY_PARAMETER` , `REQUEST_HEADER` , `REQUEST_BODY` , `RESPONSE` , `RESPONSE_HEADER` , and `RESPONSE_BODY` . The default value is `/` for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other `location` attributes, the child entity's `path` attribute must match that of the parent entity as a prefix.
        """
        status_code: NotRequired[pulumi.Input[builtins.str]]
        """
        The HTTP status code of a response. It is a valid field for the API entity types of `RESPONSE` , `RESPONSE_HEADER` , and `RESPONSE_BODY` . The default value is `*` for any status code. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other `location` attributes, the child entity's `statusCode` attribute must match that of the parent entity exactly.
        """
        type: NotRequired[pulumi.Input['DocumentationPartLocationType']]
        """
        The type of API entity to which the documentation content applies. Valid values are `API` , `AUTHORIZER` , `MODEL` , `RESOURCE` , `METHOD` , `PATH_PARAMETER` , `QUERY_PARAMETER` , `REQUEST_HEADER` , `REQUEST_BODY` , `RESPONSE` , `RESPONSE_HEADER` , and `RESPONSE_BODY` . Content inheritance does not apply to any entity of the `API` , `AUTHORIZER` , `METHOD` , `MODEL` , `REQUEST_BODY` , or `RESOURCE` type.
        """
elif False:
    DocumentationPartLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DocumentationPartLocationArgs:
    def __init__(__self__, *,
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 status_code: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input['DocumentationPartLocationType']] = None):
        """
        The ``Location`` property specifies the location of the Amazon API Gateway API entity that the documentation applies to. ``Location`` is a property of the [AWS::ApiGateway::DocumentationPart](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html) resource.
         For more information about each property, including constraints and valid values, see [DocumentationPart](https://docs.aws.amazon.com/apigateway/latest/api/API_DocumentationPartLocation.html) in the *Amazon API Gateway REST API Reference*.
        :param pulumi.Input[builtins.str] method: The HTTP verb of a method. It is a valid field for the API entity types of `METHOD` , `PATH_PARAMETER` , `QUERY_PARAMETER` , `REQUEST_HEADER` , `REQUEST_BODY` , `RESPONSE` , `RESPONSE_HEADER` , and `RESPONSE_BODY` . The default value is `*` for any method. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other `location` attributes, the child entity's `method` attribute must match that of the parent entity exactly.
        :param pulumi.Input[builtins.str] name: The name of the targeted API entity. It is a valid and required field for the API entity types of `AUTHORIZER` , `MODEL` , `PATH_PARAMETER` , `QUERY_PARAMETER` , `REQUEST_HEADER` , `REQUEST_BODY` and `RESPONSE_HEADER` . It is an invalid field for any other entity type.
        :param pulumi.Input[builtins.str] path: The URL path of the target. It is a valid field for the API entity types of `RESOURCE` , `METHOD` , `PATH_PARAMETER` , `QUERY_PARAMETER` , `REQUEST_HEADER` , `REQUEST_BODY` , `RESPONSE` , `RESPONSE_HEADER` , and `RESPONSE_BODY` . The default value is `/` for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other `location` attributes, the child entity's `path` attribute must match that of the parent entity as a prefix.
        :param pulumi.Input[builtins.str] status_code: The HTTP status code of a response. It is a valid field for the API entity types of `RESPONSE` , `RESPONSE_HEADER` , and `RESPONSE_BODY` . The default value is `*` for any status code. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other `location` attributes, the child entity's `statusCode` attribute must match that of the parent entity exactly.
        :param pulumi.Input['DocumentationPartLocationType'] type: The type of API entity to which the documentation content applies. Valid values are `API` , `AUTHORIZER` , `MODEL` , `RESOURCE` , `METHOD` , `PATH_PARAMETER` , `QUERY_PARAMETER` , `REQUEST_HEADER` , `REQUEST_BODY` , `RESPONSE` , `RESPONSE_HEADER` , and `RESPONSE_BODY` . Content inheritance does not apply to any entity of the `API` , `AUTHORIZER` , `METHOD` , `MODEL` , `REQUEST_BODY` , or `RESOURCE` type.
        """
        if method is not None:
            pulumi.set(__self__, "method", method)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The HTTP verb of a method. It is a valid field for the API entity types of `METHOD` , `PATH_PARAMETER` , `QUERY_PARAMETER` , `REQUEST_HEADER` , `REQUEST_BODY` , `RESPONSE` , `RESPONSE_HEADER` , and `RESPONSE_BODY` . The default value is `*` for any method. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other `location` attributes, the child entity's `method` attribute must match that of the parent entity exactly.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the targeted API entity. It is a valid and required field for the API entity types of `AUTHORIZER` , `MODEL` , `PATH_PARAMETER` , `QUERY_PARAMETER` , `REQUEST_HEADER` , `REQUEST_BODY` and `RESPONSE_HEADER` . It is an invalid field for any other entity type.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL path of the target. It is a valid field for the API entity types of `RESOURCE` , `METHOD` , `PATH_PARAMETER` , `QUERY_PARAMETER` , `REQUEST_HEADER` , `REQUEST_BODY` , `RESPONSE` , `RESPONSE_HEADER` , and `RESPONSE_BODY` . The default value is `/` for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other `location` attributes, the child entity's `path` attribute must match that of the parent entity as a prefix.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The HTTP status code of a response. It is a valid field for the API entity types of `RESPONSE` , `RESPONSE_HEADER` , and `RESPONSE_BODY` . The default value is `*` for any status code. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other `location` attributes, the child entity's `statusCode` attribute must match that of the parent entity exactly.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['DocumentationPartLocationType']]:
        """
        The type of API entity to which the documentation content applies. Valid values are `API` , `AUTHORIZER` , `MODEL` , `RESOURCE` , `METHOD` , `PATH_PARAMETER` , `QUERY_PARAMETER` , `REQUEST_HEADER` , `REQUEST_BODY` , `RESPONSE` , `RESPONSE_HEADER` , and `RESPONSE_BODY` . Content inheritance does not apply to any entity of the `API` , `AUTHORIZER` , `METHOD` , `MODEL` , `REQUEST_BODY` , or `RESOURCE` type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['DocumentationPartLocationType']]):
        pulumi.set(self, "type", value)


if not MYPY:
    class DomainNameEndpointConfigurationArgsDict(TypedDict):
        """
        The ``EndpointConfiguration`` property type specifies the endpoint types of an Amazon API Gateway domain name.
         ``EndpointConfiguration`` is a property of the [AWS::ApiGateway::DomainName](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html) resource.
        """
        ip_address_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP address types that can invoke this DomainName. Use `ipv4` to allow only IPv4 addresses to invoke this DomainName, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke this DomainName. For the `PRIVATE` endpoint type, only `dualstack` is supported.
        """
        types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is `"EDGE"` . For a regional API and its custom domain name, the endpoint type is `REGIONAL` . For a private API, the endpoint type is `PRIVATE` .
        """
elif False:
    DomainNameEndpointConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainNameEndpointConfigurationArgs:
    def __init__(__self__, *,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The ``EndpointConfiguration`` property type specifies the endpoint types of an Amazon API Gateway domain name.
         ``EndpointConfiguration`` is a property of the [AWS::ApiGateway::DomainName](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html) resource.
        :param pulumi.Input[builtins.str] ip_address_type: The IP address types that can invoke this DomainName. Use `ipv4` to allow only IPv4 addresses to invoke this DomainName, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke this DomainName. For the `PRIVATE` endpoint type, only `dualstack` is supported.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] types: A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is `"EDGE"` . For a regional API and its custom domain name, the endpoint type is `REGIONAL` . For a private API, the endpoint type is `PRIVATE` .
        """
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address types that can invoke this DomainName. Use `ipv4` to allow only IPv4 addresses to invoke this DomainName, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke this DomainName. For the `PRIVATE` endpoint type, only `dualstack` is supported.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is `"EDGE"` . For a regional API and its custom domain name, the endpoint type is `REGIONAL` . For a private API, the endpoint type is `PRIVATE` .
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "types", value)


if not MYPY:
    class DomainNameMutualTlsAuthenticationArgsDict(TypedDict):
        truststore_uri: NotRequired[pulumi.Input[builtins.str]]
        """
        An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example `s3://bucket-name/key-name` . The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.
        """
        truststore_version: NotRequired[pulumi.Input[builtins.str]]
        """
        The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
elif False:
    DomainNameMutualTlsAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainNameMutualTlsAuthenticationArgs:
    def __init__(__self__, *,
                 truststore_uri: Optional[pulumi.Input[builtins.str]] = None,
                 truststore_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] truststore_uri: An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example `s3://bucket-name/key-name` . The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.
        :param pulumi.Input[builtins.str] truststore_version: The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
        if truststore_uri is not None:
            pulumi.set(__self__, "truststore_uri", truststore_uri)
        if truststore_version is not None:
            pulumi.set(__self__, "truststore_version", truststore_version)

    @property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example `s3://bucket-name/key-name` . The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.
        """
        return pulumi.get(self, "truststore_uri")

    @truststore_uri.setter
    def truststore_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "truststore_uri", value)

    @property
    @pulumi.getter(name="truststoreVersion")
    def truststore_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
        return pulumi.get(self, "truststore_version")

    @truststore_version.setter
    def truststore_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "truststore_version", value)


if not MYPY:
    class DomainNameV2EndpointConfigurationArgsDict(TypedDict):
        ip_address_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP address types that can invoke an API (RestApi) or a DomainName. Use `ipv4` to allow only IPv4 addresses to invoke an API or DomainName, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke an API or a DomainName. For the `PRIVATE` endpoint type, only `dualstack` is supported.
        """
        types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is `"EDGE"` . For a regional API and its custom domain name, the endpoint type is `REGIONAL` . For a private API, the endpoint type is `PRIVATE` .
        """
elif False:
    DomainNameV2EndpointConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainNameV2EndpointConfigurationArgs:
    def __init__(__self__, *,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] ip_address_type: The IP address types that can invoke an API (RestApi) or a DomainName. Use `ipv4` to allow only IPv4 addresses to invoke an API or DomainName, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke an API or a DomainName. For the `PRIVATE` endpoint type, only `dualstack` is supported.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] types: A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is `"EDGE"` . For a regional API and its custom domain name, the endpoint type is `REGIONAL` . For a private API, the endpoint type is `PRIVATE` .
        """
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address types that can invoke an API (RestApi) or a DomainName. Use `ipv4` to allow only IPv4 addresses to invoke an API or DomainName, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke an API or a DomainName. For the `PRIVATE` endpoint type, only `dualstack` is supported.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is `"EDGE"` . For a regional API and its custom domain name, the endpoint type is `REGIONAL` . For a private API, the endpoint type is `PRIVATE` .
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "types", value)


if not MYPY:
    class MethodIntegrationResponseArgsDict(TypedDict):
        """
        ``IntegrationResponse`` is a property of the [Amazon API Gateway Method Integration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html) property type that specifies the response that API Gateway sends after a method's backend finishes processing a request.
        """
        status_code: pulumi.Input[builtins.str]
        """
        Specifies the status code that is used to map the integration response to an existing MethodResponse.
        """
        content_handling: NotRequired[pulumi.Input['MethodIntegrationResponseContentHandling']]
        """
        Specifies how to handle response payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT` , with the following behaviors:

        If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
        """
        response_parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of `method.response.header.{name}` , where `name` is a valid and unique header name. The mapped non-static value must match the pattern of `integration.response.header.{name}` or `integration.response.body.{JSON-expression}` , where `name` is a valid and unique response header name and `JSON-expression` is a valid JSON expression without the `$` prefix.
        """
        response_templates: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
        """
        selection_pattern: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the `.+` regex to match error response. However, make sure that the error response does not contain any newline ( `\\n` ) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.
        """
elif False:
    MethodIntegrationResponseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MethodIntegrationResponseArgs:
    def __init__(__self__, *,
                 status_code: pulumi.Input[builtins.str],
                 content_handling: Optional[pulumi.Input['MethodIntegrationResponseContentHandling']] = None,
                 response_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 response_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 selection_pattern: Optional[pulumi.Input[builtins.str]] = None):
        """
        ``IntegrationResponse`` is a property of the [Amazon API Gateway Method Integration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html) property type that specifies the response that API Gateway sends after a method's backend finishes processing a request.
        :param pulumi.Input[builtins.str] status_code: Specifies the status code that is used to map the integration response to an existing MethodResponse.
        :param pulumi.Input['MethodIntegrationResponseContentHandling'] content_handling: Specifies how to handle response payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT` , with the following behaviors:
               
               If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] response_parameters: A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of `method.response.header.{name}` , where `name` is a valid and unique header name. The mapped non-static value must match the pattern of `integration.response.header.{name}` or `integration.response.body.{JSON-expression}` , where `name` is a valid and unique response header name and `JSON-expression` is a valid JSON expression without the `$` prefix.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] response_templates: Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
        :param pulumi.Input[builtins.str] selection_pattern: Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the `.+` regex to match error response. However, make sure that the error response does not contain any newline ( `\\n` ) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.
        """
        pulumi.set(__self__, "status_code", status_code)
        if content_handling is not None:
            pulumi.set(__self__, "content_handling", content_handling)
        if response_parameters is not None:
            pulumi.set(__self__, "response_parameters", response_parameters)
        if response_templates is not None:
            pulumi.set(__self__, "response_templates", response_templates)
        if selection_pattern is not None:
            pulumi.set(__self__, "selection_pattern", selection_pattern)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the status code that is used to map the integration response to an existing MethodResponse.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter(name="contentHandling")
    def content_handling(self) -> Optional[pulumi.Input['MethodIntegrationResponseContentHandling']]:
        """
        Specifies how to handle response payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT` , with the following behaviors:

        If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
        """
        return pulumi.get(self, "content_handling")

    @content_handling.setter
    def content_handling(self, value: Optional[pulumi.Input['MethodIntegrationResponseContentHandling']]):
        pulumi.set(self, "content_handling", value)

    @property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of `method.response.header.{name}` , where `name` is a valid and unique header name. The mapped non-static value must match the pattern of `integration.response.header.{name}` or `integration.response.body.{JSON-expression}` , where `name` is a valid and unique response header name and `JSON-expression` is a valid JSON expression without the `$` prefix.
        """
        return pulumi.get(self, "response_parameters")

    @response_parameters.setter
    def response_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "response_parameters", value)

    @property
    @pulumi.getter(name="responseTemplates")
    def response_templates(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
        """
        return pulumi.get(self, "response_templates")

    @response_templates.setter
    def response_templates(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "response_templates", value)

    @property
    @pulumi.getter(name="selectionPattern")
    def selection_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the `.+` regex to match error response. However, make sure that the error response does not contain any newline ( `\\n` ) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.
        """
        return pulumi.get(self, "selection_pattern")

    @selection_pattern.setter
    def selection_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "selection_pattern", value)


if not MYPY:
    class MethodIntegrationArgsDict(TypedDict):
        """
        ``Integration`` is a property of the [AWS::ApiGateway::Method](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html) resource that specifies information about the target backend that a method calls.
        """
        type: pulumi.Input['MethodIntegrationType']
        """
        Specifies an API method integration type. The valid value is one of the following:

        For the HTTP and HTTP proxy integrations, each integration can specify a protocol ( `http/https` ), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a `connectionType` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
        """
        cache_key_parameters: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of request parameters whose values API Gateway caches. To be valid values for `cacheKeyParameters` , these parameters must also be specified for Method `requestParameters` .
        """
        cache_namespace: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the `cacheNamespace` . You can specify the same `cacheNamespace` across resources to return the same cached data for requests to different resources.
        """
        connection_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the VpcLink used for the integration when `connectionType=VPC_LINK` and undefined, otherwise.
        """
        connection_type: NotRequired[pulumi.Input['MethodIntegrationConnectionType']]
        """
        The type of the network connection to the integration endpoint. The valid value is `INTERNET` for connections through the public routable internet or `VPC_LINK` for private connections between API Gateway and a network load balancer in a VPC. The default value is `INTERNET` .
        """
        content_handling: NotRequired[pulumi.Input['MethodIntegrationContentHandling']]
        """
        Specifies how to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT` , with the following behaviors:

        If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the `passthroughBehavior` is configured to support payload pass-through.
        """
        credentials: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string `arn:aws:iam::\\*:user/\\*` . To use resource-based permissions on supported AWS services, specify null.
        """
        integration_http_method: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the integration's HTTP method type. For the Type property, if you specify `MOCK` , this property is optional. For Lambda integrations, you must set the integration method to `POST` . For all other types, you must specify this property.
        """
        integration_responses: NotRequired[pulumi.Input[Sequence[pulumi.Input['MethodIntegrationResponseArgsDict']]]]
        """
        Specifies the integration's responses.
        """
        passthrough_behavior: NotRequired[pulumi.Input['MethodIntegrationPassthroughBehavior']]
        """
        Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in `requestTemplates` . The valid value is one of the following: `WHEN_NO_MATCH` : passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. `WHEN_NO_TEMPLATES` : passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP 415 Unsupported Media Type response. `NEVER` : rejects the method request with an HTTP 415 Unsupported Media Type response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request.
        """
        request_parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of `method.request.{location}.{name}` , where `location` is `querystring` , `path` , or `header` and `name` must be a valid and unique method request parameter name.
        """
        request_templates: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.
        """
        timeout_in_millis: NotRequired[pulumi.Input[builtins.int]]
        """
        Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
        """
        uri: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies Uniform Resource Identifier (URI) of the integration endpoint.

        For `HTTP` or `HTTP_PROXY` integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification for standard integrations. If `connectionType` is `VPC_LINK` specify the Network Load Balancer DNS name. For `AWS` or `AWS_PROXY` integrations, the URI is of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}` . Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and {subdomain} is a designated subdomain supported by certain AWS service for fast host-name lookup. action can be used for an AWS service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an AWS service path-based API. The ensuing service_api refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of GetObject, the uri can be either `arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}` or `arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}`
        """
elif False:
    MethodIntegrationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MethodIntegrationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['MethodIntegrationType'],
                 cache_key_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cache_namespace: Optional[pulumi.Input[builtins.str]] = None,
                 connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_type: Optional[pulumi.Input['MethodIntegrationConnectionType']] = None,
                 content_handling: Optional[pulumi.Input['MethodIntegrationContentHandling']] = None,
                 credentials: Optional[pulumi.Input[builtins.str]] = None,
                 integration_http_method: Optional[pulumi.Input[builtins.str]] = None,
                 integration_responses: Optional[pulumi.Input[Sequence[pulumi.Input['MethodIntegrationResponseArgs']]]] = None,
                 passthrough_behavior: Optional[pulumi.Input['MethodIntegrationPassthroughBehavior']] = None,
                 request_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 request_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout_in_millis: Optional[pulumi.Input[builtins.int]] = None,
                 uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        ``Integration`` is a property of the [AWS::ApiGateway::Method](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html) resource that specifies information about the target backend that a method calls.
        :param pulumi.Input['MethodIntegrationType'] type: Specifies an API method integration type. The valid value is one of the following:
               
               For the HTTP and HTTP proxy integrations, each integration can specify a protocol ( `http/https` ), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a `connectionType` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cache_key_parameters: A list of request parameters whose values API Gateway caches. To be valid values for `cacheKeyParameters` , these parameters must also be specified for Method `requestParameters` .
        :param pulumi.Input[builtins.str] cache_namespace: Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the `cacheNamespace` . You can specify the same `cacheNamespace` across resources to return the same cached data for requests to different resources.
        :param pulumi.Input[builtins.str] connection_id: The ID of the VpcLink used for the integration when `connectionType=VPC_LINK` and undefined, otherwise.
        :param pulumi.Input['MethodIntegrationConnectionType'] connection_type: The type of the network connection to the integration endpoint. The valid value is `INTERNET` for connections through the public routable internet or `VPC_LINK` for private connections between API Gateway and a network load balancer in a VPC. The default value is `INTERNET` .
        :param pulumi.Input['MethodIntegrationContentHandling'] content_handling: Specifies how to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT` , with the following behaviors:
               
               If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the `passthroughBehavior` is configured to support payload pass-through.
        :param pulumi.Input[builtins.str] credentials: Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string `arn:aws:iam::\\*:user/\\*` . To use resource-based permissions on supported AWS services, specify null.
        :param pulumi.Input[builtins.str] integration_http_method: Specifies the integration's HTTP method type. For the Type property, if you specify `MOCK` , this property is optional. For Lambda integrations, you must set the integration method to `POST` . For all other types, you must specify this property.
        :param pulumi.Input[Sequence[pulumi.Input['MethodIntegrationResponseArgs']]] integration_responses: Specifies the integration's responses.
        :param pulumi.Input['MethodIntegrationPassthroughBehavior'] passthrough_behavior: Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in `requestTemplates` . The valid value is one of the following: `WHEN_NO_MATCH` : passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. `WHEN_NO_TEMPLATES` : passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP 415 Unsupported Media Type response. `NEVER` : rejects the method request with an HTTP 415 Unsupported Media Type response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] request_parameters: A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of `method.request.{location}.{name}` , where `location` is `querystring` , `path` , or `header` and `name` must be a valid and unique method request parameter name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] request_templates: Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.
        :param pulumi.Input[builtins.int] timeout_in_millis: Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
        :param pulumi.Input[builtins.str] uri: Specifies Uniform Resource Identifier (URI) of the integration endpoint.
               
               For `HTTP` or `HTTP_PROXY` integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification for standard integrations. If `connectionType` is `VPC_LINK` specify the Network Load Balancer DNS name. For `AWS` or `AWS_PROXY` integrations, the URI is of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}` . Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and {subdomain} is a designated subdomain supported by certain AWS service for fast host-name lookup. action can be used for an AWS service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an AWS service path-based API. The ensuing service_api refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of GetObject, the uri can be either `arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}` or `arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}`
        """
        pulumi.set(__self__, "type", type)
        if cache_key_parameters is not None:
            pulumi.set(__self__, "cache_key_parameters", cache_key_parameters)
        if cache_namespace is not None:
            pulumi.set(__self__, "cache_namespace", cache_namespace)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if content_handling is not None:
            pulumi.set(__self__, "content_handling", content_handling)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if integration_http_method is not None:
            pulumi.set(__self__, "integration_http_method", integration_http_method)
        if integration_responses is not None:
            pulumi.set(__self__, "integration_responses", integration_responses)
        if passthrough_behavior is not None:
            pulumi.set(__self__, "passthrough_behavior", passthrough_behavior)
        if request_parameters is not None:
            pulumi.set(__self__, "request_parameters", request_parameters)
        if request_templates is not None:
            pulumi.set(__self__, "request_templates", request_templates)
        if timeout_in_millis is not None:
            pulumi.set(__self__, "timeout_in_millis", timeout_in_millis)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['MethodIntegrationType']:
        """
        Specifies an API method integration type. The valid value is one of the following:

        For the HTTP and HTTP proxy integrations, each integration can specify a protocol ( `http/https` ), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a `connectionType` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['MethodIntegrationType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="cacheKeyParameters")
    def cache_key_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of request parameters whose values API Gateway caches. To be valid values for `cacheKeyParameters` , these parameters must also be specified for Method `requestParameters` .
        """
        return pulumi.get(self, "cache_key_parameters")

    @cache_key_parameters.setter
    def cache_key_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cache_key_parameters", value)

    @property
    @pulumi.getter(name="cacheNamespace")
    def cache_namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the `cacheNamespace` . You can specify the same `cacheNamespace` across resources to return the same cached data for requests to different resources.
        """
        return pulumi.get(self, "cache_namespace")

    @cache_namespace.setter
    def cache_namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_namespace", value)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the VpcLink used for the integration when `connectionType=VPC_LINK` and undefined, otherwise.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input['MethodIntegrationConnectionType']]:
        """
        The type of the network connection to the integration endpoint. The valid value is `INTERNET` for connections through the public routable internet or `VPC_LINK` for private connections between API Gateway and a network load balancer in a VPC. The default value is `INTERNET` .
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input['MethodIntegrationConnectionType']]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="contentHandling")
    def content_handling(self) -> Optional[pulumi.Input['MethodIntegrationContentHandling']]:
        """
        Specifies how to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT` , with the following behaviors:

        If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the `passthroughBehavior` is configured to support payload pass-through.
        """
        return pulumi.get(self, "content_handling")

    @content_handling.setter
    def content_handling(self, value: Optional[pulumi.Input['MethodIntegrationContentHandling']]):
        pulumi.set(self, "content_handling", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string `arn:aws:iam::\\*:user/\\*` . To use resource-based permissions on supported AWS services, specify null.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="integrationHttpMethod")
    def integration_http_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the integration's HTTP method type. For the Type property, if you specify `MOCK` , this property is optional. For Lambda integrations, you must set the integration method to `POST` . For all other types, you must specify this property.
        """
        return pulumi.get(self, "integration_http_method")

    @integration_http_method.setter
    def integration_http_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_http_method", value)

    @property
    @pulumi.getter(name="integrationResponses")
    def integration_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MethodIntegrationResponseArgs']]]]:
        """
        Specifies the integration's responses.
        """
        return pulumi.get(self, "integration_responses")

    @integration_responses.setter
    def integration_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MethodIntegrationResponseArgs']]]]):
        pulumi.set(self, "integration_responses", value)

    @property
    @pulumi.getter(name="passthroughBehavior")
    def passthrough_behavior(self) -> Optional[pulumi.Input['MethodIntegrationPassthroughBehavior']]:
        """
        Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in `requestTemplates` . The valid value is one of the following: `WHEN_NO_MATCH` : passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. `WHEN_NO_TEMPLATES` : passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP 415 Unsupported Media Type response. `NEVER` : rejects the method request with an HTTP 415 Unsupported Media Type response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request.
        """
        return pulumi.get(self, "passthrough_behavior")

    @passthrough_behavior.setter
    def passthrough_behavior(self, value: Optional[pulumi.Input['MethodIntegrationPassthroughBehavior']]):
        pulumi.set(self, "passthrough_behavior", value)

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of `method.request.{location}.{name}` , where `location` is `querystring` , `path` , or `header` and `name` must be a valid and unique method request parameter name.
        """
        return pulumi.get(self, "request_parameters")

    @request_parameters.setter
    def request_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "request_parameters", value)

    @property
    @pulumi.getter(name="requestTemplates")
    def request_templates(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.
        """
        return pulumi.get(self, "request_templates")

    @request_templates.setter
    def request_templates(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "request_templates", value)

    @property
    @pulumi.getter(name="timeoutInMillis")
    def timeout_in_millis(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
        """
        return pulumi.get(self, "timeout_in_millis")

    @timeout_in_millis.setter
    def timeout_in_millis(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout_in_millis", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies Uniform Resource Identifier (URI) of the integration endpoint.

        For `HTTP` or `HTTP_PROXY` integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification for standard integrations. If `connectionType` is `VPC_LINK` specify the Network Load Balancer DNS name. For `AWS` or `AWS_PROXY` integrations, the URI is of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}` . Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and {subdomain} is a designated subdomain supported by certain AWS service for fast host-name lookup. action can be used for an AWS service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an AWS service path-based API. The ensuing service_api refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of GetObject, the uri can be either `arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}` or `arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}`
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uri", value)


if not MYPY:
    class MethodResponseArgsDict(TypedDict):
        status_code: pulumi.Input[builtins.str]
        """
        The method response's status code.
        """
        response_models: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Specifies the Model resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a Model name as the value.
        """
        response_parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[Union[builtins.bool, builtins.str]]]]]
        """
        A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern `method.response.header.{name}` , where `name` is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's IntegrationResponse. The integration response data that can be mapped include an integration response header expressed in `integration.response.header.{name}` , a static value enclosed within a pair of single quotes (e.g., `'application/json'` ), or a JSON expression from the back-end response payload in the form of `integration.response.body.{JSON-expression}` , where `JSON-expression` is a valid JSON expression without the `$` prefix.)
        """
elif False:
    MethodResponseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MethodResponseArgs:
    def __init__(__self__, *,
                 status_code: pulumi.Input[builtins.str],
                 response_models: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 response_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[builtins.bool, builtins.str]]]]] = None):
        """
        :param pulumi.Input[builtins.str] status_code: The method response's status code.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] response_models: Specifies the Model resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a Model name as the value.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union[builtins.bool, builtins.str]]]] response_parameters: A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern `method.response.header.{name}` , where `name` is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's IntegrationResponse. The integration response data that can be mapped include an integration response header expressed in `integration.response.header.{name}` , a static value enclosed within a pair of single quotes (e.g., `'application/json'` ), or a JSON expression from the back-end response payload in the form of `integration.response.body.{JSON-expression}` , where `JSON-expression` is a valid JSON expression without the `$` prefix.)
        """
        pulumi.set(__self__, "status_code", status_code)
        if response_models is not None:
            pulumi.set(__self__, "response_models", response_models)
        if response_parameters is not None:
            pulumi.set(__self__, "response_parameters", response_parameters)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[builtins.str]:
        """
        The method response's status code.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter(name="responseModels")
    def response_models(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies the Model resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a Model name as the value.
        """
        return pulumi.get(self, "response_models")

    @response_models.setter
    def response_models(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "response_models", value)

    @property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[builtins.bool, builtins.str]]]]]:
        """
        A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern `method.response.header.{name}` , where `name` is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's IntegrationResponse. The integration response data that can be mapped include an integration response header expressed in `integration.response.header.{name}` , a static value enclosed within a pair of single quotes (e.g., `'application/json'` ), or a JSON expression from the back-end response payload in the form of `integration.response.body.{JSON-expression}` , where `JSON-expression` is a valid JSON expression without the `$` prefix.)
        """
        return pulumi.get(self, "response_parameters")

    @response_parameters.setter
    def response_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[builtins.bool, builtins.str]]]]]):
        pulumi.set(self, "response_parameters", value)


if not MYPY:
    class RestApiEndpointConfigurationArgsDict(TypedDict):
        """
        The ``EndpointConfiguration`` property type specifies the endpoint types of a REST API.
         ``EndpointConfiguration`` is a property of the [AWS::ApiGateway::RestApi](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html) resource.
        """
        ip_address_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP address types that can invoke an API (RestApi). Use `ipv4` to allow only IPv4 addresses to invoke an API, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke an API. For the `PRIVATE` endpoint type, only `dualstack` is supported.
        """
        types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is `"EDGE"` . For a regional API and its custom domain name, the endpoint type is `REGIONAL` . For a private API, the endpoint type is `PRIVATE` .
        """
        vpc_endpoint_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of VpcEndpointIds of an API (RestApi) against which to create Route53 ALIASes. It is only supported for `PRIVATE` endpoint type.
        """
elif False:
    RestApiEndpointConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestApiEndpointConfigurationArgs:
    def __init__(__self__, *,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vpc_endpoint_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The ``EndpointConfiguration`` property type specifies the endpoint types of a REST API.
         ``EndpointConfiguration`` is a property of the [AWS::ApiGateway::RestApi](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html) resource.
        :param pulumi.Input[builtins.str] ip_address_type: The IP address types that can invoke an API (RestApi). Use `ipv4` to allow only IPv4 addresses to invoke an API, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke an API. For the `PRIVATE` endpoint type, only `dualstack` is supported.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] types: A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is `"EDGE"` . For a regional API and its custom domain name, the endpoint type is `REGIONAL` . For a private API, the endpoint type is `PRIVATE` .
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_endpoint_ids: A list of VpcEndpointIds of an API (RestApi) against which to create Route53 ALIASes. It is only supported for `PRIVATE` endpoint type.
        """
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if types is not None:
            pulumi.set(__self__, "types", types)
        if vpc_endpoint_ids is not None:
            pulumi.set(__self__, "vpc_endpoint_ids", vpc_endpoint_ids)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address types that can invoke an API (RestApi). Use `ipv4` to allow only IPv4 addresses to invoke an API, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke an API. For the `PRIVATE` endpoint type, only `dualstack` is supported.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is `"EDGE"` . For a regional API and its custom domain name, the endpoint type is `REGIONAL` . For a private API, the endpoint type is `PRIVATE` .
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "types", value)

    @property
    @pulumi.getter(name="vpcEndpointIds")
    def vpc_endpoint_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of VpcEndpointIds of an API (RestApi) against which to create Route53 ALIASes. It is only supported for `PRIVATE` endpoint type.
        """
        return pulumi.get(self, "vpc_endpoint_ids")

    @vpc_endpoint_ids.setter
    def vpc_endpoint_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vpc_endpoint_ids", value)


if not MYPY:
    class RestApiS3LocationArgsDict(TypedDict):
        """
        ``S3Location`` is a property of the [AWS::ApiGateway::RestApi](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html) resource that specifies the Amazon S3 location of a OpenAPI (formerly Swagger) file that defines a set of RESTful APIs in JSON or YAML.
         On January 1, 2016, the Swagger Specification was donated to the [OpenAPI initiative](https://docs.aws.amazon.com/https://www.openapis.org/), becoming the foundation of the OpenAPI Specification.
        """
        bucket: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the S3 bucket where the OpenAPI file is stored.
        """
        e_tag: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon S3 ETag (a file checksum) of the OpenAPI file. If you don't specify a value, API Gateway skips ETag validation of your OpenAPI file.
        """
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        The file name of the OpenAPI file (Amazon S3 object name).
        """
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        For versioning-enabled buckets, a specific version of the OpenAPI file.
        """
elif False:
    RestApiS3LocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestApiS3LocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 e_tag: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        ``S3Location`` is a property of the [AWS::ApiGateway::RestApi](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html) resource that specifies the Amazon S3 location of a OpenAPI (formerly Swagger) file that defines a set of RESTful APIs in JSON or YAML.
         On January 1, 2016, the Swagger Specification was donated to the [OpenAPI initiative](https://docs.aws.amazon.com/https://www.openapis.org/), becoming the foundation of the OpenAPI Specification.
        :param pulumi.Input[builtins.str] bucket: The name of the S3 bucket where the OpenAPI file is stored.
        :param pulumi.Input[builtins.str] e_tag: The Amazon S3 ETag (a file checksum) of the OpenAPI file. If you don't specify a value, API Gateway skips ETag validation of your OpenAPI file.
        :param pulumi.Input[builtins.str] key: The file name of the OpenAPI file (Amazon S3 object name).
        :param pulumi.Input[builtins.str] version: For versioning-enabled buckets, a specific version of the OpenAPI file.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if e_tag is not None:
            pulumi.set(__self__, "e_tag", e_tag)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the S3 bucket where the OpenAPI file is stored.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon S3 ETag (a file checksum) of the OpenAPI file. If you don't specify a value, API Gateway skips ETag validation of your OpenAPI file.
        """
        return pulumi.get(self, "e_tag")

    @e_tag.setter
    def e_tag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "e_tag", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The file name of the OpenAPI file (Amazon S3 object name).
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For versioning-enabled buckets, a specific version of the OpenAPI file.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class StageAccessLogSettingArgsDict(TypedDict):
        """
        The ``AccessLogSetting`` property type specifies settings for logging access in this stage.
          ``AccessLogSetting`` is a property of the [AWS::ApiGateway::Stage](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html) resource.
        """
        destination_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with ``amazon-apigateway-``. This parameter is required to enable access logging.
        """
        format: NotRequired[pulumi.Input[builtins.str]]
        """
        A single line format of the access logs of data, as specified by selected [$context variables](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference). The format must include at least ``$context.requestId``. This parameter is required to enable access logging.
        """
elif False:
    StageAccessLogSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StageAccessLogSettingArgs:
    def __init__(__self__, *,
                 destination_arn: Optional[pulumi.Input[builtins.str]] = None,
                 format: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ``AccessLogSetting`` property type specifies settings for logging access in this stage.
          ``AccessLogSetting`` is a property of the [AWS::ApiGateway::Stage](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html) resource.
        :param pulumi.Input[builtins.str] destination_arn: The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with ``amazon-apigateway-``. This parameter is required to enable access logging.
        :param pulumi.Input[builtins.str] format: A single line format of the access logs of data, as specified by selected [$context variables](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference). The format must include at least ``$context.requestId``. This parameter is required to enable access logging.
        """
        if destination_arn is not None:
            pulumi.set(__self__, "destination_arn", destination_arn)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with ``amazon-apigateway-``. This parameter is required to enable access logging.
        """
        return pulumi.get(self, "destination_arn")

    @destination_arn.setter
    def destination_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_arn", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A single line format of the access logs of data, as specified by selected [$context variables](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference). The format must include at least ``$context.requestId``. This parameter is required to enable access logging.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "format", value)


if not MYPY:
    class StageCanarySettingArgsDict(TypedDict):
        deployment_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the canary deployment.
        """
        percent_traffic: NotRequired[pulumi.Input[builtins.float]]
        """
        The percent (0-100) of traffic diverted to a canary deployment.
        """
        stage_variable_overrides: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.
        """
        use_stage_cache: NotRequired[pulumi.Input[builtins.bool]]
        """
        A Boolean flag to indicate whether the canary deployment uses the stage cache or not.
        """
elif False:
    StageCanarySettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StageCanarySettingArgs:
    def __init__(__self__, *,
                 deployment_id: Optional[pulumi.Input[builtins.str]] = None,
                 percent_traffic: Optional[pulumi.Input[builtins.float]] = None,
                 stage_variable_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 use_stage_cache: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] deployment_id: The ID of the canary deployment.
        :param pulumi.Input[builtins.float] percent_traffic: The percent (0-100) of traffic diverted to a canary deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] stage_variable_overrides: Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.
        :param pulumi.Input[builtins.bool] use_stage_cache: A Boolean flag to indicate whether the canary deployment uses the stage cache or not.
        """
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if percent_traffic is not None:
            pulumi.set(__self__, "percent_traffic", percent_traffic)
        if stage_variable_overrides is not None:
            pulumi.set(__self__, "stage_variable_overrides", stage_variable_overrides)
        if use_stage_cache is not None:
            pulumi.set(__self__, "use_stage_cache", use_stage_cache)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the canary deployment.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter(name="percentTraffic")
    def percent_traffic(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The percent (0-100) of traffic diverted to a canary deployment.
        """
        return pulumi.get(self, "percent_traffic")

    @percent_traffic.setter
    def percent_traffic(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "percent_traffic", value)

    @property
    @pulumi.getter(name="stageVariableOverrides")
    def stage_variable_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.
        """
        return pulumi.get(self, "stage_variable_overrides")

    @stage_variable_overrides.setter
    def stage_variable_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "stage_variable_overrides", value)

    @property
    @pulumi.getter(name="useStageCache")
    def use_stage_cache(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A Boolean flag to indicate whether the canary deployment uses the stage cache or not.
        """
        return pulumi.get(self, "use_stage_cache")

    @use_stage_cache.setter
    def use_stage_cache(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_stage_cache", value)


if not MYPY:
    class StageMethodSettingArgsDict(TypedDict):
        """
        The ``MethodSetting`` property type configures settings for all methods in a stage.
         The ``MethodSettings`` property of the ``AWS::ApiGateway::Stage`` resource contains a list of ``MethodSetting`` property types.
        """
        cache_data_encrypted: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether the cached responses are encrypted.
        """
        cache_ttl_in_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
        """
        caching_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
        """
        data_trace_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs. This can be useful to troubleshoot APIs, but can result in logging sensitive data. We recommend that you don't enable this option for production APIs.
        """
        http_method: NotRequired[pulumi.Input[builtins.str]]
        """
        The HTTP method. To apply settings to multiple resources and methods, specify an asterisk (``*``) for the ``HttpMethod`` and ``/*`` for the ``ResourcePath``. This parameter is required when you specify a ``MethodSetting``.
        """
        logging_level: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. Valid values are `OFF` , `ERROR` , and `INFO` . Choose `ERROR` to write only error-level entries to CloudWatch Logs, or choose `INFO` to include all `ERROR` events as well as extra informational events.
        """
        metrics_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether Amazon CloudWatch metrics are enabled for this method.
        """
        resource_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource path for this method. Forward slashes (``/``) are encoded as ``~1`` and the initial slash must include a forward slash. For example, the path value ``/resource/subresource`` must be encoded as ``/~1resource~1subresource``. To specify the root path, use only a slash (``/``). To apply settings to multiple resources and methods, specify an asterisk (``*``) for the ``HttpMethod`` and ``/*`` for the ``ResourcePath``. This parameter is required when you specify a ``MethodSetting``.
        """
        throttling_burst_limit: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the throttling burst limit.
        """
        throttling_rate_limit: NotRequired[pulumi.Input[builtins.float]]
        """
        Specifies the throttling rate limit.
        """
elif False:
    StageMethodSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StageMethodSettingArgs:
    def __init__(__self__, *,
                 cache_data_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 cache_ttl_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 caching_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 data_trace_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 http_method: Optional[pulumi.Input[builtins.str]] = None,
                 logging_level: Optional[pulumi.Input[builtins.str]] = None,
                 metrics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_path: Optional[pulumi.Input[builtins.str]] = None,
                 throttling_burst_limit: Optional[pulumi.Input[builtins.int]] = None,
                 throttling_rate_limit: Optional[pulumi.Input[builtins.float]] = None):
        """
        The ``MethodSetting`` property type configures settings for all methods in a stage.
         The ``MethodSettings`` property of the ``AWS::ApiGateway::Stage`` resource contains a list of ``MethodSetting`` property types.
        :param pulumi.Input[builtins.bool] cache_data_encrypted: Specifies whether the cached responses are encrypted.
        :param pulumi.Input[builtins.int] cache_ttl_in_seconds: Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
        :param pulumi.Input[builtins.bool] caching_enabled: Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
        :param pulumi.Input[builtins.bool] data_trace_enabled: Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs. This can be useful to troubleshoot APIs, but can result in logging sensitive data. We recommend that you don't enable this option for production APIs.
        :param pulumi.Input[builtins.str] http_method: The HTTP method. To apply settings to multiple resources and methods, specify an asterisk (``*``) for the ``HttpMethod`` and ``/*`` for the ``ResourcePath``. This parameter is required when you specify a ``MethodSetting``.
        :param pulumi.Input[builtins.str] logging_level: Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. Valid values are `OFF` , `ERROR` , and `INFO` . Choose `ERROR` to write only error-level entries to CloudWatch Logs, or choose `INFO` to include all `ERROR` events as well as extra informational events.
        :param pulumi.Input[builtins.bool] metrics_enabled: Specifies whether Amazon CloudWatch metrics are enabled for this method.
        :param pulumi.Input[builtins.str] resource_path: The resource path for this method. Forward slashes (``/``) are encoded as ``~1`` and the initial slash must include a forward slash. For example, the path value ``/resource/subresource`` must be encoded as ``/~1resource~1subresource``. To specify the root path, use only a slash (``/``). To apply settings to multiple resources and methods, specify an asterisk (``*``) for the ``HttpMethod`` and ``/*`` for the ``ResourcePath``. This parameter is required when you specify a ``MethodSetting``.
        :param pulumi.Input[builtins.int] throttling_burst_limit: Specifies the throttling burst limit.
        :param pulumi.Input[builtins.float] throttling_rate_limit: Specifies the throttling rate limit.
        """
        if cache_data_encrypted is not None:
            pulumi.set(__self__, "cache_data_encrypted", cache_data_encrypted)
        if cache_ttl_in_seconds is not None:
            pulumi.set(__self__, "cache_ttl_in_seconds", cache_ttl_in_seconds)
        if caching_enabled is not None:
            pulumi.set(__self__, "caching_enabled", caching_enabled)
        if data_trace_enabled is not None:
            pulumi.set(__self__, "data_trace_enabled", data_trace_enabled)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if metrics_enabled is not None:
            pulumi.set(__self__, "metrics_enabled", metrics_enabled)
        if resource_path is not None:
            pulumi.set(__self__, "resource_path", resource_path)
        if throttling_burst_limit is not None:
            pulumi.set(__self__, "throttling_burst_limit", throttling_burst_limit)
        if throttling_rate_limit is not None:
            pulumi.set(__self__, "throttling_rate_limit", throttling_rate_limit)

    @property
    @pulumi.getter(name="cacheDataEncrypted")
    def cache_data_encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the cached responses are encrypted.
        """
        return pulumi.get(self, "cache_data_encrypted")

    @cache_data_encrypted.setter
    def cache_data_encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cache_data_encrypted", value)

    @property
    @pulumi.getter(name="cacheTtlInSeconds")
    def cache_ttl_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
        """
        return pulumi.get(self, "cache_ttl_in_seconds")

    @cache_ttl_in_seconds.setter
    def cache_ttl_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cache_ttl_in_seconds", value)

    @property
    @pulumi.getter(name="cachingEnabled")
    def caching_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
        """
        return pulumi.get(self, "caching_enabled")

    @caching_enabled.setter
    def caching_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "caching_enabled", value)

    @property
    @pulumi.getter(name="dataTraceEnabled")
    def data_trace_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs. This can be useful to troubleshoot APIs, but can result in logging sensitive data. We recommend that you don't enable this option for production APIs.
        """
        return pulumi.get(self, "data_trace_enabled")

    @data_trace_enabled.setter
    def data_trace_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "data_trace_enabled", value)

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The HTTP method. To apply settings to multiple resources and methods, specify an asterisk (``*``) for the ``HttpMethod`` and ``/*`` for the ``ResourcePath``. This parameter is required when you specify a ``MethodSetting``.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_method", value)

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. Valid values are `OFF` , `ERROR` , and `INFO` . Choose `ERROR` to write only error-level entries to CloudWatch Logs, or choose `INFO` to include all `ERROR` events as well as extra informational events.
        """
        return pulumi.get(self, "logging_level")

    @logging_level.setter
    def logging_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logging_level", value)

    @property
    @pulumi.getter(name="metricsEnabled")
    def metrics_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether Amazon CloudWatch metrics are enabled for this method.
        """
        return pulumi.get(self, "metrics_enabled")

    @metrics_enabled.setter
    def metrics_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "metrics_enabled", value)

    @property
    @pulumi.getter(name="resourcePath")
    def resource_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource path for this method. Forward slashes (``/``) are encoded as ``~1`` and the initial slash must include a forward slash. For example, the path value ``/resource/subresource`` must be encoded as ``/~1resource~1subresource``. To specify the root path, use only a slash (``/``). To apply settings to multiple resources and methods, specify an asterisk (``*``) for the ``HttpMethod`` and ``/*`` for the ``ResourcePath``. This parameter is required when you specify a ``MethodSetting``.
        """
        return pulumi.get(self, "resource_path")

    @resource_path.setter
    def resource_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_path", value)

    @property
    @pulumi.getter(name="throttlingBurstLimit")
    def throttling_burst_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the throttling burst limit.
        """
        return pulumi.get(self, "throttling_burst_limit")

    @throttling_burst_limit.setter
    def throttling_burst_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "throttling_burst_limit", value)

    @property
    @pulumi.getter(name="throttlingRateLimit")
    def throttling_rate_limit(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Specifies the throttling rate limit.
        """
        return pulumi.get(self, "throttling_rate_limit")

    @throttling_rate_limit.setter
    def throttling_rate_limit(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "throttling_rate_limit", value)


if not MYPY:
    class UsagePlanApiStageArgsDict(TypedDict):
        api_id: NotRequired[pulumi.Input[builtins.str]]
        """
        API Id of the associated API stage in a usage plan.
        """
        stage: NotRequired[pulumi.Input[builtins.str]]
        """
        API stage name of the associated API stage in a usage plan.
        """
        throttle: NotRequired[pulumi.Input[Mapping[str, pulumi.Input['UsagePlanThrottleSettingsArgsDict']]]]
        """
        Map containing method level throttling information for API stage in a usage plan.
        """
elif False:
    UsagePlanApiStageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UsagePlanApiStageArgs:
    def __init__(__self__, *,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 stage: Optional[pulumi.Input[builtins.str]] = None,
                 throttle: Optional[pulumi.Input[Mapping[str, pulumi.Input['UsagePlanThrottleSettingsArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] api_id: API Id of the associated API stage in a usage plan.
        :param pulumi.Input[builtins.str] stage: API stage name of the associated API stage in a usage plan.
        :param pulumi.Input[Mapping[str, pulumi.Input['UsagePlanThrottleSettingsArgs']]] throttle: Map containing method level throttling information for API stage in a usage plan.
        """
        if api_id is not None:
            pulumi.set(__self__, "api_id", api_id)
        if stage is not None:
            pulumi.set(__self__, "stage", stage)
        if throttle is not None:
            pulumi.set(__self__, "throttle", throttle)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        API Id of the associated API stage in a usage plan.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter
    def stage(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        API stage name of the associated API stage in a usage plan.
        """
        return pulumi.get(self, "stage")

    @stage.setter
    def stage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stage", value)

    @property
    @pulumi.getter
    def throttle(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['UsagePlanThrottleSettingsArgs']]]]:
        """
        Map containing method level throttling information for API stage in a usage plan.
        """
        return pulumi.get(self, "throttle")

    @throttle.setter
    def throttle(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['UsagePlanThrottleSettingsArgs']]]]):
        pulumi.set(self, "throttle", value)


if not MYPY:
    class UsagePlanQuotaSettingsArgsDict(TypedDict):
        """
        ``QuotaSettings`` is a property of the [AWS::ApiGateway::UsagePlan](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html) resource that specifies a target for the maximum number of requests users can make to your REST APIs.
         In some cases clients can exceed the targets that you set. Don’t rely on usage plans to control costs. Consider using [](https://docs.aws.amazon.com/cost-management/latest/userguide/budgets-managing-costs.html) to monitor costs and [](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html) to manage API requests.
        """
        limit: NotRequired[pulumi.Input[builtins.int]]
        """
        The target maximum number of requests that can be made in a given time period.
        """
        offset: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of requests subtracted from the given limit in the initial time period.
        """
        period: NotRequired[pulumi.Input[builtins.str]]
        """
        The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
        """
elif False:
    UsagePlanQuotaSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UsagePlanQuotaSettingsArgs:
    def __init__(__self__, *,
                 limit: Optional[pulumi.Input[builtins.int]] = None,
                 offset: Optional[pulumi.Input[builtins.int]] = None,
                 period: Optional[pulumi.Input[builtins.str]] = None):
        """
        ``QuotaSettings`` is a property of the [AWS::ApiGateway::UsagePlan](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html) resource that specifies a target for the maximum number of requests users can make to your REST APIs.
         In some cases clients can exceed the targets that you set. Don’t rely on usage plans to control costs. Consider using [](https://docs.aws.amazon.com/cost-management/latest/userguide/budgets-managing-costs.html) to monitor costs and [](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html) to manage API requests.
        :param pulumi.Input[builtins.int] limit: The target maximum number of requests that can be made in a given time period.
        :param pulumi.Input[builtins.int] offset: The number of requests subtracted from the given limit in the initial time period.
        :param pulumi.Input[builtins.str] period: The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
        """
        if limit is not None:
            pulumi.set(__self__, "limit", limit)
        if offset is not None:
            pulumi.set(__self__, "offset", offset)
        if period is not None:
            pulumi.set(__self__, "period", period)

    @property
    @pulumi.getter
    def limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The target maximum number of requests that can be made in a given time period.
        """
        return pulumi.get(self, "limit")

    @limit.setter
    def limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "limit", value)

    @property
    @pulumi.getter
    def offset(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of requests subtracted from the given limit in the initial time period.
        """
        return pulumi.get(self, "offset")

    @offset.setter
    def offset(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "offset", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "period", value)


if not MYPY:
    class UsagePlanThrottleSettingsArgsDict(TypedDict):
        """
        ``ThrottleSettings`` is a property of the [AWS::ApiGateway::UsagePlan](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html) resource that specifies the overall request rate (average requests per second) and burst capacity when users call your REST APIs.
        """
        burst_limit: NotRequired[pulumi.Input[builtins.int]]
        rate_limit: NotRequired[pulumi.Input[builtins.float]]
elif False:
    UsagePlanThrottleSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UsagePlanThrottleSettingsArgs:
    def __init__(__self__, *,
                 burst_limit: Optional[pulumi.Input[builtins.int]] = None,
                 rate_limit: Optional[pulumi.Input[builtins.float]] = None):
        """
        ``ThrottleSettings`` is a property of the [AWS::ApiGateway::UsagePlan](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html) resource that specifies the overall request rate (average requests per second) and burst capacity when users call your REST APIs.
        """
        if burst_limit is not None:
            pulumi.set(__self__, "burst_limit", burst_limit)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)

    @property
    @pulumi.getter(name="burstLimit")
    def burst_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "burst_limit")

    @burst_limit.setter
    def burst_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "burst_limit", value)

    @property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[pulumi.Input[builtins.float]]:
        return pulumi.get(self, "rate_limit")

    @rate_limit.setter
    def rate_limit(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "rate_limit", value)


