# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetDomainResult',
    'AwaitableGetDomainResult',
    'get_domain',
    'get_domain_output',
]

@pulumi.output_type
class GetDomainResult:
    def __init__(__self__, arn=None, auto_sub_domain_creation_patterns=None, auto_sub_domain_iam_role=None, certificate=None, certificate_record=None, domain_status=None, enable_auto_sub_domain=None, status_reason=None, sub_domain_settings=None, update_status=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if auto_sub_domain_creation_patterns and not isinstance(auto_sub_domain_creation_patterns, list):
            raise TypeError("Expected argument 'auto_sub_domain_creation_patterns' to be a list")
        pulumi.set(__self__, "auto_sub_domain_creation_patterns", auto_sub_domain_creation_patterns)
        if auto_sub_domain_iam_role and not isinstance(auto_sub_domain_iam_role, str):
            raise TypeError("Expected argument 'auto_sub_domain_iam_role' to be a str")
        pulumi.set(__self__, "auto_sub_domain_iam_role", auto_sub_domain_iam_role)
        if certificate and not isinstance(certificate, dict):
            raise TypeError("Expected argument 'certificate' to be a dict")
        pulumi.set(__self__, "certificate", certificate)
        if certificate_record and not isinstance(certificate_record, str):
            raise TypeError("Expected argument 'certificate_record' to be a str")
        pulumi.set(__self__, "certificate_record", certificate_record)
        if domain_status and not isinstance(domain_status, str):
            raise TypeError("Expected argument 'domain_status' to be a str")
        pulumi.set(__self__, "domain_status", domain_status)
        if enable_auto_sub_domain and not isinstance(enable_auto_sub_domain, bool):
            raise TypeError("Expected argument 'enable_auto_sub_domain' to be a bool")
        pulumi.set(__self__, "enable_auto_sub_domain", enable_auto_sub_domain)
        if status_reason and not isinstance(status_reason, str):
            raise TypeError("Expected argument 'status_reason' to be a str")
        pulumi.set(__self__, "status_reason", status_reason)
        if sub_domain_settings and not isinstance(sub_domain_settings, list):
            raise TypeError("Expected argument 'sub_domain_settings' to be a list")
        pulumi.set(__self__, "sub_domain_settings", sub_domain_settings)
        if update_status and not isinstance(update_status, str):
            raise TypeError("Expected argument 'update_status' to be a str")
        pulumi.set(__self__, "update_status", update_status)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        ARN for the Domain Association.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoSubDomainCreationPatterns")
    def auto_sub_domain_creation_patterns(self) -> Optional[Sequence[builtins.str]]:
        """
        Sets the branch patterns for automatic subdomain creation.
        """
        return pulumi.get(self, "auto_sub_domain_creation_patterns")

    @property
    @pulumi.getter(name="autoSubDomainIamRole")
    def auto_sub_domain_iam_role(self) -> Optional[builtins.str]:
        """
        The required AWS Identity and Access Management (IAMlong) service role for the Amazon Resource Name (ARN) for automatically creating subdomains.
        """
        return pulumi.get(self, "auto_sub_domain_iam_role")

    @property
    @pulumi.getter
    def certificate(self) -> Optional['outputs.DomainCertificate']:
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificateRecord")
    def certificate_record(self) -> Optional[builtins.str]:
        """
        DNS Record for certificate verification.
        """
        return pulumi.get(self, "certificate_record")

    @property
    @pulumi.getter(name="domainStatus")
    def domain_status(self) -> Optional[builtins.str]:
        """
        Status for the Domain Association.
        """
        return pulumi.get(self, "domain_status")

    @property
    @pulumi.getter(name="enableAutoSubDomain")
    def enable_auto_sub_domain(self) -> Optional[builtins.bool]:
        """
        Enables the automated creation of subdomains for branches.
        """
        return pulumi.get(self, "enable_auto_sub_domain")

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[builtins.str]:
        """
        Reason for the current status of the domain.
        """
        return pulumi.get(self, "status_reason")

    @property
    @pulumi.getter(name="subDomainSettings")
    def sub_domain_settings(self) -> Optional[Sequence['outputs.DomainSubDomainSetting']]:
        """
        The setting for the subdomain.
        """
        return pulumi.get(self, "sub_domain_settings")

    @property
    @pulumi.getter(name="updateStatus")
    def update_status(self) -> Optional[builtins.str]:
        """
        The status of the domain update operation that is currently in progress. The following list describes the valid update states.

        - **REQUESTING_CERTIFICATE** - The certificate is in the process of being updated.
        - **PENDING_VERIFICATION** - Indicates that an Amplify managed certificate is in the process of being verified. This occurs during the creation of a custom domain or when a custom domain is updated to use a managed certificate.
        - **IMPORTING_CUSTOM_CERTIFICATE** - Indicates that an Amplify custom certificate is in the process of being imported. This occurs during the creation of a custom domain or when a custom domain is updated to use a custom certificate.
        - **PENDING_DEPLOYMENT** - Indicates that the subdomain or certificate changes are being propagated.
        - **AWAITING_APP_CNAME** - Amplify is waiting for CNAME records corresponding to subdomains to be propagated. If your custom domain is on Route 53, Amplify handles this for you automatically. For more information about custom domains, see [Setting up custom domains](https://docs.aws.amazon.com/amplify/latest/userguide/custom-domains.html) in the *Amplify Hosting User Guide* .
        - **UPDATE_COMPLETE** - The certificate has been associated with a domain.
        - **UPDATE_FAILED** - The certificate has failed to be provisioned or associated, and there is no existing active certificate to roll back to.
        """
        return pulumi.get(self, "update_status")


class AwaitableGetDomainResult(GetDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainResult(
            arn=self.arn,
            auto_sub_domain_creation_patterns=self.auto_sub_domain_creation_patterns,
            auto_sub_domain_iam_role=self.auto_sub_domain_iam_role,
            certificate=self.certificate,
            certificate_record=self.certificate_record,
            domain_status=self.domain_status,
            enable_auto_sub_domain=self.enable_auto_sub_domain,
            status_reason=self.status_reason,
            sub_domain_settings=self.sub_domain_settings,
            update_status=self.update_status)


def get_domain(arn: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainResult:
    """
    The AWS::Amplify::Domain resource allows you to connect a custom domain to your app.


    :param builtins.str arn: ARN for the Domain Association.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:amplify:getDomain', __args__, opts=opts, typ=GetDomainResult).value

    return AwaitableGetDomainResult(
        arn=pulumi.get(__ret__, 'arn'),
        auto_sub_domain_creation_patterns=pulumi.get(__ret__, 'auto_sub_domain_creation_patterns'),
        auto_sub_domain_iam_role=pulumi.get(__ret__, 'auto_sub_domain_iam_role'),
        certificate=pulumi.get(__ret__, 'certificate'),
        certificate_record=pulumi.get(__ret__, 'certificate_record'),
        domain_status=pulumi.get(__ret__, 'domain_status'),
        enable_auto_sub_domain=pulumi.get(__ret__, 'enable_auto_sub_domain'),
        status_reason=pulumi.get(__ret__, 'status_reason'),
        sub_domain_settings=pulumi.get(__ret__, 'sub_domain_settings'),
        update_status=pulumi.get(__ret__, 'update_status'))
def get_domain_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainResult]:
    """
    The AWS::Amplify::Domain resource allows you to connect a custom domain to your app.


    :param builtins.str arn: ARN for the Domain Association.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:amplify:getDomain', __args__, opts=opts, typ=GetDomainResult)
    return __ret__.apply(lambda __response__: GetDomainResult(
        arn=pulumi.get(__response__, 'arn'),
        auto_sub_domain_creation_patterns=pulumi.get(__response__, 'auto_sub_domain_creation_patterns'),
        auto_sub_domain_iam_role=pulumi.get(__response__, 'auto_sub_domain_iam_role'),
        certificate=pulumi.get(__response__, 'certificate'),
        certificate_record=pulumi.get(__response__, 'certificate_record'),
        domain_status=pulumi.get(__response__, 'domain_status'),
        enable_auto_sub_domain=pulumi.get(__response__, 'enable_auto_sub_domain'),
        status_reason=pulumi.get(__response__, 'status_reason'),
        sub_domain_settings=pulumi.get(__response__, 'sub_domain_settings'),
        update_status=pulumi.get(__response__, 'update_status')))
